/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.rn;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToolTip;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.rn.RelNetClusterList;
import org.tigr.microarray.mev.cluster.gui.impl.rn.RelNetSelectionDlg;
import org.tigr.microarray.mev.cluster.gui.impl.rn.RelevanceNetworkLayout;

public class RelevanceNetworkViewer
extends JPanel
implements IViewer,
Scrollable {
    private static final String ZOOM_IN_CMD = "zoom-in-cmd";
    private static final String ZOOM_OUT_CMD = "zoom-out-cmd";
    private static final String SHOW_ALL_CMD = "show-all-cmd";
    private static final String SELECT_BY_DEGREE_CMD = "select-by-degree-cmd";
    private static final String SELECT_BY_GENE_ID_CMD = "select-by-gene-id-cmd";
    private static final String LINKS_COLOR_CMD = "links-color-cmd";
    private static final String LINKS_THRESHOLD_CMD = "links-threshold-cmd";
    private static final String DESELECT_CMD = "deselect-cmd";
    private static final String SET_PUBLIC_CLUSTER_CMD = "set-public-cluster";
    private static final String RANDOM_LAYOUT_CMD = "random-layout-cmd";
    private static final String CIRCULAR_LAYOUT_CMD = "circular-layout-cmd";
    private static final String DEBUG_LAYOUT_CMD = "debug-layout-cmd";
    private static final String SET_LABEL_COLOR_CMD = "set-label-color-cmd";
    private static final String SET_SELECTION_COLOR_CMD = "set-selection-color-cmd";
    private static final String SET_BACKGROUND_COLOR_CMD = "set-background-color-cmd";
    private static final String SHAPE_RECT_CMD = "shape-rect-cmd";
    private static final String SHAPE_OVAL_CMD = "shape-oval-cmd";
    private static final String FIND_CLUSTER_CMD = "find-cluster-cmd";
    private static final String BROADCAST_NETWORK_GAGGLE_CMD = "broadcast-network-gaggle-cmd";
    private static final int SHAPE_RECT = 0;
    private static final int SHAPE_OVAL = 1;
    private static final int MAX_CONTENT_SIZE = 0x7FFFFFFE;
    private static final float ZOOM_COEFFICIENT = 2.0f;
    private Rectangle prevZoomRect = new Rectangle();
    private Experiment experiment;
    private IData data;
    private IFramework framework;
    private boolean isGenes;
    private int[][] clusters;
    private float[][] weights;
    private int[] indices;
    private float[][] coords;
    private boolean[] selected;
    private boolean[] draw;
    private float links_threshold = 0.0f;
    private boolean isLinksColor = true;
    private static final int COLORS_DEEP = 100;
    private Color[] LINKS_PALETTE = this.createPalette(Color.blue, Color.red, 100);
    private float weight_min = 0.0f;
    private float weight_scale;
    private Color selectionColor = Color.green;
    private Color labelColor = Color.black;
    private Insets insets = new Insets(10, 10, 10, 10);
    private boolean isDrawBorders;
    private boolean isAntiAliasing = true;
    private Dimension elementSize = new Dimension(20, 5);
    private int labelIndex = -1;
    private String status;
    private int shape_type = 0;
    private int exptID;
    private int subnetIndex = 0;
    private JPopupMenu popup;
    private JWindow tipWindow;

    public RelevanceNetworkViewer(boolean isGenes, Experiment experiment, int[][] clusters, float[][] weights, int[] indices) {
        this.setLayout(null);
        this.setBackground(Color.white);
        this.setFont(new Font("monospaced", 1, this.elementSize.height));
        Listener listener = new Listener();
        this.popup = this.createJPopupMenu(listener);
        this.tipWindow = this.createTipWindow();
        this.getContentComponent().addMouseListener(listener);
        this.getContentComponent().addMouseMotionListener(listener);
        this.isGenes = isGenes;
        this.experiment = experiment;
        this.clusters = clusters;
        this.weights = weights;
        this.weight_min = RelevanceNetworkViewer.getWeightsMinValue(weights);
        this.weight_scale = 100.0f / (RelevanceNetworkViewer.getWeightsMaxValue(weights) - this.weight_min);
        this.indices = indices;
        RelevanceNetworkLayout layout = new RelevanceNetworkLayout();
        this.coords = layout.doLayout(clusters, weights, 1);
        this.selected = this.createSelected(clusters);
        this.draw = new boolean[clusters.length];
        this.setPreferredSize(new Dimension(300, 300));
        this.exptID = experiment.getId();
    }

    protected void broadcastNetworkGaggle() {
        Vector<int[]> interactions = new Vector<int[]>();
        Vector<String> types = new Vector<String>();
        Vector<Boolean> directionals = new Vector<Boolean>();
        for (int i = 0; i < this.clusters.length; ++i) {
            for (int j = 0; j < this.clusters[i].length; ++j) {
                if (!(this.weights[i][j] > this.links_threshold)) continue;
                int[] thisInt = new int[]{i, this.clusters[i][j]};
                types.add("pp");
                directionals.add(false);
                interactions.add(thisInt);
            }
        }
        this.framework.broadcastNetwork(interactions, types, directionals);
    }

    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{new Boolean(this.isGenes), this.experiment, this.clusters, this.weights, this.indices});
    }

    public Color[] createPalette(Color color1, Color color2, int deep) {
        BufferedImage image = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(deep, 1);
        Graphics2D graphics = image.createGraphics();
        GradientPaint gp = new GradientPaint(0.0f, 0.0f, color1, deep - 1, 0.0f, color2);
        graphics.setPaint(gp);
        graphics.drawRect(0, 0, deep - 1, 1);
        Color[] colors = new Color[deep];
        for (int i = 0; i < deep; ++i) {
            colors[i] = new Color(image.getRGB(i, 0));
        }
        return colors;
    }

    public static float getWeightsMinValue(float[][] array) {
        if (array == null || array.length == 0) {
            return Float.NaN;
        }
        float min = Float.MAX_VALUE;
        for (int i = 0; i < array.length; ++i) {
            for (int j = 1; j < array[i].length; ++j) {
                min = Math.min(min, array[i][j]);
            }
        }
        return min;
    }

    public static float getWeightsMaxValue(float[][] array) {
        if (array == null || array.length == 0) {
            return Float.NaN;
        }
        float max = -3.4028235E38f;
        for (int i = 0; i < array.length; ++i) {
            for (int j = 1; j < array[i].length; ++j) {
                max = Math.max(max, array[i][j]);
            }
        }
        return max;
    }

    private boolean[] createSelected(int[][] cluster) {
        boolean[] selected = new boolean[cluster.length];
        this.clearSelected(selected);
        return selected;
    }

    private void clearSelected(boolean[] selected) {
        Arrays.fill(selected, false);
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    @Override
    public void paint(Graphics g1D) {
        super.paint(g1D);
        Graphics2D g = (Graphics2D)g1D;
        if (this.isAntiAliasing) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        Rectangle bounds = g.getClipBounds();
        float scale = this.getScale();
        this.drawLines(g, bounds, scale);
        this.drawLabels(g, bounds, scale);
        this.drawShapes(g, bounds, scale);
    }

    private final float getScale() {
        return Math.min(this.getPreferredSize().width - this.insets.left - this.insets.right, this.getPreferredSize().height - this.insets.top - this.insets.bottom);
    }

    private final boolean isRectIntersects(Rectangle rect, int x1, int y1, int x2, int y2) {
        if (x1 < rect.x && x2 < rect.x) {
            return false;
        }
        if (x1 > rect.x + rect.width && x2 > rect.x + rect.width) {
            return false;
        }
        if (y1 < rect.y && y2 < rect.y) {
            return false;
        }
        return y1 <= rect.y + rect.height || y2 <= rect.y + rect.height;
    }

    private final boolean isIntersectVerticalLine(Point p1, Point p2, int x, int y1, int y2, Point point) {
        if (p1.x < x && p2.x < x || p1.x > x && p2.x > x) {
            return false;
        }
        float tan = (float)(p2.y - p1.y) / (float)(p2.x - p1.x);
        float delta = tan * (float)(x - p1.x);
        float y = (float)p1.y + delta;
        point.y = p1.y + Math.round(delta);
        point.x = x;
        return y > (float)Math.min(y1, y2) && y < (float)Math.max(y1, y2);
    }

    private final boolean isIntersectHorizontalLine(Point p1, Point p2, int y, int x1, int x2, Point point) {
        if (p1.y < y && p2.y < y || p1.y > y && p2.y > y) {
            return false;
        }
        float tan = (float)(p2.y - p1.y) / (float)(p2.x - p1.x);
        float delta = (float)(y - p1.y) / tan;
        float x = (float)p1.x + delta;
        point.x = p1.x + Math.round(delta);
        point.y = y;
        return x > (float)Math.min(x1, x2) && x < (float)Math.max(x1, x2);
    }

    private final boolean isInternalPoint(Rectangle rect, Point p1, Point p2, Point n) {
        boolean p1b = rect.contains(p1);
        boolean p2b = rect.contains(p2);
        if (p1b) {
            n.setLocation(p1);
            return true;
        }
        if (p2b) {
            n.setLocation(p2);
            return true;
        }
        return false;
    }

    private final boolean isLineIntersects(Rectangle rect, Point p1, Point p2, Point n1, Point n2) {
        n1.setLocation(p1);
        n2.setLocation(p2);
        if (rect.contains(p1) && rect.contains(p2)) {
            return true;
        }
        if (p1.x < rect.x && p2.x < rect.x) {
            return false;
        }
        if (p1.y < rect.y && p2.y < rect.y) {
            return false;
        }
        if (p1.x > rect.x + rect.width && p2.x > rect.x + rect.width) {
            return false;
        }
        if (p1.y > rect.y + rect.height && p2.y > rect.y + rect.height) {
            return false;
        }
        if (p1.x == p2.x) {
            if (p1.y < rect.y) {
                n1.y = rect.y;
            } else if (p1.y > rect.y + rect.height) {
                n1.y = rect.y + rect.height;
            }
            if (p2.y < rect.y) {
                n2.y = rect.y;
            } else if (p2.y > rect.y + rect.height) {
                n2.y = rect.y + rect.height;
            }
            return true;
        }
        if (p1.y == p2.y) {
            if (p1.x < rect.x) {
                n1.x = rect.x;
            } else if (p1.x > rect.x + rect.width) {
                n1.x = rect.x + rect.width;
            }
            if (p2.x < rect.x) {
                n2.x = rect.x;
            } else if (p2.x > rect.x + rect.width) {
                n2.x = rect.x + rect.width;
            }
            return true;
        }
        if (this.isIntersectVerticalLine(p1, p2, rect.x, rect.y, rect.y + rect.height, n1)) {
            return this.isIntersectVerticalLine(p1, p2, rect.x + rect.width, rect.y, rect.y + rect.height, n2) || this.isIntersectHorizontalLine(p1, p2, rect.y, rect.x, rect.x + rect.width, n2) || this.isIntersectHorizontalLine(p1, p2, rect.y + rect.height, rect.x, rect.x + rect.width, n2) || this.isInternalPoint(rect, p1, p2, n2);
            {
            }
        }
        if (this.isIntersectVerticalLine(p1, p2, rect.x + rect.width, rect.y, rect.y + rect.height, n1)) {
            return this.isIntersectHorizontalLine(p1, p2, rect.y + rect.height, rect.x, rect.x + rect.width, n2) || this.isIntersectHorizontalLine(p1, p2, rect.y, rect.x, rect.x + rect.width, n2) || this.isInternalPoint(rect, p1, p2, n2);
            {
            }
        }
        if (this.isIntersectHorizontalLine(p1, p2, rect.y, rect.x, rect.x + rect.width, n1)) {
            return this.isIntersectHorizontalLine(p1, p2, rect.y + rect.height, rect.x, rect.x + rect.width, n2) || this.isInternalPoint(rect, p1, p2, n2);
            {
            }
        }
        if (this.isIntersectHorizontalLine(p1, p2, rect.y + rect.height, rect.x, rect.x + rect.width, n1)) {
            return this.isInternalPoint(rect, p1, p2, n2);
            {
            }
        }
        return false;
    }

    private final void drawLines(Graphics2D g, Rectangle bounds, float scale) {
        Point p1 = new Point();
        Point p2 = new Point();
        Point n1 = new Point();
        Point n2 = new Point();
        g.setColor(Color.black);
        Arrays.fill(this.draw, true);
        for (int i = 0; i < this.clusters.length; ++i) {
            if (this.clusters[i].length <= 1) continue;
            int spot_root = this.clusters[i][0];
            this.draw[spot_root] = false;
            float x1 = this.coords[spot_root][0] * scale + (float)this.insets.left;
            float y1 = this.coords[spot_root][1] * scale + (float)this.insets.top;
            for (int j = 1; j < this.clusters[i].length; ++j) {
                int spot_child;
                if (this.weights != null && this.weights[i][j] < this.links_threshold) continue;
                if (this.isLinksColor) {
                    g.setColor(this.LINKS_PALETTE[(int)((this.weights[i][j] - this.weight_min) * this.weight_scale - 0.001f)]);
                }
                if (!this.draw[spot_child = this.clusters[i][j]]) continue;
                float x2 = this.coords[spot_child][0] * scale + (float)this.insets.left;
                float y2 = this.coords[spot_child][1] * scale + (float)this.insets.top;
                p1.move((int)x1, (int)y1);
                p2.move((int)x2, (int)y2);
                if (!this.isLineIntersects(bounds, p1, p2, n1, n2)) continue;
                g.drawLine(n1.x, n1.y, n2.x, n2.y);
            }
        }
    }

    private final boolean isElementIntersects(Rectangle rect, int x, int y) {
        int X1 = x - this.elementSize.width / 2;
        int Y1 = y - this.elementSize.height / 2;
        int X2 = x + this.elementSize.width / 2;
        int Y2 = y + this.elementSize.height / 2;
        return this.isRectIntersects(rect, X1, Y1, X2, Y2);
    }

    private final void fillShape(Graphics g, int x, int y) {
        if (this.shape_type == 0) {
            g.fillRect(x, y, this.elementSize.width, this.elementSize.height);
        } else {
            g.fillOval(x, y, this.elementSize.width, this.elementSize.height);
        }
    }

    private final void drawShape(Graphics g, int x, int y) {
        this.drawShape(g, x, y, this.elementSize.width - 1, this.elementSize.height - 1);
    }

    private final void drawShape(Graphics g, int x, int y, int width, int height) {
        if (this.shape_type == 0) {
            g.drawRect(x, y, width, height);
        } else {
            g.drawOval(x, y, width, height);
        }
    }

    private final void drawNode(Graphics g, int index, int x, int y) {
        if (this.selected[index]) {
            g.setColor(this.selectionColor);
        } else {
            g.setColor(this.getProbeColor(index));
        }
        this.fillShape(g, x, y);
        if (this.isDrawBorders) {
            g.setColor(Color.black);
            this.drawShape(g, x, y);
        }
    }

    private final void drawShapes(Graphics2D g, Rectangle bounds, float scale) {
        Arrays.fill(this.draw, true);
        for (int i = 0; i < this.clusters.length; ++i) {
            if (this.clusters[i].length <= 1) continue;
            for (int j = 0; j < this.clusters[i].length; ++j) {
                int spot = this.clusters[i][j];
                if (!this.draw[spot]) continue;
                this.draw[spot] = false;
                float x = this.coords[spot][0] * scale + (float)this.insets.left;
                float y = this.coords[spot][1] * scale + (float)this.insets.top;
                if (!this.isElementIntersects(bounds, (int)x, (int)y)) continue;
                this.drawNode(g, spot, (int)x - this.elementSize.width / 2, (int)y - this.elementSize.height / 2);
            }
        }
    }

    private final void drawSpot(Graphics g, int index) {
        float scale = this.getScale();
        float x = this.coords[index][0] * scale + (float)this.insets.left;
        float y = this.coords[index][1] * scale + (float)this.insets.top;
        this.drawNode(g, index, (int)x - this.elementSize.width / 2, (int)y - this.elementSize.height / 2);
    }

    private final void drawSelectedSpot(Graphics g, int index) {
        float scale = this.getScale();
        float x = this.coords[index][0] * scale + (float)this.insets.left;
        float y = this.coords[index][1] * scale + (float)this.insets.top;
        this.drawNode(g, index, (int)x - this.elementSize.width / 2, (int)y - this.elementSize.height / 2);
        g.setColor(Color.white);
        this.drawShape(g, (int)x - this.elementSize.width / 2 + 1, (int)y - this.elementSize.height / 2 + 1, this.elementSize.width - 3, this.elementSize.height - 3);
    }

    private void onStartDrawZoom() {
        this.prevZoomRect.setBounds(0, 0, 0, 0);
    }

    private void drawZoomRect(Rectangle rect) {
        Graphics2D g = (Graphics2D)this.getGraphics();
        g.setColor(Color.black);
        g.setXORMode(this.getBackground());
        g.drawRect(this.prevZoomRect.x, this.prevZoomRect.y, this.prevZoomRect.width - 1, this.prevZoomRect.height - 1);
        this.prevZoomRect.setBounds(rect);
        g.drawRect(rect.x, rect.y, rect.width - 1, rect.height - 1);
        g.setPaintMode();
        g.dispose();
    }

    private final boolean isLabelIntersects(FontMetrics fm, Rectangle rect, String str, int x, int y) {
        int width = fm.stringWidth(str);
        int height = fm.getHeight();
        return this.isRectIntersects(rect, x, y, x + width, y + height);
    }

    private int getMaxLabelWidth() {
        if (this.isGenes && this.labelIndex < 0) {
            return 0;
        }
        Graphics2D g = (Graphics2D)this.getGraphics();
        if (this.isAntiAliasing) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        FontMetrics fm = g.getFontMetrics();
        int max = 0;
        for (int i = 0; i < this.clusters.length; ++i) {
            if (this.clusters[i].length <= 1) continue;
            for (int j = 0; j < this.clusters[i].length; ++j) {
                String str;
                String string = str = this.isGenes ? this.data.getElementAttribute(this.clusters[i][j], this.labelIndex) : this.data.getSampleName(this.clusters[i][j]);
                if (str == null) continue;
                max = Math.max(max, fm.stringWidth(str));
            }
        }
        return max;
    }

    private final void drawLabels(Graphics2D g, Rectangle bounds, float scale) {
        if (this.isGenes && this.labelIndex < 0) {
            return;
        }
        g.setColor(this.labelColor);
        FontMetrics fm = g.getFontMetrics();
        Arrays.fill(this.draw, true);
        for (int i = 0; i < this.clusters.length; ++i) {
            if (this.clusters[i].length <= 1) continue;
            for (int j = 0; j < this.clusters[i].length; ++j) {
                String str;
                int spot = this.clusters[i][j];
                if (!this.draw[spot]) continue;
                this.draw[spot] = false;
                float x = this.coords[spot][0] * scale + (float)this.insets.left + (float)(this.elementSize.width / 2) + 10.0f;
                float y = this.coords[spot][1] * scale + (float)this.insets.top + (float)(this.elementSize.height / 2);
                String string = str = this.isGenes ? this.data.getElementAttribute(this.experiment.getGeneIndexMappedToData(spot), this.labelIndex) : this.data.getSampleName(spot);
                if (!this.isLabelIntersects(fm, bounds, str, (int)x, (int)y)) continue;
                g.drawString(str, (int)x, (int)y);
            }
        }
    }

    private final Color getProbeColor(int probe) {
        Color color = this.isGenes ? this.data.getProbeColor(probe) : this.data.getExperimentColor(probe);
        return color == null ? Color.gray : color;
    }

    public JComponent getContentComponent() {
        return this;
    }

    public JComponent getHeaderComponent() {
        return null;
    }

    public void onSelected(IFramework framework) {
        this.framework = framework;
        this.data = framework.getData();
        IDisplayMenu menu = framework.getDisplayMenu();
        this.isDrawBorders = menu.isDrawingBorder();
        this.isAntiAliasing = menu.isAntiAliasing();
        this.labelIndex = menu.getLabelIndex();
        this.setElementSize(menu.getElementSize());
        this.updateSize();
    }

    public void onDataChanged(IData data) {
        this.data = data;
    }

    public void onMenuChanged(IDisplayMenu menu) {
        this.isDrawBorders = menu.isDrawingBorder();
        this.isAntiAliasing = menu.isAntiAliasing();
        this.labelIndex = menu.getLabelIndex();
        this.setElementSize(menu.getElementSize());
        this.updateSize();
    }

    private void updateSize() {
        int oldWidth = this.getPreferredSize().width - this.insets.right - this.insets.left;
        int oldHeight = this.getPreferredSize().height - this.insets.top - this.insets.bottom;
        this.insets.left = this.elementSize.width / 2 + 10;
        this.insets.right = this.getMaxLabelWidth() + this.elementSize.width / 2 + 10;
        this.insets.top = this.insets.bottom = this.elementSize.height / 2 + 10;
        this.setSizes(oldWidth + this.insets.left + this.insets.right, oldHeight + this.insets.top + this.insets.bottom);
    }

    public void onDeselected() {
    }

    public void onClosed() {
    }

    private void setElementSize(Dimension newSize) {
        if (newSize.equals(this.elementSize)) {
            return;
        }
        this.elementSize = new Dimension(newSize);
        this.setFont(new Font("monospaced", 1, newSize.height));
    }

    public BufferedImage getImage() {
        return null;
    }

    private JPopupMenu createJPopupMenu(Listener listener) {
        JPopupMenu popup = new JPopupMenu();
        this.addMenuItems(popup, listener);
        return popup;
    }

    private void addMenuItems(JPopupMenu menu, Listener listener) {
        JMenuItem menuItem = new JMenuItem("Zoom in", GUIFactory.getIcon("zoom_in.gif"));
        menuItem.setActionCommand(ZOOM_IN_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Zoom out", GUIFactory.getIcon("zoom_out.gif"));
        menuItem.setActionCommand(ZOOM_OUT_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Show all", GUIFactory.getIcon("show_all.gif"));
        menuItem.setActionCommand(SHOW_ALL_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        JMenu select_menu = new JMenu("Select");
        menuItem = new JMenuItem("Feature Degree...");
        menuItem.setActionCommand(SELECT_BY_DEGREE_CMD);
        menuItem.addActionListener(listener);
        select_menu.add(menuItem);
        menuItem = new JMenuItem("Element ID...");
        menuItem.setActionCommand(SELECT_BY_GENE_ID_CMD);
        menuItem.addActionListener(listener);
        select_menu.add(menuItem);
        menu.add(select_menu);
        JMenu links_menu = new JMenu("Links");
        menuItem = new JMenuItem("Threshold...");
        menuItem.setActionCommand(LINKS_THRESHOLD_CMD);
        menuItem.addActionListener(listener);
        links_menu.add(menuItem);
        menuItem = new JCheckBoxMenuItem("Color");
        menuItem.setSelected(true);
        menuItem.setActionCommand(LINKS_COLOR_CMD);
        menuItem.addActionListener(listener);
        links_menu.add(menuItem);
        menu.add(links_menu);
        menuItem = new JMenuItem("Deselect");
        menuItem.setActionCommand(DESELECT_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Set Public Cluster...");
        menuItem.setActionCommand(SET_PUBLIC_CLUSTER_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Find Clusters");
        menuItem.setActionCommand(FIND_CLUSTER_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        JMenu shape_menu = new JMenu("Shape");
        ButtonGroup group = new ButtonGroup();
        menuItem = new JRadioButtonMenuItem("Rectangle");
        menuItem.setSelected(true);
        menuItem.setActionCommand(SHAPE_RECT_CMD);
        menuItem.addActionListener(listener);
        shape_menu.add(menuItem);
        group.add(menuItem);
        menuItem = new JRadioButtonMenuItem("Oval");
        menuItem.setActionCommand(SHAPE_OVAL_CMD);
        menuItem.addActionListener(listener);
        shape_menu.add(menuItem);
        group.add(menuItem);
        menu.add(shape_menu);
        menu.addSeparator();
        menuItem = new JMenuItem("Set selection...");
        menuItem.setActionCommand(SET_SELECTION_COLOR_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Set labels...");
        menuItem.setActionCommand(SET_LABEL_COLOR_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Set background...");
        menuItem.setActionCommand(SET_BACKGROUND_COLOR_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Broadcast Network to Gaggle", GUIFactory.getIcon("gaggle_icon_16.gif"));
        menuItem.setActionCommand(BROADCAST_NETWORK_GAGGLE_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
    }

    private JMenuItem getJMenuItem(JPopupMenu menu, String command) {
        Component[] components = menu.getComponents();
        for (int i = 0; i < components.length; ++i) {
            JMenuItem item;
            if (components[i] instanceof JMenu && (item = this.getJMenuItem(((JMenu)components[i]).getPopupMenu(), command)) != null) {
                return item;
            }
            if (!(components[i] instanceof JMenuItem) || !((JMenuItem)components[i]).getActionCommand().equals(command)) continue;
            return (JMenuItem)components[i];
        }
        return null;
    }

    private void setEnableMenuItem(String command, boolean enable) {
        JMenuItem item = this.getJMenuItem(this.popup, command);
        if (item == null) {
            return;
        }
        item.setEnabled(enable);
    }

    private void onShowAll() {
        this.setSizes(300 + this.insets.left + this.insets.right, 300 + this.insets.top + this.insets.bottom);
        this.revalidate();
    }

    private void onZoomIn() {
        this.zoom(2.0f);
    }

    private void onZoomOut() {
        this.zoom(0.5f);
        if (this.getPreferredSize().width < this.getWidth() || this.getPreferredSize().height < this.getHeight()) {
            this.repaint();
        }
    }

    private void zoom(float coefficient) {
        int newAreaWidth = (int)((float)(this.getPreferredSize().width - this.insets.left - this.insets.right) * coefficient);
        int newAreaHeight = (int)((float)(this.getPreferredSize().height - this.insets.top - this.insets.bottom) * coefficient);
        int viewWidth = this.getParent().getWidth();
        int viewHeight = this.getParent().getHeight();
        int x = Math.abs(this.getX()) - this.insets.left + (int)((float)viewWidth * (coefficient - 1.0f) / (coefficient * 2.0f));
        int y = Math.abs(this.getY()) - this.insets.top + (int)((float)viewHeight * (coefficient - 1.0f) / (coefficient * 2.0f));
        this.setSizes(newAreaWidth + this.insets.left + this.insets.right, newAreaHeight + this.insets.top + this.insets.bottom);
        this.framework.setContentLocation((int)((float)x * coefficient + (float)this.insets.left), (int)((float)y * coefficient + (float)this.insets.top));
    }

    private void zoom(Rectangle rect) {
        if (rect == null || rect.width < 10 || rect.height < 10) {
            this.drawZoomRect(new Rectangle());
            return;
        }
        int viewWidth = this.getParent().getWidth();
        int viewHeight = this.getParent().getHeight();
        float coefficient = Math.min((float)viewWidth / (float)rect.width, (float)viewHeight / (float)rect.height);
        float width = (float)(this.getPreferredSize().width - this.insets.left - this.insets.right) * coefficient;
        float height = (float)(this.getPreferredSize().height - this.insets.top - this.insets.bottom) * coefficient;
        if (width > 2.1474836E9f || height > 2.1474836E9f) {
            this.drawZoomRect(new Rectangle());
            return;
        }
        int newAreaWidth = (int)width;
        int newAreaHeight = (int)height;
        float x = rect.x - this.insets.left;
        float y = rect.y - this.insets.top;
        this.setSizes(newAreaWidth + this.insets.left + this.insets.right, newAreaHeight + this.insets.top + this.insets.bottom);
        this.framework.setContentLocation((int)(x * coefficient + (float)this.insets.left), (int)(y * coefficient + (float)this.insets.top));
    }

    private void setSizes(int width, int height) {
        this.setSize(width, height);
        this.setPreferredSize(new Dimension(width, height));
        this.revalidate();
    }

    private void selectByDegree(String condition, int min_degree, int max_degree) {
        this.clearSelected(this.selected);
        int cond = 0;
        if (condition.equals("Equal to")) {
            cond = 1;
        } else if (condition.equals("Less than")) {
            cond = 2;
        } else if (condition.equals("Between")) {
            cond = 3;
        }
        block6: for (int i = 0; i < this.clusters.length; ++i) {
            switch (cond) {
                case 0: {
                    if (this.clusters[i].length - 1 <= max_degree) continue block6;
                    this.selected[this.clusters[i][0]] = true;
                    continue block6;
                }
                case 1: {
                    if (this.clusters[i].length - 1 != max_degree) continue block6;
                    this.selected[this.clusters[i][0]] = true;
                    continue block6;
                }
                case 2: {
                    if (this.clusters[i].length - 1 >= min_degree) continue block6;
                    this.selected[this.clusters[i][0]] = true;
                    continue block6;
                }
                case 3: {
                    int value = this.clusters[i].length - 1;
                    if (value >= max_degree || value <= min_degree) continue block6;
                    this.selected[this.clusters[i][0]] = true;
                }
            }
        }
        this.repaint();
    }

    private void selectByGeneID(String condition, String ID) {
        this.clearSelected(this.selected);
        boolean like = condition.equals("Like");
        for (int i = 0; i < this.clusters.length; ++i) {
            if (this.clusters[i].length <= 1) continue;
            for (int j = 0; j < this.clusters[i].length; ++j) {
                String str;
                String string = str = this.isGenes ? this.data.getUniqueId(this.clusters[i][j]) : this.data.getSampleName(this.clusters[i][j]);
                if (str == null) continue;
                boolean value = like ? str.indexOf(ID) != -1 : str.equals(ID);
                this.selected[this.clusters[i][j]] = value;
            }
        }
        this.repaint();
    }

    private void onSetBackgroundColor() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        Color newColor = JColorChooser.showDialog(frame, "Choose color", this.getBackground());
        if (newColor != null) {
            this.setBackground(newColor);
        }
    }

    private void setSelectionColor(Color color) {
        this.selectionColor = color;
        this.repaint();
    }

    private void setLabelColor(Color color) {
        this.labelColor = color;
        this.repaint();
    }

    private void onSetSelectionColor() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        Color newColor = JColorChooser.showDialog(frame, "Choose selection color", this.getBackground());
        if (newColor != null) {
            this.setSelectionColor(newColor);
        }
    }

    private void onSetLabelColor() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        Color newColor = JColorChooser.showDialog(frame, "Choose label color", this.getBackground());
        if (newColor != null) {
            this.setLabelColor(newColor);
        }
    }

    private void onDegreeSelection() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        RelNetSelectionDlg dialog = new RelNetSelectionDlg(frame, 0);
        if (dialog.showModal() == 0) {
            this.selectByDegree(dialog.getCondition(), dialog.getMinDegree(), dialog.getMaxDegree());
        }
    }

    private void onGeneIDSelection() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        RelNetSelectionDlg dialog = new RelNetSelectionDlg(frame, 1);
        if (dialog.showModal() == 0) {
            this.selectByGeneID(dialog.getCondition(), dialog.getGeneID());
        }
    }

    private void onLinksThreshold() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        String value = (String)JOptionPane.showInputDialog(frame, "Enter in links threshold (from 0 to 1).", "Input", 2, null, null, String.valueOf(this.links_threshold));
        if (value == null || value.equals("")) {
            return;
        }
        try {
            float threshold = Float.parseFloat(value);
            if (threshold < 0.0f || threshold > 1.0f) {
                throw new NumberFormatException("value must be between 0 and 1.");
            }
            this.links_threshold = threshold;
            this.repaint();
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(frame, "Illegal number: " + e.getMessage(), "Error", 0);
        }
    }

    private void onLinksColor() {
        JMenuItem item = this.getJMenuItem(this.popup, LINKS_COLOR_CMD);
        this.isLinksColor = item.isSelected();
        this.repaint();
    }

    private void onDeselect() {
        this.clearSelected(this.selected);
        this.repaint();
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            return this.elementSize.height;
        }
        return this.elementSize.width;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            return visibleRect.height;
        }
        return visibleRect.width;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    private int findSpot(float X, float Y, Rectangle2D.Float rect) {
        float scale = this.getScale();
        float rectWidth = (float)this.elementSize.getWidth() / scale;
        float rectHeight = (float)this.elementSize.getHeight() / scale;
        for (int i = 0; i < this.clusters.length; ++i) {
            if (this.clusters[i].length <= 1) continue;
            for (int j = 0; j < this.clusters[i].length; ++j) {
                rect.setRect(this.coords[this.clusters[i][j]][0] - rectWidth / 2.0f, this.coords[this.clusters[i][j]][1] - rectHeight / 2.0f, rectWidth, rectHeight);
                if (!rect.contains(X, Y)) continue;
                return this.clusters[i][j];
            }
        }
        return -1;
    }

    private void unselectSpot(int spotIndex) {
        this.framework.setStatusText(this.status);
        Graphics g = this.getContentComponent().getGraphics();
        this.drawSpot(g, spotIndex);
        g.dispose();
        this.hideTipWindow();
    }

    private void selectSpot(int spotIndex) {
        this.status = this.framework.getStatusText();
        if (this.isGenes) {
            this.framework.setStatusText("Gene Id: " + this.data.getUniqueId(spotIndex) + " Gene Name: " + this.data.getGeneName(spotIndex));
        } else {
            this.framework.setStatusText("Sample: " + this.data.getSampleName(spotIndex));
        }
        Graphics g = this.getContentComponent().getGraphics();
        this.drawSelectedSpot(g, spotIndex);
        g.dispose();
        this.showTipWindow(spotIndex);
    }

    private void showTipWindow(int spot) {
        if (this.isGenes && this.labelIndex < 0) {
            return;
        }
        JComponent content = this.getContentComponent();
        String text = this.isGenes ? this.data.getElementAttribute(spot, this.labelIndex) : this.data.getSampleName(spot);
        JToolTip tooltip = new JToolTip();
        tooltip.setTipText(text);
        Dimension size = tooltip.getPreferredSize();
        float scale = this.getScale();
        float x = this.coords[spot][0] * scale + (float)this.insets.left + (float)(this.elementSize.width / 2) + 10.0f;
        float y = this.coords[spot][1] * scale + (float)this.insets.top + (float)((double)this.elementSize.height - size.getHeight()) / 2.0f;
        Point screenLocation = content.getLocationOnScreen();
        this.tipWindow.getContentPane().add((Component)tooltip, "Center");
        this.tipWindow.setLocation((int)((float)screenLocation.x + x), (int)((float)screenLocation.y + y));
        this.tipWindow.pack();
        this.tipWindow.setVisible(true);
    }

    private void hideTipWindow() {
        this.tipWindow.getContentPane().removeAll();
        this.tipWindow.setVisible(false);
    }

    private JWindow createTipWindow() {
        return new JWindow(JOptionPane.getFrameForComponent(this.getContentComponent()));
    }

    private void onShapeRect() {
        this.setShapeType(0);
    }

    private void onShapeOval() {
        this.setShapeType(1);
    }

    private void setShapeType(int type) {
        this.shape_type = type;
        this.repaint();
    }

    private boolean hasSelected() {
        for (int i = 0; i < this.selected.length; ++i) {
            if (!this.selected[i]) continue;
            return true;
        }
        return false;
    }

    private void onSetPublicCluster() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        Color color = JColorChooser.showDialog(frame, "Choose color", Color.green);
        if (color == null) {
            return;
        }
        int count = 0;
        for (int i = 0; i < this.selected.length; ++i) {
            if (!this.selected[i]) continue;
            ++count;
        }
        if (count == 0) {
            return;
        }
        int[] probes = new int[count];
        int pos = 0;
        for (int i = 0; i < this.selected.length; ++i) {
            if (!this.selected[i]) continue;
            probes[pos] = i;
            ++pos;
        }
        if (this.isGenes) {
            this.data.setProbesColor(probes, color);
        } else {
            this.data.setExperimentColor(probes, color);
        }
        this.clearSelected(this.selected);
        this.repaint();
    }

    private void onFindCluster(int index) {
        ArrayList<String> info = new ArrayList<String>();
        for (int i = 0; i < this.clusters.length; ++i) {
            if (this.clusters[this.indices[i]].length <= 1) continue;
            for (int j = 0; j < this.clusters[this.indices[i]].length; ++j) {
                if (index != this.clusters[this.indices[i]][j]) continue;
                info.add(new String("Cluster " + String.valueOf(this.indices[i] + 1) + " (" + this.clusters[this.indices[i]].length + ")"));
            }
        }
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        String nodeName = this.isGenes ? this.data.getUniqueId(index) + " (" + this.data.getGeneName(index) + ")" : this.data.getSampleName(index);
        String title = "Clusters for node: " + nodeName;
        RelNetClusterList list = new RelNetClusterList(frame, title, info.toArray(new String[info.size()]));
        list.showModal();
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public JComponent getCornerComponent(int cornerIndex) {
        return null;
    }

    public void setExperiment(Experiment e) {
        this.experiment = e;
        this.exptID = e.getId();
    }

    public int getExperimentID() {
        return this.exptID;
    }

    public void setExperimentID(int i) {
        this.exptID = i;
    }

    public int[][] getClusters() {
        return this.clusters;
    }

    public Experiment getExperiment() {
        return this.experiment;
    }

    public int getViewerType() {
        if (this.isGenes) {
            return 0;
        }
        return 1;
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener,
    MouseMotionListener {
        private boolean isSpotSelected = false;
        private int spotIndex = -1;
        private Rectangle2D.Float spotRect = new Rectangle2D.Float();
        private boolean isZoomStarted = false;
        private Rectangle zoomRect = new Rectangle();
        private Point zoomPoint = new Point();

        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals(RelevanceNetworkViewer.SET_BACKGROUND_COLOR_CMD)) {
                RelevanceNetworkViewer.this.onSetBackgroundColor();
            } else if (command.equals(RelevanceNetworkViewer.SET_SELECTION_COLOR_CMD)) {
                RelevanceNetworkViewer.this.onSetSelectionColor();
            } else if (command.equals(RelevanceNetworkViewer.SET_LABEL_COLOR_CMD)) {
                RelevanceNetworkViewer.this.onSetLabelColor();
            } else if (command.equals(RelevanceNetworkViewer.ZOOM_IN_CMD)) {
                RelevanceNetworkViewer.this.onZoomIn();
            } else if (command.equals(RelevanceNetworkViewer.ZOOM_OUT_CMD)) {
                RelevanceNetworkViewer.this.onZoomOut();
            } else if (command.equals(RelevanceNetworkViewer.SHOW_ALL_CMD)) {
                RelevanceNetworkViewer.this.onShowAll();
            } else if (!(command.equals(RelevanceNetworkViewer.CIRCULAR_LAYOUT_CMD) || command.equals(RelevanceNetworkViewer.RANDOM_LAYOUT_CMD) || command.equals(RelevanceNetworkViewer.DEBUG_LAYOUT_CMD))) {
                if (command.equals(RelevanceNetworkViewer.SELECT_BY_DEGREE_CMD)) {
                    RelevanceNetworkViewer.this.onDegreeSelection();
                } else if (command.equals(RelevanceNetworkViewer.SELECT_BY_GENE_ID_CMD)) {
                    RelevanceNetworkViewer.this.onGeneIDSelection();
                } else if (command.equals(RelevanceNetworkViewer.LINKS_THRESHOLD_CMD)) {
                    RelevanceNetworkViewer.this.onLinksThreshold();
                } else if (command.equals(RelevanceNetworkViewer.LINKS_COLOR_CMD)) {
                    RelevanceNetworkViewer.this.onLinksColor();
                } else if (command.equals(RelevanceNetworkViewer.DESELECT_CMD)) {
                    RelevanceNetworkViewer.this.onDeselect();
                } else if (command.equals(RelevanceNetworkViewer.SHAPE_OVAL_CMD)) {
                    RelevanceNetworkViewer.this.onShapeOval();
                } else if (command.equals(RelevanceNetworkViewer.SHAPE_RECT_CMD)) {
                    RelevanceNetworkViewer.this.onShapeRect();
                } else if (command.equals(RelevanceNetworkViewer.SET_PUBLIC_CLUSTER_CMD)) {
                    RelevanceNetworkViewer.this.onSetPublicCluster();
                } else if (command.equals(RelevanceNetworkViewer.FIND_CLUSTER_CMD)) {
                    RelevanceNetworkViewer.this.onFindCluster(this.spotIndex);
                } else if (command.equals(RelevanceNetworkViewer.BROADCAST_NETWORK_GAGGLE_CMD)) {
                    RelevanceNetworkViewer.this.broadcastNetworkGaggle();
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                return;
            }
            if (this.isZoomStarted) {
                this.processDrawZoom(e.getX(), e.getY());
            } else {
                this.startDrawZoom(e.getX(), e.getY());
            }
        }

        private void startDrawZoom(int x, int y) {
            this.isZoomStarted = true;
            this.zoomPoint.setLocation(x, y);
            RelevanceNetworkViewer.this.onStartDrawZoom();
        }

        private void processDrawZoom(int x, int y) {
            int X = x;
            if (x > this.zoomPoint.x) {
                X = this.zoomPoint.x;
            }
            int Y = y;
            if (y > this.zoomPoint.y) {
                Y = this.zoomPoint.y;
            }
            this.zoomRect.setBounds(X, Y, Math.abs(x - this.zoomPoint.x), Math.abs(y - this.zoomPoint.y));
            RelevanceNetworkViewer.this.drawZoomRect(this.zoomRect);
        }

        private void stopDrawZoom() {
            this.isZoomStarted = false;
            RelevanceNetworkViewer.this.zoom(this.zoomRect);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (RelevanceNetworkViewer.this.popup.isVisible()) {
                return;
            }
            float scale = RelevanceNetworkViewer.this.getScale();
            float X = (float)(e.getX() - ((RelevanceNetworkViewer)RelevanceNetworkViewer.this).insets.left) / scale;
            float Y = (float)(e.getY() - ((RelevanceNetworkViewer)RelevanceNetworkViewer.this).insets.top) / scale;
            if (this.isSpotSelected) {
                if (this.spotRect.contains(X, Y)) {
                    return;
                }
                this.isSpotSelected = false;
                RelevanceNetworkViewer.this.unselectSpot(this.spotIndex);
                this.spotIndex = -1;
            }
            if ((this.spotIndex = RelevanceNetworkViewer.this.findSpot(X, Y, this.spotRect)) != -1) {
                RelevanceNetworkViewer.this.selectSpot(this.spotIndex);
                this.isSpotSelected = true;
            }
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (SwingUtilities.isRightMouseButton(event)) {
                return;
            }
            if (!event.isShiftDown() && this.isSpotSelected && RelevanceNetworkViewer.this.isGenes) {
                RelevanceNetworkViewer.this.framework.displaySlideElementInfo(0, this.spotIndex);
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if (SwingUtilities.isRightMouseButton(event)) {
                this.maybeShowPopup(event);
            } else if (this.isZoomStarted) {
                this.stopDrawZoom();
            }
        }

        private void maybeShowPopup(MouseEvent e) {
            if (!e.isPopupTrigger()) {
                return;
            }
            RelevanceNetworkViewer.this.setEnableMenuItem(RelevanceNetworkViewer.ZOOM_OUT_CMD, RelevanceNetworkViewer.this.getPreferredSize().width - ((RelevanceNetworkViewer)RelevanceNetworkViewer.this).insets.left - ((RelevanceNetworkViewer)RelevanceNetworkViewer.this).insets.right >= 300 || RelevanceNetworkViewer.this.getPreferredSize().height - ((RelevanceNetworkViewer)RelevanceNetworkViewer.this).insets.top - ((RelevanceNetworkViewer)RelevanceNetworkViewer.this).insets.bottom >= 300);
            RelevanceNetworkViewer.this.setEnableMenuItem(RelevanceNetworkViewer.ZOOM_IN_CMD, (float)Math.max(RelevanceNetworkViewer.this.getWidth() + ((RelevanceNetworkViewer)RelevanceNetworkViewer.this).insets.left + ((RelevanceNetworkViewer)RelevanceNetworkViewer.this).insets.right, RelevanceNetworkViewer.this.getHeight() + ((RelevanceNetworkViewer)RelevanceNetworkViewer.this).insets.top + ((RelevanceNetworkViewer)RelevanceNetworkViewer.this).insets.bottom) < 1.0737418E9f);
            RelevanceNetworkViewer.this.setEnableMenuItem(RelevanceNetworkViewer.SET_PUBLIC_CLUSTER_CMD, RelevanceNetworkViewer.this.hasSelected());
            RelevanceNetworkViewer.this.setEnableMenuItem(RelevanceNetworkViewer.FIND_CLUSTER_CMD, this.isSpotSelected);
            RelevanceNetworkViewer.this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }
}

