/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.rn;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import org.tigr.microarray.mev.cluster.gui.impl.rn.RelNetComparator;
import org.tigr.microarray.mev.cluster.gui.impl.util.IntSorter;

public class RelevanceNetworkLayout {
    public static final int RANDOM_LAYOUT = 0;
    public static final int CIRCULAR_LAYOUT = 1;

    public float[][] doLayout(int[][] clusters, float[][] weights, int layout) {
        switch (layout) {
            case 0: {
                return this.doRandomLayout(clusters, weights);
            }
            case 1: {
                return this.doCircularLayout(clusters, weights);
            }
        }
        return null;
    }

    private float[][] doRandomLayout(int[][] clusters, float[][] weights) {
        float[][] coords = new float[clusters.length][2];
        Random random = new Random(0L);
        for (int i = 0; i < coords.length; ++i) {
            coords[i][0] = Math.abs(random.nextFloat());
            coords[i][1] = Math.abs(random.nextFloat());
        }
        return coords;
    }

    private float[][] doCircularLayout(int[][] clusters, float[][] weights) {
        float[][] coords = new float[clusters.length][2];
        int[][] subnets = this.formRelevanceNetworks(clusters);
        int[] indices = new int[subnets.length];
        int i = indices.length;
        while (--i >= 0) {
            indices[i] = i;
        }
        IntSorter.sort(indices, new RelNetComparator(subnets));
        int x_size = (int)Math.ceil(Math.sqrt(subnets.length));
        int y_size = (int)Math.ceil((float)subnets.length / (float)x_size);
        for (int y = 0; y < y_size; ++y) {
            int subnet;
            for (int x = 0; x < x_size && (subnet = y * x_size + x) < subnets.length; ++x) {
                this.arrangeGraph(subnets[indices[subnet]], coords, x, y);
            }
        }
        this.normalize(coords, clusters);
        return coords;
    }

    private void arrangeGraph(int[] subnet, float[][] coords, int x, int y) {
        for (int i = 0; i < subnet.length; ++i) {
            coords[subnet[i]][0] = (float)(Math.cos(Math.PI * 2 * (double)i / (double)subnet.length) + 2.5 * (double)(x + 1) - 1.5);
            coords[subnet[i]][1] = (float)(Math.sin(Math.PI * 2 * (double)i / (double)subnet.length) + 2.5 * (double)(y + 1) - 1.5);
        }
    }

    private void normalize(float[][] coords, int[][] clusters) {
        int j;
        int i;
        float max = 0.0f;
        float minX = Float.MAX_VALUE;
        float minY = Float.MAX_VALUE;
        for (i = 0; i < clusters.length; ++i) {
            if (clusters[i].length <= 1) continue;
            for (j = 0; j < clusters[i].length; ++j) {
                minX = Math.min(minX, coords[clusters[i][j]][0]);
                minY = Math.min(minY, coords[clusters[i][j]][1]);
            }
        }
        for (i = 0; i < coords.length; ++i) {
            coords[i][0] = coords[i][0] - minX;
            coords[i][1] = coords[i][1] - minY;
        }
        for (i = 0; i < clusters.length; ++i) {
            if (clusters[i].length <= 1) continue;
            for (j = 0; j < clusters[i].length; ++j) {
                max = Math.max(max, Math.max(coords[clusters[i][j]][0], coords[clusters[i][j]][1]));
            }
        }
        for (i = 0; i < coords.length; ++i) {
            coords[i][0] = coords[i][0] / max;
            coords[i][1] = coords[i][1] / max;
        }
    }

    public int[][] formRelevanceNetworks(int[][] clusters) {
        int size = clusters.length;
        boolean[] visited = new boolean[size];
        Arrays.fill(visited, false);
        ArrayList<ArrayList> subnets = new ArrayList<ArrayList>();
        for (int node = 0; node < size; ++node) {
            if (visited[node]) continue;
            subnets.add(this.fillSubnet(new ArrayList(), node, visited, clusters));
        }
        int subnets_size = subnets.size();
        int number_of_subnets = 0;
        for (int i = 0; i < subnets_size; ++i) {
            if (((ArrayList)subnets.get(i)).size() <= 1) continue;
            ++number_of_subnets;
        }
        int[][] result = new int[number_of_subnets][];
        int subnet_pos = 0;
        for (int i = 0; i < subnets_size; ++i) {
            ArrayList subnet = (ArrayList)subnets.get(i);
            if (subnet.size() <= 1) continue;
            result[subnet_pos] = new int[subnet.size()];
            for (int j = 0; j < result[subnet_pos].length; ++j) {
                result[subnet_pos][j] = (Integer)subnet.get(j);
            }
            ++subnet_pos;
        }
        return result;
    }

    private ArrayList fillSubnet(ArrayList subnet, int root, boolean[] visited, int[][] clusters) {
        subnet.add(new Integer(root));
        visited[root] = true;
        int[] cluster = clusters[root];
        for (int i = 1; i < cluster.length; ++i) {
            int node = cluster[i];
            if (visited[node]) continue;
            this.fillSubnet(subnet, node, visited, clusters);
        }
        return subnet;
    }
}

