/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.rn;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;

public class RelNetSelectionDlg
extends JDialog {
    public static final int DEGREE_TYPE = 0;
    public static final int GENEID_TYPE = 1;
    public static final String CONDITION_GREATER_THAN = "Greater than";
    public static final String CONDITION_EQUAL_TO = "Equal to";
    public static final String CONDITION_LESS_THAN = "Less than";
    public static final String CONDITION_LIKE = "Like";
    public static final String CONDITION_BETWEEN = "Between";
    private int result;
    private int type;
    private JComboBox conditionCombo;
    private JPanel degreePanel;
    private JComboBox degreeCombo_1;
    private JComboBox degreeCombo_2;
    private JTextField geneidField;

    public RelNetSelectionDlg(Frame frame, int type) {
        super(frame, "Select Nodes", true);
        this.type = type;
        Listener listener = new Listener();
        this.degreeCombo_1 = this.createDegreeCombo_1();
        this.degreeCombo_2 = this.createDegreeCombo_2();
        JPanel selectionPanel = this.createSelectionPanel(listener, type);
        JPanel btnsPanel = this.createBtnsPanel(listener);
        Container content = this.getContentPane();
        content.setLayout(new GridBagLayout());
        content.add((Component)selectionPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        content.add((Component)btnsPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(4, 8, 4, 8), 0, 0));
        this.addWindowListener(listener);
        this.pack();
    }

    private JPanel createSelectionPanel(ActionListener listener, int type) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new BevelBorder(0));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        panel.add((Component)new JLabel("Condition:"), gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        switch (type) {
            case 0: {
                panel.add((Component)new JLabel("Degree:"), gbc);
                break;
            }
            case 1: {
                panel.add((Component)new JLabel("Element ID:"), gbc);
            }
        }
        this.conditionCombo = this.createConditionCombo(listener, type);
        gbc.anchor = 10;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 0;
        panel.add((Component)this.conditionCombo, gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        switch (type) {
            case 0: {
                this.degreePanel = this.createDegreePanel();
                panel.add((Component)this.degreePanel, gbc);
                break;
            }
            case 1: {
                this.geneidField = new JTextField();
                panel.add((Component)this.geneidField, gbc);
            }
        }
        return panel;
    }

    private JComboBox createConditionCombo(ActionListener listener, int type) {
        JComboBox<String> combo = new JComboBox<String>();
        switch (type) {
            case 0: {
                combo.addItem(CONDITION_GREATER_THAN);
                combo.addItem(CONDITION_EQUAL_TO);
                combo.addItem(CONDITION_LESS_THAN);
                combo.addItem(CONDITION_BETWEEN);
                break;
            }
            case 1: {
                combo.addItem(CONDITION_EQUAL_TO);
                combo.addItem(CONDITION_LIKE);
            }
        }
        combo.setActionCommand("condition-changed");
        combo.addActionListener(listener);
        return combo;
    }

    private JComboBox createDegreeCombo_1() {
        JComboBox<String> combo = new JComboBox<String>();
        combo.setEditable(true);
        for (int i = 0; i < 10; ++i) {
            combo.addItem(String.valueOf(i));
        }
        return combo;
    }

    private JComboBox createDegreeCombo_2() {
        JComboBox<String> combo = new JComboBox<String>();
        combo.setEditable(true);
        int i = 10;
        while (--i >= 0) {
            combo.addItem(String.valueOf(i));
        }
        return combo;
    }

    private JPanel createDegreePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        panel.add((Component)this.degreeCombo_1, gbc);
        return panel;
    }

    private void updateDegreePanel(boolean two_combo) {
        this.degreePanel.removeAll();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        if (two_combo) {
            gbc.gridy = 0;
            gbc.gridx = 0;
            gbc.weightx = 0.5;
            this.degreePanel.add((Component)this.degreeCombo_1, gbc);
            gbc.gridx = 1;
            gbc.insets.left = 5;
            this.degreePanel.add((Component)this.degreeCombo_2, gbc);
        } else {
            gbc.weightx = 1.0;
            this.degreePanel.add((Component)this.degreeCombo_1, gbc);
        }
        this.degreePanel.validate();
        this.degreePanel.repaint();
    }

    private JPanel createBtnsPanel(ActionListener listener) {
        GridLayout gridLayout = new GridLayout();
        JPanel panel = new JPanel(gridLayout);
        JButton okButton = new JButton("OK");
        okButton.setActionCommand("ok-command");
        okButton.addActionListener(listener);
        panel.add(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setActionCommand("cancel-command");
        cancelButton.addActionListener(listener);
        gridLayout.setHgap(4);
        panel.add(cancelButton);
        this.getRootPane().setDefaultButton(okButton);
        return panel;
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public String getCondition() {
        return (String)this.conditionCombo.getSelectedItem();
    }

    public String getGeneID() {
        return this.geneidField.getText();
    }

    private int getDegree() {
        return Integer.parseInt((String)this.degreeCombo_1.getSelectedItem());
    }

    public int getMinDegree() {
        if (!this.getCondition().equals(CONDITION_BETWEEN)) {
            return this.getDegree();
        }
        return Math.min(Integer.parseInt((String)this.degreeCombo_1.getSelectedItem()), Integer.parseInt((String)this.degreeCombo_2.getSelectedItem()));
    }

    public int getMaxDegree() {
        if (!this.getCondition().equals(CONDITION_BETWEEN)) {
            return this.getDegree();
        }
        return Math.max(Integer.parseInt((String)this.degreeCombo_1.getSelectedItem()), Integer.parseInt((String)this.degreeCombo_2.getSelectedItem()));
    }

    private void onConditionChanged() {
        if (this.type == 0) {
            if (this.getCondition().equals(CONDITION_BETWEEN)) {
                this.updateDegreePanel(true);
            } else {
                this.updateDegreePanel(false);
            }
        }
    }

    private class Listener
    extends DialogListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("ok-command")) {
                try {
                    switch (RelNetSelectionDlg.this.type) {
                        case 0: {
                            Integer.parseInt((String)RelNetSelectionDlg.this.degreeCombo_1.getSelectedItem());
                            if (!RelNetSelectionDlg.this.getCondition().equals(RelNetSelectionDlg.CONDITION_BETWEEN)) break;
                            Integer.parseInt((String)RelNetSelectionDlg.this.degreeCombo_2.getSelectedItem());
                        }
                    }
                    RelNetSelectionDlg.this.result = 0;
                }
                catch (Exception exception) {
                    RelNetSelectionDlg.this.result = 2;
                }
                RelNetSelectionDlg.this.dispose();
            } else if (command.equals("cancel-command")) {
                RelNetSelectionDlg.this.result = 2;
                RelNetSelectionDlg.this.dispose();
            } else if (command.equals("condition-changed")) {
                RelNetSelectionDlg.this.onConditionChanged();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            RelNetSelectionDlg.this.result = -1;
            RelNetSelectionDlg.this.dispose();
        }
    }
}

