/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.rn;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.SampleSelectionPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class RelNetInitDialog
extends AlgorithmDialog {
    private int result;
    private JCheckBox usePermutationBox;
    private JTextField minThresholdField;
    private JTextField maxThresholdField;
    private JTextField entropyField;
    private JCheckBox useEntropyBox;
    private SampleSelectionPanel sampleSelectionPanel;

    public RelNetInitDialog(Frame parent) {
        super(parent, "RN: Relevance Networks", true);
        Listener listener = new Listener();
        this.addWindowListener(listener);
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new GridBagLayout());
        this.sampleSelectionPanel = new SampleSelectionPanel(Color.white, UIManager.getColor("Label.foreground"), true, "Sample Selection");
        ParameterPanel parameters = new ParameterPanel();
        parameters.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        this.usePermutationBox = new JCheckBox("Use Permutation Test");
        this.usePermutationBox.setFocusPainted(false);
        this.usePermutationBox.setBackground(Color.white);
        this.usePermutationBox.setForeground(UIManager.getColor("Label.foreground"));
        this.usePermutationBox.setActionCommand("permutation-command");
        this.usePermutationBox.addActionListener(listener);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.insets.bottom = 5;
        parameters.add((Component)this.usePermutationBox, gbc);
        gbc.gridwidth = 1;
        gbc.gridy = 1;
        gbc.insets.bottom = 5;
        parameters.add((Component)new JLabel("Min Threshold:"), gbc);
        gbc.gridy = 2;
        parameters.add((Component)new JLabel("Max Threshold:"), gbc);
        gbc.gridy = 3;
        this.useEntropyBox = new JCheckBox("Use Filter, %");
        this.useEntropyBox.setFocusPainted(false);
        this.useEntropyBox.setBackground(Color.white);
        this.useEntropyBox.setForeground(UIManager.getColor("Label.foreground"));
        this.useEntropyBox.setActionCommand("entropy-command");
        this.useEntropyBox.addActionListener(listener);
        parameters.add((Component)this.useEntropyBox, gbc);
        this.minThresholdField = new JTextField(String.valueOf(0.97f), 5);
        this.maxThresholdField = new JTextField(String.valueOf(1.0f), 5);
        this.entropyField = new JTextField("95", 5);
        this.entropyField.setEnabled(false);
        gbc.insets = new Insets(0, 10, 5, 0);
        gbc.gridx = 1;
        gbc.gridy = 1;
        parameters.add((Component)this.minThresholdField, gbc);
        gbc.gridy = 2;
        parameters.add((Component)this.maxThresholdField, gbc);
        gbc.gridy = 3;
        parameters.add((Component)this.entropyField, gbc);
        contentPanel.add((Component)this.sampleSelectionPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        contentPanel.add((Component)parameters, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setActionListeners(listener);
        this.addContent(contentPanel);
        this.pack();
        this.setResizable(false);
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public boolean usePermutation() {
        return this.usePermutationBox.isSelected();
    }

    public float getMinThreshold() {
        return Float.parseFloat(this.minThresholdField.getText());
    }

    public float getMaxThreshold() {
        return Float.parseFloat(this.maxThresholdField.getText());
    }

    public boolean useEntropy() {
        return this.useEntropyBox.isSelected();
    }

    public float getEntropy() {
        if (this.useEntropy()) {
            return Float.parseFloat(this.entropyField.getText());
        }
        return 0.0f;
    }

    public boolean isClusterGenes() {
        return this.sampleSelectionPanel.isClusterGenesSelected();
    }

    private void resetControls() {
        this.sampleSelectionPanel.setClusterGenesSelected(true);
        this.useEntropyBox.setSelected(false);
        this.usePermutationBox.setSelected(false);
        this.entropyField.setText("95");
        this.entropyField.setEnabled(false);
        this.maxThresholdField.setText(String.valueOf(1.0f));
        this.minThresholdField.setText(String.valueOf(0.97f));
        this.minThresholdField.setEnabled(true);
    }

    private boolean validInput(float min, float max, float entropy) {
        boolean valid = true;
        if (!this.usePermutationBox.isSelected() && (min <= 0.0f || (double)min > 1.0)) {
            JOptionPane.showMessageDialog(this, "Min. Treshold must be > 0 and <= 1.0", "Input Error!", 0);
            this.minThresholdField.requestFocus();
            this.minThresholdField.selectAll();
            valid = false;
        } else if (max <= 0.0f || (double)max > 1.0) {
            JOptionPane.showMessageDialog(this, "Max. Treshold must be > 0 and <= 1.0", "Input Error!", 0);
            this.maxThresholdField.requestFocus();
            this.maxThresholdField.selectAll();
            valid = false;
        } else if (max <= min) {
            JOptionPane.showMessageDialog(this, "Max. threshold must be > Min. threshold", "Input Error!", 0);
            valid = false;
        } else if (this.useEntropy() && (entropy <= 0.0f || entropy > 100.0f)) {
            JOptionPane.showMessageDialog(this, "Entropy must be > 0 and <= 100", "Input Error!", 0);
            this.entropyField.requestFocus();
            this.entropyField.selectAll();
            valid = false;
        }
        return valid;
    }

    public static void main(String[] args) {
        RelNetInitDialog dlg = new RelNetInitDialog(new JFrame());
        if (dlg.showModal() == 0) {
            System.out.println("ok");
        }
        System.exit(0);
    }

    private class Listener
    extends DialogListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            block19: {
                String command = e.getActionCommand();
                if (command.equals("ok-command")) {
                    int progress = 0;
                    float entropy = 0.0f;
                    try {
                        float min = Float.parseFloat(RelNetInitDialog.this.minThresholdField.getText());
                        ++progress;
                        float max = Float.parseFloat(RelNetInitDialog.this.maxThresholdField.getText());
                        ++progress;
                        if (RelNetInitDialog.this.useEntropy()) {
                            entropy = Float.parseFloat(RelNetInitDialog.this.entropyField.getText());
                            ++progress;
                        }
                        if (RelNetInitDialog.this.validInput(min, max, entropy)) {
                            RelNetInitDialog.this.result = 0;
                            RelNetInitDialog.this.dispose();
                        }
                        break block19;
                    }
                    catch (NumberFormatException nfe) {
                        JOptionPane.showMessageDialog(RelNetInitDialog.this, "Not a number: " + nfe.getMessage(), "Input Error!", 0);
                        if (progress == 0) {
                            RelNetInitDialog.this.minThresholdField.requestFocus();
                            RelNetInitDialog.this.minThresholdField.selectAll();
                        } else if (progress == 1) {
                            RelNetInitDialog.this.maxThresholdField.requestFocus();
                            RelNetInitDialog.this.maxThresholdField.selectAll();
                        } else if (progress == 2) {
                            RelNetInitDialog.this.entropyField.requestFocus();
                            RelNetInitDialog.this.entropyField.selectAll();
                        }
                        break block19;
                    }
                }
                if (command.equals("cancel-command")) {
                    RelNetInitDialog.this.result = 2;
                    RelNetInitDialog.this.dispose();
                } else if (command.equals("entropy-command")) {
                    RelNetInitDialog.this.entropyField.setEnabled(((AbstractButton)e.getSource()).isSelected());
                } else if (command.equals("permutation-command")) {
                    RelNetInitDialog.this.minThresholdField.setEnabled(!((AbstractButton)e.getSource()).isSelected());
                } else if (command.equals("reset-command")) {
                    RelNetInitDialog.this.resetControls();
                } else if (command.equals("info-command")) {
                    HelpWindow.launchBrowser(RelNetInitDialog.this, "RN Initialization Dialog");
                }
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            RelNetInitDialog.this.result = -1;
            RelNetInitDialog.this.dispose();
        }
    }
}

