/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.rn;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;

public class RNSubnetInfoViewer
extends ViewerAdapter
implements Serializable {
    public static final long serialVersionUID = 202014070001L;
    private JComponent header;
    private JTextArea content;
    private boolean clusterGenes;
    private int[] orderedIndices;

    public RNSubnetInfoViewer(int[][] clusters, int genes) {
        this.header = this.createHeader();
        this.clusterGenes = true;
        this.content = this.createContent(clusters, genes);
        this.setMaxWidth(this.content, this.header);
    }

    public RNSubnetInfoViewer(JTextArea content, JComponent header) {
        this.content = content;
        this.clusterGenes = true;
        this.header = header;
        this.setMaxWidth(content, header);
    }

    public RNSubnetInfoViewer(int[][] clusters, int[] orderedIndices, int genes, boolean clusterGenes) {
        this.orderedIndices = orderedIndices;
        this.header = this.createHeader();
        this.clusterGenes = clusterGenes;
        this.content = this.createContent(clusters, genes);
        this.setMaxWidth(this.content, this.header);
    }

    @Override
    public JComponent getContentComponent() {
        return this.content;
    }

    @Override
    public JComponent getHeaderComponent() {
        return this.header;
    }

    private JComponent createHeader() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBackground(Color.white);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(10, 0, 10, 0);
        panel.add((Component)new JLabel("<html><body bgcolor='#FFFFFF'><font face='serif' size='5' color='#000080'><b>Subnet Information</b></font></body></html>"), gbc);
        return panel;
    }

    private JTextArea createContent(int[][] clusters, int genes) {
        int counter;
        JTextArea area = new JTextArea();
        area.setEditable(false);
        area.setMargin(new Insets(0, 10, 0, 0));
        StringBuffer sb = new StringBuffer(clusters.length * 6 * 25);
        int stringLength = 0;
        String dummy = "";
        if (this.clusterGenes) {
            for (counter = 0; counter < clusters.length; ++counter) {
                dummy = "";
                if (clusters[this.orderedIndices[counter]].length <= 1) continue;
                dummy = dummy + "Subnet " + (counter + 1);
                dummy = dummy + "\t";
                dummy = dummy + "# of Genes in Subnet: " + clusters[this.orderedIndices[counter]].length;
                dummy = dummy + "\n\t";
                dummy = dummy + "% of Genes in Subnet: " + Math.round((float)clusters[this.orderedIndices[counter]].length / (float)genes * 100.0f) + "%";
                dummy = dummy + "\n\n";
                sb.append(dummy);
                stringLength += dummy.length();
            }
        } else {
            for (counter = 0; counter < clusters.length; ++counter) {
                dummy = "";
                if (clusters[this.orderedIndices[counter]].length <= 1) continue;
                dummy = dummy + "Subnet " + (counter + 1);
                dummy = dummy + "\t";
                dummy = dummy + "# of Experiments in Subnet: " + clusters[this.orderedIndices[counter]].length;
                dummy = dummy + "\n\t";
                dummy = dummy + "% of Experiments in Subnet: " + Math.round((float)clusters[this.orderedIndices[counter]].length / (float)genes * 100.0f) + "%";
                dummy = dummy + "\n\n";
                sb.append(dummy);
                stringLength += dummy.length();
            }
        }
        String str = sb.substring(0, stringLength);
        area.setText(str);
        area.setCaretPosition(0);
        return area;
    }

    private void setMaxWidth(JComponent content, JComponent header) {
        int c_width = content.getPreferredSize().width;
        int h_width = header.getPreferredSize().width;
        if (c_width > h_width) {
            header.setPreferredSize(new Dimension(c_width, header.getPreferredSize().height));
        } else {
            content.setPreferredSize(new Dimension(h_width, content.getPreferredSize().height));
        }
    }

    @Override
    public JComponent getRowHeaderComponent() {
        return null;
    }
}

