/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.rn;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.cluster.gui.impl.rn.RNCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.rn.RNCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.rn.RNElementSeedInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.rn.RNExperimentCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.rn.RNExperimentCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.rn.RNSubnetInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.rn.RelNetComparator;
import org.tigr.microarray.mev.cluster.gui.impl.rn.RelNetExperimentClusterViewer;
import org.tigr.microarray.mev.cluster.gui.impl.rn.RelNetExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.rn.RelNetInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.rn.RelevanceNetworkLayout;
import org.tigr.microarray.mev.cluster.gui.impl.rn.RelevanceNetworkViewer;
import org.tigr.microarray.mev.cluster.gui.impl.util.IntSorter;
import org.tigr.microarray.mev.script.scriptGUI.IScriptGUI;
import org.tigr.util.FloatMatrix;

public class RNGUI
implements IClusterGUI,
IScriptGUI {
    private Algorithm algorithm;
    private Progress progress;
    private FloatMatrix means;
    private FloatMatrix variances;
    private IData data;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework framework) throws AlgorithmException {
        RelNetInitDialog dlg = new RelNetInitDialog(framework.getFrame());
        if (dlg.showModal() != 0) {
            return null;
        }
        boolean use_permutation = dlg.usePermutation();
        float min_threshold = dlg.getMinThreshold();
        float max_threshold = dlg.getMaxThreshold();
        boolean use_entropy = dlg.useEntropy();
        float entropy = use_entropy ? dlg.getEntropy() : 100.0f;
        boolean clusterGenes = dlg.isClusterGenes();
        this.data = framework.getData();
        Listener listener = new Listener();
        try {
            this.algorithm = framework.getAlgorithmFactory().getAlgorithm("RN");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            this.progress = new Progress(framework.getFrame(), "Calculating Relevance Network", listener);
            this.progress.show();
            AlgorithmData data = new AlgorithmData();
            Experiment experiment = framework.getData().getExperiment();
            data.addMatrix("experiment", clusterGenes ? experiment.getMatrix() : experiment.getMatrix().transpose());
            data.addParam("distance-factor", String.valueOf(1.0f));
            IDistanceMenu menu = framework.getDistanceMenu();
            data.addParam("distance-absolute", String.valueOf(true));
            int function = 1;
            data.addParam("distance-function", String.valueOf(function));
            data.addParam("use-permutation", String.valueOf(use_permutation));
            data.addParam("min-threshold", String.valueOf(min_threshold));
            data.addParam("max-threshold", String.valueOf(max_threshold));
            data.addParam("filter-by-entropy", String.valueOf(use_entropy));
            data.addParam("top-n-percent", String.valueOf(entropy));
            data.addParam("threshold", String.valueOf(min_threshold));
            long start = System.currentTimeMillis();
            AlgorithmData result = this.algorithm.execute(data);
            long time = System.currentTimeMillis() - start;
            int[][] clusters = this.convert2int(result.getCluster("cluster"));
            float[][] weights = this.convert2float(result.getCluster("weights"));
            this.means = result.getMatrix("means");
            this.variances = result.getMatrix("variances");
            AlgorithmParameters params = result.getParams();
            result = null;
            int[] indices = this.getSortedIndices(clusters);
            GeneralInfo info = new GeneralInfo();
            info.time = time;
            info.links = params.getInt("links", 0);
            info.min_threshold = params.getFloat("min_threshold");
            info.max_threshold = max_threshold;
            info.entropy = entropy;
            info.function = menu.getFunctionName(function);
            info.absolute = true;
            RelevanceNetworkLayout layout = new RelevanceNetworkLayout();
            if (layout.formRelevanceNetworks(clusters).length < 1) {
                DefaultMutableTreeNode defaultMutableTreeNode = this.createEmptyResultTree(info);
                return defaultMutableTreeNode;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(experiment, clusters, weights, indices, info, clusterGenes);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
        }
    }

    protected DefaultMutableTreeNode createEmptyResultTree(GeneralInfo info) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("RelNet - no Results");
        root.add(new DefaultMutableTreeNode("No Results"));
        this.addGeneralInfo(root, info);
        return root;
    }

    public AlgorithmData getScriptParameters(IFramework framework) {
        RelNetInitDialog dlg = new RelNetInitDialog(framework.getFrame());
        if (dlg.showModal() != 0) {
            return null;
        }
        boolean use_permutation = dlg.usePermutation();
        float min_threshold = dlg.getMinThreshold();
        float max_threshold = dlg.getMaxThreshold();
        boolean use_entropy = dlg.useEntropy();
        float entropy = use_entropy ? dlg.getEntropy() : 100.0f;
        boolean clusterGenes = dlg.isClusterGenes();
        this.data = framework.getData();
        AlgorithmData data = new AlgorithmData();
        Experiment experiment = framework.getData().getExperiment();
        data.addParam("rn-cluster-genes", String.valueOf(clusterGenes));
        data.addParam("distance-factor", String.valueOf(1.0f));
        IDistanceMenu menu = framework.getDistanceMenu();
        data.addParam("distance-absolute", String.valueOf(true));
        int function = 1;
        data.addParam("distance-function", String.valueOf(function));
        data.addParam("use-permutation", String.valueOf(use_permutation));
        data.addParam("min-threshold", String.valueOf(min_threshold));
        data.addParam("max-threshold", String.valueOf(max_threshold));
        data.addParam("filter-by-entropy", String.valueOf(use_entropy));
        data.addParam("top-n-percent", String.valueOf(entropy));
        data.addParam("threshold", String.valueOf(min_threshold));
        data.addParam("name", "RN");
        if (clusterGenes) {
            data.addParam("alg-type", "cluster-genes");
        } else {
            data.addParam("alg-type", "cluster-experiments");
        }
        if (clusterGenes) {
            data.addParam("output-class", "multi-gene-cluster-output");
        } else {
            data.addParam("output-class", "multi-experiment-cluster-output");
        }
        String[] outputNodes = new String[]{"Multi-cluster"};
        data.addStringArray("output-nodes", outputNodes);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode executeScript(IFramework framework, AlgorithmData algData, Experiment experiment) throws AlgorithmException {
        boolean clusterGenes = algData.getParams().getBoolean("rn-cluster-genes");
        System.out.println("cluster genes = " + clusterGenes);
        this.data = framework.getData();
        Listener listener = new Listener();
        try {
            this.algorithm = framework.getAlgorithmFactory().getAlgorithm("RN");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            this.progress = new Progress(framework.getFrame(), "Calculating Relevance Network", listener);
            this.progress.show();
            algData.addMatrix("experiment", clusterGenes ? experiment.getMatrix() : experiment.getMatrix().transpose());
            IDistanceMenu menu = framework.getDistanceMenu();
            int function = 1;
            long start = System.currentTimeMillis();
            AlgorithmData result = this.algorithm.execute(algData);
            long time = System.currentTimeMillis() - start;
            int[][] clusters = this.convert2int(result.getCluster("cluster"));
            float[][] weights = this.convert2float(result.getCluster("weights"));
            this.means = result.getMatrix("means");
            this.variances = result.getMatrix("variances");
            AlgorithmParameters params = result.getParams();
            result = null;
            int[] indices = this.getSortedIndices(clusters);
            System.out.println("cluster length =" + clusters.length);
            AlgorithmParameters algDataParams = algData.getParams();
            function = algDataParams.getInt("distance-function");
            GeneralInfo info = new GeneralInfo();
            info.time = time;
            info.links = params.getInt("links", 0);
            info.min_threshold = algDataParams.getFloat("min-threshold");
            info.max_threshold = algDataParams.getFloat("max-threshold");
            info.entropy = algDataParams.getFloat("top-n-percent");
            info.function = menu.getFunctionName(function);
            info.absolute = true;
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(experiment, clusters, weights, indices, info, clusterGenes);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
        }
    }

    private int[][] convert2int(Cluster cluster) throws AlgorithmException {
        NodeList nodeList = cluster.getNodeList();
        int nodeListSize = nodeList.getSize();
        int[][] result = new int[nodeListSize][];
        for (int i = 0; i < nodeListSize; ++i) {
            result[i] = nodeList.getNode(i).getFeaturesIndexes();
            if (result[i] != null) continue;
            throw new AlgorithmException("Cluster " + i + " does not contain indices.");
        }
        return result;
    }

    private static float[] int2float(int[] ints) {
        if (ints == null) {
            return null;
        }
        float[] floats = new float[ints.length];
        for (int i = 0; i < floats.length; ++i) {
            floats[i] = Float.intBitsToFloat(ints[i]);
        }
        return floats;
    }

    private float[][] convert2float(Cluster cluster) {
        if (cluster == null) {
            return null;
        }
        NodeList nodeList = cluster.getNodeList();
        float[][] result = new float[nodeList.getSize()][];
        for (int i = 0; i < nodeList.getSize(); ++i) {
            result[i] = RNGUI.int2float(nodeList.getNode(i).getFeaturesIndexes());
        }
        return result;
    }

    private int[] getSortedIndices(int[][] clusters) {
        int[] indices = new int[clusters.length];
        int i = indices.length;
        while (--i >= 0) {
            indices[i] = i;
        }
        IntSorter.sort(indices, new RelNetComparator(clusters));
        return indices;
    }

    private DefaultMutableTreeNode createResultTree(Experiment experiment, int[][] clusters, float[][] weights, int[] indices, GeneralInfo info, boolean clusterGenes) {
        DefaultMutableTreeNode root = clusterGenes ? new DefaultMutableTreeNode("RelNet - genes") : new DefaultMutableTreeNode("RelNet - samples");
        this.addResultNodes(root, experiment, clusters, weights, indices, info, clusterGenes);
        return root;
    }

    private void addResultNodes(DefaultMutableTreeNode root, Experiment experiment, int[][] clusters, float[][] weights, int[] indices, GeneralInfo info, boolean clusterGenes) {
        DefaultMutableTreeNode elementClusterNode = new DefaultMutableTreeNode("Element Seed Clusters");
        this.addExpressionImages(elementClusterNode, experiment, clusters, indices, clusterGenes);
        this.addCentroidViews(elementClusterNode, experiment, clusters, indices, clusterGenes);
        this.addTableViews(elementClusterNode, experiment, clusters, indices, clusterGenes);
        this.addElementClusterInfo(elementClusterNode, experiment, clusters, indices, clusterGenes);
        DefaultMutableTreeNode subnetNode = new DefaultMutableTreeNode("Subnets");
        this.addSubnets(subnetNode, experiment, clusters, clusterGenes);
        this.addRelevanceNetworkViewer(root, experiment, clusters, weights, indices, clusterGenes);
        root.add(elementClusterNode);
        root.add(subnetNode);
        this.addGeneralInfo(root, info);
    }

    private void addElementClusterInfo(DefaultMutableTreeNode root, Experiment experiment, int[][] clusters, int[] orderedIndices, boolean clusterGenes) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Cluster Information");
        if (clusterGenes) {
            node.add(new DefaultMutableTreeNode(new LeafInfo("Genes in Clusters (#,%)", (IViewer)new RNElementSeedInfoViewer(clusters, experiment, orderedIndices, experiment.getNumberOfGenes(), true))));
        } else {
            node.add(new DefaultMutableTreeNode(new LeafInfo("Samples in Clusters (#,%)", (IViewer)new RNElementSeedInfoViewer(clusters, experiment, orderedIndices, experiment.getNumberOfSamples(), false))));
        }
        root.add(node);
    }

    private void addSubnetClusterInfo(DefaultMutableTreeNode root, Experiment experiment, int[][] clusters, int[] orderedIndices, boolean clusterGenes) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Cluster Information");
        if (clusterGenes) {
            node.add(new DefaultMutableTreeNode(new LeafInfo("Genes in Subnets (#,%)", (IViewer)new RNSubnetInfoViewer(clusters, orderedIndices, experiment.getNumberOfGenes(), true))));
        } else {
            node.add(new DefaultMutableTreeNode(new LeafInfo("Samples in Subnets (#,%)", (IViewer)new RNSubnetInfoViewer(clusters, orderedIndices, experiment.getNumberOfSamples(), false))));
        }
        root.add(node);
    }

    private void addTableViews(DefaultMutableTreeNode root, Experiment experiment, int[][] clusters, int[] indices, boolean clusterGenes) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Table views");
        Object viewer = clusterGenes ? new ClusterTableViewer(experiment, clusters, this.data) : new ExperimentClusterTableViewer(experiment, clusters, this.data);
        for (int i = 0; i < clusters.length; ++i) {
            if (clusters[indices[i]].length <= 1) continue;
            node.add(new DefaultMutableTreeNode(new LeafInfo("Element index " + String.valueOf(experiment.getGeneIndexMappedToData(clusters[i][0]) + 1) + " (" + clusters[indices[i]].length + ")", (IViewer)viewer, (Object)new Integer(indices[i]))));
        }
        root.add(node);
    }

    private void addExpressionImages(DefaultMutableTreeNode root, Experiment experiment, int[][] clusters, int[] indices, boolean clusterGenes) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Expression Images");
        Object viewer = clusterGenes ? new RelNetExperimentViewer(experiment, clusters) : new RelNetExperimentClusterViewer(experiment, clusters);
        for (int i = 0; i < clusters.length; ++i) {
            if (clusters[indices[i]].length <= 1) continue;
            node.add(new DefaultMutableTreeNode(new LeafInfo("Element index " + String.valueOf(experiment.getGeneIndexMappedToData(clusters[i][0]) + 1) + " (" + clusters[indices[i]].length + ")", (IViewer)viewer, (Object)new Integer(indices[i]))));
        }
        root.add(node);
    }

    private void addCentroidViews(DefaultMutableTreeNode root, Experiment experiment, int[][] clusters, int[] indices, boolean clusterGenes) {
        DefaultMutableTreeNode centroidNode = new DefaultMutableTreeNode("Centroid Graphs");
        DefaultMutableTreeNode expressionNode = new DefaultMutableTreeNode("Expression Graphs");
        if (clusterGenes) {
            RNCentroidViewer centroidViewer = new RNCentroidViewer(experiment, clusters);
            centroidViewer.setMeans(this.means.A);
            centroidViewer.setVariances(this.variances.A);
            for (int i = 0; i < clusters.length; ++i) {
                if (clusters[indices[i]].length <= 1) continue;
                centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Element index " + String.valueOf(experiment.getGeneIndexMappedToData(clusters[i][0]) + 1) + " (" + clusters[indices[i]].length + ")", (IViewer)centroidViewer, (Object)new CentroidUserObject(indices[i], 0))));
                expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Element index " + String.valueOf(experiment.getGeneIndexMappedToData(clusters[i][0]) + 1) + " (" + clusters[indices[i]].length + ")", (IViewer)centroidViewer, (Object)new CentroidUserObject(indices[i], 1))));
            }
        } else {
            RNExperimentCentroidViewer expCentroidViewer = new RNExperimentCentroidViewer(experiment, clusters);
            expCentroidViewer.setMeans(this.means.A);
            expCentroidViewer.setVariances(this.variances.A);
            for (int i = 0; i < clusters.length; ++i) {
                if (clusters[indices[i]].length <= 1) continue;
                centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Element index " + String.valueOf(indices[i] + 1) + " (" + clusters[indices[i]].length + ")", (IViewer)expCentroidViewer, (Object)new CentroidUserObject(indices[i], 0))));
                expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Element index " + String.valueOf(indices[i] + 1) + " (" + clusters[indices[i]].length + ")", (IViewer)expCentroidViewer, (Object)new CentroidUserObject(indices[i], 1))));
            }
            RNExperimentCentroidsViewer expCentroidsViewer = new RNExperimentCentroidsViewer(experiment, clusters);
            expCentroidsViewer.setMeans(this.means.A);
            expCentroidsViewer.setVariances(this.variances.A);
            centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)expCentroidsViewer, (Object)new Integer(0))));
            expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)expCentroidsViewer, (Object)new Integer(1))));
        }
        root.add(centroidNode);
        root.add(expressionNode);
    }

    private void addSubnets(DefaultMutableTreeNode root, Experiment experiment, int[][] clusters, boolean clusterGenes) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Expression Images");
        RelevanceNetworkLayout layout = new RelevanceNetworkLayout();
        int[][] subnets = layout.formRelevanceNetworks(clusters);
        int[] indices = this.getSortedIndices(subnets);
        Object viewer = clusterGenes ? new RelNetExperimentViewer(experiment, subnets) : new RelNetExperimentClusterViewer(experiment, subnets);
        for (int i = 0; i < subnets.length; ++i) {
            node.add(new DefaultMutableTreeNode(new LeafInfo("Subnet " + String.valueOf(i + 1) + " (" + subnets[indices[i]].length + ")", (IViewer)viewer, (Object)new Integer(indices[i]))));
        }
        root.add(node);
        this.addSubnetCentroidViews(root, experiment, subnets, indices, clusterGenes);
        this.addSubnetTableViews(root, experiment, subnets, indices, clusterGenes);
        this.addSubnetClusterInfo(root, experiment, subnets, indices, clusterGenes);
    }

    private void addSubnetTableViews(DefaultMutableTreeNode root, Experiment experiment, int[][] subnets, int[] indices, boolean clusterGenes) {
        DefaultMutableTreeNode tabNode = new DefaultMutableTreeNode("Table Views");
        if (!clusterGenes) {
            return;
        }
        ClusterTableViewer viewer = new ClusterTableViewer(experiment, subnets, this.data);
        for (int i = 0; i < subnets.length; ++i) {
            tabNode.add(new DefaultMutableTreeNode(new LeafInfo("Subnet " + String.valueOf(i + 1) + " (" + subnets[indices[i]].length + ")", (IViewer)viewer, (Object)new Integer(indices[i]))));
        }
        root.add(tabNode);
    }

    private void addSubnetCentroidViews(DefaultMutableTreeNode root, Experiment experiment, int[][] subnets, int[] indices, boolean clusterGenes) {
        DefaultMutableTreeNode centroidNode = new DefaultMutableTreeNode("Centroid Graphs");
        DefaultMutableTreeNode expressionNode = new DefaultMutableTreeNode("Expression Graphs");
        FloatMatrix subnetMeans = this.getMeans(subnets, experiment, clusterGenes);
        FloatMatrix subnetVars = this.getVariances(subnetMeans, experiment, subnets, clusterGenes);
        if (clusterGenes) {
            RNCentroidViewer centroidViewer = new RNCentroidViewer(experiment, subnets);
            centroidViewer.setMeans(subnetMeans.A);
            centroidViewer.setVariances(subnetVars.A);
            for (int i = 0; i < subnets.length; ++i) {
                centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Subnet " + String.valueOf(i + 1), (IViewer)centroidViewer, (Object)new CentroidUserObject(indices[i], 0))));
                expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Subnet " + String.valueOf(i + 1), (IViewer)centroidViewer, (Object)new CentroidUserObject(indices[i], 1))));
            }
            RNCentroidsViewer centroidsViewer = new RNCentroidsViewer(experiment, subnets);
            centroidsViewer.setMeans(subnetMeans.A);
            centroidsViewer.setVariances(subnetVars.A);
            centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)centroidsViewer, (Object)new Integer(0))));
            expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)centroidsViewer, (Object)new Integer(1))));
        } else {
            RNExperimentCentroidViewer expCentroidViewer = new RNExperimentCentroidViewer(experiment, subnets);
            expCentroidViewer.setMeans(subnetMeans.A);
            expCentroidViewer.setVariances(subnetVars.A);
            for (int i = 0; i < subnets.length; ++i) {
                centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Subnet " + String.valueOf(i + 1), (IViewer)expCentroidViewer, (Object)new CentroidUserObject(indices[i], 0))));
                expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Subnet " + String.valueOf(i + 1), (IViewer)expCentroidViewer, (Object)new CentroidUserObject(indices[i], 1))));
            }
            RNExperimentCentroidsViewer expCentroidsViewer = new RNExperimentCentroidsViewer(experiment, subnets);
            expCentroidsViewer.setMeans(subnetMeans.A);
            expCentroidsViewer.setVariances(subnetVars.A);
            centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)expCentroidsViewer, (Object)new Integer(0))));
            expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)expCentroidsViewer, (Object)new Integer(1))));
        }
        root.add(centroidNode);
        root.add(expressionNode);
    }

    private FloatMatrix getMeans(int[][] subnets, Experiment experiment, boolean classifyGenes) {
        FloatMatrix expMatrix = experiment.getMatrix();
        if (!classifyGenes) {
            expMatrix = expMatrix.transpose();
        }
        int numSamples = expMatrix.getColumnDimension();
        int numGenes = expMatrix.getRowDimension();
        FloatMatrix means = new FloatMatrix(subnets.length, numSamples);
        float cumVal = 0.0f;
        int n = 0;
        int index = 0;
        for (int i = 0; i < subnets.length; ++i) {
            float[] currMeans = new float[numSamples];
            for (int j = 0; j < numSamples; ++j) {
                for (int k = 0; k < subnets[i].length; ++k) {
                    index = subnets[i][k];
                    float value = expMatrix.get(index, j);
                    if (Float.isNaN(value)) continue;
                    ++n;
                    cumVal += value;
                }
                currMeans[j] = n > 0 ? cumVal / (float)n : 0.0f;
                n = 0;
                cumVal = 0.0f;
            }
            means.A[i] = currMeans;
        }
        return means;
    }

    private FloatMatrix getVariances(FloatMatrix means, Experiment experiment, int[][] subnets, boolean clusterGenes) {
        FloatMatrix expMatrix = experiment.getMatrix();
        if (!clusterGenes) {
            expMatrix = expMatrix.transpose();
        }
        int numSamples = expMatrix.getColumnDimension();
        int numGenes = expMatrix.getRowDimension();
        FloatMatrix vars = new FloatMatrix(subnets.length, numSamples);
        float mean = 0.0f;
        float cumVal = 0.0f;
        int n = 0;
        int index = 0;
        for (int i = 0; i < subnets.length; ++i) {
            float[] currVars = new float[numSamples];
            for (int j = 0; j < numSamples; ++j) {
                for (int k = 0; k < subnets[i].length; ++k) {
                    index = subnets[i][k];
                    float value = expMatrix.get(index, j);
                    if (Float.isNaN(value)) continue;
                    ++n;
                    cumVal = (float)((double)cumVal + Math.pow(value - means.get(i, j), 2.0));
                }
                currVars[j] = n > 1 ? (float)Math.sqrt(cumVal / (float)(n - 1)) : 0.0f;
                n = 0;
                cumVal = 0.0f;
            }
            vars.A[i] = currVars;
        }
        return vars;
    }

    private void addRelevanceNetworkViewer(DefaultMutableTreeNode root, Experiment experiment, int[][] clusters, float[][] weights, int[] indices, boolean clusterGenes) {
        root.add(new DefaultMutableTreeNode(new LeafInfo("Network", (IViewer)new RelevanceNetworkViewer(clusterGenes, experiment, clusters, weights, indices))));
    }

    private void addGeneralInfo(DefaultMutableTreeNode root, GeneralInfo info) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("General Information");
        node.add(new DefaultMutableTreeNode("Links: " + String.valueOf(info.links)));
        node.add(new DefaultMutableTreeNode("Time: " + String.valueOf(info.time) + " ms"));
        node.add(new DefaultMutableTreeNode("Min Threshold: " + String.valueOf(info.min_threshold)));
        node.add(new DefaultMutableTreeNode("Max Threshold: " + String.valueOf(info.max_threshold)));
        node.add(new DefaultMutableTreeNode("Highest Entropy Filter: " + String.valueOf(info.entropy) + " %"));
        node.add(new DefaultMutableTreeNode(info.function));
        node.add(new DefaultMutableTreeNode("Absolute: " + String.valueOf(info.absolute)));
        root.add(node);
    }

    private class GeneralInfo {
        private long time;
        private int links;
        private float min_threshold;
        private float max_threshold;
        private float entropy;
        private String function;
        private boolean absolute;

        private GeneralInfo() {
        }
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        private Listener() {
        }

        public void valueChanged(AlgorithmEvent event) {
            switch (event.getId()) {
                case 1: {
                    RNGUI.this.progress.setUnits(event.getIntValue());
                    RNGUI.this.progress.setDescription(event.getDescription());
                    break;
                }
                case 2: {
                    RNGUI.this.progress.setValue(event.getIntValue());
                    RNGUI.this.progress.setDescription(event.getDescription());
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("cancel-command")) {
                RNGUI.this.algorithm.abort();
                RNGUI.this.progress.dispose();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            RNGUI.this.algorithm.abort();
            RNGUI.this.progress.dispose();
        }
    }
}

