/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.qtc;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DistanceMetricPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.HCLSelectionPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.SampleSelectionPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.util.awt.GBA;

public class QTCInitDialog
extends AlgorithmDialog {
    protected GBA gba;
    protected EventListener eventListener;
    protected JPanel inputPanel;
    public JLabel diameterLabel;
    public JTextField diameterTextField;
    public JLabel clusterLabel;
    public JTextField clusterTextField;
    public int result;
    private SampleSelectionPanel sampleSelectionPanel;
    private HCLSelectionPanel hclOpsPanel;
    protected JPanel mainPanel;
    private boolean okPressed = false;
    private DistanceMetricPanel metricPanel;

    public QTCInitDialog(JFrame parent, boolean modal, String globalMetricName, boolean globalAbsoluteValue) {
        super(parent, "QTC: QT Cluster", modal);
        this.initialize(globalMetricName, globalAbsoluteValue);
    }

    protected void initialize(String globalMetricName, boolean globalAbsoluteValue) {
        this.gba = new GBA();
        this.eventListener = new EventListener();
        this.diameterLabel = new JLabel("Maximum Cluster Diameter");
        this.diameterLabel.setAlignmentX(0.0f);
        this.diameterTextField = new JTextField(5);
        this.diameterTextField.setText("0.5");
        this.clusterLabel = new JLabel("Minimum Cluster Population");
        this.clusterTextField = new JTextField(5);
        this.clusterTextField.setText("5");
        this.sampleSelectionPanel = new SampleSelectionPanel(Color.white, UIManager.getColor("Label.foreground"), true, "Sample Selection");
        this.metricPanel = new DistanceMetricPanel(globalMetricName, globalAbsoluteValue, "Pearson Correlation", "QTC", true, true);
        this.inputPanel = new JPanel();
        this.inputPanel.setLayout(new GridBagLayout());
        this.inputPanel.setBackground(Color.white);
        this.gba.add((Container)this.inputPanel, (Component)this.diameterLabel, 0, 0, 1, 1, 0, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add((Container)this.inputPanel, (Component)this.clusterLabel, 0, 1, 1, 0, 0, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add((Container)this.inputPanel, (Component)this.diameterTextField, 1, 0, 1, 1, 0, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add((Container)this.inputPanel, (Component)this.clusterTextField, 1, 1, 1, 1, 0, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.hclOpsPanel = new HCLSelectionPanel();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        this.mainPanel.setBackground(Color.white);
        ParameterPanel parameters = new ParameterPanel();
        parameters.setLayout(new GridBagLayout());
        this.gba.add((Container)parameters, (Component)this.inputPanel, 0, 0, 1, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add((Container)this.mainPanel, (Component)this.sampleSelectionPanel, 0, 0, 1, 1, 1, 1, 2, 10, new Insets(0, 0, 0, 0), 0, 0);
        this.gba.add((Container)this.mainPanel, (Component)this.metricPanel, 0, 1, 1, 1, 1, 1, 2, 10, new Insets(0, 0, 0, 0), 0, 0);
        this.gba.add((Container)this.mainPanel, (Component)parameters, 0, 2, 1, 1, 1, 1, 2, 10, new Insets(0, 0, 0, 0), 0, 0);
        this.gba.add((Container)this.mainPanel, (Component)this.hclOpsPanel, 0, 3, 1, 1, 1, 1, 2, 10, new Insets(0, 0, 0, 0), 0, 0);
        this.setActionListeners(this.eventListener);
        this.addContent(this.mainPanel);
        this.pack();
    }

    @Override
    public void setVisible(boolean visible) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        super.setVisible(visible);
        if (visible) {
            this.okButton.requestFocus();
        }
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public boolean isClusterGenesSelected() {
        return this.sampleSelectionPanel.isClusterGenesSelected();
    }

    public boolean isHCLSelected() {
        return this.hclOpsPanel.isHCLSelected();
    }

    public int getDistanceMetric() {
        return this.metricPanel.getMetricIndex();
    }

    public boolean isAbsoluteDistance() {
        return this.metricPanel.getAbsoluteSelection();
    }

    private void resetControls() {
        this.sampleSelectionPanel.setClusterGenesSelected(true);
        this.hclOpsPanel.setHCLSelected(false);
        this.clusterTextField.setText("5");
        this.diameterTextField.setText("0.5");
        this.metricPanel.reset();
    }

    private boolean validInput(int k, float d) {
        boolean valid = true;
        if (d <= 0.0f) {
            JOptionPane.showMessageDialog(this, "Diameter must be > 0", "Input Error!", 0);
            this.diameterTextField.requestFocus();
            this.diameterTextField.selectAll();
            valid = false;
        } else if (k < 1) {
            JOptionPane.showMessageDialog(this, "Population of a cluster must be > 0", "Input Error!", 0);
            this.clusterTextField.requestFocus();
            this.clusterTextField.selectAll();
            valid = false;
        }
        return valid;
    }

    public static void main(String[] agrs) {
        QTCInitDialog hgid = new QTCInitDialog(new JFrame(), true, "Euclidean Distance", false);
        hgid.show();
        System.exit(0);
    }

    protected class EventListener
    implements ActionListener {
        protected EventListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String command = event.getActionCommand();
            if (command.equals("ok-command")) {
                int k;
                float d;
                int progress = 0;
                try {
                    d = Float.parseFloat(QTCInitDialog.this.diameterTextField.getText());
                    ++progress;
                    k = Integer.parseInt(QTCInitDialog.this.clusterTextField.getText());
                    ++progress;
                }
                catch (NumberFormatException nfe) {
                    if (progress == 0) {
                        QTCInitDialog.this.diameterTextField.requestFocus();
                        QTCInitDialog.this.diameterTextField.selectAll();
                    } else if (progress == 1) {
                        QTCInitDialog.this.clusterTextField.requestFocus();
                        QTCInitDialog.this.clusterTextField.selectAll();
                    }
                    JOptionPane.showMessageDialog(QTCInitDialog.this, "Number format error.", "Number Format Error", 0);
                    QTCInitDialog.this.result = 2;
                    QTCInitDialog.this.okPressed = false;
                    return;
                }
                if (QTCInitDialog.this.validInput(k, d)) {
                    QTCInitDialog.this.result = 0;
                    QTCInitDialog.this.okPressed = true;
                    QTCInitDialog.this.dispose();
                } else {
                    QTCInitDialog.this.result = 2;
                    QTCInitDialog.this.okPressed = false;
                }
            } else if (command.equals("cancel-command")) {
                QTCInitDialog.this.result = 2;
                QTCInitDialog.this.okPressed = false;
                QTCInitDialog.this.dispose();
            } else if (command.equals("reset-command")) {
                QTCInitDialog.this.resetControls();
            } else if (command.equals("info-command")) {
                HelpWindow.launchBrowser(QTCInitDialog.this, "QTC Initialization Dialog");
            }
        }
    }
}

