/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.qtc;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;

public class QTCInfoViewer
extends ViewerAdapter
implements Serializable {
    private JComponent header;
    private JTextArea content;
    private boolean clusterGenes = true;

    public QTCInfoViewer(int[][] clusters, int genes) {
        this.header = this.createHeader();
        this.content = this.createContent(clusters, genes);
        this.setMaxWidth(this.content, this.header);
    }

    public QTCInfoViewer(int[][] clusters, int genes, boolean clusterGenes) {
        this.clusterGenes = clusterGenes;
        this.header = this.createHeader();
        this.content = this.createContent(clusters, genes);
        this.setMaxWidth(this.content, this.header);
    }

    public QTCInfoViewer(JTextArea contentComponent, JComponent headerComponent) {
        this.header = headerComponent;
        this.content = contentComponent;
        this.setMaxWidth(this.content, this.header);
    }

    @Override
    public JComponent getContentComponent() {
        return this.content;
    }

    @Override
    public JComponent getHeaderComponent() {
        return this.header;
    }

    private JComponent createHeader() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBackground(Color.white);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(10, 0, 10, 0);
        panel.add((Component)new JLabel("<html><body bgcolor='#FFFFFF'><font face='serif' size='5' color='#000080'><b>Cluster Information</b></font></body></html>"), gbc);
        return panel;
    }

    private JTextArea createContent(int[][] clusters, int genes) {
        JTextArea area = new JTextArea(clusters.length * 3, 20);
        area.setMargin(new Insets(0, 10, 0, 0));
        area.setEditable(false);
        StringBuffer sb = new StringBuffer(clusters.length * 3 * 10);
        if (this.clusterGenes) {
            for (int counter = 0; counter < clusters.length - 1; ++counter) {
                sb.append("Cluster " + (counter + 1));
                sb.append("\t\t");
                sb.append("# of Genes in Cluster: " + clusters[counter].length);
                sb.append("\n\t\t");
                sb.append("% of Genes in Cluster: " + Math.round((float)clusters[counter].length / (float)genes * 100.0f) + "%");
                sb.append("\n\n");
            }
            sb.append("Unassigned Genes ");
            sb.append("\t");
            sb.append("# of Unassigned Genes: " + clusters[clusters.length - 1].length);
            sb.append("\n\t\t");
            sb.append("% of Genes that are Unassigned: " + Math.round((float)clusters[clusters.length - 1].length / (float)genes * 100.0f) + "%");
            sb.append("\n\n");
        } else {
            for (int counter = 0; counter < clusters.length - 1; ++counter) {
                sb.append("Cluster " + (counter + 1));
                sb.append("\t\t");
                sb.append("# of Experiments in Cluster: " + clusters[counter].length);
                sb.append("\n\t\t");
                sb.append("% of Experiments in Cluster: " + Math.round((float)clusters[counter].length / (float)genes * 100.0f) + "%");
                sb.append("\n\n");
            }
            sb.append("Unassigned Experiments ");
            sb.append("\t");
            sb.append("# of Unassigned Experiments: " + clusters[clusters.length - 1].length);
            sb.append("\n\t\t");
            sb.append("% of Experiments that are Unassigned: " + Math.round((float)clusters[clusters.length - 1].length / (float)genes * 100.0f) + "%");
            sb.append("\n\n");
        }
        area.setText(sb.toString());
        area.setCaretPosition(0);
        return area;
    }

    private void setMaxWidth(JComponent content, JComponent header) {
        int c_width = content.getPreferredSize().width;
        int h_width = header.getPreferredSize().width;
        if (c_width > h_width) {
            header.setPreferredSize(new Dimension(c_width, header.getPreferredSize().height));
        } else {
            content.setPreferredSize(new Dimension(h_width, content.getPreferredSize().height));
        }
    }

    @Override
    public JComponent getRowHeaderComponent() {
        return null;
    }
}

