/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ptm;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.tigr.graph.GraphCanvas;
import org.tigr.graph.GraphElement;
import org.tigr.graph.GraphLine;
import org.tigr.graph.GraphPoint;
import org.tigr.microarray.mev.TMEV;
import org.tigr.util.FloatMatrix;

public class PavlidisTemplateInitBox
extends JPanel {
    String[] SampleNames;
    Vector sampleNamesVector;
    Vector uniqueIDs;
    Vector clusters;
    Color[] clusterColors;
    UniqueIDSelector uidSelectPanel;
    ClusterSelector clusterSelectPanel;
    SavedTemplateSelector templateSelectPanel;
    BottomPanel bott;
    TemplatePanel tempPanel;
    AbsolutePanel abs;
    ThresholdPanel thresh;
    FloatMatrix expMatrix;
    JCheckBox drawTreesBox;
    JPanel drawTreesPane;
    JTabbedPane tabbedPane;
    Vector template;
    FloatMatrix templateMatrix;
    private boolean okPressed = false;

    public PavlidisTemplateInitBox(JFrame parentFrame, boolean modality, FloatMatrix expMatrix, Vector sampleNamesVector, Vector uniqueIDs, Vector clusters, Color[] clusterColors) {
        this.expMatrix = expMatrix;
        this.sampleNamesVector = sampleNamesVector;
        this.uniqueIDs = uniqueIDs;
        this.clusters = clusters;
        this.clusterColors = clusterColors;
        this.SampleNames = this.getSampleNames();
        this.setBounds(0, 0, 1000, 800);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        JPanel pane = new JPanel();
        pane.setLayout(gridbag);
        this.buildConstraints(constraints, 0, 0, 2, 1, 0, 25);
        this.tabbedPane = new JTabbedPane();
        this.uidSelectPanel = new UniqueIDSelector();
        this.clusterSelectPanel = new ClusterSelector();
        this.templateSelectPanel = new SavedTemplateSelector();
        this.tabbedPane.addTab("Select a gene as template", this.uidSelectPanel);
        this.tabbedPane.addTab("Select a cluster mean as template", this.clusterSelectPanel);
        this.tabbedPane.addTab("Select a saved template", this.templateSelectPanel);
        gridbag.setConstraints(this.tabbedPane, constraints);
        pane.add(this.tabbedPane);
        this.buildConstraints(constraints, 0, 1, 2, 1, 0, 55);
        this.tempPanel = new TemplatePanel();
        gridbag.setConstraints(this.tempPanel, constraints);
        pane.add(this.tempPanel);
        this.buildConstraints(constraints, 0, 2, 1, 1, 70, 5);
        this.abs = new AbsolutePanel();
        gridbag.setConstraints(this.abs, constraints);
        pane.add(this.abs);
        this.buildConstraints(constraints, 0, 3, 1, 1, 0, 10);
        this.thresh = new ThresholdPanel();
        gridbag.setConstraints(this.thresh, constraints);
        pane.add(this.thresh);
        this.buildConstraints(constraints, 0, 4, 1, 1, 0, 5);
        this.drawTreesPane = new JPanel();
        this.drawTreesBox = new JCheckBox("Draw hierarchical trees?");
        this.drawTreesPane.add(this.drawTreesBox);
        gridbag.setConstraints(this.drawTreesPane, constraints);
        pane.add(this.drawTreesPane);
        this.buildConstraints(constraints, 1, 2, 1, 3, 30, 0);
        this.bott = new BottomPanel();
        this.bott.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (evt.getSource() == PavlidisTemplateInitBox.this.bott.cancelButton) {
                    // empty if block
                }
            }
        });
        gridbag.setConstraints(this.bott, constraints);
        pane.add(this.bott);
        this.add(pane);
    }

    @Override
    public void setVisible(boolean visible) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        super.setVisible(visible);
    }

    void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    String[] getSampleNames() {
        String[] SampleNames = new String[this.sampleNamesVector.size()];
        for (int i = 0; i < this.sampleNamesVector.size(); ++i) {
            SampleNames[i] = (String)this.sampleNamesVector.get(i);
        }
        return SampleNames;
    }

    private Vector getGene(int index) {
        Vector<Float> gene = new Vector<Float>();
        for (int i = 0; i < this.sampleNamesVector.size(); ++i) {
            gene.add(new Float(this.expMatrix.get(index, i)));
        }
        return gene;
    }

    private float getMax(Vector gene) {
        float max = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < gene.size(); ++i) {
            float current;
            if (Float.isNaN(((Float)gene.get(i)).floatValue()) || !((current = ((Float)gene.get(i)).floatValue()) > max)) continue;
            max = current;
        }
        return max;
    }

    private float getMin(Vector gene) {
        float min = Float.MAX_VALUE;
        for (int i = 0; i < gene.size(); ++i) {
            float current;
            if (Float.isNaN(((Float)gene.get(i)).floatValue()) || !((current = ((Float)gene.get(i)).floatValue()) < min)) continue;
            min = current;
        }
        return min;
    }

    public Vector getTemplate() {
        Vector<Float> geneTemplate = new Vector<Float>();
        for (int i = 0; i < this.sampleNamesVector.size(); ++i) {
            String s = this.tempPanel.tempScr.tempGrid[i].templateField.getText();
            if (s.equals("NaN") || s.equals("NULL") || !this.tempPanel.tempScr.tempGrid[i].activeBox.isSelected()) {
                geneTemplate.add(new Float(Float.NaN));
                continue;
            }
            geneTemplate.add(new Float(s));
        }
        return geneTemplate;
    }

    public FloatMatrix convertTemplateVectorToFloatMatrix() {
        this.template = this.getTemplate();
        FloatMatrix templateMatrix = new FloatMatrix(1, this.template.size());
        for (int i = 0; i < this.template.size(); ++i) {
            templateMatrix.A[0][i] = ((Float)this.template.get(i)).floatValue();
        }
        return templateMatrix;
    }

    protected void fireOkButtonEvent() {
        this.templateMatrix = this.convertTemplateVectorToFloatMatrix();
        boolean absoluteSelected = this.abs.absBox.isSelected();
        boolean drawTreesSelected = this.drawTreesBox.isSelected();
        boolean rSelected = this.thresh.chooseR.isSelected();
        String s = this.thresh.threshInputField.getText();
        double threshR = Double.parseDouble(s);
        Hashtable<String, Serializable> hash = new Hashtable<String, Serializable>();
        hash.put(new String("drawTrees"), new Boolean(drawTreesSelected));
        hash.put(new String("useAbsolute"), new Boolean(absoluteSelected));
        hash.put(new String("useR"), new Boolean(rSelected));
        hash.put(new String("template"), this.template);
        hash.put(new String("thresholdR"), new Double(threshR));
    }

    public boolean isDrawTrees() {
        return this.drawTreesBox.isSelected();
    }

    public boolean isUseAbsolute() {
        return this.abs.absBox.isSelected();
    }

    public boolean isUseR() {
        return this.thresh.chooseR.isSelected();
    }

    public FloatMatrix getTemplateMatrix() {
        return this.convertTemplateVectorToFloatMatrix();
    }

    public double getThresholdR() {
        return Double.parseDouble(this.thresh.threshInputField.getText());
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    protected class EventListener
    implements ActionListener {
        protected EventListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object source = event.getSource();
            if (source == PavlidisTemplateInitBox.this.bott.okButton) {
                try {
                    String s = PavlidisTemplateInitBox.this.thresh.threshInputField.getText();
                    double r = Double.parseDouble(s);
                    if (r > 1.0 || r < 0.0) {
                        JOptionPane.showMessageDialog(null, "Threshold R value must be between 0 and 1 (inclusive)");
                        PavlidisTemplateInitBox.this.thresh.threshInputField.setText("0.80");
                    } else {
                        PavlidisTemplateInitBox.this.setVisible(false);
                        PavlidisTemplateInitBox.this.fireOkButtonEvent();
                        PavlidisTemplateInitBox.this.okPressed = true;
                    }
                }
                catch (Exception exc) {
                    JOptionPane.showMessageDialog(null, "Threshold R value must be between 0 and 1 (inclusive)");
                    PavlidisTemplateInitBox.this.thresh.threshInputField.setText("0.80");
                }
            }
        }
    }

    class TemplatePanel
    extends JPanel {
        TemplateScroller tempScr;

        TemplatePanel() {
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.fill = 1;
            this.setLayout(gridbag);
            this.tempScr = new TemplateScroller();
            JScrollPane scroller = this.tempScr.createTemplateScroller();
            PavlidisTemplateInitBox.this.buildConstraints(constraints, 0, 0, 1, 1, 100, 95);
            gridbag.setConstraints(scroller, constraints);
            this.add(scroller);
            PavlidisTemplateInitBox.this.buildConstraints(constraints, 0, 1, 1, 1, 100, 5);
            constraints.fill = 0;
        }

        class TemplateScroller
        extends JPanel {
            TemplateElementGrid[] tempGrid;

            TemplateScroller() {
                this.tempGrid = new TemplateElementGrid[PavlidisTemplateInitBox.this.SampleNames.length];
            }

            JScrollPane createTemplateScroller() {
                GridBagLayout gridbag = new GridBagLayout();
                GridBagConstraints constraints = new GridBagConstraints();
                constraints.fill = 1;
                this.setLayout(gridbag);
                for (int i = 0; i < PavlidisTemplateInitBox.this.SampleNames.length; ++i) {
                    this.tempGrid[i] = new TemplateElementGrid(PavlidisTemplateInitBox.this.SampleNames[i]);
                    PavlidisTemplateInitBox.this.buildConstraints(constraints, i, 0, 1, 1, 100, 100);
                    gridbag.setConstraints(this.tempGrid[i], constraints);
                    this.add(this.tempGrid[i]);
                }
                JScrollPane scroller = new JScrollPane(this);
                scroller.setHorizontalScrollBarPolicy(30);
                scroller.setVerticalScrollBarPolicy(20);
                return scroller;
            }

            class TemplateElementGrid
            extends JPanel {
                JLabel exptName;
                JTextField templateField;
                JSlider templateSlider;
                JCheckBox activeBox;

                TemplateElementGrid(String SampleName) {
                    GridBagLayout templateElement = new GridBagLayout();
                    GridBagConstraints constraints = new GridBagConstraints();
                    constraints.fill = 1;
                    this.setLayout(templateElement);
                    PavlidisTemplateInitBox.this.buildConstraints(constraints, 0, 0, 1, 1, 50, 10);
                    this.exptName = new JLabel(SampleName, 0);
                    templateElement.setConstraints(this.exptName, constraints);
                    this.add(this.exptName);
                    PavlidisTemplateInitBox.this.buildConstraints(constraints, 1, 0, 1, 1, 50, 0);
                    this.activeBox = new JCheckBox();
                    this.activeBox.setSelected(true);
                    this.activeBox.addItemListener(new ItemListener(){

                        @Override
                        public void itemStateChanged(ItemEvent e) {
                            if (e.getStateChange() == 2) {
                                TemplateElementGrid.this.templateField.setBackground(Color.gray);
                                TemplateElementGrid.this.templateField.setEnabled(false);
                                TemplateElementGrid.this.templateSlider.setEnabled(false);
                            }
                            if (e.getStateChange() == 1) {
                                TemplateElementGrid.this.templateField.setBackground(Color.white);
                                TemplateElementGrid.this.templateField.setEnabled(true);
                                TemplateElementGrid.this.templateSlider.setEnabled(true);
                            }
                        }
                    });
                    templateElement.setConstraints(this.activeBox, constraints);
                    this.add(this.activeBox);
                    PavlidisTemplateInitBox.this.buildConstraints(constraints, 0, 1, 2, 1, 0, 5);
                    this.templateField = new JTextField("0.5", 4);
                    this.templateField.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (e.getSource() == TemplateElementGrid.this.templateField) {
                                int sliderValue;
                                try {
                                    String s = TemplateElementGrid.this.templateField.getText();
                                    double d = Double.parseDouble(s);
                                    sliderValue = (int)Math.floor(d * 100.0);
                                    if (d > 1.0 || d < 0.0) {
                                        sliderValue = 50;
                                        TemplateElementGrid.this.templateField.setText("0.5");
                                        JOptionPane.showMessageDialog(null, "Template values must be between 0 and 1 (inclusive)");
                                    }
                                }
                                catch (Exception exc) {
                                    TemplateElementGrid.this.templateField.setText("0.5");
                                    sliderValue = 50;
                                    JOptionPane.showMessageDialog(null, "Template values must be between 0 and 1 (inclusive)");
                                }
                                TemplateElementGrid.this.templateSlider.setValue(sliderValue);
                            }
                        }
                    });
                    this.templateField.addFocusListener(new FocusListener(){

                        @Override
                        public void focusLost(FocusEvent e) {
                            if (e.getSource() == TemplateElementGrid.this.templateField) {
                                int sliderValue;
                                try {
                                    String s = TemplateElementGrid.this.templateField.getText();
                                    double d = Double.parseDouble(s);
                                    sliderValue = (int)Math.floor(d * 100.0);
                                    if (d > 1.0 || d < 0.0) {
                                        sliderValue = 50;
                                        TemplateElementGrid.this.templateField.setText("0.5");
                                        JOptionPane.showMessageDialog(null, "Template values must be between 0 and 1 (inclusive)");
                                    }
                                }
                                catch (Exception exc) {
                                    TemplateElementGrid.this.templateField.setText("0.5");
                                    sliderValue = 50;
                                    JOptionPane.showMessageDialog(null, "Template values must be between 0 and 1 (inclusive)");
                                }
                                TemplateElementGrid.this.templateSlider.setValue(sliderValue);
                            }
                        }

                        @Override
                        public void focusGained(FocusEvent e) {
                        }
                    });
                    templateElement.setConstraints(this.templateField, constraints);
                    this.add(this.templateField);
                    PavlidisTemplateInitBox.this.buildConstraints(constraints, 0, 2, 1, 2, 0, 85);
                    this.templateSlider = new JSlider(1, 0, 100, 50);
                    this.templateSlider.setMajorTickSpacing(20);
                    this.templateSlider.setMinorTickSpacing(10);
                    Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
                    labelTable.put(new Integer(0), new JLabel("Min"));
                    labelTable.put(new Integer(100), new JLabel("Max"));
                    this.templateSlider.setLabelTable(labelTable);
                    this.templateSlider.setPaintLabels(true);
                    this.templateSlider.addChangeListener(new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent e) {
                            JSlider source = (JSlider)e.getSource();
                            if (!source.getValueIsAdjusting()) {
                                int value = source.getValue();
                                if (value == 100) {
                                    TemplateElementGrid.this.templateField.setText("1.0");
                                } else if (value > 0 && value < 10) {
                                    TemplateElementGrid.this.templateField.setText("0.0" + value);
                                } else {
                                    TemplateElementGrid.this.templateField.setText("0." + value);
                                }
                            }
                        }
                    });
                    templateElement.setConstraints(this.templateSlider, constraints);
                    this.add(this.templateSlider);
                }

                public void reset() {
                    this.templateSlider.setValue(50);
                    this.templateField.setText("0.5");
                }
            }
        }
    }

    class BottomPanel
    extends JPanel {
        JButton resetButton;
        JButton okButton;
        JButton cancelButton;
        JButton saveButton;

        BottomPanel() {
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.fill = 0;
            this.setLayout(gridbag);
            PavlidisTemplateInitBox.this.buildConstraints(constraints, 0, 0, 1, 1, 100, 100);
            this.saveButton = new JButton("Save template to file");
            gridbag.setConstraints(this.saveButton, constraints);
            this.saveButton.setEnabled(false);
            this.add(this.saveButton);
            this.saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    JFileChooser fc;
                    int returnVal;
                    if (evt.getSource() == BottomPanel.this.saveButton && (returnVal = (fc = new JFileChooser(TMEV.getFile((String)"data/"))).showSaveDialog(BottomPanel.this)) == 0) {
                        File file = fc.getSelectedFile();
                        try {
                            DataOutputStream templateData = new DataOutputStream(new FileOutputStream(file.getName(), true));
                            for (int i = 0; i < PavlidisTemplateInitBox.this.tempPanel.tempScr.tempGrid.length; ++i) {
                                String s = PavlidisTemplateInitBox.this.tempPanel.tempScr.tempGrid[i].templateField.getText();
                                float f = Float.parseFloat(s);
                                templateData.writeFloat(f);
                            }
                            templateData.close();
                        }
                        catch (IOException e) {
                            System.out.println("Error: " + e.toString());
                        }
                    }
                }
            });
            PavlidisTemplateInitBox.this.buildConstraints(constraints, 0, 1, 1, 1, 100, 100);
            this.resetButton = new JButton("Reset");
            this.resetButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (evt.getSource() == BottomPanel.this.resetButton) {
                        for (int i = 0; i < PavlidisTemplateInitBox.this.tempPanel.tempScr.tempGrid.length; ++i) {
                            PavlidisTemplateInitBox.this.tempPanel.tempScr.tempGrid[i].reset();
                        }
                        PavlidisTemplateInitBox.this.thresh.threshInputField.setText("");
                        PavlidisTemplateInitBox.this.abs.absBox.setSelected(false);
                    }
                }
            });
            gridbag.setConstraints(this.resetButton, constraints);
            this.add(this.resetButton);
            PavlidisTemplateInitBox.this.buildConstraints(constraints, 0, 2, 1, 1, 100, 100);
            this.okButton = new JButton("OK");
            this.okButton.addActionListener(new EventListener());
            gridbag.setConstraints(this.okButton, constraints);
            this.add(this.okButton);
            PavlidisTemplateInitBox.this.buildConstraints(constraints, 0, 3, 1, 1, 100, 100);
            this.cancelButton = new JButton("Cancel");
            gridbag.setConstraints(this.cancelButton, constraints);
            this.add(this.cancelButton);
        }
    }

    class ThresholdPanel
    extends JPanel {
        JLabel threshLabel1;
        JLabel threshLabel2;
        JTextField threshInputField;
        JRadioButton chooseR;
        JRadioButton chooseP;

        ThresholdPanel() {
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.fill = 0;
            this.setLayout(gridbag);
            ButtonGroup chooseRorP = new ButtonGroup();
            this.chooseR = new JRadioButton("Use Threshold R", false);
            chooseRorP.add(this.chooseR);
            this.chooseP = new JRadioButton("Use Threshold p-Value", true);
            chooseRorP.add(this.chooseP);
            PavlidisTemplateInitBox.this.buildConstraints(constraints, 0, 0, 1, 1, 10, 50);
            constraints.anchor = 16;
            gridbag.setConstraints(this.chooseR, constraints);
            this.add(this.chooseR);
            PavlidisTemplateInitBox.this.buildConstraints(constraints, 0, 1, 1, 1, 0, 50);
            constraints.anchor = 18;
            gridbag.setConstraints(this.chooseP, constraints);
            this.add(this.chooseP);
            PavlidisTemplateInitBox.this.buildConstraints(constraints, 1, 0, 1, 1, 80, 0);
            constraints.anchor = 16;
            this.threshLabel1 = new JLabel("Enter magnitude of threshold R or p-Value (between 0 and 1 inclusive)");
            gridbag.setConstraints(this.threshLabel1, constraints);
            this.add(this.threshLabel1);
            PavlidisTemplateInitBox.this.buildConstraints(constraints, 1, 1, 1, 1, 0, 0);
            constraints.anchor = 18;
            this.threshLabel2 = new JLabel("at which selected profiles should be correlated to template");
            gridbag.setConstraints(this.threshLabel2, constraints);
            this.add(this.threshLabel2);
            PavlidisTemplateInitBox.this.buildConstraints(constraints, 2, 0, 1, 2, 10, 0);
            constraints.anchor = 17;
            this.threshInputField = new JTextField("", 7);
            this.threshInputField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (evt.getSource() == ThresholdPanel.this.threshInputField) {
                        try {
                            System.out.println("in gene dialog, ptm");
                            String s = ThresholdPanel.this.threshInputField.getText();
                            double r = Double.parseDouble(s);
                            if (r > 1.0 || r < 0.0) {
                                JOptionPane.showMessageDialog(null, "Threshold R value must be between 0 and 1 (inclusive)");
                                ThresholdPanel.this.threshInputField.setText("");
                            }
                        }
                        catch (Exception exc) {
                            JOptionPane.showMessageDialog(null, "Threshold R value must be between 0 and 1 (inclusive)");
                            ThresholdPanel.this.threshInputField.setText("");
                        }
                    }
                }
            });
            gridbag.setConstraints(this.threshInputField, constraints);
            this.add(this.threshInputField);
        }
    }

    class SavedTemplateSelector
    extends JPanel {
        JList templateList;
        GraphCanvas profileDisplayPanel;
        JScrollPane listScrollPane;
        JButton selectButton;
        JButton loadButton;
        Vector templatesVector = new Vector();
        DefaultListModel listModel;
        Vector templates;
        JSplitPane templateSplitPane;
        JPanel templateButtonPanel;

        SavedTemplateSelector() {
        }

        private void refreshGraph() {
            int i;
            int index = this.templateList.getSelectedIndex();
            if (index < 0) {
                return;
            }
            Vector expProfile = (Vector)((Vector)this.templatesVector.get(index)).clone();
            this.profileDisplayPanel.removeAllGraphElements();
            for (i = 0; i < expProfile.size(); ++i) {
                GraphPoint gp = new GraphPoint((double)(i + 1), (double)((Float)expProfile.elementAt(i)).floatValue(), Color.red, 2);
                this.profileDisplayPanel.addGraphElement((GraphElement)gp);
            }
            for (i = 0; i < expProfile.size() - 1; ++i) {
                GraphLine gl = new GraphLine((double)(i + 1), (double)((Float)expProfile.elementAt(i)).floatValue(), (double)(i + 2), (double)((Float)expProfile.elementAt(i + 1)).floatValue(), Color.blue);
                this.profileDisplayPanel.addGraphElement((GraphElement)gl);
            }
            this.profileDisplayPanel.repaint();
        }
    }

    class AbsolutePanel
    extends JPanel {
        JCheckBox absBox;
        JLabel absLabel1;
        JLabel absLabel2;

        AbsolutePanel() {
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.fill = 0;
            this.setLayout(gridbag);
            PavlidisTemplateInitBox.this.buildConstraints(constraints, 0, 0, 1, 2, 30, 0);
            this.absBox = new JCheckBox("Match to Absolute R?");
            gridbag.setConstraints(this.absBox, constraints);
            this.add(this.absBox);
            PavlidisTemplateInitBox.this.buildConstraints(constraints, 1, 0, 1, 1, 70, 50);
            this.absLabel1 = new JLabel("Yes: both +vely and -vely correlated expression profiles will be matched");
            constraints.anchor = 17;
            gridbag.setConstraints(this.absLabel1, constraints);
            this.add(this.absLabel1);
            PavlidisTemplateInitBox.this.buildConstraints(constraints, 1, 1, 1, 1, 0, 50);
            this.absLabel2 = new JLabel("No: only +vely correlated expression profiles will be matched");
            constraints.anchor = 18;
            gridbag.setConstraints(this.absLabel2, constraints);
            this.add(this.absLabel2);
        }
    }

    class ClusterSelector
    extends JPanel {
        JList clusterList;
        GraphCanvas profileDisplayPanel;
        JScrollPane listScrollPane;
        JButton selectButton;
        Vector clusterNames = new Vector();
        Vector geneDataInClusters;
        Vector averageClusterProfiles;
        JSplitPane clusterSplitPane;

        ClusterSelector() {
            if (PavlidisTemplateInitBox.this.clusters.size() == 0) {
                this.clusterNames.add("No clusters to show");
            } else {
                for (int i = 0; i < PavlidisTemplateInitBox.this.clusters.size(); ++i) {
                    this.clusterNames.add("Cluster " + (i + 1));
                }
                this.geneDataInClusters = new Vector();
                this.averageClusterProfiles = new Vector();
                for (int j = 0; j < PavlidisTemplateInitBox.this.clusters.size(); ++j) {
                    Vector currentCluster = (Vector)PavlidisTemplateInitBox.this.clusters.get(j);
                    for (int k = 0; k < currentCluster.size(); ++k) {
                        int index = (Integer)currentCluster.get(k);
                        Vector currentGene = PavlidisTemplateInitBox.this.getGene(index);
                        currentCluster.set(k, currentGene);
                    }
                    this.geneDataInClusters.add(currentCluster);
                    Vector meanOfCurrentCluster = this.getMeanProfile(currentCluster);
                    this.averageClusterProfiles.add(meanOfCurrentCluster);
                }
            }
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.setLayout(gridbag);
            this.clusterList = new JList(this.clusterNames);
            this.clusterList.setSelectionMode(0);
            this.clusterList.setSelectedIndex(0);
            this.profileDisplayPanel = new GraphCanvas();
            this.profileDisplayPanel.setGraphBounds(0.0, (double)PavlidisTemplateInitBox.this.sampleNamesVector.size(), -3.0, 3.0);
            this.profileDisplayPanel.setGraphSpacing(20, 20, 20, 20);
            this.profileDisplayPanel.setXAxisValue(0.0);
            this.profileDisplayPanel.setYAxisValue(0.0);
            this.clusterList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    ClusterSelector.this.refreshGraph();
                }
            });
            this.listScrollPane = new JScrollPane(this.clusterList);
            this.clusterSplitPane = new JSplitPane(1, this.listScrollPane, (Component)this.profileDisplayPanel);
            this.clusterSplitPane.setOneTouchExpandable(true);
            this.clusterSplitPane.setDividerLocation(200);
            Dimension minimumSize = new Dimension(100, 50);
            this.clusterList.setMinimumSize(minimumSize);
            this.profileDisplayPanel.setMinimumSize(minimumSize);
            PavlidisTemplateInitBox.this.buildConstraints(constraints, 0, 0, 1, 1, 1, 80);
            constraints.fill = 1;
            gridbag.setConstraints(this.clusterSplitPane, constraints);
            this.add(this.clusterSplitPane);
            PavlidisTemplateInitBox.this.buildConstraints(constraints, 0, 1, 1, 1, 0, 20);
            constraints.fill = 0;
            this.selectButton = new JButton("Select highlighted cluster from above list to use its mean as template");
            this.selectButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PavlidisTemplateInitBox.this.clusters.size() == 0) {
                        JOptionPane.showMessageDialog(null, "No clusters to select");
                    } else {
                        int i;
                        float min;
                        int index = ClusterSelector.this.clusterList.getSelectedIndex();
                        Vector expProfile = (Vector)((Vector)ClusterSelector.this.averageClusterProfiles.get(index)).clone();
                        float max = PavlidisTemplateInitBox.this.getMax(expProfile);
                        if (max - (min = PavlidisTemplateInitBox.this.getMin(expProfile)) == 0.0f) {
                            for (i = 0; i < expProfile.size(); ++i) {
                                expProfile.set(i, new Float(0.5));
                            }
                        } else {
                            for (i = 0; i < expProfile.size(); ++i) {
                                float f = (((Float)expProfile.get(i)).floatValue() - min) / (max - min);
                                expProfile.set(i, new Float(f));
                            }
                        }
                        for (i = 0; i < PavlidisTemplateInitBox.this.tempPanel.tempScr.tempGrid.length; ++i) {
                            PavlidisTemplateInitBox.this.tempPanel.tempScr.tempGrid[i].templateSlider.setValue((int)Math.floor(((Float)expProfile.get(i)).floatValue() * 100.0f));
                            PavlidisTemplateInitBox.this.tempPanel.tempScr.tempGrid[i].templateField.setText("" + ((Float)expProfile.get(i)).floatValue());
                        }
                    }
                }
            });
            gridbag.setConstraints(this.selectButton, constraints);
            this.add(this.selectButton);
            this.refreshGraph();
        }

        private void refreshGraph() {
            int i;
            int index = this.clusterList.getSelectedIndex();
            if (PavlidisTemplateInitBox.this.clusters.size() <= 0) {
                return;
            }
            Vector meanProfile = (Vector)this.averageClusterProfiles.elementAt(index);
            this.profileDisplayPanel.removeAllGraphElements();
            Vector selectedCluster = (Vector)this.geneDataInClusters.get(index);
            for (int j = 0; j < selectedCluster.size(); ++j) {
                int i2;
                Vector currGene = (Vector)selectedCluster.get(j);
                for (i2 = 0; i2 < currGene.size(); ++i2) {
                }
                for (i2 = 0; i2 < currGene.size() - 1; ++i2) {
                    if (Float.isNaN(((Float)currGene.elementAt(i2)).floatValue()) || Float.isNaN(((Float)currGene.elementAt(i2 + 1)).floatValue())) continue;
                    GraphLine gl = new GraphLine((double)i2, (double)((Float)currGene.elementAt(i2)).floatValue(), (double)(i2 + 1), (double)((Float)currGene.elementAt(i2 + 1)).floatValue(), PavlidisTemplateInitBox.this.clusterColors[index]);
                    this.profileDisplayPanel.addGraphElement((GraphElement)gl);
                }
            }
            for (i = 0; i < meanProfile.size(); ++i) {
                if (Float.isNaN(((Float)meanProfile.elementAt(i)).floatValue())) continue;
                GraphPoint gp = new GraphPoint((double)i, (double)((Float)meanProfile.elementAt(i)).floatValue(), Color.red, 5);
                this.profileDisplayPanel.addGraphElement((GraphElement)gp);
            }
            for (i = 0; i < meanProfile.size() - 1; ++i) {
                GraphLine gl = new GraphLine((double)i, (double)((Float)meanProfile.elementAt(i)).floatValue(), (double)(i + 1), (double)((Float)meanProfile.elementAt(i + 1)).floatValue(), Color.blue);
                this.profileDisplayPanel.addGraphElement((GraphElement)gl);
            }
            this.profileDisplayPanel.repaint();
        }

        Vector getMeanProfile(Vector genesInCluster) {
            Vector<Float> meanProfile = new Vector<Float>();
            float[][] geneMatrix = this.convertToFloatMatrix(genesInCluster);
            for (int i = 0; i < geneMatrix[0].length; ++i) {
                float sum = 0.0f;
                for (int j = 0; j < geneMatrix.length; ++j) {
                    if (Float.isNaN(geneMatrix[j][i])) continue;
                    sum += geneMatrix[j][i];
                }
                float mean = sum / (float)geneMatrix.length;
                meanProfile.add(new Float(mean));
            }
            return meanProfile;
        }

        float[][] convertToFloatMatrix(Vector geneCluster) {
            float[][] matrix = new float[geneCluster.size()][];
            for (int i = 0; i < geneCluster.size(); ++i) {
                Vector currentGene = (Vector)((Vector)geneCluster.get(i)).clone();
                matrix[i] = new float[currentGene.size()];
                for (int j = 0; j < currentGene.size(); ++j) {
                    matrix[i][j] = ((Float)currentGene.get(j)).floatValue();
                }
            }
            return matrix;
        }
    }

    class UniqueIDSelector
    extends JPanel {
        JList uniqueIDList;
        GraphCanvas profileDisplayPanel;
        JScrollPane listScrollPane;
        JButton selectButton;
        int maxIndex = -1;
        int minIndex = -1;
        JSplitPane uIDSplitPane;

        UniqueIDSelector() {
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.setLayout(gridbag);
            this.uniqueIDList = new JList(PavlidisTemplateInitBox.this.uniqueIDs);
            this.uniqueIDList.setSelectionMode(0);
            this.uniqueIDList.setSelectedIndex(0);
            this.profileDisplayPanel = new GraphCanvas();
            this.profileDisplayPanel.setGraphBounds(0.0, (double)PavlidisTemplateInitBox.this.sampleNamesVector.size(), -3.0, 3.0);
            this.profileDisplayPanel.setGraphSpacing(20, 20, 20, 20);
            this.profileDisplayPanel.setXAxisValue(0.0);
            this.profileDisplayPanel.setYAxisValue(0.0);
            this.uniqueIDList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    UniqueIDSelector.this.refreshGraph();
                }
            });
            this.listScrollPane = new JScrollPane(this.uniqueIDList);
            this.uIDSplitPane = new JSplitPane(1, this.listScrollPane, (Component)this.profileDisplayPanel);
            this.uIDSplitPane.setOneTouchExpandable(true);
            this.uIDSplitPane.setDividerLocation(200);
            Dimension minimumSize = new Dimension(100, 50);
            this.uniqueIDList.setMinimumSize(minimumSize);
            this.profileDisplayPanel.setMinimumSize(minimumSize);
            PavlidisTemplateInitBox.this.buildConstraints(constraints, 0, 0, 1, 1, 1, 80);
            constraints.fill = 1;
            gridbag.setConstraints(this.uIDSplitPane, constraints);
            this.add(this.uIDSplitPane);
            PavlidisTemplateInitBox.this.buildConstraints(constraints, 0, 1, 1, 1, 0, 20);
            constraints.fill = 0;
            constraints.anchor = 15;
            this.selectButton = new JButton("Select highlighted gene from above list to use as template");
            this.selectButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int i;
                    float min;
                    int index = UniqueIDSelector.this.uniqueIDList.getSelectedIndex();
                    Vector expProfile = PavlidisTemplateInitBox.this.getGene(index);
                    float max = PavlidisTemplateInitBox.this.getMax(expProfile);
                    if (max - (min = PavlidisTemplateInitBox.this.getMin(expProfile)) == 0.0f) {
                        for (i = 0; i < expProfile.size(); ++i) {
                            expProfile.set(i, new Float(0.5));
                        }
                    } else {
                        for (i = 0; i < expProfile.size(); ++i) {
                            float f = (((Float)expProfile.get(i)).floatValue() - min) / (max - min);
                            expProfile.set(i, new Float(f));
                        }
                    }
                    for (i = 0; i < PavlidisTemplateInitBox.this.tempPanel.tempScr.tempGrid.length; ++i) {
                        if (!Float.isNaN(((Float)expProfile.get(i)).floatValue())) {
                            PavlidisTemplateInitBox.this.tempPanel.tempScr.tempGrid[i].activeBox.setSelected(true);
                            PavlidisTemplateInitBox.this.tempPanel.tempScr.tempGrid[i].templateSlider.setEnabled(true);
                            PavlidisTemplateInitBox.this.tempPanel.tempScr.tempGrid[i].templateSlider.setValue((int)Math.floor(((Float)expProfile.get(i)).floatValue() * 100.0f));
                            PavlidisTemplateInitBox.this.tempPanel.tempScr.tempGrid[i].templateField.setEnabled(true);
                            PavlidisTemplateInitBox.this.tempPanel.tempScr.tempGrid[i].templateField.setBackground(Color.white);
                            PavlidisTemplateInitBox.this.tempPanel.tempScr.tempGrid[i].templateField.setText("" + ((Float)expProfile.get(i)).floatValue());
                            continue;
                        }
                        PavlidisTemplateInitBox.this.tempPanel.tempScr.tempGrid[i].activeBox.setSelected(false);
                        PavlidisTemplateInitBox.this.tempPanel.tempScr.tempGrid[i].templateSlider.setEnabled(false);
                        PavlidisTemplateInitBox.this.tempPanel.tempScr.tempGrid[i].templateField.setText("NULL");
                        PavlidisTemplateInitBox.this.tempPanel.tempScr.tempGrid[i].templateField.setBackground(Color.gray);
                        PavlidisTemplateInitBox.this.tempPanel.tempScr.tempGrid[i].templateField.setEnabled(false);
                    }
                }
            });
            gridbag.setConstraints(this.selectButton, constraints);
            this.add(this.selectButton);
            this.refreshGraph();
        }

        private void refreshGraph() {
            int i;
            int index = this.uniqueIDList.getSelectedIndex();
            Vector expProfile = PavlidisTemplateInitBox.this.getGene(index);
            float max = PavlidisTemplateInitBox.this.getMax(expProfile);
            float min = PavlidisTemplateInitBox.this.getMin(expProfile);
            this.profileDisplayPanel.removeAllGraphElements();
            for (i = 0; i < expProfile.size(); ++i) {
                if (Float.isNaN(((Float)expProfile.elementAt(i)).floatValue())) continue;
                GraphPoint gp = new GraphPoint((double)i, (double)((Float)expProfile.elementAt(i)).floatValue(), Color.red, 5);
                this.profileDisplayPanel.addGraphElement((GraphElement)gp);
            }
            for (i = 0; i < expProfile.size() - 1; ++i) {
                if (Float.isNaN(((Float)expProfile.elementAt(i)).floatValue()) || Float.isNaN(((Float)expProfile.elementAt(i + 1)).floatValue())) continue;
                GraphLine gl = new GraphLine((double)i, (double)((Float)expProfile.elementAt(i)).floatValue(), (double)(i + 1), (double)((Float)expProfile.elementAt(i + 1)).floatValue(), Color.blue);
                this.profileDisplayPanel.addGraphElement((GraphElement)gl);
            }
            this.profileDisplayPanel.repaint();
        }
    }
}

