/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ptm;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ptm.PTMSubCentroidViewer;

public class PTMSubCentroidsViewer
extends JPanel
implements IViewer {
    protected PTMSubCentroidViewer centroidViewer;

    public PTMSubCentroidsViewer(Experiment experiment, int[][] clusters, Vector templateVector) {
        this.centroidViewer = new PTMSubCentroidViewer(experiment, clusters, templateVector);
        this.setBackground(Color.white);
        this.setFont(new Font("monospaced", 1, 10));
    }

    public PTMSubCentroidsViewer(PTMSubCentroidViewer cv) {
        this.centroidViewer = cv;
        this.setBackground(Color.white);
        this.setFont(new Font("monospaced", 1, 10));
    }

    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{this.centroidViewer});
    }

    public void setExperiment(Experiment e) {
        this.centroidViewer.setExperiment(e);
    }

    public void setExperimentID(int i) {
        this.centroidViewer.setExperimentID(i);
    }

    public int getExperimentID() {
        return this.centroidViewer.getExperimentID();
    }

    public JComponent getContentComponent() {
        return this;
    }

    public JComponent getHeaderComponent() {
        return null;
    }

    public void onSelected(IFramework framework) {
        this.centroidViewer.setData(framework.getData());
        this.centroidViewer.setMode((Integer)framework.getUserObject());
        this.centroidViewer.setAntiAliasing(framework.getDisplayMenu().isAntiAliasing());
    }

    public void onDataChanged(IData data) {
        this.centroidViewer.setData(data);
    }

    public void setMeans(float[][] means) {
        this.centroidViewer.setMeans(means);
    }

    public void setVariances(float[][] variances) {
        this.centroidViewer.setVariances(variances);
    }

    public void setCodes(float[][] codes) {
        this.centroidViewer.setCodes(codes);
    }

    public Experiment getExperiment() {
        return this.centroidViewer.getExperiment();
    }

    protected IData getData() {
        return this.centroidViewer.getData();
    }

    public int[][] getClusters() {
        return this.centroidViewer.getClusters();
    }

    public void onMenuChanged(IDisplayMenu menu) {
        this.centroidViewer.onMenuChanged(menu);
    }

    public void onDeselected() {
    }

    public void onClosed() {
    }

    public BufferedImage getImage() {
        return null;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        int gap = 10;
        int imagesX = (int)Math.ceil(Math.sqrt(this.getClusters().length));
        int imagesY = (int)Math.ceil((float)this.getClusters().length / (float)imagesX);
        float stepX = (float)(this.getWidth() - 10) / (float)imagesX;
        float stepY = (float)(this.getHeight() - 10) / (float)imagesY;
        Rectangle rect = new Rectangle();
        for (int y = 0; y < imagesY; ++y) {
            int cluster;
            for (int x = 0; x < imagesX && (cluster = y * imagesX + x) < this.getClusters().length; ++x) {
                this.centroidViewer.setClusterIndex(cluster);
                rect.setBounds(Math.round(10.0f + (float)x * stepX), Math.round(10.0f + (float)y * stepY), Math.round(stepX - 10.0f), Math.round(stepY - 10.0f));
                this.centroidViewer.paint((Graphics2D)g, rect, false);
            }
        }
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public JComponent getCornerComponent(int cornerIndex) {
        return null;
    }

    public int getViewerType() {
        return this.centroidViewer.getViewerType();
    }
}

