/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ptm;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.Vector;
import org.tigr.microarray.mev.cluster.ClusterWrapper;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidViewer;

public class PTMSubCentroidViewer
extends CentroidViewer {
    Vector templateVector;

    public PTMSubCentroidViewer(Experiment experiment, int[][] clusters, Vector templateVector) {
        super(experiment, clusters);
        this.templateVector = templateVector;
    }

    public PTMSubCentroidViewer(Experiment e, ClusterWrapper clusters, float[][] variances, float[][] means, float[][] codes) {
        this(e, clusters.getClusters(), variances, means, codes);
    }

    public PTMSubCentroidViewer(Experiment e, int[][] clusters, float[][] variances, float[][] means, float[][] codes) {
        super(e, clusters, variances, means, codes);
    }

    public void paint(Graphics g) {
        FontMetrics metrics = g.getFontMetrics();
        Rectangle rect = new Rectangle(40, 20, this.getWidth() - 80, this.getHeight() - 40 - this.getNamesWidth(metrics));
        this.paint((Graphics2D)g, rect, true);
    }

    public void paint(Graphics2D g, Rectangle rect, boolean drawMarks) {
        int i;
        int i2;
        super.subPaint(g, rect, drawMarks);
        if (this.isAntiAliasing) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        int left = rect.x;
        int top = rect.y;
        int width = rect.width;
        int height = rect.height;
        if (width < 5 || height < 5) {
            return;
        }
        int zeroValue = top + Math.round((float)height / 2.0f);
        int numberOfSamples = this.experiment.getNumberOfSamples();
        if (this.yRangeOption == CentroidViewer.USE_EXPERIMENT_MAX) {
            this.maxYValue = this.maxExperimentValue;
        } else if (this.yRangeOption == CentroidViewer.USE_CLUSTER_MAX) {
            this.maxYValue = this.maxClusterValue;
        }
        if (this.maxYValue == 0.0f) {
            this.maxYValue = 1.0f;
        }
        if (this.maxYValue == 0.0f) {
            this.maxYValue = 1.0f;
        }
        float factor = (float)height / (2.0f * this.maxYValue);
        float stepX = (float)width / (float)(numberOfSamples - 1);
        int stepsY = (int)this.maxYValue + 1;
        if (this.drawVariances) {
            g.setColor(bColor);
            for (i2 = 0; i2 < numberOfSamples; ++i2) {
                if (Float.isNaN(this.means[this.clusterIndex][i2]) || Float.isNaN(this.variances[this.clusterIndex][i2]) || this.variances[this.clusterIndex][i2] < 0.0f) continue;
                g.drawLine(left + Math.round((float)i2 * stepX), zeroValue - Math.round((this.means[this.clusterIndex][i2] - this.variances[this.clusterIndex][i2]) * factor), left + Math.round((float)i2 * stepX), zeroValue - Math.round((this.means[this.clusterIndex][i2] + this.variances[this.clusterIndex][i2]) * factor));
                g.drawLine(left + Math.round((float)i2 * stepX) - 3, zeroValue - Math.round((this.means[this.clusterIndex][i2] - this.variances[this.clusterIndex][i2]) * factor), left + Math.round((float)i2 * stepX) + 3, zeroValue - Math.round((this.means[this.clusterIndex][i2] - this.variances[this.clusterIndex][i2]) * factor));
                g.drawLine(left + Math.round((float)i2 * stepX) - 3, zeroValue - Math.round((this.means[this.clusterIndex][i2] + this.variances[this.clusterIndex][i2]) * factor), left + Math.round((float)i2 * stepX) + 3, zeroValue - Math.round((this.means[this.clusterIndex][i2] + this.variances[this.clusterIndex][i2]) * factor));
            }
        }
        if (this.drawValues) {
            for (int sample = 0; sample < numberOfSamples - 1; ++sample) {
                for (int probe = 0; probe < this.getCluster().length; ++probe) {
                    float fValue = this.experiment.get(this.getProbe(probe), sample);
                    float sValue = this.experiment.get(this.getProbe(probe), sample + 1);
                    if (Float.isNaN(fValue) || Float.isNaN(sValue)) continue;
                    Color color = this.data.getProbeColor(this.experiment.getGeneIndexMappedToData(this.getProbe(probe)));
                    color = color == null ? DEF_CLUSTER_COLOR : color;
                    g.setColor(color);
                    g.drawLine(left + Math.round((float)sample * stepX), zeroValue - Math.round(fValue * factor), left + Math.round((float)(sample + 1) * stepX), zeroValue - Math.round(sValue * factor));
                }
            }
        }
        if (this.drawCodes && this.codes != null && this.clusters[this.clusterIndex].length > 0) {
            g.setColor(Color.gray);
            for (i2 = 0; i2 < numberOfSamples - 1; ++i2) {
                g.drawLine(left + Math.round((float)i2 * stepX), zeroValue - Math.round(this.codes[this.clusterIndex][i2] * factor), left + Math.round((float)(i2 + 1) * stepX), zeroValue - Math.round(this.codes[this.clusterIndex][i2 + 1] * factor));
            }
        }
        g.setColor(Color.black);
        g.drawLine(left, zeroValue, left + width, zeroValue);
        if (this.getCluster() != null && this.getCluster().length > 0) {
            g.setColor(Color.magenta);
            for (i2 = 0; i2 < numberOfSamples - 1; ++i2) {
                if (Float.isNaN(this.means[this.clusterIndex][i2]) || Float.isNaN(this.means[this.clusterIndex][i2 + 1])) continue;
                g.drawLine(left + Math.round((float)i2 * stepX), zeroValue - Math.round(this.means[this.clusterIndex][i2] * factor), left + Math.round((float)(i2 + 1) * stepX), zeroValue - Math.round(this.means[this.clusterIndex][i2 + 1] * factor));
            }
        }
        float[] templateArray = new float[this.templateVector.size()];
        for (i = 0; i < templateArray.length; ++i) {
            templateArray[i] = ((Float)this.templateVector.get(i)).floatValue();
        }
        for (i = 0; i < templateArray.length; ++i) {
            templateArray[i] = templateArray[i] - 0.5f;
        }
        for (i = 0; i < numberOfSamples - 1; ++i) {
            g.setColor(Color.red);
            if (!Float.isNaN(templateArray[i])) {
                g.fillOval(left + Math.round((float)i * stepX) - 2, zeroValue - Math.round(templateArray[i] * factor) - 2, 5, 5);
            }
            if (!Float.isNaN(templateArray[i + 1])) {
                g.fillOval(left + Math.round((float)(i + 1) * stepX) - 2, zeroValue - Math.round(templateArray[i + 1] * factor) - 2, 5, 5);
            }
            if (Float.isNaN(templateArray[i]) || Float.isNaN(templateArray[i + 1])) continue;
            g.setColor(Color.blue);
            g.drawLine(left + Math.round((float)i * stepX), zeroValue - Math.round(templateArray[i] * factor), left + Math.round((float)(i + 1) * stepX), zeroValue - Math.round(templateArray[i + 1] * factor));
        }
        g.setColor(Color.black);
        g.drawRect(left, top, width, height);
        for (i = 1; i < numberOfSamples - 1; ++i) {
            g.drawLine(left + Math.round((float)i * stepX), top + height - 5, left + Math.round((float)i * stepX), top + height);
        }
        for (i = 1; i < stepsY; ++i) {
            g.drawLine(left, zeroValue - Math.round((float)i * factor), left + 5, zeroValue - Math.round((float)i * factor));
            g.drawLine(left, zeroValue + Math.round((float)i * factor), left + 5, zeroValue + Math.round((float)i * factor));
        }
        g.setColor(bColor);
        if (drawMarks) {
            FontMetrics metrics = g.getFontMetrics();
            for (int i3 = 1; i3 < stepsY; ++i3) {
                String str = String.valueOf(i3);
                int strWidth = metrics.stringWidth(str);
                g.drawString(str, left - 10 - strWidth, zeroValue + 5 - Math.round((float)i3 * factor));
                str = String.valueOf(-i3);
                strWidth = metrics.stringWidth(str);
                g.drawString(str, left - 10 - strWidth, zeroValue + 5 + Math.round((float)i3 * factor));
            }
            g.rotate(-1.5707963267948966);
            int max_name_width = this.getNamesWidth(metrics);
            for (int i4 = 0; i4 < numberOfSamples; ++i4) {
                g.drawString(this.data.getSampleName(this.experiment.getSampleIndex(i4)), -height - top - 10 - max_name_width, left + Math.round((float)i4 * stepX) + 3);
            }
            g.rotate(1.5707963267948966);
        }
        if (this.getCluster() != null && this.getCluster().length > 0 && this.drawVariances) {
            g.setColor(bColor);
            for (int i5 = 0; i5 < numberOfSamples; ++i5) {
                if (Float.isNaN(this.means[this.clusterIndex][i5])) continue;
                g.fillOval(left + Math.round((float)i5 * stepX) - 3, zeroValue - Math.round(this.means[this.clusterIndex][i5] * factor) - 3, 6, 6);
            }
        }
        g.setColor(bColor);
        if (this.getCluster() == null || this.getCluster().length == 0) {
            g.drawString("No Genes", left + 10, top + 20);
        } else {
            g.drawString(this.getCluster().length + " Genes", left + 10, top + 20);
        }
    }
}

