/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ptm;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.tigr.graph.GraphCanvas;
import org.tigr.graph.GraphElement;
import org.tigr.graph.GraphLine;
import org.tigr.graph.GraphPoint;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.util.FloatMatrix;

public class PTMInitDialog
extends AlgorithmDialog {
    String[] SampleNames;
    Vector sampleNamesVector;
    Vector uniqueIDs;
    Vector clusters;
    Vector expClusters;
    Color[] clusterColors;
    Color[] expClusterColors;
    GeneSelector geneSelectPanel;
    GeneClusterSelector geneClusterSelectPanel;
    ExperimentSelector expSelectPanel;
    ExperimentClusterSelector clusterSelectPanel;
    SavedTemplateSelector templateSelectPanel;
    TemplatePanel tempPanel;
    ThresholdPanel thresh;
    FloatMatrix expMatrix;
    JCheckBox drawTreesBox;
    private JRadioButton sigOnly;
    private JRadioButton allClusters;
    JPanel drawTreesPane;
    JTabbedPane tabbedPane;
    JButton saveTemplateButton;
    Vector template = new Vector();
    FloatMatrix templateMatrix;
    boolean setTemplate = false;
    boolean clusterGenes = true;
    int numberOfExperiments;
    private boolean okPressed = false;

    public PTMInitDialog(JFrame parentFrame, boolean modality, FloatMatrix expMatrix, Vector uniqueIDs, Vector sampleNamesVector, Vector clusters, Vector expClusters, Color[] clusterColors, Color[] expClusterColors) {
        super(parentFrame, "PTM: Pavlidis Template Matching", modality);
        this.expMatrix = expMatrix;
        this.numberOfExperiments = expMatrix.getColumnDimension();
        this.uniqueIDs = uniqueIDs;
        this.sampleNamesVector = sampleNamesVector;
        this.clusters = clusters;
        this.clusterColors = clusterColors;
        this.expClusters = expClusters;
        this.expClusterColors = expClusterColors;
        this.SampleNames = this.getSampleNames();
        this.setBounds(0, 0, 890, 700);
        this.setSize(890, 700);
        this.setDefaultCloseOperation(2);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        JPanel pane = new JPanel();
        pane.setLayout(gridbag);
        this.buildConstraints(constraints, 0, 0, 2, 1, 0, 10);
        this.tabbedPane = new JTabbedPane();
        this.geneSelectPanel = new GeneSelector();
        this.geneClusterSelectPanel = new GeneClusterSelector();
        this.expSelectPanel = new ExperimentSelector();
        this.clusterSelectPanel = new ExperimentClusterSelector();
        this.templateSelectPanel = new SavedTemplateSelector();
        this.tabbedPane.addTab("Gene Templates", this.geneSelectPanel);
        this.tabbedPane.addTab("Gene Cluster Templates", this.geneClusterSelectPanel);
        this.tabbedPane.addTab("Sample Templates", this.expSelectPanel);
        this.tabbedPane.addTab("Sample Cluster Templates", this.clusterSelectPanel);
        this.tabbedPane.addTab("Select a Saved Template", this.templateSelectPanel);
        this.tabbedPane.setSelectedIndex(0);
        gridbag.setConstraints(this.tabbedPane, constraints);
        pane.add(this.tabbedPane);
        this.buildConstraints(constraints, 0, 1, 2, 1, 0, 10);
        this.tempPanel = new TemplatePanel();
        this.tempPanel.setPreferredSize(new Dimension(80, 400));
        gridbag.setConstraints(this.tempPanel, constraints);
        pane.add(this.tempPanel);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                int index = PTMInitDialog.this.tabbedPane.getSelectedIndex();
                if (index > 1) {
                    PTMInitDialog.this.tempPanel.setEnabled(false);
                    PTMInitDialog.this.tempPanel.setVisible(false);
                } else {
                    PTMInitDialog.this.tempPanel.setEnabled(true);
                    PTMInitDialog.this.tempPanel.setVisible(true);
                }
            }
        });
        this.buildConstraints(constraints, 0, 2, 1, 1, 20, 0);
        this.thresh = new ThresholdPanel();
        gridbag.setConstraints(this.thresh, constraints);
        pane.add(this.thresh);
        this.buildConstraints(constraints, 1, 2, 1, 1, 5, 0);
        this.drawTreesPane = new JPanel();
        this.drawTreesPane.setLayout(new GridBagLayout());
        this.drawTreesBox = new JCheckBox("Construct Hierarchical Trees for:");
        this.drawTreesBox.setFocusPainted(false);
        this.sigOnly = new JRadioButton("Matched genes only", true);
        this.allClusters = new JRadioButton("All clusters", false);
        this.sigOnly.setEnabled(false);
        this.allClusters.setEnabled(false);
        ButtonGroup allOrSig = new ButtonGroup();
        allOrSig.add(this.sigOnly);
        allOrSig.add(this.allClusters);
        this.saveTemplateButton = new JButton("Save Current Template", GUIFactory.getIcon("save16.gif"));
        this.saveTemplateButton.setToolTipText("Saves template to file");
        this.saveTemplateButton.setFocusPainted(false);
        this.saveTemplateButton.setActionCommand("save-template-to-file-command");
        this.saveTemplateButton.setBorder(BorderFactory.createBevelBorder(0));
        this.saveTemplateButton.setMargin(new Insets(2, 50, 2, 5));
        this.saveTemplateButton.setPreferredSize(new Dimension(175, 30));
        this.saveTemplateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (evt.getSource() == PTMInitDialog.this.saveTemplateButton) {
                    JFileChooser fc;
                    int returnVal;
                    String dataPath = TMEV.getDataPath();
                    File fileLoc = TMEV.getFile((String)"data/");
                    if (dataPath != null && !(fileLoc = new File(dataPath)).exists()) {
                        fileLoc = TMEV.getFile((String)"data/");
                    }
                    if ((returnVal = (fc = new JFileChooser(fileLoc)).showSaveDialog(PTMInitDialog.this)) == 0) {
                        File file = fc.getSelectedFile();
                        try {
                            BufferedWriter bw = new BufferedWriter(new FileWriter(file.getPath()));
                            if (PTMInitDialog.this.tabbedPane.getSelectedIndex() < 2) {
                                for (int i = 0; i < PTMInitDialog.this.tempPanel.tempScr.tempGrid.length; ++i) {
                                    String s = PTMInitDialog.this.tempPanel.tempScr.tempGrid[i].templateField.getText();
                                    float f = Float.parseFloat(s);
                                    bw.write(Float.toString(f) + "\n");
                                }
                            } else {
                                for (int i = 0; i < PTMInitDialog.this.template.size(); ++i) {
                                    bw.write(((Float)PTMInitDialog.this.template.elementAt(i)).toString() + "\n");
                                }
                            }
                            bw.flush();
                            bw.close();
                        }
                        catch (IOException e) {
                            System.out.println("Error: " + e.toString());
                        }
                    }
                }
            }
        });
        this.drawTreesBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    PTMInitDialog.this.sigOnly.setEnabled(false);
                    PTMInitDialog.this.allClusters.setEnabled(false);
                } else {
                    PTMInitDialog.this.sigOnly.setEnabled(true);
                    PTMInitDialog.this.allClusters.setEnabled(true);
                }
            }
        });
        this.drawTreesPane.add((Component)this.saveTemplateButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 30, 0, 20), 0, 0));
        this.drawTreesPane.add((Component)this.drawTreesBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 30, 0, 20), 0, 0));
        this.drawTreesPane.add((Component)this.sigOnly, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 30, 0, 20), 0, 0));
        this.drawTreesPane.add((Component)this.allClusters, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 30, 0, 20), 0, 0));
        constraints.anchor = 10;
        gridbag.setConstraints(this.drawTreesPane, constraints);
        this.buildConstraints(constraints, 1, 2, 1, 1, 80, 0);
        gridbag.setConstraints(this.drawTreesPane, constraints);
        pane.add(this.drawTreesPane);
        this.addContent(pane);
        this.setActionListeners(new EventListener());
    }

    @Override
    public void setVisible(boolean visible) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        super.setVisible(visible);
    }

    public boolean isGeneTemplate() {
        return this.clusterGenes;
    }

    void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    String[] getSampleNames() {
        String[] SampleNames = new String[this.sampleNamesVector.size()];
        for (int i = 0; i < this.sampleNamesVector.size(); ++i) {
            SampleNames[i] = (String)this.sampleNamesVector.get(i);
        }
        return SampleNames;
    }

    Vector getMeanProfile(Vector expInCluster) {
        Vector<Float> meanProfile = new Vector<Float>();
        if (expInCluster.size() == 0) {
            Vector<Float> v = new Vector<Float>(this.numberOfExperiments);
            for (int i = 0; i < this.numberOfExperiments; ++i) {
                v.add(new Float(Float.NaN));
            }
            return v;
        }
        float[][] expMatrix = this.convertToFloatMatrix(expInCluster);
        int n = 0;
        for (int i = 0; i < expMatrix[0].length; ++i) {
            float sum = 0.0f;
            n = 0;
            for (int j = 0; j < expMatrix.length; ++j) {
                if (Float.isNaN(expMatrix[j][i])) continue;
                sum += expMatrix[j][i];
                ++n;
            }
            float mean = n > 0 ? sum / (float)n : 0.0f;
            meanProfile.add(new Float(mean));
        }
        return meanProfile;
    }

    float[][] convertToFloatMatrix(Vector geneCluster) {
        float[][] matrix = new float[geneCluster.size()][];
        for (int i = 0; i < geneCluster.size(); ++i) {
            Vector currentGene = (Vector)((Vector)geneCluster.get(i)).clone();
            matrix[i] = new float[currentGene.size()];
            for (int j = 0; j < currentGene.size(); ++j) {
                matrix[i][j] = ((Float)currentGene.get(j)).floatValue();
            }
        }
        return matrix;
    }

    private Vector getExperiment(int index) {
        Vector<Float> exp = new Vector<Float>();
        int rows = this.expMatrix.getRowDimension();
        for (int i = 0; i < rows; ++i) {
            exp.add(new Float(this.expMatrix.get(i, index)));
        }
        return exp;
    }

    private float getMax(Vector element) {
        float max = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < element.size(); ++i) {
            float current;
            if (Float.isNaN(((Float)element.get(i)).floatValue()) || !((current = ((Float)element.get(i)).floatValue()) > max)) continue;
            max = current;
        }
        return max;
    }

    private float getMin(Vector element) {
        float min = Float.MAX_VALUE;
        for (int i = 0; i < element.size(); ++i) {
            float current;
            if (Float.isNaN(((Float)element.get(i)).floatValue()) || !((current = ((Float)element.get(i)).floatValue()) < min)) continue;
            min = current;
        }
        return min;
    }

    public Vector getTemplate() {
        Vector<Float> geneTemplate = new Vector<Float>();
        int paneIndex = this.tabbedPane.getSelectedIndex();
        if (paneIndex == 0 || paneIndex == 1 || paneIndex == 4 && this.tempPanel.isVisible()) {
            int numExp = this.expMatrix.getColumnDimension();
            for (int i = 0; i < numExp; ++i) {
                String s = this.tempPanel.tempScr.tempGrid[i].templateField.getText();
                if (s.equals("NaN") || s.equals("NULL") || !this.tempPanel.tempScr.tempGrid[i].activeBox.isSelected()) {
                    geneTemplate.add(new Float(Float.NaN));
                    continue;
                }
                geneTemplate.add(new Float(s));
            }
            return geneTemplate;
        }
        return this.template;
    }

    public FloatMatrix convertTemplateVectorToFloatMatrix() {
        this.template = this.getTemplate();
        FloatMatrix templateMatrix = new FloatMatrix(1, this.template.size());
        for (int i = 0; i < this.template.size(); ++i) {
            templateMatrix.A[0][i] = ((Float)this.template.get(i)).floatValue();
        }
        return templateMatrix;
    }

    protected void fireOkButtonEvent() {
        this.templateMatrix = this.convertTemplateVectorToFloatMatrix();
        boolean absoluteSelected = this.thresh.useAbsolute.isSelected();
        boolean drawTreesSelected = this.drawTreesBox.isSelected();
        boolean rSelected = this.thresh.chooseR.isSelected();
        String s = this.thresh.threshInputField.getText();
        double threshR = Double.parseDouble(s);
        Hashtable<String, Serializable> hash = new Hashtable<String, Serializable>();
        hash.put(new String("drawTrees"), new Boolean(drawTreesSelected));
        hash.put(new String("useAbsolute"), new Boolean(absoluteSelected));
        hash.put(new String("useR"), new Boolean(rSelected));
        hash.put(new String("template"), this.getTemplate());
        hash.put(new String("thresholdR"), new Double(threshR));
    }

    public boolean isDrawTrees() {
        return this.drawTreesBox.isSelected();
    }

    public boolean drawSigTreesOnly() {
        return this.sigOnly.isSelected();
    }

    public boolean isUseAbsolute() {
        return this.thresh.useAbsolute.isSelected();
    }

    public boolean isUseR() {
        return this.thresh.chooseR.isSelected();
    }

    public FloatMatrix getTemplateMatrix() {
        return this.convertTemplateVectorToFloatMatrix();
    }

    public double getThresholdR() {
        return Double.parseDouble(this.thresh.threshInputField.getText());
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    private Vector getGene(int index) {
        Vector<Float> gene = new Vector<Float>();
        for (int i = 0; i < this.sampleNamesVector.size(); ++i) {
            gene.add(new Float(this.expMatrix.get(index, i)));
        }
        return gene;
    }

    public static void main(String[] args) {
        int i;
        FloatMatrix expMatrix = new FloatMatrix(100, 10);
        Vector<String> uniqueIDs = new Vector<String>();
        Vector<String> sampleNamesVector = new Vector<String>();
        Color[] colors = null;
        for (i = 0; i < 100; ++i) {
            uniqueIDs.add(String.valueOf(i));
        }
        for (i = 0; i < 10; ++i) {
            sampleNamesVector.add("Exp " + String.valueOf(i));
        }
        PTMInitDialog box = new PTMInitDialog(new JFrame(), true, expMatrix, uniqueIDs, sampleNamesVector, new Vector(), new Vector(), colors, colors);
        box.setVisible(true);
        System.exit(0);
    }

    class TemplateElementGrid
    extends JPanel {
        JLabel exptName;
        JTextField templateField;
        JSlider templateSlider;
        JCheckBox activeBox;

        TemplateElementGrid(String SampleName) {
            GridBagLayout templateElement = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.fill = 1;
            this.setLayout(templateElement);
            PTMInitDialog.this.buildConstraints(constraints, 0, 0, 1, 1, 50, 10);
            this.exptName = new JLabel(SampleName, 0);
            templateElement.setConstraints(this.exptName, constraints);
            this.add(this.exptName);
            PTMInitDialog.this.buildConstraints(constraints, 1, 0, 1, 1, 50, 0);
            this.activeBox = new JCheckBox();
            this.activeBox.setSelected(true);
            this.activeBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 2) {
                        TemplateElementGrid.this.templateField.setBackground(Color.gray);
                        TemplateElementGrid.this.templateField.setEnabled(false);
                        TemplateElementGrid.this.templateSlider.setEnabled(false);
                    }
                    if (e.getStateChange() == 1) {
                        TemplateElementGrid.this.templateField.setBackground(Color.white);
                        TemplateElementGrid.this.templateField.setEnabled(true);
                        TemplateElementGrid.this.templateSlider.setEnabled(true);
                    }
                }
            });
            templateElement.setConstraints(this.activeBox, constraints);
            this.add(this.activeBox);
            PTMInitDialog.this.buildConstraints(constraints, 0, 1, 2, 1, 0, 5);
            this.templateField = new JTextField("0.5", 4);
            this.templateField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() == TemplateElementGrid.this.templateField) {
                        int sliderValue;
                        try {
                            String s = TemplateElementGrid.this.templateField.getText();
                            double d = Double.parseDouble(s);
                            sliderValue = (int)Math.floor(d * 100.0);
                            if (d > 1.0 || d < 0.0) {
                                sliderValue = 50;
                                TemplateElementGrid.this.templateField.setText("0.5");
                                JOptionPane.showMessageDialog(null, "Template values must be between 0 and 1 (inclusive)");
                            }
                        }
                        catch (Exception exc) {
                            TemplateElementGrid.this.templateField.setText("0.5");
                            sliderValue = 50;
                            JOptionPane.showMessageDialog(null, "Template values must be between 0 and 1 (inclusive)");
                        }
                        TemplateElementGrid.this.templateSlider.setValue(sliderValue);
                    }
                }
            });
            this.templateField.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (e.getSource() == TemplateElementGrid.this.templateField) {
                        int sliderValue;
                        try {
                            String s = TemplateElementGrid.this.templateField.getText();
                            double d = Double.parseDouble(s);
                            sliderValue = (int)Math.floor(d * 100.0);
                            if (d > 1.0 || d < 0.0) {
                                sliderValue = 50;
                                TemplateElementGrid.this.templateField.setText("0.5");
                                JOptionPane.showMessageDialog(null, "Template values must be between 0 and 1 (inclusive)");
                            }
                        }
                        catch (Exception exc) {
                            TemplateElementGrid.this.templateField.setText("0.5");
                            sliderValue = 50;
                            JOptionPane.showMessageDialog(null, "Input Format Error: Template values must be between 0 and 1 (inclusive)");
                        }
                        TemplateElementGrid.this.templateSlider.setValue(sliderValue);
                    }
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
            templateElement.setConstraints(this.templateField, constraints);
            this.add(this.templateField);
            PTMInitDialog.this.buildConstraints(constraints, 0, 2, 1, 2, 0, 85);
            this.templateSlider = new JSlider(1, 0, 100, 50);
            this.templateSlider.setMajorTickSpacing(20);
            this.templateSlider.setMinorTickSpacing(10);
            Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
            labelTable.put(new Integer(0), new JLabel("Min"));
            labelTable.put(new Integer(100), new JLabel("Max"));
            this.templateSlider.setLabelTable(labelTable);
            this.templateSlider.setPaintLabels(true);
            this.templateSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    JSlider source = (JSlider)e.getSource();
                    if (!source.getValueIsAdjusting()) {
                        int value = source.getValue();
                        if (value == 100) {
                            TemplateElementGrid.this.templateField.setText("1.0");
                        } else if (value > 0 && value < 10) {
                            TemplateElementGrid.this.templateField.setText("0.0" + value);
                        } else {
                            TemplateElementGrid.this.templateField.setText("0." + value);
                        }
                    }
                }
            });
            templateElement.setConstraints(this.templateSlider, constraints);
            this.add(this.templateSlider);
        }

        public void reset() {
            this.templateSlider.setValue(50);
            this.templateField.setText("0.5");
        }
    }

    class GeneClusterSelector
    extends JPanel {
        JList clusterList;
        GraphCanvas profileDisplayPanel;
        JScrollPane listScrollPane;
        JButton selectButton;
        Vector clusterNames = new Vector();
        Vector geneDataInClusters;
        Vector averageClusterProfiles;
        JSplitPane clusterSplitPane;

        GeneClusterSelector() {
            if (PTMInitDialog.this.clusters.size() == 0) {
                this.clusterNames.add("No clusters to show");
            } else {
                for (int i = 0; i < PTMInitDialog.this.clusters.size(); ++i) {
                    this.clusterNames.add("Cluster " + (i + 1));
                }
                this.geneDataInClusters = new Vector();
                this.averageClusterProfiles = new Vector();
                for (int j = 0; j < PTMInitDialog.this.clusters.size(); ++j) {
                    Vector currentCluster = (Vector)PTMInitDialog.this.clusters.get(j);
                    for (int k = 0; k < currentCluster.size(); ++k) {
                        int index = (Integer)currentCluster.get(k);
                        Vector currentGene = PTMInitDialog.this.getGene(index);
                        currentCluster.set(k, currentGene);
                    }
                    this.geneDataInClusters.add(currentCluster);
                    Vector meanOfCurrentCluster = PTMInitDialog.this.getMeanProfile(currentCluster);
                    this.averageClusterProfiles.add(meanOfCurrentCluster);
                }
            }
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.setLayout(gridbag);
            this.clusterList = new JList(this.clusterNames);
            this.clusterList.setSelectionMode(0);
            this.clusterList.setSelectedIndex(0);
            this.profileDisplayPanel = new GraphCanvas();
            this.profileDisplayPanel.setGraphBounds(0.0, (double)PTMInitDialog.this.sampleNamesVector.size(), -3.0, 3.0);
            this.profileDisplayPanel.setGraphSpacing(20, 20, 20, 20);
            this.profileDisplayPanel.setXAxisValue(0.0);
            this.profileDisplayPanel.setYAxisValue(0.0);
            this.clusterList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    GeneClusterSelector.this.refreshGraph();
                }
            });
            this.listScrollPane = new JScrollPane(this.clusterList);
            this.clusterSplitPane = new JSplitPane(1, this.listScrollPane, (Component)this.profileDisplayPanel);
            this.clusterSplitPane.setOneTouchExpandable(true);
            this.clusterSplitPane.setDividerLocation(200);
            Dimension minimumSize = new Dimension(100, 50);
            this.clusterList.setMinimumSize(minimumSize);
            this.profileDisplayPanel.setMinimumSize(minimumSize);
            PTMInitDialog.this.buildConstraints(constraints, 0, 0, 1, 1, 1, 80);
            constraints.fill = 1;
            gridbag.setConstraints(this.clusterSplitPane, constraints);
            this.add(this.clusterSplitPane);
            PTMInitDialog.this.buildConstraints(constraints, 0, 1, 1, 1, 0, 20);
            constraints.fill = 0;
            this.selectButton = new JButton("Select highlighted cluster from above list to use its mean as template", GUIFactory.getIcon("select_check24.gif"));
            this.selectButton.setBorder(BorderFactory.createBevelBorder(0));
            this.selectButton.setMargin(new Insets(10, 10, 10, 10));
            this.selectButton.setPreferredSize(new Dimension(430, 30));
            this.selectButton.setFocusPainted(false);
            this.selectButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PTMInitDialog.this.clusters.size() == 0) {
                        JOptionPane.showMessageDialog(null, "No clusters to select");
                    } else {
                        int i;
                        float min;
                        int index = GeneClusterSelector.this.clusterList.getSelectedIndex();
                        Vector expProfile = (Vector)((Vector)GeneClusterSelector.this.averageClusterProfiles.get(index)).clone();
                        float max = PTMInitDialog.this.getMax(expProfile);
                        if (max - (min = PTMInitDialog.this.getMin(expProfile)) == 0.0f) {
                            for (i = 0; i < expProfile.size(); ++i) {
                                expProfile.set(i, new Float(0.5));
                            }
                        } else {
                            for (i = 0; i < expProfile.size(); ++i) {
                                float f = (((Float)expProfile.get(i)).floatValue() - min) / (max - min);
                                expProfile.set(i, new Float(f));
                            }
                        }
                        for (i = 0; i < PTMInitDialog.this.tempPanel.tempScr.tempGrid.length; ++i) {
                            PTMInitDialog.this.tempPanel.tempScr.tempGrid[i].templateSlider.setValue((int)Math.floor(((Float)expProfile.get(i)).floatValue() * 100.0f));
                            PTMInitDialog.this.tempPanel.tempScr.tempGrid[i].templateField.setText("" + ((Float)expProfile.get(i)).floatValue());
                        }
                        if (PTMInitDialog.this.setTemplate) {
                            for (i = 0; i < expProfile.size() - 1; ++i) {
                                if (Float.isNaN(((Float)expProfile.elementAt(i)).floatValue()) || Float.isNaN(((Float)expProfile.elementAt(i + 1)).floatValue())) continue;
                                GraphLine gl = new GraphLine((double)i, (double)((Float)expProfile.elementAt(i)).floatValue(), (double)(i + 1), (double)((Float)expProfile.elementAt(i + 1)).floatValue(), Color.green);
                                GeneClusterSelector.this.profileDisplayPanel.addGraphElement((GraphElement)gl);
                            }
                        }
                        PTMInitDialog.this.template = expProfile;
                        PTMInitDialog.this.setTemplate = true;
                        PTMInitDialog.this.clusterGenes = true;
                        PTMInitDialog.this.okButton.setEnabled(true);
                    }
                }
            });
            gridbag.setConstraints(this.selectButton, constraints);
            this.add(this.selectButton);
            this.refreshGraph();
        }

        private void refreshGraph() {
            int i;
            int index = this.clusterList.getSelectedIndex();
            if (PTMInitDialog.this.clusters.size() <= 0) {
                return;
            }
            Vector meanProfile = (Vector)this.averageClusterProfiles.elementAt(index);
            float min = Float.POSITIVE_INFINITY;
            float max = Float.NEGATIVE_INFINITY;
            this.profileDisplayPanel.removeAllGraphElements();
            Vector selectedCluster = (Vector)this.geneDataInClusters.get(index);
            for (int j = 0; j < selectedCluster.size(); ++j) {
                int i2;
                Vector currGene = (Vector)selectedCluster.get(j);
                max = Math.max(max, PTMInitDialog.this.getMax(currGene));
                min = Math.min(min, PTMInitDialog.this.getMin(currGene));
                float maxRange = Math.max(max, Math.abs(min));
                this.profileDisplayPanel.setGraphBounds(0.0, (double)currGene.size(), (double)(-maxRange), (double)maxRange);
                for (i2 = 0; i2 < currGene.size(); ++i2) {
                }
                for (i2 = 0; i2 < currGene.size() - 1; ++i2) {
                    if (Float.isNaN(((Float)currGene.elementAt(i2)).floatValue()) || Float.isNaN(((Float)currGene.elementAt(i2 + 1)).floatValue())) continue;
                    GraphLine gl = new GraphLine((double)i2, (double)((Float)currGene.elementAt(i2)).floatValue(), (double)(i2 + 1), (double)((Float)currGene.elementAt(i2 + 1)).floatValue(), PTMInitDialog.this.clusterColors[index]);
                    this.profileDisplayPanel.addGraphElement((GraphElement)gl);
                }
            }
            for (i = 0; i < meanProfile.size(); ++i) {
                if (Float.isNaN(((Float)meanProfile.elementAt(i)).floatValue())) continue;
                GraphPoint gp = new GraphPoint((double)i, (double)((Float)meanProfile.elementAt(i)).floatValue(), Color.red, 5);
                this.profileDisplayPanel.addGraphElement((GraphElement)gp);
            }
            for (i = 0; i < meanProfile.size() - 1; ++i) {
                GraphLine gl = new GraphLine((double)i, (double)((Float)meanProfile.elementAt(i)).floatValue(), (double)(i + 1), (double)((Float)meanProfile.elementAt(i + 1)).floatValue(), Color.blue);
                this.profileDisplayPanel.addGraphElement((GraphElement)gl);
            }
            this.profileDisplayPanel.repaint();
        }

        public void reset() {
            this.clusterList.setSelectedIndex(0);
            PTMInitDialog.this.setTemplate = false;
            this.refreshGraph();
        }
    }

    class GeneSelector
    extends JPanel {
        JList uniqueIDList;
        GraphCanvas profileDisplayPanel;
        JScrollPane listScrollPane;
        JButton selectButton;
        int maxIndex = -1;
        int minIndex = -1;
        JSplitPane uIDSplitPane;

        GeneSelector() {
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.setLayout(gridbag);
            this.uniqueIDList = new JList(PTMInitDialog.this.uniqueIDs);
            this.uniqueIDList.setSelectionMode(0);
            this.uniqueIDList.setSelectedIndex(0);
            this.profileDisplayPanel = new GraphCanvas();
            this.profileDisplayPanel.setGraphBounds(0.0, (double)PTMInitDialog.this.sampleNamesVector.size(), -3.0, 3.0);
            this.profileDisplayPanel.setGraphSpacing(20, 20, 20, 20);
            this.profileDisplayPanel.setXAxisValue(0.0);
            this.profileDisplayPanel.setYAxisValue(0.0);
            this.uniqueIDList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    GeneSelector.this.refreshGraph();
                }
            });
            this.listScrollPane = new JScrollPane(this.uniqueIDList);
            this.uIDSplitPane = new JSplitPane(1, this.listScrollPane, (Component)this.profileDisplayPanel);
            this.uIDSplitPane.setOneTouchExpandable(true);
            this.uIDSplitPane.setDividerLocation(200);
            Dimension minimumSize = new Dimension(100, 50);
            this.uniqueIDList.setMinimumSize(minimumSize);
            this.profileDisplayPanel.setMinimumSize(minimumSize);
            PTMInitDialog.this.buildConstraints(constraints, 0, 0, 1, 1, 1, 1);
            constraints.fill = 1;
            constraints.anchor = 11;
            gridbag.setConstraints(this.uIDSplitPane, constraints);
            this.add(this.uIDSplitPane);
            PTMInitDialog.this.buildConstraints(constraints, 0, 1, 1, 1, 1, 0);
            constraints.fill = 0;
            constraints.anchor = 10;
            constraints.insets = new Insets(10, 10, 10, 10);
            this.selectButton = new JButton("Select highlighted gene from above list to use as template", GUIFactory.getIcon("select_check24.gif"));
            this.selectButton.setBorder(BorderFactory.createBevelBorder(0));
            this.selectButton.setMargin(new Insets(10, 10, 10, 10));
            this.selectButton.setPreferredSize(new Dimension(400, 30));
            this.selectButton.setFocusPainted(false);
            this.selectButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int i;
                    float min;
                    int index = GeneSelector.this.uniqueIDList.getSelectedIndex();
                    Vector expProfile = PTMInitDialog.this.getGene(index);
                    float max = PTMInitDialog.this.getMax(expProfile);
                    if (max - (min = PTMInitDialog.this.getMin(expProfile)) == 0.0f) {
                        for (i = 0; i < expProfile.size(); ++i) {
                            expProfile.set(i, new Float(0.5));
                        }
                    } else {
                        for (i = 0; i < expProfile.size(); ++i) {
                            float f = (((Float)expProfile.get(i)).floatValue() - min) / (max - min);
                            expProfile.set(i, new Float(f));
                        }
                    }
                    for (i = 0; i < PTMInitDialog.this.tempPanel.tempScr.tempGrid.length; ++i) {
                        if (!Float.isNaN(((Float)expProfile.get(i)).floatValue())) {
                            PTMInitDialog.this.tempPanel.tempScr.tempGrid[i].activeBox.setSelected(true);
                            PTMInitDialog.this.tempPanel.tempScr.tempGrid[i].templateSlider.setEnabled(true);
                            PTMInitDialog.this.tempPanel.tempScr.tempGrid[i].templateSlider.setValue((int)Math.floor(((Float)expProfile.get(i)).floatValue() * 100.0f));
                            PTMInitDialog.this.tempPanel.tempScr.tempGrid[i].templateField.setEnabled(true);
                            PTMInitDialog.this.tempPanel.tempScr.tempGrid[i].templateField.setBackground(Color.white);
                            PTMInitDialog.this.tempPanel.tempScr.tempGrid[i].templateField.setText("" + ((Float)expProfile.get(i)).floatValue());
                            continue;
                        }
                        PTMInitDialog.this.tempPanel.tempScr.tempGrid[i].activeBox.setSelected(false);
                        PTMInitDialog.this.tempPanel.tempScr.tempGrid[i].templateSlider.setEnabled(false);
                        PTMInitDialog.this.tempPanel.tempScr.tempGrid[i].templateField.setText("NULL");
                        PTMInitDialog.this.tempPanel.tempScr.tempGrid[i].templateField.setBackground(Color.gray);
                        PTMInitDialog.this.tempPanel.tempScr.tempGrid[i].templateField.setEnabled(false);
                    }
                    PTMInitDialog.this.template = expProfile;
                    PTMInitDialog.this.setTemplate = true;
                    PTMInitDialog.this.clusterGenes = true;
                    PTMInitDialog.this.okButton.setEnabled(true);
                }
            });
            gridbag.setConstraints(this.selectButton, constraints);
            this.add(this.selectButton);
            this.refreshGraph();
        }

        private void refreshGraph() {
            int i;
            int index = this.uniqueIDList.getSelectedIndex();
            Vector expProfile = PTMInitDialog.this.getGene(index);
            float max = PTMInitDialog.this.getMax(expProfile);
            float min = PTMInitDialog.this.getMin(expProfile);
            float maxRange = Math.max(max, Math.abs(min));
            this.profileDisplayPanel.removeAllGraphElements();
            this.profileDisplayPanel.setGraphBounds(0.0, (double)expProfile.size(), (double)(-maxRange), (double)maxRange);
            for (i = 0; i < expProfile.size(); ++i) {
                if (Float.isNaN(((Float)expProfile.elementAt(i)).floatValue())) continue;
                GraphPoint gp = new GraphPoint((double)i, (double)((Float)expProfile.elementAt(i)).floatValue(), Color.red, 5);
                this.profileDisplayPanel.addGraphElement((GraphElement)gp);
            }
            for (i = 0; i < expProfile.size() - 1; ++i) {
                if (Float.isNaN(((Float)expProfile.elementAt(i)).floatValue()) || Float.isNaN(((Float)expProfile.elementAt(i + 1)).floatValue())) continue;
                GraphLine gl = new GraphLine((double)i, (double)((Float)expProfile.elementAt(i)).floatValue(), (double)(i + 1), (double)((Float)expProfile.elementAt(i + 1)).floatValue(), Color.blue);
                this.profileDisplayPanel.addGraphElement((GraphElement)gl);
            }
            this.profileDisplayPanel.repaint();
        }

        public void reset() {
            this.uniqueIDList.setSelectedIndex(0);
            PTMInitDialog.this.setTemplate = false;
            this.refreshGraph();
        }
    }

    protected class EventListener
    implements ActionListener {
        protected EventListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            block12: {
                String command = event.getActionCommand();
                if (command.equals("ok-command")) {
                    try {
                        String s = PTMInitDialog.this.thresh.threshInputField.getText();
                        double r = Double.parseDouble(s);
                        if (r > 1.0 || r < 0.0) {
                            JOptionPane.showMessageDialog(null, "P-Value threshold R value must be between 0 and 1 (inclusive)");
                            PTMInitDialog.this.thresh.threshInputField.selectAll();
                            PTMInitDialog.this.thresh.threshInputField.requestFocus();
                            break block12;
                        }
                        PTMInitDialog.this.okPressed = true;
                        PTMInitDialog.this.fireOkButtonEvent();
                        PTMInitDialog.this.setVisible(false);
                    }
                    catch (Exception exc) {
                        JOptionPane.showMessageDialog(null, "P-Value Input Format Error: Requires value between 0 and 1 (inclusive)");
                        PTMInitDialog.this.thresh.threshInputField.selectAll();
                        PTMInitDialog.this.thresh.threshInputField.requestFocus();
                    }
                } else if (command.equals("reset-command")) {
                    PTMInitDialog.this.template = new Vector();
                    PTMInitDialog.this.expSelectPanel.reset();
                    PTMInitDialog.this.clusterSelectPanel.reset();
                    PTMInitDialog.this.geneSelectPanel.reset();
                    PTMInitDialog.this.geneClusterSelectPanel.reset();
                    PTMInitDialog.this.tempPanel.reset();
                    PTMInitDialog.this.templateSelectPanel.reset();
                    PTMInitDialog.this.thresh.useAbsolute.setSelected(false);
                    PTMInitDialog.this.thresh.chooseP.setSelected(true);
                    PTMInitDialog.this.thresh.threshInputField.setText("0.01");
                    PTMInitDialog.this.okPressed = false;
                } else if (command.equals("cancel-command")) {
                    PTMInitDialog.this.hide();
                    PTMInitDialog.this.dispose();
                } else if (command.equals("info-command")) {
                    HelpWindow.launchBrowser(PTMInitDialog.this, "PTM Initialization Dialog");
                } else if (command.equals("save-template-command")) {
                    // empty if block
                }
            }
        }
    }

    class TemplatePanel
    extends JPanel {
        TemplateScroller tempScr;

        TemplatePanel() {
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.fill = 1;
            this.setLayout(gridbag);
            this.tempScr = new TemplateScroller();
            JScrollPane scroller = this.tempScr.createTemplateScroller();
            PTMInitDialog.this.buildConstraints(constraints, 0, 0, 1, 1, 100, 95);
            gridbag.setConstraints(scroller, constraints);
            this.add(scroller);
            PTMInitDialog.this.buildConstraints(constraints, 0, 1, 1, 1, 100, 5);
            constraints.fill = 0;
            this.setMaximumSize(new Dimension(600, 100));
            this.setSize(600, 100);
        }

        public void reset() {
            this.tempScr.reset();
        }

        class TemplateScroller
        extends JPanel {
            TemplateElementGrid[] tempGrid;

            TemplateScroller() {
                this.tempGrid = new TemplateElementGrid[PTMInitDialog.this.SampleNames.length];
            }

            JScrollPane createTemplateScroller() {
                GridBagLayout gridbag = new GridBagLayout();
                GridBagConstraints constraints = new GridBagConstraints();
                constraints.fill = 1;
                this.setLayout(gridbag);
                for (int i = 0; i < PTMInitDialog.this.SampleNames.length; ++i) {
                    this.tempGrid[i] = new TemplateElementGrid(PTMInitDialog.this.SampleNames[i]);
                    PTMInitDialog.this.buildConstraints(constraints, i, 0, 1, 1, 100, 100);
                    gridbag.setConstraints(this.tempGrid[i], constraints);
                    this.add(this.tempGrid[i]);
                }
                JScrollPane scroller = new JScrollPane(this);
                scroller.setHorizontalScrollBarPolicy(30);
                scroller.setVerticalScrollBarPolicy(21);
                return scroller;
            }

            public void reset() {
                for (int i = 0; i < this.tempGrid.length; ++i) {
                    this.tempGrid[i].reset();
                }
            }

            class TemplateElementGrid
            extends JPanel {
                JLabel exptName;
                JTextField templateField;
                JSlider templateSlider;
                JCheckBox activeBox;

                TemplateElementGrid(String SampleName) {
                    GridBagLayout templateElement = new GridBagLayout();
                    GridBagConstraints constraints = new GridBagConstraints();
                    constraints.fill = 1;
                    this.setLayout(templateElement);
                    PTMInitDialog.this.buildConstraints(constraints, 0, 0, 1, 1, 50, 10);
                    this.exptName = new JLabel(SampleName, 0);
                    templateElement.setConstraints(this.exptName, constraints);
                    this.add(this.exptName);
                    PTMInitDialog.this.buildConstraints(constraints, 1, 0, 1, 1, 50, 0);
                    this.activeBox = new JCheckBox();
                    this.activeBox.setSelected(true);
                    this.activeBox.addItemListener(new ItemListener(){

                        @Override
                        public void itemStateChanged(ItemEvent e) {
                            if (e.getStateChange() == 2) {
                                TemplateElementGrid.this.templateField.setBackground(Color.gray);
                                TemplateElementGrid.this.templateField.setEnabled(false);
                                TemplateElementGrid.this.templateSlider.setEnabled(false);
                            }
                            if (e.getStateChange() == 1) {
                                TemplateElementGrid.this.templateField.setBackground(Color.white);
                                TemplateElementGrid.this.templateField.setEnabled(true);
                                TemplateElementGrid.this.templateSlider.setEnabled(true);
                            }
                        }
                    });
                    templateElement.setConstraints(this.activeBox, constraints);
                    this.add(this.activeBox);
                    PTMInitDialog.this.buildConstraints(constraints, 0, 1, 2, 1, 0, 5);
                    this.templateField = new JTextField("0.5", 4);
                    this.templateField.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (e.getSource() == TemplateElementGrid.this.templateField) {
                                int sliderValue;
                                try {
                                    String s = TemplateElementGrid.this.templateField.getText();
                                    double d = Double.parseDouble(s);
                                    sliderValue = (int)Math.floor(d * 100.0);
                                    if (d > 1.0 || d < 0.0) {
                                        sliderValue = 50;
                                        TemplateElementGrid.this.templateField.setText("0.5");
                                        JOptionPane.showMessageDialog(null, "Template values must be between 0 and 1 (inclusive)");
                                    }
                                }
                                catch (Exception exc) {
                                    TemplateElementGrid.this.templateField.setText("0.5");
                                    sliderValue = 50;
                                    JOptionPane.showMessageDialog(null, "Input Format Error: Template values must be between 0 and 1 (inclusive)");
                                }
                                TemplateElementGrid.this.templateSlider.setValue(sliderValue);
                            }
                        }
                    });
                    this.templateField.addFocusListener(new FocusListener(){

                        @Override
                        public void focusLost(FocusEvent e) {
                            if (e.getSource() == TemplateElementGrid.this.templateField) {
                                int sliderValue;
                                try {
                                    String s = TemplateElementGrid.this.templateField.getText();
                                    double d = Double.parseDouble(s);
                                    sliderValue = (int)Math.floor(d * 100.0);
                                    if (d > 1.0 || d < 0.0) {
                                        sliderValue = 50;
                                        TemplateElementGrid.this.templateField.setText("0.5");
                                        JOptionPane.showMessageDialog(null, "Template values must be between 0 and 1 (inclusive)");
                                    }
                                }
                                catch (Exception exc) {
                                    TemplateElementGrid.this.templateField.setText("0.5");
                                    sliderValue = 50;
                                    JOptionPane.showMessageDialog(null, "Template values must be between 0 and 1 (inclusive)");
                                }
                                TemplateElementGrid.this.templateSlider.setValue(sliderValue);
                            }
                        }

                        @Override
                        public void focusGained(FocusEvent e) {
                        }
                    });
                    templateElement.setConstraints(this.templateField, constraints);
                    this.add(this.templateField);
                    PTMInitDialog.this.buildConstraints(constraints, 0, 2, 2, 1, 0, 85);
                    this.templateSlider = new JSlider(1, 0, 100, 50);
                    this.templateSlider.setPreferredSize(new Dimension(30, 50));
                    this.templateSlider.setMajorTickSpacing(20);
                    this.templateSlider.setMinorTickSpacing(10);
                    Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
                    labelTable.put(new Integer(0), new JLabel("Min"));
                    labelTable.put(new Integer(100), new JLabel("Max"));
                    this.templateSlider.setLabelTable(labelTable);
                    this.templateSlider.setPaintLabels(true);
                    this.templateSlider.addChangeListener(new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent e) {
                            JSlider source = (JSlider)e.getSource();
                            if (!source.getValueIsAdjusting()) {
                                int value = source.getValue();
                                if (value == 100) {
                                    TemplateElementGrid.this.templateField.setText("1.0");
                                } else if (value > 0 && value < 10) {
                                    TemplateElementGrid.this.templateField.setText("0.0" + value);
                                } else {
                                    TemplateElementGrid.this.templateField.setText("0." + value);
                                }
                            }
                        }
                    });
                    templateElement.setConstraints(this.templateSlider, constraints);
                    this.add(this.templateSlider);
                }

                public void reset() {
                    this.templateSlider.setValue(50);
                    this.templateField.setText("0.5");
                }
            }
        }
    }

    class ThresholdPanel
    extends JPanel {
        JLabel threshLabel1;
        JLabel threshLabel2;
        JTextField threshInputField;
        JRadioButton chooseR;
        JRadioButton chooseP;
        JCheckBox useAbsolute;
        JLabel inputLabel;

        ThresholdPanel() {
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.fill = 0;
            constraints.insets = new Insets(10, 30, 10, 0);
            this.setLayout(gridbag);
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Threshold Parameters"));
            this.useAbsolute = new JCheckBox("Use Absolute R");
            this.useAbsolute.setFocusPainted(false);
            PTMInitDialog.this.buildConstraints(constraints, 0, 0, 3, 1, 0, 0);
            constraints.anchor = 17;
            gridbag.setConstraints(this.useAbsolute, constraints);
            this.add(this.useAbsolute);
            constraints.insets = new Insets(0, 30, 0, 0);
            ButtonGroup chooseRorP = new ButtonGroup();
            this.chooseR = new JRadioButton("Use Threshold R", false);
            this.chooseR.setFocusPainted(false);
            chooseRorP.add(this.chooseR);
            this.chooseP = new JRadioButton("Use Threshold p-Value", true);
            this.chooseP.setFocusPainted(false);
            chooseRorP.add(this.chooseP);
            PTMInitDialog.this.buildConstraints(constraints, 0, 1, 1, 1, 10, 0);
            gridbag.setConstraints(this.chooseR, constraints);
            this.add(this.chooseR);
            PTMInitDialog.this.buildConstraints(constraints, 0, 2, 1, 1, 0, 0);
            gridbag.setConstraints(this.chooseP, constraints);
            this.add(this.chooseP);
            PTMInitDialog.this.buildConstraints(constraints, 1, 0, 1, 1, 80, 0);
            this.threshLabel1 = new JLabel("Enter magnitude of threshold R or p-Value (between 0 and 1 inclusive)");
            PTMInitDialog.this.buildConstraints(constraints, 1, 1, 1, 1, 0, 0);
            this.threshLabel2 = new JLabel("at which selected profiles should be correlated to template");
            constraints.insets = new Insets(15, 5, 0, 0);
            JPanel thresholdInputPanel = new JPanel(new GridBagLayout());
            this.inputLabel = new JLabel("Enter p-value [0,1] :");
            this.inputLabel.setForeground(Color.black);
            this.inputLabel.setAlignmentX(1.0f);
            this.inputLabel.setSize(150, 40);
            this.inputLabel.setMinimumSize(new Dimension(150, 40));
            gridbag.setConstraints(this.inputLabel, constraints);
            thresholdInputPanel.add((Component)this.inputLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.chooseR.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent evt) {
                    if (ThresholdPanel.this.chooseR.isSelected()) {
                        ThresholdPanel.this.inputLabel.setText("Enter R [0,1] :");
                    } else {
                        ThresholdPanel.this.inputLabel.setText("Enter p-value [0,1] :");
                    }
                }
            });
            this.threshInputField = new JTextField("", 7);
            this.threshInputField.setMinimumSize(new Dimension(100, 20));
            this.threshInputField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (evt.getSource() == ThresholdPanel.this.threshInputField) {
                        try {
                            String s = ThresholdPanel.this.threshInputField.getText();
                            double r = Double.parseDouble(s);
                            if (r > 1.0 || r < 0.0) {
                                JOptionPane.showMessageDialog(null, "Threshold R value must be between 0 and 1 (inclusive)");
                                ThresholdPanel.this.threshInputField.selectAll();
                                ThresholdPanel.this.threshInputField.requestFocus();
                            }
                        }
                        catch (Exception exc) {
                            JOptionPane.showMessageDialog(null, "Input Format Error: Threshold R value must be between 0 and 1 (inclusive)");
                            ThresholdPanel.this.threshInputField.selectAll();
                            ThresholdPanel.this.threshInputField.requestFocus();
                        }
                    }
                }
            });
            thresholdInputPanel.add((Component)this.threshInputField, new GridBagConstraints(1, 0, 1, 1, 5.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            PTMInitDialog.this.buildConstraints(constraints, 1, 0, 1, 3, 10, 0);
            constraints.anchor = 10;
            constraints.fill = 1;
            gridbag.setConstraints(thresholdInputPanel, constraints);
            this.add(thresholdInputPanel);
        }
    }

    class SavedTemplateSelector
    extends JPanel {
        JList templateList;
        GraphCanvas profileDisplayPanel;
        JScrollPane listScrollPane;
        JButton selectButton;
        JButton loadButton;
        Vector templatesVector = new Vector();
        DefaultListModel listModel = new DefaultListModel();
        Vector templates;
        JSplitPane templateSplitPane;
        JPanel templateButtonPanel;
        boolean savedTemplateSelected;

        SavedTemplateSelector() {
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.setLayout(gridbag);
            this.templateList = new JList(this.listModel);
            this.templateList.setSelectionMode(0);
            this.templateList.setSelectedIndex(-1);
            this.profileDisplayPanel = new GraphCanvas();
            this.profileDisplayPanel.setGraphBounds(0.0, (double)PTMInitDialog.this.sampleNamesVector.size(), -3.0, 3.0);
            this.profileDisplayPanel.setGraphSpacing(20, 20, 20, 20);
            this.profileDisplayPanel.setXAxisValue(0.0);
            this.profileDisplayPanel.setYAxisValue(0.0);
            this.templateList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (SavedTemplateSelector.this.templatesVector.size() > 0) {
                        Vector temp = (Vector)SavedTemplateSelector.this.templatesVector.elementAt(SavedTemplateSelector.this.templateList.getSelectedIndex());
                        if (temp.size() == PTMInitDialog.this.numberOfExperiments) {
                            PTMInitDialog.this.tempPanel.setVisible(true);
                            PTMInitDialog.this.tempPanel.setEnabled(true);
                        } else {
                            PTMInitDialog.this.tempPanel.setVisible(false);
                            PTMInitDialog.this.tempPanel.setEnabled(false);
                        }
                    }
                    SavedTemplateSelector.this.savedTemplateSelected = false;
                    SavedTemplateSelector.this.refreshGraph();
                }
            });
            this.listScrollPane = new JScrollPane(this.templateList);
            this.templateSplitPane = new JSplitPane(1, this.listScrollPane, (Component)this.profileDisplayPanel);
            this.templateSplitPane.setOneTouchExpandable(true);
            this.templateSplitPane.setDividerLocation(200);
            Dimension minimumSize = new Dimension(100, 50);
            this.templateList.setMinimumSize(minimumSize);
            this.profileDisplayPanel.setMinimumSize(minimumSize);
            this.templateSplitPane.setPreferredSize(new Dimension(700, 150));
            PTMInitDialog.this.buildConstraints(constraints, 0, 0, 1, 1, 1, 1);
            constraints.fill = 1;
            constraints.anchor = 10;
            constraints.insets = new Insets(5, 5, 5, 5);
            gridbag.setConstraints(this.templateSplitPane, constraints);
            this.add(this.templateSplitPane);
            this.loadButton = new JButton("Load saved template", GUIFactory.getIcon("Open24.gif"));
            this.loadButton.setBorder(BorderFactory.createBevelBorder(0));
            this.loadButton.setMargin(new Insets(10, 10, 10, 10));
            this.loadButton.setFocusPainted(false);
            this.loadButton.setPreferredSize(new Dimension(200, 30));
            this.loadButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    JFileChooser fc;
                    int returnVal;
                    if (evt.getSource() == SavedTemplateSelector.this.loadButton && (returnVal = (fc = new JFileChooser(TMEV.getFile((String)"data/"))).showOpenDialog(SavedTemplateSelector.this)) == 0) {
                        File file = fc.getSelectedFile();
                        try {
                            BufferedReader br = new BufferedReader(new FileReader(file.getPath()));
                            try {
                                String value;
                                int index = SavedTemplateSelector.this.templatesVector.size();
                                Vector<Float> currentTemplate = new Vector<Float>();
                                while ((value = br.readLine()) != null) {
                                    currentTemplate.add(new Float(value));
                                }
                                SavedTemplateSelector.this.listModel.addElement(file.getName());
                                SavedTemplateSelector.this.templatesVector.add(currentTemplate);
                                SavedTemplateSelector.this.templateList.setSelectedIndex(SavedTemplateSelector.this.templatesVector.size() - 1);
                                br.close();
                                SavedTemplateSelector.this.refreshGraph();
                                SavedTemplateSelector.this.profileDisplayPanel.setGraphBounds(0.0, (double)currentTemplate.size(), -3.0, 3.0);
                            }
                            catch (EOFException exc) {
                                br.close();
                            }
                        }
                        catch (IOException e) {
                            System.out.println("Error: " + e.toString());
                            JOptionPane.showMessageDialog(null, e.toString());
                        }
                    }
                }
            });
            this.selectButton = new JButton("Select Displayed Template", GUIFactory.getIcon("select_check24.gif"));
            this.selectButton.setBorder(BorderFactory.createBevelBorder(0));
            this.selectButton.setMargin(new Insets(10, 10, 10, 10));
            this.selectButton.setFocusPainted(false);
            this.selectButton.setPreferredSize(new Dimension(200, 30));
            this.selectButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (SavedTemplateSelector.this.listModel.size() == 0) {
                        JOptionPane.showMessageDialog(null, "No templates to select");
                    } else {
                        int i;
                        float min;
                        SavedTemplateSelector.this.savedTemplateSelected = true;
                        int index = SavedTemplateSelector.this.templateList.getSelectedIndex();
                        Vector expProfile = (Vector)((Vector)SavedTemplateSelector.this.templatesVector.get(index)).clone();
                        float max = PTMInitDialog.this.getMax(expProfile);
                        if (max - (min = PTMInitDialog.this.getMin(expProfile)) == 0.0f) {
                            for (i = 0; i < expProfile.size(); ++i) {
                                expProfile.set(i, new Float(0.5));
                            }
                        } else {
                            for (i = 0; i < expProfile.size(); ++i) {
                                float f = (((Float)expProfile.get(i)).floatValue() - min) / (max - min);
                                expProfile.set(i, new Float(f));
                            }
                        }
                        if (expProfile.size() == PTMInitDialog.this.numberOfExperiments) {
                            PTMInitDialog.this.clusterGenes = true;
                            for (i = 0; i < PTMInitDialog.this.tempPanel.tempScr.tempGrid.length; ++i) {
                                PTMInitDialog.this.tempPanel.tempScr.tempGrid[i].templateSlider.setValue((int)Math.floor(((Float)expProfile.get(i)).floatValue() * 100.0f));
                                PTMInitDialog.this.tempPanel.tempScr.tempGrid[i].templateField.setText("" + ((Float)expProfile.get(i)).floatValue());
                            }
                        } else {
                            PTMInitDialog.this.clusterGenes = false;
                            PTMInitDialog.this.template = expProfile;
                        }
                    }
                    SavedTemplateSelector.this.refreshGraph();
                }
            });
            gridbag.setConstraints(this.selectButton, constraints);
            this.add(this.selectButton);
            PTMInitDialog.this.buildConstraints(constraints, 0, 1, 1, 1, 0, 0);
            this.templateButtonPanel = new JPanel();
            this.templateButtonPanel.add(this.loadButton);
            this.templateButtonPanel.add(this.selectButton);
            gridbag.setConstraints(this.templateButtonPanel, constraints);
            this.add(this.templateButtonPanel);
            this.refreshGraph();
        }

        private void refreshGraph() {
            int i;
            float min = Float.POSITIVE_INFINITY;
            float max = Float.NEGATIVE_INFINITY;
            int index = this.templateList.getSelectedIndex();
            Color lineColor = Color.blue;
            if (this.savedTemplateSelected) {
                lineColor = Color.green;
            }
            if (index < 0) {
                return;
            }
            Vector expProfile = (Vector)((Vector)this.templatesVector.get(index)).clone();
            max = Math.max(max, PTMInitDialog.this.getMax(expProfile));
            min = Math.min(min, PTMInitDialog.this.getMin(expProfile));
            float maxRange = Math.max(max, Math.abs(min));
            this.profileDisplayPanel.setGraphBounds(0.0, (double)expProfile.size(), (double)(-maxRange), (double)maxRange);
            this.profileDisplayPanel.removeAllGraphElements();
            for (i = 0; i < expProfile.size(); ++i) {
                GraphPoint gp = new GraphPoint((double)(i + 1), (double)((Float)expProfile.elementAt(i)).floatValue(), Color.red, 2);
                this.profileDisplayPanel.addGraphElement((GraphElement)gp);
            }
            for (i = 0; i < expProfile.size() - 1; ++i) {
                GraphLine gl = new GraphLine((double)(i + 1), (double)((Float)expProfile.elementAt(i)).floatValue(), (double)(i + 2), (double)((Float)expProfile.elementAt(i + 1)).floatValue(), lineColor);
                this.profileDisplayPanel.addGraphElement((GraphElement)gl);
            }
            this.profileDisplayPanel.repaint();
        }

        public void reset() {
            this.savedTemplateSelected = false;
            this.refreshGraph();
        }
    }

    class ExperimentClusterSelector
    extends JPanel {
        JList clusterList;
        GraphCanvas profileDisplayPanel;
        JScrollPane listScrollPane;
        JButton selectButton;
        Vector clusterNames = new Vector();
        Vector expDataInClusters;
        Vector averageClusterProfiles;
        JSplitPane clusterSplitPane;

        ExperimentClusterSelector() {
            if (PTMInitDialog.this.expClusters.size() == 0) {
                this.clusterNames.add("No sample clusters to show");
            } else {
                for (int i = 0; i < PTMInitDialog.this.expClusters.size(); ++i) {
                    this.clusterNames.add("Exp. Cluster " + (i + 1));
                }
                this.expDataInClusters = new Vector();
                this.averageClusterProfiles = new Vector();
                for (int j = 0; j < PTMInitDialog.this.expClusters.size(); ++j) {
                    Vector currentCluster = (Vector)PTMInitDialog.this.expClusters.get(j);
                    Vector<Vector> cluster = new Vector<Vector>();
                    for (int k = 0; k < currentCluster.size(); ++k) {
                        int index = (Integer)currentCluster.get(k);
                        Vector currentGene = PTMInitDialog.this.getExperiment(index);
                        cluster.add(currentGene);
                    }
                    this.expDataInClusters.add(cluster);
                    Vector meanOfCurrentCluster = PTMInitDialog.this.getMeanProfile(cluster);
                    this.averageClusterProfiles.add(meanOfCurrentCluster);
                }
            }
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.setLayout(gridbag);
            this.clusterList = new JList(this.clusterNames);
            this.clusterList.setSelectionMode(0);
            this.clusterList.setSelectedIndex(0);
            this.profileDisplayPanel = new GraphCanvas();
            this.profileDisplayPanel.setGraphBounds(0.0, (double)PTMInitDialog.this.sampleNamesVector.size(), -3.0, 3.0);
            this.profileDisplayPanel.setGraphSpacing(20, 20, 20, 20);
            this.profileDisplayPanel.setXAxisValue(0.0);
            this.profileDisplayPanel.setYAxisValue(0.0);
            this.clusterList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    ExperimentClusterSelector.this.refreshGraph();
                }
            });
            this.listScrollPane = new JScrollPane(this.clusterList);
            this.clusterSplitPane = new JSplitPane(1, this.listScrollPane, (Component)this.profileDisplayPanel);
            this.clusterSplitPane.setOneTouchExpandable(true);
            this.clusterSplitPane.setDividerLocation(200);
            Dimension minimumSize = new Dimension(100, 50);
            this.clusterList.setMinimumSize(minimumSize);
            this.profileDisplayPanel.setMinimumSize(minimumSize);
            PTMInitDialog.this.buildConstraints(constraints, 0, 0, 1, 1, 1, 1);
            constraints.fill = 1;
            gridbag.setConstraints(this.clusterSplitPane, constraints);
            this.add(this.clusterSplitPane);
            PTMInitDialog.this.buildConstraints(constraints, 0, 1, 1, 1, 0, 0);
            constraints.fill = 0;
            constraints.anchor = 10;
            constraints.insets = new Insets(10, 0, 10, 0);
            this.selectButton = new JButton("Select highlighted cluster from above list to use its mean as template", GUIFactory.getIcon("select_check24.gif"));
            this.selectButton.setBorder(BorderFactory.createBevelBorder(0));
            this.selectButton.setMargin(new Insets(10, 10, 10, 10));
            this.selectButton.setPreferredSize(new Dimension(430, 30));
            this.selectButton.setFocusPainted(false);
            this.selectButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PTMInitDialog.this.expClusters.size() == 0) {
                        JOptionPane.showMessageDialog(null, "No sample clusters to select");
                    } else {
                        int c = ExperimentClusterSelector.this.clusterList.getSelectedIndex();
                        Vector v = (Vector)PTMInitDialog.this.expClusters.elementAt(c);
                        int[] index = new int[v.size()];
                        for (int i = 0; i < index.length; ++i) {
                            index[i] = (Integer)v.elementAt(i);
                        }
                        Vector expProfile = new Vector();
                        Vector<Vector> expProfiles = new Vector<Vector>();
                        for (int j = 0; j < index.length; ++j) {
                            int i;
                            float min;
                            expProfile = PTMInitDialog.this.getExperiment(index[j]);
                            float max = PTMInitDialog.this.getMax(expProfile);
                            if (max - (min = PTMInitDialog.this.getMin(expProfile)) == 0.0f) {
                                for (i = 0; i < expProfile.size(); ++i) {
                                    expProfile.set(i, new Float(0.5));
                                }
                            } else {
                                for (i = 0; i < expProfile.size(); ++i) {
                                    float f = (((Float)expProfile.get(i)).floatValue() - min) / (max - min);
                                    expProfile.set(i, new Float(f));
                                }
                            }
                            expProfiles.add(expProfile);
                        }
                        PTMInitDialog.this.template = PTMInitDialog.this.getMeanProfile(expProfiles);
                        PTMInitDialog.this.setTemplate = true;
                        PTMInitDialog.this.clusterGenes = false;
                        PTMInitDialog.this.okButton.setEnabled(true);
                    }
                }
            });
            gridbag.setConstraints(this.selectButton, constraints);
            this.add(this.selectButton);
            this.refreshGraph();
        }

        private void refreshGraph() {
            int i;
            GraphLine gL;
            int index = this.clusterList.getSelectedIndex();
            if (PTMInitDialog.this.expClusters.size() <= 0) {
                return;
            }
            Vector meanProfile = (Vector)this.averageClusterProfiles.elementAt(index);
            float min = Float.POSITIVE_INFINITY;
            float max = Float.NEGATIVE_INFINITY;
            this.profileDisplayPanel.removeAllGraphElements();
            Vector selectedCluster = (Vector)this.expDataInClusters.get(index);
            for (int j = 0; j < selectedCluster.size(); ++j) {
                Vector currExp = (Vector)selectedCluster.get(j);
                max = Math.max(max, PTMInitDialog.this.getMax(currExp));
                min = Math.min(min, PTMInitDialog.this.getMin(currExp));
                float maxRange = Math.max(max, Math.abs(min));
                this.profileDisplayPanel.setGraphBounds(0.0, (double)currExp.size(), (double)(-maxRange), (double)maxRange);
                for (int i2 = 0; i2 < currExp.size() - 1; ++i2) {
                    if (Float.isNaN(((Float)currExp.elementAt(i2)).floatValue()) || Float.isNaN(((Float)currExp.elementAt(i2 + 1)).floatValue())) continue;
                    gL = new GraphLine((double)i2, (double)((Float)currExp.elementAt(i2)).floatValue(), (double)(i2 + 1), (double)((Float)currExp.elementAt(i2 + 1)).floatValue(), PTMInitDialog.this.expClusterColors[index]);
                    this.profileDisplayPanel.addGraphElement((GraphElement)gL);
                }
            }
            for (i = 0; i < meanProfile.size(); ++i) {
                if (Float.isNaN(((Float)meanProfile.elementAt(i)).floatValue())) continue;
                GraphPoint gp = new GraphPoint((double)i, (double)((Float)meanProfile.elementAt(i)).floatValue(), Color.red, 5);
                this.profileDisplayPanel.addGraphElement((GraphElement)gp);
            }
            for (i = 0; i < meanProfile.size() - 1; ++i) {
                gL = new GraphLine((double)i, (double)((Float)meanProfile.elementAt(i)).floatValue(), (double)(i + 1), (double)((Float)meanProfile.elementAt(i + 1)).floatValue(), Color.blue);
                this.profileDisplayPanel.addGraphElement((GraphElement)gL);
            }
            if (PTMInitDialog.this.setTemplate) {
                for (i = 0; i < meanProfile.size() - 1; ++i) {
                    if (Float.isNaN(((Float)meanProfile.elementAt(i)).floatValue()) || Float.isNaN(((Float)meanProfile.elementAt(i + 1)).floatValue())) continue;
                    gL = new GraphLine((double)i, (double)((Float)meanProfile.elementAt(i)).floatValue(), (double)(i + 1), (double)((Float)meanProfile.elementAt(i + 1)).floatValue(), Color.green);
                    this.profileDisplayPanel.addGraphElement((GraphElement)gL);
                }
            }
            this.profileDisplayPanel.repaint();
        }

        public void reset() {
            this.clusterList.setSelectedIndex(0);
            PTMInitDialog.this.setTemplate = false;
            this.refreshGraph();
        }
    }

    class ExperimentSelector
    extends JPanel {
        JList expList;
        GraphCanvas profileDisplayPanel;
        JScrollPane listScrollPane;
        JButton selectButton;
        int maxIndex = -1;
        int minIndex = -1;
        JSplitPane expSplitPane;

        ExperimentSelector() {
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.setLayout(gridbag);
            this.expList = new JList(PTMInitDialog.this.sampleNamesVector);
            this.expList.setSelectedIndex(0);
            this.profileDisplayPanel = new GraphCanvas();
            this.profileDisplayPanel.setGraphBounds(0.0, (double)PTMInitDialog.this.expMatrix.getRowDimension(), -3.0, 3.0);
            this.profileDisplayPanel.setGraphSpacing(20, 20, 20, 20);
            this.profileDisplayPanel.setXAxisValue(0.0);
            this.profileDisplayPanel.setYAxisValue(0.0);
            this.expList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    ExperimentSelector.this.refreshGraph();
                }
            });
            this.listScrollPane = new JScrollPane(this.expList);
            this.expSplitPane = new JSplitPane(1, this.listScrollPane, (Component)this.profileDisplayPanel);
            this.expSplitPane.setOneTouchExpandable(true);
            this.expSplitPane.setDividerLocation(200);
            Dimension minimumSize = new Dimension(100, 50);
            this.expList.setMinimumSize(minimumSize);
            this.profileDisplayPanel.setMinimumSize(minimumSize);
            PTMInitDialog.this.buildConstraints(constraints, 0, 0, 1, 1, 1, 1);
            constraints.fill = 1;
            gridbag.setConstraints(this.expSplitPane, constraints);
            this.add(this.expSplitPane);
            PTMInitDialog.this.buildConstraints(constraints, 0, 1, 1, 1, 0, 0);
            constraints.fill = 0;
            constraints.anchor = 10;
            constraints.insets = new Insets(10, 0, 10, 0);
            this.selectButton = new JButton("Select highlighted samples from above list to use as template", GUIFactory.getIcon("select_check24.gif"));
            this.selectButton.setBorder(BorderFactory.createBevelBorder(0));
            this.selectButton.setMargin(new Insets(10, 10, 10, 10));
            this.selectButton.setPreferredSize(new Dimension(400, 30));
            this.selectButton.setFocusPainted(false);
            this.selectButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int[] index = ExperimentSelector.this.expList.getSelectedIndices();
                    Vector expProfile = new Vector();
                    Vector<Vector> expProfiles = new Vector<Vector>();
                    for (int j = 0; j < index.length; ++j) {
                        int i;
                        float min;
                        expProfile = PTMInitDialog.this.getExperiment(index[j]);
                        float max = PTMInitDialog.this.getMax(expProfile);
                        if (max - (min = PTMInitDialog.this.getMin(expProfile)) == 0.0f) {
                            for (i = 0; i < expProfile.size(); ++i) {
                                expProfile.set(i, new Float(0.5));
                            }
                        } else {
                            for (i = 0; i < expProfile.size(); ++i) {
                                float f = (((Float)expProfile.get(i)).floatValue() - min) / (max - min);
                                expProfile.set(i, new Float(f));
                            }
                        }
                        expProfiles.add(expProfile);
                    }
                    PTMInitDialog.this.template = PTMInitDialog.this.getMeanProfile(expProfiles);
                    PTMInitDialog.this.setTemplate = true;
                    PTMInitDialog.this.clusterGenes = false;
                    ExperimentSelector.this.refreshGraph();
                }
            });
            gridbag.setConstraints(this.selectButton, constraints);
            this.add(this.selectButton);
            this.refreshGraph();
        }

        private void refreshGraph() {
            Vector expProfile;
            this.profileDisplayPanel.removeAllGraphElements();
            int[] indices = this.expList.getSelectedIndices();
            Vector<Vector> expProfiles = new Vector<Vector>();
            float max = Float.NEGATIVE_INFINITY;
            float min = Float.POSITIVE_INFINITY;
            for (int exp = 0; exp < indices.length; ++exp) {
                int i;
                expProfile = PTMInitDialog.this.getExperiment(indices[exp]);
                expProfiles.add(expProfile);
                max = Math.max(max, PTMInitDialog.this.getMax(expProfile));
                min = Math.min(min, PTMInitDialog.this.getMin(expProfile));
                float maxRange = Math.max(max, Math.abs(min));
                this.profileDisplayPanel.setGraphBounds(0.0, (double)expProfile.size(), (double)(-maxRange), (double)maxRange);
                for (i = 0; i < expProfile.size(); ++i) {
                    if (Float.isNaN(((Float)expProfile.elementAt(i)).floatValue())) continue;
                    GraphPoint gp = new GraphPoint((double)i, (double)((Float)expProfile.elementAt(i)).floatValue(), Color.red, 5);
                    this.profileDisplayPanel.addGraphElement((GraphElement)gp);
                }
                for (i = 0; i < expProfile.size() - 1; ++i) {
                    if (Float.isNaN(((Float)expProfile.elementAt(i)).floatValue()) || Float.isNaN(((Float)expProfile.elementAt(i + 1)).floatValue())) continue;
                    GraphLine gl = new GraphLine((double)i, (double)((Float)expProfile.elementAt(i)).floatValue(), (double)(i + 1), (double)((Float)expProfile.elementAt(i + 1)).floatValue(), Color.blue);
                    this.profileDisplayPanel.addGraphElement((GraphElement)gl);
                }
            }
            expProfile = PTMInitDialog.this.getMeanProfile(expProfiles);
            if (PTMInitDialog.this.setTemplate) {
                for (int i = 0; i < expProfile.size() - 1; ++i) {
                    if (Float.isNaN(((Float)expProfile.elementAt(i)).floatValue()) || Float.isNaN(((Float)expProfile.elementAt(i + 1)).floatValue())) continue;
                    GraphLine gl = new GraphLine((double)i, (double)((Float)expProfile.elementAt(i)).floatValue(), (double)(i + 1), (double)((Float)expProfile.elementAt(i + 1)).floatValue(), Color.green);
                    this.profileDisplayPanel.addGraphElement((GraphElement)gl);
                }
            }
            this.profileDisplayPanel.repaint();
        }

        public void reset() {
            this.expList.setSelectedIndex(0);
            PTMInitDialog.this.setTemplate = false;
            this.refreshGraph();
        }
    }
}

