/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ptm;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;

public class PTMInfoViewer
extends ViewerAdapter
implements Serializable {
    private JComponent header;
    private JTextArea content;
    private boolean clusterGenes = true;

    public PTMInfoViewer(int[][] clusters, int genes) {
        this.header = this.createHeader();
        this.content = this.createContent(clusters, genes);
        this.setMaxWidth(this.content, this.header);
    }

    public PTMInfoViewer(int[][] clusters, int genes, boolean clusterGenes) {
        this.header = this.createHeader();
        this.clusterGenes = clusterGenes;
        this.content = this.createContent(clusters, genes);
        this.setMaxWidth(this.content, this.header);
    }

    public PTMInfoViewer(JTextArea content, JComponent header) {
        this.header = header;
        this.content = content;
        this.setMaxWidth(content, header);
    }

    @Override
    public JComponent getContentComponent() {
        return this.content;
    }

    @Override
    public JComponent getHeaderComponent() {
        return this.header;
    }

    private JComponent createHeader() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBackground(Color.white);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(10, 0, 10, 0);
        panel.add((Component)new JLabel("<html><body bgcolor='#FFFFFF'><font face='serif' size='5' color='#000080'><b>Cluster Information</b></font></body></html>"), gbc);
        return panel;
    }

    private JTextArea createContent(int[][] clusters, int genes) {
        JTextArea area = new JTextArea(clusters.length * 3, 20);
        area.setMargin(new Insets(0, 10, 0, 0));
        area.setEditable(false);
        StringBuffer sb = new StringBuffer(clusters.length * 3 * 10);
        if (this.clusterGenes) {
            for (int counter = 0; counter < clusters.length; ++counter) {
                if (counter == 0) {
                    sb.append("Matched genes ");
                    sb.append("\t\t");
                    sb.append("# of Matched Genes: " + clusters[counter].length);
                    sb.append("\n\t\t");
                    sb.append("% of Genes that Match Template: " + Math.round((float)clusters[counter].length / (float)genes * 100.0f) + "%");
                    sb.append("\n\n");
                    continue;
                }
                if (counter != 1) continue;
                sb.append("Unmatched genes ");
                sb.append("\t");
                sb.append("# of Unmatched Genes: " + clusters[counter].length);
                sb.append("\n\t\t");
                sb.append("% of Genes that do not Match Template: " + Math.round((float)clusters[counter].length / (float)genes * 100.0f) + "%");
                sb.append("\n\n");
            }
        } else {
            for (int counter = 0; counter < clusters.length; ++counter) {
                if (counter == 0) {
                    sb.append("Matched experiments ");
                    sb.append("\t");
                    sb.append("# of Matched Experiments: " + clusters[counter].length);
                    sb.append("\n\t\t");
                    sb.append("% of Experiments that Match Template: " + Math.round((float)clusters[counter].length / (float)genes * 100.0f) + "%");
                    sb.append("\n\n");
                    continue;
                }
                if (counter != 1) continue;
                sb.append("Unmatched experiments ");
                sb.append("\t");
                sb.append("# of Unmatched Experiments: " + clusters[counter].length);
                sb.append("\n\t\t");
                sb.append("% of Experiments that do not Match Template: " + Math.round((float)clusters[counter].length / (float)genes * 100.0f) + "%");
                sb.append("\n\n");
            }
        }
        area.setText(sb.toString());
        area.setCaretPosition(0);
        return area;
    }

    private void setMaxWidth(JComponent content, JComponent header) {
        int c_width = content.getPreferredSize().width;
        int h_width = header.getPreferredSize().width;
        if (c_width > h_width) {
            header.setPreferredSize(new Dimension(c_width, header.getPreferredSize().height));
        } else {
            content.setPreferredSize(new Dimension(h_width, content.getPreferredSize().height));
        }
    }

    @Override
    public JComponent getRowHeaderComponent() {
        return null;
    }
}

