/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ptm;

import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterList;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterRepository;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLGUI;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeData;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ptm.PTMCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ptm.PTMCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ptm.PTMExperimentCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ptm.PTMExperimentCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ptm.PTMExperimentClusterViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ptm.PTMExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ptm.PTMInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ptm.PTMInitDialog;
import org.tigr.microarray.mev.script.scriptGUI.IScriptGUI;
import org.tigr.util.FloatMatrix;

public class PTMGUI
implements IClusterGUI,
IScriptGUI {
    private Algorithm algorithm;
    private Experiment experiment;
    private int[][] clusters;
    private FloatMatrix means;
    private FloatMatrix variances;
    private IData data;
    Vector templateVector;
    private float[] pValues;
    private float[] rValues;
    private boolean clusterGenes = false;
    private Object[][] auxData;
    private String[] auxTitles;
    private boolean drawSigTreesOnly;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework framework) throws AlgorithmException {
        IDistanceMenu menu;
        int function;
        boolean isHierarchicalTree;
        FloatMatrix templateMatrix;
        int i;
        int k = 2;
        boolean modality = true;
        boolean useAbsolute = false;
        boolean useR = false;
        float threshold = 0.8f;
        this.experiment = framework.getData().getExperiment();
        this.data = framework.getData();
        Vector<String> sampleNamesVector = new Vector<String>();
        int number_of_samples = this.experiment.getNumberOfSamples();
        int number_of_genes = this.experiment.getNumberOfGenes();
        for (int i2 = 0; i2 < number_of_samples; ++i2) {
            sampleNamesVector.add(framework.getData().getFullSampleName(this.experiment.getSampleIndex(i2)));
        }
        Vector<String> uniqueIDs = new Vector<String>();
        int labelIndex = framework.getDisplayMenu().getLabelIndex();
        for (int i3 = 0; i3 < number_of_genes; ++i3) {
            uniqueIDs.add(framework.getData().getElementAttribute(this.experiment.getGeneIndexMappedToData(i3), labelIndex));
        }
        Vector clusterVector = new Vector();
        Color[] clusterColors = framework.getData().getColors();
        boolean[] assignedToACluster = new boolean[number_of_genes];
        for (int i4 = 0; i4 < number_of_genes; ++i4) {
            assignedToACluster[i4] = false;
        }
        ClusterRepository geneClusterRepository = framework.getClusterRepository(0);
        int numClusters = 0;
        for (int i5 = 0; i5 < geneClusterRepository.size(); ++i5) {
            numClusters += geneClusterRepository.getClusterList(i5).size();
        }
        clusterColors = new Color[numClusters];
        int clusterIndex = 0;
        for (int i6 = 0; i6 < geneClusterRepository.size(); ++i6) {
            ClusterList list = geneClusterRepository.getClusterList(i6);
            for (int j = 0; j < list.size(); ++j) {
                Vector<Integer> currentCluster = new Vector<Integer>();
                org.tigr.microarray.mev.cluster.clusterUtil.Cluster mevCluster = list.getClusterAt(j);
                clusterColors[clusterIndex] = mevCluster.getClusterColor();
                ++clusterIndex;
                for (int m = 0; m < number_of_genes; ++m) {
                    if (mevCluster.isMember(this.experiment.getGeneIndexMappedToData(m))) {
                        currentCluster.add(new Integer(m));
                    }
                    assignedToACluster[m] = true;
                }
                clusterVector.add(currentCluster);
            }
        }
        Vector expClusterVector = new Vector();
        Color[] expClusterColors = framework.getData().getExperimentColors();
        boolean[] expAssignedToACluster = new boolean[number_of_samples];
        for (int i7 = 0; i7 < number_of_samples; ++i7) {
            expAssignedToACluster[i7] = false;
        }
        ClusterRepository expClusterRepository = framework.getClusterRepository(1);
        numClusters = 0;
        for (i = 0; i < expClusterRepository.size(); ++i) {
            numClusters += expClusterRepository.getClusterList(i).size();
        }
        expClusterColors = new Color[numClusters];
        clusterIndex = 0;
        for (i = 0; i < expClusterRepository.size(); ++i) {
            ClusterList list = expClusterRepository.getClusterList(i);
            for (int j = 0; j < list.size(); ++j) {
                Vector<Integer> currentCluster = new Vector<Integer>();
                org.tigr.microarray.mev.cluster.clusterUtil.Cluster mevCluster = list.getClusterAt(j);
                expClusterColors[clusterIndex] = mevCluster.getClusterColor();
                ++clusterIndex;
                for (int m = 0; m < number_of_samples; ++m) {
                    if (mevCluster.isMember(this.experiment.getSampleIndex(m))) {
                        currentCluster.add(new Integer(m));
                    }
                    expAssignedToACluster[m] = true;
                }
                expClusterVector.add(currentCluster);
            }
        }
        PTMInitDialog ptmInitBox = new PTMInitDialog((JFrame)framework.getFrame(), modality, this.experiment.getMatrix(), uniqueIDs, sampleNamesVector, clusterVector, expClusterVector, clusterColors, expClusterColors);
        int hcl_method = 0;
        boolean hcl_samples = false;
        boolean hcl_genes = false;
        ptmInitBox.setVisible(true);
        if (!ptmInitBox.isOkPressed()) {
            return null;
        }
        this.clusterGenes = ptmInitBox.isGeneTemplate();
        if (this.clusterGenes) {
            templateMatrix = ptmInitBox.convertTemplateVectorToFloatMatrix();
            this.templateVector = ptmInitBox.getTemplate();
            useAbsolute = ptmInitBox.isUseAbsolute();
            useR = ptmInitBox.isUseR();
            threshold = (float)ptmInitBox.getThresholdR();
            isHierarchicalTree = ptmInitBox.isDrawTrees();
        } else {
            templateMatrix = ptmInitBox.convertTemplateVectorToFloatMatrix();
            this.templateVector = ptmInitBox.getTemplate();
            useAbsolute = ptmInitBox.isUseAbsolute();
            useR = ptmInitBox.isUseR();
            threshold = (float)ptmInitBox.getThresholdR();
            isHierarchicalTree = ptmInitBox.isDrawTrees();
        }
        this.drawSigTreesOnly = true;
        if (isHierarchicalTree) {
            this.drawSigTreesOnly = ptmInitBox.drawSigTreesOnly();
        }
        if ((function = (menu = framework.getDistanceMenu()).getDistanceFunction()) == 0) {
            function = 1;
        }
        int hcl_function = 4;
        boolean hcl_absolute = false;
        if (isHierarchicalTree) {
            HCLInitDialog hcl_dialog = new HCLInitDialog((Frame)new JFrame(), menu.getFunctionName(function), menu.isAbsoluteDistance(), true);
            if (hcl_dialog.showModal() != 0) {
                return null;
            }
            hcl_method = hcl_dialog.getMethod();
            hcl_samples = hcl_dialog.isClusterExperiments();
            hcl_genes = hcl_dialog.isClusterGenes();
            hcl_function = hcl_dialog.getDistanceMetric();
            hcl_absolute = hcl_dialog.getAbsoluteSelection();
        }
        Listener listener = new Listener();
        try {
            int i8;
            this.algorithm = framework.getAlgorithmFactory().getAlgorithm("PTM");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            FloatMatrix matrix = this.experiment.getMatrix();
            if (!this.clusterGenes) {
                matrix = matrix.transpose();
                int n = matrix.getRowDimension();
            }
            int genes = this.experiment.getNumberOfGenes();
            AlgorithmData data = new AlgorithmData();
            data.addMatrix("experiment", matrix);
            data.addParam("ptm-cluster-genes", String.valueOf(this.clusterGenes));
            data.addMatrix("templateVectorMatrix", templateMatrix);
            data.addParam("distance-factor", String.valueOf(1.0f));
            data.addParam("use-absolute", String.valueOf(useAbsolute));
            data.addParam("useR", String.valueOf(useR));
            data.addParam("threshold", String.valueOf(threshold));
            data.addParam("distance-function", String.valueOf(function));
            if (isHierarchicalTree) {
                data.addParam("hierarchical-tree", String.valueOf(true));
                data.addParam("draw-sig-trees-only", String.valueOf(this.drawSigTreesOnly));
                data.addParam("method-linkage", String.valueOf(hcl_method));
                data.addParam("calculate-genes", String.valueOf(hcl_genes));
                data.addParam("calculate-experiments", String.valueOf(hcl_samples));
                data.addParam("hcl-distance-function", String.valueOf(hcl_function));
                data.addParam("hcl-distance-absolute", String.valueOf(hcl_absolute));
            }
            long start = System.currentTimeMillis();
            AlgorithmData result = this.algorithm.execute(data);
            long time = System.currentTimeMillis() - start;
            Cluster result_cluster = result.getCluster("cluster");
            NodeList nodeList = result_cluster.getNodeList();
            this.clusters = new int[k][];
            for (int i9 = 0; i9 < k; ++i9) {
                this.clusters[i9] = nodeList.getNode(i9).getFeaturesIndexes();
            }
            this.means = result.getMatrix("clusters_means");
            this.variances = result.getMatrix("clusters_variances");
            FloatMatrix rValuesMatrix = result.getMatrix("rValuesMatrix");
            FloatMatrix pValuesMatrix = result.getMatrix("pValuesMatrix");
            this.pValues = new float[pValuesMatrix.getRowDimension()];
            this.rValues = new float[rValuesMatrix.getRowDimension()];
            for (i8 = 0; i8 < this.pValues.length; ++i8) {
                this.pValues[i8] = pValuesMatrix.A[i8][0];
                this.rValues[i8] = rValuesMatrix.A[i8][0];
            }
            this.auxTitles = new String[2];
            this.auxTitles[0] = "R values";
            this.auxTitles[1] = "p Values";
            this.auxData = new Object[this.pValues.length][2];
            for (i8 = 0; i8 < this.auxData.length; ++i8) {
                this.auxData[i8][0] = new Float(this.rValues[i8]);
                this.auxData[i8][1] = new Float(this.pValues[i8]);
            }
            GeneralInfo info = new GeneralInfo();
            info.clusters = k;
            info.time = time;
            info.function = menu.getFunctionName(function);
            info.isR = useR;
            info.isAbsolute = useAbsolute;
            info.threshold = threshold;
            info.hcl = isHierarchicalTree;
            info.hcl_genes = hcl_genes;
            info.hcl_samples = hcl_samples;
            info.hcl_method = hcl_method;
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(result_cluster, info);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
        }
    }

    public AlgorithmData getScriptParameters(IFramework framework) {
        IDistanceMenu menu;
        int function;
        boolean isHierarchicalTree;
        FloatMatrix templateMatrix;
        int i;
        int i2;
        int k = 2;
        boolean modality = true;
        boolean useAbsolute = false;
        boolean useR = false;
        float threshold = 0.8f;
        this.experiment = framework.getData().getExperiment();
        this.data = framework.getData();
        Vector<String> sampleNamesVector = new Vector<String>();
        int number_of_samples = this.experiment.getNumberOfSamples();
        int number_of_genes = this.experiment.getNumberOfGenes();
        for (int i3 = 0; i3 < number_of_samples; ++i3) {
            sampleNamesVector.add(framework.getData().getFullSampleName(this.experiment.getSampleIndex(i3)));
        }
        Vector<String> uniqueIDs = new Vector<String>();
        int labelIndex = framework.getDisplayMenu().getLabelIndex();
        for (int i4 = 0; i4 < number_of_genes; ++i4) {
            uniqueIDs.add(framework.getData().getElementAttribute(this.experiment.getGeneIndexMappedToData(i4), labelIndex));
        }
        Vector clusterVector = new Vector();
        Color[] clusterColors = framework.getData().getColors();
        boolean[] assignedToACluster = new boolean[number_of_genes];
        for (i2 = 0; i2 < number_of_genes; ++i2) {
            assignedToACluster[i2] = false;
        }
        for (i2 = 0; i2 < clusterColors.length; ++i2) {
            Vector<Integer> currentCluster = new Vector<Integer>();
            for (int j = 0; j < number_of_genes; ++j) {
                if (assignedToACluster[j] || !clusterColors[i2].equals(framework.getData().getProbeColor(this.experiment.getGeneIndexMappedToData(j)))) continue;
                currentCluster.add(new Integer(j));
                assignedToACluster[j] = true;
            }
            clusterVector.add(currentCluster);
        }
        Vector expClusterVector = new Vector();
        Color[] expClusterColors = framework.getData().getExperimentColors();
        boolean[] expAssignedToACluster = new boolean[number_of_samples];
        for (i = 0; i < number_of_samples; ++i) {
            expAssignedToACluster[i] = false;
        }
        for (i = 0; i < expClusterColors.length; ++i) {
            Vector<Integer> currentCluster = new Vector<Integer>();
            for (int j = 0; j < number_of_samples; ++j) {
                if (expAssignedToACluster[j] || !expClusterColors[i].equals(framework.getData().getExperimentColor(this.experiment.getSampleIndex(j)))) continue;
                currentCluster.add(new Integer(j));
                expAssignedToACluster[j] = true;
            }
            expClusterVector.add(currentCluster);
        }
        PTMInitDialog ptmInitBox = new PTMInitDialog((JFrame)framework.getFrame(), modality, this.experiment.getMatrix(), uniqueIDs, sampleNamesVector, clusterVector, expClusterVector, clusterColors, expClusterColors);
        int hcl_method = 0;
        boolean hcl_samples = false;
        boolean hcl_genes = false;
        ptmInitBox.setVisible(true);
        if (!ptmInitBox.isOkPressed()) {
            return null;
        }
        this.clusterGenes = ptmInitBox.isGeneTemplate();
        if (this.clusterGenes) {
            templateMatrix = ptmInitBox.convertTemplateVectorToFloatMatrix();
            this.templateVector = ptmInitBox.getTemplate();
            useAbsolute = ptmInitBox.isUseAbsolute();
            useR = ptmInitBox.isUseR();
            threshold = (float)ptmInitBox.getThresholdR();
            isHierarchicalTree = ptmInitBox.isDrawTrees();
        } else {
            templateMatrix = ptmInitBox.convertTemplateVectorToFloatMatrix();
            this.templateVector = ptmInitBox.getTemplate();
            useAbsolute = ptmInitBox.isUseAbsolute();
            useR = ptmInitBox.isUseR();
            threshold = (float)ptmInitBox.getThresholdR();
            isHierarchicalTree = ptmInitBox.isDrawTrees();
        }
        this.drawSigTreesOnly = true;
        if (isHierarchicalTree) {
            this.drawSigTreesOnly = ptmInitBox.drawSigTreesOnly();
        }
        if ((function = (menu = framework.getDistanceMenu()).getDistanceFunction()) == 0) {
            function = 1;
        }
        int hcl_function = 4;
        boolean hcl_absolute = false;
        if (isHierarchicalTree) {
            HCLInitDialog hcl_dialog = new HCLInitDialog((Frame)new JFrame(), menu.getFunctionName(function), menu.isAbsoluteDistance(), true);
            if (hcl_dialog.showModal() != 0) {
                return null;
            }
            hcl_method = hcl_dialog.getMethod();
            hcl_samples = hcl_dialog.isClusterExperiments();
            hcl_genes = hcl_dialog.isClusterGenes();
            hcl_function = hcl_dialog.getDistanceMetric();
            hcl_absolute = hcl_dialog.getAbsoluteSelection();
        }
        AlgorithmData data = new AlgorithmData();
        data.addParam("ptm-cluster-genes", String.valueOf(this.clusterGenes));
        data.addMatrix("templateVectorMatrix", templateMatrix);
        data.addParam("distance-factor", String.valueOf(1.0f));
        data.addParam("use-absolute", String.valueOf(useAbsolute));
        data.addParam("useR", String.valueOf(useR));
        data.addParam("threshold", String.valueOf(threshold));
        data.addParam("distance-function", String.valueOf(function));
        if (isHierarchicalTree) {
            data.addParam("hierarchical-tree", String.valueOf(true));
            data.addParam("draw-sig-trees-only", String.valueOf(this.drawSigTreesOnly));
            data.addParam("method-linkage", String.valueOf(hcl_method));
            data.addParam("calculate-genes", String.valueOf(hcl_genes));
            data.addParam("calculate-experiments", String.valueOf(hcl_samples));
            data.addParam("hcl-distance-function", String.valueOf(hcl_function));
            data.addParam("hcl-distance-absolute", String.valueOf(hcl_absolute));
        }
        data.addParam("name", "PTM");
        if (this.clusterGenes) {
            data.addParam("alg-type", "cluster-genes");
        } else {
            data.addParam("alg-type", "cluster-experiments");
        }
        data.addParam("output-class", "partition-output");
        String[] outputNodes = new String[]{"Significant Genes", "Non-significant Genes"};
        data.addStringArray("output-nodes", outputNodes);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode executeScript(IFramework framework, AlgorithmData algData, Experiment experiment) throws AlgorithmException {
        int k = 2;
        this.experiment = experiment;
        this.data = framework.getData();
        AlgorithmParameters params = algData.getParams();
        this.drawSigTreesOnly = algData.getParams().getBoolean("draw-sig-trees-only");
        this.clusterGenes = params.getBoolean("ptm-cluster-genes");
        FloatMatrix templateMatrix = algData.getMatrix("templateVectorMatrix");
        this.templateVector = new Vector();
        int cols = templateMatrix.getColumnDimension();
        for (int i = 0; i < cols; ++i) {
            this.templateVector.add(new Float(templateMatrix.A[0][i]));
        }
        Listener listener = new Listener();
        try {
            int i;
            this.algorithm = framework.getAlgorithmFactory().getAlgorithm("PTM");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            FloatMatrix matrix = experiment.getMatrix();
            if (!this.clusterGenes) {
                matrix = matrix.transpose();
                int n = matrix.getRowDimension();
            }
            int genes = experiment.getNumberOfGenes();
            algData.addMatrix("experiment", matrix);
            long start = System.currentTimeMillis();
            AlgorithmData result = this.algorithm.execute(algData);
            long time = System.currentTimeMillis() - start;
            Cluster result_cluster = result.getCluster("cluster");
            NodeList nodeList = result_cluster.getNodeList();
            this.clusters = new int[k][];
            for (int i2 = 0; i2 < k; ++i2) {
                this.clusters[i2] = nodeList.getNode(i2).getFeaturesIndexes();
            }
            this.means = result.getMatrix("clusters_means");
            this.variances = result.getMatrix("clusters_variances");
            FloatMatrix rValuesMatrix = result.getMatrix("rValuesMatrix");
            FloatMatrix pValuesMatrix = result.getMatrix("pValuesMatrix");
            this.pValues = new float[pValuesMatrix.getRowDimension()];
            this.rValues = new float[rValuesMatrix.getRowDimension()];
            for (i = 0; i < this.pValues.length; ++i) {
                this.pValues[i] = pValuesMatrix.A[i][0];
                this.rValues[i] = rValuesMatrix.A[i][0];
            }
            this.auxTitles = new String[2];
            this.auxTitles[0] = "R values";
            this.auxTitles[1] = "p Values";
            this.auxData = new Object[this.pValues.length][2];
            for (i = 0; i < this.auxData.length; ++i) {
                this.auxData[i][0] = new Float(this.rValues[i]);
                this.auxData[i][1] = new Float(this.pValues[i]);
            }
            GeneralInfo info = new GeneralInfo();
            info.clusters = k;
            info.time = time;
            int function = params.getInt("distance-function");
            info.function = framework.getDistanceMenu().getFunctionName(function);
            info.isR = params.getBoolean("useR");
            info.isAbsolute = params.getBoolean("use-absolute");
            info.threshold = params.getFloat("threshold");
            info.hcl = params.getBoolean("hierarchical-tree");
            info.hcl_genes = params.getBoolean("calculate-genes");
            info.hcl_samples = params.getBoolean("calculate-experiments");
            if (info.hcl) {
                info.hcl_method = params.getInt("method-linkage");
            }
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(result_cluster, info);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
        }
    }

    private HCLTreeData getResult(Node clusterNode, int pos) {
        HCLTreeData data = new HCLTreeData();
        NodeValueList valueList = clusterNode.getValues();
        data.child_1_array = (int[])valueList.getNodeValue((int)pos).value;
        data.child_2_array = (int[])valueList.getNodeValue((int)(pos + 1)).value;
        data.node_order = (int[])valueList.getNodeValue((int)(pos + 2)).value;
        data.height = (float[])valueList.getNodeValue((int)(pos + 3)).value;
        return data;
    }

    private DefaultMutableTreeNode createResultTree(Cluster result_cluster, GeneralInfo info) {
        DefaultMutableTreeNode root = this.clusterGenes ? new DefaultMutableTreeNode("PTM - genes") : new DefaultMutableTreeNode("PTM - samples");
        this.addResultNodes(root, result_cluster, info);
        return root;
    }

    private void addResultNodes(DefaultMutableTreeNode root, Cluster result_cluster, GeneralInfo info) {
        this.addExpressionImages(root);
        this.addHierarchicalTrees(root, result_cluster, info);
        this.addCentroidViews(root);
        this.addStatsTables(root);
        this.addClusterInfo(root);
        this.addGeneralInfo(root, info);
    }

    private void addExpressionImages(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Expression Images");
        if (this.clusterGenes) {
            PTMExperimentViewer expViewer = new PTMExperimentViewer(this.experiment, this.clusters, this.templateVector, this.auxTitles, this.auxData);
            for (int i = 0; i < this.clusters.length; ++i) {
                if (i < this.clusters.length - 1) {
                    node.add(new DefaultMutableTreeNode(new LeafInfo("Matched Genes ", (IViewer)expViewer, (Object)new Integer(i))));
                    continue;
                }
                if (i != this.clusters.length - 1) continue;
                node.add(new DefaultMutableTreeNode(new LeafInfo("Unmatched Genes ", (IViewer)expViewer, (Object)new Integer(i))));
            }
        } else {
            PTMExperimentClusterViewer expViewer = new PTMExperimentClusterViewer(this.experiment, this.clusters, "Template", this.templateVector, this.auxTitles, this.auxData);
            for (int i = 0; i < this.clusters.length; ++i) {
                if (i < this.clusters.length - 1) {
                    node.add(new DefaultMutableTreeNode(new LeafInfo("Matched Experiments ", (IViewer)expViewer, (Object)new Integer(i))));
                    continue;
                }
                if (i != this.clusters.length - 1) continue;
                node.add(new DefaultMutableTreeNode(new LeafInfo("Unmatched Experiments ", (IViewer)expViewer, (Object)new Integer(i))));
            }
        }
        root.add(node);
    }

    private void addHierarchicalTrees(DefaultMutableTreeNode root, Cluster result_cluster, GeneralInfo info) {
        if (!info.hcl) {
            return;
        }
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Hierarchical Trees");
        NodeList nodeList = result_cluster.getNodeList();
        int n = nodeList.getSize();
        Object clusters = null;
        if (!this.drawSigTreesOnly) {
            int i;
            if (!this.clusterGenes) {
                clusters = new int[n][];
                for (i = 0; i < ((int[][])clusters).length; ++i) {
                    clusters[i] = nodeList.getNode(i).getFeaturesIndexes();
                }
                if (info.hcl_samples) {
                    clusters = this.getOrderedIndices(nodeList, (int[][])clusters, info.hcl_genes);
                }
            }
            for (i = 0; i < n; ++i) {
                if (this.clusterGenes) {
                    if (i == 0) {
                        node.add(new DefaultMutableTreeNode(new LeafInfo("Matched Genes", this.createHCLViewer(nodeList.getNode(i), info, null))));
                        continue;
                    }
                    node.add(new DefaultMutableTreeNode(new LeafInfo("Unmatched Genes", this.createHCLViewer(nodeList.getNode(i), info, null))));
                    continue;
                }
                if (i == 0) {
                    node.add(new DefaultMutableTreeNode(new LeafInfo("Matched Experiments", this.createHCLViewer(nodeList.getNode(i), info, (int[][])clusters), (Object)new Integer(i))));
                    continue;
                }
                node.add(new DefaultMutableTreeNode(new LeafInfo("UnMatched Experiments", this.createHCLViewer(nodeList.getNode(i), info, (int[][])clusters), (Object)new Integer(i))));
            }
        } else {
            int i;
            if (!this.clusterGenes) {
                clusters = new int[1][];
                for (i = 0; i < ((int[][])clusters).length; ++i) {
                    clusters[i] = nodeList.getNode(i).getFeaturesIndexes();
                }
                if (info.hcl_samples) {
                    clusters = this.getOrderedIndices(nodeList, (int[][])clusters, info.hcl_genes);
                }
            }
            for (i = 0; i < n; ++i) {
                if (this.clusterGenes) {
                    if (i != 0) continue;
                    node.add(new DefaultMutableTreeNode(new LeafInfo("Matched Genes", this.createHCLViewer(nodeList.getNode(i), info, null))));
                    continue;
                }
                if (i != 0) continue;
                node.add(new DefaultMutableTreeNode(new LeafInfo("Matched Experiments", this.createHCLViewer(nodeList.getNode(i), info, (int[][])clusters), (Object)new Integer(i))));
            }
        }
        root.add(node);
    }

    private IViewer createHCLViewer(Node clusterNode, GeneralInfo info, int[][] sampleClusters) {
        HCLTreeData samples_result;
        HCLTreeData genes_result;
        HCLTreeData hCLTreeData = genes_result = info.hcl_genes ? this.getResult(clusterNode, 0) : null;
        HCLTreeData hCLTreeData2 = info.hcl_samples ? this.getResult(clusterNode, info.hcl_genes ? 4 : 0) : (samples_result = null);
        if (this.clusterGenes) {
            return new HCLViewer(this.experiment, clusterNode.getFeaturesIndexes(), genes_result, samples_result);
        }
        return new HCLViewer(this.experiment, clusterNode.getFeaturesIndexes(), genes_result, samples_result, sampleClusters, true);
    }

    private void addClusterInfo(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Cluster Information");
        if (this.clusterGenes) {
            node.add(new DefaultMutableTreeNode(new LeafInfo("Matching Results (#,%)", (IViewer)new PTMInfoViewer(this.clusters, this.experiment.getNumberOfGenes()))));
        } else {
            node.add(new DefaultMutableTreeNode(new LeafInfo("Matching Results (#,%)", (IViewer)new PTMInfoViewer(this.clusters, this.experiment.getNumberOfSamples(), this.clusterGenes))));
        }
        root.add(node);
    }

    private void addCentroidViews(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode centroidNode = new DefaultMutableTreeNode("Centroid Graphs");
        DefaultMutableTreeNode expressionNode = new DefaultMutableTreeNode("Expression Graphs");
        if (this.clusterGenes) {
            PTMCentroidViewer centroidViewer = new PTMCentroidViewer(this.experiment, this.clusters, this.templateVector, this.auxTitles, this.auxData);
            centroidViewer.setMeans(this.means.A);
            centroidViewer.setVariances(this.variances.A);
            for (int i = 0; i < this.clusters.length; ++i) {
                if (i == 0) {
                    centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Matched Genes ", (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 0))));
                    expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Matched Genes ", (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 1))));
                    continue;
                }
                centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Unmatched Genes ", (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 0))));
                expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Unmatched Genes ", (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 1))));
            }
            PTMCentroidsViewer centroidsViewer = new PTMCentroidsViewer(this.experiment, this.clusters, this.templateVector, this.auxTitles, this.auxData);
            centroidsViewer.setMeans(this.means.A);
            centroidsViewer.setVariances(this.variances.A);
            centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)centroidsViewer, (Object)new Integer(0))));
            expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)centroidsViewer, (Object)new Integer(1))));
        } else {
            PTMExperimentCentroidViewer expCentroidViewer = new PTMExperimentCentroidViewer(this.experiment, this.clusters, this.templateVector, this.auxTitles, this.auxData);
            float[][] codes = this.getCodes(this.templateVector);
            expCentroidViewer.setMeans(this.means.A);
            expCentroidViewer.setVariances(this.variances.A);
            for (int i = 0; i < this.clusters.length; ++i) {
                if (i == 0) {
                    centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Matched Experiments ", (IViewer)expCentroidViewer, (Object)new CentroidUserObject(i, 0))));
                    expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Matched Experiments ", (IViewer)expCentroidViewer, (Object)new CentroidUserObject(i, 1))));
                    continue;
                }
                centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Unmatched Experiments ", (IViewer)expCentroidViewer, (Object)new CentroidUserObject(i, 0))));
                expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Unmatched Experiments ", (IViewer)expCentroidViewer, (Object)new CentroidUserObject(i, 1))));
            }
            PTMExperimentCentroidsViewer expCentroidsViewer = new PTMExperimentCentroidsViewer(this.experiment, this.clusters, this.templateVector, this.auxTitles, this.auxData);
            expCentroidsViewer.setMeans(this.means.A);
            expCentroidsViewer.setVariances(this.variances.A);
            centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)expCentroidsViewer, (Object)new Integer(0))));
            expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)expCentroidsViewer, (Object)new Integer(1))));
        }
        root.add(centroidNode);
        root.add(expressionNode);
    }

    private void addStatsTables(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode tablesNode = new DefaultMutableTreeNode("Table views");
        if (this.clusterGenes) {
            ClusterTableViewer tabViewer = new ClusterTableViewer(this.experiment, this.clusters, this.data, this.auxTitles, this.auxData);
            for (int i = 0; i < this.clusters.length; ++i) {
                if (i < this.clusters.length - 1) {
                    tablesNode.add(new DefaultMutableTreeNode(new LeafInfo("Matched Genes ", (IViewer)tabViewer, (Object)new Integer(i))));
                    continue;
                }
                if (i != this.clusters.length - 1) continue;
                tablesNode.add(new DefaultMutableTreeNode(new LeafInfo("Unmatched Genes ", (IViewer)tabViewer, (Object)new Integer(i))));
            }
        } else {
            ExperimentClusterTableViewer tabViewer = new ExperimentClusterTableViewer(this.experiment, this.clusters, this.data, this.auxTitles, this.auxData);
            for (int i = 0; i < this.clusters.length; ++i) {
                if (i < this.clusters.length - 1) {
                    tablesNode.add(new DefaultMutableTreeNode(new LeafInfo("Matched Experiments ", (IViewer)tabViewer, (Object)new Integer(i))));
                    continue;
                }
                if (i != this.clusters.length - 1) continue;
                tablesNode.add(new DefaultMutableTreeNode(new LeafInfo("Unmatched Experiments ", (IViewer)tabViewer, (Object)new Integer(i))));
            }
        }
        root.add(tablesNode);
    }

    public float[][] getCodes(Vector template) {
        int length = template.size();
        float[][] codes = new float[2][length];
        for (int i = 0; i < codes.length; ++i) {
            for (int j = 0; j < codes[i].length; ++j) {
                codes[i][j] = ((Float)template.elementAt(i)).intValue();
            }
        }
        return codes;
    }

    private void addGeneralInfo(DefaultMutableTreeNode root, GeneralInfo info) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("General Information");
        node.add(new DefaultMutableTreeNode("Absolute: " + String.valueOf(info.isAbsolute)));
        if (info.isR) {
            node.add(new DefaultMutableTreeNode("Threshold Pearson R: " + String.valueOf(info.threshold)));
        } else {
            node.add(new DefaultMutableTreeNode("Threshold prob. of R: " + String.valueOf(info.threshold)));
        }
        node.add(new DefaultMutableTreeNode("HCL: " + info.getMethodName()));
        node.add(new DefaultMutableTreeNode("Time: " + String.valueOf(info.time) + " ms"));
        node.add(new DefaultMutableTreeNode(info.function));
        root.add(node);
    }

    private int[][] getOrderedIndices(NodeList nodeList, int[][] sampleClusters, boolean calcGeneHCL) {
        for (int i = 0; i < sampleClusters.length; ++i) {
            if (sampleClusters[i].length <= 0) continue;
            HCLTreeData result = this.getResult(nodeList.getNode(i), calcGeneHCL ? 4 : 0);
            sampleClusters[i] = this.getSampleOrder(result, sampleClusters[i]);
        }
        return sampleClusters;
    }

    private int[] getSampleOrder(HCLTreeData result, int[] indices) {
        return this.getLeafOrder(result.node_order, result.child_1_array, result.child_2_array, indices);
    }

    private int[] getLeafOrder(int[] nodeOrder, int[] child1, int[] child2, int[] indices) {
        int[] leafOrder = new int[nodeOrder.length];
        Arrays.fill(leafOrder, -1);
        this.fillLeafOrder(leafOrder, child1, child2, 0, child1.length - 2, indices);
        return leafOrder;
    }

    private int fillLeafOrder(int[] leafOrder, int[] child1, int[] child2, int pos, int index, int[] indices) {
        if (child1[index] != -1) {
            pos = this.fillLeafOrder(leafOrder, child1, child2, pos, child1[index], indices);
        }
        if (child2[index] != -1) {
            pos = this.fillLeafOrder(leafOrder, child1, child2, pos, child2[index], indices);
        } else {
            leafOrder[pos] = indices == null ? index : indices[index];
            ++pos;
        }
        return pos;
    }

    private class GeneralInfo {
        public int clusters;
        public long time;
        public String function;
        public boolean isAbsolute;
        public boolean isR;
        public float threshold;
        private boolean hcl;
        private int hcl_method;
        private boolean hcl_genes;
        private boolean hcl_samples;

        private GeneralInfo() {
        }

        public String getMethodName() {
            return this.hcl ? HCLGUI.GeneralInfo.getMethodName(this.hcl_method) : "no linkage";
        }
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        private Listener() {
        }

        public void valueChanged(AlgorithmEvent event) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("cancel-command")) {
                PTMGUI.this.algorithm.abort();
                this.cleanUp();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            PTMGUI.this.algorithm.abort();
            this.cleanUp();
        }

        public void cleanUp() {
        }
    }
}

