/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ptm;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.tigr.microarray.mev.cluster.ClusterWrapper;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.ptm.PTMExperimentHeader;

public class PTMExperimentViewer
extends ExperimentViewer
implements IViewer {
    protected static final String STORE_CLUSTER_CMD = "store-cluster-cmd";
    protected static final String SET_DEF_COLOR_CMD = "set-def-color-cmd";
    protected static final String SAVE_CLUSTER_CMD = "save-cluster-cmd";
    protected static final String SAVE_ALL_CLUSTERS_CMD = "save-all-clusters-cmd";
    protected static final String LAUNCH_NEW_SESSION_CMD = "launch-new-session-cmd";
    private ExperimentViewer expViewer;
    private PTMExperimentHeader header;
    private String[] auxTitles;
    private Object[][] auxData;
    private int[][] clusters;
    private Vector templateVector;

    public PTMExperimentViewer(Experiment experiment, ClusterWrapper clusters, Vector templateVector, String[] auxTitles, Object[][] auxData) {
        this(experiment, clusters.getClusters(), templateVector, auxTitles, auxData);
    }

    public PTMExperimentViewer(Experiment experiment, int[][] clusters, Vector templateVector, String[] auxTitles, Object[][] auxData) {
        this.expViewer = new ExperimentViewer(experiment, clusters);
        this.auxTitles = auxTitles;
        this.auxData = auxData;
        this.clusters = clusters;
        this.templateVector = templateVector;
        this.header = new PTMExperimentHeader(this.expViewer.getHeaderComponent(), templateVector);
        this.header.setColorImages(this.expViewer.getNegColorImage(), this.expViewer.getPosColorImage());
        this.header.setMissingColor(this.expViewer.getMissingColor());
    }

    public Expression getExpression() {
        return new Expression((Object)this, ((Object)((Object)this)).getClass(), "new", new Object[]{this.expViewer.getExperiment(), ClusterWrapper.wrapClusters((int[][])this.clusters), this.templateVector, this.auxTitles, this.auxData});
    }

    public void setExperiment(Experiment e) {
        this.expViewer.setExperiment(e);
    }

    public void setExperimentID(int i) {
        this.expViewer.setExperimentID(i);
    }

    public int getExperimentID() {
        return this.expViewer.getExperimentID();
    }

    public JComponent getHeaderComponent() {
        return this.header;
    }

    public JComponent getContentComponent() {
        return this.expViewer.getContentComponent();
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public JComponent getCornerComponent(int cornerIndex) {
        return null;
    }

    public BufferedImage getImage() {
        return this.expViewer.getImage();
    }

    public void onSelected(IFramework framework) {
        this.expViewer.onSelected(framework);
        this.header.setCurrentCluster((Integer)framework.getUserObject());
        IDisplayMenu menu = framework.getDisplayMenu();
        this.header.setUseDoubleGradient(menu.getUseDoubleGradient());
        this.header.setColorImages(menu.getPositiveGradientImage(), menu.getNegativeGradientImage());
        this.header.setValues(menu.getMinRatioScale(), menu.getMidRatioValue(), menu.getMaxRatioScale());
        this.header.setAntiAliasing(menu.isAntiAliasing());
        this.header.setDrawBorders(menu.isDrawingBorder());
        this.header.updateSize(menu.getElementSize());
    }

    public void onDataChanged(IData data) {
        this.expViewer.onDataChanged(data);
    }

    public void onMenuChanged(IDisplayMenu menu) {
        this.expViewer.onMenuChanged(menu);
        this.header.setUseDoubleGradient(menu.getUseDoubleGradient());
        this.header.setColorImages(menu.getPositiveGradientImage(), menu.getNegativeGradientImage());
        this.header.setValues(menu.getMinRatioScale(), menu.getMidRatioValue(), menu.getMaxRatioScale());
        this.header.setAntiAliasing(menu.isAntiAliasing());
        this.header.setDrawBorders(menu.isDrawingBorder());
        this.header.updateSize(menu.getElementSize());
    }

    public void onDeselected() {
    }

    public void onClosed() {
    }

    protected void addMenuItems(JPopupMenu menu, ActionListener listener) {
        JMenuItem menuItem = new JMenuItem("Store cluster", GUIFactory.getIcon("new16.gif"));
        menuItem.setActionCommand(STORE_CLUSTER_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Launch new session", GUIFactory.getIcon("analysis16.gif"));
        menuItem.setActionCommand(LAUNCH_NEW_SESSION_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Delete public cluster", GUIFactory.getIcon("delete16.gif"));
        menuItem.setActionCommand(SET_DEF_COLOR_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Save cluster...", GUIFactory.getIcon("save16.gif"));
        menuItem.setActionCommand(SAVE_CLUSTER_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Save all clusters...", GUIFactory.getIcon("save16.gif"));
        menuItem.setActionCommand(SAVE_ALL_CLUSTERS_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
    }

    protected void onSaveClusters() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            ExperimentUtil.saveAllGeneClustersWithAux((Frame)frame, (Experiment)this.expViewer.getExperiment(), (IData)this.expViewer.getData(), (int[][])this.expViewer.getClusters(), (String[])this.auxTitles, (Object[][])this.auxData);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(frame, "Can not save clusters!", e.toString(), 0);
            e.printStackTrace();
        }
    }

    protected void onSaveCluster() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            ExperimentUtil.saveGeneClusterWithAux((Frame)frame, (Experiment)this.expViewer.getExperiment(), (IData)this.expViewer.getData(), (int[])this.expViewer.getCluster(), (String[])this.auxTitles, (Object[][])this.auxData);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(frame, "Can not save cluster!", e.toString(), 0);
            e.printStackTrace();
        }
    }

    protected void onSetDefaultColor() {
        this.expViewer.setClusterColor(null);
    }

    public int[][] getClusters() {
        return this.expViewer.getClusters();
    }

    public Experiment getExperiment() {
        return this.expViewer.getExperiment();
    }

    public int getViewerType() {
        return this.expViewer.getViewerType();
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals(PTMExperimentViewer.SAVE_CLUSTER_CMD)) {
                PTMExperimentViewer.this.onSaveCluster();
            } else if (command.equals(PTMExperimentViewer.SAVE_ALL_CLUSTERS_CMD)) {
                PTMExperimentViewer.this.onSaveClusters();
            } else if (command.equals(PTMExperimentViewer.SET_DEF_COLOR_CMD)) {
                PTMExperimentViewer.this.onSetDefaultColor();
            } else if (command.equals(PTMExperimentViewer.STORE_CLUSTER_CMD)) {
                PTMExperimentViewer.this.expViewer.storeCluster();
            } else if (command.equals(PTMExperimentViewer.LAUNCH_NEW_SESSION_CMD)) {
                PTMExperimentViewer.this.expViewer.launchNewSession();
            } else if (command.equals("broadcast-matrix-to-gaggle")) {
                PTMExperimentViewer.this.broadcastClusterGaggle();
            } else if (command.equals("broadcast-namelist-to-gaggle")) {
                PTMExperimentViewer.this.broadcastNamelistGaggle();
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            this.maybeShowPopup(event);
        }

        @Override
        public void mousePressed(MouseEvent event) {
            this.maybeShowPopup(event);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (!e.isPopupTrigger() || PTMExperimentViewer.this.expViewer.getCluster() == null || PTMExperimentViewer.this.expViewer.getCluster().length == 0) {
                return;
            }
            PTMExperimentViewer.this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }
}

