/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ptm;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.beans.Encoder;
import java.beans.Expression;
import java.beans.PersistenceDelegate;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class PTMExperimentHeader
extends JPanel {
    private PTMVectorPanel ptmVectorPanel;
    private static final String PTM_TEMPLATE_STRING = "Template";
    private Insets insets = new Insets(0, 10, 0, 0);
    private BufferedImage posColorImage;
    private BufferedImage negColorImage;
    private boolean useDoubleGradient = true;
    private JComponent expHeader;
    private Vector templateVector;

    public PTMExperimentHeader(JComponent expHeader, Vector templateVector) {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.white);
        this.expHeader = expHeader;
        this.templateVector = templateVector;
        this.ptmVectorPanel = new PTMVectorPanel(templateVector);
        this.add((Component)expHeader, "North");
        this.add((Component)this.ptmVectorPanel, "South");
    }

    public static PersistenceDelegate getPersistenceDelegate() {
        return new PTMExperimentHeaderPersistenceDelegate();
    }

    public Vector getTemplateVector() {
        return this.templateVector;
    }

    public JComponent getExpHeader() {
        return this.expHeader;
    }

    public void setUseDoubleGradient(boolean useDouble) {
        this.useDoubleGradient = useDouble;
    }

    public void updateSize(Dimension size) {
        this.ptmVectorPanel.updateSize(size);
    }

    public void setCurrentCluster(int cluster) {
        this.ptmVectorPanel.setCurrentCluster(cluster);
    }

    public void setDrawBorders(boolean draw) {
        this.ptmVectorPanel.setDrawBorders(draw);
    }

    public void setValues(float minValue, float maxValue) {
        this.ptmVectorPanel.setValues(minValue, maxValue);
    }

    public void setValues(float minValue, float midValue, float maxValue) {
        this.ptmVectorPanel.setValues(minValue, midValue, maxValue);
    }

    public void setColorImages(BufferedImage posColorImage, BufferedImage negColorImage) {
        this.posColorImage = posColorImage;
        this.negColorImage = negColorImage;
    }

    public void setMissingColor(Color color) {
        this.ptmVectorPanel.setMissingColor(color);
    }

    public void setAntiAliasing(boolean value) {
        this.ptmVectorPanel.setAntiAliasing(value);
    }

    private static class PTMExperimentHeaderPersistenceDelegate
    extends PersistenceDelegate {
        private PTMExperimentHeaderPersistenceDelegate() {
        }

        @Override
        protected Expression instantiate(Object o, Encoder encoder) {
            PTMExperimentHeader oldInstance = (PTMExperimentHeader)o;
            return new Expression(oldInstance, oldInstance.getClass(), "new", new Object[]{oldInstance.getExpHeader(), oldInstance.getTemplateVector()});
        }

        public void initialize(Class type, Object oldInstance, Object newInstance, Encoder encoder) {
        }
    }

    private class PTMVectorPanel
    extends JPanel {
        private Vector templateVector;
        private int cluster;
        private float maxValue = 3.0f;
        private float minValue = -3.0f;
        private float midValue = 0.0f;
        private Dimension elementSize;
        private boolean drawBorders = true;
        private boolean isAntiAliasing = false;
        private Color missingColor = new Color(128, 128, 128);

        public PTMVectorPanel(Vector templateVector) {
            this.setBackground(Color.white);
            this.templateVector = templateVector;
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            oos.defaultWriteObject();
            oos.writeObject(this.templateVector);
            oos.writeInt(this.cluster);
            oos.writeFloat(this.maxValue);
            oos.writeFloat(this.minValue);
            oos.writeObject(this.elementSize);
            oos.writeBoolean(this.drawBorders);
            oos.writeBoolean(this.isAntiAliasing);
            oos.writeObject(this.missingColor);
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            ois.defaultReadObject();
            this.templateVector = (Vector)ois.readObject();
            this.cluster = ois.readInt();
            this.maxValue = ois.readFloat();
            this.minValue = ois.readFloat();
            this.elementSize = (Dimension)ois.readObject();
            this.drawBorders = ois.readBoolean();
            this.isAntiAliasing = ois.readBoolean();
            this.missingColor = (Color)ois.readObject();
        }

        public void setMissingColor(Color color) {
            this.missingColor = color;
        }

        public void setCurrentCluster(int cluster) {
            this.cluster = cluster;
        }

        public void setDrawBorders(boolean draw) {
            this.drawBorders = draw;
        }

        public void setAntiAliasing(boolean value) {
            this.isAntiAliasing = value;
        }

        public void setValues(float minValue, float maxValue) {
            this.maxValue = maxValue;
            this.minValue = minValue;
        }

        public void setValues(float minValue, float midValue, float maxValue) {
            this.maxValue = maxValue;
            this.minValue = minValue;
            this.midValue = midValue;
        }

        public void setLeftInset(int leftMargin) {
            ((PTMExperimentHeader)PTMExperimentHeader.this).insets.left = leftMargin;
        }

        public void updateSize(Dimension size) {
            this.elementSize = new Dimension(size);
            this.setFont(new Font("monospaced", 0, size.height));
            Graphics2D g = (Graphics2D)this.getGraphics();
            if (this.isAntiAliasing) {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            FontMetrics metrics = g.getFontMetrics();
            int strWidth = metrics.stringWidth(PTMExperimentHeader.PTM_TEMPLATE_STRING) + 10;
            int width = size.width * this.templateVector.size() + strWidth;
            int height = size.height + 10;
            this.setSize(width, height);
            this.setPreferredSize(new Dimension(width, height));
        }

        @Override
        public void paint(Graphics g) {
            int i;
            super.paint(g);
            if (this.isAntiAliasing) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            int samples = this.templateVector.size();
            Vector<Float> scaledTemplateVector = new Vector<Float>();
            float max = this.getMax(this.templateVector);
            float min = this.getMin(this.templateVector);
            for (i = 0; i < this.templateVector.size(); ++i) {
                float current = ((Float)this.templateVector.get(i)).floatValue();
                if (current == max) {
                    scaledTemplateVector.add(new Float(3.0f));
                    continue;
                }
                if (current == min) {
                    scaledTemplateVector.add(new Float(-3.0f));
                    continue;
                }
                float scaledValue = 6.0f * ((current - min) / (max - min)) - 3.0f;
                scaledTemplateVector.add(new Float(scaledValue));
            }
            for (i = 0; i < samples; ++i) {
                this.fillRectAt(g, i, this.getColor(((Float)scaledTemplateVector.get(i)).floatValue()));
                if (!this.drawBorders) continue;
                this.drawRectAt(g, i, Color.black);
            }
            g.setColor(Color.black);
            g.drawString(PTMExperimentHeader.PTM_TEMPLATE_STRING, this.elementSize.width * samples + 10 + ((PTMExperimentHeader)PTMExperimentHeader.this).insets.left, this.elementSize.height);
        }

        private float getMax(Vector gene) {
            float max = Float.MIN_VALUE;
            for (int i = 0; i < gene.size(); ++i) {
                float current;
                if (Float.isNaN(((Float)gene.get(i)).floatValue()) || !((current = ((Float)gene.get(i)).floatValue()) > max)) continue;
                max = current;
            }
            return max;
        }

        private float getMin(Vector gene) {
            float min = Float.MAX_VALUE;
            for (int i = 0; i < gene.size(); ++i) {
                float current;
                if (Float.isNaN(((Float)gene.get(i)).floatValue()) || !((current = ((Float)gene.get(i)).floatValue()) < min)) continue;
                min = current;
            }
            return min;
        }

        private void fillRectAt(Graphics g, int sample, Color color) {
            g.setColor(color);
            g.fillRect(sample * this.elementSize.width + ((PTMExperimentHeader)PTMExperimentHeader.this).insets.left, 0, this.elementSize.width, this.elementSize.height);
        }

        private void drawRectAt(Graphics g, int sample, Color color) {
            g.setColor(color);
            g.drawRect(sample * this.elementSize.width, 0, this.elementSize.width - 1, this.elementSize.height - 1);
        }

        private Color getColor(float value) {
            int rgb;
            if (Float.isNaN(value)) {
                return this.missingColor;
            }
            if (PTMExperimentHeader.this.useDoubleGradient) {
                float maximum = value < this.midValue ? this.minValue : this.maxValue;
                int colorIndex = (int)(255.0f * (value - this.midValue) / (maximum - this.midValue));
                if (colorIndex < 0) {
                    colorIndex = -colorIndex;
                }
                colorIndex = colorIndex > 255 ? 255 : colorIndex;
                rgb = value < this.midValue ? PTMExperimentHeader.this.negColorImage.getRGB(255 - colorIndex, 0) : PTMExperimentHeader.this.posColorImage.getRGB(colorIndex, 0);
            } else {
                float span = this.maxValue - this.minValue;
                int colorIndex = value <= this.minValue ? 0 : (value >= this.maxValue ? 255 : (int)((value - this.minValue) / span * 255.0f));
                rgb = PTMExperimentHeader.this.posColorImage.getRGB(colorIndex, 0);
            }
            return new Color(rgb);
        }
    }
}

