/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ptm;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.Expression;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.ptm.PTMExperimentCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ptm.PTMExperimentSubCentroidsViewer;

public class PTMExperimentCentroidsViewer
extends PTMExperimentSubCentroidsViewer {
    private static final String SAVE_ALL_CLUSTERS_CMD = "save-all-clusters-cmd";
    private static final String SET_Y_TO_EXPERIMENT_MAX_CMD = "set-y-to-exp-max-cmd";
    private static final String SET_Y_TO_CLUSTER_MAX_CMD = "set-y-to-cluster-max-cmd";
    private JPopupMenu popup;
    private JMenuItem setOverallMaxMenuItem;
    private JMenuItem setClusterMaxMenuItem;
    private String[] auxTitles;
    private Object[][] auxData;

    public PTMExperimentCentroidsViewer(Experiment experiment, int[][] clusters, Vector template, String[] auxTitles, Object[][] auxData) {
        super(experiment, clusters, template, auxTitles, auxData);
        Listener listener = new Listener();
        this.auxTitles = auxTitles;
        this.auxData = auxData;
        this.popup = this.createJPopupMenu(listener);
        this.getContentComponent().addMouseListener(listener);
    }

    public PTMExperimentCentroidsViewer(PTMExperimentCentroidViewer cv, String[] auxTitles, Object[][] auxData) {
        super(cv);
        this.auxTitles = auxTitles;
        this.auxData = auxData;
        Listener listener = new Listener();
        this.auxTitles = auxTitles;
        this.auxData = auxData;
        this.popup = this.createJPopupMenu(listener);
        this.getContentComponent().addMouseListener(listener);
    }

    @Override
    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{this.centroidViewer, this.auxTitles, this.auxData});
    }

    private JPopupMenu createJPopupMenu(Listener listener) {
        JPopupMenu popup = new JPopupMenu();
        this.addMenuItems(popup, listener);
        return popup;
    }

    private void addMenuItems(JPopupMenu menu, Listener listener) {
        JMenuItem menuItem = new JMenuItem("Save all clusters", GUIFactory.getIcon("save16.gif"));
        menuItem.setActionCommand(SAVE_ALL_CLUSTERS_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        this.setOverallMaxMenuItem = new JMenuItem("Set Y to overall max...", GUIFactory.getIcon("Y_range_expand.gif"));
        this.setOverallMaxMenuItem.setActionCommand(SET_Y_TO_EXPERIMENT_MAX_CMD);
        this.setOverallMaxMenuItem.addActionListener(listener);
        this.setOverallMaxMenuItem.setEnabled(false);
        menu.add(this.setOverallMaxMenuItem);
        this.setClusterMaxMenuItem = new JMenuItem("Set Y to cluster max...", GUIFactory.getIcon("Y_range_expand.gif"));
        this.setClusterMaxMenuItem.setActionCommand(SET_Y_TO_CLUSTER_MAX_CMD);
        this.setClusterMaxMenuItem.addActionListener(listener);
        menu.add(this.setClusterMaxMenuItem);
    }

    private void onSaveClusters() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            ExperimentUtil.saveAllExperimentClustersWithAux((Frame)frame, (Experiment)this.getExperiment(), (IData)this.getData(), (int[][])this.getClusters(), (String[])this.auxTitles, (Object[][])this.auxData);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(frame, "Can not save cluster!", e.toString(), 0);
            e.printStackTrace();
        }
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals(PTMExperimentCentroidsViewer.SAVE_ALL_CLUSTERS_CMD)) {
                PTMExperimentCentroidsViewer.this.onSaveClusters();
            } else if (command.equals(PTMExperimentCentroidsViewer.SET_Y_TO_EXPERIMENT_MAX_CMD)) {
                this.setAllYRanges(CentroidViewer.USE_EXPERIMENT_MAX);
                PTMExperimentCentroidsViewer.this.setClusterMaxMenuItem.setEnabled(true);
                PTMExperimentCentroidsViewer.this.setOverallMaxMenuItem.setEnabled(false);
                PTMExperimentCentroidsViewer.this.repaint();
            } else if (command.equals(PTMExperimentCentroidsViewer.SET_Y_TO_CLUSTER_MAX_CMD)) {
                this.setAllYRanges(CentroidViewer.USE_CLUSTER_MAX);
                PTMExperimentCentroidsViewer.this.setClusterMaxMenuItem.setEnabled(false);
                PTMExperimentCentroidsViewer.this.setOverallMaxMenuItem.setEnabled(true);
                PTMExperimentCentroidsViewer.this.repaint();
            }
        }

        private void setAllYRanges(int yRangeOption) {
            int numClusters = PTMExperimentCentroidsViewer.this.getClusters().length;
            for (int i = 0; i < numClusters; ++i) {
                PTMExperimentCentroidsViewer.this.centroidViewer.setClusterIndex(i);
                PTMExperimentCentroidsViewer.this.centroidViewer.setYRangeOption(yRangeOption);
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            this.maybeShowPopup(event);
        }

        @Override
        public void mousePressed(MouseEvent event) {
            this.maybeShowPopup(event);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (!e.isPopupTrigger()) {
                return;
            }
            PTMExperimentCentroidsViewer.this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }
}

