/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ptm;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.Expression;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.tigr.microarray.mev.cluster.ClusterWrapper;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentClusterCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;

public class PTMExperimentCentroidViewer
extends ExperimentClusterCentroidViewer {
    private Vector templateVector;
    private int numberOfGenes;
    private String[] auxTitles;
    private Object[][] auxData;

    public PTMExperimentCentroidViewer(Experiment experiment, int[][] clusters, Vector templateVector, String[] auxTitles, Object[][] auxData) {
        super(experiment, clusters);
        this.numberOfGenes = experiment.getNumberOfGenes();
        Listener listener = new Listener();
        this.popup = this.createJPopupMenu(listener);
        this.templateVector = templateVector;
        this.auxTitles = auxTitles;
        this.auxData = auxData;
        this.getContentComponent().addMouseListener(listener);
    }

    public PTMExperimentCentroidViewer(Experiment e, ClusterWrapper clusters, Integer clusterIndex, float[][] means, float[][] variances, float[][] codes, Vector templateVector, String[] auxTitles, String[][] auxData) {
        this(e, clusters.getClusters(), clusterIndex, means, variances, codes, templateVector, auxTitles, (Object[][])auxData);
    }

    public PTMExperimentCentroidViewer(Experiment experiment, int[][] clusters, Integer clusterIndex, float[][] means, float[][] variances, float[][] codes, Vector templateVector, String[] auxTitles, Object[][] auxData) {
        super(experiment, clusters, clusterIndex, means, variances, codes);
        Listener listener = new Listener();
        this.popup = this.createJPopupMenu(listener);
        this.templateVector = templateVector;
        this.auxTitles = auxTitles;
        this.auxData = auxData;
        this.getContentComponent().addMouseListener(listener);
    }

    public Expression getExpression() {
        return new Expression((Object)this, ((Object)((Object)this)).getClass(), "new", new Object[]{this.getExperiment(), ClusterWrapper.wrapClusters((int[][])this.clusters), new Integer(this.clusterIndex), this.means, this.variances, this.codes, this.templateVector, this.auxTitles, this.auxData});
    }

    public void setExperiment(Experiment e) {
        super.setExperiment(e);
        this.numberOfGenes = this.experiment.getNumberOfGenes();
    }

    private JPopupMenu createJPopupMenu(Listener listener) {
        JPopupMenu popup = new JPopupMenu();
        this.addMenuItems(popup, listener);
        return popup;
    }

    protected void onSaveClusters() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            ExperimentUtil.saveAllExperimentClustersWithAux((Frame)frame, (Experiment)this.getExperiment(), (IData)this.getData(), (int[][])this.getClusters(), (String[])this.auxTitles, (Object[][])this.auxData);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(frame, "Can not save clusters!", e.toString(), 0);
            e.printStackTrace();
        }
    }

    private void onSaveCluster() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            ExperimentUtil.saveExperimentClusterWithAux((Frame)frame, (Experiment)this.getExperiment(), (IData)this.getData(), (int[])this.getCluster(), (String[])this.auxTitles, (Object[][])this.auxData);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(frame, "Can not save cluster!", e.toString(), 0);
            e.printStackTrace();
        }
    }

    private void onSetColor() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        Color newColor = JColorChooser.showDialog(frame, "Choose color", DEF_CLUSTER_COLOR);
        if (newColor != null) {
            this.setClusterColor(newColor);
        }
    }

    public void paint(Graphics g) {
        FontMetrics metrics = g.getFontMetrics();
        Rectangle rect = new Rectangle(40, 20, this.getWidth() - 80, this.getHeight() - 40 - this.getNamesWidth(metrics));
        this.paint((Graphics2D)g, rect, true);
    }

    public void paint(Graphics2D g, Rectangle rect, boolean drawMarks) {
        int i;
        int i2;
        super.subPaint(g, rect, drawMarks);
        if (this.isAntiAliasing) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        int left = rect.x;
        int top = rect.y;
        int width = rect.width;
        int height = rect.height;
        if (width < 5 || height < 5) {
            return;
        }
        int zeroValue = top + Math.round((float)height / 2.0f);
        int numberOfSamples = this.getCluster().length;
        if (this.yRangeOption == USE_EXPERIMENT_MAX) {
            this.maxYValue = this.maxExperimentValue;
        } else if (this.yRangeOption == USE_CLUSTER_MAX) {
            this.maxYValue = this.maxClusterValue;
        }
        if (this.maxYValue == 0.0f) {
            this.maxYValue = 1.0f;
        }
        float factor = (float)height / (2.0f * this.maxYValue);
        float stepX = (float)width / (float)(this.numberOfGenes - 1);
        int stepsY = (int)this.maxYValue + 1;
        if (this.drawVariances) {
            g.setColor(bColor);
            for (i2 = 0; i2 < this.numberOfGenes; ++i2) {
                if (Float.isNaN(this.means[this.clusterIndex][i2]) || Float.isNaN(this.variances[this.clusterIndex][i2]) || this.variances[this.clusterIndex][i2] < 0.0f) continue;
                g.drawLine(left + Math.round((float)i2 * stepX), zeroValue - Math.round((this.means[this.clusterIndex][i2] - this.variances[this.clusterIndex][i2]) * factor), left + Math.round((float)i2 * stepX), zeroValue - Math.round((this.means[this.clusterIndex][i2] + this.variances[this.clusterIndex][i2]) * factor));
                g.drawLine(left + Math.round((float)i2 * stepX) - 3, zeroValue - Math.round((this.means[this.clusterIndex][i2] - this.variances[this.clusterIndex][i2]) * factor), left + Math.round((float)i2 * stepX) + 3, zeroValue - Math.round((this.means[this.clusterIndex][i2] - this.variances[this.clusterIndex][i2]) * factor));
                g.drawLine(left + Math.round((float)i2 * stepX) - 3, zeroValue - Math.round((this.means[this.clusterIndex][i2] + this.variances[this.clusterIndex][i2]) * factor), left + Math.round((float)i2 * stepX) + 3, zeroValue - Math.round((this.means[this.clusterIndex][i2] + this.variances[this.clusterIndex][i2]) * factor));
            }
        }
        if (this.drawValues) {
            for (int sample = 0; sample < this.getCluster().length; ++sample) {
                for (int probe = 0; probe < this.numberOfGenes - 1; ++probe) {
                    float fValue = this.experiment.get(probe, this.getCluster()[sample]);
                    float sValue = this.experiment.get(probe + 1, this.getCluster()[sample]);
                    if (Float.isNaN(fValue) || Float.isNaN(sValue)) continue;
                    Color color = this.data.getExperimentColor(this.getCluster()[sample]);
                    color = color == null ? DEF_CLUSTER_COLOR : color;
                    g.setColor(color);
                    g.drawLine(left + Math.round((float)probe * stepX), zeroValue - Math.round(fValue * factor), left + Math.round((float)(probe + 1) * stepX), zeroValue - Math.round(sValue * factor));
                }
            }
        }
        if (this.drawCodes && this.codes != null && this.clusters[this.clusterIndex].length > 0) {
            g.setColor(Color.gray);
            for (i2 = 0; i2 < this.numberOfGenes - 1; ++i2) {
                g.drawLine(left + Math.round((float)i2 * stepX), zeroValue - Math.round(this.codes[this.clusterIndex][i2] * factor), left + Math.round((float)(i2 + 1) * stepX), zeroValue - Math.round(this.codes[this.clusterIndex][i2 + 1] * factor));
            }
        }
        g.setColor(Color.black);
        g.drawLine(left, zeroValue, left + width, zeroValue);
        if (this.getCluster() != null && this.getCluster().length > 0) {
            g.setColor(Color.magenta);
            for (i2 = 0; i2 < this.numberOfGenes - 1; ++i2) {
                if (Float.isNaN(this.means[this.clusterIndex][i2]) || Float.isNaN(this.means[this.clusterIndex][i2 + 1])) continue;
                g.drawLine(left + Math.round((float)i2 * stepX), zeroValue - Math.round(this.means[this.clusterIndex][i2] * factor), left + Math.round((float)(i2 + 1) * stepX), zeroValue - Math.round(this.means[this.clusterIndex][i2 + 1] * factor));
            }
        }
        float[] templateArray = new float[this.templateVector.size()];
        for (i = 0; i < templateArray.length; ++i) {
            templateArray[i] = ((Float)this.templateVector.get(i)).floatValue();
        }
        for (i = 0; i < templateArray.length; ++i) {
            templateArray[i] = templateArray[i] - 0.5f;
        }
        for (i = 0; i < this.numberOfGenes - 1; ++i) {
            g.setColor(Color.red);
            if (!Float.isNaN(templateArray[i])) {
                g.fillOval(left + Math.round((float)i * stepX) - 2, zeroValue - Math.round(templateArray[i] * factor) - 2, 5, 5);
            }
            if (!Float.isNaN(templateArray[i + 1])) {
                g.fillOval(left + Math.round((float)(i + 1) * stepX) - 2, zeroValue - Math.round(templateArray[i + 1] * factor) - 2, 5, 5);
            }
            if (Float.isNaN(templateArray[i]) || Float.isNaN(templateArray[i + 1])) continue;
            g.setColor(Color.blue);
            g.drawLine(left + Math.round((float)i * stepX), zeroValue - Math.round(templateArray[i] * factor), left + Math.round((float)(i + 1) * stepX), zeroValue - Math.round(templateArray[i + 1] * factor));
        }
        g.setColor(Color.black);
        g.drawRect(left, top, width, height);
        for (i = 1; i < this.numberOfGenes - 1; ++i) {
            g.drawLine(left + Math.round((float)i * stepX), top + height - 5, left + Math.round((float)i * stepX), top + height);
        }
        for (i = 1; i < stepsY; ++i) {
            g.drawLine(left, zeroValue - Math.round((float)i * factor), left + 5, zeroValue - Math.round((float)i * factor));
            g.drawLine(left, zeroValue + Math.round((float)i * factor), left + 5, zeroValue + Math.round((float)i * factor));
        }
        g.setColor(bColor);
        if (this.getCluster() != null && this.getCluster().length > 0 && this.drawVariances) {
            g.setColor(bColor);
            for (i = 0; i < this.numberOfGenes; ++i) {
                if (Float.isNaN(this.means[this.clusterIndex][i])) continue;
                g.fillOval(left + Math.round((float)i * stepX) - 3, zeroValue - Math.round(this.means[this.clusterIndex][i] * factor) - 3, 6, 6);
            }
        }
        g.setColor(bColor);
        if (this.getCluster() == null || this.getCluster().length == 0) {
            g.drawString("No Experiments In Cluster", left + 10, top + 20);
        } else if (this.getCluster().length == 1) {
            g.drawString("1 Experiment", left + 10, top + 20);
        } else {
            g.drawString(this.getCluster().length + " Experiments", left + 10, top + 20);
        }
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("save-cluster-cmd")) {
                PTMExperimentCentroidViewer.this.onSaveCluster();
            } else if (command.equals("save-all-clusters-cmd")) {
                PTMExperimentCentroidViewer.this.onSaveClusters();
            } else if (command.equals("set-def-color-cmd")) {
                PTMExperimentCentroidViewer.this.onSetDefaultColor();
            } else if (command.equals("set-y-to-exp-max-cmd")) {
                PTMExperimentCentroidViewer.this.yRangeOption = CentroidViewer.USE_EXPERIMENT_MAX;
                PTMExperimentCentroidViewer.this.setClusterMaxMenuItem.setEnabled(true);
                PTMExperimentCentroidViewer.this.setOverallMaxMenuItem.setEnabled(false);
                PTMExperimentCentroidViewer.this.repaint();
            } else if (command.equals("set-y-to-cluster-max-cmd")) {
                PTMExperimentCentroidViewer.this.yRangeOption = CentroidViewer.USE_CLUSTER_MAX;
                PTMExperimentCentroidViewer.this.setClusterMaxMenuItem.setEnabled(false);
                PTMExperimentCentroidViewer.this.setOverallMaxMenuItem.setEnabled(true);
                PTMExperimentCentroidViewer.this.repaint();
            } else if (command.equals("store-cluster-cmd")) {
                PTMExperimentCentroidViewer.this.storeCluster();
            } else if (command.equals("launch-new-session-cmd")) {
                PTMExperimentCentroidViewer.this.launchNewSession();
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            this.maybeShowPopup(event);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (!e.isPopupTrigger() || PTMExperimentCentroidViewer.this.getCluster() == null || PTMExperimentCentroidViewer.this.getCluster().length == 0) {
                return;
            }
            PTMExperimentCentroidViewer.this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }
}

