/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ptm;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;
import org.tigr.util.QSort;

public class PTMExpStatsTableViewer
extends ViewerAdapter {
    private JComponent header;
    private JComponent content;
    private Experiment experiment;
    private int[][] expClusters;
    private boolean sig;
    private int[] cols;
    private JTable pAndRValuesTable;
    private PAndRValuesTableModel pAndRModel;
    private String[] auxTitles;
    private Object[][] auxData;
    private IData data;
    private JPopupMenu popup;
    private Object[][] origData;
    private boolean[] sortedAscending;

    public PTMExpStatsTableViewer(Experiment experiment, int[][] expClusters, IData data, String[] auxTitles, Object[][] auxData, boolean sig) {
        int i;
        this.experiment = experiment;
        this.expClusters = expClusters;
        this.data = data;
        this.auxTitles = auxTitles;
        this.auxData = auxData;
        this.sig = sig;
        this.cols = sig ? expClusters[0] : expClusters[1];
        this.pAndRModel = new PAndRValuesTableModel();
        this.pAndRValuesTable = new JTable(this.pAndRModel);
        this.origData = new Object[this.pAndRModel.getRowCount()][this.pAndRModel.getColumnCount()];
        for (i = 0; i < this.origData.length; ++i) {
            for (int j = 0; j < this.origData[i].length; ++j) {
                this.origData[i][j] = this.pAndRModel.getValueAt(i, j);
            }
        }
        this.sortedAscending = new boolean[this.pAndRModel.getColumnCount()];
        for (i = 0; i < this.sortedAscending.length; ++i) {
            this.sortedAscending[i] = false;
        }
        TableColumn column = null;
        for (int i2 = 0; i2 < this.pAndRModel.getColumnCount(); ++i2) {
            column = this.pAndRValuesTable.getColumnModel().getColumn(i2);
            column.setMinWidth(30);
        }
        this.addMouseListenerToHeaderInTable(this.pAndRValuesTable);
        this.header = this.pAndRValuesTable.getTableHeader();
        this.setMaxWidth(this.getContentComponent(), this.getHeaderComponent());
    }

    public PTMExpStatsTableViewer(JComponent content, JComponent header) {
        this.content = content;
        this.header = header;
        this.setMaxWidth(this.getContentComponent(), this.getHeaderComponent());
    }

    @Override
    public JComponent getContentComponent() {
        JPanel panel = new JPanel();
        panel.setBackground(Color.white);
        GridBagConstraints constraints = new GridBagConstraints();
        GridBagLayout gridbag = new GridBagLayout();
        panel.setLayout(gridbag);
        constraints.fill = 2;
        constraints.anchor = 11;
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 100);
        gridbag.setConstraints(this.pAndRValuesTable, constraints);
        panel.add(this.pAndRValuesTable);
        final JFileChooser fc = new JFileChooser(TMEV.getDataPath());
        fc.setDialogTitle("Save p and R values");
        this.popup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Save p and R values", GUIFactory.getIcon("save16.gif"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int returnVal = fc.showSaveDialog(PTMExpStatsTableViewer.this.getHeaderComponent());
                if (returnVal == 0) {
                    File file = fc.getSelectedFile();
                    try {
                        int i;
                        PrintWriter out = new PrintWriter(new FileOutputStream(file));
                        out.print("Sample\t");
                        for (i = 0; i < PTMExpStatsTableViewer.this.auxTitles.length; ++i) {
                            out.print(PTMExpStatsTableViewer.this.auxTitles[i]);
                            if (i >= PTMExpStatsTableViewer.this.auxTitles.length - 1) continue;
                            out.print("\t");
                        }
                        out.println();
                        for (i = 0; i < PTMExpStatsTableViewer.this.cols.length; ++i) {
                            out.print(PTMExpStatsTableViewer.this.data.getFullSampleName(PTMExpStatsTableViewer.this.experiment.getSampleIndex(PTMExpStatsTableViewer.this.cols[i])));
                            for (int j = 0; j < PTMExpStatsTableViewer.this.auxData[PTMExpStatsTableViewer.this.cols[i]].length; ++j) {
                                out.print("\t" + ((Float)PTMExpStatsTableViewer.this.auxData[PTMExpStatsTableViewer.this.cols[i]][j]).floatValue());
                            }
                            out.print("\n");
                        }
                        out.println();
                        out.flush();
                        out.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.popup.add(menuItem);
        this.pAndRValuesTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    PTMExpStatsTableViewer.this.popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        return panel;
    }

    @Override
    public JComponent getHeaderComponent() {
        JPanel panel = new JPanel();
        panel.setBackground(Color.white);
        GridBagConstraints constraints = new GridBagConstraints();
        GridBagLayout gridbag = new GridBagLayout();
        panel.setLayout(gridbag);
        constraints.fill = 2;
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 100);
        gridbag.setConstraints(this.header, constraints);
        panel.add(this.header);
        return panel;
    }

    void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    private void setMaxWidth(JComponent content, JComponent header) {
        int c_width = content.getPreferredSize().width;
        int h_width = header.getPreferredSize().width;
        if (c_width > h_width) {
            header.setPreferredSize(new Dimension(c_width, header.getPreferredSize().height));
        } else {
            content.setPreferredSize(new Dimension(h_width, content.getPreferredSize().height));
        }
    }

    public void addMouseListenerToHeaderInTable(JTable table) {
        final JTable tableView = table;
        tableView.setColumnSelectionAllowed(false);
        MouseAdapter listMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = tableView.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = tableView.convertColumnIndexToModel(viewColumn);
                if (e.getClickCount() == 1 && column != -1) {
                    int shiftPressed = e.getModifiers() & 1;
                    int controlPressed = e.getModifiers() & 2;
                    boolean originalOrder = controlPressed != 0;
                    PTMExpStatsTableViewer.this.sortByColumn(column, !PTMExpStatsTableViewer.this.sortedAscending[column], originalOrder);
                    boolean bl = ((PTMExpStatsTableViewer)PTMExpStatsTableViewer.this).sortedAscending[column] = !PTMExpStatsTableViewer.this.sortedAscending[column];
                    if (originalOrder) {
                        for (int i = 0; i < PTMExpStatsTableViewer.this.pAndRModel.getColumnCount(); ++i) {
                            ((PTMExpStatsTableViewer)PTMExpStatsTableViewer.this).sortedAscending[i] = false;
                        }
                    }
                }
            }
        };
        JTableHeader th = tableView.getTableHeader();
        th.addMouseListener(listMouseListener);
    }

    public void sortByColumn(int column, boolean ascending, boolean originalOrder) {
        int j;
        int i;
        int i2;
        if (originalOrder) {
            for (int i3 = 0; i3 < this.pAndRModel.getRowCount(); ++i3) {
                for (int j2 = 0; j2 < this.pAndRModel.getColumnCount(); ++j2) {
                    this.pAndRModel.setValueAt(this.origData[i3][j2], i3, j2);
                }
            }
            return;
        }
        Object[][] sortedData = new Object[this.pAndRValuesTable.getRowCount()][this.pAndRValuesTable.getColumnCount()];
        float[] origArray = new float[this.cols.length];
        Object[] sortFields = new SortableField[this.cols.length];
        if (column == 0) {
            for (i2 = 0; i2 < sortFields.length; ++i2) {
                sortFields[i2] = new SortableField(i2, column);
            }
            Arrays.sort(sortFields);
        } else {
            for (i2 = 0; i2 < origArray.length; ++i2) {
                origArray[i2] = ((Float)this.auxData[this.cols[i2]][column - 1]).floatValue();
            }
        }
        int[] sortedIndices = new int[this.cols.length];
        if (column > 0) {
            QSort sortArray = new QSort(origArray);
            sortedIndices = sortArray.getOrigIndx();
        } else if (column == 0) {
            for (int i4 = 0; i4 < sortedIndices.length; ++i4) {
                sortedIndices[i4] = ((SortableField)sortFields[i4]).getIndex();
            }
        }
        if (!ascending) {
            sortedIndices = this.reverse(sortedIndices);
        }
        for (i = 0; i < sortedData.length; ++i) {
            for (j = 0; j < sortedData[i].length; ++j) {
                sortedData[i][j] = this.origData[sortedIndices[i]][j];
            }
        }
        for (i = 0; i < sortedData.length; ++i) {
            for (j = 0; j < sortedData[i].length; ++j) {
                this.pAndRModel.setValueAt(sortedData[i][j], i, j);
            }
        }
    }

    private int[] reverse(int[] arr) {
        int[] revArr = new int[arr.length];
        int revCount = 0;
        int count = arr.length - 1;
        for (int i = 0; i < arr.length; ++i) {
            revArr[revCount] = arr[count];
            ++revCount;
            --count;
        }
        return revArr;
    }

    private class SortableField
    implements Comparable {
        private String field;
        private int index;

        SortableField(int index, int column) {
            this.index = index;
            this.field = (String)PTMExpStatsTableViewer.this.origData[index][column];
        }

        public int compareTo(Object other) {
            SortableField otherField = (SortableField)other;
            return this.field.compareTo(otherField.getField());
        }

        public int getIndex() {
            return this.index;
        }

        public String getField() {
            return this.field;
        }
    }

    class PAndRValuesTableModel
    extends AbstractTableModel {
        String[] columnNames;
        Object[][] tableData;

        public PAndRValuesTableModel() {
            int i;
            this.columnNames = new String[1 + PTMExpStatsTableViewer.this.auxTitles.length];
            this.columnNames[0] = "Samples";
            for (i = 1; i < this.columnNames.length; ++i) {
                this.columnNames[i] = PTMExpStatsTableViewer.this.auxTitles[i - 1];
            }
            this.tableData = new Object[PTMExpStatsTableViewer.this.cols.length][this.columnNames.length];
            for (i = 0; i < this.tableData.length; ++i) {
                this.tableData[i][0] = PTMExpStatsTableViewer.this.data.getFullSampleName(PTMExpStatsTableViewer.this.experiment.getSampleIndex(PTMExpStatsTableViewer.this.cols[i]));
                for (int k = 1; k < this.tableData[i].length; ++k) {
                    float f = ((Float)PTMExpStatsTableViewer.this.auxData[PTMExpStatsTableViewer.this.cols[i]][k - 1]).floatValue();
                    this.tableData[i][k] = Float.isNaN(f) ? "N/A" : new Float(f);
                }
            }
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.tableData.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.tableData[row][col];
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.tableData[row][col] = value;
            this.fireTableCellUpdated(row, col);
        }
    }
}

