/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.pca;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.Serializable;
import java.text.DecimalFormat;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;
import org.tigr.util.FloatMatrix;

public class ValuesViewer
extends ViewerAdapter
implements Serializable {
    public static final long serialVersionUID = 202011050001L;
    private JComponent header;
    private JComponent content;

    public ValuesViewer(FloatMatrix S) {
        this.content = this.createContent(S);
        this.header = this.createHeader();
        this.setMaxWidth(this.content, this.header);
    }

    public ValuesViewer(JComponent content, JComponent header) {
        this.content = content;
        this.header = header;
        this.setMaxWidth(content, header);
    }

    @Override
    public JComponent getContentComponent() {
        return this.content;
    }

    @Override
    public JComponent getHeaderComponent() {
        return this.header;
    }

    private JComponent createHeader() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBackground(Color.white);
        JLabel label = new JLabel("<html><body bgcolor='#FFFFFF'><font face='serif' size='5' color='#000080'><b>Eigenvalues</b></font></body></html>");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(10, 0, 10, 0);
        panel.add((Component)label, gbc);
        return panel;
    }

    private JComponent createContent(FloatMatrix S) {
        JTextArea area = new JTextArea();
        area.setEditable(false);
        area.setMargin(new Insets(0, 10, 0, 0));
        DecimalFormat format = new DecimalFormat();
        format.setMinimumIntegerDigits(2);
        format.setMaximumFractionDigits(3);
        format.setMinimumFractionDigits(3);
        format.setGroupingUsed(false);
        float sum = 0.0f;
        int columns = S.getColumnDimension();
        for (int i = 0; i < columns; ++i) {
            sum += S.get(i, i);
        }
        float factor = 100.0f / sum;
        for (int i = 0; i < columns; ++i) {
            area.append("Principal Component " + new Integer(i + 1).toString() + "\t" + format.format(S.get(i, i)) + "\t" + format.format(S.get(i, i) * factor) + " %\n");
        }
        if (columns > 1) {
            area.append("\n");
            area.append("First 2 components: " + format.format((S.get(0, 0) + S.get(1, 1)) * factor) + " %\n");
            if (columns > 2) {
                area.append("First 3 components: " + format.format((S.get(0, 0) + S.get(1, 1) + S.get(2, 2)) * factor) + " %\n");
            }
        }
        return area;
    }

    private void setMaxWidth(JComponent content, JComponent header) {
        int c_width = content.getPreferredSize().width;
        int h_width = header.getPreferredSize().width;
        if (c_width > h_width) {
            header.setPreferredSize(new Dimension(c_width, header.getPreferredSize().height));
        } else {
            content.setPreferredSize(new Dimension(h_width, content.getPreferredSize().height));
        }
    }

    @Override
    public JComponent getRowHeaderComponent() {
        return null;
    }
}

