/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.pca;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.beans.Expression;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;
import org.tigr.util.FloatMatrix;

public class PlotViewer
extends ViewerAdapter
implements Serializable {
    private JComponent content;
    FloatMatrix S;

    public PlotViewer(FloatMatrix S) {
        this.content = this.createContent(S);
        this.S = S;
    }

    @Override
    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{this.S});
    }

    @Override
    public JComponent getContentComponent() {
        return this.content;
    }

    private JComponent createContent(FloatMatrix S) {
        return new Plot(S);
    }

    @Override
    public JComponent getRowHeaderComponent() {
        return null;
    }

    private class Plot
    extends JPanel {
        private static final int left = 40;
        private static final int top = 40;
        private FloatMatrix S;
        private Font font = new Font("monospaced", 1, 10);

        public Plot(FloatMatrix S) {
            this.setBackground(Color.white);
            this.setFont(this.font);
            this.S = S;
        }

        @Override
        public void paint(Graphics g) {
            int width;
            String str;
            int i;
            int curValue;
            int i2;
            super.paint(g);
            int plotWidth = this.getWidth() - 80;
            int plotHeight = this.getHeight() - 80;
            if (plotWidth < 5 || plotHeight < 5) {
                return;
            }
            g.setColor(Color.black);
            g.drawRect(40, 40, plotWidth, plotHeight);
            double maxValue = this.S.get(0, 0);
            if (Double.isNaN(maxValue)) {
                return;
            }
            int counter = 1;
            while (maxValue >= 10.0) {
                maxValue /= 10.0;
                counter *= 10;
            }
            int scale = (int)Math.round(maxValue + 0.5) * counter;
            int steps = (int)Math.round(maxValue + 0.5);
            double stepY = (double)plotHeight / (double)steps;
            for (int i3 = 1; i3 < steps; ++i3) {
                g.drawLine(40, 40 + (int)Math.round((double)i3 * stepY), 45, 40 + (int)Math.round((double)i3 * stepY));
            }
            double stepX = (double)plotWidth / ((double)this.S.getColumnDimension() - 1.0);
            for (int i4 = 1; i4 < this.S.getColumnDimension(); ++i4) {
                g.drawLine(40 + (int)Math.round((double)i4 * stepX), 40 + plotHeight - 5, 40 + (int)Math.round((double)i4 * stepX), 40 + plotHeight);
            }
            g.setColor(Color.magenta);
            double factor = (double)plotHeight / (double)scale;
            int prevValue = -((int)Math.round((double)this.S.get(0, 0) * factor));
            int zeroValue = 40 + plotHeight;
            for (i2 = 1; i2 < this.S.getColumnDimension(); ++i2) {
                curValue = -((int)Math.round((double)this.S.get(i2, i2) * factor));
                g.drawLine(40 + (int)Math.round((double)(i2 - 1) * stepX), zeroValue + prevValue, 40 + (int)Math.round((double)i2 * stepX), zeroValue + curValue);
                prevValue = curValue;
            }
            g.setColor(new Color(0, 0, 128));
            for (i2 = 0; i2 < this.S.getColumnDimension(); ++i2) {
                curValue = -((int)Math.round((double)this.S.get(i2, i2) * factor));
                g.fillOval(40 + (int)Math.round((double)i2 * stepX) - 3, zeroValue + curValue - 3, 6, 6);
            }
            FontMetrics metrics = g.getFontMetrics();
            for (i = 0; i <= steps; ++i) {
                str = String.valueOf(scale - counter * i);
                width = metrics.stringWidth(str);
                g.drawString(str, 30 - width, 40 + (int)Math.round((double)i * stepY) + 5);
            }
            ((Graphics2D)g).rotate(-1.5707963267948966);
            for (i = 0; i < this.S.getColumnDimension(); ++i) {
                str = String.valueOf(i + 1);
                width = metrics.stringWidth(str);
                g.drawString(str, -40 - plotHeight - 10 - width, 45 + (int)Math.round((double)i * stepX));
            }
            ((Graphics2D)g).rotate(1.5707963267948966);
        }
    }
}

