/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.pca;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.beans.Expression;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;
import org.tigr.util.FloatMatrix;

public class PlotVectorViewer
extends ViewerAdapter
implements Serializable {
    private JComponent content;
    private int current = -1;
    FloatMatrix T;

    public PlotVectorViewer(FloatMatrix T) {
        this.content = this.createContent(T);
        this.T = T;
    }

    @Override
    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{this.T});
    }

    @Override
    public JComponent getContentComponent() {
        return this.content;
    }

    @Override
    public void onSelected(IFramework framework) {
        Object userObject = framework.getUserObject();
        if (userObject instanceof Integer) {
            this.current = (Integer)userObject;
            return;
        }
        this.current = -1;
    }

    private JComponent createContent(FloatMatrix T) {
        return new Plot(T);
    }

    @Override
    public JComponent getRowHeaderComponent() {
        return null;
    }

    private class Plot
    extends JPanel {
        private static final int left = 40;
        private static final int top = 40;
        private FloatMatrix T;
        private Font font = new Font("monospaced", 1, 10);

        public Plot(FloatMatrix T) {
            this.setBackground(Color.white);
            this.setFont(this.font);
            this.T = T;
        }

        @Override
        public void paint(Graphics g) {
            int width;
            int i;
            int curValue;
            int i2;
            int i3;
            super.paint(g);
            int rows = this.T.getRowDimension();
            if (rows < 1) {
                return;
            }
            int plotWidth = this.getWidth() - 80;
            int plotHeight = this.getHeight() - 80;
            if (PlotVectorViewer.this.current == -1 || plotWidth < 5 || plotHeight < 5) {
                return;
            }
            double stepY = 1.0;
            double factor = plotHeight;
            double stepX = (double)plotWidth / ((double)rows - 1.0);
            double maxValue = this.T.get(0, PlotVectorViewer.this.current);
            if (Double.isNaN(maxValue)) {
                return;
            }
            for (int i4 = 0; i4 < rows; ++i4) {
                if (!((double)Math.abs(this.T.get(i4, PlotVectorViewer.this.current)) > maxValue)) continue;
                maxValue = Math.abs(this.T.get(i4, PlotVectorViewer.this.current));
            }
            double scale = 1.0;
            int counter = 1;
            int steps = 1;
            if (maxValue >= 1.0) {
                while (maxValue >= 10.0) {
                    maxValue /= 10.0;
                    counter *= 10;
                }
                steps = (int)Math.round(maxValue + 0.5);
                stepY = plotHeight / steps;
                factor /= scale * 2.0;
            } else {
                while (maxValue <= 1.0) {
                    maxValue *= 10.0;
                    counter = (int)((double)counter * 10.0);
                }
                scale = (int)Math.round(maxValue + 0.5);
                steps = (int)Math.round(maxValue + 0.5);
                stepY = plotHeight / (steps * 2);
            }
            factor = factor / (scale * 2.0) * (double)counter;
            int zeroValue = 40 + plotHeight / 2;
            g.setColor(Color.black);
            g.drawRect(40, 40, plotWidth, plotHeight);
            g.drawLine(40, 40 + plotHeight / 2, 40 + plotWidth, 40 + plotHeight / 2);
            FontMetrics metrics = g.getFontMetrics();
            int height = metrics.getHeight();
            for (i3 = 1; i3 < steps; ++i3) {
                g.drawLine(40, 40 + (int)Math.round((double)i3 * stepY), 45, 40 + (int)Math.round((double)i3 * stepY));
            }
            for (i3 = steps + 1; i3 < steps * 2; ++i3) {
                g.drawLine(40, 40 + (int)Math.round((double)i3 * stepY), 45, 40 + (int)Math.round((double)i3 * stepY));
            }
            for (i3 = 1; i3 < rows; ++i3) {
                g.drawLine(40 + (int)Math.round((double)i3 * stepX), 40 + plotHeight - 5, 40 + (int)Math.round((double)i3 * stepX), 40 + plotHeight);
            }
            g.setColor(Color.magenta);
            g.clipRect(40, 40, plotWidth, plotHeight);
            int prevValue = -((int)Math.round((double)this.T.get(0, PlotVectorViewer.this.current) * factor));
            for (i2 = 1; i2 < rows; ++i2) {
                curValue = -((int)Math.round((double)this.T.get(i2, PlotVectorViewer.this.current) * factor));
                g.drawLine(40 + (int)Math.round((double)(i2 - 1) * stepX), zeroValue + prevValue, 40 + (int)Math.round((double)i2 * stepX), zeroValue + curValue);
                prevValue = curValue;
            }
            g.setColor(new Color(0, 0, 128));
            for (i2 = 0; i2 < rows; ++i2) {
                curValue = -((int)Math.round((double)this.T.get(i2, PlotVectorViewer.this.current) * factor));
                g.fillOval(40 + (int)Math.round((double)i2 * stepX) - 3, zeroValue + curValue - 3, 6, 6);
            }
            g.setClip(0, 0, this.getWidth(), this.getHeight());
            for (i = 0; i <= steps * 2; ++i) {
                String str = String.valueOf((scale - (double)i) / (double)counter);
                width = metrics.stringWidth(str);
                g.drawString(str, 30 - width, 40 + (int)Math.round((double)i * stepY) + 5);
            }
            ((Graphics2D)g).rotate(-1.5707963267948966);
            for (i = 0; i < rows; ++i) {
                String str = String.valueOf(i + 1);
                width = metrics.stringWidth(str);
                g.drawString(str, -40 - plotHeight - 10 - width, 45 + (int)Math.round((double)i * stepX));
            }
            ((Graphics2D)g).rotate(1.5707963267948966);
        }
    }
}

