/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.pca;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.Expression;
import java.text.DecimalFormat;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;
import org.tigr.util.FloatMatrix;

public class PCInfoViewer
extends ViewerAdapter {
    private JComponent header;
    private JTextArea content;
    private JLabel headerLabel;
    private FloatMatrix T;
    private DecimalFormat format;

    public PCInfoViewer(FloatMatrix T) {
        this.T = T;
        this.format = new DecimalFormat();
        this.format.setMaximumFractionDigits(5);
        this.format.setMinimumFractionDigits(5);
        this.format.setGroupingUsed(false);
        this.headerLabel = new JLabel("<html><body bgcolor='#FFFFFF'><font face='serif' size='5' color='#000080'><b>Eigenvector</b></font></body></html>");
        this.header = this.createHeader(this.headerLabel);
        this.content = this.createContent();
        this.setMaxWidth(this.content, this.header);
    }

    @Override
    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{this.T});
    }

    @Override
    public void onSelected(IFramework framework) {
        Object userObject = framework.getUserObject();
        this.updateViewer((Integer)userObject);
    }

    @Override
    public JComponent getContentComponent() {
        return this.content;
    }

    @Override
    public JComponent getHeaderComponent() {
        return this.header;
    }

    private JComponent createHeader(JLabel label) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBackground(Color.white);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(10, 0, 10, 0);
        panel.add((Component)label, gbc);
        return panel;
    }

    private JTextArea createContent() {
        JTextArea area = new JTextArea(this.T.getRowDimension(), 20);
        area.setMargin(new Insets(0, 10, 0, 0));
        area.setEditable(false);
        return area;
    }

    private void updateViewer(int gen) {
        this.headerLabel.setText("<html><body bgcolor='#FFFFFF'><font face='serif' size='5' color='#000080'><b>Eigenvector " + String.valueOf(gen + 1) + "</b></font></body></html>");
        this.content.setText("");
        int rows = this.T.getRowDimension();
        StringBuffer sb = new StringBuffer(rows * 10);
        for (int i = 0; i < rows; ++i) {
            float value = this.T.get(i, gen);
            if (Float.isNaN(value)) {
                sb.append(String.valueOf(Float.NaN) + "\n");
                continue;
            }
            sb.append(this.format.format(value) + "\n");
        }
        this.content.setText(sb.toString());
        this.content.setCaretPosition(0);
    }

    private void setMaxWidth(JComponent content, JComponent header) {
        int c_width = content.getPreferredSize().width;
        int h_width = header.getPreferredSize().width;
        if (c_width > h_width) {
            header.setPreferredSize(new Dimension(c_width, header.getPreferredSize().height));
        } else {
            content.setPreferredSize(new Dimension(h_width, content.getPreferredSize().height));
        }
    }

    @Override
    public JComponent getRowHeaderComponent() {
        return null;
    }
}

