/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.pca;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.CenteringModePanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.SampleSelectionPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class PCASelectionDialog
extends AlgorithmDialog {
    private int result = 2;
    private SampleSelectionPanel sampleSelectionPanel;
    private CenteringModePanel centeringModePanel;
    private JPanel CovarianceMatrixType;
    private JPanel shortcutSelectionPanel;
    private JCheckBox shortcutCheckBox;
    private JRadioButton nnMatrix;
    private JRadioButton mmMatrix;
    private ButtonGroup matrixButtonGroup;
    JTextField numNeighborsField;

    public PCASelectionDialog(Frame frame) {
        super(frame, "PCA: Principal Components Analysis", true);
        this.setBounds(0, 0, 600, 200);
        this.setBackground(Color.white);
        this.setDefaultCloseOperation(2);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        JPanel pane = new JPanel();
        pane.setBackground(Color.white);
        pane.setBorder(new EtchedBorder());
        pane.setLayout(gridbag);
        this.sampleSelectionPanel = new SampleSelectionPanel(Color.white, UIManager.getColor("Label.foreground"), true, "Sample Selection");
        this.sampleSelectionPanel.setGeneButtonItemListener(new EventListener());
        this.sampleSelectionPanel.setSampleButtonItemListener(new EventListener());
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 50);
        gridbag.setConstraints(this.sampleSelectionPanel, constraints);
        pane.add(this.sampleSelectionPanel);
        this.centeringModePanel = new CenteringModePanel(Color.white, UIManager.getColor("Label.foreground"), true, "Centering Mode");
        this.buildConstraints(constraints, 0, 1, 1, 1, 0, 50);
        gridbag.setConstraints(this.centeringModePanel, constraints);
        pane.add(this.centeringModePanel);
        JPanel numNeibsPanel = new JPanel();
        numNeibsPanel.setBackground(Color.white);
        GridBagLayout grid2 = new GridBagLayout();
        JLabel numNeibsLabel = new JLabel("Number for neighbors for KNN imputation :");
        this.buildConstraints(constraints, 0, 0, 1, 1, 50, 100);
        grid2.setConstraints(numNeibsLabel, constraints);
        numNeibsPanel.add(numNeibsLabel);
        this.numNeighborsField = new JTextField("10", 7);
        this.buildConstraints(constraints, 1, 0, 1, 1, 50, 100);
        grid2.setConstraints(this.numNeighborsField, constraints);
        numNeibsPanel.add(this.numNeighborsField);
        this.buildConstraints(constraints, 0, 2, 1, 1, 0, 50);
        gridbag.setConstraints(numNeibsPanel, constraints);
        pane.add(numNeibsPanel);
        this.CovarianceMatrixType = new JPanel();
        this.CovarianceMatrixType.setBorder(new TitledBorder(new EtchedBorder(), "Algorithm Optimization", 0, 0, new Font("Dialog", 1, 12), Color.black));
        this.nnMatrix = new JRadioButton();
        this.mmMatrix = new JRadioButton();
        this.matrixButtonGroup = new ButtonGroup();
        this.nnMatrix.setText("Complete Algorithm");
        this.nnMatrix.setSelected(false);
        this.nnMatrix.setEnabled(false);
        this.nnMatrix.setBackground(Color.white);
        this.mmMatrix.setText("Optimized for speed (recommended)");
        this.mmMatrix.setSelected(true);
        this.mmMatrix.setEnabled(false);
        this.mmMatrix.setBackground(Color.white);
        this.matrixButtonGroup.add(this.mmMatrix);
        this.matrixButtonGroup.add(this.nnMatrix);
        this.CovarianceMatrixType.setLayout(new GridBagLayout());
        this.CovarianceMatrixType.add((Component)this.mmMatrix, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.CovarianceMatrixType.add((Component)this.nnMatrix, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.CovarianceMatrixType.add((Component)new JLabel("Most analyses by samples can be sufficiently approximated by running the faster algorithm."), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.CovarianceMatrixType.add((Component)new JLabel("The complete algorithm will dramatically increase calculation time for larger data sets."), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.CovarianceMatrixType.add((Component)new JLabel("Click INFO for more information."), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.CovarianceMatrixType.setEnabled(false);
        this.CovarianceMatrixType.setBackground(Color.white);
        pane.add(this.CovarianceMatrixType);
        this.buildConstraints(constraints, 0, 3, 1, 1, 0, 50);
        gridbag.setConstraints(this.CovarianceMatrixType, constraints);
        this.shortcutSelectionPanel = new JPanel();
        this.shortcutCheckBox = new JCheckBox("Utilize shortcut");
        this.shortcutCheckBox.setSelected(true);
        this.shortcutCheckBox.setFocusPainted(false);
        this.shortcutCheckBox.setBackground(Color.white);
        this.shortcutCheckBox.setForeground(UIManager.getColor("Label.foreground"));
        this.shortcutCheckBox.addItemListener(new EventListener());
        this.shortcutSelectionPanel.add(this.shortcutCheckBox);
        this.shortcutSelectionPanel.setBackground(Color.white);
        this.buildConstraints(constraints, 0, 3, 1, 1, 0, 50);
        gridbag.setConstraints(this.shortcutSelectionPanel, constraints);
        this.setActionListeners(new EventListener());
        this.addContent(pane);
        this.pack();
    }

    void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public boolean isClusterGenesSelected() {
        return this.sampleSelectionPanel.isClusterGenesSelected();
    }

    public boolean isCenteringNoneSelected() {
        return this.centeringModePanel.isNoneSelected();
    }

    public boolean isShortcutUsed() {
        return this.mmMatrix.isSelected();
    }

    public boolean isCenteringMedianSelected() {
        return this.centeringModePanel.isMedianSelected();
    }

    public void resetControls() {
        this.sampleSelectionPanel.setClusterGenesSelected(true);
    }

    public int getNumNeighbors() {
        return Integer.parseInt(this.numNeighborsField.getText());
    }

    public static void main(String[] args) {
        PCASelectionDialog dialog = new PCASelectionDialog(new Frame());
        int result = dialog.showModal();
        System.out.println("result = " + result);
        System.exit(0);
    }

    protected class EventListener
    implements ActionListener,
    ItemListener {
        protected EventListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String command = event.getActionCommand();
            if (command.equals("ok-command")) {
                try {
                    int numNeibs = PCASelectionDialog.this.getNumNeighbors();
                    if (numNeibs <= 0) {
                        JOptionPane.showMessageDialog(null, "Invalid number of neighbors", "Error", 0);
                        return;
                    }
                    PCASelectionDialog.this.result = 0;
                    PCASelectionDialog.this.dispose();
                }
                catch (NumberFormatException nfe) {
                    JOptionPane.showMessageDialog(null, "Invalid number of neighbors", "Error", 0);
                    return;
                }
            } else if (command.equals("cancel-command")) {
                PCASelectionDialog.this.result = 2;
                PCASelectionDialog.this.dispose();
            } else if (command.equals("reset-command")) {
                PCASelectionDialog.this.resetControls();
            } else if (command.equals("info-command")) {
                HelpWindow.launchBrowser(PCASelectionDialog.this, "PCA Initialization Dialog");
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() == PCASelectionDialog.this.sampleSelectionPanel.getSampleButton()) {
                PCASelectionDialog.this.nnMatrix.setEnabled(true);
                PCASelectionDialog.this.mmMatrix.setEnabled(true);
            }
            if (e.getSource() == PCASelectionDialog.this.sampleSelectionPanel.getGeneButton()) {
                PCASelectionDialog.this.nnMatrix.setEnabled(false);
                PCASelectionDialog.this.mmMatrix.setEnabled(false);
                PCASelectionDialog.this.mmMatrix.setSelected(true);
            }
        }
    }
}

