/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.pca;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.microarray.mev.cluster.gui.impl.pca.Content3D;

public class PCASelectionAreaDialog
extends AlgorithmDialog {
    private int result;
    private Content3D content;
    private JTextField textField1;
    private JTextField textField2;
    private JTextField textField3;
    private JTextField textField4;
    private JTextField textField5;
    private JTextField textField6;
    private float positionX;
    private float positionY;
    private float positionZ;
    private float sizeX;
    private float sizeY;
    private float sizeZ;
    private int initSizePos;
    private float initSize;
    private final float maxPos;
    private JSlider posXSlider;
    private JSlider posYSlider;
    private JSlider posZSlider;
    private JSlider sizeXSlider;
    private JSlider sizeYSlider;
    private JSlider sizeZSlider;

    public PCASelectionAreaDialog(Frame parent, float positionX, float positionY, float positionZ, float sizeX, float sizeY, float sizeZ) {
        super(parent, "PCA selection area configuration", true);
        this.positionX = positionX;
        this.positionY = positionY;
        this.positionZ = positionZ;
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
        this.maxPos = positionX;
        Listener listener = new Listener();
        this.addWindowListener(listener);
        JPanel parameters = new JPanel(new GridLayout(0, 2, 10, 0));
        parameters.setBorder(new EmptyBorder(20, 20, 20, 10));
        parameters.setBackground(Color.white);
        parameters.add(new JLabel("Position X  "));
        this.textField1 = new JTextField(Float.toString(positionX), 5);
        parameters.add((Component)this.textField1, "East");
        parameters.add(new JLabel("Position Y  "));
        this.textField2 = new JTextField(Float.toString(positionY), 5);
        parameters.add((Component)this.textField2, "East");
        parameters.add(new JLabel("Position Z  "));
        this.textField3 = new JTextField(Float.toString(positionZ), 5);
        parameters.add((Component)this.textField3, "East");
        parameters.add(new JLabel("Size X  "));
        this.textField4 = new JTextField(Float.toString(sizeX), 5);
        parameters.add((Component)this.textField4, "East");
        parameters.add(new JLabel("Size Y "));
        this.textField5 = new JTextField(Float.toString(sizeY), 5);
        parameters.add((Component)this.textField5, "East");
        parameters.add(new JLabel("Size Z "));
        this.textField6 = new JTextField(Float.toString(sizeZ), 5);
        parameters.add((Component)this.textField6, "East");
        JPanel panel3 = new JPanel(new BorderLayout());
        panel3.setForeground(Color.white);
        panel3.setBorder(BorderFactory.createLineBorder(Color.gray));
        panel3.setBackground(Color.white);
        panel3.add((Component)parameters, "West");
        panel3.add((Component)new JLabel(GUIFactory.getIcon("dialog_button_bar.gif")), "East");
        JPanel panel1 = new JPanel(new BorderLayout());
        panel1.add((Component)panel3, "Center");
        this.addContent(panel1);
        this.setActionListeners(listener);
        this.pack();
        this.setResizable(false);
    }

    public PCASelectionAreaDialog(Content3D content, Frame parent, float positionX, float positionY, float positionZ, float sizeX, float sizeY, float sizeZ, float maxPosition) {
        super(parent, "PCA selection area configuration", false);
        this.positionX = positionX;
        this.positionY = positionY;
        this.positionZ = positionZ;
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
        this.content = content;
        this.maxPos = maxPosition;
        this.posXSlider = new JSlider(-1000, 1000, 0);
        this.posYSlider = new JSlider(-1000, 1000, 0);
        this.posZSlider = new JSlider(-1000, 1000, 0);
        this.initSizePos = this.getSliderPos(sizeX);
        this.initSize = sizeX;
        this.sizeXSlider = new JSlider(0, 2000, this.initSizePos);
        this.sizeYSlider = new JSlider(0, 2000, this.initSizePos);
        this.sizeZSlider = new JSlider(0, 2000, this.initSizePos);
        this.posXSlider.setBackground(Color.white);
        this.posYSlider.setBackground(Color.white);
        this.posZSlider.setBackground(Color.white);
        this.sizeXSlider.setBackground(Color.white);
        this.sizeYSlider.setBackground(Color.white);
        this.sizeZSlider.setBackground(Color.white);
        this.textField1 = new JTextField(Float.toString(positionX), 5);
        this.textField2 = new JTextField(Float.toString(positionY), 5);
        this.textField3 = new JTextField(Float.toString(positionZ), 5);
        this.textField4 = new JTextField(Float.toString(sizeX), 5);
        this.textField5 = new JTextField(Float.toString(sizeY), 5);
        this.textField6 = new JTextField(Float.toString(sizeY), 5);
        this.textField1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    String s = PCASelectionAreaDialog.this.textField1.getText();
                    float val = Float.parseFloat(s);
                    int sliderValue = PCASelectionAreaDialog.this.getSliderPos(val);
                    if (sliderValue >= 1000) {
                        PCASelectionAreaDialog.this.posXSlider.setValue(1000);
                        PCASelectionAreaDialog.this.textField1.setText("" + PCASelectionAreaDialog.this.maxPos);
                    } else if (sliderValue <= -1000) {
                        PCASelectionAreaDialog.this.posXSlider.setValue(-1000);
                        PCASelectionAreaDialog.this.textField1.setText("" + -1.0f * PCASelectionAreaDialog.this.maxPos);
                    } else {
                        PCASelectionAreaDialog.this.posXSlider.setValue(sliderValue);
                        PCASelectionAreaDialog.this.textField1.setText("" + val);
                    }
                }
                catch (Exception exc) {
                    PCASelectionAreaDialog.this.posXSlider.setValue(0);
                    PCASelectionAreaDialog.this.textField1.setText("0.0");
                    PCASelectionAreaDialog.this.setPositionX(0.0f);
                    PCASelectionAreaDialog.this.updateContent();
                }
                String posString = PCASelectionAreaDialog.this.textField1.getText();
                float posX = Float.parseFloat(posString);
                PCASelectionAreaDialog.this.setPositionX(posX);
                PCASelectionAreaDialog.this.updateContent();
            }
        });
        this.textField1.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    String s = PCASelectionAreaDialog.this.textField1.getText();
                    float val = Float.parseFloat(s);
                    int sliderValue = PCASelectionAreaDialog.this.getSliderPos(val);
                    if (sliderValue >= 1000) {
                        PCASelectionAreaDialog.this.posXSlider.setValue(1000);
                        PCASelectionAreaDialog.this.textField1.setText("" + PCASelectionAreaDialog.this.maxPos);
                    } else if (sliderValue <= -1000) {
                        PCASelectionAreaDialog.this.posXSlider.setValue(-1000);
                        PCASelectionAreaDialog.this.textField1.setText("" + -1.0f * PCASelectionAreaDialog.this.maxPos);
                    } else {
                        PCASelectionAreaDialog.this.posXSlider.setValue(sliderValue);
                        PCASelectionAreaDialog.this.textField1.setText("" + val);
                    }
                }
                catch (Exception exc) {
                    PCASelectionAreaDialog.this.posXSlider.setValue(0);
                    PCASelectionAreaDialog.this.textField1.setText("0.0");
                    PCASelectionAreaDialog.this.setPositionX(0.0f);
                    PCASelectionAreaDialog.this.updateContent();
                }
                String posString = PCASelectionAreaDialog.this.textField1.getText();
                float posX = Float.parseFloat(posString);
                PCASelectionAreaDialog.this.setPositionX(posX);
                PCASelectionAreaDialog.this.updateContent();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        this.posXSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                int value = source.getValue();
                float displayValue = PCASelectionAreaDialog.this.getCoord(value);
                if (value == -1000) {
                    displayValue = -1.0f * PCASelectionAreaDialog.this.maxPos;
                }
                if (value == 1000) {
                    displayValue = PCASelectionAreaDialog.this.maxPos;
                }
                PCASelectionAreaDialog.this.textField1.setText("" + displayValue);
                String dString = PCASelectionAreaDialog.this.textField1.getText();
                float pos = Float.parseFloat(dString);
                PCASelectionAreaDialog.this.setPositionX(pos);
                PCASelectionAreaDialog.this.updateContent();
            }
        });
        this.textField2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    String s = PCASelectionAreaDialog.this.textField2.getText();
                    float val = Float.parseFloat(s);
                    int sliderValue = PCASelectionAreaDialog.this.getSliderPos(val);
                    if (sliderValue >= 1000) {
                        PCASelectionAreaDialog.this.posYSlider.setValue(1000);
                        PCASelectionAreaDialog.this.textField2.setText("" + PCASelectionAreaDialog.this.maxPos);
                    } else if (sliderValue <= -1000) {
                        PCASelectionAreaDialog.this.posYSlider.setValue(-1000);
                        PCASelectionAreaDialog.this.textField2.setText("" + -1.0f * PCASelectionAreaDialog.this.maxPos);
                    } else {
                        PCASelectionAreaDialog.this.posYSlider.setValue(sliderValue);
                        PCASelectionAreaDialog.this.textField2.setText("" + val);
                    }
                }
                catch (Exception exc) {
                    PCASelectionAreaDialog.this.posYSlider.setValue(0);
                    PCASelectionAreaDialog.this.textField2.setText("0.0");
                    PCASelectionAreaDialog.this.setPositionY(0.0f);
                    PCASelectionAreaDialog.this.updateContent();
                }
                String posString = PCASelectionAreaDialog.this.textField2.getText();
                float pos = Float.parseFloat(posString);
                PCASelectionAreaDialog.this.setPositionY(pos);
                PCASelectionAreaDialog.this.updateContent();
            }
        });
        this.textField2.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    String s = PCASelectionAreaDialog.this.textField2.getText();
                    float val = Float.parseFloat(s);
                    int sliderValue = PCASelectionAreaDialog.this.getSliderPos(val);
                    if (sliderValue >= 1000) {
                        PCASelectionAreaDialog.this.posYSlider.setValue(1000);
                        PCASelectionAreaDialog.this.textField2.setText("" + PCASelectionAreaDialog.this.maxPos);
                    } else if (sliderValue <= -1000) {
                        PCASelectionAreaDialog.this.posYSlider.setValue(-1000);
                        PCASelectionAreaDialog.this.textField2.setText("" + -1.0f * PCASelectionAreaDialog.this.maxPos);
                    } else {
                        PCASelectionAreaDialog.this.posYSlider.setValue(sliderValue);
                        PCASelectionAreaDialog.this.textField2.setText("" + val);
                    }
                }
                catch (Exception exc) {
                    PCASelectionAreaDialog.this.posYSlider.setValue(0);
                    PCASelectionAreaDialog.this.textField2.setText("0.0");
                    PCASelectionAreaDialog.this.setPositionY(0.0f);
                    PCASelectionAreaDialog.this.updateContent();
                }
                String posString = PCASelectionAreaDialog.this.textField2.getText();
                float pos = Float.parseFloat(posString);
                PCASelectionAreaDialog.this.setPositionY(pos);
                PCASelectionAreaDialog.this.updateContent();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        this.posYSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                int value = source.getValue();
                float displayValue = PCASelectionAreaDialog.this.getCoord(value);
                if (value == -1000) {
                    displayValue = -1.0f * PCASelectionAreaDialog.this.maxPos;
                }
                if (value == 1000) {
                    displayValue = PCASelectionAreaDialog.this.maxPos;
                }
                PCASelectionAreaDialog.this.textField2.setText("" + displayValue);
                String dString = PCASelectionAreaDialog.this.textField2.getText();
                float pos = Float.parseFloat(dString);
                PCASelectionAreaDialog.this.setPositionY(pos);
                PCASelectionAreaDialog.this.updateContent();
            }
        });
        this.textField3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    String s = PCASelectionAreaDialog.this.textField3.getText();
                    float val = Float.parseFloat(s);
                    int sliderValue = PCASelectionAreaDialog.this.getSliderPos(val);
                    if (sliderValue >= 1000) {
                        PCASelectionAreaDialog.this.posZSlider.setValue(1000);
                        PCASelectionAreaDialog.this.textField3.setText("" + PCASelectionAreaDialog.this.maxPos);
                    } else if (sliderValue <= -1000) {
                        PCASelectionAreaDialog.this.posZSlider.setValue(-1000);
                        PCASelectionAreaDialog.this.textField3.setText("" + -1.0f * PCASelectionAreaDialog.this.maxPos);
                    } else {
                        PCASelectionAreaDialog.this.posZSlider.setValue(sliderValue);
                        PCASelectionAreaDialog.this.textField3.setText("" + val);
                    }
                }
                catch (Exception exc) {
                    PCASelectionAreaDialog.this.posZSlider.setValue(0);
                    PCASelectionAreaDialog.this.textField3.setText("0.0");
                    PCASelectionAreaDialog.this.setPositionZ(0.0f);
                    PCASelectionAreaDialog.this.updateContent();
                }
                String posString = PCASelectionAreaDialog.this.textField3.getText();
                float pos = Float.parseFloat(posString);
                PCASelectionAreaDialog.this.setPositionZ(pos);
                PCASelectionAreaDialog.this.updateContent();
            }
        });
        this.textField3.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    String s = PCASelectionAreaDialog.this.textField3.getText();
                    float val = Float.parseFloat(s);
                    int sliderValue = PCASelectionAreaDialog.this.getSliderPos(val);
                    if (sliderValue >= 1000) {
                        PCASelectionAreaDialog.this.posZSlider.setValue(1000);
                        PCASelectionAreaDialog.this.textField3.setText("" + PCASelectionAreaDialog.this.maxPos);
                    } else if (sliderValue <= -1000) {
                        PCASelectionAreaDialog.this.posZSlider.setValue(-1000);
                        PCASelectionAreaDialog.this.textField3.setText("" + -1.0f * PCASelectionAreaDialog.this.maxPos);
                    } else {
                        PCASelectionAreaDialog.this.posZSlider.setValue(sliderValue);
                        PCASelectionAreaDialog.this.textField3.setText("" + val);
                    }
                }
                catch (Exception exc) {
                    PCASelectionAreaDialog.this.posZSlider.setValue(0);
                    PCASelectionAreaDialog.this.textField3.setText("0.0");
                    PCASelectionAreaDialog.this.setPositionZ(0.0f);
                    PCASelectionAreaDialog.this.updateContent();
                }
                String posString = PCASelectionAreaDialog.this.textField3.getText();
                float pos = Float.parseFloat(posString);
                PCASelectionAreaDialog.this.setPositionZ(pos);
                PCASelectionAreaDialog.this.updateContent();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        this.posZSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                int value = source.getValue();
                float displayValue = PCASelectionAreaDialog.this.getCoord(value);
                if (value == -1000) {
                    displayValue = -1.0f * PCASelectionAreaDialog.this.maxPos;
                }
                if (value == 1000) {
                    displayValue = PCASelectionAreaDialog.this.maxPos;
                }
                PCASelectionAreaDialog.this.textField3.setText("" + displayValue);
                String dString = PCASelectionAreaDialog.this.textField3.getText();
                float pos = Float.parseFloat(dString);
                PCASelectionAreaDialog.this.setPositionZ(pos);
                PCASelectionAreaDialog.this.updateContent();
            }
        });
        this.textField4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    String s = PCASelectionAreaDialog.this.textField4.getText();
                    float val = Float.parseFloat(s);
                    int sliderValue = PCASelectionAreaDialog.this.getSliderPos(val);
                    if (sliderValue >= 2000) {
                        PCASelectionAreaDialog.this.sizeXSlider.setValue(2000);
                        PCASelectionAreaDialog.this.textField4.setText("" + 2.0f * PCASelectionAreaDialog.this.maxPos);
                    } else if (sliderValue == 0) {
                        PCASelectionAreaDialog.this.sizeXSlider.setValue(0);
                        PCASelectionAreaDialog.this.textField4.setText("0.0");
                    } else {
                        PCASelectionAreaDialog.this.sizeXSlider.setValue(sliderValue);
                        PCASelectionAreaDialog.this.textField4.setText("" + val);
                    }
                }
                catch (Exception exc) {
                    PCASelectionAreaDialog.this.sizeXSlider.setValue(PCASelectionAreaDialog.this.initSizePos);
                    PCASelectionAreaDialog.this.textField4.setText("" + PCASelectionAreaDialog.this.initSize);
                    PCASelectionAreaDialog.this.setSizeX(PCASelectionAreaDialog.this.initSize);
                    PCASelectionAreaDialog.this.updateContent();
                }
                String sizeString = PCASelectionAreaDialog.this.textField4.getText();
                float size = Float.parseFloat(sizeString);
                PCASelectionAreaDialog.this.setSizeX(size);
                PCASelectionAreaDialog.this.updateContent();
            }
        });
        this.textField4.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    String s = PCASelectionAreaDialog.this.textField4.getText();
                    float val = Float.parseFloat(s);
                    int sliderValue = PCASelectionAreaDialog.this.getSliderPos(val);
                    if (sliderValue >= 2000) {
                        PCASelectionAreaDialog.this.sizeXSlider.setValue(2000);
                        PCASelectionAreaDialog.this.textField4.setText("" + 2.0f * PCASelectionAreaDialog.this.maxPos);
                    } else if (sliderValue == 0) {
                        PCASelectionAreaDialog.this.sizeXSlider.setValue(0);
                        PCASelectionAreaDialog.this.textField4.setText("0.0");
                    } else {
                        PCASelectionAreaDialog.this.sizeXSlider.setValue(sliderValue);
                        PCASelectionAreaDialog.this.textField4.setText("" + val);
                    }
                }
                catch (Exception exc) {
                    PCASelectionAreaDialog.this.sizeXSlider.setValue(PCASelectionAreaDialog.this.initSizePos);
                    PCASelectionAreaDialog.this.textField4.setText("" + PCASelectionAreaDialog.this.initSize);
                    PCASelectionAreaDialog.this.setSizeX(PCASelectionAreaDialog.this.initSize);
                    PCASelectionAreaDialog.this.updateContent();
                }
                String sizeString = PCASelectionAreaDialog.this.textField4.getText();
                float size = Float.parseFloat(sizeString);
                PCASelectionAreaDialog.this.setSizeX(size);
                PCASelectionAreaDialog.this.updateContent();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        this.sizeXSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                int value = source.getValue();
                float displayValue = PCASelectionAreaDialog.this.getCoord(value);
                if (value == 0) {
                    displayValue = 0.0f;
                }
                if (value == 2000) {
                    displayValue = 2.0f * PCASelectionAreaDialog.this.maxPos;
                }
                PCASelectionAreaDialog.this.textField4.setText("" + displayValue);
                String dString = PCASelectionAreaDialog.this.textField4.getText();
                float size = Float.parseFloat(dString);
                PCASelectionAreaDialog.this.setSizeX(size);
                PCASelectionAreaDialog.this.updateContent();
            }
        });
        this.textField5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    String s = PCASelectionAreaDialog.this.textField5.getText();
                    float val = Float.parseFloat(s);
                    int sliderValue = PCASelectionAreaDialog.this.getSliderPos(val);
                    if (sliderValue >= 2000) {
                        PCASelectionAreaDialog.this.sizeYSlider.setValue(2000);
                        PCASelectionAreaDialog.this.textField5.setText("" + 2.0f * PCASelectionAreaDialog.this.maxPos);
                    } else if (sliderValue == 0) {
                        PCASelectionAreaDialog.this.sizeYSlider.setValue(0);
                        PCASelectionAreaDialog.this.textField5.setText("0.0");
                    } else {
                        PCASelectionAreaDialog.this.sizeYSlider.setValue(sliderValue);
                        PCASelectionAreaDialog.this.textField5.setText("" + val);
                    }
                }
                catch (Exception exc) {
                    PCASelectionAreaDialog.this.sizeYSlider.setValue(PCASelectionAreaDialog.this.initSizePos);
                    PCASelectionAreaDialog.this.textField5.setText("" + PCASelectionAreaDialog.this.initSize);
                    PCASelectionAreaDialog.this.setSizeY(PCASelectionAreaDialog.this.initSize);
                    PCASelectionAreaDialog.this.updateContent();
                }
                String sizeString = PCASelectionAreaDialog.this.textField5.getText();
                float size = Float.parseFloat(sizeString);
                PCASelectionAreaDialog.this.setSizeY(size);
                PCASelectionAreaDialog.this.updateContent();
            }
        });
        this.textField5.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    String s = PCASelectionAreaDialog.this.textField5.getText();
                    float val = Float.parseFloat(s);
                    int sliderValue = PCASelectionAreaDialog.this.getSliderPos(val);
                    if (sliderValue >= 2000) {
                        PCASelectionAreaDialog.this.sizeYSlider.setValue(2000);
                        PCASelectionAreaDialog.this.textField5.setText("" + 2.0f * PCASelectionAreaDialog.this.maxPos);
                    } else if (sliderValue == 0) {
                        PCASelectionAreaDialog.this.sizeYSlider.setValue(0);
                        PCASelectionAreaDialog.this.textField5.setText("0.0");
                    } else {
                        PCASelectionAreaDialog.this.sizeYSlider.setValue(sliderValue);
                        PCASelectionAreaDialog.this.textField5.setText("" + val);
                    }
                }
                catch (Exception exc) {
                    PCASelectionAreaDialog.this.sizeYSlider.setValue(PCASelectionAreaDialog.this.initSizePos);
                    PCASelectionAreaDialog.this.textField5.setText("" + PCASelectionAreaDialog.this.initSize);
                    PCASelectionAreaDialog.this.setSizeY(PCASelectionAreaDialog.this.initSize);
                    PCASelectionAreaDialog.this.updateContent();
                }
                String sizeString = PCASelectionAreaDialog.this.textField5.getText();
                float size = Float.parseFloat(sizeString);
                PCASelectionAreaDialog.this.setSizeY(size);
                PCASelectionAreaDialog.this.updateContent();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        this.sizeYSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                int value = source.getValue();
                float displayValue = PCASelectionAreaDialog.this.getCoord(value);
                if (value == 0) {
                    displayValue = 0.0f;
                }
                if (value == 2000) {
                    displayValue = 2.0f * PCASelectionAreaDialog.this.maxPos;
                }
                PCASelectionAreaDialog.this.textField5.setText("" + displayValue);
                String dString = PCASelectionAreaDialog.this.textField5.getText();
                float size = Float.parseFloat(dString);
                PCASelectionAreaDialog.this.setSizeY(size);
                PCASelectionAreaDialog.this.updateContent();
            }
        });
        this.textField6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    String s = PCASelectionAreaDialog.this.textField6.getText();
                    float val = Float.parseFloat(s);
                    int sliderValue = PCASelectionAreaDialog.this.getSliderPos(val);
                    if (sliderValue >= 2000) {
                        PCASelectionAreaDialog.this.sizeZSlider.setValue(2000);
                        PCASelectionAreaDialog.this.textField6.setText("" + 2.0f * PCASelectionAreaDialog.this.maxPos);
                    } else if (sliderValue == 0) {
                        PCASelectionAreaDialog.this.sizeZSlider.setValue(0);
                        PCASelectionAreaDialog.this.textField6.setText("0.0");
                    } else {
                        PCASelectionAreaDialog.this.sizeZSlider.setValue(sliderValue);
                        PCASelectionAreaDialog.this.textField6.setText("" + val);
                    }
                }
                catch (Exception exc) {
                    PCASelectionAreaDialog.this.sizeZSlider.setValue(PCASelectionAreaDialog.this.initSizePos);
                    PCASelectionAreaDialog.this.textField6.setText("" + PCASelectionAreaDialog.this.initSize);
                    PCASelectionAreaDialog.this.setSizeZ(PCASelectionAreaDialog.this.initSize);
                    PCASelectionAreaDialog.this.updateContent();
                }
                String sizeString = PCASelectionAreaDialog.this.textField6.getText();
                float size = Float.parseFloat(sizeString);
                PCASelectionAreaDialog.this.setSizeZ(size);
                PCASelectionAreaDialog.this.updateContent();
            }
        });
        this.textField6.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    String s = PCASelectionAreaDialog.this.textField6.getText();
                    float val = Float.parseFloat(s);
                    int sliderValue = PCASelectionAreaDialog.this.getSliderPos(val);
                    if (sliderValue >= 2000) {
                        PCASelectionAreaDialog.this.sizeZSlider.setValue(2000);
                        PCASelectionAreaDialog.this.textField6.setText("" + 2.0f * PCASelectionAreaDialog.this.maxPos);
                    } else if (sliderValue == 0) {
                        PCASelectionAreaDialog.this.sizeZSlider.setValue(0);
                        PCASelectionAreaDialog.this.textField6.setText("0.0");
                    } else {
                        PCASelectionAreaDialog.this.sizeZSlider.setValue(sliderValue);
                        PCASelectionAreaDialog.this.textField6.setText("" + val);
                    }
                }
                catch (Exception exc) {
                    PCASelectionAreaDialog.this.sizeZSlider.setValue(PCASelectionAreaDialog.this.initSizePos);
                    PCASelectionAreaDialog.this.textField6.setText("" + PCASelectionAreaDialog.this.initSize);
                    PCASelectionAreaDialog.this.setSizeZ(PCASelectionAreaDialog.this.initSize);
                    PCASelectionAreaDialog.this.updateContent();
                }
                String sizeString = PCASelectionAreaDialog.this.textField6.getText();
                float size = Float.parseFloat(sizeString);
                PCASelectionAreaDialog.this.setSizeZ(size);
                PCASelectionAreaDialog.this.updateContent();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        this.sizeZSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                int value = source.getValue();
                float displayValue = PCASelectionAreaDialog.this.getCoord(value);
                if (value == 0) {
                    displayValue = 0.0f;
                }
                if (value == 2000) {
                    displayValue = 2.0f * PCASelectionAreaDialog.this.maxPos;
                }
                PCASelectionAreaDialog.this.textField6.setText("" + displayValue);
                String dString = PCASelectionAreaDialog.this.textField6.getText();
                float size = Float.parseFloat(dString);
                PCASelectionAreaDialog.this.setSizeZ(size);
                PCASelectionAreaDialog.this.updateContent();
            }
        });
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel pane = new JPanel();
        pane.setBackground(Color.white);
        pane.setBorder(new EtchedBorder());
        pane.setLayout(gridbag);
        JLabel posXLabel = new JLabel("Position X  ");
        this.buildConstraints(constraints, 0, 0, 1, 1, 25, 16);
        gridbag.setConstraints(posXLabel, constraints);
        pane.add(posXLabel);
        this.buildConstraints(constraints, 1, 0, 1, 1, 25, 0);
        gridbag.setConstraints(this.textField1, constraints);
        pane.add(this.textField1);
        this.buildConstraints(constraints, 2, 0, 1, 1, 50, 0);
        gridbag.setConstraints(this.posXSlider, constraints);
        pane.add(this.posXSlider);
        JLabel posYLabel = new JLabel("Position Y  ");
        this.buildConstraints(constraints, 0, 1, 1, 1, 25, 16);
        gridbag.setConstraints(posYLabel, constraints);
        pane.add(posYLabel);
        this.buildConstraints(constraints, 1, 1, 1, 1, 25, 0);
        gridbag.setConstraints(this.textField2, constraints);
        pane.add(this.textField2);
        this.buildConstraints(constraints, 2, 1, 1, 1, 50, 0);
        gridbag.setConstraints(this.posYSlider, constraints);
        pane.add(this.posYSlider);
        JLabel posZLabel = new JLabel("Position Z  ");
        this.buildConstraints(constraints, 0, 2, 1, 1, 25, 17);
        gridbag.setConstraints(posZLabel, constraints);
        pane.add(posZLabel);
        this.buildConstraints(constraints, 1, 2, 1, 1, 25, 0);
        gridbag.setConstraints(this.textField3, constraints);
        pane.add(this.textField3);
        this.buildConstraints(constraints, 2, 2, 1, 1, 50, 0);
        gridbag.setConstraints(this.posZSlider, constraints);
        pane.add(this.posZSlider);
        JLabel sizeXLabel = new JLabel("Size X  ");
        this.buildConstraints(constraints, 0, 3, 1, 1, 25, 17);
        gridbag.setConstraints(sizeXLabel, constraints);
        pane.add(sizeXLabel);
        this.buildConstraints(constraints, 1, 3, 1, 1, 25, 0);
        gridbag.setConstraints(this.textField4, constraints);
        pane.add(this.textField4);
        this.buildConstraints(constraints, 2, 3, 1, 1, 50, 0);
        gridbag.setConstraints(this.sizeXSlider, constraints);
        pane.add(this.sizeXSlider);
        JLabel sizeYLabel = new JLabel("Size Y  ");
        this.buildConstraints(constraints, 0, 4, 1, 1, 25, 17);
        gridbag.setConstraints(sizeYLabel, constraints);
        pane.add(sizeYLabel);
        this.buildConstraints(constraints, 1, 4, 1, 1, 25, 0);
        gridbag.setConstraints(this.textField5, constraints);
        pane.add(this.textField5);
        this.buildConstraints(constraints, 2, 4, 1, 1, 50, 0);
        gridbag.setConstraints(this.sizeYSlider, constraints);
        pane.add(this.sizeYSlider);
        JLabel sizeZLabel = new JLabel("Size Z  ");
        this.buildConstraints(constraints, 0, 5, 1, 1, 25, 17);
        gridbag.setConstraints(sizeZLabel, constraints);
        pane.add(sizeZLabel);
        this.buildConstraints(constraints, 1, 5, 1, 1, 25, 0);
        gridbag.setConstraints(this.textField6, constraints);
        pane.add(this.textField6);
        this.buildConstraints(constraints, 2, 5, 1, 1, 50, 0);
        gridbag.setConstraints(this.sizeZSlider, constraints);
        pane.add(this.sizeZSlider);
        this.addContent(pane);
        Listener listener = new Listener();
        this.addWindowListener(listener);
        this.setActionListeners(listener);
        this.pack();
    }

    private int getSliderPos(float pos) {
        return Math.round(1000.0f / this.maxPos * pos);
    }

    private float getCoord(int sliderPos) {
        return this.maxPos * (float)sliderPos / 1000.0f;
    }

    void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public float getPositionX() {
        return Float.parseFloat(this.textField1.getText());
    }

    private void setPositionX(float posX) {
        this.positionX = posX;
    }

    public float getPositionY() {
        return Float.parseFloat(this.textField2.getText());
    }

    private void setPositionY(float posY) {
        this.positionY = posY;
    }

    public float getPositionZ() {
        return Float.parseFloat(this.textField3.getText());
    }

    private void setPositionZ(float posZ) {
        this.positionZ = posZ;
    }

    public float getSizeX() {
        return Float.parseFloat(this.textField4.getText());
    }

    private void setSizeX(float val) {
        this.sizeX = val;
    }

    public float getSizeY() {
        return Float.parseFloat(this.textField5.getText());
    }

    private void setSizeY(float val) {
        this.sizeY = val;
    }

    public float getSizeZ() {
        return Float.parseFloat(this.textField6.getText());
    }

    private void setSizeZ(float val) {
        this.sizeZ = val;
    }

    private void updateContent() {
        this.content.setBoxPosition(this.getPositionX(), this.getPositionY(), this.getPositionZ());
        this.content.setBoxSize(this.getSizeX(), this.getSizeY(), this.getSizeZ());
        this.content.updateScene();
    }

    private void updateContentToInit() {
        this.content.setBoxPosition(0.0f, 0.0f, 0.0f);
        this.content.setBoxSize(this.initSize, this.initSize, this.initSize);
        this.content.updateScene();
    }

    private void resetValues() {
        this.posXSlider.setValue(0);
        this.posYSlider.setValue(0);
        this.posZSlider.setValue(0);
        this.sizeXSlider.setValue(this.initSizePos);
        this.sizeYSlider.setValue(this.initSizePos);
        this.sizeZSlider.setValue(this.initSizePos);
        this.textField1.setText("0.0");
        this.textField2.setText("0.0");
        this.textField3.setText("0.0");
        this.textField4.setText("" + this.initSize);
        this.textField5.setText("" + this.initSize);
        this.textField6.setText("" + this.initSize);
    }

    public static void main(String[] args) {
        PCASelectionAreaDialog dialog = new PCASelectionAreaDialog(new Frame(), 0.0f, 0.0f, 0.0f, 5.0f, 5.0f, 5.0f);
        dialog.showModal();
    }

    private class Listener
    extends DialogListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("ok-command")) {
                try {
                    Float.parseFloat(PCASelectionAreaDialog.this.textField1.getText());
                    Float.parseFloat(PCASelectionAreaDialog.this.textField2.getText());
                    Float.parseFloat(PCASelectionAreaDialog.this.textField3.getText());
                    Float.parseFloat(PCASelectionAreaDialog.this.textField4.getText());
                    Float.parseFloat(PCASelectionAreaDialog.this.textField5.getText());
                    Float.parseFloat(PCASelectionAreaDialog.this.textField6.getText());
                    PCASelectionAreaDialog.this.result = 0;
                }
                catch (Exception exception) {
                    PCASelectionAreaDialog.this.result = 2;
                }
                PCASelectionAreaDialog.this.dispose();
            } else if (command.equals("cancel-command")) {
                PCASelectionAreaDialog.this.result = 2;
                PCASelectionAreaDialog.this.dispose();
            } else if (command.equals("reset-command")) {
                PCASelectionAreaDialog.this.resetValues();
                PCASelectionAreaDialog.this.updateContentToInit();
            } else if (command.equals("info-command")) {
                HelpWindow.launchBrowser(PCASelectionAreaDialog.this, "PCA Selection Area Configuration");
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            PCASelectionAreaDialog.this.result = -1;
            PCASelectionAreaDialog.this.dispose();
        }
    }
}

