/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.pca;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Logger;
import org.tigr.microarray.mev.cluster.gui.impl.pca.PCA2DViewer;
import org.tigr.microarray.mev.cluster.gui.impl.pca.PCA3DViewer;
import org.tigr.microarray.mev.cluster.gui.impl.pca.PCAAdditional3DAxesDialog;
import org.tigr.microarray.mev.cluster.gui.impl.pca.PCADummyViewer;
import org.tigr.microarray.mev.cluster.gui.impl.pca.PCASelectionDialog;
import org.tigr.microarray.mev.cluster.gui.impl.pca.PCInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.pca.PlotVectorViewer;
import org.tigr.microarray.mev.cluster.gui.impl.pca.PlotViewer;
import org.tigr.microarray.mev.cluster.gui.impl.pca.ValuesViewer;
import org.tigr.microarray.mev.script.scriptGUI.IScriptGUI;
import org.tigr.util.FloatMatrix;

public class PCAGUI
implements IClusterGUI,
IScriptGUI {
    private static final String ADD_NEW_3D_CMD = "add-new-3d-cmd";
    private static final String ADD_NEW_2D_CMD = "add-new-2d-cmd";
    private int mode;
    private int numNeibs;
    private int center;
    private int shortcut;
    private FloatMatrix T;
    private FloatMatrix V;
    private FloatMatrix S;
    private FloatMatrix U;
    private Algorithm algorithm;
    private Logger logger;
    private IFramework currFramework;
    private DefaultMutableTreeNode projectionNode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework framework) throws AlgorithmException {
        Listener listener = new Listener();
        try {
            PCASelectionDialog dialog = new PCASelectionDialog(framework.getFrame());
            if (dialog.showModal() == 2) {
                DefaultMutableTreeNode defaultMutableTreeNode = null;
                return defaultMutableTreeNode;
            }
            this.mode = dialog.isClusterGenesSelected() ? 1 : 3;
            this.center = dialog.isCenteringMedianSelected() ? 1 : (dialog.isCenteringNoneSelected() ? 3 : 2);
            this.shortcut = dialog.isShortcutUsed() ? 0 : 1;
            this.numNeibs = dialog.getNumNeighbors();
            this.algorithm = framework.getAlgorithmFactory().getAlgorithm("PCA");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            this.logger = new Logger(framework.getFrame(), "PCA Log Window", listener);
            this.logger.show();
            this.logger.append("Starting SVD calculation\n");
            this.currFramework = framework;
            AlgorithmData data = new AlgorithmData();
            Experiment experiment = framework.getData().getExperiment();
            data.addMatrix("experiment", experiment.getMatrix());
            data.addParam("distance-factor", String.valueOf(1.0f));
            IDistanceMenu menu = framework.getDistanceMenu();
            data.addParam("distance-absolute", String.valueOf(menu.isAbsoluteDistance()));
            int function = menu.getDistanceFunction();
            if (function == 0) {
                function = 3;
            }
            data.addParam("distance-function", String.valueOf(function));
            data.addParam("pca-mode", String.valueOf(this.mode));
            data.addParam("centering", String.valueOf(this.center));
            data.addParam("numNeighbors", String.valueOf(this.numNeibs));
            data.addParam("use-shortcut", String.valueOf(this.shortcut));
            AlgorithmData result = null;
            DefaultMutableTreeNode node = null;
            long start = System.currentTimeMillis();
            switch (this.mode) {
                case 1: {
                    data.addParam("distance-function", String.valueOf(function));
                    result = this.algorithm.execute(data);
                    this.T = result.getMatrix("T");
                    this.V = result.getMatrix("V");
                    this.S = result.getMatrix("S");
                    this.U = result.getMatrix("U");
                    node = new DefaultMutableTreeNode("PCA - genes");
                    break;
                }
                case 3: {
                    result = this.algorithm.execute(data);
                    this.T = result.getMatrix("T");
                    this.V = result.getMatrix("V");
                    this.S = result.getMatrix("S");
                    this.U = result.getMatrix("U");
                    node = new DefaultMutableTreeNode("PCA - samples");
                    break;
                }
            }
            this.logger.append("Creating the result viewers");
            long time = System.currentTimeMillis() - start;
            this.addResultNodes(framework.getFrame(), node, time, menu.getFunctionName(function), experiment);
            DefaultMutableTreeNode defaultMutableTreeNode = node;
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
            if (this.logger != null) {
                this.logger.dispose();
            }
        }
    }

    public AlgorithmData getScriptParameters(IFramework framework) {
        PCASelectionDialog dialog = new PCASelectionDialog(framework.getFrame());
        if (dialog.showModal() == 2) {
            return null;
        }
        this.mode = dialog.isClusterGenesSelected() ? 1 : 3;
        this.numNeibs = dialog.getNumNeighbors();
        AlgorithmData data = new AlgorithmData();
        data.addParam("distance-factor", String.valueOf(1.0f));
        IDistanceMenu menu = framework.getDistanceMenu();
        data.addParam("distance-absolute", String.valueOf(menu.isAbsoluteDistance()));
        int function = menu.getDistanceFunction();
        if (function == 0) {
            function = 3;
        }
        data.addParam("distance-function", String.valueOf(function));
        data.addParam("pca-mode", String.valueOf(this.mode));
        data.addParam("numNeighbors", String.valueOf(this.numNeibs));
        data.addParam("use-shortcut", String.valueOf(this.shortcut));
        data.addParam("name", "PCA");
        data.addParam("alg-type", "data-visualization");
        data.addParam("output-class", "single-output");
        String[] outputNodes = new String[]{"Data Visualization"};
        data.addStringArray("output-nodes", outputNodes);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode executeScript(IFramework framework, AlgorithmData algData, Experiment experiment) throws AlgorithmException {
        Listener listener = new Listener();
        try {
            this.mode = algData.getParams().getInt("pca-mode");
            this.shortcut = algData.getParams().getInt("use-shortcut");
            this.numNeibs = algData.getParams().getInt("numNeighbors");
            int function = algData.getParams().getInt("distance-function");
            AlgorithmData result = null;
            DefaultMutableTreeNode node = null;
            algData.addMatrix("experiment", experiment.getMatrix());
            this.algorithm = framework.getAlgorithmFactory().getAlgorithm("PCA");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            this.logger = new Logger(framework.getFrame(), "PCA Log Window", listener);
            this.logger.show();
            this.logger.append("Starting SVD calculation\n");
            this.currFramework = framework;
            long start = System.currentTimeMillis();
            switch (this.mode) {
                case 1: {
                    result = this.algorithm.execute(algData);
                    this.T = result.getMatrix("T");
                    this.V = result.getMatrix("V");
                    this.S = result.getMatrix("S");
                    this.U = result.getMatrix("U");
                    node = new DefaultMutableTreeNode("PCA - genes");
                    break;
                }
                case 3: {
                    result = this.algorithm.execute(algData);
                    this.T = result.getMatrix("T");
                    this.V = result.getMatrix("V");
                    this.S = result.getMatrix("S");
                    this.U = result.getMatrix("U");
                    node = new DefaultMutableTreeNode("PCA - samples");
                    break;
                }
            }
            this.logger.append("Creating the result viewers");
            long time = System.currentTimeMillis() - start;
            this.addResultNodes(framework.getFrame(), node, time, framework.getDistanceMenu().getFunctionName(function), experiment);
            DefaultMutableTreeNode defaultMutableTreeNode = node;
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
            if (this.logger != null) {
                this.logger.dispose();
            }
        }
    }

    private void addResultNodes(Frame frame, DefaultMutableTreeNode node, long time, String function, Experiment experiment) {
        Listener listener = new Listener();
        PCADummyViewer pdv = new PCADummyViewer(this.U, this.S, this.mode);
        DefaultMutableTreeNode firstNode = new DefaultMutableTreeNode("Components 1, 2, 3");
        this.add3DViewNode(frame, firstNode, experiment, 0, 1, 2);
        DefaultMutableTreeNode twoDNode = new DefaultMutableTreeNode("2D Views");
        this.add2DViewNode(twoDNode, experiment, 0, 1, 2);
        firstNode.add(twoDNode);
        JPopupMenu projMenu = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Add new 3-axis projections");
        menuItem.setActionCommand(ADD_NEW_3D_CMD);
        menuItem.addActionListener(listener);
        projMenu.add(menuItem);
        menuItem = new JMenuItem("Add new 2-axis projections");
        menuItem.setActionCommand(ADD_NEW_2D_CMD);
        menuItem.addActionListener(listener);
        projMenu.add(menuItem);
        this.projectionNode = new DefaultMutableTreeNode(new LeafInfo("Projections on PC axes", (IViewer)pdv, pdv.getJPopupMenu()));
        this.projectionNode.add(firstNode);
        node.add(this.projectionNode);
        this.addPCPlotsNode(node);
        this.addPCInfoNode(node);
        this.addEigenNode(node);
        this.addGeneralInfoNode(node, time, function);
    }

    private void add2DViewNode(DefaultMutableTreeNode node, Experiment experiment) {
        boolean geneViewer = false;
        if (this.mode == 1) {
            geneViewer = true;
        } else if (this.mode == 3) {
            geneViewer = false;
        }
        PCA2DViewer pca01 = new PCA2DViewer(experiment, this.U, geneViewer, 0, 1);
        PCA2DViewer pca12 = new PCA2DViewer(experiment, this.U, geneViewer, 1, 2);
        PCA2DViewer pca02 = new PCA2DViewer(experiment, this.U, geneViewer, 0, 2);
        node.add(new DefaultMutableTreeNode(new LeafInfo("1, 2", (IViewer)pca01, pca01.getJPopupMenu())));
        node.add(new DefaultMutableTreeNode(new LeafInfo("2, 3", (IViewer)pca12, pca12.getJPopupMenu())));
        node.add(new DefaultMutableTreeNode(new LeafInfo("1, 3", (IViewer)pca02, pca02.getJPopupMenu())));
    }

    private void add2DViewNode(DefaultMutableTreeNode node, Experiment experiment, int xAxis, int yAxis, int zAxis) {
        boolean geneViewer = false;
        if (this.mode == 1) {
            geneViewer = true;
        } else if (this.mode == 3) {
            geneViewer = false;
        }
        PCA2DViewer pcaxy = new PCA2DViewer(experiment, this.U, geneViewer, xAxis, yAxis);
        PCA2DViewer pcayz = new PCA2DViewer(experiment, this.U, geneViewer, yAxis, zAxis);
        PCA2DViewer pcaxz = new PCA2DViewer(experiment, this.U, geneViewer, xAxis, zAxis);
        node.add(new DefaultMutableTreeNode(new LeafInfo("" + (xAxis + 1) + ", " + (yAxis + 1), (IViewer)pcaxy, pcaxy.getJPopupMenu())));
        node.add(new DefaultMutableTreeNode(new LeafInfo("" + (yAxis + 1) + ", " + (zAxis + 1), (IViewer)pcayz, pcayz.getJPopupMenu())));
        node.add(new DefaultMutableTreeNode(new LeafInfo("" + (xAxis + 1) + ", " + (zAxis + 1), (IViewer)pcaxz, pcaxz.getJPopupMenu())));
    }

    private void add3DViewNode(Frame frame, DefaultMutableTreeNode node, Experiment experiment) {
        if (this.U == null || this.U.getColumnDimension() < 3) {
            return;
        }
        PCA3DViewer pca3DViewer = this.mode == 1 ? new PCA3DViewer(frame, this.mode, this.U, experiment, true, 0, 1, 2) : new PCA3DViewer(frame, this.mode, this.U, experiment, false, 0, 1, 2);
        node.add(new DefaultMutableTreeNode(new LeafInfo("3D view", (IViewer)pca3DViewer, pca3DViewer.getJPopupMenu())));
    }

    private void add3DViewNode(Frame frame, DefaultMutableTreeNode node, Experiment experiment, int xAxis, int yAxis, int zAxis) {
        if (this.U == null || this.U.getColumnDimension() < 3) {
            return;
        }
        PCA3DViewer pca3DViewer = this.mode == 1 ? new PCA3DViewer(frame, this.mode, this.U, experiment, true, xAxis, yAxis, zAxis) : new PCA3DViewer(frame, this.mode, this.U, experiment, false, xAxis, yAxis, zAxis);
        node.add(new DefaultMutableTreeNode(new LeafInfo("3D view", (IViewer)pca3DViewer, pca3DViewer.getJPopupMenu())));
    }

    private void addPCPlotsNode(DefaultMutableTreeNode node) {
        if (this.S == null) {
            return;
        }
        DefaultMutableTreeNode pcNode = new DefaultMutableTreeNode("PC Plots");
        PlotVectorViewer plotVectorViewer = new PlotVectorViewer(this.T);
        for (int i = 0; i < this.S.getRowDimension(); ++i) {
            pcNode.add(new DefaultMutableTreeNode(new LeafInfo("Component " + (i + 1), (IViewer)plotVectorViewer, (Object)new Integer(i))));
        }
        node.add(pcNode);
    }

    private void addPCInfoNode(DefaultMutableTreeNode node) {
        if (this.S == null) {
            return;
        }
        DefaultMutableTreeNode infoNode = new DefaultMutableTreeNode("PC Information");
        PCInfoViewer pcInfoViewer = new PCInfoViewer(this.T);
        for (int i = 0; i < this.S.getRowDimension(); ++i) {
            infoNode.add(new DefaultMutableTreeNode(new LeafInfo("Component " + (i + 1), (IViewer)pcInfoViewer, (Object)new Integer(i))));
        }
        node.add(infoNode);
    }

    private void addEigenNode(DefaultMutableTreeNode node) {
        DefaultMutableTreeNode vNode = new DefaultMutableTreeNode("Eigenvalues");
        vNode.add(new DefaultMutableTreeNode(new LeafInfo("Plot", (IViewer)new PlotViewer(this.S))));
        vNode.add(new DefaultMutableTreeNode(new LeafInfo("Values", (IViewer)new ValuesViewer(this.S))));
        node.add(vNode);
    }

    private void addGeneralInfoNode(DefaultMutableTreeNode node, long time, String function) {
        DefaultMutableTreeNode gNode = new DefaultMutableTreeNode("General Information");
        if (this.S != null) {
            gNode.add(new DefaultMutableTreeNode("Components: " + this.S.getColumnDimension()));
        }
        gNode.add(new DefaultMutableTreeNode("Time: " + String.valueOf(time) + " ms"));
        gNode.add(new DefaultMutableTreeNode(function));
        gNode.add(new DefaultMutableTreeNode("Number of neighbors for KNN imputation: " + this.numNeibs));
        node.add(gNode);
    }

    private void addNew3DNode() {
        if (this.S == null) {
            return;
        }
        PCAAdditional3DAxesDialog pd = new PCAAdditional3DAxesDialog((JFrame)this.currFramework.getFrame(), true, this.S.getRowDimension());
        pd.setVisible(true);
        if (!pd.isOkPressed()) {
            return;
        }
        int selectedX = pd.getXAxis();
        int selectedY = pd.getYAxis();
        int selectedZ = pd.getZAxis();
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode("Components " + (selectedX + 1) + ", " + (selectedY + 1) + ", " + (selectedZ + 1));
        this.add3DViewNode(this.currFramework.getFrame(), newNode, this.currFramework.getData().getExperiment(), selectedX, selectedY, selectedZ);
        DefaultMutableTreeNode twoDNode = new DefaultMutableTreeNode("2D Views");
        this.add2DViewNode(twoDNode, this.currFramework.getData().getExperiment(), selectedX, selectedY, selectedZ);
        newNode.add(twoDNode);
        this.currFramework.addNode(this.projectionNode, newNode);
    }

    private void addNew2DNode() {
        if (this.S == null) {
            return;
        }
        PCAAdditional3DAxesDialog pd = new PCAAdditional3DAxesDialog((JFrame)this.currFramework.getFrame(), true, this.S.getRowDimension());
        pd.setZBoxInvisible(true);
        pd.setVisible(true);
        if (!pd.isOkPressed()) {
            return;
        }
        int selectedX = pd.getXAxis();
        int selectedY = pd.getYAxis();
        boolean geneViewer = false;
        if (this.mode == 1) {
            geneViewer = true;
        } else if (this.mode == 3) {
            geneViewer = false;
        }
        PCA2DViewer pcaxy = new PCA2DViewer(this.currFramework.getData().getExperiment(), this.U, geneViewer, selectedX, selectedY);
        this.currFramework.addNode(this.projectionNode, new DefaultMutableTreeNode(new LeafInfo("Components " + (selectedX + 1) + ", " + (selectedY + 1), (IViewer)pcaxy, pcaxy.getJPopupMenu())));
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        private Listener() {
        }

        public void valueChanged(AlgorithmEvent event) {
            PCAGUI.this.logger.append(event.getDescription());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("cancel-command")) {
                PCAGUI.this.algorithm.abort();
                PCAGUI.this.logger.dispose();
            } else if (command.equals(PCAGUI.ADD_NEW_3D_CMD)) {
                PCAGUI.this.addNew3DNode();
            } else if (command.equals(PCAGUI.ADD_NEW_2D_CMD)) {
                PCAGUI.this.addNew2DNode();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            PCAGUI.this.algorithm.abort();
            PCAGUI.this.logger.dispose();
        }
    }
}

