/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.pca;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.Expression;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;
import org.tigr.microarray.mev.cluster.gui.impl.pca.PCA2DViewer;
import org.tigr.microarray.mev.cluster.gui.impl.pca.PCA3DViewer;
import org.tigr.microarray.mev.cluster.gui.impl.pca.PCAAdditional3DAxesDialog;
import org.tigr.util.FloatMatrix;

public class PCADummyViewer
extends ViewerAdapter {
    private static final String ADD_NEW_3D_CMD = "add-new-3d-cmd";
    private static final String ADD_NEW_2D_CMD = "add-new-2d-cmd";
    private JPopupMenu popup;
    private IFramework framework;
    private FloatMatrix U;
    private FloatMatrix S;
    private int mode;

    public PCADummyViewer(FloatMatrix U, FloatMatrix S, int mode) {
        this.U = U;
        this.S = S;
        this.mode = mode;
        this.popup = this.createJPopupMenu();
    }

    public PCADummyViewer(FloatMatrix U, FloatMatrix S, Integer mode) {
        this(U, S, (int)mode);
    }

    @Override
    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{this.U, this.S, new Integer(this.mode)});
    }

    @Override
    public void onSelected(IFramework framework) {
        this.framework = framework;
        if (this.popup == null) {
            this.popup = this.createJPopupMenu();
            DefaultMutableTreeNode node = framework.getCurrentNode();
            if (node != null && node.getUserObject() instanceof LeafInfo) {
                LeafInfo leafInfo = (LeafInfo)node.getUserObject();
                leafInfo.setPopupMenu(this.popup);
            }
        }
    }

    public JPopupMenu getJPopupMenu() {
        return this.popup;
    }

    private JPopupMenu createJPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        this.addMenuItems(popup);
        return popup;
    }

    private void addMenuItems(JPopupMenu menu) {
        Listener listener = new Listener();
        JMenuItem menuItem = new JMenuItem("Add new 3-axis projections");
        menuItem.setActionCommand(ADD_NEW_3D_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Add new 2-axis projections");
        menuItem.setActionCommand(ADD_NEW_2D_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
    }

    private JMenuItem getJMenuItem(String command) {
        Component[] components = this.popup.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof JMenuItem) || !((JMenuItem)components[i]).getActionCommand().equals(command)) continue;
            return (JMenuItem)components[i];
        }
        return null;
    }

    private void add2DViewNode(DefaultMutableTreeNode node, Experiment experiment, int xAxis, int yAxis, int zAxis) {
        boolean geneViewer = false;
        if (this.mode == 1) {
            geneViewer = true;
        } else if (this.mode == 3) {
            geneViewer = false;
        }
        PCA2DViewer pcaxy = new PCA2DViewer(experiment, this.U, geneViewer, xAxis, yAxis);
        PCA2DViewer pcayz = new PCA2DViewer(experiment, this.U, geneViewer, yAxis, zAxis);
        PCA2DViewer pcaxz = new PCA2DViewer(experiment, this.U, geneViewer, xAxis, zAxis);
        node.add(new DefaultMutableTreeNode(new LeafInfo("" + (xAxis + 1) + ", " + (yAxis + 1), (IViewer)pcaxy, pcaxy.getJPopupMenu())));
        node.add(new DefaultMutableTreeNode(new LeafInfo("" + (yAxis + 1) + ", " + (zAxis + 1), (IViewer)pcayz, pcayz.getJPopupMenu())));
        node.add(new DefaultMutableTreeNode(new LeafInfo("" + (xAxis + 1) + ", " + (zAxis + 1), (IViewer)pcaxz, pcaxz.getJPopupMenu())));
    }

    private void add3DViewNode(Frame frame, DefaultMutableTreeNode node, Experiment experiment, int xAxis, int yAxis, int zAxis) {
        if (this.U == null || this.U.getColumnDimension() < 3) {
            return;
        }
        PCA3DViewer pca3DViewer = this.mode == 1 ? new PCA3DViewer(frame, this.mode, this.U, experiment, true, xAxis, yAxis, zAxis) : new PCA3DViewer(frame, this.mode, this.U, experiment, false, xAxis, yAxis, zAxis);
        node.add(new DefaultMutableTreeNode(new LeafInfo("3D view", (IViewer)pca3DViewer, pca3DViewer.getJPopupMenu())));
    }

    private void addNew3DNode() {
        if (this.S == null) {
            return;
        }
        PCAAdditional3DAxesDialog pd = new PCAAdditional3DAxesDialog((JFrame)this.framework.getFrame(), true, this.S.getRowDimension());
        pd.setVisible(true);
        if (!pd.isOkPressed()) {
            return;
        }
        int selectedX = pd.getXAxis();
        int selectedY = pd.getYAxis();
        int selectedZ = pd.getZAxis();
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode("Components " + (selectedX + 1) + ", " + (selectedY + 1) + ", " + (selectedZ + 1));
        this.add3DViewNode(this.framework.getFrame(), newNode, this.framework.getData().getExperiment(), selectedX, selectedY, selectedZ);
        DefaultMutableTreeNode twoDNode = new DefaultMutableTreeNode("2D Views");
        this.add2DViewNode(twoDNode, this.framework.getData().getExperiment(), selectedX, selectedY, selectedZ);
        newNode.add(twoDNode);
        this.framework.addNode(this.framework.getCurrentNode(), newNode);
    }

    private void addNew2DNode() {
        if (this.S == null) {
            return;
        }
        PCAAdditional3DAxesDialog pd = new PCAAdditional3DAxesDialog((JFrame)this.framework.getFrame(), true, this.S.getRowDimension());
        pd.setZBoxInvisible(true);
        pd.setVisible(true);
        if (!pd.isOkPressed()) {
            return;
        }
        int selectedX = pd.getXAxis();
        int selectedY = pd.getYAxis();
        boolean geneViewer = false;
        if (this.mode == 1) {
            geneViewer = true;
        } else if (this.mode == 3) {
            geneViewer = false;
        }
        PCA2DViewer pcaxy = new PCA2DViewer(this.framework.getData().getExperiment(), this.U, geneViewer, selectedX, selectedY);
        this.framework.addNode(this.framework.getCurrentNode(), new DefaultMutableTreeNode(new LeafInfo("Components " + (selectedX + 1) + ", " + (selectedY + 1), (IViewer)pcaxy, pcaxy.getJPopupMenu())));
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals(PCADummyViewer.ADD_NEW_3D_CMD)) {
                PCADummyViewer.this.addNew3DNode();
            } else if (command.equals(PCADummyViewer.ADD_NEW_2D_CMD)) {
                PCADummyViewer.this.addNew2DNode();
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            this.maybeShowPopup(event);
        }

        @Override
        public void mousePressed(MouseEvent event) {
            this.maybeShowPopup(event);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (!e.isPopupTrigger()) {
                return;
            }
            PCADummyViewer.this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }
}

