/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.pca;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.ShowThrowableDialog;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;
import org.tigr.microarray.mev.cluster.gui.impl.pca.Content3D;
import org.tigr.microarray.mev.cluster.gui.impl.pca.PCAResultConfigDialog;
import org.tigr.microarray.mev.cluster.gui.impl.pca.PCASelectionAreaDialog;
import org.tigr.util.FloatMatrix;

public class PCA3DViewer
extends ViewerAdapter {
    private static final String RESET_CMD = "reset-cmd";
    private static final String OPTIONS_CMD = "options-cmd";
    private static final String SELECTION_AREA_CMD = "select-cmd";
    private static final String SAVE_CMD = "save-cmd";
    private static final String SAVE_3D_CMD = "save-3d-cmd";
    private static final String SHOW_SELECTION_CMD = "show-selection-cmd";
    private static final String HIDE_SELECTION_BOX_CMD = "hide-selection-box-cmd";
    private static final String SHOW_SPHERES_CMD = "show-spheres-cmd";
    private static final String SHOW_TEXT_CMD = "show-text-cmd";
    private static final String WHITE_CMD = "white-cmd";
    private static final String STORE_CLUSTER_CMD = "store-cluster-cmd";
    private static final String LAUNCH_NEW_SESSION_CMD = "launch-new-session-cmd";
    private IData data;
    private Experiment experiment;
    private Content3D content;
    private JPopupMenu popup;
    private Frame frame;
    private boolean geneViewer;
    private IFramework framework;
    private FloatMatrix U;
    private int mode;
    private int xAxis;
    private int yAxis;
    private int zAxis;
    private int labelIndex = -1;
    private PCASelectionAreaDialog dlg;
    private int exptID = 0;
    private boolean enabled3D = false;
    private JComponent renderContent;

    public PCA3DViewer(Frame frame, int mode, FloatMatrix U, Experiment experiment, boolean geneViewer) {
        this.frame = frame;
        this.experiment = experiment;
        this.exptID = experiment.getId();
        this.geneViewer = geneViewer;
        this.U = U;
        this.mode = mode;
        try {
            this.content = this.createContent(mode, U, experiment, geneViewer);
            this.dlg = new PCASelectionAreaDialog(this.content, frame, this.content.getPositionX(), this.content.getPositionY(), this.content.getPositionZ(), this.content.getSizeX(), this.content.getSizeY(), this.content.getSizeZ(), this.content.getMaxValue());
            this.popup = this.createJPopupMenu();
            this.enabled3D = true;
            this.renderContent = this.content;
        }
        catch (UnsatisfiedLinkError ule) {
            ShowThrowableDialog.show((Frame)new Frame(), (String)"No Java 3D detected", (Throwable)new Exception("Java3D is not installed. The 3D viewer cannot be created."));
            this.enabled3D = false;
            this.renderContent = this.getJ3DErrorPlaceholderContent();
        }
        catch (NoClassDefFoundError ncdfe) {
            ShowThrowableDialog.show((Frame)new Frame(), (String)"No Java 3D detected", (Throwable)new Exception("Java3D is not installed. The 3D viewer cannot be created."));
            this.enabled3D = false;
            this.renderContent = this.getJ3DErrorPlaceholderContent();
        }
    }

    private JTextArea getJ3DErrorPlaceholderContent() {
        JTextArea area = new JTextArea(20, 20);
        area.setEditable(false);
        area.setMargin(new Insets(0, 10, 0, 0));
        area.setText("No 3D viewer is available. To view the results of this analysis, please install Java3D, available at java.sun.com. \nUse the File -> Save Analysis As option to save your results. \nAfter installing Java3D, restart MeV and load the saved analysis file to view these results in an interactive form. \n");
        area.setCaretPosition(0);
        return area;
    }

    public PCA3DViewer(Frame frame, int mode, FloatMatrix U, Experiment experiment, boolean geneViewer, int xAxis, int yAxis, int zAxis) {
        this.frame = frame;
        this.experiment = experiment;
        this.exptID = experiment.getId();
        this.geneViewer = geneViewer;
        this.U = U;
        this.mode = mode;
        this.xAxis = xAxis;
        this.yAxis = yAxis;
        this.zAxis = zAxis;
        try {
            this.content = this.createContent(mode, U, experiment, geneViewer, xAxis, yAxis, zAxis);
            this.dlg = new PCASelectionAreaDialog(this.content, frame, this.content.getPositionX(), this.content.getPositionY(), this.content.getPositionZ(), this.content.getSizeX(), this.content.getSizeY(), this.content.getSizeZ(), this.content.getMaxValue());
            this.popup = this.createJPopupMenu();
            this.enabled3D = true;
            this.renderContent = this.content;
        }
        catch (UnsatisfiedLinkError ule) {
            ShowThrowableDialog.show((Frame)new Frame(), (String)"No Java 3D detected", (Throwable)new Exception("Java3D is not installed. The 3D viewer cannot be created."));
            this.enabled3D = false;
            this.renderContent = this.getJ3DErrorPlaceholderContent();
        }
        catch (NoClassDefFoundError ncdfe) {
            ShowThrowableDialog.show((Frame)new Frame(), (String)"No Java 3D detected", (Throwable)new Exception("Java3D is not installed. The 3D viewer cannot be created."));
            this.enabled3D = false;
            this.renderContent = this.getJ3DErrorPlaceholderContent();
        }
    }

    public PCA3DViewer(Experiment e, Boolean geneViewer, FloatMatrix U, Integer mode, Integer xAxis, Integer yAxis, Integer zAxis) {
        this.geneViewer = geneViewer;
        this.U = U;
        this.mode = mode;
        this.xAxis = xAxis;
        this.yAxis = yAxis;
        this.zAxis = zAxis;
        this.experiment = e;
        this.exptID = this.experiment.getId();
        try {
            this.content = this.createContent(mode, U, this.experiment, geneViewer, xAxis, yAxis, zAxis);
            this.dlg = new PCASelectionAreaDialog(this.content, this.frame, this.content.getPositionX(), this.content.getPositionY(), this.content.getPositionZ(), this.content.getSizeX(), this.content.getSizeY(), this.content.getSizeZ(), this.content.getMaxValue());
            this.popup = this.createJPopupMenu();
            this.enabled3D = true;
            this.renderContent = this.content;
        }
        catch (UnsatisfiedLinkError ule) {
            this.enabled3D = false;
            this.renderContent = this.getJ3DErrorPlaceholderContent();
        }
        catch (NoClassDefFoundError ncdfe) {
            this.enabled3D = false;
            this.renderContent = this.getJ3DErrorPlaceholderContent();
        }
    }

    @Override
    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{this.experiment, new Boolean(this.geneViewer), this.U, new Integer(this.mode), new Integer(this.xAxis), new Integer(this.yAxis), new Integer(this.zAxis)});
    }

    @Override
    public int getExperimentID() {
        return this.exptID;
    }

    @Override
    public void onSelected(IFramework framework) {
        this.framework = framework;
        this.frame = framework.getFrame();
        this.data = framework.getData();
        IDisplayMenu menu = framework.getDisplayMenu();
        this.labelIndex = menu.getLabelIndex();
        if (this.enabled3D) {
            this.content.setData(this.data);
            this.content.setGeneLabelIndex(this.labelIndex);
            this.onMenuChanged(menu);
            this.content.updateScene();
            if (this.popup == null) {
                this.popup = this.createJPopupMenu();
                DefaultMutableTreeNode node = framework.getCurrentNode();
                if (node != null && node.getUserObject() instanceof LeafInfo) {
                    LeafInfo leafInfo = (LeafInfo)node.getUserObject();
                    leafInfo.setPopupMenu(this.popup);
                }
            }
        }
    }

    @Override
    public void onMenuChanged(IDisplayMenu menu) {
        this.labelIndex = menu.getLabelIndex();
        this.content.setGeneLabelIndex(this.labelIndex);
        this.content.updateScene();
    }

    @Override
    public void onDataChanged(IData data) {
        this.data = data;
        this.content.setData(data);
        this.content.updateScene();
    }

    @Override
    public JComponent getContentComponent() {
        return this.renderContent;
    }

    @Override
    public BufferedImage getImage() {
        return this.content.createImage();
    }

    private Content3D createContent(int mode, FloatMatrix U, Experiment experiment, boolean geneViewer) {
        return new Content3D(mode, U, experiment, geneViewer);
    }

    private Content3D createContent(int mode, FloatMatrix U, Experiment experiment, boolean geneViewer, int x, int y, int z) {
        return new Content3D(mode, U, experiment, geneViewer, x, y, z);
    }

    public JPopupMenu getJPopupMenu() {
        return this.popup;
    }

    private JPopupMenu createJPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        this.addMenuItems(popup);
        return popup;
    }

    private void addMenuItems(JPopupMenu menu) {
        Listener listener = new Listener();
        JMenuItem menuItem = new JMenuItem("Reset", GUIFactory.getIcon("refresh16.gif"));
        menuItem.setActionCommand(RESET_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Options...", GUIFactory.getIcon("edit16.gif"));
        menuItem.setActionCommand(OPTIONS_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Selection area...", GUIFactory.getIcon("edit16.gif"));
        menuItem.setEnabled(false);
        menuItem.setActionCommand(SELECTION_AREA_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Store cluster...", GUIFactory.getIcon("new16.gif"));
        menuItem.setEnabled(false);
        menuItem.setActionCommand(STORE_CLUSTER_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Launch new session", GUIFactory.getIcon("launch_new_mav.gif"));
        menuItem.setEnabled(false);
        menuItem.setActionCommand(LAUNCH_NEW_SESSION_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Save cluster...", GUIFactory.getIcon("save16.gif"));
        menuItem.setEnabled(false);
        menuItem.setActionCommand(SAVE_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Save 3D coordinates...", GUIFactory.getIcon("save16.gif"));
        menuItem.setEnabled(true);
        menuItem.setActionCommand(SAVE_3D_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JCheckBoxMenuItem("Show selection area");
        menuItem.setActionCommand(SHOW_SELECTION_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JCheckBoxMenuItem("Hide selection box");
        menuItem.setEnabled(false);
        menuItem.setActionCommand(HIDE_SELECTION_BOX_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JCheckBoxMenuItem("Show spheres");
        menuItem.setActionCommand(SHOW_SPHERES_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JCheckBoxMenuItem("Show text");
        menuItem.setEnabled(true);
        menuItem.setActionCommand(SHOW_TEXT_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JCheckBoxMenuItem("White background");
        menuItem.setActionCommand(WHITE_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
    }

    private JMenuItem getJMenuItem(String command) {
        Component[] components = this.popup.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof JMenuItem) || !((JMenuItem)components[i]).getActionCommand().equals(command)) continue;
            return (JMenuItem)components[i];
        }
        return null;
    }

    private void setEnableMenuItem(String command, boolean enable) {
        JMenuItem item = this.getJMenuItem(command);
        if (item == null) {
            return;
        }
        item.setEnabled(enable);
    }

    private void onReset() {
        this.content.reset();
    }

    private void onOptions() {
        PCAResultConfigDialog dlg = new PCAResultConfigDialog(this.frame, this.content.getPointSize(), this.content.getSelectedPointSize(), this.content.getScaleAxisX(), this.content.getScaleAxisY(), this.content.getScaleAxisZ());
        if (dlg.showModal() == 0) {
            this.content.setPointSize(dlg.getPointSize());
            this.content.setSelectedPointSize(dlg.getSelectedPointSize());
            this.content.setScale(dlg.getScaleAxisX(), dlg.getScaleAxisY(), dlg.getScaleAxisZ());
            this.content.updateScene();
        }
    }

    private void onSelectionArea() {
        if (this.dlg.showModal() == 0) {
            this.content.setBoxPosition(this.dlg.getPositionX(), this.dlg.getPositionY(), this.dlg.getPositionZ());
            this.content.setBoxSize(this.dlg.getSizeX(), this.dlg.getSizeY(), this.dlg.getSizeZ());
            this.content.updateScene();
        }
    }

    private void onSave() {
        try {
            if (this.geneViewer) {
                ExperimentUtil.saveExperiment((Frame)this.frame, (Experiment)this.experiment, (IData)this.data, (int[])this.content.getSelectedGenes());
            } else {
                ExperimentUtil.saveExperimentCluster((Frame)this.frame, (Experiment)this.experiment, (IData)this.data, (int[])this.content.getSelectedGenes());
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.frame, "Can not save matrix!", e.toString(), 0);
            e.printStackTrace();
        }
    }

    private void storeCluster() {
        if (this.geneViewer) {
            this.framework.storeSubCluster(this.content.getSelectedGenes(), this.experiment, 0);
        } else {
            this.framework.storeSubCluster(this.content.getSelectedGenes(), this.experiment, 1);
        }
        this.content.setSelection(false);
        this.onDataChanged(this.data);
        this.content.updateScene();
    }

    private void launchNewSession() {
        if (this.geneViewer) {
            this.framework.launchNewMAV(this.content.getSelectedGenes(), this.experiment, "Multiple Experiment Viewer - Cluster Viewer", 0);
        } else {
            this.framework.launchNewMAV(this.content.getSelectedGenes(), this.experiment, "Multiple Experiment Viewer - Cluster Viewer", 1);
        }
    }

    private void onShowSelection() {
        JMenuItem selectionItem = this.getJMenuItem(SHOW_SELECTION_CMD);
        JMenuItem hideBoxItem = this.getJMenuItem(HIDE_SELECTION_BOX_CMD);
        JMenuItem selectionAreaItem = this.getJMenuItem(SELECTION_AREA_CMD);
        JMenuItem saveClusterItem = this.getJMenuItem(SAVE_CMD);
        JMenuItem storeClusterItem = this.getJMenuItem(STORE_CLUSTER_CMD);
        JMenuItem launchNewItem = this.getJMenuItem(LAUNCH_NEW_SESSION_CMD);
        if (selectionItem.isSelected()) {
            this.content.setSelection(true);
            this.content.setSelectionBox(!hideBoxItem.isSelected());
            selectionAreaItem.setEnabled(true);
            saveClusterItem.setEnabled(true);
            hideBoxItem.setEnabled(true);
            storeClusterItem.setEnabled(true);
            launchNewItem.setEnabled(true);
        } else {
            this.content.setSelection(false);
            this.content.setSelectionBox(false);
            selectionAreaItem.setEnabled(false);
            saveClusterItem.setEnabled(false);
            hideBoxItem.setEnabled(false);
            storeClusterItem.setEnabled(false);
            launchNewItem.setEnabled(false);
        }
        this.content.updateScene();
    }

    private void onHideSelection() {
        this.content.setSelectionBox(!this.content.isSelectionBox());
        this.content.updateScene();
    }

    private void onShowSphere() {
        this.content.setShowSpheres(!this.content.isShowSpheres());
        this.content.updateScene();
        JMenuItem sphereItem = this.getJMenuItem(SHOW_SPHERES_CMD);
        JMenuItem textItem = this.getJMenuItem(SHOW_TEXT_CMD);
        if (sphereItem.isSelected()) {
            this.content.setShowSpheres(true);
            this.content.setShowText(textItem.isSelected());
            textItem.setEnabled(true);
        } else {
            this.content.setShowSpheres(false);
            this.content.setShowText(textItem.isSelected());
            textItem.setEnabled(true);
        }
        this.content.updateScene();
    }

    private void onShowText() {
        this.content.setShowText(!this.content.isShowText());
        this.content.updateScene();
    }

    private void onWhiteBackground() {
        this.content.setWhiteBackround(!this.content.isWhiteBackground());
        this.content.updateScene();
    }

    @Override
    public JComponent getRowHeaderComponent() {
        return null;
    }

    private void output3DCoords() {
        block12: {
            String[] annFields;
            JFileChooser fileChooser = new JFileChooser(TMEV.getDataPath());
            FloatMatrix coordMatrix = this.U;
            boolean outputGenes = this.geneViewer;
            if (outputGenes) {
                annFields = this.data.getFieldNames();
            } else {
                Vector sampleAnnFields = this.data.getSampleAnnotationFieldNames();
                annFields = new String[sampleAnnFields.size()];
                for (int i = 0; i < annFields.length; ++i) {
                    annFields[i] = (String)sampleAnnFields.get(i);
                }
            }
            try {
                if (fileChooser.showSaveDialog(this.frame) != 0) break block12;
                File file = fileChooser.getSelectedFile();
                PrintWriter pw = new PrintWriter(new FileWriter(file));
                for (int i = 0; i < annFields.length; ++i) {
                    pw.print(annFields[i] + "\t");
                }
                pw.println("X\tY\tZ");
                int nRows = coordMatrix.getRowDimension();
                if (outputGenes) {
                    for (int i = 0; i < nRows; ++i) {
                        for (int j = 0; j < annFields.length; ++j) {
                            pw.print(this.data.getElementAttribute(this.experiment.getGeneIndexMappedToData(i), j) + "\t");
                        }
                        pw.print(coordMatrix.get(i, 0) + "\t");
                        pw.print(coordMatrix.get(i, 1) + "\t");
                        pw.println(coordMatrix.get(i, 2));
                    }
                } else {
                    for (int i = 0; i < nRows; ++i) {
                        for (int j = 0; j < annFields.length; ++j) {
                            pw.print(this.data.getSampleAnnotation(i, annFields[j]) + "\t");
                        }
                        pw.print(coordMatrix.get(i, 0) + "\t");
                        pw.print(coordMatrix.get(i, 1) + "\t");
                        pw.println(coordMatrix.get(i, 2));
                    }
                }
                pw.flush();
                pw.close();
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this.frame, "Error opening or saving to file", "Coordinate ouput Error", 0);
            }
        }
    }

    private class Listener
    implements ActionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String command = event.getActionCommand();
            if (command.equals(PCA3DViewer.RESET_CMD)) {
                PCA3DViewer.this.onReset();
            } else if (command.equals(PCA3DViewer.OPTIONS_CMD)) {
                PCA3DViewer.this.onOptions();
            } else if (command.equals(PCA3DViewer.SELECTION_AREA_CMD)) {
                PCA3DViewer.this.onSelectionArea();
            } else if (command.equals(PCA3DViewer.SAVE_CMD)) {
                PCA3DViewer.this.onSave();
            } else if (command.equals(PCA3DViewer.SHOW_SELECTION_CMD)) {
                PCA3DViewer.this.onShowSelection();
            } else if (command.equals(PCA3DViewer.HIDE_SELECTION_BOX_CMD)) {
                PCA3DViewer.this.onHideSelection();
            } else if (command.equals(PCA3DViewer.SHOW_SPHERES_CMD)) {
                PCA3DViewer.this.onShowSphere();
            } else if (command.equals(PCA3DViewer.SHOW_TEXT_CMD)) {
                PCA3DViewer.this.onShowText();
            } else if (command.equals(PCA3DViewer.WHITE_CMD)) {
                PCA3DViewer.this.onWhiteBackground();
            } else if (command.equals(PCA3DViewer.STORE_CLUSTER_CMD)) {
                PCA3DViewer.this.storeCluster();
            } else if (command.equals(PCA3DViewer.LAUNCH_NEW_SESSION_CMD)) {
                PCA3DViewer.this.launchNewSession();
            } else if (command.equals(PCA3DViewer.SAVE_3D_CMD)) {
                PCA3DViewer.this.output3DCoords();
            }
        }
    }
}

