/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.pca;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.MouseInputAdapter;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.util.FloatMatrix;

public class PCA2DViewer
extends JPanel
implements IViewer {
    private static final String SAVE_CMD = "save-cmd";
    private static final String SHOW_TEXT_CMD = "show-text-cmd";
    private static final String SHOW_TICK_LABELS_CMD = "show-tick-labels-cmd";
    private static final String STORE_CLUSTER_CMD = "store-cluster-cmd";
    private static final String LAUNCH_NEW_SESSION_CMD = "launch-new-session-cmd";
    private static final String DISPLAY_EXPT_NAMES_CMD = "display-expt-names-cmd";
    private static final String SHOW_LARGER_POINTS_CMD = "show-larger-points-cmd";
    private float[] yArray;
    private float[] xArray;
    private int axis1;
    private int axis2;
    private FloatMatrix UMatrix;
    private Experiment experiment;
    private IFramework framework;
    private Frame frame;
    private IData data;
    private JPopupMenu popup;
    private Ellipse2D.Double ellipse;
    private boolean displayExptNames;
    private boolean showLargePoints;
    private boolean geneViewer;
    private boolean showTickLabels;
    Rectangle currentRect = null;
    Rectangle rectToDraw = null;
    Rectangle previousRectDrawn = new Rectangle();
    private int exptID = 0;

    public PCA2DViewer(Experiment experiment, float[] xArray, float[] yArray, boolean geneViewer, int axis1, int axis2) {
        this.yArray = yArray;
        this.xArray = xArray;
        this.displayExptNames = false;
        this.showLargePoints = false;
        this.showTickLabels = true;
        this.geneViewer = geneViewer;
        this.axis1 = axis1;
        this.axis2 = axis2;
        this.experiment = experiment;
        this.exptID = experiment.getId();
        this.ellipse = new Ellipse2D.Double();
        this.setBackground(Color.white);
        this.popup = this.createJPopupMenu();
        GraphListener graphListener = new GraphListener();
        this.addMouseListener(graphListener);
        this.addMouseMotionListener(graphListener);
    }

    public PCA2DViewer(Experiment experiment, FloatMatrix UMatrix, boolean geneViewer, int axis1, int axis2) {
        this.UMatrix = UMatrix;
        this.axis1 = axis1;
        this.axis2 = axis2;
        this.xArray = this.getFloatArray(UMatrix, axis1);
        this.yArray = this.getFloatArray(UMatrix, axis2);
        this.displayExptNames = false;
        this.showLargePoints = false;
        this.showTickLabels = true;
        this.geneViewer = geneViewer;
        this.experiment = experiment;
        this.exptID = experiment.getId();
        this.ellipse = new Ellipse2D.Double();
        this.setBackground(Color.white);
        this.popup = this.createJPopupMenu();
        GraphListener graphListener = new GraphListener();
        this.addMouseListener(graphListener);
        this.addMouseMotionListener(graphListener);
    }

    public PCA2DViewer(Experiment e, FloatMatrix UMatrix, Boolean geneViewer, Integer axis1, Integer axis2) {
        this.UMatrix = UMatrix;
        this.axis1 = axis1;
        this.axis2 = axis2;
        this.xArray = this.getFloatArray(UMatrix, this.axis1);
        this.yArray = this.getFloatArray(UMatrix, this.axis2);
        this.displayExptNames = false;
        this.showLargePoints = false;
        this.showTickLabels = true;
        this.geneViewer = geneViewer;
        this.ellipse = new Ellipse2D.Double();
        this.setBackground(Color.white);
        this.popup = this.createJPopupMenu();
        GraphListener graphListener = new GraphListener();
        this.addMouseListener(graphListener);
        this.addMouseMotionListener(graphListener);
        this.setExperiment(e);
    }

    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{this.experiment, this.UMatrix, new Boolean(this.geneViewer), new Integer(this.axis1), new Integer(this.axis2)});
    }

    private float[] getFloatArray(FloatMatrix matrix, int column) {
        float[] array = new float[matrix.getRowDimension()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = matrix.A[i][column];
        }
        return array;
    }

    @Override
    public void paint(Graphics g) {
        int i;
        super.paint(g);
        Graphics2D g2D = (Graphics2D)g;
        int panelWidth = this.getWidth();
        int panelHeight = this.getHeight();
        int originX = (int)Math.round((double)(this.getWidth() / 2));
        int originY = (int)Math.round((double)(this.getHeight() / 2));
        double origMaxXValue = this.getMax(this.xArray);
        double origMaxYValue = this.getMax(this.yArray);
        double origMinXValue = this.getMin(this.xArray);
        double origMinYValue = this.getMin(this.yArray);
        double xScalingFactor = this.getXScalingFactor(origMaxXValue, origMinXValue);
        double yScalingFactor = this.getYScalingFactor(origMaxYValue, origMinYValue);
        g2D.setStroke(new BasicStroke(2.0f));
        g2D.drawLine(0, (int)Math.round((double)(this.getHeight() / 2)), this.getWidth(), (int)Math.round((double)(this.getHeight() / 2)));
        g2D.drawLine((int)Math.round((double)(this.getWidth() / 2)), 0, (int)Math.round((double)(this.getWidth() / 2)), this.getHeight());
        double[] xIntervalArray = new double[6];
        double[] yIntervalArray = new double[6];
        double xIncrement = 0.0;
        double yIncrement = 0.0;
        xIncrement = Math.abs(origMaxXValue) > Math.abs(origMinXValue) ? Math.abs(origMaxXValue / 5.0) : Math.abs(origMinXValue / 5.0);
        yIncrement = Math.abs(origMaxYValue) > Math.abs(origMinYValue) ? Math.abs(origMaxYValue / 5.0) : Math.abs(origMinYValue / 5.0);
        double xCounter = 0.0;
        double yCounter = 0.0;
        for (i = 0; i < xIntervalArray.length; ++i) {
            xIntervalArray[i] = xCounter;
            xCounter += xIncrement;
            yIntervalArray[i] = yCounter;
            yCounter += yIncrement;
        }
        if (this.showTickLabels) {
            double stringWidth;
            int i2;
            for (i = 1; i < xIntervalArray.length; ++i) {
                g2D.drawLine((int)Math.round(xIntervalArray[i] * xScalingFactor) + this.getWidth() / 2, this.getHeight() / 2 - 5, (int)Math.round(xIntervalArray[i] * xScalingFactor) + this.getWidth() / 2, this.getHeight() / 2 + 5);
            }
            for (i = 1; i < xIntervalArray.length; ++i) {
                g2D.drawLine(this.getWidth() / 2 - (int)Math.round(xIntervalArray[i] * xScalingFactor), this.getHeight() / 2 - 5, this.getWidth() / 2 - (int)Math.round(xIntervalArray[i] * xScalingFactor), this.getHeight() / 2 + 5);
            }
            for (i = 1; i < yIntervalArray.length; ++i) {
                g2D.drawLine(this.getWidth() / 2 - 5, this.getHeight() / 2 + (int)Math.round(yIntervalArray[i] * yScalingFactor), this.getWidth() / 2 + 5, this.getHeight() / 2 + (int)Math.round(yIntervalArray[i] * yScalingFactor));
            }
            for (i = 1; i < yIntervalArray.length; ++i) {
                g2D.drawLine(this.getWidth() / 2 - 5, this.getHeight() / 2 - (int)Math.round(yIntervalArray[i] * yScalingFactor), this.getWidth() / 2 + 5, this.getHeight() / 2 - (int)Math.round(yIntervalArray[i] * yScalingFactor));
            }
            g2D.setStroke(new BasicStroke(2.0f));
            g2D.setColor(Color.black);
            DecimalFormat nf = new DecimalFormat();
            nf.setMaximumFractionDigits(2);
            for (i2 = 1; i2 < xIntervalArray.length; ++i2) {
                stringWidth = g2D.getFontMetrics().stringWidth(nf.format(xIntervalArray[i2]));
                g2D.drawString(nf.format(xIntervalArray[i2]), (int)Math.round(xIntervalArray[i2] * xScalingFactor) + this.getWidth() / 2 - (int)Math.round(0.5 * stringWidth), this.getHeight() / 2 + 20);
            }
            for (i2 = 1; i2 < xIntervalArray.length; ++i2) {
                stringWidth = g2D.getFontMetrics().stringWidth("-" + nf.format(xIntervalArray[i2]));
                g2D.drawString("-" + nf.format(xIntervalArray[i2]), this.getWidth() / 2 - (int)Math.round(xIntervalArray[i2] * xScalingFactor) - (int)Math.round(0.5 * stringWidth), this.getHeight() / 2 + 20);
            }
            for (i2 = 1; i2 < yIntervalArray.length; ++i2) {
                g2D.drawString(nf.format(yIntervalArray[i2]), this.getWidth() / 2 + 10, this.getHeight() / 2 - (int)Math.round(yIntervalArray[i2] * yScalingFactor));
            }
            for (i2 = 1; i2 < yIntervalArray.length; ++i2) {
                g2D.drawString("-" + nf.format(yIntervalArray[i2]), this.getWidth() / 2 + 10, this.getHeight() / 2 + (int)Math.round(yIntervalArray[i2] * yScalingFactor));
            }
        }
        for (i = 0; i < this.xArray.length; ++i) {
            Color currPointColor = Color.black;
            if (this.geneViewer) {
                this.experiment.toString();
                currPointColor = this.data.getProbeColor(this.experiment.getGeneIndexMappedToData(i));
                if (currPointColor == null) {
                    currPointColor = Color.black;
                }
            } else {
                currPointColor = this.data.getExperimentColor(i);
                if (currPointColor == null) {
                    currPointColor = Color.black;
                }
            }
            g2D.setColor(currPointColor);
            if (this.showLargePoints) {
                this.drawRectPoint(g2D, this.xArray[i], this.yArray[i], this.getXScalingFactor(origMaxXValue, origMinXValue), this.getYScalingFactor(origMaxYValue, origMinYValue), 8);
            } else {
                this.drawPoint(g2D, this.xArray[i], this.yArray[i], this.getXScalingFactor(origMaxXValue, origMinXValue), this.getYScalingFactor(origMaxYValue, origMinYValue), 5);
            }
            g2D.setColor(Color.black);
        }
        g2D.drawString("X axis = " + (this.axis1 + 1) + ", Y axis = " + (this.axis2 + 1), this.getWidth() / 2 + 25, this.getHeight() - 25);
        if (!this.geneViewer && this.displayExptNames) {
            FontMetrics fmet = g2D.getFontMetrics(g2D.getFont());
            double ascent = fmet.getAscent();
            double advance = fmet.getMaxAdvance();
            for (int i3 = 0; i3 < this.xArray.length; ++i3) {
                String currName;
                double stringWidth;
                double[] currCoords = this.getCoords(this.xArray[i3], this.yArray[i3]);
                if (currCoords[0] + 0.5 * advance + (stringWidth = (double)fmet.stringWidth(currName = this.data.getSampleName(i3))) > (double)this.getWidth()) {
                    g2D.drawString(currName, (float)(currCoords[0] - stringWidth - 0.25 * advance), (float)(currCoords[1] + 0.5 * ascent));
                    continue;
                }
                g2D.drawString(currName, (float)(currCoords[0] + 0.5 * advance), (float)(currCoords[1] + 0.5 * ascent));
            }
        }
        if (this.currentRect != null) {
            g2D.setXORMode(Color.white);
            g2D.draw(this.ellipse);
        }
    }

    private void drawPoint(Graphics2D g2D, double xValue, double yValue, double xScale, double yScale, int diameter) {
        int xRaw = (int)Math.round(xValue * xScale);
        int yRaw = (int)Math.round(yValue * yScale);
        int xCoord = (int)Math.round((double)(this.getWidth() / 2)) + xRaw;
        int yCoord = (int)Math.round((double)(this.getHeight() / 2)) - yRaw;
        g2D.fillOval(xCoord, yCoord, diameter, diameter);
    }

    private void drawRectPoint(Graphics2D g2D, double xValue, double yValue, double xScale, double yScale, int dim) {
        int xRaw = (int)Math.round(xValue * xScale);
        int yRaw = (int)Math.round(yValue * yScale);
        int xCoord = (int)Math.round((double)(this.getWidth() / 2)) + xRaw;
        int yCoord = (int)Math.round((double)(this.getHeight() / 2)) - yRaw;
        g2D.fillRect(xCoord, yCoord, dim, dim);
    }

    private double getMax(float[] array) {
        float max = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < array.length; ++i) {
            if (!(max < array[i])) continue;
            max = array[i];
        }
        return max;
    }

    private double getMin(float[] array) {
        float min = Float.POSITIVE_INFINITY;
        for (int i = 0; i < array.length; ++i) {
            if (!(min > array[i])) continue;
            min = array[i];
        }
        return min;
    }

    private double getXScalingFactor(double maxValue, double minValue) {
        double largest = 1.0;
        if (maxValue > 0.0 && minValue > 0.0) {
            largest = maxValue;
        } else if (maxValue > 0.0 && minValue < 0.0) {
            largest = maxValue > Math.abs(minValue) ? maxValue : Math.abs(minValue);
        } else if (maxValue <= 0.0) {
            largest = Math.abs(minValue);
        } else if (minValue == 0.0) {
            largest = maxValue;
        }
        double scalingFactor = 0.0;
        scalingFactor = (double)(this.getWidth() / 2 - 50) / largest;
        return scalingFactor;
    }

    private double getYScalingFactor(double maxValue, double minValue) {
        double largest = 1.0;
        if (maxValue > 0.0 && minValue > 0.0) {
            largest = maxValue;
        } else if (maxValue > 0.0 && minValue < 0.0) {
            largest = maxValue > Math.abs(minValue) ? maxValue : Math.abs(minValue);
        } else if (maxValue <= 0.0) {
            largest = Math.abs(minValue);
        } else if (minValue == 0.0) {
            largest = maxValue;
        }
        double scalingFactor = 0.0;
        scalingFactor = (double)(this.getHeight() / 2 - 50) / largest;
        return scalingFactor;
    }

    public int[][] getClusters() {
        return null;
    }

    public int[] getSelectedPoints() {
        Vector<Integer> selPointsVector = new Vector<Integer>();
        for (int i = 0; i < this.UMatrix.getRowDimension(); ++i) {
            double[] currCoords = this.getCoords(this.xArray[i], this.yArray[i]);
            if (!this.ellipse.contains(currCoords[0], currCoords[1])) continue;
            if (this.geneViewer) {
                selPointsVector.add(new Integer(this.experiment.getGeneIndexMappedToData(i)));
                continue;
            }
            selPointsVector.add(new Integer(this.experiment.getSampleIndex(i)));
        }
        int[] selPoints = new int[selPointsVector.size()];
        for (int i = 0; i < selPoints.length; ++i) {
            selPoints[i] = (Integer)selPointsVector.get(i);
        }
        return selPoints;
    }

    private double[] getCoords(double xValue, double yValue) {
        double origMaxXValue = this.getMax(this.xArray);
        double origMaxYValue = this.getMax(this.yArray);
        double origMinXValue = this.getMin(this.xArray);
        double origMinYValue = this.getMin(this.yArray);
        double xScalingFactor = this.getXScalingFactor(origMaxXValue, origMinXValue);
        double yScalingFactor = this.getYScalingFactor(origMaxYValue, origMinYValue);
        double xRaw = Math.round(xValue * xScalingFactor);
        double yRaw = Math.round(yValue * yScalingFactor);
        double xCoord = (double)Math.round((double)(this.getWidth() / 2)) + xRaw;
        double yCoord = (double)Math.round((double)(this.getHeight() / 2)) - yRaw;
        double[] coords = new double[]{xCoord, yCoord};
        return coords;
    }

    public JComponent getContentComponent() {
        return this;
    }

    public JComponent getCornerComponent(int cornerIndex) {
        return null;
    }

    public Experiment getExperiment() {
        return this.experiment;
    }

    public JComponent getHeaderComponent() {
        return null;
    }

    public BufferedImage getImage() {
        return null;
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public void onClosed() {
    }

    public void onDataChanged(IData data) {
        this.setData(data);
    }

    public void onDeselected() {
    }

    public void onMenuChanged(IDisplayMenu menu) {
    }

    public void onSelected(IFramework framework) {
        this.framework = framework;
        this.frame = framework.getFrame();
        this.setData(framework.getData());
        if (this.popup == null) {
            this.popup = this.createJPopupMenu();
            DefaultMutableTreeNode node = framework.getCurrentNode();
            if (node != null && node.getUserObject() instanceof LeafInfo) {
                LeafInfo leafInfo = (LeafInfo)node.getUserObject();
                leafInfo.setPopupMenu(this.popup);
            }
        }
    }

    public void setData(IData data) {
        this.data = data;
    }

    public JPopupMenu getJPopupMenu() {
        return this.popup;
    }

    private JPopupMenu createJPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        this.addMenuItems(popup);
        return popup;
    }

    private void addMenuItems(JPopupMenu menu) {
        Listener listener = new Listener();
        JMenuItem menuItem = new JMenuItem("Store cluster...", GUIFactory.getIcon("new16.gif"));
        menuItem.setEnabled(false);
        menuItem.setActionCommand(STORE_CLUSTER_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Launch new session", GUIFactory.getIcon("launch_new_mav.gif"));
        menuItem.setEnabled(false);
        menuItem.setActionCommand(LAUNCH_NEW_SESSION_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Save cluster...", GUIFactory.getIcon("save16.gif"));
        menuItem.setEnabled(false);
        menuItem.setActionCommand(SAVE_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        if (!this.geneViewer) {
            menu.addSeparator();
            menuItem = new JCheckBoxMenuItem("Show sample names");
            menuItem.setEnabled(true);
            menuItem.setActionCommand(DISPLAY_EXPT_NAMES_CMD);
            menuItem.addActionListener(listener);
            menu.add(menuItem);
        }
        menuItem = new JCheckBoxMenuItem("Larger point size");
        menuItem.setEnabled(true);
        menuItem.setActionCommand(SHOW_LARGER_POINTS_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JCheckBoxMenuItem("Show tick marks and labels");
        menuItem.setEnabled(true);
        menuItem.setSelected(true);
        menuItem.setActionCommand(SHOW_TICK_LABELS_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
    }

    private JMenuItem getJMenuItem(String command) {
        Component[] components = this.popup.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof JMenuItem) || !((JMenuItem)components[i]).getActionCommand().equals(command)) continue;
            return (JMenuItem)components[i];
        }
        return null;
    }

    private void setEnableMenuItem(String command, boolean enable) {
        JMenuItem item = this.getJMenuItem(command);
        if (item == null) {
            return;
        }
        item.setEnabled(enable);
    }

    private void onSave() {
        try {
            if (this.geneViewer) {
                ExperimentUtil.saveExperiment((Frame)this.frame, (Experiment)this.experiment, (IData)this.data, (int[])this.getSelectedPoints());
            } else {
                ExperimentUtil.saveExperimentCluster((Frame)this.frame, (Experiment)this.experiment, (IData)this.data, (int[])this.getSelectedPoints());
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.frame, "Can not save matrix!", e.toString(), 0);
            e.printStackTrace();
        }
    }

    private void storeCluster() {
        if (this.geneViewer) {
            this.framework.storeSubCluster(this.getSelectedPoints(), this.experiment, 0);
        } else {
            this.framework.storeSubCluster(this.getSelectedPoints(), this.experiment, 1);
        }
        this.onDataChanged(this.data);
        this.repaint();
    }

    private void launchNewSession() {
        if (this.geneViewer) {
            this.framework.launchNewMAV(this.getSelectedPoints(), this.experiment, "Multiple Experiment Viewer - Cluster Viewer", 0);
        } else {
            this.framework.launchNewMAV(this.getSelectedPoints(), this.experiment, "Multiple Experiment Viewer - Cluster Viewer", 1);
        }
    }

    private void onShowSelection() {
        JMenuItem saveClusterItem = this.getJMenuItem(SAVE_CMD);
        JMenuItem storeClusterItem = this.getJMenuItem(STORE_CLUSTER_CMD);
        JMenuItem launchNewItem = this.getJMenuItem(LAUNCH_NEW_SESSION_CMD);
        if (!this.ellipse.isEmpty()) {
            saveClusterItem.setEnabled(true);
            storeClusterItem.setEnabled(true);
            launchNewItem.setEnabled(true);
        } else {
            saveClusterItem.setEnabled(false);
            storeClusterItem.setEnabled(false);
            launchNewItem.setEnabled(false);
        }
    }

    private void showExptNames() {
        this.displayExptNames = !this.displayExptNames;
        this.repaint();
    }

    private void displayLargePoints() {
        this.showLargePoints = !this.showLargePoints;
        this.repaint();
    }

    private void displayTickLabels() {
        this.showTickLabels = !this.showTickLabels;
        this.repaint();
    }

    public int getViewerType() {
        return -1;
    }

    public void setExperiment(Experiment e) {
        this.experiment = e;
        this.exptID = this.experiment.getId();
    }

    public int getExperimentID() {
        return this.exptID;
    }

    public void setExperimentID(int id) {
        this.exptID = id;
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String command = event.getActionCommand();
            if (command.equals(PCA2DViewer.SAVE_CMD)) {
                PCA2DViewer.this.onSave();
            } else if (command.equals(PCA2DViewer.STORE_CLUSTER_CMD)) {
                PCA2DViewer.this.storeCluster();
            } else if (command.equals(PCA2DViewer.LAUNCH_NEW_SESSION_CMD)) {
                PCA2DViewer.this.launchNewSession();
            } else if (command.equals(PCA2DViewer.DISPLAY_EXPT_NAMES_CMD)) {
                PCA2DViewer.this.showExptNames();
            } else if (command.equals(PCA2DViewer.SHOW_LARGER_POINTS_CMD)) {
                PCA2DViewer.this.displayLargePoints();
            } else if (command.equals(PCA2DViewer.SHOW_TICK_LABELS_CMD)) {
                PCA2DViewer.this.displayTickLabels();
            }
        }
    }

    private class GraphListener
    extends MouseInputAdapter {
        private GraphListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            PCA2DViewer.this.currentRect = new Rectangle(x, y, 0, 0);
            this.updateDrawableRect(PCA2DViewer.this.getWidth(), PCA2DViewer.this.getHeight());
            PCA2DViewer.this.repaint();
            PCA2DViewer.this.onShowSelection();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.updateSize(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.updateSize(e);
        }

        void updateSize(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            PCA2DViewer.this.currentRect.setSize(x - PCA2DViewer.this.currentRect.x, y - PCA2DViewer.this.currentRect.y);
            this.updateDrawableRect(PCA2DViewer.this.getWidth(), PCA2DViewer.this.getHeight());
            Rectangle totalRepaint = PCA2DViewer.this.rectToDraw.union(PCA2DViewer.this.previousRectDrawn);
            PCA2DViewer.this.ellipse.setFrame(totalRepaint.getX(), totalRepaint.getY(), totalRepaint.getWidth(), totalRepaint.getHeight());
            PCA2DViewer.this.repaint();
            PCA2DViewer.this.onShowSelection();
        }

        private void updateDrawableRect(int compWidth, int compHeight) {
            int x = PCA2DViewer.this.currentRect.x;
            int y = PCA2DViewer.this.currentRect.y;
            int width = PCA2DViewer.this.currentRect.width;
            int height = PCA2DViewer.this.currentRect.height;
            if (width < 0 && (x = x - (width = 0 - width) + 1) < 0) {
                width += x;
                x = 0;
            }
            if (height < 0 && (y = y - (height = 0 - height) + 1) < 0) {
                height += y;
                y = 0;
            }
            if (x + width > compWidth) {
                width = compWidth - x;
            }
            if (y + height > compHeight) {
                height = compHeight - y;
            }
            if (PCA2DViewer.this.rectToDraw != null) {
                PCA2DViewer.this.previousRectDrawn.setBounds(PCA2DViewer.this.rectToDraw.x, PCA2DViewer.this.rectToDraw.y, PCA2DViewer.this.rectToDraw.width, PCA2DViewer.this.rectToDraw.height);
                PCA2DViewer.this.rectToDraw.setBounds(x, y, width, height);
            } else {
                PCA2DViewer.this.rectToDraw = new Rectangle(x, y, width, height);
            }
        }
    }
}

