/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.owa;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterRepository;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterSelector;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.HCLSigOnlyPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class OneWayANOVAInitBox
extends AlgorithmDialog {
    public static final int JUST_ALPHA = 1;
    public static final int STD_BONFERRONI = 2;
    public static final int ADJ_BONFERRONI = 3;
    public static final int MAX_T = 9;
    public static final int FALSE_NUM = 12;
    public static final int FALSE_PROP = 13;
    public static final int BUTTON_SELECTION = 14;
    public static final int CLUSTER_SELECTION = 15;
    boolean okPressed = false;
    Vector exptNames;
    MultiClassPanel mPanel;
    JTabbedPane selectionPanel;
    PermOrFDistPanel permPanel;
    PValuePanel pPanel;
    HCLSigOnlyPanel hclOpsPanel;
    ClusterRepository repository;

    public OneWayANOVAInitBox(JFrame parentFrame, boolean modality, Vector exptNames, ClusterRepository repository) {
        super(parentFrame, "One-way ANOVA Initialization", modality);
        this.exptNames = exptNames;
        this.repository = repository;
        this.setBounds(0, 0, 800, 850);
        this.setBackground(Color.white);
        this.setDefaultCloseOperation(2);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        JPanel pane = new JPanel();
        pane.setLayout(gridbag);
        this.mPanel = new MultiClassPanel();
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 80);
        gridbag.setConstraints(this.mPanel, constraints);
        pane.add(this.mPanel);
        JTabbedPane consolidatedPane = new JTabbedPane();
        this.permPanel = new PermOrFDistPanel();
        consolidatedPane.add("Permutations of F-Distribution", this.permPanel);
        this.pPanel = new PValuePanel();
        consolidatedPane.add("P-Value/False Discovery Parameters", this.pPanel);
        this.hclOpsPanel = new HCLSigOnlyPanel();
        consolidatedPane.add("Hierarchical Clusters", this.hclOpsPanel);
        this.buildConstraints(constraints, 0, 1, 1, 1, 0, 20);
        gridbag.setConstraints(consolidatedPane, constraints);
        pane.add(consolidatedPane);
        this.addContent(pane);
        EventListener listener = new EventListener();
        this.setActionListeners(listener);
        this.addWindowListener(listener);
    }

    @Override
    public void setVisible(boolean visible) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        super.setVisible(visible);
        if (visible) {
            // empty if block
        }
    }

    void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public boolean drawTrees() {
        return this.hclOpsPanel.isHCLSelected();
    }

    public boolean drawSigTreesOnly() {
        return this.hclOpsPanel.drawSigTreesOnly();
    }

    public int[] getGroupAssignments() {
        int[] groupAssignments = new int[this.exptNames.size()];
        block0: for (int i = 0; i < this.exptNames.size(); ++i) {
            if (this.mPanel.mulgPanel.notInGroupRadioButtons[i].isSelected()) {
                groupAssignments[i] = 0;
                continue;
            }
            for (int j = 0; j < this.mPanel.mulgPanel.exptGroupRadioButtons.length; ++j) {
                if (!this.mPanel.mulgPanel.exptGroupRadioButtons[j][i].isSelected()) continue;
                groupAssignments[i] = j + 1;
                continue block0;
            }
        }
        return groupAssignments;
    }

    public int getTestDesign() {
        int design = -1;
        design = this.mPanel.tabbedmulg.getSelectedIndex() == 0 ? 14 : 15;
        return design;
    }

    public int[] getClusterGroupAssignments() {
        int j;
        int i;
        int[] groupAssignments = new int[this.exptNames.size()];
        ArrayList[] arraylistArray = new ArrayList[this.mPanel.numGroups];
        for (i = 0; i < this.mPanel.numGroups; ++i) {
            j = i + 1;
            arraylistArray[i] = this.mPanel.clusterSelector.getGroupSamples("Group " + j);
        }
        for (i = 0; i < arraylistArray[0].size(); ++i) {
        }
        for (i = 0; i < this.exptNames.size(); ++i) {
            boolean doubleAssigned = false;
            groupAssignments[i] = 0;
            for (j = 0; j < this.mPanel.numGroups; ++j) {
                if (!arraylistArray[j].contains(i)) continue;
                if (doubleAssigned) {
                    Object[] optionst = new Object[]{"OK"};
                    JOptionPane.showOptionDialog(null, "The clusters you have chosen have overlapping samples. \n Each group must contain unique samples.", "Multiple Ownership Error", 1, 3, null, optionst, optionst[0]);
                    return null;
                }
                groupAssignments[i] = j + 1;
                doubleAssigned = true;
            }
        }
        return groupAssignments;
    }

    public int getNumGroups() {
        return this.mPanel.numGroups;
    }

    public boolean usePerms() {
        return this.permPanel.permutButton.isSelected();
    }

    public int getNumPerms() {
        return Integer.parseInt(this.permPanel.timesField.getText());
    }

    public double getPValue() {
        return Double.parseDouble(this.pPanel.pValueInputField.getText());
    }

    public int getFalseNum() {
        return Integer.parseInt(this.pPanel.falseNumField.getText());
    }

    public double getFalseProp() {
        return Double.parseDouble(this.pPanel.falsePropField.getText());
    }

    public boolean validateFalseNum() {
        int a;
        try {
            String falseNum = this.pPanel.falseNumField.getText();
            a = Integer.parseInt(falseNum);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "False number must be an integer >= 0", "Input Error", 2);
            this.pPanel.falseNumField.requestFocus();
            this.pPanel.falseNumField.selectAll();
            return false;
        }
        if (a < 0) {
            JOptionPane.showMessageDialog(this, "False number must be an integer >= 0", "Input Error", 2);
            this.pPanel.falseNumField.requestFocus();
            this.pPanel.falseNumField.selectAll();
            return false;
        }
        return true;
    }

    public boolean validateFalseProp() {
        float a;
        try {
            String falseProp = this.pPanel.falsePropField.getText();
            a = Float.parseFloat(falseProp);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "False proportion must be between 0 and 1", "Input Error", 2);
            this.pPanel.falsePropField.requestFocus();
            this.pPanel.falsePropField.selectAll();
            return false;
        }
        if (a <= 0.0f || a > 1.0f) {
            JOptionPane.showMessageDialog(this, "False proportion must be between 0 and 1", "Input Error", 2);
            this.pPanel.falsePropField.requestFocus();
            this.pPanel.falsePropField.selectAll();
            return false;
        }
        return true;
    }

    public int getCorrectionMethod() {
        int method = 1;
        if (this.pPanel.justAlphaButton.isSelected()) {
            method = 1;
        } else if (this.pPanel.stdBonfButton.isSelected()) {
            method = 2;
        } else if (this.pPanel.adjBonfButton.isSelected()) {
            method = 3;
        } else if (this.pPanel.maxTButton.isSelected()) {
            method = 9;
        } else if (this.pPanel.falseNumButton.isSelected()) {
            method = 12;
        } else if (this.pPanel.falsePropButton.isSelected()) {
            method = 13;
        }
        return method;
    }

    public static void main(String[] args) {
        JFrame dummyFrame = new JFrame();
        Vector<String> dummyVect = new Vector<String>();
        for (int i = 0; i < 95; ++i) {
            dummyVect.add("Expt " + i);
        }
        OneWayANOVAInitBox oBox = new OneWayANOVAInitBox(dummyFrame, true, dummyVect, null);
        oBox.setVisible(true);
    }

    public class EventListener
    extends WindowAdapter
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ae) {
            block19: {
                String command = ae.getActionCommand();
                if (command.equals("ok-command")) {
                    int i;
                    if (OneWayANOVAInitBox.this.getTestDesign() == 15 && OneWayANOVAInitBox.this.repository.isEmpty()) {
                        JOptionPane.showMessageDialog(null, "Cluster Repository is Empty.", "Error", 2);
                        return;
                    }
                    boolean tooFew = false;
                    int[] grpAssignments = OneWayANOVAInitBox.this.getGroupAssignments();
                    if (OneWayANOVAInitBox.this.getTestDesign() == 15) {
                        grpAssignments = OneWayANOVAInitBox.this.getClusterGroupAssignments();
                    }
                    if (grpAssignments == null) {
                        return;
                    }
                    int numGroups = OneWayANOVAInitBox.this.getNumGroups();
                    int[] groupSize = new int[numGroups];
                    for (i = 0; i < groupSize.length; ++i) {
                        groupSize[i] = 0;
                    }
                    for (i = 0; i < grpAssignments.length; ++i) {
                        int currentGroup = grpAssignments[i];
                        if (currentGroup == 0) continue;
                        int n = currentGroup - 1;
                        groupSize[n] = groupSize[n] + 1;
                    }
                    for (i = 0; i < groupSize.length; ++i) {
                        if (groupSize[i] > 1) continue;
                        JOptionPane.showMessageDialog(null, "Each group must contain more than one sample.", "Error", 2);
                        tooFew = true;
                        break;
                    }
                    if (!tooFew) {
                        try {
                            if (OneWayANOVAInitBox.this.pPanel.falseNumButton.isSelected() && !OneWayANOVAInitBox.this.validateFalseNum()) {
                                OneWayANOVAInitBox.this.okPressed = false;
                                return;
                            }
                            if (OneWayANOVAInitBox.this.pPanel.falsePropButton.isSelected() && !OneWayANOVAInitBox.this.validateFalseProp()) {
                                OneWayANOVAInitBox.this.okPressed = false;
                                return;
                            }
                            double d = Double.parseDouble(OneWayANOVAInitBox.this.pPanel.pValueInputField.getText());
                            if (d <= 0.0 || d > 1.0 || OneWayANOVAInitBox.this.usePerms() && OneWayANOVAInitBox.this.getNumPerms() <= 1) {
                                JOptionPane.showMessageDialog(null, "Valid inputs: 0 < alpha < 1, and # of permutations (integer only) > 1", "Error!", 0);
                                break block19;
                            }
                            OneWayANOVAInitBox.this.okPressed = true;
                            OneWayANOVAInitBox.this.dispose();
                        }
                        catch (NumberFormatException nfe) {
                            JOptionPane.showMessageDialog(null, "Valid inputs: 0 < alpha < 1, and # of permutations (integer only) > 1", "Error!", 0);
                        }
                    }
                } else if (command.equals("reset-command")) {
                    OneWayANOVAInitBox.this.mPanel.reset();
                    OneWayANOVAInitBox.this.pPanel.reset();
                } else if (command.equals("cancel-command")) {
                    OneWayANOVAInitBox.this.okPressed = false;
                    OneWayANOVAInitBox.this.dispose();
                } else if (command.equals("info-command")) {
                    HelpWindow.launchBrowser(OneWayANOVAInitBox.this, "One Way ANOVA Initialization Dialog");
                }
            }
        }
    }

    class PValuePanel
    extends JPanel {
        JTextField pValueInputField;
        JTextField falseNumField;
        JTextField falsePropField;
        JRadioButton justAlphaButton;
        JRadioButton stdBonfButton;
        JRadioButton adjBonfButton;
        JRadioButton maxTButton;
        JRadioButton falseNumButton;
        JRadioButton falsePropButton;

        public PValuePanel() {
            this.setBorder(new TitledBorder(new EtchedBorder(), "P-value / false discovery parameters", 0, 0, new Font("Dialog", 1, 12), Color.black));
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.setBackground(Color.white);
            this.setLayout(gridbag);
            JLabel pValueLabel = new JLabel("Enter alpha (critical p-value): ");
            OneWayANOVAInitBox.this.buildConstraints(constraints, 0, 0, 1, 1, 33, 25);
            constraints.anchor = 13;
            gridbag.setConstraints(pValueLabel, constraints);
            this.add(pValueLabel);
            this.pValueInputField = new JTextField("0.01", 7);
            OneWayANOVAInitBox.this.buildConstraints(constraints, 1, 0, 1, 1, 33, 0);
            constraints.anchor = 17;
            gridbag.setConstraints(this.pValueInputField, constraints);
            this.add(this.pValueInputField);
            constraints.anchor = 10;
            this.justAlphaButton = new JRadioButton("Just alpha (no correction)", true);
            this.justAlphaButton.setBackground(Color.white);
            this.stdBonfButton = new JRadioButton("Standard Bonferroni", false);
            this.stdBonfButton.setBackground(Color.white);
            this.adjBonfButton = new JRadioButton("Adjusted Bonferroni", false);
            this.adjBonfButton.setBackground(Color.white);
            this.maxTButton = new JRadioButton("Westfall-Young step-down maxT", false);
            this.maxTButton.setBackground(Color.white);
            this.maxTButton.setEnabled(false);
            this.falseNumButton = new JRadioButton("EITHER, The number of false significant genes should not exceed", false);
            this.falseNumButton.setEnabled(false);
            this.falseNumButton.setFocusPainted(false);
            this.falseNumButton.setForeground(UIManager.getColor("Label.foreground"));
            this.falseNumButton.setBackground(Color.white);
            this.falsePropButton = new JRadioButton("OR, The proportion of false significant genes should not exceed", false);
            this.falsePropButton.setEnabled(false);
            this.falsePropButton.setFocusPainted(false);
            this.falsePropButton.setForeground(UIManager.getColor("Label.foreground"));
            this.falsePropButton.setBackground(Color.white);
            this.falseNumField = new JTextField(10);
            this.falseNumField.setText("10");
            this.falseNumField.setEnabled(false);
            this.falsePropField = new JTextField(10);
            this.falsePropField.setText("0.05");
            this.falsePropField.setEnabled(false);
            ButtonGroup chooseCorrection = new ButtonGroup();
            chooseCorrection.add(this.justAlphaButton);
            chooseCorrection.add(this.stdBonfButton);
            chooseCorrection.add(this.adjBonfButton);
            chooseCorrection.add(this.maxTButton);
            chooseCorrection.add(this.falseNumButton);
            chooseCorrection.add(this.falsePropButton);
            JPanel FDRPanel = new JPanel();
            FDRPanel.setBackground(Color.white);
            FDRPanel.setBorder(new TitledBorder(new EtchedBorder(1), "False discovery control (permutations only)", 0, 0, new Font("Dialog", 1, 12), Color.black));
            GridBagLayout grid3 = new GridBagLayout();
            FDRPanel.setLayout(grid3);
            JLabel FDRLabel = new JLabel("With confidence of [1 - alpha] : ");
            constraints.anchor = 17;
            OneWayANOVAInitBox.this.buildConstraints(constraints, 0, 0, 2, 1, 100, 34);
            grid3.setConstraints(FDRLabel, constraints);
            FDRPanel.add(FDRLabel);
            constraints.anchor = 10;
            OneWayANOVAInitBox.this.buildConstraints(constraints, 0, 1, 1, 1, 50, 33);
            constraints.anchor = 13;
            grid3.setConstraints(this.falseNumButton, constraints);
            FDRPanel.add(this.falseNumButton);
            OneWayANOVAInitBox.this.buildConstraints(constraints, 1, 1, 1, 1, 50, 0);
            constraints.anchor = 17;
            grid3.setConstraints(this.falseNumField, constraints);
            FDRPanel.add(this.falseNumField);
            OneWayANOVAInitBox.this.buildConstraints(constraints, 0, 2, 1, 1, 50, 33);
            constraints.anchor = 13;
            grid3.setConstraints(this.falsePropButton, constraints);
            FDRPanel.add(this.falsePropButton);
            OneWayANOVAInitBox.this.buildConstraints(constraints, 1, 2, 1, 1, 50, 0);
            constraints.anchor = 17;
            grid3.setConstraints(this.falsePropField, constraints);
            FDRPanel.add(this.falsePropField);
            constraints.anchor = 10;
            OneWayANOVAInitBox.this.buildConstraints(constraints, 0, 1, 1, 1, 25, 25);
            gridbag.setConstraints(this.justAlphaButton, constraints);
            this.add(this.justAlphaButton);
            OneWayANOVAInitBox.this.buildConstraints(constraints, 1, 1, 1, 1, 25, 0);
            gridbag.setConstraints(this.stdBonfButton, constraints);
            this.add(this.stdBonfButton);
            OneWayANOVAInitBox.this.buildConstraints(constraints, 2, 1, 1, 1, 25, 0);
            gridbag.setConstraints(this.adjBonfButton, constraints);
            this.add(this.adjBonfButton);
            OneWayANOVAInitBox.this.buildConstraints(constraints, 3, 1, 1, 1, 25, 0);
            gridbag.setConstraints(this.maxTButton, constraints);
            this.add(this.maxTButton);
            OneWayANOVAInitBox.this.buildConstraints(constraints, 0, 2, 4, 1, 100, 50);
            gridbag.setConstraints(FDRPanel, constraints);
            this.add(FDRPanel);
        }

        protected void reset() {
            this.pValueInputField.setText("0.01");
            this.justAlphaButton.setSelected(true);
        }
    }

    class PermOrFDistPanel
    extends JPanel {
        JRadioButton tDistButton;
        JRadioButton permutButton;
        JLabel numPermsLabel;
        JTextField timesField;

        PermOrFDistPanel() {
            this.setBorder(new TitledBorder(new EtchedBorder(1), "Permutations or F-distribution", 0, 0, new Font("Dialog", 1, 12), Color.black));
            this.setBackground(Color.white);
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.setLayout(gridbag);
            ButtonGroup chooseP = new ButtonGroup();
            this.tDistButton = new JRadioButton("p-values based on F-distribution", true);
            this.tDistButton.setFocusPainted(false);
            this.tDistButton.setForeground(UIManager.getColor("Label.foreground"));
            this.tDistButton.setBackground(Color.white);
            this.numPermsLabel = new JLabel("Enter number of permutations");
            this.numPermsLabel.setEnabled(false);
            this.timesField = new JTextField("1000", 7);
            this.timesField.setEnabled(false);
            this.timesField.setBackground(Color.darkGray);
            this.tDistButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PermOrFDistPanel.this.numPermsLabel.setEnabled(false);
                    PermOrFDistPanel.this.timesField.setEnabled(false);
                    PermOrFDistPanel.this.timesField.setBackground(Color.darkGray);
                    if (OneWayANOVAInitBox.this.pPanel.maxTButton.isSelected() || OneWayANOVAInitBox.this.pPanel.falseNumButton.isSelected() || OneWayANOVAInitBox.this.pPanel.falsePropButton.isSelected()) {
                        OneWayANOVAInitBox.this.pPanel.justAlphaButton.setSelected(true);
                    }
                    OneWayANOVAInitBox.this.pPanel.maxTButton.setEnabled(false);
                    OneWayANOVAInitBox.this.pPanel.falseNumButton.setEnabled(false);
                    OneWayANOVAInitBox.this.pPanel.falsePropButton.setEnabled(false);
                    OneWayANOVAInitBox.this.pPanel.falseNumField.setEnabled(false);
                    OneWayANOVAInitBox.this.pPanel.falsePropField.setEnabled(false);
                }
            });
            chooseP.add(this.tDistButton);
            this.permutButton = new JRadioButton("p-values based on permutation:  ", false);
            this.permutButton.setFocusPainted(false);
            this.permutButton.setForeground(UIManager.getColor("Label.foreground"));
            this.permutButton.setBackground(Color.white);
            this.permutButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PermOrFDistPanel.this.numPermsLabel.setEnabled(true);
                    PermOrFDistPanel.this.timesField.setEnabled(true);
                    PermOrFDistPanel.this.timesField.setBackground(Color.white);
                    OneWayANOVAInitBox.this.pPanel.maxTButton.setEnabled(true);
                    OneWayANOVAInitBox.this.pPanel.falseNumButton.setEnabled(true);
                    OneWayANOVAInitBox.this.pPanel.falsePropButton.setEnabled(true);
                    OneWayANOVAInitBox.this.pPanel.falseNumField.setEnabled(true);
                    OneWayANOVAInitBox.this.pPanel.falsePropField.setEnabled(true);
                }
            });
            chooseP.add(this.permutButton);
            OneWayANOVAInitBox.this.buildConstraints(constraints, 0, 0, 3, 1, 100, 50);
            constraints.anchor = 17;
            gridbag.setConstraints(this.tDistButton, constraints);
            this.add(this.tDistButton);
            OneWayANOVAInitBox.this.buildConstraints(constraints, 0, 1, 1, 1, 30, 50);
            constraints.anchor = 17;
            gridbag.setConstraints(this.permutButton, constraints);
            this.add(this.permutButton);
            OneWayANOVAInitBox.this.buildConstraints(constraints, 1, 1, 1, 1, 30, 0);
            gridbag.setConstraints(this.numPermsLabel, constraints);
            this.add(this.numPermsLabel);
            OneWayANOVAInitBox.this.buildConstraints(constraints, 2, 1, 1, 1, 40, 0);
            gridbag.setConstraints(this.timesField, constraints);
            this.add(this.timesField);
        }
    }

    class MultiClassPanel
    extends JPanel {
        NumGroupsPanel ngPanel;
        GridBagConstraints constraints = new GridBagConstraints();
        GridBagLayout gridbag = new GridBagLayout();
        JPanel dummyPanel;
        MultiGroupExperimentsPanel mulgPanel;
        JTabbedPane tabbedmulg;
        ClusterSelector clusterSelector;
        int numGroups;

        public MultiClassPanel() {
            this.setBackground(Color.white);
            this.setLayout(this.gridbag);
            this.ngPanel = new NumGroupsPanel();
            OneWayANOVAInitBox.this.buildConstraints(this.constraints, 0, 0, 1, 1, 100, 10);
            this.constraints.fill = 1;
            this.gridbag.setConstraints(this.ngPanel, this.constraints);
            this.ngPanel.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MultiClassPanel.this.ngPanel.okPressed = true;
                    try {
                        MultiClassPanel.this.numGroups = Integer.parseInt(MultiClassPanel.this.ngPanel.numGroupsField.getText());
                        if (MultiClassPanel.this.numGroups <= 2) {
                            JOptionPane.showMessageDialog(null, "Please enter a positive integer > 2!", "Error", 0);
                        } else {
                            MultiClassPanel.this.mulgPanel = new MultiGroupExperimentsPanel(OneWayANOVAInitBox.this.exptNames, MultiClassPanel.this.numGroups);
                            MultiClassPanel.this.remove(MultiClassPanel.this.dummyPanel);
                            MultiClassPanel.this.tabbedmulg = new JTabbedPane();
                            MultiClassPanel.this.clusterSelector = new ClusterSelector(OneWayANOVAInitBox.this.repository, MultiClassPanel.this.numGroups);
                            MultiClassPanel.this.tabbedmulg.add("Button Selection", MultiClassPanel.this.mulgPanel);
                            MultiClassPanel.this.tabbedmulg.add("Cluster Selection", (Component)MultiClassPanel.this.clusterSelector);
                            MultiClassPanel.this.tabbedmulg.setSelectedIndex(1);
                            if (OneWayANOVAInitBox.this.repository == null || OneWayANOVAInitBox.this.repository.isEmpty()) {
                                MultiClassPanel.this.tabbedmulg.setSelectedIndex(0);
                            }
                            OneWayANOVAInitBox.this.buildConstraints(MultiClassPanel.this.constraints, 0, 1, 1, 1, 0, 90);
                            MultiClassPanel.this.constraints.fill = 1;
                            MultiClassPanel.this.gridbag.setConstraints(MultiClassPanel.this.tabbedmulg, MultiClassPanel.this.constraints);
                            MultiClassPanel.this.add(MultiClassPanel.this.tabbedmulg);
                            MultiClassPanel.this.validate();
                            MultiClassPanel.this.ngPanel.okButton.setEnabled(false);
                            MultiClassPanel.this.ngPanel.numGroupsField.setEnabled(false);
                        }
                    }
                    catch (NumberFormatException nfe) {
                        JOptionPane.showMessageDialog(null, "Please enter a positive integer > 2!", "Error", 0);
                    }
                }
            });
            this.add(this.ngPanel);
            OneWayANOVAInitBox.this.buildConstraints(this.constraints, 0, 1, 1, 1, 0, 90);
            this.dummyPanel = new JPanel();
            this.dummyPanel.setBackground(Color.white);
            this.gridbag.setConstraints(this.dummyPanel, this.constraints);
            this.add(this.dummyPanel);
        }

        protected void reset() {
            this.mulgPanel.reset();
        }

        class MultiGroupExperimentsPanel
        extends JPanel {
            int numPanels = 0;
            JLabel[] expLabels;
            JRadioButton[][] exptGroupRadioButtons;
            JRadioButton[] notInGroupRadioButtons;

            MultiGroupExperimentsPanel(Vector exptNames, int numGroups) {
                int i;
                int i2;
                this.setBorder(new TitledBorder(new EtchedBorder(), "Group Assignments", 0, 0, new Font("Dialog", 1, 12), Color.black));
                this.setBackground(Color.white);
                this.expLabels = new JLabel[exptNames.size()];
                this.exptGroupRadioButtons = new JRadioButton[numGroups][exptNames.size()];
                this.numPanels = exptNames.size() / 512 + 1;
                this.notInGroupRadioButtons = new JRadioButton[exptNames.size()];
                ButtonGroup[] chooseGroup = new ButtonGroup[exptNames.size()];
                GridBagLayout gridbag = new GridBagLayout();
                GridBagLayout gridbag2 = new GridBagLayout();
                GridBagConstraints constraints = new GridBagConstraints();
                this.setLayout(gridbag2);
                JPanel[] panels = new JPanel[this.numPanels];
                int currPanel = 0;
                for (i2 = 0; i2 < panels.length; ++i2) {
                    panels[i2] = new JPanel(gridbag);
                }
                for (i2 = 0; i2 < exptNames.size(); ++i2) {
                    int j;
                    String s1 = (String)exptNames.get(i2);
                    this.expLabels[i2] = new JLabel(s1);
                    chooseGroup[i2] = new ButtonGroup();
                    for (j = 0; j < numGroups; ++j) {
                        this.exptGroupRadioButtons[j][i2] = new JRadioButton("Group " + (j + 1) + "     ", j == 0);
                        chooseGroup[i2].add(this.exptGroupRadioButtons[j][i2]);
                    }
                    currPanel = i2 / 512;
                    this.notInGroupRadioButtons[i2] = new JRadioButton("Not in groups", false);
                    chooseGroup[i2].add(this.notInGroupRadioButtons[i2]);
                    for (j = 0; j < numGroups; ++j) {
                        OneWayANOVAInitBox.this.buildConstraints(constraints, j, i2 % 512, 1, 1, 100, 100);
                        gridbag.setConstraints(this.exptGroupRadioButtons[j][i2], constraints);
                        panels[currPanel].add(this.exptGroupRadioButtons[j][i2]);
                    }
                    OneWayANOVAInitBox.this.buildConstraints(constraints, numGroups + 1, i2 % 512, 1, 1, 100, 100);
                    gridbag.setConstraints(this.notInGroupRadioButtons[i2], constraints);
                    panels[currPanel].add(this.notInGroupRadioButtons[i2]);
                }
                int maxLabelWidth = 0;
                for (int i3 = 0; i3 < this.expLabels.length; ++i3) {
                    if (!(this.expLabels[i3].getPreferredSize().getWidth() > (double)maxLabelWidth)) continue;
                    maxLabelWidth = (int)Math.ceil(this.expLabels[i3].getPreferredSize().getWidth());
                }
                JPanel bigPanel = new JPanel(new GridBagLayout());
                for (int i4 = 0; i4 < this.numPanels; ++i4) {
                    bigPanel.add((Component)panels[i4], new GridBagConstraints(0, i4, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                }
                JScrollPane scroll = new JScrollPane(bigPanel);
                scroll.setHorizontalScrollBarPolicy(32);
                scroll.setVerticalScrollBarPolicy(22);
                JPanel[] exptNameHeaderPanels = new JPanel[this.numPanels];
                GridBagLayout exptHeaderGridbag = new GridBagLayout();
                for (i = 0; i < exptNameHeaderPanels.length; ++i) {
                    exptNameHeaderPanels[i] = new JPanel();
                    exptNameHeaderPanels[i].setSize(50, panels[i].getPreferredSize().height);
                    exptNameHeaderPanels[i].setPreferredSize(new Dimension(maxLabelWidth + 10, panels[i].getPreferredSize().height));
                    exptNameHeaderPanels[i].setLayout(exptHeaderGridbag);
                }
                for (i = 0; i < this.expLabels.length; ++i) {
                    currPanel = i / 512;
                    OneWayANOVAInitBox.this.buildConstraints(constraints, 0, i % 512, 1, 1, 100, 100);
                    constraints.fill = 1;
                    exptHeaderGridbag.setConstraints(this.expLabels[i], constraints);
                    exptNameHeaderPanels[currPanel].add(this.expLabels[i]);
                }
                JPanel headerPanel = new JPanel(new GridBagLayout());
                for (int i5 = 0; i5 < exptNameHeaderPanels.length; ++i5) {
                    headerPanel.add((Component)exptNameHeaderPanels[i5], new GridBagConstraints(0, i5, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                }
                scroll.setRowHeaderView(headerPanel);
                OneWayANOVAInitBox.this.buildConstraints(constraints, 0, 0, 1, 1, 100, 90);
                constraints.fill = 1;
                gridbag2.setConstraints(scroll, constraints);
                this.add(scroll);
                JLabel label1 = new JLabel("Note: Each group MUST each contain more than one sample.");
                label1.setHorizontalAlignment(0);
                OneWayANOVAInitBox.this.buildConstraints(constraints, 0, 1, 1, 1, 0, 5);
                constraints.anchor = 13;
                gridbag2.setConstraints(label1, constraints);
                this.add(label1);
                JPanel panel2 = new JPanel();
                GridBagLayout gridbag3 = new GridBagLayout();
                panel2.setLayout(gridbag3);
                panel2.setBackground(Color.white);
                JButton saveButton = new JButton("  Save settings  ");
                saveButton.setFocusPainted(false);
                saveButton.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
                JButton loadButton = new JButton("  Load settings  ");
                loadButton.setFocusPainted(false);
                loadButton.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
                JButton resetButton = new JButton("  Reset  ");
                resetButton.setFocusPainted(false);
                resetButton.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
                final int finNum = exptNames.size();
                resetButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        for (int i = 0; i < finNum; ++i) {
                            MultiGroupExperimentsPanel.this.exptGroupRadioButtons[0][i].setSelected(true);
                        }
                    }
                });
                JFileChooser fc = new JFileChooser(TMEV.getDataPath());
                saveButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        MultiGroupExperimentsPanel.this.saveAssignments();
                    }
                });
                loadButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        MultiGroupExperimentsPanel.this.loadAssignments();
                    }
                });
                constraints.anchor = 10;
                constraints.fill = 0;
                constraints.insets = new Insets(5, 5, 5, 5);
                OneWayANOVAInitBox.this.buildConstraints(constraints, 0, 0, 1, 1, 33, 100);
                gridbag3.setConstraints(saveButton, constraints);
                panel2.add(saveButton);
                OneWayANOVAInitBox.this.buildConstraints(constraints, 1, 0, 1, 1, 33, 0);
                gridbag3.setConstraints(loadButton, constraints);
                panel2.add(loadButton);
                OneWayANOVAInitBox.this.buildConstraints(constraints, 2, 0, 1, 1, 34, 0);
                gridbag3.setConstraints(resetButton, constraints);
                panel2.add(resetButton);
                constraints.insets = new Insets(0, 0, 0, 0);
                OneWayANOVAInitBox.this.buildConstraints(constraints, 0, 2, 1, 1, 0, 5);
                constraints.anchor = 10;
                gridbag2.setConstraints(panel2, constraints);
                this.add(panel2);
            }

            private void saveAssignments() {
                JFileChooser fileChooser = new JFileChooser(TMEV.getDataPath());
                if (fileChooser.showSaveDialog(this) == 0) {
                    File file = fileChooser.getSelectedFile();
                    try {
                        PrintWriter pw = new PrintWriter(new FileWriter(file));
                        Date currDate = new Date(System.currentTimeMillis());
                        String dateString = currDate.toString();
                        String userName = System.getProperty("user.name");
                        pw.println("# Assignment File");
                        pw.println("# User: " + userName + " Save Date: " + dateString);
                        pw.println("#");
                        pw.print("Module:\t");
                        pw.println("ANOVA");
                        for (int i = 0; i < MultiClassPanel.this.numGroups; ++i) {
                            pw.print("Group " + (i + 1) + " Label:\t");
                            pw.println("Group " + (i + 1));
                        }
                        pw.println("#");
                        pw.println("Sample Index\tSample Name\tGroup Assignment");
                        int[] groupAssgn = OneWayANOVAInitBox.this.getGroupAssignments();
                        for (int sample = 0; sample < OneWayANOVAInitBox.this.exptNames.size(); ++sample) {
                            pw.print(String.valueOf(sample + 1) + "\t");
                            pw.print(OneWayANOVAInitBox.this.exptNames.get(sample) + "\t");
                            if (groupAssgn[sample] != 0) {
                                pw.println("Group " + groupAssgn[sample]);
                                continue;
                            }
                            pw.println("Exclude");
                        }
                        pw.flush();
                        pw.close();
                    }
                    catch (FileNotFoundException fnfe) {
                        fnfe.printStackTrace();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
            }

            private void loadAssignments() {
                JFileChooser fileChooser = new JFileChooser(TMEV.getDataPath());
                if (fileChooser.showOpenDialog(this) == 0) {
                    File file = fileChooser.getSelectedFile();
                    try {
                        String line;
                        BufferedReader br = new BufferedReader(new FileReader(file));
                        Vector<String> data = new Vector<String>();
                        while ((line = br.readLine()) != null) {
                            data.add(line.trim());
                        }
                        br.close();
                        Vector<String> groupNames = new Vector<String>();
                        Vector<Integer> sampleIndices = new Vector<Integer>();
                        Vector<String> sampleNames = new Vector<String>();
                        Vector<String> groupAssignments = new Vector<String>();
                        for (int row = 0; row < data.size(); ++row) {
                            line = (String)data.get(row);
                            if (line.startsWith("#") || line.startsWith("SampleIndex")) continue;
                            String[] lineArray = line.split("\t");
                            if (lineArray[0].startsWith("Module:")) {
                                if (lineArray[1].equals("ANOVA")) continue;
                                Object[] optionst = new Object[]{"Continue", "Cancel"};
                                if (JOptionPane.showOptionDialog(null, "The saved file was saved using a different module, " + lineArray[1] + ". \n Would you like MeV to try to load it anyway?", "File type warning", 1, 3, null, optionst, optionst[0]) == 0) continue;
                                return;
                            }
                            if (lineArray[0].startsWith("Group ") && lineArray[0].endsWith("Label:")) {
                                groupNames.add(lineArray[1]);
                                continue;
                            }
                            try {
                                Integer.parseInt(lineArray[0]);
                            }
                            catch (NumberFormatException nfe) {
                                continue;
                            }
                            sampleIndices.add(new Integer(lineArray[0]));
                            sampleNames.add(lineArray[1]);
                            groupAssignments.add(lineArray[2]);
                        }
                        if (OneWayANOVAInitBox.this.exptNames.size() != sampleNames.size()) {
                            System.out.println(OneWayANOVAInitBox.this.exptNames.size() + "  " + sampleNames.size());
                            System.out.println(OneWayANOVAInitBox.this.exptNames.size() + " s length " + sampleNames.size());
                            JOptionPane.showMessageDialog(this, "<html>Error -- number of samples designated in assignment file (" + String.valueOf(sampleNames.size()) + ")<br>" + "does not match the number of samples loaded in MeV (" + OneWayANOVAInitBox.this.exptNames.size() + ").<br>" + "Assignments are not set.</html>", "File Compatibility Error", 0);
                            return;
                        }
                        Vector<String> currSampleVector = new Vector<String>();
                        for (int i = 0; i < OneWayANOVAInitBox.this.exptNames.size(); ++i) {
                            currSampleVector.add((String)OneWayANOVAInitBox.this.exptNames.get(i));
                        }
                        int fileSampleIndex = 0;
                        int groupIndex = 0;
                        for (int sample = 0; sample < OneWayANOVAInitBox.this.exptNames.size(); ++sample) {
                            boolean doIndex = false;
                            for (int i = 0; i < OneWayANOVAInitBox.this.exptNames.size(); ++i) {
                                if (i == sample || !OneWayANOVAInitBox.this.exptNames.get(i).equals(OneWayANOVAInitBox.this.exptNames.get(sample))) continue;
                                doIndex = true;
                            }
                            fileSampleIndex = sampleNames.indexOf(OneWayANOVAInitBox.this.exptNames.get(sample));
                            if (fileSampleIndex == -1) {
                                doIndex = true;
                            }
                            if (doIndex) {
                                this.setStateBasedOnIndex(groupAssignments, groupNames);
                                break;
                            }
                            String groupName = (String)groupAssignments.get(fileSampleIndex);
                            groupIndex = groupNames.indexOf(groupName);
                            try {
                                this.exptGroupRadioButtons[groupIndex][sample].setSelected(true);
                                continue;
                            }
                            catch (Exception e) {
                                this.notInGroupRadioButtons[sample].setSelected(true);
                            }
                        }
                        this.repaint();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(this, "<html>The file format cannot be read.</html>", "File Compatibility Error", 0);
                    }
                }
            }

            private void setStateBasedOnIndex(Vector<String> groupAssignments, Vector<String> groupNames) {
                Object[] optionst = new Object[]{"Continue", "Cancel"};
                if (JOptionPane.showOptionDialog(null, "The saved file was saved using a different sample annotation. \n Would you like MeV to try to load it by index order?", "File type warning", 1, 3, null, optionst, optionst[0]) == 1) {
                    return;
                }
                for (int sample = 0; sample < OneWayANOVAInitBox.this.exptNames.size(); ++sample) {
                    try {
                        this.exptGroupRadioButtons[groupNames.indexOf(groupAssignments.get(sample))][sample].setSelected(true);
                        continue;
                    }
                    catch (Exception e) {
                        this.notInGroupRadioButtons[sample].setSelected(true);
                    }
                }
            }

            protected void reset() {
                for (int i = 0; i < OneWayANOVAInitBox.this.exptNames.size(); ++i) {
                    this.exptGroupRadioButtons[0][i].setSelected(true);
                }
            }
        }

        class NumGroupsPanel
        extends JPanel {
            JTextField numGroupsField;
            JButton okButton;
            boolean okPressed = false;

            public NumGroupsPanel() {
                this.setBackground(Color.white);
                GridBagLayout gridbag = new GridBagLayout();
                GridBagConstraints constraints = new GridBagConstraints();
                this.setLayout(gridbag);
                JLabel numGroupsLabel = new JLabel("Number of groups ");
                OneWayANOVAInitBox.this.buildConstraints(constraints, 0, 0, 1, 1, 30, 100);
                constraints.anchor = 13;
                gridbag.setConstraints(numGroupsLabel, constraints);
                this.add(numGroupsLabel);
                this.numGroupsField = new JTextField("", 7);
                constraints.anchor = 17;
                OneWayANOVAInitBox.this.buildConstraints(constraints, 1, 0, 1, 1, 30, 0);
                gridbag.setConstraints(this.numGroupsField, constraints);
                this.add(this.numGroupsField);
                this.okButton = new JButton("OK");
                OneWayANOVAInitBox.this.buildConstraints(constraints, 2, 0, 1, 1, 40, 0);
                gridbag.setConstraints(this.okButton, constraints);
                this.add(this.okButton);
            }

            @Override
            public void setVisible(boolean visible) {
                this.setLocation((MultiClassPanel.this.getWidth() - this.getSize().width) / 2, (MultiClassPanel.this.getHeight() - this.getSize().height) / 2);
                super.setVisible(visible);
                if (visible) {
                    // empty if block
                }
            }

            public boolean isOkPressed() {
                return this.okPressed;
            }
        }
    }
}

