/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.owa;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLGUI;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeData;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLViewer;
import org.tigr.microarray.mev.cluster.gui.impl.owa.OWACentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.owa.OWACentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.owa.OWAExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.owa.OWAInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.owa.OneWayANOVAInitBox;
import org.tigr.microarray.mev.script.scriptGUI.IScriptGUI;
import org.tigr.util.FloatMatrix;

public class OWAGUI
implements IClusterGUI,
IScriptGUI {
    protected Algorithm algorithm;
    protected Progress progress;
    protected Experiment experiment;
    protected int[][] clusters;
    protected FloatMatrix means;
    protected FloatMatrix variances;
    protected String[] auxTitles;
    protected Object[][] auxData;
    protected Vector fValues;
    protected Vector rawPValues;
    protected Vector adjPValues;
    protected Vector dfNumValues;
    protected Vector dfDenomValues;
    protected Vector ssGroups;
    protected Vector ssError;
    protected float[][] geneGroupMeans;
    protected float[][] geneGroupSDs;
    protected boolean drawSigTreesOnly;
    Vector exptNamesVector;
    protected int[] groupAssignments;
    protected int falseNum;
    protected int correctionMethod;
    protected double falseProp;
    protected IData data;
    protected int numGroups;
    protected int numPerms;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework framework) throws AlgorithmException {
        IDistanceMenu menu;
        int function;
        this.experiment = framework.getData().getExperiment();
        this.data = framework.getData();
        this.exptNamesVector = new Vector();
        int number_of_samples = this.experiment.getNumberOfSamples();
        int number_of_genes = this.experiment.getNumberOfGenes();
        int[] columnIndices = this.experiment.getColumnIndicesCopy();
        for (int i = 0; i < number_of_samples; ++i) {
            this.exptNamesVector.add(framework.getData().getFullSampleName(columnIndices[i]));
        }
        OneWayANOVAInitBox owaDialog = new OneWayANOVAInitBox((JFrame)framework.getFrame(), true, this.exptNamesVector, framework.getClusterRepository(1));
        owaDialog.setVisible(true);
        if (!owaDialog.isOkPressed()) {
            return null;
        }
        double alpha = owaDialog.getPValue();
        this.numGroups = owaDialog.getNumGroups();
        if (owaDialog.getTestDesign() == 15) {
            this.groupAssignments = owaDialog.getClusterGroupAssignments();
        }
        if (owaDialog.getTestDesign() == 14) {
            this.groupAssignments = owaDialog.getGroupAssignments();
        }
        if (this.groupAssignments == null) {
            return null;
        }
        boolean usePerms = owaDialog.usePerms();
        int numPerms = 0;
        if (usePerms) {
            numPerms = owaDialog.getNumPerms();
        }
        this.correctionMethod = owaDialog.getCorrectionMethod();
        if (this.correctionMethod == 12) {
            this.falseNum = owaDialog.getFalseNum();
        }
        if (this.correctionMethod == 13) {
            this.falseProp = owaDialog.getFalseProp();
        }
        boolean isHierarchicalTree = owaDialog.drawTrees();
        this.drawSigTreesOnly = true;
        if (isHierarchicalTree) {
            this.drawSigTreesOnly = owaDialog.drawSigTreesOnly();
        }
        if ((function = (menu = framework.getDistanceMenu()).getDistanceFunction()) == 0) {
            function = 1;
        }
        int hcl_method = 0;
        boolean hcl_samples = false;
        boolean hcl_genes = false;
        int hcl_function = 4;
        boolean hcl_absolute = false;
        if (isHierarchicalTree) {
            HCLInitDialog hcl_dialog = new HCLInitDialog(framework.getFrame(), menu.getFunctionName(function), menu.isAbsoluteDistance(), true);
            if (hcl_dialog.showModal() != 0) {
                return null;
            }
            hcl_method = hcl_dialog.getMethod();
            hcl_samples = hcl_dialog.isClusterExperiments();
            hcl_genes = hcl_dialog.isClusterGenes();
            hcl_function = hcl_dialog.getDistanceMetric();
            hcl_absolute = hcl_dialog.getAbsoluteSelection();
        }
        Listener listener = new Listener();
        try {
            int i;
            int i2;
            this.algorithm = framework.getAlgorithmFactory().getAlgorithm("OWA");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            this.progress = new Progress(framework.getFrame(), "Finding significant genes", listener);
            this.progress.show();
            AlgorithmData data = new AlgorithmData();
            data.addMatrix("experiment", this.experiment.getMatrix());
            data.addParam("distance-factor", String.valueOf(1.0f));
            data.addParam("distance-absolute", String.valueOf(menu.isAbsoluteDistance()));
            data.addParam("distance-function", String.valueOf(function));
            data.addIntArray("group-assignments", this.groupAssignments);
            data.addParam("usePerms", String.valueOf(usePerms));
            data.addParam("numPerms", String.valueOf(numPerms));
            data.addParam("alpha", String.valueOf(alpha));
            data.addParam("correction-method", String.valueOf(this.correctionMethod));
            data.addParam("numGroups", String.valueOf(this.numGroups));
            if (this.correctionMethod == 12) {
                data.addParam("falseNum", String.valueOf(this.falseNum));
            }
            if (this.correctionMethod == 13) {
                data.addParam("falseProp", String.valueOf((float)this.falseProp));
            }
            if (isHierarchicalTree) {
                data.addParam("hierarchical-tree", String.valueOf(true));
                data.addParam("draw-sig-trees-only", String.valueOf(this.drawSigTreesOnly));
                data.addParam("method-linkage", String.valueOf(hcl_method));
                data.addParam("calculate-genes", String.valueOf(hcl_genes));
                data.addParam("calculate-experiments", String.valueOf(hcl_samples));
                data.addParam("hcl-distance-function", String.valueOf(hcl_function));
                data.addParam("hcl-distance-absolute", String.valueOf(hcl_absolute));
            }
            long start = System.currentTimeMillis();
            AlgorithmData result = this.algorithm.execute(data);
            long time = System.currentTimeMillis() - start;
            Cluster result_cluster = result.getCluster("cluster");
            NodeList nodeList = result_cluster.getNodeList();
            AlgorithmParameters resultMap = result.getParams();
            int k = 2;
            this.clusters = new int[k][];
            for (int i3 = 0; i3 < k; ++i3) {
                this.clusters[i3] = nodeList.getNode(i3).getFeaturesIndexes();
            }
            this.means = result.getMatrix("clusters_means");
            this.variances = result.getMatrix("clusters_variances");
            FloatMatrix rawPValuesMatrix = result.getMatrix("rawPValues");
            FloatMatrix adjPValuesMatrix = result.getMatrix("adjPValues");
            FloatMatrix fValuesMatrix = result.getMatrix("fValues");
            FloatMatrix dfNumMatrix = result.getMatrix("dfNumMatrix");
            FloatMatrix dfDenomMatrix = result.getMatrix("dfDenomMatrix");
            FloatMatrix ssGroupsMatrix = result.getMatrix("ssGroupsMatrix");
            FloatMatrix ssErrorMatrix = result.getMatrix("ssErrorMatrix");
            FloatMatrix geneGroupMeansMatrix = result.getMatrix("geneGroupMeansMatrix");
            FloatMatrix geneGroupSDsMatrix = result.getMatrix("geneGroupSDsMatrix");
            this.rawPValues = new Vector();
            this.adjPValues = new Vector();
            this.fValues = new Vector();
            this.ssGroups = new Vector();
            this.ssError = new Vector();
            this.geneGroupMeans = new float[geneGroupMeansMatrix.getRowDimension()][geneGroupMeansMatrix.getColumnDimension()];
            this.geneGroupSDs = new float[geneGroupSDsMatrix.getRowDimension()][geneGroupSDsMatrix.getColumnDimension()];
            for (i2 = 0; i2 < this.geneGroupMeans.length; ++i2) {
                for (int j = 0; j < this.geneGroupMeans[i2].length; ++j) {
                    this.geneGroupMeans[i2][j] = geneGroupMeansMatrix.A[i2][j];
                    this.geneGroupSDs[i2][j] = geneGroupSDsMatrix.A[i2][j];
                }
            }
            for (i2 = 0; i2 < rawPValuesMatrix.getRowDimension(); ++i2) {
                this.rawPValues.add(new Float(rawPValuesMatrix.A[i2][0]));
                this.adjPValues.add(new Float(adjPValuesMatrix.A[i2][0]));
            }
            for (i2 = 0; i2 < fValuesMatrix.getRowDimension(); ++i2) {
                this.fValues.add(new Float(fValuesMatrix.A[i2][0]));
            }
            this.dfNumValues = new Vector();
            this.dfDenomValues = new Vector();
            for (i2 = 0; i2 < dfNumMatrix.getRowDimension(); ++i2) {
                this.dfNumValues.add(new Float(dfNumMatrix.A[i2][0]));
                this.dfDenomValues.add(new Float(dfDenomMatrix.A[i2][0]));
                this.ssGroups.add(new Float(ssGroupsMatrix.A[i2][0]));
                this.ssError.add(new Float(ssErrorMatrix.A[i2][0]));
            }
            GeneralInfo info = new GeneralInfo();
            info.time = time;
            info.alpha = alpha;
            info.usePerms = usePerms;
            info.numPerms = numPerms;
            info.correctionMethod = this.getSigMethod(this.correctionMethod);
            info.function = menu.getFunctionName(function);
            info.hcl = isHierarchicalTree;
            info.hcl_genes = hcl_genes;
            info.hcl_samples = hcl_samples;
            info.hcl_method = hcl_method;
            Vector<String> titlesVector = new Vector<String>();
            for (i = 0; i < this.geneGroupMeans[0].length; ++i) {
                titlesVector.add("Group" + (i + 1) + " mean");
                titlesVector.add("Group" + (i + 1) + " std.dev");
            }
            titlesVector.add("F ratio");
            titlesVector.add("SS(Groups)");
            titlesVector.add("SS(Error)");
            titlesVector.add("df (Groups)");
            titlesVector.add("df (Error)");
            titlesVector.add("Raw p value");
            if (this.correctionMethod != 12 && this.correctionMethod != 13) {
                titlesVector.add("Adj. p value");
            }
            this.auxTitles = new String[titlesVector.size()];
            for (i = 0; i < this.auxTitles.length; ++i) {
                this.auxTitles[i] = (String)titlesVector.get(i);
            }
            this.auxData = new Object[this.experiment.getNumberOfGenes()][this.auxTitles.length];
            for (i = 0; i < this.auxData.length; ++i) {
                int counter = 0;
                for (int j = 0; j < this.geneGroupMeans[i].length; ++j) {
                    this.auxData[i][counter++] = new Float(this.geneGroupMeans[i][j]);
                    this.auxData[i][counter++] = new Float(this.geneGroupSDs[i][j]);
                }
                this.auxData[i][counter++] = this.fValues.get(i);
                this.auxData[i][counter++] = this.ssGroups.get(i);
                this.auxData[i][counter++] = this.ssError.get(i);
                this.auxData[i][counter++] = this.dfNumValues.get(i);
                this.auxData[i][counter++] = this.dfDenomValues.get(i);
                this.auxData[i][counter++] = this.rawPValues.get(i);
                if (this.correctionMethod == 12 || this.correctionMethod == 13) continue;
                this.auxData[i][counter++] = this.adjPValues.get(i);
            }
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(result_cluster, info);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
        }
    }

    public AlgorithmData getScriptParameters(IFramework framework) {
        IDistanceMenu menu;
        int function;
        this.experiment = framework.getData().getExperiment();
        this.exptNamesVector = new Vector();
        int number_of_samples = this.experiment.getNumberOfSamples();
        int number_of_genes = this.experiment.getNumberOfGenes();
        for (int i = 0; i < number_of_samples; ++i) {
            this.exptNamesVector.add(framework.getData().getFullSampleName(this.experiment.getSampleIndex(i)));
        }
        OneWayANOVAInitBox owaDialog = new OneWayANOVAInitBox((JFrame)framework.getFrame(), true, this.exptNamesVector, framework.getClusterRepository(1));
        owaDialog.setVisible(true);
        if (!owaDialog.isOkPressed()) {
            return null;
        }
        double alpha = owaDialog.getPValue();
        this.numGroups = owaDialog.getNumGroups();
        if (owaDialog.getTestDesign() == 15) {
            this.groupAssignments = owaDialog.getClusterGroupAssignments();
        }
        if (owaDialog.getTestDesign() == 14) {
            this.groupAssignments = owaDialog.getGroupAssignments();
        }
        if (this.groupAssignments == null) {
            return null;
        }
        boolean usePerms = owaDialog.usePerms();
        int numPerms = 0;
        if (usePerms) {
            numPerms = owaDialog.getNumPerms();
        }
        this.correctionMethod = owaDialog.getCorrectionMethod();
        if (this.correctionMethod == 12) {
            this.falseNum = owaDialog.getFalseNum();
        }
        if (this.correctionMethod == 13) {
            this.falseProp = owaDialog.getFalseProp();
        }
        boolean isHierarchicalTree = owaDialog.drawTrees();
        this.drawSigTreesOnly = true;
        if (isHierarchicalTree) {
            this.drawSigTreesOnly = owaDialog.drawSigTreesOnly();
        }
        if ((function = (menu = framework.getDistanceMenu()).getDistanceFunction()) == 0) {
            function = 1;
        }
        int hcl_method = 0;
        boolean hcl_samples = false;
        boolean hcl_genes = false;
        int hcl_function = 4;
        boolean hcl_absolute = false;
        if (isHierarchicalTree) {
            HCLInitDialog hcl_dialog = new HCLInitDialog(framework.getFrame(), menu.getFunctionName(function), menu.isAbsoluteDistance(), true);
            if (hcl_dialog.showModal() != 0) {
                return null;
            }
            hcl_method = hcl_dialog.getMethod();
            hcl_samples = hcl_dialog.isClusterExperiments();
            hcl_genes = hcl_dialog.isClusterGenes();
            hcl_function = hcl_dialog.getDistanceMetric();
            hcl_absolute = hcl_dialog.getAbsoluteSelection();
        }
        AlgorithmData data = new AlgorithmData();
        data.addParam("distance-factor", String.valueOf(1.0f));
        data.addParam("distance-absolute", String.valueOf(menu.isAbsoluteDistance()));
        data.addParam("distance-function", String.valueOf(function));
        data.addIntArray("group-assignments", this.groupAssignments);
        data.addParam("usePerms", String.valueOf(usePerms));
        data.addParam("numPerms", String.valueOf(numPerms));
        data.addParam("alpha", String.valueOf(alpha));
        data.addParam("correction-method", String.valueOf(this.correctionMethod));
        data.addParam("numGroups", String.valueOf(this.numGroups));
        if (this.correctionMethod == 12) {
            data.addParam("falseNum", String.valueOf(this.falseNum));
        }
        if (this.correctionMethod == 13) {
            data.addParam("falseProp", String.valueOf((float)this.falseProp));
        }
        if (isHierarchicalTree) {
            data.addParam("hierarchical-tree", String.valueOf(true));
            data.addParam("draw-sig-trees-only", String.valueOf(this.drawSigTreesOnly));
            data.addParam("method-linkage", String.valueOf(hcl_method));
            data.addParam("calculate-genes", String.valueOf(hcl_genes));
            data.addParam("calculate-experiments", String.valueOf(hcl_samples));
            data.addParam("hcl-distance-function", String.valueOf(hcl_function));
            data.addParam("hcl-distance-absolute", String.valueOf(hcl_absolute));
        }
        data.addParam("name", "ANOVA");
        data.addParam("alg-type", "cluster-genes");
        data.addParam("output-class", "partition-output");
        String[] outputNodes = new String[]{"Significant Genes", "Non-significant Genes"};
        data.addStringArray("output-nodes", outputNodes);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode executeScript(IFramework framework, AlgorithmData algData, Experiment experiment) throws AlgorithmException {
        Listener listener = new Listener();
        this.experiment = experiment;
        this.data = framework.getData();
        this.groupAssignments = algData.getIntArray("group-assignments");
        this.correctionMethod = algData.getParams().getInt("correction-method");
        if (this.correctionMethod == 12) {
            this.falseNum = algData.getParams().getInt("falseNum");
        }
        if (this.correctionMethod == 13) {
            this.falseProp = algData.getParams().getFloat("falseProp");
        }
        this.drawSigTreesOnly = algData.getParams().getBoolean("draw-sig-trees-only");
        this.rawPValues = new Vector();
        this.adjPValues = new Vector();
        this.exptNamesVector = new Vector();
        int number_of_samples = experiment.getNumberOfSamples();
        for (int i = 0; i < number_of_samples; ++i) {
            this.exptNamesVector.add(this.data.getFullSampleName(i));
        }
        try {
            int i;
            int i2;
            algData.addMatrix("experiment", experiment.getMatrix());
            this.algorithm = framework.getAlgorithmFactory().getAlgorithm("OWA");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            this.progress = new Progress(framework.getFrame(), "Finding significant genes", listener);
            this.progress.show();
            long start = System.currentTimeMillis();
            AlgorithmData result = this.algorithm.execute(algData);
            long time = System.currentTimeMillis() - start;
            Cluster result_cluster = result.getCluster("cluster");
            NodeList nodeList = result_cluster.getNodeList();
            AlgorithmParameters resultMap = result.getParams();
            int k = 2;
            this.clusters = new int[k][];
            for (int i3 = 0; i3 < k; ++i3) {
                this.clusters[i3] = nodeList.getNode(i3).getFeaturesIndexes();
            }
            this.means = result.getMatrix("clusters_means");
            this.variances = result.getMatrix("clusters_variances");
            FloatMatrix rawPValuesMatrix = result.getMatrix("rawPValues");
            FloatMatrix adjPValuesMatrix = result.getMatrix("adjPValues");
            FloatMatrix fValuesMatrix = result.getMatrix("fValues");
            FloatMatrix dfNumMatrix = result.getMatrix("dfNumMatrix");
            FloatMatrix dfDenomMatrix = result.getMatrix("dfDenomMatrix");
            FloatMatrix ssGroupsMatrix = result.getMatrix("ssGroupsMatrix");
            FloatMatrix ssErrorMatrix = result.getMatrix("ssErrorMatrix");
            FloatMatrix geneGroupMeansMatrix = result.getMatrix("geneGroupMeansMatrix");
            FloatMatrix geneGroupSDsMatrix = result.getMatrix("geneGroupSDsMatrix");
            this.fValues = new Vector();
            this.ssGroups = new Vector();
            this.ssError = new Vector();
            this.geneGroupMeans = new float[geneGroupMeansMatrix.getRowDimension()][geneGroupMeansMatrix.getColumnDimension()];
            this.geneGroupSDs = new float[geneGroupSDsMatrix.getRowDimension()][geneGroupSDsMatrix.getColumnDimension()];
            for (i2 = 0; i2 < this.geneGroupMeans.length; ++i2) {
                for (int j = 0; j < this.geneGroupMeans[i2].length; ++j) {
                    this.geneGroupMeans[i2][j] = geneGroupMeansMatrix.A[i2][j];
                    this.geneGroupSDs[i2][j] = geneGroupSDsMatrix.A[i2][j];
                }
            }
            for (i2 = 0; i2 < rawPValuesMatrix.getRowDimension(); ++i2) {
                this.rawPValues.add(new Float(rawPValuesMatrix.A[i2][0]));
                this.adjPValues.add(new Float(adjPValuesMatrix.A[i2][0]));
            }
            for (i2 = 0; i2 < fValuesMatrix.getRowDimension(); ++i2) {
                this.fValues.add(new Float(fValuesMatrix.A[i2][0]));
            }
            this.dfNumValues = new Vector();
            this.dfDenomValues = new Vector();
            for (i2 = 0; i2 < dfNumMatrix.getRowDimension(); ++i2) {
                this.dfNumValues.add(new Float(dfNumMatrix.A[i2][0]));
                this.dfDenomValues.add(new Float(dfDenomMatrix.A[i2][0]));
                this.ssGroups.add(new Float(ssGroupsMatrix.A[i2][0]));
                this.ssError.add(new Float(ssErrorMatrix.A[i2][0]));
            }
            AlgorithmParameters params = algData.getParams();
            GeneralInfo info = new GeneralInfo();
            info.time = time;
            info.alpha = params.getFloat("alpha");
            this.numGroups = params.getInt("numGroups");
            info.correctionMethod = this.getSigMethod(params.getInt("correction-method"));
            info.usePerms = params.getBoolean("usePerms");
            info.numPerms = params.getInt("numPerms");
            info.function = framework.getDistanceMenu().getFunctionName(params.getInt("distance-function"));
            info.hcl = params.getBoolean("hierarchical-tree");
            info.hcl_genes = params.getBoolean("calculate-genes");
            info.hcl_samples = params.getBoolean("calculate-experiments");
            if (info.hcl) {
                info.hcl_method = params.getInt("method-linkage");
            }
            Vector<String> titlesVector = new Vector<String>();
            for (i = 0; i < this.geneGroupMeans[0].length; ++i) {
                titlesVector.add("Group" + (i + 1) + " mean");
                titlesVector.add("Group" + (i + 1) + " std.dev");
            }
            titlesVector.add("F ratio");
            titlesVector.add("SS(Groups)");
            titlesVector.add("SS(Error)");
            titlesVector.add("df (Groups)");
            titlesVector.add("df (Error)");
            titlesVector.add("Raw p value");
            if (this.correctionMethod != 12 && this.correctionMethod != 13) {
                titlesVector.add("Adj. p value");
            }
            this.auxTitles = new String[titlesVector.size()];
            for (i = 0; i < this.auxTitles.length; ++i) {
                this.auxTitles[i] = (String)titlesVector.get(i);
            }
            this.auxData = new Object[experiment.getNumberOfGenes()][this.auxTitles.length];
            for (i = 0; i < this.auxData.length; ++i) {
                int counter = 0;
                for (int j = 0; j < this.geneGroupMeans[i].length; ++j) {
                    this.auxData[i][counter++] = new Float(this.geneGroupMeans[i][j]);
                    this.auxData[i][counter++] = new Float(this.geneGroupSDs[i][j]);
                }
                this.auxData[i][counter++] = this.fValues.get(i);
                this.auxData[i][counter++] = this.ssGroups.get(i);
                this.auxData[i][counter++] = this.ssError.get(i);
                this.auxData[i][counter++] = this.dfNumValues.get(i);
                this.auxData[i][counter++] = this.dfDenomValues.get(i);
                this.auxData[i][counter++] = this.rawPValues.get(i);
                if (this.correctionMethod == 12 || this.correctionMethod == 13) continue;
                this.auxData[i][counter++] = this.adjPValues.get(i);
            }
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(result_cluster, info);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
        }
    }

    protected String getSigMethod(int sigMethod) {
        String methodName = "";
        if (sigMethod == 1) {
            methodName = "Just alpha (uncorrected)";
        } else if (sigMethod == 2) {
            methodName = "Standard Bonferroni correction";
        } else if (sigMethod == 3) {
            methodName = "Adjusted Bonferroni correction";
        } else if (sigMethod == 9) {
            methodName = "Westfall Young stepdown - MaxT";
        } else if (sigMethod == 12) {
            methodName = "False significant number: " + this.falseNum + " or less";
        } else if (sigMethod == 13) {
            methodName = "False significant proportion: " + this.falseProp + " or less";
        }
        return methodName;
    }

    protected DefaultMutableTreeNode createResultTree(Cluster result_cluster, GeneralInfo info) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("One-way ANOVA");
        this.addResultNodes(root, result_cluster, info);
        return root;
    }

    protected void addResultNodes(DefaultMutableTreeNode root, Cluster result_cluster, GeneralInfo info) {
        this.addExpressionImages(root);
        this.addHierarchicalTrees(root, result_cluster, info);
        this.addCentroidViews(root);
        this.addTableViews(root);
        this.addClusterInfo(root);
        this.addGeneralInfo(root, info);
    }

    protected void addTableViews(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Table Views");
        ClusterTableViewer tabViewer = new ClusterTableViewer(this.experiment, this.clusters, this.data, this.auxTitles, this.auxData);
        for (int i = 0; i < this.clusters.length; ++i) {
            if (i < this.clusters.length - 1) {
                node.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes ", (IViewer)tabViewer, (Object)new Integer(i))));
                continue;
            }
            if (i != this.clusters.length - 1) continue;
            node.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", (IViewer)tabViewer, (Object)new Integer(i))));
        }
        root.add(node);
    }

    protected void addExpressionImages(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Expression Images");
        OWAExperimentViewer expViewer = new OWAExperimentViewer(this.experiment, this.clusters, this.geneGroupMeans, this.geneGroupSDs, this.rawPValues, this.adjPValues, this.fValues, this.ssGroups, this.ssError, this.dfNumValues, this.dfDenomValues);
        for (int i = 0; i < this.clusters.length; ++i) {
            if (i < this.clusters.length - 1) {
                node.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes ", (IViewer)expViewer, (Object)new Integer(i))));
                continue;
            }
            if (i != this.clusters.length - 1) continue;
            node.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", (IViewer)expViewer, (Object)new Integer(i))));
        }
        root.add(node);
    }

    protected void addHierarchicalTrees(DefaultMutableTreeNode root, Cluster result_cluster, GeneralInfo info) {
        if (!info.hcl) {
            return;
        }
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Hierarchical Trees");
        NodeList nodeList = result_cluster.getNodeList();
        if (!this.drawSigTreesOnly) {
            for (int i = 0; i < nodeList.getSize(); ++i) {
                if (i < nodeList.getSize() - 1) {
                    node.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes ", this.createHCLViewer(nodeList.getNode(i), info))));
                    continue;
                }
                if (i != nodeList.getSize() - 1) continue;
                node.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", this.createHCLViewer(nodeList.getNode(i), info))));
            }
        } else {
            node.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes ", this.createHCLViewer(nodeList.getNode(0), info))));
        }
        root.add(node);
    }

    protected IViewer createHCLViewer(Node clusterNode, GeneralInfo info) {
        HCLTreeData genes_result;
        HCLTreeData hCLTreeData = genes_result = info.hcl_genes ? this.getResult(clusterNode, 0) : null;
        HCLTreeData samples_result = info.hcl_samples ? this.getResult(clusterNode, info.hcl_genes ? 4 : 0) : null;
        return new HCLViewer(this.experiment, clusterNode.getFeaturesIndexes(), genes_result, samples_result);
    }

    protected HCLTreeData getResult(Node clusterNode, int pos) {
        HCLTreeData data = new HCLTreeData();
        NodeValueList valueList = clusterNode.getValues();
        data.child_1_array = (int[])valueList.getNodeValue((int)pos).value;
        data.child_2_array = (int[])valueList.getNodeValue((int)(pos + 1)).value;
        data.node_order = (int[])valueList.getNodeValue((int)(pos + 2)).value;
        data.height = (float[])valueList.getNodeValue((int)(pos + 3)).value;
        return data;
    }

    protected void addClusterInfo(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Cluster Information");
        node.add(new DefaultMutableTreeNode(new LeafInfo("Results (#,%)", (IViewer)new OWAInfoViewer(this.clusters, this.experiment.getNumberOfGenes()))));
        root.add(node);
    }

    protected void addCentroidViews(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode centroidNode = new DefaultMutableTreeNode("Centroid Graphs");
        DefaultMutableTreeNode expressionNode = new DefaultMutableTreeNode("Expression Graphs");
        OWACentroidViewer centroidViewer = new OWACentroidViewer(this.experiment, this.clusters, this.geneGroupMeans, this.geneGroupSDs, this.rawPValues, this.adjPValues, this.fValues, this.ssGroups, this.ssError, this.dfNumValues, this.dfDenomValues);
        centroidViewer.setMeans(this.means.A);
        centroidViewer.setVariances(this.variances.A);
        for (int i = 0; i < this.clusters.length; ++i) {
            if (i == 0) {
                centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes ", (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 0))));
                expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes ", (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 1))));
                continue;
            }
            if (i != 1) continue;
            centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 0))));
            expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 1))));
        }
        OWACentroidsViewer centroidsViewer = new OWACentroidsViewer(this.experiment, this.clusters, this.geneGroupMeans, this.geneGroupSDs, this.rawPValues, this.adjPValues, this.fValues, this.ssGroups, this.ssError, this.dfNumValues, this.dfDenomValues);
        centroidsViewer.setMeans(this.means.A);
        centroidsViewer.setVariances(this.variances.A);
        centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("All Genes", (IViewer)centroidsViewer, (Object)new Integer(0))));
        expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("All Genes", (IViewer)centroidsViewer, (Object)new Integer(1))));
        root.add(centroidNode);
        root.add(expressionNode);
    }

    protected void addGeneralInfo(DefaultMutableTreeNode root, GeneralInfo info) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("General Information");
        node.add(this.getGroupAssignmentInfo());
        if (info.correctionMethod.startsWith("False")) {
            node.add(new DefaultMutableTreeNode("Confidence (1 - alpha) : " + (1.0 - info.alpha) * 100.0 + " %"));
        } else {
            node.add(new DefaultMutableTreeNode("Alpha (overall threshold p-value): " + info.alpha));
        }
        node.add(new DefaultMutableTreeNode("Used permutation test? " + info.usePerms));
        if (info.usePerms) {
            node.add(new DefaultMutableTreeNode("Number of permutations " + info.numPerms));
        }
        if (info.correctionMethod.startsWith("False")) {
            node.add(new DefaultMutableTreeNode(info.correctionMethod));
        } else {
            node.add(new DefaultMutableTreeNode("Significance determined by: " + info.correctionMethod));
        }
        node.add(new DefaultMutableTreeNode("HCL: " + info.getMethodName()));
        node.add(new DefaultMutableTreeNode("Time: " + String.valueOf(info.time) + " ms"));
        node.add(new DefaultMutableTreeNode(info.function));
        root.add(node);
    }

    protected DefaultMutableTreeNode getGroupAssignmentInfo() {
        int i;
        DefaultMutableTreeNode groupAssignmentInfo = new DefaultMutableTreeNode("Group assignments ");
        DefaultMutableTreeNode notInGroups = new DefaultMutableTreeNode("Not in groups");
        DefaultMutableTreeNode[] groups = new DefaultMutableTreeNode[this.numGroups];
        for (i = 0; i < this.numGroups; ++i) {
            groups[i] = new DefaultMutableTreeNode("Group " + (i + 1));
        }
        for (i = 0; i < this.groupAssignments.length; ++i) {
            int currentGroup = this.groupAssignments[i];
            if (currentGroup == 0) {
                notInGroups.add(new DefaultMutableTreeNode((String)this.exptNamesVector.get(i)));
                continue;
            }
            groups[currentGroup - 1].add(new DefaultMutableTreeNode((String)this.exptNamesVector.get(i)));
        }
        for (i = 0; i < groups.length; ++i) {
            groupAssignmentInfo.add(groups[i]);
        }
        if (notInGroups.getChildCount() > 0) {
            groupAssignmentInfo.add(notInGroups);
        }
        return groupAssignmentInfo;
    }

    protected class GeneralInfo {
        public int clusters;
        public String correctionMethod;
        public double alpha;
        public long time;
        public String function;
        protected boolean hcl;
        protected boolean usePerms;
        protected int hcl_method;
        protected int numPerms;
        protected boolean hcl_genes;
        protected boolean hcl_samples;

        protected GeneralInfo() {
        }

        public String getMethodName() {
            return this.hcl ? HCLGUI.GeneralInfo.getMethodName(this.hcl_method) : "no linkage";
        }
    }

    protected class Listener
    extends DialogListener
    implements AlgorithmListener {
        protected Listener() {
        }

        public void valueChanged(AlgorithmEvent event) {
            switch (event.getId()) {
                case 1: {
                    OWAGUI.this.progress.setUnits(event.getIntValue());
                    OWAGUI.this.progress.setDescription(event.getDescription());
                    break;
                }
                case 2: {
                    OWAGUI.this.progress.setValue(event.getIntValue());
                    OWAGUI.this.progress.setDescription(event.getDescription());
                    break;
                }
                case 3: {
                    int value = event.getIntValue();
                    if (value != -1) break;
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("cancel-command")) {
                OWAGUI.this.algorithm.abort();
                OWAGUI.this.progress.dispose();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            OWAGUI.this.algorithm.abort();
            OWAGUI.this.progress.dispose();
        }
    }
}

