/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.owa;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;
import org.tigr.util.QSort;

public class FStatsTableViewer
extends ViewerAdapter
implements Serializable {
    public static final long serialVersionUID = 202010010001L;
    private JComponent header;
    private JComponent content;
    private Experiment experiment;
    private int[][] clusters;
    private boolean sig;
    private int[] rows;
    private String[] fieldNames;
    private FValuesTableModel fModel;
    private JTable fValuesTable;
    private Vector pValues;
    private Vector fValues;
    private Vector dfNumValues;
    private Vector dfDenomValues;
    private Vector ssGroups;
    private Vector ssError;
    private float[][] geneGroupMeans;
    private float[][] geneGroupSDs;
    private IData data;
    private JPopupMenu popup;
    private Object[][] origData;
    private int univCnt;
    private int univCnt2;
    private int univCnt3;
    private boolean[] sortedAscending;

    public FStatsTableViewer(Experiment experiment, int[][] clusters, IData data, float[][] geneGroupMeans, float[][] geneGroupSDs, Vector pValues, Vector fValues, Vector ssGroups, Vector ssError, Vector dfNumValues, Vector dfDenomValues, boolean sig) {
        int i;
        this.experiment = experiment;
        this.clusters = clusters;
        this.data = data;
        this.fieldNames = data.getFieldNames();
        this.geneGroupMeans = geneGroupMeans;
        this.geneGroupSDs = geneGroupSDs;
        this.pValues = pValues;
        this.fValues = fValues;
        this.ssGroups = ssGroups;
        this.ssError = ssError;
        this.dfNumValues = dfNumValues;
        this.dfDenomValues = dfDenomValues;
        this.sig = sig;
        this.rows = sig ? clusters[0] : clusters[1];
        this.fModel = new FValuesTableModel();
        this.fValuesTable = new JTable(this.fModel);
        this.origData = new Object[this.fModel.getRowCount()][this.fModel.getColumnCount()];
        for (i = 0; i < this.origData.length; ++i) {
            for (int j = 0; j < this.origData[i].length; ++j) {
                this.origData[i][j] = this.fModel.getValueAt(i, j);
            }
        }
        this.sortedAscending = new boolean[this.fModel.getColumnCount()];
        for (i = 0; i < this.sortedAscending.length; ++i) {
            this.sortedAscending[i] = false;
        }
        TableColumn column = null;
        for (int i2 = 0; i2 < this.fModel.getColumnCount(); ++i2) {
            column = this.fValuesTable.getColumnModel().getColumn(i2);
            column.setMinWidth(30);
        }
        this.addMouseListenerToHeaderInTable(this.fValuesTable);
        this.header = this.fValuesTable.getTableHeader();
        this.setMaxWidth(this.getContentComponent(), this.getHeaderComponent());
    }

    public FStatsTableViewer(JComponent content, JComponent header) {
        this.content = content;
        this.header = header;
        this.setMaxWidth(this.getContentComponent(), this.getHeaderComponent());
    }

    @Override
    public JComponent getContentComponent() {
        JPanel panel = new JPanel();
        panel.setBackground(Color.white);
        GridBagConstraints constraints = new GridBagConstraints();
        GridBagLayout gridbag = new GridBagLayout();
        panel.setLayout(gridbag);
        constraints.fill = 2;
        constraints.anchor = 11;
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 100);
        gridbag.setConstraints(this.fValuesTable, constraints);
        panel.add(this.fValuesTable);
        final JFileChooser fc = new JFileChooser(TMEV.getDataPath());
        fc.setDialogTitle("Save F-Ratio information");
        this.popup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Save F-Ratio information", GUIFactory.getIcon("save16.gif"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int returnVal = fc.showSaveDialog(FStatsTableViewer.this.getHeaderComponent());
                if (returnVal == 0) {
                    File file = fc.getSelectedFile();
                    try {
                        int i;
                        PrintWriter out = new PrintWriter(new FileOutputStream(file));
                        for (i = 0; i < FStatsTableViewer.this.fieldNames.length; ++i) {
                            out.print(FStatsTableViewer.this.fieldNames[i]);
                            out.print("\t");
                        }
                        for (i = 0; i < FStatsTableViewer.this.geneGroupMeans[0].length; ++i) {
                            out.print("Group" + (i + 1) + " mean\t");
                            out.print("Group" + (i + 1) + " std.dev.\t");
                        }
                        out.print("F-ratio\tSS(Groups)\tSS(Error)\tdf(Groups)\tdf(Error)\tp-value\n");
                        for (i = 0; i < FStatsTableViewer.this.rows.length; ++i) {
                            for (int k = 0; k < FStatsTableViewer.this.fieldNames.length; ++k) {
                                out.print(FStatsTableViewer.this.data.getElementAttribute(FStatsTableViewer.this.experiment.getGeneIndexMappedToData(FStatsTableViewer.this.rows[i]), k));
                                out.print("\t");
                            }
                            for (int j = 0; j < FStatsTableViewer.this.geneGroupMeans[i].length; ++j) {
                                out.print(FStatsTableViewer.this.geneGroupMeans[FStatsTableViewer.this.rows[i]][j] + "\t");
                                out.print(FStatsTableViewer.this.geneGroupSDs[FStatsTableViewer.this.rows[i]][j] + "\t");
                            }
                            out.print(((Float)FStatsTableViewer.this.fValues.get(FStatsTableViewer.this.rows[i])).floatValue());
                            out.print("\t" + ((Float)FStatsTableViewer.this.ssGroups.get(FStatsTableViewer.this.rows[i])).floatValue());
                            out.print("\t" + ((Float)FStatsTableViewer.this.ssError.get(FStatsTableViewer.this.rows[i])).floatValue());
                            out.print("\t" + ((Float)FStatsTableViewer.this.dfNumValues.get(FStatsTableViewer.this.rows[i])).intValue());
                            out.print("\t" + ((Float)FStatsTableViewer.this.dfDenomValues.get(FStatsTableViewer.this.rows[i])).intValue());
                            out.print("\t" + ((Float)FStatsTableViewer.this.pValues.get(FStatsTableViewer.this.rows[i])).floatValue());
                            out.print("\n");
                        }
                        out.println();
                        out.flush();
                        out.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        });
        this.popup.add(menuItem);
        this.fValuesTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    FStatsTableViewer.this.popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        return panel;
    }

    @Override
    public JComponent getHeaderComponent() {
        JPanel panel = new JPanel();
        panel.setBackground(Color.white);
        GridBagConstraints constraints = new GridBagConstraints();
        GridBagLayout gridbag = new GridBagLayout();
        panel.setLayout(gridbag);
        constraints.fill = 2;
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 100);
        gridbag.setConstraints(this.header, constraints);
        panel.add(this.header);
        return panel;
    }

    void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    private void setMaxWidth(JComponent content, JComponent header) {
        int c_width = content.getPreferredSize().width;
        int h_width = header.getPreferredSize().width;
        if (c_width > h_width) {
            header.setPreferredSize(new Dimension(c_width, header.getPreferredSize().height));
        } else {
            content.setPreferredSize(new Dimension(h_width, content.getPreferredSize().height));
        }
    }

    public void addMouseListenerToHeaderInTable(JTable table) {
        final JTable tableView = table;
        tableView.setColumnSelectionAllowed(false);
        MouseAdapter listMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = tableView.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = tableView.convertColumnIndexToModel(viewColumn);
                if (e.getClickCount() == 1 && column != -1) {
                    int shiftPressed = e.getModifiers() & 1;
                    int controlPressed = e.getModifiers() & 2;
                    boolean originalOrder = controlPressed != 0;
                    FStatsTableViewer.this.sortByColumn(column, !FStatsTableViewer.this.sortedAscending[column], originalOrder);
                    boolean bl = ((FStatsTableViewer)FStatsTableViewer.this).sortedAscending[column] = !FStatsTableViewer.this.sortedAscending[column];
                    if (originalOrder) {
                        for (int i = 0; i < FStatsTableViewer.this.fModel.getColumnCount(); ++i) {
                            ((FStatsTableViewer)FStatsTableViewer.this).sortedAscending[i] = false;
                        }
                    }
                }
            }
        };
        JTableHeader th = tableView.getTableHeader();
        th.addMouseListener(listMouseListener);
    }

    public void sortByColumn(int column, boolean ascending, boolean originalOrder) {
        int j;
        int i;
        int i2;
        if (originalOrder) {
            for (int i3 = 0; i3 < this.fModel.getRowCount(); ++i3) {
                for (int j2 = 0; j2 < this.fModel.getColumnCount(); ++j2) {
                    this.fModel.setValueAt(this.origData[i3][j2], i3, j2);
                }
            }
            return;
        }
        Object[][] sortedData = new Object[this.fValuesTable.getRowCount()][this.fValuesTable.getColumnCount()];
        float[] origArray = new float[this.rows.length];
        Object[] sortFields = new SortableField[this.rows.length];
        if (column < this.fieldNames.length) {
            for (i2 = 0; i2 < sortFields.length; ++i2) {
                sortFields[i2] = new SortableField(i2, column);
            }
            Arrays.sort(sortFields);
        } else if (column == this.univCnt3) {
            for (i2 = 0; i2 < origArray.length; ++i2) {
                origArray[i2] = ((Float)this.fValues.get(this.rows[i2])).floatValue();
            }
        } else if (column == this.univCnt3 + 1) {
            for (i2 = 0; i2 < origArray.length; ++i2) {
                origArray[i2] = ((Float)this.ssGroups.get(this.rows[i2])).floatValue();
            }
        } else if (column == this.univCnt3 + 2) {
            for (i2 = 0; i2 < origArray.length; ++i2) {
                origArray[i2] = ((Float)this.ssError.get(this.rows[i2])).floatValue();
            }
        } else if (column == this.univCnt3 + 3) {
            for (i2 = 0; i2 < origArray.length; ++i2) {
                origArray[i2] = ((Float)this.dfNumValues.get(this.rows[i2])).floatValue();
            }
        } else if (column == this.univCnt3 + 4) {
            for (i2 = 0; i2 < origArray.length; ++i2) {
                origArray[i2] = ((Float)this.dfDenomValues.get(this.rows[i2])).floatValue();
            }
        } else if (column == this.univCnt3 + 5) {
            for (i2 = 0; i2 < origArray.length; ++i2) {
                origArray[i2] = ((Float)this.pValues.get(this.rows[i2])).floatValue();
            }
        } else {
            int i4;
            int currentIndex = column - this.fieldNames.length;
            int newIndex = 0;
            if (currentIndex % 2 == 0) {
                newIndex = currentIndex / 2;
                for (i4 = 0; i4 < origArray.length; ++i4) {
                    origArray[i4] = this.geneGroupMeans[this.rows[i4]][newIndex];
                }
            } else {
                newIndex = (currentIndex - 1) / 2;
                for (i4 = 0; i4 < origArray.length; ++i4) {
                    origArray[i4] = this.geneGroupSDs[this.rows[i4]][newIndex];
                }
            }
        }
        int[] sortedIndices = new int[this.rows.length];
        if (column >= this.fieldNames.length) {
            QSort sortArray = new QSort(origArray);
            sortedIndices = sortArray.getOrigIndx();
        } else {
            for (int i5 = 0; i5 < sortedIndices.length; ++i5) {
                sortedIndices[i5] = ((SortableField)sortFields[i5]).getIndex();
            }
        }
        if (!ascending) {
            sortedIndices = this.reverse(sortedIndices);
        }
        for (i = 0; i < sortedData.length; ++i) {
            for (j = 0; j < sortedData[i].length; ++j) {
                sortedData[i][j] = this.origData[sortedIndices[i]][j];
            }
        }
        for (i = 0; i < sortedData.length; ++i) {
            for (j = 0; j < sortedData[i].length; ++j) {
                this.fModel.setValueAt(sortedData[i][j], i, j);
            }
        }
    }

    private int[] reverse(int[] arr) {
        int[] revArr = new int[arr.length];
        int revCount = 0;
        int count = arr.length - 1;
        for (int i = 0; i < arr.length; ++i) {
            revArr[revCount] = arr[count];
            ++revCount;
            --count;
        }
        return revArr;
    }

    private class SortableField
    implements Comparable {
        private String field;
        private int index;

        SortableField(int index, int column) {
            this.index = index;
            this.field = (String)FStatsTableViewer.this.origData[index][column];
        }

        public int compareTo(Object other) {
            SortableField otherField = (SortableField)other;
            return this.field.compareTo(otherField.getField());
        }

        public int getIndex() {
            return this.index;
        }

        public String getField() {
            return this.field;
        }
    }

    class FValuesTableModel
    extends AbstractTableModel {
        String[] columnNames;
        Object[][] tableData;

        public FValuesTableModel() {
            int j;
            int i;
            int counter2;
            int counter;
            this.columnNames = new String[FStatsTableViewer.this.fieldNames.length + 2 * FStatsTableViewer.this.geneGroupMeans[0].length + 6];
            for (counter = 0; counter < FStatsTableViewer.this.fieldNames.length; ++counter) {
                this.columnNames[counter] = FStatsTableViewer.this.fieldNames[counter];
            }
            FStatsTableViewer.this.univCnt = counter;
            int groupNum = 1;
            for (counter2 = 0; counter2 < 2 * FStatsTableViewer.this.geneGroupMeans[0].length; ++counter2) {
                this.columnNames[counter + counter2] = "Group" + groupNum + " mean";
                this.columnNames[counter + ++counter2] = "Group" + groupNum + " std.dev.";
                ++groupNum;
            }
            FStatsTableViewer.this.univCnt2 = counter2;
            int counter3 = counter + counter2;
            FStatsTableViewer.this.univCnt3 = counter3;
            this.columnNames[counter3] = "F-Ratio";
            this.columnNames[counter3 + 1] = "SS (Groups)";
            this.columnNames[counter3 + 2] = "SS (Error)";
            this.columnNames[counter3 + 3] = "df (Groups)";
            this.columnNames[counter3 + 4] = "df (Error)";
            this.columnNames[counter3 + 5] = "p-value";
            this.tableData = new Object[FStatsTableViewer.this.rows.length][this.columnNames.length];
            for (i = 0; i < this.tableData.length; ++i) {
                groupNum = 0;
                for (j = counter; j < counter3; ++j) {
                    this.tableData[i][j] = Float.isNaN(FStatsTableViewer.this.geneGroupMeans[FStatsTableViewer.this.rows[i]][groupNum]) ? "N/A" : new Float(FStatsTableViewer.this.geneGroupMeans[FStatsTableViewer.this.rows[i]][groupNum]);
                    this.tableData[i][++j] = Float.isNaN(FStatsTableViewer.this.geneGroupSDs[FStatsTableViewer.this.rows[i]][groupNum]) ? "N/A" : new Float(FStatsTableViewer.this.geneGroupSDs[FStatsTableViewer.this.rows[i]][groupNum]);
                    ++groupNum;
                }
            }
            for (i = 0; i < this.tableData.length; ++i) {
                for (j = 0; j < this.tableData[i].length; ++j) {
                    float f;
                    if (j < counter) {
                        this.tableData[i][j] = FStatsTableViewer.this.data.getElementAttribute(FStatsTableViewer.this.experiment.getGeneIndexMappedToData(FStatsTableViewer.this.rows[i]), j);
                        continue;
                    }
                    if (j >= counter && j < counter3) continue;
                    if (j == counter3) {
                        f = ((Float)FStatsTableViewer.this.fValues.get(FStatsTableViewer.this.rows[i])).floatValue();
                        if (Float.isNaN(f)) {
                            this.tableData[i][j] = "N/A";
                            continue;
                        }
                        this.tableData[i][j] = (Float)FStatsTableViewer.this.fValues.get(FStatsTableViewer.this.rows[i]);
                        continue;
                    }
                    if (j == counter3 + 1) {
                        f = ((Float)FStatsTableViewer.this.ssGroups.get(FStatsTableViewer.this.rows[i])).floatValue();
                        if (Float.isNaN(f)) {
                            this.tableData[i][j] = "N/A";
                            continue;
                        }
                        this.tableData[i][j] = (Float)FStatsTableViewer.this.ssGroups.get(FStatsTableViewer.this.rows[i]);
                        continue;
                    }
                    if (j == counter3 + 2) {
                        f = ((Float)FStatsTableViewer.this.ssError.get(FStatsTableViewer.this.rows[i])).floatValue();
                        if (Float.isNaN(f)) {
                            this.tableData[i][j] = "N/A";
                            continue;
                        }
                        this.tableData[i][j] = (Float)FStatsTableViewer.this.ssError.get(FStatsTableViewer.this.rows[i]);
                        continue;
                    }
                    if (j == counter3 + 3) {
                        f = ((Float)FStatsTableViewer.this.dfNumValues.get(FStatsTableViewer.this.rows[i])).floatValue();
                        if (Float.isNaN(f)) {
                            this.tableData[i][j] = "N/A";
                            continue;
                        }
                        this.tableData[i][j] = (Float)FStatsTableViewer.this.dfNumValues.get(FStatsTableViewer.this.rows[i]);
                        continue;
                    }
                    if (j == counter3 + 4) {
                        f = ((Float)FStatsTableViewer.this.dfDenomValues.get(FStatsTableViewer.this.rows[i])).floatValue();
                        if (Float.isNaN(f)) {
                            this.tableData[i][j] = "N/A";
                            continue;
                        }
                        this.tableData[i][j] = (Float)FStatsTableViewer.this.dfDenomValues.get(FStatsTableViewer.this.rows[i]);
                        continue;
                    }
                    if (j != counter3 + 5) continue;
                    f = ((Float)FStatsTableViewer.this.pValues.get(FStatsTableViewer.this.rows[i])).floatValue();
                    this.tableData[i][j] = Float.isNaN(f) ? "N/A" : (Float)FStatsTableViewer.this.pValues.get(FStatsTableViewer.this.rows[i]);
                }
            }
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.tableData.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.tableData[row][col];
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.tableData[row][col] = value;
            this.fireTableCellUpdated(row, col);
        }
    }
}

