/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.nonpar;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.IWizardParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.microarray.mev.cluster.gui.impl.nonpar.NonparConstants;

public class NonparWilcoxonPanel
extends JPanel
implements IWizardParameterPanel {
    private AlgorithmData algData;
    private JRadioButton pValueButton;
    private JRadioButton fdrButton;
    private JCheckBox fdrGraphBox;
    private JLabel alphaLabel;
    private JTextField alphaField;
    private JLabel fdrLimitLabel;
    private JTextField fdrField;
    private JCheckBox hclBox;
    private boolean supportFDR;
    private String WILCOXON_TITLE = "Wilcoxon, Mann-Whitney Test Parameters";
    private String KRUSKAL_WALLIS_TITLE = "Kruskal-Wallis Test Parameters";
    private String MACK_SKILLINGS_TITLE = "Mack-Skillings Test Parameters";
    private JDialog parent;

    public NonparWilcoxonPanel(AlgorithmData parameters, JDialog parent) {
        super(new GridBagLayout());
        this.parent = parent;
        this.supportFDR = true;
        this.algData = parameters;
    }

    public NonparWilcoxonPanel(String[] groupNames, int numX, int numY, String mode, JDialog parent) {
        super(new GridBagLayout());
        this.parent = parent;
        this.supportFDR = true;
        this.initializePanel(mode);
    }

    public void initializePanel(String mode) {
        this.removeAll();
        if (mode.equals(NonparConstants.MODE_MACK_SKILLINGS)) {
            this.supportFDR = false;
        }
        if (mode.equals(NonparConstants.MODE_WILCOXON_MANN_WHITNEY)) {
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), this.WILCOXON_TITLE));
        } else if (mode.equals(NonparConstants.MODE_KRUSKAL_WALLIS)) {
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), this.KRUSKAL_WALLIS_TITLE));
        } else if (mode.equals(NonparConstants.MODE_MACK_SKILLINGS)) {
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), this.MACK_SKILLINGS_TITLE));
        }
        Listener listener = new Listener();
        ButtonGroup bg = new ButtonGroup();
        this.pValueButton = new JRadioButton("Use p-value Significance Criterion", true);
        this.pValueButton.setIconTextGap(8);
        this.pValueButton.setFocusPainted(false);
        this.pValueButton.addActionListener(listener);
        bg.add(this.pValueButton);
        this.alphaLabel = new JLabel("Alpha, critcal p-value:");
        this.alphaField = new JTextField("0.05");
        this.alphaField.setPreferredSize(new Dimension(60, 20));
        this.hclBox = new JCheckBox("<html>Create Hierarchical Trees (on significant genes)</html>", false);
        this.hclBox.setFocusPainted(false);
        this.hclBox.setOpaque(false);
        this.hclBox.setIconTextGap(8);
        this.hclBox.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Hierarcical Clustering"));
        int infoY = 7;
        if (this.supportFDR) {
            this.fdrButton = new JRadioButton("<html>Use FDR Significance Criterion<br>(based on Benjamini-Hochberg Correction)</html>");
            this.fdrButton.setIconTextGap(8);
            this.fdrButton.setFocusPainted(false);
            this.fdrButton.addActionListener(listener);
            bg.add(this.fdrButton);
            this.fdrGraphBox = new JCheckBox("<html>Select FDR After Analysis<br><c>(interactive mode)</c></html>", true);
            this.fdrGraphBox.setIconTextGap(8);
            this.fdrGraphBox.setFocusPainted(false);
            this.fdrGraphBox.setEnabled(false);
            this.fdrGraphBox.addActionListener(listener);
            this.fdrLimitLabel = new JLabel("Selected FDR Limit: ");
            this.fdrField = new JTextField("0.05");
            this.fdrField.setPreferredSize(new Dimension(60, 20));
            this.fdrField.setEnabled(false);
            JSeparator sep = new JSeparator(0);
            sep.setPreferredSize(new Dimension(200, 2));
            this.add((Component)this.pValueButton, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 10, 10, 10), 0, 0));
            this.add((Component)this.alphaLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 13, 3, new Insets(0, 10, 10, 10), 0, 0));
            this.add((Component)this.alphaField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 3, new Insets(0, 0, 10, 10), 0, 0));
            this.add((Component)sep, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 1, new Insets(0, 20, 10, 20), 0, 0));
            this.add((Component)this.fdrButton, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 10, 5, 0), 0, 0));
            this.add((Component)this.fdrGraphBox, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 3, new Insets(0, 0, 10, 0), 0, 0));
            this.add((Component)this.fdrLimitLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 10, 10), 0, 0));
            this.add((Component)this.fdrField, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 17, 3, new Insets(0, 0, 10, 0), 0, 0));
            this.add((Component)this.hclBox, new GridBagConstraints(0, 6, 2, 1, 1.0, 0.0, 10, 2, new Insets(20, 10, 10, 10), 0, 0));
        } else {
            infoY = 3;
            this.add((Component)this.alphaLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 3, new Insets(0, 10, 10, 10), 0, 0));
            this.add((Component)this.alphaField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 3, new Insets(0, 0, 10, 10), 0, 0));
            this.add((Component)this.hclBox, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(20, 10, 10, 10), 0, 0));
        }
        JButton infoButton = new JButton(null, GUIFactory.getIcon("Information24.gif"));
        infoButton.setActionCommand("info-command");
        infoButton.setSize(30, 30);
        infoButton.setPreferredSize(new Dimension(30, 30));
        infoButton.setFocusPainted(false);
        Border border = BorderFactory.createBevelBorder(0);
        infoButton.setBorder(border);
        infoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                HelpWindow.launchBrowser(NonparWilcoxonPanel.this.parent, "NonpaR Significance Parameters");
            }
        });
        this.add((Component)infoButton, new GridBagConstraints(0, infoY, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 5, 5, 0), 0, 0));
    }

    @Override
    public void populateAlgorithmData() {
        this.algData.addParam("use-alpha-criterion", String.valueOf(this.pValueButton.isSelected()));
        if (this.pValueButton.isSelected()) {
            this.algData.addParam("alpha", this.alphaField.getText());
        } else {
            this.algData.addParam("use-fdr-graph", String.valueOf(this.fdrGraphBox.isSelected()));
            if (!this.fdrGraphBox.isSelected()) {
                this.algData.addParam("fdr", this.fdrField.getText());
            }
        }
        this.algData.addParam("hcl-execution", String.valueOf(this.runHCL()));
    }

    @Override
    public void clearValuesFromAlgorithmData() {
        this.algData.getParams().getMap().remove("use-alpha-criterion");
        this.algData.getParams().getMap().remove("alpha");
        this.algData.getParams().getMap().remove("use-fdr-graph");
        this.algData.getParams().getMap().remove("fdr");
        this.algData.getParams().getMap().remove("hcl-execution");
    }

    @Override
    public void onDisplayed() {
    }

    public boolean runHCL() {
        return this.hclBox.isSelected();
    }

    private long factorial(int n) {
        if (n == 1 || n == 0) {
            return 1L;
        }
        return this.factorial(n - 1) * (long)n;
    }

    private int getNumCombs(int n, int k) {
        return Math.round(this.factorial(n) / (this.factorial(k) * this.factorial(n - k)));
    }

    public class Listener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            NonparWilcoxonPanel.this.alphaField.setEnabled(NonparWilcoxonPanel.this.pValueButton.isSelected());
            NonparWilcoxonPanel.this.fdrGraphBox.setEnabled(NonparWilcoxonPanel.this.fdrButton.isSelected());
            NonparWilcoxonPanel.this.fdrField.setEnabled(!NonparWilcoxonPanel.this.fdrGraphBox.isSelected());
        }
    }
}

