/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.nonpar;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.IWizardParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.microarray.mev.cluster.gui.impl.nonpar.NonparConstants;

public class NonparModePanel
extends JPanel
implements IWizardParameterPanel {
    private AlgorithmData algData;
    private JRadioButton wilcoxonButton;
    private JRadioButton kruskalButton;
    private JRadioButton mackSkillingsButton;
    private JRadioButton fisherExactButton;
    JDialog parent;

    public NonparModePanel(AlgorithmData paramData, JDialog parent) {
        super(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Select Test/Mode"));
        this.algData = paramData;
        this.parent = parent;
        this.constructPanel();
    }

    private void constructPanel() {
        ButtonGroup bg = new ButtonGroup();
        this.wilcoxonButton = new JRadioButton("<html><u>Wilcoxon, Mann-Whitney Test</u><br>(one factor, two experimental groups)</html>", true);
        this.wilcoxonButton.setOpaque(false);
        this.wilcoxonButton.setIconTextGap(10);
        bg.add(this.wilcoxonButton);
        this.kruskalButton = new JRadioButton("<html><u>Kruskal-Wallis Test</u><br>(one factor, n experimental groups)</html>");
        this.kruskalButton.setOpaque(false);
        this.kruskalButton.setIconTextGap(10);
        bg.add(this.kruskalButton);
        this.mackSkillingsButton = new JRadioButton("<html><u>Mack-Skillings Test</u><br>(two-factor designs, n x k)</html>");
        this.mackSkillingsButton.setOpaque(false);
        this.mackSkillingsButton.setIconTextGap(10);
        bg.add(this.mackSkillingsButton);
        this.fisherExactButton = new JRadioButton("<html><u>Fisher Exact Test</u><br>(two experimental groups,<br>data represents two categories or bins)</html>");
        this.fisherExactButton.setOpaque(false);
        this.fisherExactButton.setIconTextGap(10);
        bg.add(this.fisherExactButton);
        this.add((Component)this.wilcoxonButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 10, 0, 20), 0, 0));
        this.add((Component)this.kruskalButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(10, 10, 10, 20), 0, 0));
        this.add((Component)this.mackSkillingsButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 10, 10, 20), 0, 0));
        this.add((Component)this.fisherExactButton, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 10, 0, 20), 0, 0));
        JButton infoButton = new JButton(null, GUIFactory.getIcon("Information24.gif"));
        infoButton.setActionCommand("info-command");
        infoButton.setSize(30, 30);
        infoButton.setPreferredSize(new Dimension(30, 30));
        infoButton.setFocusPainted(false);
        Border border = BorderFactory.createBevelBorder(0);
        infoButton.setBorder(border);
        infoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                HelpWindow.launchBrowser(NonparModePanel.this.parent, "NonpaR Mode Selection");
            }
        });
        this.add((Component)infoButton, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 5, 5, 0), 0, 0));
    }

    @Override
    public void populateAlgorithmData() {
        if (this.wilcoxonButton.isSelected()) {
            this.algData.addParam("nonpar-mode", NonparConstants.MODE_WILCOXON_MANN_WHITNEY);
        } else if (this.kruskalButton.isSelected()) {
            this.algData.addParam("nonpar-mode", NonparConstants.MODE_KRUSKAL_WALLIS);
        } else if (this.mackSkillingsButton.isSelected()) {
            this.algData.addParam("nonpar-mode", NonparConstants.MODE_MACK_SKILLINGS);
        } else if (this.fisherExactButton.isSelected()) {
            this.algData.addParam("nonpar-mode", NonparConstants.MODE_FISHER_EXACT);
        }
    }

    @Override
    public void clearValuesFromAlgorithmData() {
        this.algData.getParams().getMap().remove("nonpar-mode");
    }

    @Override
    public void onDisplayed() {
    }
}

