/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.nonpar;

import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.GroupNumberAndNameSelectionPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.GroupSelectionColorPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.IWizardParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.StatProcessWizard;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.TwoWaySelectionPanel;
import org.tigr.microarray.mev.cluster.gui.impl.nonpar.NonparConstants;
import org.tigr.microarray.mev.cluster.gui.impl.nonpar.NonparFEGroupAndDataBinNamePanel;
import org.tigr.microarray.mev.cluster.gui.impl.nonpar.NonparFisherPanel;
import org.tigr.microarray.mev.cluster.gui.impl.nonpar.NonparModePanel;
import org.tigr.microarray.mev.cluster.gui.impl.nonpar.NonparWilcoxonPanel;

public class NonparInitWizard
extends StatProcessWizard {
    private NonparModePanel modePanel;
    private GroupNumberAndNameSelectionPanel groupNumberAndNamesPanel;
    NonparFEGroupAndDataBinNamePanel feGroupAndBinNamesPanel;
    private GroupSelectionColorPanel groupSelectionPanel;
    private NonparWilcoxonPanel wilcoxonPanel;
    private NonparFisherPanel fisherExactPanel;
    private IWizardParameterPanel twoWayPanel;
    private IWizardParameterPanel currentPanel;

    public NonparInitWizard(IData idata, JFrame parent, String title, boolean modal, AlgorithmData algData, String[] steps, int stepCount, JPanel initPanel) {
        super(parent, title, modal, algData, steps, stepCount, initPanel);
        this.modePanel = new NonparModePanel(algData, this);
        super.setInitialPanel(this.modePanel);
        this.currentPanel = this.modePanel;
        this.groupNumberAndNamesPanel = new GroupNumberAndNameSelectionPanel(algData, this, false);
        this.groupSelectionPanel = new GroupSelectionColorPanel(algData);
        this.wilcoxonPanel = new NonparWilcoxonPanel(algData, this);
        this.feGroupAndBinNamesPanel = new NonparFEGroupAndDataBinNamePanel(algData, this);
        this.fisherExactPanel = new NonparFisherPanel(algData, this);
        Vector fieldNameVector = idata.getSampleAnnotationFieldNames();
        String[] fieldNames = new String[fieldNameVector.size()];
        for (int i = 0; i < fieldNames.length; ++i) {
            fieldNames[i] = (String)fieldNameVector.get(i);
        }
        int numSamples = idata.getFeaturesList().size();
        String[][] sampleAnn = new String[fieldNames.length][numSamples];
        for (int i = 0; i < sampleAnn.length; ++i) {
            for (int j = 0; j < sampleAnn[i].length; ++j) {
                sampleAnn[i][j] = idata.getSampleAnnotation(j, fieldNames[i]);
            }
        }
        this.twoWayPanel = new TwoWaySelectionPanel(algData, fieldNames, sampleAnn);
    }

    @Override
    protected IWizardParameterPanel prepareAndDeliverNextParameterPanel(AlgorithmData currAlgData, int currentStepIndex) {
        IWizardParameterPanel nextPanel = null;
        this.currentPanel.populateAlgorithmData();
        String mode = currAlgData.getParams().getString("nonpar-mode");
        if (currentStepIndex == 0) {
            if (mode.equals(NonparConstants.MODE_WILCOXON_MANN_WHITNEY)) {
                this.groupNumberAndNamesPanel.initialize(true, false, 2);
                nextPanel = this.groupNumberAndNamesPanel;
                this.pack();
            } else if (mode.equals(NonparConstants.MODE_KRUSKAL_WALLIS)) {
                this.groupNumberAndNamesPanel.initialize(true, true, 2);
                nextPanel = this.groupNumberAndNamesPanel;
                this.pack();
            } else if (mode.equals(NonparConstants.MODE_MACK_SKILLINGS)) {
                this.groupNumberAndNamesPanel.initialize(false, true, 2);
                nextPanel = this.groupNumberAndNamesPanel;
            } else if (mode.equals(NonparConstants.MODE_FISHER_EXACT)) {
                nextPanel = this.feGroupAndBinNamesPanel;
            }
            this.currentPanel = nextPanel;
        } else if (currentStepIndex == 1) {
            boolean uniqueNames = true;
            uniqueNames = mode.equals(NonparConstants.MODE_FISHER_EXACT) ? this.feGroupAndBinNamesPanel.areGroupAndFactorNamesUnique() : this.groupNumberAndNamesPanel.areGroupAndFactorNamesUnique();
            if (!uniqueNames) {
                --this.currentStepIndex;
                JOptionPane.showMessageDialog(this, "Please select unique groupa or factor names. Group or factor names are not unique.", "Ambiguous Naming Error", 0);
                return this.currentPanel;
            }
            this.currentPanel.populateAlgorithmData();
            String[] sampleNames = currAlgData.getStringArray("sample-names");
            String[] groupNames = currAlgData.getStringArray("group-names");
            if (mode.equals(NonparConstants.MODE_WILCOXON_MANN_WHITNEY)) {
                this.groupSelectionPanel.initializeOneFactor(groupNames, sampleNames);
                nextPanel = this.groupSelectionPanel;
            } else if (mode.equals(NonparConstants.MODE_KRUSKAL_WALLIS)) {
                this.groupSelectionPanel.initializeOneFactor(groupNames, sampleNames);
                nextPanel = this.groupSelectionPanel;
            } else if (mode.equals(NonparConstants.MODE_MACK_SKILLINGS)) {
                String factorAName = currAlgData.getParams().getString("factor-A-name");
                String factorBName = currAlgData.getParams().getString("factor-B-name");
                String[] factorANames = currAlgData.getStringArray("factor-A-level-names");
                String[] factorBNames = currAlgData.getStringArray("factor-B-level-names");
                ((TwoWaySelectionPanel)this.twoWayPanel).initialize(factorAName, factorBName, factorANames, factorBNames);
                nextPanel = this.twoWayPanel;
            }
            if (mode.equals(NonparConstants.MODE_FISHER_EXACT)) {
                this.groupSelectionPanel.initializeOneFactor(groupNames, sampleNames);
                nextPanel = this.groupSelectionPanel;
            }
            this.currentPanel = nextPanel;
        } else if (currentStepIndex == 2) {
            if (mode.equals(NonparConstants.MODE_WILCOXON_MANN_WHITNEY)) {
                nextPanel = this.wilcoxonPanel;
                this.wilcoxonPanel.initializePanel(mode);
            } else if (mode.equals(NonparConstants.MODE_KRUSKAL_WALLIS)) {
                nextPanel = this.wilcoxonPanel;
                this.wilcoxonPanel.initializePanel(mode);
            } else if (mode.equals(NonparConstants.MODE_MACK_SKILLINGS)) {
                nextPanel = this.wilcoxonPanel;
                this.wilcoxonPanel.initializePanel(mode);
            }
            if (mode.equals(NonparConstants.MODE_FISHER_EXACT)) {
                nextPanel = this.fisherExactPanel;
                this.fisherExactPanel.initializePanel();
            }
        } else if (currentStepIndex == 3) {
            if (mode.equals(NonparConstants.MODE_FISHER_EXACT)) {
                this.fisherExactPanel.populateAlgorithmData();
            } else {
                this.wilcoxonPanel.populateAlgorithmData();
            }
            this.result = 0;
        }
        return nextPanel;
    }

    @Override
    protected IWizardParameterPanel prepareAndDeliverPreviousParameterPanel(AlgorithmData currAlgData, int currentStepIndex) {
        IWizardParameterPanel prevPanel = null;
        this.currentPanel.clearValuesFromAlgorithmData();
        String mode = currAlgData.getParams().getString("nonpar-mode");
        if (currentStepIndex == 1) {
            prevPanel = this.modePanel;
            this.currentPanel = prevPanel;
        } else if (currentStepIndex == 2) {
            prevPanel = mode.equals(NonparConstants.MODE_FISHER_EXACT) ? this.feGroupAndBinNamesPanel : this.groupNumberAndNamesPanel;
            this.currentPanel = prevPanel;
        } else if (currentStepIndex == 3) {
            prevPanel = mode.equals(NonparConstants.MODE_MACK_SKILLINGS) ? this.twoWayPanel : this.groupSelectionPanel;
        }
        return prevPanel;
    }

    @Override
    protected boolean nextStep() {
        if (!super.nextStep()) {
            this.dispose();
        }
        return true;
    }
}

