/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.nonpar;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeData;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLViewer;
import org.tigr.microarray.mev.cluster.gui.impl.nonpar.NonparCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.nonpar.NonparCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.nonpar.NonparConstants;
import org.tigr.microarray.mev.cluster.gui.impl.nonpar.NonparExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.nonpar.NonparInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.nonpar.NonparInitWizard;
import org.tigr.microarray.mev.cluster.gui.impl.nonpar.NonparModePanel;
import org.tigr.util.FloatMatrix;

public class NonparGUI
implements IClusterGUI {
    private Algorithm nonpar;
    private Progress progress;

    public DefaultMutableTreeNode execute(IFramework framework) throws AlgorithmException {
        DefaultMutableTreeNode resultNode = null;
        IData idata = framework.getData();
        Experiment experiment = idata.getExperiment();
        FloatMatrix matrix = experiment.getMatrix();
        int numSamples = experiment.getNumberOfSamples();
        AlgorithmData algData = new AlgorithmData();
        algData.addMatrix("matrix", matrix);
        String[] sampleNames = new String[numSamples];
        for (int i = 0; i < numSamples; ++i) {
            sampleNames[i] = idata.getSampleName(experiment.getSampleIndex(i));
        }
        algData.addStringArray("sample-names", sampleNames);
        String[] steps = new String[]{"Mode Selection.", "Group name selection.", "Group assignment.", "Parameter selection.", "Execute"};
        JFrame mainFrame = (JFrame)framework.getFrame();
        Object[][] frameArray = new Object[1][1];
        frameArray[0][0] = mainFrame;
        algData.addObjectMatrix("main-frame", frameArray);
        NonparInitWizard wiz = new NonparInitWizard(idata, mainFrame, "Nonparameteric Tests Initialization", true, algData, steps, 3, new NonparModePanel(algData, new JDialog()));
        if (wiz.showModal() == 0) {
            if (algData.getParams().getBoolean("hcl-execution")) {
                HCLInitDialog hclDialog;
                IDistanceMenu menu = framework.getDistanceMenu();
                int function = menu.getDistanceFunction();
                if (function == 0) {
                    function = 1;
                }
                if ((hclDialog = new HCLInitDialog(framework.getFrame(), menu.getFunctionName(function), false, true)).showModal() == 0) {
                    int metric = hclDialog.getDistanceMetric();
                    boolean runGenes = hclDialog.isClusterGenes();
                    boolean runSamples = hclDialog.isClusterExperiments();
                    boolean absDistance = hclDialog.getAbsoluteSelection();
                    algData.addParam("hcl-distance-function", String.valueOf(metric));
                    algData.addParam("calculate-genes", String.valueOf(runGenes));
                    algData.addParam("calculate-samples", String.valueOf(runSamples));
                    algData.addParam("hcl-distance-absolute", String.valueOf(absDistance));
                    algData.addParam("method-linkage", String.valueOf(hclDialog.getMethod()));
                } else {
                    algData.addParam("hcl-execution", String.valueOf(false));
                }
            }
            if (algData.getParams().getString("nonpar-mode").equals(NonparConstants.MODE_FISHER_EXACT)) {
                if (algData.getParams().getBoolean("swap-groups")) {
                    String[] groupNames = algData.getStringArray("group-names");
                    String temp = groupNames[0];
                    groupNames[0] = groupNames[1];
                    groupNames[1] = temp;
                }
                if (algData.getParams().getBoolean("swap-bins")) {
                    String[] binNames = algData.getStringArray("fisher-exact-bin-names");
                    String temp = binNames[0];
                    binNames[0] = binNames[1];
                    binNames[1] = temp;
                }
            }
            Listener listener = new Listener();
            this.progress = new Progress(framework.getFrame(), "NonpaR Progress", listener);
            this.progress.setUnits(110);
            this.progress.setDescription("Initialization");
            this.progress.show();
            this.nonpar = framework.getAlgorithmFactory().getAlgorithm("NONPAR");
            this.nonpar.addAlgorithmListener((AlgorithmListener)listener);
            AlgorithmData result = this.nonpar.execute(algData);
            this.progress.dispose();
            String mode = algData.getParams().getString("nonpar-mode");
            int[][] clusters = mode.equals(NonparConstants.MODE_WILCOXON_MANN_WHITNEY) || mode.equals(NonparConstants.MODE_KRUSKAL_WALLIS) || mode.equals(NonparConstants.MODE_FISHER_EXACT) ? algData.getIntMatrix("clusters") : algData.getIntMatrix("clusters");
            resultNode = this.createResultNode(mode, result, idata, clusters, experiment);
        }
        return resultNode;
    }

    private String[][] createAuxDataMatrix(FloatMatrix data) {
        String[][] auxData = new String[data.getRowDimension()][data.getColumnDimension()];
        for (int j = 0; j < auxData.length; ++j) {
            for (int k = 0; k < auxData[j].length; ++k) {
                auxData[j][k] = String.valueOf(data.A[j][k]);
            }
        }
        return auxData;
    }

    private String[][] createAuxDataMatrix(FloatMatrix data, String[] methodArray) {
        String[][] auxData = new String[data.getRowDimension()][data.getColumnDimension() + 1];
        for (int j = 0; j < auxData.length; ++j) {
            auxData[j][0] = methodArray[j];
            for (int k = 0; k < auxData[j].length - 1; ++k) {
                auxData[j][k + 1] = String.valueOf(data.A[j][k]);
            }
        }
        return auxData;
    }

    private String[][] createAuxDataMatrix(FloatMatrix data, String[] designDescArray, String[] methodArray) {
        String[][] auxData = new String[data.getRowDimension()][data.getColumnDimension() + 2];
        for (int j = 0; j < auxData.length; ++j) {
            auxData[j][0] = designDescArray[j];
            auxData[j][1] = methodArray[j];
            for (int k = 0; k < auxData[j].length - 2; ++k) {
                auxData[j][k + 2] = String.valueOf(data.A[j][k]);
            }
        }
        return auxData;
    }

    private DefaultMutableTreeNode createResultNode(String mode, AlgorithmData result, IData idata, int[][] clusters, Experiment experiment) {
        DefaultMutableTreeNode node = null;
        if (mode.equals(NonparConstants.MODE_WILCOXON_MANN_WHITNEY)) {
            node = new DefaultMutableTreeNode("NonpaR [Wilcoxon Rank Sum]");
            this.addExpressionImages(node, mode, result, clusters, experiment);
            if (result.getParams().getBoolean("hcl-execution", false)) {
                this.addHierarchicalTrees(result, mode, node, result.getCluster("hcl-clusters"), experiment, result.getParams().getBoolean("calculate-genes"), result.getParams().getBoolean("calculate-samples"));
            }
            this.addCentroidViews(node, mode, result, experiment, clusters);
            this.addTableViews(mode, node, result, experiment, idata, clusters);
            this.addInfoViewer(node, mode, clusters, result);
        } else if (mode.equals(NonparConstants.MODE_KRUSKAL_WALLIS)) {
            node = new DefaultMutableTreeNode("NonpaR [Kruskal-Wallis Test]");
            this.addExpressionImages(node, mode, result, clusters, experiment);
            if (result.getParams().getBoolean("hcl-execution", false)) {
                this.addHierarchicalTrees(result, mode, node, result.getCluster("hcl-clusters"), experiment, result.getParams().getBoolean("calculate-genes"), result.getParams().getBoolean("calculate-samples"));
            }
            this.addCentroidViews(node, mode, result, experiment, clusters);
            this.addTableViews(mode, node, result, experiment, idata, clusters);
            this.addInfoViewer(node, mode, clusters, result);
        } else if (mode.equals(NonparConstants.MODE_MACK_SKILLINGS)) {
            node = new DefaultMutableTreeNode("NonpaR [Mack-Skilligs Test]");
            this.addExpressionImages(node, mode, result, clusters, experiment);
            if (result.getParams().getBoolean("hcl-execution", false)) {
                this.addHierarchicalTrees(result, mode, node, result.getCluster("hcl-clusters"), experiment, result.getParams().getBoolean("calculate-genes"), result.getParams().getBoolean("calculate-samples"));
            }
            this.addCentroidViews(node, mode, result, experiment, clusters);
            this.addTableViews(mode, node, result, experiment, idata, clusters);
            this.addInfoViewer(node, mode, clusters, result);
        } else if (mode.equals(NonparConstants.MODE_FISHER_EXACT)) {
            node = new DefaultMutableTreeNode("NonpaR [Fisher Exact Test]");
            this.addExpressionImages(node, mode, result, clusters, experiment);
            if (result.getParams().getBoolean("hcl-execution", false)) {
                this.addHierarchicalTrees(result, mode, node, result.getCluster("hcl-clusters"), experiment, result.getParams().getBoolean("calculate-genes"), result.getParams().getBoolean("calculate-samples"));
            }
            this.addCentroidViews(node, mode, result, experiment, clusters);
            this.addTableViews(mode, node, result, experiment, idata, clusters);
            this.addInfoViewer(node, mode, clusters, result);
        }
        return node;
    }

    private void addExpressionImages(DefaultMutableTreeNode root, String mode, AlgorithmData result, int[][] clusters, Experiment experiment) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Expression Images");
        FloatMatrix resultMatrix = result.getMatrix("result-matrix");
        String[] methodArray = result.getStringArray("method-array");
        String[] auxTitles = this.constructAuxTitles(result, mode);
        if (mode.equals(NonparConstants.MODE_WILCOXON_MANN_WHITNEY)) {
            String[][] auxData = this.createAuxDataMatrix(resultMatrix, methodArray);
            NonparExperimentViewer viewer = new NonparExperimentViewer(experiment, clusters, auxTitles, auxData);
            DefaultMutableTreeNode viewerNode = new DefaultMutableTreeNode(new LeafInfo("Significant Genes", (IViewer)viewer, (Object)new Integer(0)));
            node.add(viewerNode);
            viewerNode = new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes", (IViewer)viewer, (Object)new Integer(1)));
            node.add(viewerNode);
        } else if (mode.equals(NonparConstants.MODE_KRUSKAL_WALLIS)) {
            String[][] auxData = this.createAuxDataMatrix(resultMatrix, methodArray);
            NonparExperimentViewer viewer = new NonparExperimentViewer(experiment, clusters, auxTitles, auxData);
            DefaultMutableTreeNode viewerNode = new DefaultMutableTreeNode(new LeafInfo("Significant Genes", (IViewer)viewer, (Object)new Integer(0)));
            node.add(viewerNode);
            viewerNode = new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes", (IViewer)viewer, (Object)new Integer(1)));
            node.add(viewerNode);
        } else if (mode.equals(NonparConstants.MODE_MACK_SKILLINGS)) {
            String[] designArray = result.getStringArray("design-array");
            String[][] auxData = this.createAuxDataMatrix(resultMatrix, designArray, methodArray);
            NonparExperimentViewer viewer = new NonparExperimentViewer(experiment, clusters, auxTitles, auxData);
            String factorAName = result.getParams().getString("factor-A-name");
            String factorBName = result.getParams().getString("factor-B-name");
            DefaultMutableTreeNode viewerNode = new DefaultMutableTreeNode(new LeafInfo(factorAName + " Significant Genes", (IViewer)viewer, (Object)new Integer(0)));
            node.add(viewerNode);
            viewerNode = new DefaultMutableTreeNode(new LeafInfo(factorAName + " Non-significant Genes", (IViewer)viewer, (Object)new Integer(1)));
            node.add(viewerNode);
            viewerNode = new DefaultMutableTreeNode(new LeafInfo(factorBName + " Significant Genes", (IViewer)viewer, (Object)new Integer(2)));
            node.add(viewerNode);
            viewerNode = new DefaultMutableTreeNode(new LeafInfo(factorBName + " Non-significant Genes", (IViewer)viewer, (Object)new Integer(3)));
            node.add(viewerNode);
            viewerNode = new DefaultMutableTreeNode(new LeafInfo("Incomplete Design (untested)", (IViewer)viewer, (Object)new Integer(4)));
            node.add(viewerNode);
        } else if (mode.equals(NonparConstants.MODE_FISHER_EXACT)) {
            String[][] auxData = this.createAuxDataMatrix(resultMatrix);
            NonparExperimentViewer viewer = new NonparExperimentViewer(experiment, clusters, auxTitles, auxData);
            DefaultMutableTreeNode viewerNode = new DefaultMutableTreeNode(new LeafInfo("Significant Genes", (IViewer)viewer, (Object)new Integer(0)));
            node.add(viewerNode);
            viewerNode = new DefaultMutableTreeNode(new LeafInfo("Significant Genes (left tail lower)", (IViewer)viewer, (Object)new Integer(1)));
            node.add(viewerNode);
            viewerNode = new DefaultMutableTreeNode(new LeafInfo("Significant Genes (right tail lower)", (IViewer)viewer, (Object)new Integer(2)));
            node.add(viewerNode);
            viewerNode = new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes", (IViewer)viewer, (Object)new Integer(3)));
            node.add(viewerNode);
        }
        root.add(node);
    }

    private String[] constructAuxTitles(AlgorithmData result, String mode) {
        String[] auxTitles = null;
        String[] groupNames = result.getStringArray("group-names");
        if (mode.equals(NonparConstants.MODE_WILCOXON_MANN_WHITNEY)) {
            boolean useAlpha = result.getParams().getBoolean("use-alpha-criterion");
            auxTitles = useAlpha ? new String[6] : new String[7];
            auxTitles[0] = "Method";
            auxTitles[1] = "n (" + groupNames[0] + ")";
            auxTitles[2] = "n (" + groupNames[1] + ")";
            auxTitles[3] = "W";
            auxTitles[4] = "W*";
            auxTitles[5] = "p-value";
            if (!useAlpha) {
                auxTitles[6] = "adj. p (Benjamini/Hochberg)";
            }
        } else if (mode.equals(NonparConstants.MODE_KRUSKAL_WALLIS)) {
            boolean useAlpha = result.getParams().getBoolean("use-alpha-criterion");
            auxTitles = useAlpha ? new String[4] : new String[5];
            auxTitles[0] = "Method";
            auxTitles[1] = "df";
            auxTitles[2] = "Kruskal-Wallis Statistic (H)";
            auxTitles[3] = "p-value";
            if (!useAlpha) {
                auxTitles[4] = "adj. p (Benjamini/Hochberg)";
            }
        } else if (mode.equals(NonparConstants.MODE_MACK_SKILLINGS)) {
            String factorAName = result.getParams().getString("factor-A-name");
            String factorBName = result.getParams().getString("factor-B-name");
            auxTitles = new String[]{"Design Descr.", "Method", "n vals", "n " + factorAName + " Levels", "MS Stat (" + factorAName + ")", "p-value (" + factorAName + ")", "n " + factorBName + " Levels", "MS Stat (" + factorBName + ")", "p-value (" + factorBName + ")"};
        } else if (mode.equals(NonparConstants.MODE_FISHER_EXACT)) {
            boolean useAlpha = result.getParams().getBoolean("use-alpha-criterion");
            auxTitles = useAlpha ? new String[7] : new String[8];
            String[] binNames = result.getStringArray("fisher-exact-bin-names");
            auxTitles[0] = groupNames[0] + "/" + binNames[0];
            auxTitles[1] = groupNames[1] + "/" + binNames[0];
            auxTitles[2] = groupNames[0] + "/" + binNames[1];
            auxTitles[3] = groupNames[1] + "/" + binNames[1];
            auxTitles[4] = "Left Tail p-value";
            auxTitles[5] = "Right Tail p-value";
            auxTitles[6] = "2-Tail p-value";
            if (!useAlpha) {
                auxTitles[7] = "adj. p (Benjamini/Hochberg)";
            }
        }
        return auxTitles;
    }

    private void addHierarchicalTrees(AlgorithmData result, String mode, DefaultMutableTreeNode root, Cluster result_cluster, Experiment experiment, boolean hclGenes, boolean hclSamples) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Hierarchical Trees");
        NodeList nodeList = result_cluster.getNodeList();
        if (!mode.equals(NonparConstants.MODE_MACK_SKILLINGS)) {
            node.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes", this.createHCLViewer(nodeList.getNode(0), experiment, hclGenes, hclSamples, null))));
        } else {
            String factorAName = result.getParams().getString("factor-A-name");
            String factorBName = result.getParams().getString("factor-B-name");
            node.add(new DefaultMutableTreeNode(new LeafInfo(factorAName + " Significant Genes", this.createHCLViewer(nodeList.getNode(0), experiment, hclGenes, hclSamples, null))));
            node.add(new DefaultMutableTreeNode(new LeafInfo(factorBName + " Significant Genes", this.createHCLViewer(nodeList.getNode(1), experiment, hclGenes, hclSamples, null))));
        }
        root.add(node);
    }

    private IViewer createHCLViewer(Node clusterNode, Experiment experiment, boolean genes, boolean samples, int[][] sampleClusters) {
        HCLTreeData genes_result;
        HCLTreeData hCLTreeData = genes_result = genes ? this.getResult(clusterNode, 0) : null;
        HCLTreeData samples_result = samples ? this.getResult(clusterNode, genes ? 4 : 0) : null;
        return new HCLViewer(experiment, clusterNode.getFeaturesIndexes(), genes_result, samples_result);
    }

    private HCLTreeData getResult(Node clusterNode, int pos) {
        HCLTreeData data = new HCLTreeData();
        NodeValueList valueList = clusterNode.getValues();
        data.child_1_array = (int[])valueList.getNodeValue((int)pos).value;
        data.child_2_array = (int[])valueList.getNodeValue((int)(pos + 1)).value;
        data.node_order = (int[])valueList.getNodeValue((int)(pos + 2)).value;
        data.height = (float[])valueList.getNodeValue((int)(pos + 3)).value;
        return data;
    }

    private void addCentroidViews(DefaultMutableTreeNode root, String mode, AlgorithmData result, Experiment experiment, int[][] clusters) {
        String[][] auxData;
        float[][] means = result.getMatrix((String)"cluster-means").A;
        float[][] vars = result.getMatrix((String)"cluster-variances").A;
        FloatMatrix resultMatrix = result.getMatrix("result-matrix");
        String[] groupNames = result.getStringArray("group-names");
        String[] auxTitles = this.constructAuxTitles(result, mode);
        String[] methodArray = result.getStringArray("method-array");
        if (mode.equals(NonparConstants.MODE_MACK_SKILLINGS)) {
            String[] designArray = result.getStringArray("design-array");
            auxData = this.createAuxDataMatrix(resultMatrix, designArray, methodArray);
        } else {
            auxData = mode.equals(NonparConstants.MODE_FISHER_EXACT) ? this.createAuxDataMatrix(resultMatrix) : this.createAuxDataMatrix(resultMatrix, methodArray);
        }
        DefaultMutableTreeNode centroidNode = new DefaultMutableTreeNode("Centroid Graphs");
        DefaultMutableTreeNode expressionNode = new DefaultMutableTreeNode("Expression Graphs");
        NonparCentroidViewer centroidViewer = new NonparCentroidViewer(experiment, clusters, auxTitles, auxData);
        centroidViewer.setMeans(means);
        centroidViewer.setVariances(vars);
        String clusterLabel = "";
        if (mode.equals(NonparConstants.MODE_FISHER_EXACT)) {
            centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes", (IViewer)centroidViewer, (Object)new CentroidUserObject(0, 0))));
            centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes (left tail lower)", (IViewer)centroidViewer, (Object)new CentroidUserObject(1, 0))));
            centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes (right tail lower)", (IViewer)centroidViewer, (Object)new CentroidUserObject(2, 0))));
            centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes", (IViewer)centroidViewer, (Object)new CentroidUserObject(3, 0))));
            expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes", (IViewer)centroidViewer, (Object)new CentroidUserObject(0, 1))));
            expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes (left tail lower)", (IViewer)centroidViewer, (Object)new CentroidUserObject(1, 1))));
            expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes (right tail lower)", (IViewer)centroidViewer, (Object)new CentroidUserObject(2, 1))));
            expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes", (IViewer)centroidViewer, (Object)new CentroidUserObject(3, 1))));
        } else if (!mode.equals(NonparConstants.MODE_MACK_SKILLINGS)) {
            for (int i = 0; i < clusters.length; ++i) {
                if (i == 0) {
                    clusterLabel = "Significant Genes ";
                } else if (i == 1) {
                    clusterLabel = "Non-significant Genes ";
                }
                centroidNode.add(new DefaultMutableTreeNode(new LeafInfo(clusterLabel, (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 0))));
                expressionNode.add(new DefaultMutableTreeNode(new LeafInfo(clusterLabel, (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 1))));
            }
        } else {
            String factorAName = result.getParams().getString("factor-A-name");
            String factorBName = result.getParams().getString("factor-B-name");
            for (int i = 0; i < clusters.length; ++i) {
                if (i == 0) {
                    clusterLabel = factorAName + " Significant Genes ";
                } else if (i == 1) {
                    clusterLabel = factorAName + " Non-significant Genes ";
                } else if (i == 2) {
                    clusterLabel = factorBName + " Significant Genes ";
                } else if (i == 3) {
                    clusterLabel = factorBName + " Non-significant Genes ";
                } else if (i == 4) {
                    clusterLabel = "Incomplete Design (untested)";
                }
                centroidNode.add(new DefaultMutableTreeNode(new LeafInfo(clusterLabel, (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 0))));
                expressionNode.add(new DefaultMutableTreeNode(new LeafInfo(clusterLabel, (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 1))));
            }
        }
        NonparCentroidsViewer centroidsViewer = new NonparCentroidsViewer(experiment, clusters, auxTitles, auxData);
        centroidsViewer.setMeans(means);
        centroidsViewer.setVariances(vars);
        centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("All Genes", (IViewer)centroidsViewer, (Object)new Integer(0))));
        expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("All Genes", (IViewer)centroidsViewer, (Object)new Integer(1))));
        root.add(centroidNode);
        root.add(expressionNode);
    }

    private void addTableViews(String mode, DefaultMutableTreeNode root, AlgorithmData result, Experiment experiment, IData data, int[][] clusters) {
        Object[][] auxData;
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Table Views");
        FloatMatrix resultMatrix = result.getMatrix("result-matrix");
        String[] auxTitles = this.constructAuxTitles(result, mode);
        String[] methodArray = result.getStringArray("method-array");
        if (mode.equals(NonparConstants.MODE_MACK_SKILLINGS)) {
            String[] designArray = result.getStringArray("design-array");
            auxData = this.createAuxDataMatrix(resultMatrix, designArray, methodArray);
        } else {
            auxData = mode.equals(NonparConstants.MODE_FISHER_EXACT) ? this.createAuxDataMatrix(resultMatrix) : this.createAuxDataMatrix(resultMatrix, methodArray);
        }
        ClusterTableViewer tabViewer = new ClusterTableViewer(experiment, clusters, data, auxTitles, auxData);
        if (mode.equals(NonparConstants.MODE_FISHER_EXACT)) {
            node.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes", (IViewer)tabViewer, (Object)new Integer(0))));
            node.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes (left tail lower)", (IViewer)tabViewer, (Object)new Integer(1))));
            node.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes (right tail lower)", (IViewer)tabViewer, (Object)new Integer(2))));
            node.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes", (IViewer)tabViewer, (Object)new Integer(3))));
            int[][] allIndices = new int[1][auxData.length];
            for (int i = 0; i < allIndices[0].length; ++i) {
                allIndices[0][i] = i;
            }
            node.add(new DefaultMutableTreeNode(new LeafInfo("All Genes", (IViewer)new ClusterTableViewer(experiment, allIndices, data, auxTitles, auxData), (Object)new Integer(0))));
        } else if (!mode.equals(NonparConstants.MODE_MACK_SKILLINGS)) {
            for (int i = 0; i < clusters.length; ++i) {
                if (i < clusters.length - 1) {
                    node.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes ", (IViewer)tabViewer, (Object)new Integer(i))));
                    continue;
                }
                if (i != clusters.length - 1) continue;
                node.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", (IViewer)tabViewer, (Object)new Integer(i))));
            }
        } else {
            String clusterLabel = "";
            String factorAName = result.getParams().getString("factor-A-name");
            String factorBName = result.getParams().getString("factor-B-name");
            for (int i = 0; i < clusters.length; ++i) {
                if (i == 0) {
                    clusterLabel = factorAName + " Significant Genes ";
                } else if (i == 1) {
                    clusterLabel = factorAName + " Non-significant Genes ";
                } else if (i == 2) {
                    clusterLabel = factorBName + " Significant Genes ";
                } else if (i == 3) {
                    clusterLabel = factorBName + " Non-significant Genes ";
                } else if (i == 4) {
                    clusterLabel = "Incomplete Design (untested)";
                }
                node.add(new DefaultMutableTreeNode(new LeafInfo(clusterLabel, (IViewer)tabViewer, (Object)new Integer(i))));
            }
        }
        root.add(node);
    }

    private void addInfoViewer(DefaultMutableTreeNode root, String mode, int[][] clusters, AlgorithmData result) {
        String[] groupNames;
        float sigLevel;
        boolean useAlpha = result.getParams().getBoolean("use-alpha-criterion", true);
        float estFDR = Float.NaN;
        if (useAlpha) {
            sigLevel = result.getParams().getFloat("alpha");
        } else {
            sigLevel = result.getParams().getFloat("fdr");
            estFDR = result.getParams().getFloat("estimated-fdr");
        }
        NonparInfoViewer viewer = null;
        String modeStr = null;
        if (mode.equals(NonparConstants.MODE_FISHER_EXACT)) {
            modeStr = "Fisher Exact Test";
            groupNames = result.getStringArray("group-names");
            int[] groupAssign = result.getIntArray("group-assignments");
            int[] numPerGroup = this.getGroupNs(groupNames.length, groupAssign);
            String[] binNames = result.getStringArray("fisher-exact-bin-names");
            float dataBinCutoff = result.getParams().getFloat("fisher-exact-bin-cutoff");
            viewer = new NonparInfoViewer(clusters, modeStr, useAlpha, sigLevel, estFDR, groupNames, numPerGroup, binNames, dataBinCutoff);
        } else if (mode.equals(NonparConstants.MODE_MACK_SKILLINGS)) {
            String factorAName = result.getParams().getString("factor-A-name");
            String factorBName = result.getParams().getString("factor-B-name");
            String[] factorANames = result.getStringArray("factor-A-level-names");
            String[] factorBNames = result.getStringArray("factor-B-level-names");
            modeStr = "Mack-Skillings Test";
            viewer = new NonparInfoViewer(clusters, modeStr, useAlpha, sigLevel, factorAName, factorBName, factorANames, factorBNames);
        } else {
            groupNames = result.getStringArray("group-names");
            int[] groupAssign = result.getIntArray("group-assignments");
            int[] numPerGroup = this.getGroupNs(groupNames.length, groupAssign);
            if (mode.equals(NonparConstants.MODE_WILCOXON_MANN_WHITNEY)) {
                modeStr = "Wilcoxon Rank Sum Test";
            } else if (mode.equals(NonparConstants.MODE_KRUSKAL_WALLIS)) {
                modeStr = "Kruskal-Wallis Test";
            }
            viewer = new NonparInfoViewer(clusters, modeStr, useAlpha, sigLevel, estFDR, groupNames, numPerGroup);
        }
        DefaultMutableTreeNode infoNode = new DefaultMutableTreeNode("Cluster Information");
        infoNode.add(new DefaultMutableTreeNode(new LeafInfo("Result Overview", (IViewer)viewer)));
        root.add(infoNode);
    }

    private int[] getGroupNs(int numGroups, int[] assignments) {
        int[] groupNs = new int[numGroups];
        for (int i = 0; i < assignments.length; ++i) {
            if (assignments[i] != -1) {
                int n = assignments[i];
                groupNs[n] = groupNs[n] + 1;
                continue;
            }
            int n = groupNs.length - 1;
            groupNs[n] = groupNs[n] + 1;
        }
        return groupNs;
    }

    public static void main(String[] args) {
        NonparGUI gui = new NonparGUI();
        try {
            gui.execute(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        private Listener() {
        }

        public void valueChanged(AlgorithmEvent event) {
            switch (event.getId()) {
                case 1: {
                    NonparGUI.this.progress.setUnits(event.getIntValue());
                    NonparGUI.this.progress.setDescription(event.getDescription());
                    break;
                }
                case 2: {
                    NonparGUI.this.progress.setValue(event.getIntValue());
                    NonparGUI.this.progress.setDescription(event.getDescription());
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("cancel-command")) {
                NonparGUI.this.nonpar.abort();
                NonparGUI.this.progress.dispose();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            NonparGUI.this.nonpar.abort();
            NonparGUI.this.progress.dispose();
        }
    }
}

