/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.nonpar;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.IWizardParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class NonparFisherPanel
extends JPanel
implements IWizardParameterPanel {
    private AlgorithmData algData;
    private String[] binNames;
    private String[] groupNames;
    private JTextField cutoffField;
    private JRadioButton binOneButton;
    private JRadioButton binTwoButton;
    private JRadioButton pValueButton;
    private JRadioButton fdrButton;
    private JCheckBox fdrGraphBox;
    private JLabel alphaLabel;
    private JTextField alphaField;
    private JLabel fdrLimitLabel;
    private JTextField fdrField;
    private JCheckBox hclBox;
    private int c1Index;
    private int r1Index;
    private JDialog parent;
    private String FISHER_TITLE = "Fisher Exact Test Parameters";

    public NonparFisherPanel(AlgorithmData parameters, JDialog parent) {
        super(new GridBagLayout());
        this.parent = parent;
        this.algData = parameters;
    }

    public void initializePanel() {
        this.removeAll();
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), this.FISHER_TITLE));
        Listener listener = new Listener();
        this.binNames = this.algData.getStringArray("fisher-exact-bin-names");
        this.groupNames = this.algData.getStringArray("group-names");
        JLabel cutoffLabel = new JLabel("<html>Data Bin Partition Cutoff Value:<br>( segregates data values into two bins )</html>");
        this.cutoffField = new JTextField("0.0");
        JLabel polarityInstructionLabel = new JLabel("<html>Select the data bin label that represents data values <u>greater</u> than<br> the cutoff value selected above:");
        this.binOneButton = new JRadioButton("\"" + this.binNames[0] + "\" Data Bin", true);
        this.binOneButton.setFocusPainted(false);
        this.binTwoButton = new JRadioButton("\"" + this.binNames[1] + "\" Data Bin");
        this.binTwoButton.setFocusPainted(false);
        ButtonGroup bg1 = new ButtonGroup();
        bg1.add(this.binOneButton);
        bg1.add(this.binTwoButton);
        JSeparator sep1 = new JSeparator(0);
        sep1.setPreferredSize(new Dimension(200, 2));
        ContingencyMatrixPanel matrixPanel = new ContingencyMatrixPanel(this.groupNames, this.binNames);
        JSeparator sep2 = new JSeparator(0);
        sep2.setPreferredSize(new Dimension(200, 2));
        ButtonGroup bg = new ButtonGroup();
        this.pValueButton = new JRadioButton("Use p-value Significance Criterion", true);
        this.pValueButton.setIconTextGap(8);
        this.pValueButton.setFocusPainted(false);
        this.pValueButton.addActionListener(listener);
        bg.add(this.pValueButton);
        this.alphaLabel = new JLabel("Alpha, critcal p-value:");
        this.alphaField = new JTextField("0.05");
        this.alphaField.setPreferredSize(new Dimension(60, 20));
        this.hclBox = new JCheckBox("<html>Create Hierarchical Trees (on significant genes)</html>", false);
        this.hclBox.setFocusPainted(false);
        this.hclBox.setOpaque(false);
        this.hclBox.setIconTextGap(8);
        this.hclBox.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Hierarcical Clustering"));
        this.fdrButton = new JRadioButton("<html>Use FDR Significance Criterion<br>(based on Benjamini-Hochberg Correction)</html>");
        this.fdrButton.setIconTextGap(8);
        this.fdrButton.setFocusPainted(false);
        this.fdrButton.addActionListener(listener);
        bg.add(this.fdrButton);
        this.fdrGraphBox = new JCheckBox("<html>Select FDR After Analysis<br><c>(interactive mode)</c></html>", true);
        this.fdrGraphBox.setIconTextGap(8);
        this.fdrGraphBox.setFocusPainted(false);
        this.fdrGraphBox.setEnabled(false);
        this.fdrGraphBox.addActionListener(listener);
        this.fdrLimitLabel = new JLabel("Selected FDR Limit: ");
        this.fdrField = new JTextField("0.05");
        this.fdrField.setPreferredSize(new Dimension(60, 20));
        this.fdrField.setEnabled(false);
        JSeparator sep = new JSeparator(0);
        sep.setPreferredSize(new Dimension(200, 2));
        this.add((Component)cutoffLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 15, 10, 10), 0, 0));
        this.add((Component)this.cutoffField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 10, 10), 0, 0));
        this.add((Component)polarityInstructionLabel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(15, 15, 10, 10), 0, 0));
        JPanel binPanel = new JPanel(new GridBagLayout());
        binPanel.add((Component)this.binOneButton, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 0, new Insets(0, 0, 15, 0), 0, 0));
        binPanel.add((Component)this.binTwoButton, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 0, new Insets(0, 0, 15, 0), 0, 0));
        this.add((Component)binPanel, new GridBagConstraints(0, 2, 2, 1, 0.5, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)sep1, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 1, new Insets(0, 20, 15, 20), 0, 0));
        this.add((Component)matrixPanel, new GridBagConstraints(0, 4, 2, 1, 0.5, 0.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
        this.add((Component)sep2, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 10, 1, new Insets(15, 20, 15, 20), 0, 0));
        this.add((Component)this.pValueButton, new GridBagConstraints(0, 6, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 15, 10, 10), 0, 0));
        this.add((Component)this.alphaLabel, new GridBagConstraints(0, 7, 1, 1, 1.0, 0.0, 13, 3, new Insets(0, 10, 15, 10), 0, 0));
        this.add((Component)this.alphaField, new GridBagConstraints(1, 7, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 15, 10), 0, 0));
        this.add((Component)sep, new GridBagConstraints(0, 8, 2, 1, 1.0, 0.0, 10, 1, new Insets(0, 20, 10, 20), 0, 0));
        this.add((Component)this.fdrButton, new GridBagConstraints(0, 9, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 15, 5, 0), 0, 0));
        this.add((Component)this.fdrGraphBox, new GridBagConstraints(0, 10, 2, 1, 1.0, 0.0, 10, 3, new Insets(0, 0, 10, 0), 0, 0));
        this.add((Component)this.fdrLimitLabel, new GridBagConstraints(0, 11, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 10, 10), 0, 0));
        this.add((Component)this.fdrField, new GridBagConstraints(1, 11, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 10, 10), 0, 0));
        this.add((Component)this.hclBox, new GridBagConstraints(0, 12, 2, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        JButton infoButton = new JButton(null, GUIFactory.getIcon("Information24.gif"));
        infoButton.setActionCommand("info-command");
        infoButton.setSize(30, 30);
        infoButton.setPreferredSize(new Dimension(30, 30));
        infoButton.setFocusPainted(false);
        Border border = BorderFactory.createBevelBorder(0);
        infoButton.setBorder(border);
        infoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                HelpWindow.launchBrowser(NonparFisherPanel.this.parent, "NonpaR Fisher Exact Parameters");
            }
        });
        this.add((Component)infoButton, new GridBagConstraints(0, 13, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
    }

    @Override
    public void populateAlgorithmData() {
        this.algData.addParam("use-alpha-criterion", String.valueOf(this.pValueButton.isSelected()));
        if (this.pValueButton.isSelected()) {
            this.algData.addParam("alpha", this.alphaField.getText());
        } else {
            this.algData.addParam("use-fdr-graph", String.valueOf(this.fdrGraphBox.isSelected()));
            if (!this.fdrGraphBox.isSelected()) {
                this.algData.addParam("fdr", this.fdrField.getText());
            }
        }
        this.algData.addParam("hcl-execution", String.valueOf(this.runHCL()));
        this.algData.addParam("fisher-exact-bin-cutoff", this.cutoffField.getText());
        this.algData.addParam("upper-bin-index", this.binOneButton.isSelected() ? "0" : "1");
        this.algData.addParam("swap-groups", String.valueOf(this.c1Index == 1));
        this.algData.addParam("swap-bins", String.valueOf(this.r1Index == 1));
    }

    @Override
    public void clearValuesFromAlgorithmData() {
        this.algData.getParams().getMap().remove("use-alpha-criterion");
        this.algData.getParams().getMap().remove("alpha");
        this.algData.getParams().getMap().remove("use-fdr-graph");
        this.algData.getParams().getMap().remove("fdr");
        this.algData.getParams().getMap().remove("hcl-execution");
        this.algData.getParams().getMap().remove("fisher-exact-bin-cutoff");
        this.algData.getParams().getMap().remove("upper-bin-index");
        this.algData.getParams().getMap().remove("swap-groups");
        this.algData.getParams().getMap().remove("swap-bins");
    }

    @Override
    public void onDisplayed() {
    }

    public boolean runHCL() {
        return this.hclBox.isSelected();
    }

    private long factorial(int n) {
        if (n == 1 || n == 0) {
            return 1L;
        }
        return this.factorial(n - 1) * (long)n;
    }

    private int getNumCombs(int n, int k) {
        return Math.round(this.factorial(n) / (this.factorial(k) * this.factorial(n - k)));
    }

    public class Listener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            NonparFisherPanel.this.alphaField.setEnabled(NonparFisherPanel.this.pValueButton.isSelected());
            NonparFisherPanel.this.fdrGraphBox.setEnabled(NonparFisherPanel.this.fdrButton.isSelected());
            NonparFisherPanel.this.fdrField.setEnabled(!NonparFisherPanel.this.fdrGraphBox.isSelected());
        }
    }

    public class ContingencyMatrixPanel
    extends JPanel {
        private JLabel c1;
        private JLabel c2;
        private JLabel r1;
        private JLabel r2;

        public ContingencyMatrixPanel(String[] groupNames, String[] binNames) {
            super(new GridBagLayout());
            NonparFisherPanel.this.c1Index = 0;
            NonparFisherPanel.this.r1Index = 0;
            this.c1 = new JLabel(groupNames[0]);
            this.c2 = new JLabel(groupNames[1]);
            this.r1 = new JLabel(binNames[0]);
            this.r2 = new JLabel(binNames[1]);
            JButton colSwapButton = new JButton("Swap Columns");
            colSwapButton.setFocusPainted(false);
            colSwapButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ContingencyMatrixPanel.this.swapCols();
                }
            });
            JButton rowSwapButton = new JButton("Swap Rows");
            rowSwapButton.setFocusPainted(false);
            rowSwapButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ContingencyMatrixPanel.this.swapRows();
                }
            });
            JButton d11 = new JButton(" ");
            d11.setFocusPainted(false);
            d11.setEnabled(false);
            d11.setBackground(Color.gray);
            d11.setOpaque(true);
            d11.setBorder(BorderFactory.createLineBorder(Color.black, 2));
            JButton d12 = new JButton(" ");
            d12.setFocusPainted(false);
            d12.setBorder(BorderFactory.createLineBorder(Color.black, 2));
            d12.setEnabled(false);
            JButton d21 = new JButton(" ");
            d21.setFocusPainted(false);
            d21.setBorder(BorderFactory.createLineBorder(Color.black, 2));
            d21.setEnabled(false);
            JButton d22 = new JButton(" ");
            d22.setFocusPainted(false);
            d22.setBorder(BorderFactory.createLineBorder(Color.black, 2));
            d22.setEnabled(false);
            this.add((Component)new JLabel("<html>The orientation of the 2x2 contingency matrix can be modified.<br>The test reports tail probabilities relative to the upper left cell.<br>(alteration is optional and will not effect the two tailed p-value)</html>"), new GridBagConstraints(0, 0, 4, 1, 1.0, 1.0, 10, 0, new Insets(5, 5, 10, 5), 0, 0));
            this.add((Component)colSwapButton, new GridBagConstraints(2, 1, 2, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 5, 0), 0, 0));
            this.add((Component)this.c1, new GridBagConstraints(2, 2, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 5, 0), 0, 0));
            this.add((Component)this.c2, new GridBagConstraints(3, 2, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 5, 10), 0, 0));
            this.add((Component)rowSwapButton, new GridBagConstraints(0, 3, 1, 2, 1.0, 1.0, 10, 13, new Insets(0, 0, 0, 10), 0, 0));
            this.add((Component)this.r1, new GridBagConstraints(1, 3, 1, 1, 0.0, 1.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.add((Component)d11, new GridBagConstraints(2, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)d12, new GridBagConstraints(3, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 10), 0, 0));
            this.add((Component)this.r2, new GridBagConstraints(1, 4, 1, 1, 0.0, 1.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.add((Component)d21, new GridBagConstraints(2, 4, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)d22, new GridBagConstraints(3, 4, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 10), 0, 0));
        }

        private void swapCols() {
            NonparFisherPanel.this.c1Index = (NonparFisherPanel.this.c1Index + 1) % 2;
            String temp = this.c1.getText();
            this.c1.setText(this.c2.getText());
            this.c2.setText(temp);
            this.validate();
        }

        private void swapRows() {
            NonparFisherPanel.this.r1Index = (NonparFisherPanel.this.r1Index + 1) % 2;
            String temp = this.r1.getText();
            this.r1.setText(this.r2.getText());
            this.r2.setText(temp);
            this.validate();
        }
    }
}

