/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.nonpar;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.GroupNumberAndNameSelectionPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.IWizardParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.StatProcessWizard;

public class NonparFEGroupAndDataBinNamePanel
extends GroupNumberAndNameSelectionPanel
implements IWizardParameterPanel {
    private JTextField binOneNameField;
    private JTextField binTwoNameField;
    private AlgorithmData aData;

    public NonparFEGroupAndDataBinNamePanel(AlgorithmData algData, StatProcessWizard w) {
        super(algData, w, false);
        this.aData = algData;
        this.initialize(true, false, 2);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Select Data Bin Names"));
        JLabel label = new JLabel("Data Bin 1 Label:");
        panel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 15, 25, 10), 0, 0));
        this.binOneNameField = new JTextField("Bin 1");
        Dimension fieldDimension = new Dimension(80, 20);
        this.binOneNameField.setPreferredSize(fieldDimension);
        panel.add((Component)this.binOneNameField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 0, 25, 15), 0, 0));
        label = new JLabel("Data Bin 2 Label:");
        panel.add((Component)label, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 15, 25, 10), 0, 0));
        this.binTwoNameField = new JTextField("Bin 2");
        this.binTwoNameField.setPreferredSize(fieldDimension);
        panel.add((Component)this.binTwoNameField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 0, 25, 15), 0, 0));
        this.add((Component)panel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public NonparFEGroupAndDataBinNamePanel() {
        super(false);
        this.initialize(true, false, 2);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Select Data Bin Names"));
        JLabel label = new JLabel("Data Bin 1 Label:");
        panel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 15, 25, 10), 0, 0));
        this.binOneNameField = new JTextField("Bin 1");
        Dimension fieldDimension = new Dimension(80, 25);
        this.binOneNameField.setPreferredSize(fieldDimension);
        panel.add((Component)this.binOneNameField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 0, 25, 15), 0, 0));
        label = new JLabel("Data Bin 2 Label:");
        panel.add((Component)label, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 15, 25, 10), 0, 0));
        this.binTwoNameField = new JTextField("Bin 2");
        this.binTwoNameField.setPreferredSize(fieldDimension);
        panel.add((Component)this.binTwoNameField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 0, 25, 15), 0, 0));
        this.add((Component)panel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void populateAlgorithmData() {
        super.populateAlgorithmData();
        String[] binNames = new String[]{this.binOneNameField.getText(), this.binTwoNameField.getText()};
        this.aData.addStringArray("fisher-exact-bin-names", binNames);
    }

    @Override
    public void clearValuesFromAlgorithmData() {
        super.clearValuesFromAlgorithmData();
        this.aData.getParams().getMap().remove("fisher-exact-bin-names");
    }

    @Override
    public boolean areGroupAndFactorNamesUnique() {
        int i;
        boolean unique = true;
        String[] groupNames = new String[this.textFieldVector.size() + 1];
        for (i = 0; i < groupNames.length - 1; ++i) {
            groupNames[i] = ((JTextField)this.textFieldVector.get(i)).getText();
        }
        groupNames[groupNames.length - 1] = "Exclude";
        for (i = 0; i < groupNames.length; ++i) {
            for (int j = i + 1; j < groupNames.length; ++j) {
                if (!groupNames[i].equals(groupNames[j])) continue;
                return false;
            }
        }
        String binOneName = this.binOneNameField.getText();
        String binTwoName = this.binTwoNameField.getText();
        if (binOneName == null || binTwoName == null || binOneName.equals(binTwoName)) {
            return false;
        }
        return unique;
    }

    public static void main(String[] args) {
        NonparFEGroupAndDataBinNamePanel p = new NonparFEGroupAndDataBinNamePanel();
        p.setVisible(true);
        JFrame frame = new JFrame();
        frame.getContentPane().add(p);
        frame.setSize(300, 450);
        frame.setVisible(true);
    }
}

