/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.nonpar;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.tigr.graph.GraphElement;
import org.tigr.graph.GraphLine;
import org.tigr.graph.GraphPoint;
import org.tigr.graph.GraphTick;
import org.tigr.graph.GraphViewer;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;

public class NonparFDRDialog
extends AlgorithmDialog {
    private int result = 2;
    private JFrame par;
    private float[] orderedFDR;
    private int[] orderedIndices;
    private GraphPanel graphPanel;
    private ControlPanel controlPanel;
    private int numCaptured;
    private float currFDR;

    public NonparFDRDialog(JFrame parent, float[] fdr, int[] indices) {
        super(parent, "FDR Selection", true);
        this.orderedFDR = fdr;
        this.orderedIndices = indices;
        this.currFDR = 0.0f;
        this.graphPanel = new GraphPanel(this.orderedFDR);
        this.controlPanel = new ControlPanel();
        this.mainPanel = new JPanel(new GridBagLayout());
        this.mainPanel.add((Component)this.graphPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.controlPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        super.addContent(this.mainPanel);
        super.setActionListeners(new Listener());
        this.pack();
    }

    public float getFDRLimit() {
        return this.currFDR;
    }

    public int[] getSelectedIndices() {
        int lastIndex = this.graphPanel.getNumberOfGenesLessThan(this.currFDR) - 1;
        int[] selGenes = new int[lastIndex + 1];
        for (int i = 0; i < selGenes.length; ++i) {
            selGenes[i] = this.orderedIndices[i];
        }
        return selGenes;
    }

    public int[] getNonSelectedIndices() {
        int firstIndex = this.graphPanel.getNumberOfGenesLessThan(this.currFDR);
        int[] nonSelGenes = new int[this.orderedIndices.length - firstIndex];
        int index = 0;
        for (int i = firstIndex; i < this.orderedIndices.length; ++i) {
            nonSelGenes[index] = this.orderedIndices[i];
            ++index;
        }
        return nonSelGenes;
    }

    public void setCurrentFDR(int fdr) {
        this.currFDR = fdr;
    }

    public int showModal() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dim = toolkit.getScreenSize();
        this.setLocation(dim.width / 2 - this.getWidth() / 2, dim.height / 2 - this.getHeight() / 2);
        this.show();
        return this.result;
    }

    public static void main(String[] args) {
        float[] fdr = new float[]{0.01f, 0.02f, 0.04f, 0.05f, 0.1f, 0.3f, 0.5f, 0.8f, 0.9f, 0.98f};
        int[] index = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        NonparFDRDialog d = new NonparFDRDialog(new JFrame(), fdr, index);
        d.showModal();
        d.dispose();
    }

    public class NonparGraphViewer
    extends GraphViewer {
        public NonparGraphViewer(JFrame frame, int startx, int stopx, int starty, int stopy, double graphstartx, double graphstopx, double graphstarty, double graphstopy, int preXSpacing, int postXSpacing, int preYSpacing, int postYSpacing, String title, String xLabel, String yLabel) {
            super(frame, startx, stopx, starty, stopy, graphstartx, graphstopx, graphstarty, graphstopy, preXSpacing, postXSpacing, preYSpacing, postYSpacing, title, xLabel, yLabel);
        }

        public void removeLastGraphElement() {
            this.graphElements.remove(this.graphElements.size() - 1);
            this.repaint();
        }
    }

    public class Listener
    implements ActionListener,
    ChangeListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("zoom-in-command")) {
                NonparFDRDialog.this.graphPanel.zoomIn();
                NonparFDRDialog.this.controlPanel.validateZoomButtons(NonparFDRDialog.this.graphPanel.getZoomLevel());
            } else if (command.equals("zoom-out-command")) {
                NonparFDRDialog.this.graphPanel.zoomOut();
                NonparFDRDialog.this.controlPanel.validateZoomButtons(NonparFDRDialog.this.graphPanel.getZoomLevel());
            } else if (command.equals("ok-command")) {
                NonparFDRDialog.this.result = 0;
                NonparFDRDialog.this.dispose();
            } else if (command.equals("cancel-command")) {
                NonparFDRDialog.this.result = 2;
                NonparFDRDialog.this.dispose();
            } else if (command.equals("reset-command")) {
                NonparFDRDialog.this.graphPanel.resetGraph();
                NonparFDRDialog.this.controlPanel.reset();
            } else if (command.equals("info-command")) {
                // empty if block
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            NonparFDRDialog.this.controlPanel.updateFields();
        }
    }

    public class ControlPanel
    extends JPanel {
        private JSpinner fdrSpinner;
        private JButton inButton;
        private JButton outButton;
        private JTextField selGenesField;
        private JTextField falseGenesField;
        private JTextField currFDRField;

        public ControlPanel() {
            super(new GridBagLayout());
            Listener listener = new Listener();
            JPanel zoomPanel = new JPanel(new GridBagLayout());
            zoomPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Graph Zoom"));
            this.inButton = new JButton("+");
            this.inButton.setBorder(BorderFactory.createBevelBorder(0));
            this.inButton.setFocusPainted(false);
            Dimension buttonDim = new Dimension(25, 25);
            this.inButton.setPreferredSize(buttonDim);
            this.inButton.setSize(buttonDim);
            this.inButton.setActionCommand("zoom-in-command");
            this.inButton.addActionListener(listener);
            this.outButton = new JButton("-");
            this.outButton.setBorder(BorderFactory.createBevelBorder(0));
            this.outButton.setFocusPainted(false);
            this.outButton.setPreferredSize(buttonDim);
            this.outButton.setSize(buttonDim);
            this.outButton.setActionCommand("zoom-out-command");
            this.outButton.setEnabled(false);
            this.outButton.addActionListener(listener);
            zoomPanel.add((Component)this.inButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            zoomPanel.add((Component)this.outButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            JPanel fdrPanel = new JPanel(new GridBagLayout());
            fdrPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "FDR Selection"));
            Dimension fieldDim = new Dimension(70, 20);
            JLabel spinnerLabel = new JLabel("FDR Limit: ");
            spinnerLabel.setOpaque(false);
            this.fdrSpinner = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 1.0, 0.01));
            this.fdrSpinner.addChangeListener(listener);
            this.fdrSpinner.setPreferredSize(fieldDim);
            JLabel calcFDRLabel = new JLabel("Current Est. FDR:");
            this.currFDRField = new JTextField("0");
            this.currFDRField.setPreferredSize(fieldDim);
            this.currFDRField.setEditable(false);
            JLabel numSigLabel = new JLabel("Number of selected genes: ");
            this.selGenesField = new JTextField("0");
            this.selGenesField.setPreferredSize(fieldDim);
            this.selGenesField.setEditable(false);
            JLabel numFalseSigLabel = new JLabel("Est. # of false positive genes: ");
            this.falseGenesField = new JTextField("0");
            this.falseGenesField.setPreferredSize(fieldDim);
            this.falseGenesField.setEditable(false);
            fdrPanel.add((Component)spinnerLabel, new GridBagConstraints(0, 0, 1, 1, 0.5, 1.0, 13, 3, new Insets(5, 5, 5, 5), 0, 0));
            fdrPanel.add((Component)this.fdrSpinner, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 3, new Insets(5, 5, 5, 5), 0, 0));
            fdrPanel.add((Component)calcFDRLabel, new GridBagConstraints(0, 1, 1, 1, 0.5, 1.0, 13, 3, new Insets(5, 5, 5, 5), 0, 0));
            fdrPanel.add((Component)this.currFDRField, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 3, new Insets(5, 5, 5, 5), 0, 0));
            fdrPanel.add((Component)numSigLabel, new GridBagConstraints(0, 2, 1, 1, 0.5, 1.0, 13, 3, new Insets(5, 5, 5, 5), 0, 0));
            fdrPanel.add((Component)this.selGenesField, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 17, 3, new Insets(5, 5, 5, 5), 0, 0));
            fdrPanel.add((Component)numFalseSigLabel, new GridBagConstraints(0, 3, 1, 1, 0.5, 1.0, 13, 3, new Insets(5, 5, 5, 5), 0, 0));
            fdrPanel.add((Component)this.falseGenesField, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 17, 3, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)zoomPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)fdrPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        }

        public void validateZoomButtons(int zoomLevel) {
            this.inButton.setEnabled(zoomLevel < 4);
            this.outButton.setEnabled(zoomLevel > 0);
        }

        public void updateFields() {
            float fdr = (float)((Double)this.fdrSpinner.getValue()).doubleValue();
            NonparFDRDialog.this.currFDR = fdr;
            int numberCaptured = NonparFDRDialog.this.graphPanel.getNumberOfGenesLessThan(fdr);
            this.selGenesField.setText(String.valueOf(numberCaptured));
            if (numberCaptured > 0) {
                this.currFDRField.setText(String.valueOf(NonparFDRDialog.this.orderedFDR[numberCaptured - 1]));
                this.falseGenesField.setText(String.valueOf((int)((float)numberCaptured * NonparFDRDialog.this.orderedFDR[numberCaptured - 1])));
            } else {
                this.currFDRField.setText("0");
                this.falseGenesField.setText(String.valueOf(0));
            }
        }

        public void reset() {
            this.validateZoomButtons(0);
            this.fdrSpinner.setValue(new Double(0.0));
            this.updateFields();
        }
    }

    public class GraphPanel
    extends JPanel {
        private NonparGraphViewer viewer;
        private int zoomLevel;
        private float[] yZoomRange;
        private int[] xZoomRange;
        private GraphLine fdrLine;

        public GraphPanel(float[] fdr) {
            int i;
            super(new GridBagLayout());
            this.zoomLevel = 0;
            this.yZoomRange = new float[]{1.0f, 0.5f, 0.25f, 0.1f, 0.05f};
            this.xZoomRange = new int[5];
            int yLabelSpacing = 40;
            if (fdr.length > 10000) {
                yLabelSpacing = 80;
            } else if (fdr.length > 1000) {
                yLabelSpacing = 60;
            }
            this.viewer = new NonparGraphViewer(NonparFDRDialog.this.par, 0, 100, 0, 100, 0.0, fdr.length, 0.0, 1.0, 50, 30, 30, yLabelSpacing, "FDR", "Count", "FDR");
            int zoomRangeIndex = 4;
            this.xZoomRange[0] = fdr.length;
            for (i = 0; i < fdr.length - 1; ++i) {
                if (!Float.isNaN(fdr[i])) {
                    this.viewer.addGraphElement((GraphElement)new GraphPoint((double)(i + 1), (double)fdr[i], Color.RED, 3));
                    if (!Float.isNaN(fdr[i + 1]) && !Float.isNaN(fdr[i + 1])) {
                        this.viewer.addGraphElement((GraphElement)new GraphLine((double)(i + 1), (double)fdr[i], (double)(i + 2), (double)fdr[i + 1]));
                    }
                    if (zoomRangeIndex > -1 && fdr[i] >= this.yZoomRange[zoomRangeIndex]) {
                        this.xZoomRange[zoomRangeIndex] = i + 1;
                        --zoomRangeIndex;
                    }
                }
                if (Float.isNaN(fdr[fdr.length - 1])) continue;
                this.viewer.addGraphElement((GraphElement)new GraphPoint((double)fdr.length, (double)fdr[fdr.length - 1], Color.RED, 3));
            }
            for (i = 0; i < this.xZoomRange.length; ++i) {
                this.viewer.addGraphElement((GraphElement)new GraphTick((double)this.xZoomRange[i], 3, Color.black, 0, 0, String.valueOf(this.xZoomRange[i]), Color.black));
                this.viewer.addGraphElement((GraphElement)new GraphTick((double)this.yZoomRange[i], 3, Color.black, 1, 0, String.valueOf(this.yZoomRange[i]), Color.black));
            }
            this.fdrLine = new GraphLine(0.0, 0.0, (double)fdr.length, 0.0);
            this.viewer.addGraphElement((GraphElement)this.fdrLine);
            this.viewer.setPointSize(100);
            this.setPreferredSize(new Dimension(300, 300));
            this.setSize(new Dimension(300, 300));
            this.add((Component)((Object)this.viewer), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        }

        public void zoomIn() {
            ++this.zoomLevel;
            this.viewer.setGraphStopX(this.xZoomRange[this.zoomLevel]);
            this.viewer.setGraphStopY(this.yZoomRange[this.zoomLevel]);
            this.viewer.removeLastGraphElement();
            this.fdrLine = NonparFDRDialog.this.currFDR != 0.0f ? new GraphLine(0.0, (double)NonparFDRDialog.this.currFDR, (double)this.xZoomRange[this.zoomLevel], (double)NonparFDRDialog.this.currFDR, Color.orange) : new GraphLine(0.0, (double)NonparFDRDialog.this.currFDR, (double)this.xZoomRange[this.zoomLevel], (double)NonparFDRDialog.this.currFDR, Color.black);
            this.viewer.addGraphElement((GraphElement)this.fdrLine);
            this.viewer.repaint();
        }

        public void zoomOut() {
            --this.zoomLevel;
            this.viewer.setGraphStopX(this.xZoomRange[this.zoomLevel]);
            this.viewer.setGraphStopY(this.yZoomRange[this.zoomLevel]);
            this.viewer.removeLastGraphElement();
            this.fdrLine = NonparFDRDialog.this.currFDR != 0.0f ? new GraphLine(0.0, (double)NonparFDRDialog.this.currFDR, (double)this.xZoomRange[this.zoomLevel], (double)NonparFDRDialog.this.currFDR, Color.orange) : new GraphLine(0.0, (double)NonparFDRDialog.this.currFDR, (double)this.xZoomRange[this.zoomLevel], (double)NonparFDRDialog.this.currFDR, Color.black);
            this.viewer.addGraphElement((GraphElement)this.fdrLine);
            this.viewer.repaint();
        }

        public int getZoomLevel() {
            return this.zoomLevel;
        }

        public int getNumberOfGenesLessThan(float fdr) {
            int numGenes = 0;
            if (NonparFDRDialog.this.orderedFDR.length == 0) {
                return 0;
            }
            while (numGenes <= NonparFDRDialog.this.orderedFDR.length && NonparFDRDialog.this.orderedFDR[numGenes] <= fdr && ++numGenes != NonparFDRDialog.this.orderedFDR.length) {
            }
            this.viewer.removeLastGraphElement();
            this.fdrLine = fdr != 0.0f ? new GraphLine(0.0, (double)fdr, (double)this.xZoomRange[this.zoomLevel], (double)fdr, Color.orange) : new GraphLine(0.0, (double)fdr, (double)this.xZoomRange[this.zoomLevel], (double)fdr, Color.black);
            this.viewer.addGraphElement((GraphElement)this.fdrLine);
            this.viewer.repaint();
            return numGenes;
        }

        public void resetGraph() {
            this.zoomLevel = 1;
            this.zoomOut();
        }
    }
}

