/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.nmf;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.Expression;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;
import org.tigr.util.FloatMatrix;

public class NMFPlotViewer
extends ViewerAdapter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private JComponent content;
    IFramework framework;
    FloatMatrix data;
    String[] labels = new String[]{"no labels"};
    boolean w;
    boolean cophen;
    int[] samplesOrder = new int[0];
    private int r;
    private float minValue;
    private double maxValue;
    static boolean orderedSamples = false;
    protected static final String ORDERED_SAMPLES = "order-samples";

    public NMFPlotViewer(float[] data, boolean w, boolean cophen, int r) {
        this(new float[][]{data}, w, cophen, r);
    }

    public NMFPlotViewer(float[][] data, boolean w, boolean cophen, int r) {
        this(new FloatMatrix(data), w, cophen, r);
    }

    public NMFPlotViewer(FloatMatrix data, boolean w, boolean cophen, int r) {
        this.w = w;
        this.r = r;
        this.cophen = cophen;
        this.data = data;
        this.content = new JPanel();
    }

    @Override
    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{this.data, this.w, this.cophen, this.r});
    }

    @Override
    public void onSelected(IFramework framework) {
        this.framework = framework;
        this.initLabels();
        this.content = this.createContent(this.data.A, this.labels, this.minValue - 0.05f, this.maxValue);
    }

    private void initLabels() {
        int i;
        float minValue = Float.POSITIVE_INFINITY;
        float maxValue = 1.0f;
        for (int i2 = 0; i2 < this.data.A.length; ++i2) {
            for (int j = 0; j < this.data.A[i2].length; ++j) {
                if (this.data.A[i2][j] < minValue) {
                    minValue = this.data.A[i2][j];
                }
                if (!(this.data.A[i2][j] > maxValue)) continue;
                maxValue = this.data.A[i2][j];
            }
        }
        this.minValue = minValue;
        this.maxValue = maxValue;
        if (this.cophen) {
            String[] ccLabels = new String[this.data.A[0].length];
            for (i = 0; i < ccLabels.length; ++i) {
                ccLabels[i] = "Rank = " + (this.r + i);
            }
            this.labels = ccLabels;
        } else if (this.w) {
            this.labels = this.framework.getData().getAnnotationList(this.framework.getData().getAllFilledAnnotationFields()[0]);
        } else {
            String[] strLabels = new String[this.framework.getData().getSampleAnnotationMatrix().length];
            for (i = 0; i < strLabels.length; ++i) {
                strLabels[i] = this.framework.getData().getSampleAnnotationMatrix()[i][0];
            }
            this.labels = strLabels;
        }
        this.samplesOrder = new int[this.labels.length];
    }

    @Override
    public JComponent getContentComponent() {
        return this.content;
    }

    private JComponent createContent(float[][] data, String[] labels, double minValue, double maxValue) {
        return new Plot(data, labels, minValue, maxValue);
    }

    @Override
    public JComponent getRowHeaderComponent() {
        return null;
    }

    public static void main(String[] args) {
        int i;
        float[][] fm = new float[20][20];
        for (i = 0; i < fm.length; ++i) {
            for (int j = 0; j < fm[i].length; ++j) {
                fm[i][j] = 0.0f;
            }
        }
        fm[0][0] = 116.0f;
        fm[1][1] = -33.0f;
        fm[0][1] = 700.0f;
        fm[1][0] = 101.0f;
        for (i = 0; i < fm.length; ++i) {
            fm[i][i] = i;
        }
        fm[0][0] = 20.0f;
        float[][] fa = new float[][]{{0.99f, 0.88f, 0.72f, 0.1f}};
        String[] sa = new String[]{"2 Clusters", "3 Clusters", "4 Clusters", "5 Clusters"};
        NMFPlotViewer pv = new NMFPlotViewer(fa, false, true, 2);
        JDialog jd = new JDialog();
        jd.add(pv.getContentComponent());
        jd.setSize(800, 800);
        jd.setModal(true);
        jd.setVisible(true);
        System.exit(0);
    }

    private class Plot
    extends JPanel {
        private static final long serialVersionUID = 1L;
        protected JPopupMenu popup;
        double maxValue = 1.0;
        double minValue = 0.6;
        Color[] colors;
        private static final int left = 80;
        private static final int top = 40;
        private float[][] data;
        private String[] labels;
        private Font font = new Font("monospaced", 1, 10);

        public Plot(float[][] data, String[] labels, double minValue, double maxValue) {
            this.setBackground(Color.white);
            this.setFont(this.font);
            this.data = data;
            this.labels = labels;
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.colors = new Color[data.length];
            this.fillColors();
            this.orderSamples();
            this.init();
        }

        private void fillColors() {
            Color[] colorOrder = new Color[]{Color.red, Color.green, Color.blue, Color.yellow, Color.ORANGE, Color.black};
            for (int i = 0; i < this.colors.length; ++i) {
                if (i < colorOrder.length) {
                    this.colors[i] = colorOrder[i];
                    continue;
                }
                int red = (int)(Math.random() * 256.0);
                int green = (int)(Math.random() * 256.0);
                int blue = (int)(Math.random() * 256.0);
                this.colors[i] = new Color(red, green, blue);
            }
        }

        @Override
        public void paint(Graphics g) {
            int width;
            int i;
            super.paint(g);
            int plotWidth = this.getWidth() - 160;
            int plotHeight = this.getHeight() - 200;
            if (plotWidth < 5 || plotHeight < 5) {
                return;
            }
            g.setColor(Color.black);
            g.drawRect(80, 40, plotWidth, plotHeight);
            int steps = 10;
            double stepValue = (this.maxValue - this.minValue) / (double)steps;
            if (Double.isNaN(this.maxValue)) {
                return;
            }
            float scale = (float)(this.maxValue - this.minValue);
            double stepY = (double)plotHeight / (double)steps;
            for (int i2 = 1; i2 < steps; ++i2) {
                g.drawLine(80, 40 + (int)Math.round((double)i2 * stepY), 85, 40 + (int)Math.round((double)i2 * stepY));
            }
            double stepX = (double)plotWidth / ((double)this.data[0].length - 1.0);
            for (int i3 = 1; i3 < this.data.length; ++i3) {
                g.drawLine(80 + (int)Math.round((double)i3 * stepX), 40 + plotHeight - 5, 80 + (int)Math.round((double)i3 * stepX), 40 + plotHeight);
            }
            for (int j = 0; j < this.data.length; ++j) {
                int curValue;
                int i4;
                g.setColor(this.colors[j]);
                double factor = plotHeight;
                int prevValue = -((int)Math.round(((double)this.data[j][orderedSamples ? NMFPlotViewer.this.samplesOrder[0] : 0] - this.minValue) * factor / (double)scale));
                int zeroValue = 40 + plotHeight;
                for (i4 = 1; i4 < this.data[j].length; ++i4) {
                    curValue = -((int)Math.round(((double)this.data[j][orderedSamples ? NMFPlotViewer.this.samplesOrder[i4] : i4] - this.minValue) * factor / (double)scale));
                    g.drawLine(80 + (int)Math.round((double)(i4 - 1) * stepX), zeroValue + prevValue, 80 + (int)Math.round((double)i4 * stepX), zeroValue + curValue);
                    prevValue = curValue;
                }
                g.setColor(new Color(0, 0, 128));
                for (i4 = 0; i4 < this.data[j].length; ++i4) {
                    curValue = -((int)Math.round(((double)this.data[j][orderedSamples ? NMFPlotViewer.this.samplesOrder[i4] : i4] - this.minValue) * factor / (double)scale));
                    g.fillOval(80 + (int)Math.round((double)i4 * stepX) - 3, zeroValue + curValue - 3, 6, 6);
                }
            }
            FontMetrics metrics = g.getFontMetrics();
            for (i = 0; i <= steps; ++i) {
                String str = String.valueOf((double)Math.round(100.0 * (this.maxValue - stepValue * (double)i)) / 100.0);
                width = metrics.stringWidth(str);
                g.drawString(str, 70 - width, 40 + (int)Math.round((double)i * stepY) + 5);
            }
            ((Graphics2D)g).rotate(-1.5707963267948966);
            g.setColor(Color.blue);
            for (i = 0; i < this.labels.length; ++i) {
                String str = String.valueOf(this.labels[orderedSamples ? NMFPlotViewer.this.samplesOrder[i] : i]);
                width = metrics.stringWidth(str);
                g.drawString(str, -40 - plotHeight - 10 - width, 85 + (int)Math.round((double)i * stepX));
            }
            ((Graphics2D)g).rotate(1.5707963267948966);
        }

        private void setOrdered() {
            orderedSamples = !orderedSamples;
            Listener listener = new Listener();
            this.popup = this.createJPopupMenu(listener);
        }

        private void orderSamples() {
            int j;
            int i;
            int[] winner = new int[this.data[0].length];
            float[] ratios = new float[this.data[0].length];
            for (i = 0; i < this.data[0].length; ++i) {
                float max = 0.0f;
                for (j = 0; j < this.data.length; ++j) {
                    if (!(this.data[j][i] > max)) continue;
                    max = this.data[j][i];
                    winner[i] = j;
                }
            }
            for (i = 0; i < this.data[0].length; ++i) {
                float minRatio = Float.POSITIVE_INFINITY;
                for (j = 0; j < this.data.length; ++j) {
                    if (i == j || !(this.data[winner[i]][i] / this.data[j][i] < minRatio)) continue;
                    ratios[i] = minRatio = this.data[winner[i]][i] / this.data[j][i];
                }
            }
            int index = 0;
            for (int cluster = 0; cluster < this.data.length; ++cluster) {
                for (int i2 = 0; i2 < NMFPlotViewer.this.samplesOrder.length; ++i2) {
                    if (winner[i2] != cluster) continue;
                    NMFPlotViewer.this.samplesOrder[index] = i2;
                    ++index;
                }
            }
        }

        private void init() {
            Listener listener = new Listener();
            this.popup = this.createJPopupMenu(listener);
            this.addMouseListener(listener);
            this.addMouseMotionListener(listener);
            this.repaint();
        }

        protected JPopupMenu createJPopupMenu(ActionListener listener) {
            JPopupMenu popup = new JPopupMenu();
            this.addMenuItems(popup, listener);
            return popup;
        }

        protected void addMenuItems(JPopupMenu menu, ActionListener listener) {
            JMenuItem menuItem = new JMenuItem("Arrange/reset Samples order", GUIFactory.getIcon("new16.gif"));
            menuItem.setActionCommand(NMFPlotViewer.ORDERED_SAMPLES);
            menuItem.addActionListener(listener);
            menu.add(menuItem);
        }

        private class Listener
        extends MouseAdapter
        implements MouseMotionListener,
        ActionListener {
            private Listener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String command = e.getActionCommand();
                if (command.equals(NMFPlotViewer.ORDERED_SAMPLES)) {
                    Plot.this.setOrdered();
                    Plot.this.repaint();
                }
            }

            @Override
            public void mouseClicked(MouseEvent event) {
                if (SwingUtilities.isRightMouseButton(event)) {
                    return;
                }
            }

            @Override
            public void mouseReleased(MouseEvent event) {
                this.maybeShowPopup(event);
                if (event.isPopupTrigger()) {
                    return;
                }
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    Plot.this.popup.show(e.getComponent(), e.getX(), e.getY());
                    Plot.this.repaint();
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        }
    }
}

