/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.nmf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import java.util.ArrayList;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.tigr.microarray.mev.cluster.ClusterWrapper;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.nmf.NMFExperimentHeader;

public class NMFHCLExperimentViewer
extends JPanel
implements IViewer {
    private static final float INITIAL_MAX_VALUE = 1.0f;
    private static final float INITIAL_MIN_VALUE = 0.0f;
    private static final String NO_GENES_STR = "No Genes in Cluster!";
    private static final Font ERROR_FONT = new Font("monospaced", 1, 20);
    protected static final String STORE_CLUSTER_CMD = "store-cluster-cmd";
    protected static final String AUTO_STORE_GENE_CLUSTERS_CMD = "auto-store-gene-cluster-cmd";
    protected static final String AUTO_STORE_SAMPLE_CLUSTERS_CMD = "auto-store-sample-cluster-cmd";
    protected static final String SET_DEF_COLOR_CMD = "set-def-color-cmd";
    protected static final String SAVE_CLUSTER_CMD = "save-cluster-cmd";
    protected static final String SAVE_ALL_CLUSTERS_CMD = "save-all-clusters-cmd";
    protected static final String LAUNCH_NEW_SESSION_CMD = "launch-new-session-cmd";
    public static final String BROADCAST_MATRIX_GAGGLE_CMD = "broadcast-matrix-to-gaggle";
    public static final String BROADCAST_NAMELIST_GAGGLE_CMD = "broadcast-namelist-to-gaggle";
    private NMFExperimentHeader header;
    private Experiment experiment;
    private IFramework framework;
    private IData data;
    private int clusterIndex = 0;
    private int[][] clusters;
    private int[] samplesOrder;
    private Dimension elementSize = new Dimension(20, 5);
    private int labelIndex = -1;
    private boolean isAntiAliasing = true;
    private boolean isDrawBorders = true;
    private boolean isCompact = false;
    private boolean isAutoArrangeColors = true;
    private boolean isShowRects = true;
    private boolean clickedCell = false;
    private boolean genes = true;
    private int clickedColumn = 0;
    private int clickedRow = 0;
    private boolean isDrawAnnotations = true;
    public static Color missingColor = new Color(128, 128, 128);
    public static Color maskColor = new Color(255, 255, 255, 128);
    private float maxValue = 1.0f;
    private float minValue = 0.0f;
    private float midValue = 0.5f;
    private int firstSelectedRow = -1;
    private int lastSelectedRow = -1;
    private int firstSelectedColumn = -1;
    private int lastSelectedColumn = -1;
    public BufferedImage posColorImage = this.createGradientImage(Color.black, Color.red);
    public BufferedImage negColorImage = this.createGradientImage(Color.blue, Color.black);
    private int annotationWidth;
    private Insets insets = new Insets(0, 10, 0, 0);
    private int contentWidth = 0;
    private boolean useDoubleGradient = true;
    private boolean showClusters = true;
    private boolean haveColorBar = false;
    protected int exptID = 0;
    protected String LabelName;
    private int activeCluster = 0;
    public static ArrayList<Color> storedGeneColors = new ArrayList();
    public static ArrayList<Color> savedGeneColorOrder = new ArrayList();
    private static int[] ColorOverlaps = new int[100000];
    private int colorWidth = 0;
    private int maxColorWidth = 0;
    private boolean mouseOnMap = false;
    private int mouseRow = 0;
    private int mouseColumn = 0;
    protected JPopupMenu popup;
    private boolean inColorbarDrag = false;
    private int dragRow = 0;
    private int dragColumn = 0;
    private boolean enableMoveable;

    public Expression getExpression() {
        return null;
    }

    public NMFHCLExperimentViewer(Experiment experiment, ClusterWrapper clusters, ClusterWrapper samplesOrder, Boolean drawAnnotations, Integer offset, Boolean genes) {
        this(experiment, clusters.getClusters(), samplesOrder.getClusters()[0], (boolean)drawAnnotations, (int)offset, (boolean)genes);
    }

    public NMFHCLExperimentViewer(Experiment experiment, int[][] clusters, int[] samplesOrder, boolean drawAnnotations, int offset, boolean genes) {
        if (experiment == null) {
            throw new IllegalArgumentException("experiment == null");
        }
        this.genes = genes;
        this.experiment = experiment;
        this.exptID = experiment.getId();
        this.clusters = clusters == null ? NMFHCLExperimentViewer.defGenesOrder(experiment.getNumberOfGenes()) : clusters;
        this.samplesOrder = samplesOrder == null ? NMFHCLExperimentViewer.defSamplesOrder(experiment.getNumberOfSamples()) : samplesOrder;
        this.setGenesOrder(samplesOrder);
        this.isDrawAnnotations = drawAnnotations;
        this.header = new NMFExperimentHeader(this.experiment, this.clusters, this.samplesOrder, storedGeneColors, genes);
        this.header.setNegAndPosColorImages(this.negColorImage, this.posColorImage);
        this.insets.left = offset;
        this.header.setLeftInset(offset);
        this.header.setValues(0.0f, 0.5f, 1.0f);
        this.setBackground(Color.white);
        Listener listener = new Listener();
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
        PopupListener popListener = new PopupListener();
        this.popup = this.createJPopupMenu(popListener);
        this.getContentComponent().addMouseListener(popListener);
        this.getHeaderComponent().addMouseListener(popListener);
    }

    public NMFHCLExperimentViewer() {
    }

    public void setInsets(Insets i) {
        this.insets = i;
    }

    public NMFHCLExperimentViewer(Experiment experiment, int[][] clusters, int[] samplesOrder, boolean drawAnnotations, NMFExperimentHeader header, Insets insets) {
        this.insets = insets;
        this.experiment = experiment;
        this.header = header;
        this.clusters = clusters;
        this.samplesOrder = samplesOrder;
        this.isDrawAnnotations = drawAnnotations;
        this.header = header;
        header.setValues(0.0f, 0.5f, 1.0f);
        this.setBackground(Color.white);
        Listener listener = new Listener();
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
        PopupListener popListener = new PopupListener();
        this.popup = this.createJPopupMenu(popListener);
        this.getContentComponent().addMouseListener(popListener);
        this.getHeaderComponent().addMouseListener(popListener);
    }

    public void setExperiment(Experiment e) {
    }

    private static int[] defSamplesOrder(int size) {
        int[] order = new int[size];
        for (int i = 0; i < order.length; ++i) {
            order[i] = i;
        }
        return order;
    }

    private static int[][] defGenesOrder(int size) {
        int[][] order = new int[1][size];
        for (int i = 0; i < order[0].length; ++i) {
            order[0][i] = i;
        }
        return order;
    }

    public void setLeftInset(int leftMargin) {
        this.insets.left = leftMargin;
        this.header.setLeftInset(leftMargin);
    }

    public JComponent getHeaderComponent() {
        return this.header;
    }

    public JComponent getContentComponent() {
        return this;
    }

    public BufferedImage getImage() {
        return null;
    }

    public BufferedImage getPosColorImage() {
        return this.posColorImage;
    }

    public BufferedImage getNegColorImage() {
        return this.negColorImage;
    }

    public Color getMissingColor() {
        return missingColor;
    }

    public void selectRows(int start, int end) {
        this.firstSelectedRow = start;
        this.lastSelectedRow = end;
        this.repaint();
    }

    public void selectColumns(int start, int end) {
        this.firstSelectedColumn = start;
        this.lastSelectedColumn = end;
        this.repaint();
    }

    public void onSelected(IFramework framework) {
        this.header.clusterViewerClicked = false;
        this.header.clickedCell = false;
        this.clickedCell = false;
        this.framework = framework;
        this.data = framework.getData();
        IDisplayMenu menu = framework.getDisplayMenu();
        this.useDoubleGradient = menu.getUseDoubleGradient();
        this.header.setUseDoubleGradient(this.useDoubleGradient);
        Integer userObject = (Integer)framework.getUserObject();
        this.setClusterIndex(userObject == null ? 0 : userObject);
        this.header.setClusterIndex(this.clusterIndex);
        this.labelIndex = menu.getLabelIndex();
        this.setElementSize(menu.getElementSize());
        this.setAntialiasing(menu.isAntiAliasing());
        this.setDrawBorders(menu.isDrawingBorder());
        this.setCompactClusters(menu.isCompactClusters());
        this.setShowRects(menu.isShowRects());
        this.setAutoArrangeColors(!menu.isAutoArrangeColors());
        this.header.setCompactClusters(menu.isCompactClusters());
        this.header.setStoredColors(storedGeneColors);
        if (this.isAutoArrangeColors || this.isCompact) {
            storedGeneColors.clear();
            this.header.clearStoredSampleColors();
        }
        this.haveColorBar = this.showClusters ? this.areProbesColored() : false;
        this.updateSize();
        this.posColorImage = this.createGradientImage(Color.black, Color.red);
        this.negColorImage = this.createGradientImage(Color.blue, Color.black);
        this.useDoubleGradient = menu.getUseDoubleGradient();
        this.header.setNegAndPosColorImages(this.negColorImage, this.posColorImage);
        this.header.setUseDoubleGradient(this.useDoubleGradient);
        this.header.updateSizes(this.header.getSize().width, this.elementSize.width);
        this.header.setData(this.data);
        this.header.setAntiAliasing(menu.isAntiAliasing());
        this.header.updateSizes(this.header.getSize().width, this.elementSize.width);
    }

    public void onMenuChanged(IDisplayMenu menu) {
        this.header.clusterViewerClicked = false;
        this.header.clickedCell = false;
        this.clickedCell = false;
        boolean isAutoArrangeChanged = this.isAutoArrangeColors;
        this.setDrawBorders(menu.isDrawingBorder());
        this.setCompactClusters(menu.isCompactClusters());
        this.setAutoArrangeColors(!menu.isAutoArrangeColors());
        this.setShowRects(menu.isShowRects());
        this.header.isShowRects = this.isShowRects;
        this.header.setCompactClusters(menu.isCompactClusters());
        this.header.setStoredColors(storedGeneColors);
        if (this.isAutoArrangeColors != isAutoArrangeChanged || this.isAutoArrangeColors) {
            storedGeneColors.clear();
            this.header.clearStoredSampleColors();
        }
        this.header.updateSizes(this.header.getSize().width, this.elementSize.width);
        this.updateSize();
        this.posColorImage = this.createGradientImage(Color.black, Color.red);
        this.negColorImage = this.createGradientImage(Color.blue, Color.black);
        this.useDoubleGradient = menu.getUseDoubleGradient();
        this.header.setNegAndPosColorImages(this.negColorImage, this.posColorImage);
        this.header.setUseDoubleGradient(this.useDoubleGradient);
        if (this.elementSize.equals(menu.getElementSize()) && this.labelIndex == menu.getLabelIndex() && this.isAntiAliasing == menu.isAntiAliasing()) {
            return;
        }
        this.setElementSize(menu.getElementSize());
        this.setAntialiasing(menu.isAntiAliasing());
        this.labelIndex = menu.getLabelIndex();
        this.haveColorBar = this.showClusters ? this.areProbesColored() : false;
        this.header.updateSizes(this.header.getSize().width, this.elementSize.width);
        this.updateSize();
        this.header.setAntiAliasing(menu.isAntiAliasing());
        this.header.updateSizes(this.header.getSize().width, this.elementSize.width);
        this.onSelected(this.framework);
    }

    public void onDataChanged(IData data) {
        this.data = data;
        this.header.setData(data);
        this.haveColorBar = this.showClusters ? this.areProbesColored() : false;
        this.updateSize();
        this.repaint();
    }

    public void onDeselected() {
    }

    public void onClosed() {
    }

    public void setClusterIndex(int clusterIndex) {
        this.clusterIndex = clusterIndex;
    }

    public int getClusterIndex() {
        return this.clusterIndex;
    }

    public int[] getCluster() {
        return this.clusters[this.clusterIndex];
    }

    public void setGenesOrder(int[] cluster) {
        this.clusters[this.clusterIndex] = cluster;
    }

    public int[][] getClusters() {
        return this.clusters;
    }

    private int getMultipleArrayDataRow(int clusterArrayRow) {
        return this.experiment.getGeneIndexMappedToData(this.clusters[this.clusterIndex][clusterArrayRow]);
    }

    private int getExperimentRow(int row) {
        return this.clusters[this.clusterIndex][row];
    }

    private int getColumn(int column) {
        return this.samplesOrder[column];
    }

    public Experiment getExperiment() {
        return this.experiment;
    }

    public IData getData() {
        return this.data;
    }

    protected boolean areProbesColored() {
        int[] indices = this.getCluster();
        for (int i = 0; i < indices.length; ++i) {
            if (this.data.getProbeColor(this.getMultipleArrayDataRow(i)) == null) continue;
            return true;
        }
        return false;
    }

    public void setClusterColor(Color color) {
        if (color == null) {
            this.framework.removeCluster(this.getIDataRowIndices(this.getCluster()), this.experiment, 0);
        }
    }

    public void storeCluster() {
        this.framework.storeCluster(this.getIDataRowIndices(this.getCluster()), this.experiment, 0);
        this.onDataChanged(this.data);
        this.updateSize();
    }

    public void autoStoreClusters(int clusterType, int index) {
        this.framework.autoStoreClusters(clusterType, index);
    }

    public Color setHCLClusterColor(int[] clusterIndices, Color color, boolean areGeneIndices) {
        Color clusterColor = null;
        clusterColor = areGeneIndices ? this.framework.storeSubCluster(clusterIndices, this.experiment, 0) : this.framework.storeSubCluster(clusterIndices, this.experiment, 1);
        this.selectColumns(-1, -1);
        this.selectRows(-1, -1);
        this.header.updateSizes(this.getSize().width, this.elementSize.width);
        this.header.repaint();
        this.updateSize();
        this.repaint();
        return clusterColor;
    }

    private int[] getIDataRowIndices(int[] expIndices) {
        int[] dataIndices = new int[expIndices.length];
        for (int i = 0; i < expIndices.length; ++i) {
            dataIndices[i] = this.getMultipleArrayDataRow(i);
        }
        return dataIndices;
    }

    public void saveClusters(Frame frame) throws Exception {
        frame = frame == null ? JOptionPane.getFrameForComponent(this) : frame;
        ExperimentUtil.saveExperiment((Frame)frame, (Experiment)this.getExperiment(), (IData)this.getData(), (int[][])this.getClusters());
    }

    public void saveCluster(Frame frame) throws Exception {
        frame = frame == null ? JOptionPane.getFrameForComponent(this) : frame;
        ExperimentUtil.saveExperiment((Frame)frame, (Experiment)this.getExperiment(), (IData)this.getData(), (int[])this.getCluster());
    }

    public void launchNewSession() {
        this.framework.launchNewMAV(this.getIDataRowIndices(this.getCluster()), this.experiment, "Multiple Experiment Viewer - Cluster Viewer", 0);
    }

    private void setElementSize(Dimension elementSize) {
        this.elementSize = new Dimension(elementSize);
    }

    private void setAntialiasing(boolean value) {
        this.isAntiAliasing = value;
    }

    private void setDrawBorders(boolean value) {
        this.isDrawBorders = value;
    }

    private void setCompactClusters(boolean value) {
        if (value == this.isCompact) {
            return;
        }
        if (value) {
            savedGeneColorOrder.clear();
            for (int i = 0; i < storedGeneColors.size(); ++i) {
                savedGeneColorOrder.add(storedGeneColors.get(i));
            }
            storedGeneColors.clear();
        } else {
            storedGeneColors.clear();
            this.clearColorOverlaps();
            for (int i = 0; i < savedGeneColorOrder.size(); ++i) {
                storedGeneColors.add(savedGeneColorOrder.get(i));
            }
        }
        this.isCompact = value;
    }

    public void setClusters(int[][] mat) {
        this.clusters = new int[mat.length][mat[0].length];
        for (int i = 0; i < mat.length; ++i) {
            for (int j = 0; j < mat[i].length; ++j) {
                this.clusters[i][j] = mat[i][j];
            }
        }
        this.repaint();
        this.updateUI();
    }

    private void setShowRects(boolean value) {
        this.isShowRects = !value;
        this.header.isShowRects = !value;
    }

    private void setAutoArrangeColors(boolean value) {
        this.isAutoArrangeColors = value;
    }

    private void clearColorOverlaps() {
        for (int i = 0; i < ColorOverlaps.length; ++i) {
            NMFHCLExperimentViewer.ColorOverlaps[i] = i;
        }
    }

    public BufferedImage createGradientImage(Color color1, Color color2) {
        BufferedImage image = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(256, 1);
        Graphics2D graphics = image.createGraphics();
        GradientPaint gp = new GradientPaint(0.0f, 0.0f, color1, 255.0f, 0.0f, color2);
        graphics.setPaint(gp);
        graphics.drawRect(0, 0, 255, 1);
        return image;
    }

    private void updateSize() {
        if (this.clusters == null || this.getCluster().length == 0) {
            this.setFont(ERROR_FONT);
            Graphics2D g = (Graphics2D)this.getGraphics();
            FontMetrics metrics = g.getFontMetrics();
            int width = metrics.stringWidth(NO_GENES_STR) + 10;
            int height = metrics.getHeight() + 30;
            this.setSize(width, height);
            this.setPreferredSize(new Dimension(width, height));
            return;
        }
        this.setFont(new Font("monospaced", 0, this.elementSize.height));
        Graphics2D g = (Graphics2D)this.getGraphics();
        int width = this.elementSize.width * this.experiment.getNumberOfSamples() + 1 + this.insets.left;
        if (this.isDrawAnnotations) {
            this.annotationWidth = this.getMaxWidth(g);
            width += 20 + this.annotationWidth;
        }
        if (this.maxColorWidth < this.colorWidth) {
            this.maxColorWidth = this.colorWidth;
        }
        if (this.haveColorBar) {
            width += this.elementSize.width * this.colorWidth + 10;
        }
        this.contentWidth = width;
        int height = this.elementSize.height * this.getCluster().length + 1;
        this.setSize(width, height);
        if (this.header.getSize().width < width) {
            this.setSize(width, height);
            this.setPreferredSize(new Dimension(width, height));
        } else {
            this.setSize(new Dimension(this.header.getSize().width, this.getSize().height));
            this.setPreferredSize(new Dimension(this.header.getSize().width, this.getSize().height));
        }
        if (this.isCompact) {
            this.setSize(width, height);
            this.setPreferredSize(new Dimension(width, height));
        }
        this.header.setHeaderWidth(width);
    }

    private int getMaxWidth(Graphics2D g) {
        if (g == null || this.data == null || this.getCluster() == null) {
            return 0;
        }
        if (this.isAntiAliasing) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        FontMetrics fm = g.getFontMetrics();
        int max = 0;
        for (int i = 0; i < this.getCluster().length; ++i) {
            String str = this.data.getElementAnnotation(this.getMultipleArrayDataRow(i), this.data.getFieldNames()[this.labelIndex]).toString();
            max = Math.max(max, fm.stringWidth(str));
        }
        return max;
    }

    public int getContentWidth() {
        this.updateSize();
        return this.contentWidth;
    }

    private Color getColor(float value) {
        if (Float.isNaN(value)) {
            return missingColor;
        }
        if (this.useDoubleGradient) {
            float maximum = value < this.midValue ? this.minValue : this.maxValue;
            int colorIndex = (int)(255.0f * (value - this.midValue) / (maximum - this.midValue));
            if (colorIndex < 0) {
                colorIndex = -colorIndex;
            }
            int n = colorIndex = colorIndex > 255 ? 255 : colorIndex;
            if (value < this.midValue) {
                return new Color(colorIndex, 0, 0);
            }
            return new Color(0, 0, colorIndex);
        }
        float span = this.maxValue - this.minValue;
        int colorIndex = value <= this.minValue ? 0 : (value >= this.maxValue ? 255 : (int)((value - this.minValue) / span * 255.0f));
        int rgb = this.posColorImage.getRGB(colorIndex, 0);
        return new Color(rgb);
    }

    public ArrayList getStoredColors() {
        return storedGeneColors;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.header != null) {
            this.header.setStoredColors(storedGeneColors);
            this.header.updateSizes(0, this.elementSize.width);
            this.header.repaint();
        }
        int oldWidth = this.colorWidth;
        if (this.data == null) {
            return;
        }
        if (this.elementSize.getHeight() < 1.0) {
            return;
        }
        int samples = this.experiment.getNumberOfSamples();
        if (this.clusters == null || this.getCluster().length == 0) {
            g.setColor(new Color(0, 0, 128));
            g.setFont(ERROR_FONT);
            g.drawString(NO_GENES_STR, 10, 30);
            return;
        }
        Rectangle bounds = g.getClipBounds();
        int top = this.getTopIndex(bounds.y);
        int bottom = this.getBottomIndex(bounds.y + bounds.height, this.getCluster().length);
        int left = this.getLeftIndex(bounds.x);
        int right = this.getRightIndex(bounds.x + bounds.width, samples);
        for (int column = left; column < right; ++column) {
            for (int row = top; row < bottom; ++row) {
                this.fillRectAt(g, row, column);
            }
        }
        Color initColor = g.getColor();
        if (this.genes && this.haveColorBar) {
            this.fillClusterColorPositions(g);
        }
        if (this.isDrawAnnotations) {
            if (this.isAntiAliasing) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            if (right >= samples) {
                String label = "";
                g.setColor(Color.black);
                int uniqX = this.elementSize.width * samples + 10;
                if (this.haveColorBar && !this.isCompact) {
                    uniqX += this.elementSize.width * storedGeneColors.size();
                    this.colorWidth = storedGeneColors.size();
                }
                if (this.isCompact) {
                    int maxSpacesOver = -1;
                    for (int i = 0; i < storedGeneColors.size(); ++i) {
                        if (ColorOverlaps[i] <= maxSpacesOver) continue;
                        maxSpacesOver = ColorOverlaps[i];
                    }
                    this.colorWidth = maxSpacesOver + 1;
                    uniqX += this.elementSize.width * (maxSpacesOver + 1);
                }
                String[] annot = new String[]{""};
                int fieldNamesLength = this.data.getFieldNames().length - 1;
                String[] names = new String[this.experiment.getNumberOfGenes()];
                for (int i = 0; i < names.length; ++i) {
                    names[i] = this.genes ? this.data.getGeneName(this.clusters[0][i]) : this.data.getSampleName(this.clusters[0][i]);
                }
                for (int row = top; row < bottom; ++row) {
                    if (this.labelIndex >= 0) {
                        annot = this.data.getElementAnnotation(this.getMultipleArrayDataRow(row), this.data.getFieldNames()[this.labelIndex]);
                    }
                    int annY = (row + 1) * this.elementSize.height;
                    g.drawString(names[row], uniqX + this.insets.left, annY - 1);
                }
            }
        }
        if (this.mouseOnMap) {
            this.drawRectAt(g, this.mouseRow, this.mouseColumn, Color.white);
            if (this.haveColorBar && this.isShowRects) {
                this.drawClusterRectsAt(g, this.mouseRow, this.mouseColumn, Color.gray);
            }
        }
        this.mouseOnMap = false;
        if (this.clickedCell) {
            g.setColor(Color.red);
            if (!this.isCompact) {
                this.drawClusterRectsAt(g, this.clickedRow, this.clickedColumn, Color.red);
            }
        }
        if (this.inColorbarDrag) {
            g.setColor(Color.blue);
            g.drawRect(this.dragColumn * this.elementSize.width + this.insets.left + 5 - 1, -1, this.elementSize.width, this.elementSize.height * this.getCluster().length + 1);
            this.header.drawClusterHeaderRectsAt(this.dragColumn, Color.blue, true);
        }
        if (this.colorWidth != oldWidth) {
            this.updateSize();
        }
    }

    private void fillRectAt(Graphics g, int row, int column) {
        if (column > this.experiment.getNumberOfSamples() - 1) {
            return;
        }
        int x = column * this.elementSize.width + this.insets.left;
        int y = row * this.elementSize.height;
        boolean mask = this.firstSelectedRow >= 0 && this.lastSelectedRow >= 0 && (row < this.firstSelectedRow || row > this.lastSelectedRow);
        mask = mask || this.firstSelectedColumn >= 0 && this.lastSelectedColumn >= 0 && (column < this.firstSelectedColumn || column > this.lastSelectedColumn);
        g.setColor(this.getColor(this.experiment.get(this.getExperimentRow(row), this.getColumn(column))));
        g.fillRect(x, y, this.elementSize.width, this.elementSize.height);
        if (mask) {
            g.setColor(maskColor);
            g.fillRect(x, y, this.elementSize.width, this.elementSize.height);
        }
        if (this.isDrawBorders) {
            g.setColor(Color.black);
            g.drawRect(x, y, this.elementSize.width - 1, this.elementSize.height - 1);
        }
    }

    private void fillClusterRectAt(Graphics g, int row, int xLoc, Color color) {
        if (color == null) {
            color = Color.white;
        }
        g.setColor(color);
        g.fillRect(xLoc + this.insets.left, row * this.elementSize.height, this.elementSize.width - 1, this.elementSize.height);
    }

    private void fillClusterColorPositions(Graphics g) {
        int samples = this.experiment.getNumberOfSamples();
        Rectangle bounds = g.getClipBounds();
        int top = this.getTopIndex(bounds.y);
        int bottom = this.getBottomIndex(bounds.y + bounds.height, this.getCluster().length);
        int spacesOver = 0;
        for (int row = top; row < bottom; ++row) {
            Color[] colors = this.data.getGeneColorArray(this.getMultipleArrayDataRow(row));
            if (colors == null) continue;
            for (int clusters = 0; clusters < colors.length; ++clusters) {
                if (colors[clusters] == null) continue;
                if (storedGeneColors.contains(colors[clusters])) {
                    this.activeCluster = storedGeneColors.indexOf(colors[clusters]);
                } else {
                    storedGeneColors.add(colors[clusters]);
                    NMFHCLExperimentViewer.ColorOverlaps[this.activeCluster] = this.activeCluster = storedGeneColors.size() - 1;
                    boolean foundit = false;
                    if (!this.isCompact) {
                        foundit = true;
                    }
                    while (!foundit) {
                        for (int i = 0; i < storedGeneColors.size(); ++i) {
                            boolean allClear = true;
                            for (int j = 0; j < storedGeneColors.size(); ++j) {
                                if (ColorOverlaps[j] != i) continue;
                                if (this.data.isColorOverlap(this.getMultipleArrayDataRow(row), colors[clusters], storedGeneColors.get(j), true)) {
                                    allClear = false;
                                    break;
                                }
                                allClear = true;
                            }
                            if (!allClear) continue;
                            NMFHCLExperimentViewer.ColorOverlaps[this.activeCluster] = i;
                            foundit = true;
                            break;
                        }
                        if (!foundit) continue;
                    }
                }
                spacesOver = ColorOverlaps[this.activeCluster];
                int expWidth = samples * this.elementSize.width + 5 + this.elementSize.width * spacesOver;
                this.fillClusterRectAt(g, row, expWidth, colors[clusters]);
            }
        }
    }

    private void drawRectAt(Graphics g, int row, int column, Color color) {
        g.setColor(color);
        if (column >= this.experiment.getNumberOfSamples()) {
            return;
        }
        g.drawRect(column * this.elementSize.width + this.insets.left, row * this.elementSize.height, this.elementSize.width - 1, this.elementSize.height - 1);
    }

    private void drawClusterRectsAt(Graphics g, int row, int column, Color color) {
        g.setColor(color);
        if (column >= this.experiment.getNumberOfSamples()) {
            g.drawRect(this.experiment.getNumberOfSamples() * this.elementSize.width + this.insets.left + 5 - 1, row * this.elementSize.height - 1, this.elementSize.width * this.colorWidth + this.annotationWidth + 8, this.elementSize.height + 1);
            if (this.isCompact) {
                return;
            }
            g.drawRect(column * this.elementSize.width + this.insets.left + 5 - 1, -1, this.elementSize.width, this.elementSize.height * this.getCluster().length + 1);
            this.header.drawClusterHeaderRectsAt(column, color, true);
        } else {
            g.drawRect(this.experiment.getNumberOfSamples() * this.elementSize.width + this.insets.left + 5 - 1, row * this.elementSize.height - 1, this.elementSize.width * this.colorWidth + this.annotationWidth + 8, this.elementSize.height + 1);
            this.header.drawClusterHeaderRectsAt(column, color, false);
        }
    }

    private int getTopIndex(int top) {
        if (top < 0) {
            return 0;
        }
        return top / this.elementSize.height;
    }

    private int getLeftIndex(int left) {
        if (left < this.insets.left) {
            return 0;
        }
        return (left - this.insets.left) / this.elementSize.width;
    }

    private int getRightIndex(int right, int limit) {
        if (right < 0) {
            return 0;
        }
        int result = right / this.elementSize.width + 1;
        return result > limit ? limit : result;
    }

    private int getBottomIndex(int bottom, int limit) {
        if (bottom < 0) {
            return 0;
        }
        int result = bottom / this.elementSize.height + 1;
        return result > limit ? limit : result;
    }

    private int findColumn(int targetx) {
        int xSize = this.experiment.getNumberOfSamples() * this.elementSize.width;
        if (targetx < this.insets.left) {
            return -1;
        }
        if (targetx >= xSize + this.insets.left && targetx < xSize + this.insets.left + this.elementSize.width * this.colorWidth + 10) {
            return (targetx - this.insets.left - 5) / this.elementSize.width;
        }
        return (targetx - this.insets.left) / this.elementSize.width;
    }

    private int findRow(int targety) {
        int ySize = this.getCluster().length * this.elementSize.height;
        if (targety >= ySize || targety < 0) {
            return -1;
        }
        return targety / this.elementSize.height;
    }

    private boolean isLegalPosition(int row, int column) {
        return this.isLegalRow(row) && this.isLegalColumn(column);
    }

    private boolean isLegalColumn(int column) {
        return column >= 0 && column <= this.experiment.getNumberOfSamples() - 1 + this.colorWidth;
    }

    private boolean isLegalRow(int row) {
        return row >= 0 && row <= this.getCluster().length - 1;
    }

    protected void addMenuItems(JPopupMenu menu, ActionListener listener) {
        JMenuItem menuItem = new JMenuItem("Store entire cluster", GUIFactory.getIcon("new16.gif"));
        menuItem.setActionCommand(STORE_CLUSTER_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Store clusters by gene annotation", GUIFactory.getIcon("new16.gif"));
        menuItem.setActionCommand(AUTO_STORE_GENE_CLUSTERS_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Store clusters by sample annotation", GUIFactory.getIcon("new16.gif"));
        menuItem.setActionCommand(AUTO_STORE_SAMPLE_CLUSTERS_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Launch new session", GUIFactory.getIcon("launch_new_mav.gif"));
        menuItem.setActionCommand(LAUNCH_NEW_SESSION_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Delete public cluster", GUIFactory.getIcon("delete16.gif"));
        menuItem.setActionCommand(SET_DEF_COLOR_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Save cluster...", GUIFactory.getIcon("save16.gif"));
        menuItem.setActionCommand(SAVE_CLUSTER_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Save all clusters...", GUIFactory.getIcon("save16.gif"));
        menuItem.setActionCommand(SAVE_ALL_CLUSTERS_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Broadcast Matrix to Gaggle", GUIFactory.getIcon("gaggle_icon_16.gif"));
        menuItem.setActionCommand(BROADCAST_MATRIX_GAGGLE_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Broadcast Gene List to Gaggle", GUIFactory.getIcon("gaggle_icon_16.gif"));
        menuItem.setActionCommand(BROADCAST_NAMELIST_GAGGLE_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public JComponent getCornerComponent(int cornerIndex) {
        return null;
    }

    public int getViewerType() {
        return 0;
    }

    public int getExperimentID() {
        return this.exptID;
    }

    public void setExperimentID(int id) {
        this.exptID = id;
    }

    public void broadcastClusterGaggle() {
        int[] temp = this.getCluster();
        Experiment e = this.getExperiment();
        if (temp == null) {
            System.out.println("getCluster returns null");
        }
        if (e == null) {
            System.out.println("getExperiment returns null");
        }
        if (this.framework == null) {
            System.out.println(this.toString() + ": framework is null");
        }
        this.framework.broadcastGeneCluster(this.getExperiment(), this.getCluster(), null);
    }

    public void broadcastNamelistGaggle() {
        this.framework.broadcastNamelist(this.getExperiment(), this.getCluster());
    }

    public void setFramework(IFramework framework) {
        this.framework = framework;
    }

    protected JPopupMenu createJPopupMenu(ActionListener listener) {
        JPopupMenu popup = new JPopupMenu();
        this.addMenuItems(popup, listener);
        return popup;
    }

    protected void onSaveClusters() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            this.saveClusters(frame);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(frame, "Can not save clusters!", e.toString(), 0);
            e.printStackTrace();
        }
    }

    protected void onSaveCluster() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            this.saveCluster(frame);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(frame, "Can not save cluster!", e.toString(), 0);
            e.printStackTrace();
        }
    }

    protected void onSetColor() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        Color newColor = JColorChooser.showDialog(frame, "Choose color", CentroidViewer.DEF_CLUSTER_COLOR);
        if (newColor != null) {
            this.setClusterColor(newColor);
        }
    }

    protected void onSetDefaultColor() {
        this.setClusterColor(null);
    }

    public int[] getSamplesOrder() {
        return this.samplesOrder;
    }

    public void setSamplesOrder(int[] samplesOrder) {
        this.samplesOrder = samplesOrder;
    }

    public void setEnableMoveable(boolean enableMoveable) {
        this.enableMoveable = enableMoveable;
        ((NMFExperimentHeader)this.getHeaderComponent()).setEnableMoveable(enableMoveable);
    }

    public class PopupListener
    extends MouseAdapter
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals(NMFHCLExperimentViewer.SAVE_CLUSTER_CMD)) {
                NMFHCLExperimentViewer.this.onSaveCluster();
            } else if (command.equals(NMFHCLExperimentViewer.SAVE_ALL_CLUSTERS_CMD)) {
                NMFHCLExperimentViewer.this.onSaveClusters();
            } else if (command.equals(NMFHCLExperimentViewer.STORE_CLUSTER_CMD)) {
                NMFHCLExperimentViewer.this.storeCluster();
            } else if (command.equals(NMFHCLExperimentViewer.AUTO_STORE_GENE_CLUSTERS_CMD)) {
                NMFHCLExperimentViewer.this.autoStoreClusters(0, NMFHCLExperimentViewer.this.labelIndex);
            } else if (command.equals(NMFHCLExperimentViewer.AUTO_STORE_SAMPLE_CLUSTERS_CMD)) {
                NMFHCLExperimentViewer.this.autoStoreClusters(1, 0);
            } else if (command.equals(NMFHCLExperimentViewer.SET_DEF_COLOR_CMD)) {
                NMFHCLExperimentViewer.this.onSetDefaultColor();
            } else if (command.equals(NMFHCLExperimentViewer.LAUNCH_NEW_SESSION_CMD)) {
                NMFHCLExperimentViewer.this.launchNewSession();
            } else if (command.equals(NMFHCLExperimentViewer.BROADCAST_MATRIX_GAGGLE_CMD)) {
                NMFHCLExperimentViewer.this.broadcastClusterGaggle();
            } else if (command.equals(NMFHCLExperimentViewer.BROADCAST_NAMELIST_GAGGLE_CMD)) {
                NMFHCLExperimentViewer.this.broadcastNamelistGaggle();
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            this.maybeShowPopup(event);
            NMFHCLExperimentViewer.this.repaint();
        }

        @Override
        public void mousePressed(MouseEvent event) {
            this.maybeShowPopup(event);
            NMFHCLExperimentViewer.this.repaint();
        }

        private void maybeShowPopup(MouseEvent e) {
            if (!e.isPopupTrigger() || NMFHCLExperimentViewer.this.getCluster() == null || NMFHCLExperimentViewer.this.getCluster().length == 0) {
                return;
            }
            NMFHCLExperimentViewer.this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private class Listener
    extends MouseAdapter
    implements MouseMotionListener {
        private String oldStatusText;
        private int oldRow = -1;
        private int oldColumn = -1;
        private int startColumn = 0;
        private int startRow = 0;

        private Listener() {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (SwingUtilities.isRightMouseButton(event)) {
                return;
            }
            int column = NMFHCLExperimentViewer.this.findColumn(event.getX());
            int row = NMFHCLExperimentViewer.this.findRow(event.getY());
            if (!NMFHCLExperimentViewer.this.isLegalPosition(row, column)) {
                return;
            }
            if (column > NMFHCLExperimentViewer.this.experiment.getNumberOfSamples() - 1) {
                if (row == NMFHCLExperimentViewer.this.clickedRow && column == NMFHCLExperimentViewer.this.clickedColumn) {
                    NMFHCLExperimentViewer.this.clickedCell = !NMFHCLExperimentViewer.this.clickedCell;
                    ((NMFHCLExperimentViewer)NMFHCLExperimentViewer.this).header.clusterViewerClicked = NMFHCLExperimentViewer.this.clickedCell;
                    return;
                }
                NMFHCLExperimentViewer.this.clickedRow = row;
                NMFHCLExperimentViewer.this.clickedColumn = column;
                NMFHCLExperimentViewer.this.clickedCell = true;
                ((NMFHCLExperimentViewer)NMFHCLExperimentViewer.this).header.clusterViewerClickedColumn = column;
                ((NMFHCLExperimentViewer)NMFHCLExperimentViewer.this).header.clusterViewerClicked = true;
                if (NMFHCLExperimentViewer.this.isCompact) {
                    NMFHCLExperimentViewer.this.clickedCell = false;
                    ((NMFHCLExperimentViewer)NMFHCLExperimentViewer.this).header.clusterViewerClicked = false;
                }
                NMFHCLExperimentViewer.this.repaint();
                return;
            }
            if (!event.isShiftDown()) {
                NMFHCLExperimentViewer.this.framework.displaySlideElementInfo(NMFHCLExperimentViewer.this.experiment.getSampleIndex(NMFHCLExperimentViewer.this.getColumn(column)), NMFHCLExperimentViewer.this.getMultipleArrayDataRow(row));
                return;
            }
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            if (NMFHCLExperimentViewer.this.experiment.getNumberOfSamples() == 0 || event.isShiftDown()) {
                return;
            }
            int column = NMFHCLExperimentViewer.this.findColumn(event.getX());
            int row = NMFHCLExperimentViewer.this.findRow(event.getY());
            Graphics g = null;
            g = NMFHCLExperimentViewer.this.getGraphics();
            if (this.isCurrentPosition(row, column)) {
                if (NMFHCLExperimentViewer.this.isLegalPosition(row, column) && NMFHCLExperimentViewer.this.isShowRects) {
                    NMFHCLExperimentViewer.this.drawClusterRectsAt(g, this.oldRow, this.oldColumn, Color.gray);
                }
                return;
            }
            if (NMFHCLExperimentViewer.this.isLegalPosition(row, column) && column < NMFHCLExperimentViewer.this.experiment.getNumberOfSamples()) {
                NMFHCLExperimentViewer.this.drawRectAt(g, row, column, Color.white);
                if (NMFHCLExperimentViewer.this.isShowRects) {
                    NMFHCLExperimentViewer.this.drawClusterRectsAt(g, row, column, Color.gray);
                }
                String statusText = NMFHCLExperimentViewer.this.genes ? "Gene #1: " + NMFHCLExperimentViewer.this.data.getUniqueId(NMFHCLExperimentViewer.this.getMultipleArrayDataRow(row)) + " Gene #2: " + NMFHCLExperimentViewer.this.data.getUniqueId(NMFHCLExperimentViewer.this.getMultipleArrayDataRow(column)) + " Value: " + (1.0f - NMFHCLExperimentViewer.this.experiment.get(NMFHCLExperimentViewer.this.getExperimentRow(row), NMFHCLExperimentViewer.this.getColumn(column))) : "Sample #1: " + NMFHCLExperimentViewer.this.data.getSampleName(NMFHCLExperimentViewer.this.experiment.getSampleIndex(NMFHCLExperimentViewer.this.getColumn(row))) + " Sample #2: " + NMFHCLExperimentViewer.this.data.getSampleName(NMFHCLExperimentViewer.this.experiment.getSampleIndex(NMFHCLExperimentViewer.this.getColumn(column))) + " Value: " + (1.0f - NMFHCLExperimentViewer.this.experiment.get(NMFHCLExperimentViewer.this.getExperimentRow(row), NMFHCLExperimentViewer.this.getColumn(column)));
                NMFHCLExperimentViewer.this.framework.setStatusText(statusText);
            }
            if (!this.isCurrentPosition(row, column) && NMFHCLExperimentViewer.this.isLegalPosition(row, column)) {
                NMFHCLExperimentViewer.this.mouseOnMap = true;
                NMFHCLExperimentViewer.this.mouseRow = row;
                NMFHCLExperimentViewer.this.mouseColumn = column;
                NMFHCLExperimentViewer.this.repaint();
            } else {
                NMFHCLExperimentViewer.this.repaint();
                NMFHCLExperimentViewer.this.framework.setStatusText(this.oldStatusText);
            }
            if (NMFHCLExperimentViewer.this.isLegalPosition(this.oldRow, this.oldColumn)) {
                g = g != null ? g : NMFHCLExperimentViewer.this.getGraphics();
                NMFHCLExperimentViewer.this.fillRectAt(g, this.oldRow, this.oldColumn);
            }
            this.setOldPosition(row, column);
            if (g != null) {
                g.dispose();
            }
        }

        @Override
        public void mouseEntered(MouseEvent event) {
            try {
                this.oldStatusText = NMFHCLExperimentViewer.this.framework.getStatusText();
            }
            catch (NullPointerException npe) {
                npe.printStackTrace();
            }
        }

        @Override
        public void mouseExited(MouseEvent event) {
            NMFHCLExperimentViewer.this.mouseOnMap = false;
            NMFHCLExperimentViewer.this.header.setDrag(false, 0, 0);
            NMFHCLExperimentViewer.this.inColorbarDrag = false;
            NMFHCLExperimentViewer.this.repaint();
            if (NMFHCLExperimentViewer.this.isLegalPosition(this.oldRow, this.oldColumn)) {
                Graphics g = NMFHCLExperimentViewer.this.getGraphics();
                NMFHCLExperimentViewer.this.fillRectAt(g, this.oldRow, this.oldColumn);
                g.dispose();
            }
            this.setOldPosition(-1, -1);
            NMFHCLExperimentViewer.this.framework.setStatusText(this.oldStatusText);
            NMFHCLExperimentViewer.this.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            NMFHCLExperimentViewer.this.repaint();
            if (SwingUtilities.isRightMouseButton(event)) {
                return;
            }
            int column = NMFHCLExperimentViewer.this.findColumn(event.getX());
            int row = NMFHCLExperimentViewer.this.findRow(event.getY());
            if (!NMFHCLExperimentViewer.this.isLegalPosition(row, column)) {
                NMFHCLExperimentViewer.this.inColorbarDrag = false;
                NMFHCLExperimentViewer.this.header.setDrag(false, 0, 0);
                return;
            }
            if (!NMFHCLExperimentViewer.this.inColorbarDrag) {
                return;
            }
            NMFHCLExperimentViewer.this.dragColumn = column;
            NMFHCLExperimentViewer.this.dragRow = row;
            NMFHCLExperimentViewer.this.header.setDrag(true, NMFHCLExperimentViewer.this.dragColumn, NMFHCLExperimentViewer.this.dragRow);
            if (column < NMFHCLExperimentViewer.this.experiment.getNumberOfSamples()) {
                NMFHCLExperimentViewer.this.inColorbarDrag = false;
                NMFHCLExperimentViewer.this.header.setDrag(false, 0, 0);
            }
        }

        @Override
        public void mousePressed(MouseEvent event) {
            if (SwingUtilities.isRightMouseButton(event)) {
                return;
            }
            this.startColumn = NMFHCLExperimentViewer.this.findColumn(event.getX());
            this.startRow = NMFHCLExperimentViewer.this.findRow(event.getY());
            if (!NMFHCLExperimentViewer.this.isLegalPosition(this.startRow, this.startColumn) || event.isShiftDown() || this.startColumn < NMFHCLExperimentViewer.this.experiment.getNumberOfSamples()) {
                return;
            }
            NMFHCLExperimentViewer.this.inColorbarDrag = true;
            NMFHCLExperimentViewer.this.dragColumn = this.startColumn;
            NMFHCLExperimentViewer.this.dragRow = this.startRow;
            NMFHCLExperimentViewer.this.header.setDrag(true, this.startColumn, this.startRow);
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if (!NMFHCLExperimentViewer.this.inColorbarDrag) {
                return;
            }
            NMFHCLExperimentViewer.this.inColorbarDrag = false;
            NMFHCLExperimentViewer.this.header.setDrag(false, 0, 0);
            int endColumn = NMFHCLExperimentViewer.this.findColumn(event.getX());
            if (endColumn < NMFHCLExperimentViewer.this.experiment.getNumberOfSamples()) {
                return;
            }
            int endRow = NMFHCLExperimentViewer.this.findRow(event.getY());
            if (!NMFHCLExperimentViewer.this.isLegalPosition(this.startRow, this.startColumn)) {
                return;
            }
            if (!NMFHCLExperimentViewer.this.isCompact) {
                Color inter = storedGeneColors.get(this.startColumn - NMFHCLExperimentViewer.this.experiment.getNumberOfSamples());
                storedGeneColors.remove(this.startColumn - NMFHCLExperimentViewer.this.experiment.getNumberOfSamples());
                storedGeneColors.add(endColumn - NMFHCLExperimentViewer.this.experiment.getNumberOfSamples(), inter);
                NMFHCLExperimentViewer.this.repaint();
            } else {
                for (int j = 0; j < storedGeneColors.size(); ++j) {
                    if (ColorOverlaps[j] == this.startColumn - NMFHCLExperimentViewer.this.experiment.getNumberOfSamples()) {
                        ColorOverlaps[j] = -1;
                    }
                    if (ColorOverlaps[j] == endColumn - NMFHCLExperimentViewer.this.experiment.getNumberOfSamples()) {
                        ColorOverlaps[j] = this.startColumn - NMFHCLExperimentViewer.this.experiment.getNumberOfSamples();
                    }
                    if (ColorOverlaps[j] != -1) continue;
                    ColorOverlaps[j] = endColumn - NMFHCLExperimentViewer.this.experiment.getNumberOfSamples();
                }
                NMFHCLExperimentViewer.this.repaint();
            }
        }

        private void setOldPosition(int row, int column) {
            this.oldColumn = column;
            this.oldRow = row;
        }

        private boolean isCurrentPosition(int row, int column) {
            return row == this.oldRow && column == this.oldColumn;
        }
    }
}

