/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.nmf;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLGUI;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeData;
import org.tigr.microarray.mev.cluster.gui.impl.nmf.NMFDialog;
import org.tigr.microarray.mev.cluster.gui.impl.nmf.NMFExperimentCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.nmf.NMFExperimentClusterViewer;
import org.tigr.microarray.mev.cluster.gui.impl.nmf.NMFFactorViewer;
import org.tigr.microarray.mev.cluster.gui.impl.nmf.NMFHCLViewer;
import org.tigr.microarray.mev.cluster.gui.impl.nmf.NMFInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.nmf.NMFPlotViewer;
import org.tigr.microarray.mev.cluster.gui.impl.nmf.NMFProgress;
import org.tigr.microarray.mev.script.scriptGUI.IScriptGUI;
import org.tigr.util.FloatMatrix;

public class NMFGUI
implements IClusterGUI,
IScriptGUI {
    protected Algorithm algorithm;
    protected IFramework framework;
    protected NMFProgress progressBar;
    protected Experiment experiment;
    protected Experiment[] connectivityMatrix;
    FloatMatrix[][] W;
    FloatMatrix[][] H;
    float[][] costs;
    protected int[][][] clusters = new int[0][][];
    protected FloatMatrix[] means;
    protected FloatMatrix[] variances;
    private float[] cophen = new float[0];
    protected IData data;
    int rvalue;
    int maxrvalue;
    int numRuns;
    int maxIters;
    int checkFreq;
    boolean divergence;
    boolean doSamples;
    boolean storeClusters;
    boolean multiClusters;
    boolean expScale;
    boolean doMax;
    boolean adjustData;
    float cutoff;
    long randomSeed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework framework) throws AlgorithmException {
        this.framework = framework;
        this.experiment = framework.getData().getExperiment();
        this.data = framework.getData();
        NMFDialog initNMF = new NMFDialog((JFrame)framework.getFrame());
        if (initNMF.showModal() == 2) {
            return null;
        }
        Listener listener = new Listener();
        try {
            long time;
            this.algorithm = framework.getAlgorithmFactory().getAlgorithm("NMF");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            this.progressBar = new NMFProgress(framework.getFrame(), "Running NMF Analysis", listener);
            this.progressBar.show();
            AlgorithmData data = new AlgorithmData();
            this.rvalue = initNMF.getRValue();
            this.maxrvalue = initNMF.getMaxRValue();
            this.numRuns = initNMF.getNumRuns();
            this.maxIters = initNMF.getMaxIterations();
            this.checkFreq = initNMF.getCheckFreq();
            this.divergence = initNMF.getDivergence();
            this.doSamples = initNMF.isClusterSamples();
            this.expScale = initNMF.isExpScale();
            this.doMax = initNMF.isDoMaxIters();
            this.cutoff = initNMF.getCutoff();
            this.adjustData = initNMF.isAdjustData();
            this.storeClusters = initNMF.isStoreClusters();
            this.multiClusters = initNMF.isMultiRank();
            this.randomSeed = initNMF.getRandomSeed();
            int numFactorRuns = 1 + this.maxrvalue - this.rvalue;
            this.connectivityMatrix = new Experiment[numFactorRuns];
            this.W = new FloatMatrix[numFactorRuns][];
            this.H = new FloatMatrix[numFactorRuns][];
            this.costs = new float[numFactorRuns][];
            this.clusters = new int[numFactorRuns][][];
            this.means = new FloatMatrix[numFactorRuns];
            this.variances = new FloatMatrix[numFactorRuns];
            this.cophen = new float[numFactorRuns];
            data.addMatrix("experiment", this.experiment.getMatrix());
            data.addParam("r-value", String.valueOf(this.rvalue));
            data.addParam("min- r-value", String.valueOf(this.rvalue));
            data.addParam("max- r-value", String.valueOf(this.maxrvalue));
            data.addParam("runs", String.valueOf(this.numRuns));
            data.addParam("iterations", String.valueOf(this.maxIters));
            data.addParam("checkFreq", String.valueOf(this.checkFreq));
            data.addParam("divergence", String.valueOf(this.divergence));
            data.addParam("doSamples", String.valueOf(this.doSamples));
            data.addParam("expScale", String.valueOf(this.expScale));
            data.addParam("doMax", String.valueOf(this.doMax));
            data.addParam("cutoff", String.valueOf(this.cutoff));
            data.addParam("adjustData", String.valueOf(this.adjustData));
            data.addParam("multiClusters", String.valueOf(this.multiClusters));
            data.addParam("randomSeed", String.valueOf(this.randomSeed));
            long start = System.currentTimeMillis();
            data.addParam("startTime", String.valueOf(start));
            Cluster[] result_cluster = new Cluster[1 + this.maxrvalue - this.rvalue];
            for (int factorIndex = 0; factorIndex <= this.maxrvalue - this.rvalue; ++factorIndex) {
                int i;
                data.addParam("r-value", String.valueOf(this.rvalue + factorIndex));
                AlgorithmData result = this.algorithm.execute(data);
                result_cluster[factorIndex] = result.getCluster("cluster");
                this.clusters[factorIndex] = result.getIntMatrix("clusters");
                this.means[factorIndex] = result.getMatrix("clusters_means");
                this.variances[factorIndex] = result.getMatrix("clusters_variances");
                this.cophen[factorIndex] = result.getParams().getFloat("cophen");
                if (this.storeClusters) {
                    this.storeClusters(this.clusters[factorIndex], this.rvalue + factorIndex);
                }
                this.connectivityMatrix[factorIndex] = new Experiment(result.getMatrix("connectivity-matrix"), this.doSamples ? this.experiment.getColumns() : this.experiment.getRows());
                this.W[factorIndex] = new FloatMatrix[this.numRuns];
                this.H[factorIndex] = new FloatMatrix[this.numRuns];
                for (i = 0; i < this.numRuns; ++i) {
                    this.W[factorIndex][i] = result.getMatrix("W" + i);
                }
                for (i = 0; i < this.numRuns; ++i) {
                    this.H[factorIndex][i] = result.getMatrix("H" + i);
                }
                this.costs[factorIndex] = result.getMatrix((String)"costs").transpose().A[0];
                this.adjustData = result.getParams().getBoolean("adjustData");
            }
            GeneralInfo info = new GeneralInfo();
            info.time = time = System.currentTimeMillis() - start;
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(result_cluster, info);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
            if (this.progressBar != null) {
                this.progressBar.dispose();
            }
        }
    }

    private void storeClusters(int[][] clusters, int rank) {
        for (int i = 0; i < clusters.length; ++i) {
            this.framework.storeClusterWithoutDialog(clusters[i], "Algorithm", "NMF, Rank " + rank + " - Cluster " + (i + 1), "NMF, Rank " + rank, "Cluster " + Integer.toString(i + 1), null, 1);
        }
    }

    public AlgorithmData getScriptParameters(IFramework framework) {
        this.experiment = framework.getData().getExperiment();
        NMFDialog NMFDialog2 = new NMFDialog((JFrame)framework.getFrame());
        if (NMFDialog2.showModal() == 2) {
            return null;
        }
        IDistanceMenu menu = framework.getDistanceMenu();
        int function = menu.getDistanceFunction();
        if (function == 0) {
            function = 1;
        }
        AlgorithmData data = new AlgorithmData();
        data.addParam("name", "NMF");
        data.addParam("alg-type", "cluster-genes");
        data.addParam("output-class", "partition-output");
        String[] outputNodes = new String[]{"Significant Genes", "Non-significant Genes"};
        data.addStringArray("output-nodes", outputNodes);
        return data;
    }

    public DefaultMutableTreeNode executeScript(IFramework framework, AlgorithmData algData, Experiment experiment) throws AlgorithmException {
        this.experiment = experiment;
        this.data = framework.getData();
        return null;
    }

    protected DefaultMutableTreeNode createResultTree(Cluster[] clusterResult, GeneralInfo info) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("NMF");
        this.addResultNodes(root, clusterResult, info);
        return root;
    }

    protected void addResultNodes(DefaultMutableTreeNode root, Cluster[] clusterResult, GeneralInfo info) {
        if (this.doSamples) {
            if (this.multiClusters) {
                this.addCopheneticCorrelationCoefficientGraph(root);
                DefaultMutableTreeNode[] factorRoot = new DefaultMutableTreeNode[clusterResult.length];
                for (int i = 0; i < clusterResult.length; ++i) {
                    factorRoot[i] = new DefaultMutableTreeNode("Rank " + (this.rvalue + i) + " NMF");
                    factorRoot[i].add(new DefaultMutableTreeNode("Cophenetic Correlation = " + this.cophen[i]));
                    this.addConsensusMatrix(factorRoot[i], clusterResult[i], info, i);
                    this.addExpressionImages(factorRoot[i], i);
                    this.addCentroidViews(factorRoot[i], i);
                    this.addTableViews(factorRoot[i], i);
                    this.addClusterInfo(factorRoot[i], i);
                    this.addWHFactors(factorRoot[i], i);
                    root.add(factorRoot[i]);
                }
            } else {
                root.add(new DefaultMutableTreeNode("Cophenetic Correlation = " + this.cophen[0]));
                this.addConsensusMatrix(root, clusterResult[0], info, 0);
                this.addExpressionImages(root, 0);
                this.addCentroidViews(root, 0);
                this.addTableViews(root, 0);
                this.addClusterInfo(root, 0);
                this.addWHFactors(root, 0);
            }
        } else if (this.multiClusters) {
            this.addCopheneticCorrelationCoefficientGraph(root);
            DefaultMutableTreeNode[] factorRoot = new DefaultMutableTreeNode[clusterResult.length];
            for (int i = 0; i < clusterResult.length; ++i) {
                factorRoot[i] = new DefaultMutableTreeNode("Rank " + (this.rvalue + i) + " NMF");
                factorRoot[i].add(new DefaultMutableTreeNode("Cophenetic Correlation = " + this.cophen[i]));
                this.addConsensusMatrix(factorRoot[i], clusterResult[i], info, i);
                this.addExpressionImages(factorRoot[i], i);
                this.addCentroidViews(factorRoot[i], i);
                this.addTableViews(factorRoot[i], i);
                this.addClusterInfo(factorRoot[i], i);
                this.addWHFactors(factorRoot[i], i);
                root.add(factorRoot[i]);
            }
        } else {
            root.add(new DefaultMutableTreeNode("Cophenetic Correlation = " + this.cophen[0]));
            this.addConsensusMatrix(root, clusterResult[0], info, 0);
            this.addExpressionImages(root, 0);
            this.addCentroidViews(root, 0);
            this.addTableViews(root, 0);
            this.addClusterInfo(root, 0);
            this.addWHFactors(root, 0);
        }
        this.addGeneralInfo(root, info);
    }

    private void addCopheneticCorrelationCoefficientGraph(DefaultMutableTreeNode root) {
        root.add(new DefaultMutableTreeNode(new LeafInfo("Cophenetic Correlation Graph", (IViewer)new NMFPlotViewer(this.cophen, false, true, this.rvalue))));
    }

    private void addWHFactors(DefaultMutableTreeNode root, int factorIndex) {
        int i;
        DefaultMutableTreeNode WNode = new DefaultMutableTreeNode("Metagene expressions (W)");
        DefaultMutableTreeNode WGraphNode = new DefaultMutableTreeNode("Metagene expression graphs (W)");
        DefaultMutableTreeNode HNode = new DefaultMutableTreeNode("Metagenes (H)");
        DefaultMutableTreeNode HGraphNode = new DefaultMutableTreeNode("Metagene graphs (H)");
        NMFFactorViewer wfv = new NMFFactorViewer(this.W[factorIndex], this.costs[factorIndex], true);
        for (int i2 = 0; i2 < this.W[factorIndex].length; ++i2) {
            WNode.add(new DefaultMutableTreeNode(new LeafInfo("W Factor " + (i2 + 1) + ", cost = " + this.costs[factorIndex][i2], (IViewer)wfv, (Object)new Integer(i2))));
            WGraphNode.add(new DefaultMutableTreeNode(new LeafInfo("W Factor " + (i2 + 1) + ", cost = " + this.costs[factorIndex][i2], (IViewer)new NMFPlotViewer(this.W[factorIndex][i2].transpose().A, true, false, 0))));
        }
        NMFFactorViewer hfv = new NMFFactorViewer(this.H[factorIndex], this.costs[factorIndex], false);
        String[] names = new String[this.H[factorIndex][0].getColumnDimension()];
        for (i = 0; i < names.length; ++i) {
            names[i] = this.data.getSampleName(i);
        }
        for (i = 0; i < this.H[factorIndex].length; ++i) {
            HNode.add(new DefaultMutableTreeNode(new LeafInfo("H Factor " + (i + 1) + ", cost = " + this.costs[factorIndex][i], (IViewer)hfv, (Object)new Integer(i))));
            HGraphNode.add(new DefaultMutableTreeNode(new LeafInfo("H Factor " + (i + 1) + ", cost = " + this.costs[factorIndex][i], (IViewer)new NMFPlotViewer(this.H[factorIndex][i].A, false, false, 0))));
        }
        root.add(WNode);
        root.add(WGraphNode);
        root.add(HNode);
        root.add(HGraphNode);
    }

    protected void addTableViews(DefaultMutableTreeNode root, int factorIndex) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Table Views");
        Object tabViewer = this.doSamples ? new ExperimentClusterTableViewer(this.experiment, this.clusters[factorIndex], this.data) : new ClusterTableViewer(this.experiment, this.clusters[factorIndex], this.data);
        for (int i = 0; i < this.clusters[factorIndex].length; ++i) {
            node.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + (i + 1), (IViewer)tabViewer, (Object)new Integer(i))));
        }
        root.add(node);
    }

    protected void addExpressionImages(DefaultMutableTreeNode root, int factorIndex) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Expression Images");
        NMFExperimentClusterViewer expViewer = this.doSamples ? new NMFExperimentClusterViewer(this.experiment, this.clusters[factorIndex]) : new ExperimentViewer(this.experiment, this.clusters[factorIndex]);
        for (int i = 0; i < this.clusters[factorIndex].length; ++i) {
            node.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + (i + 1), (IViewer)expViewer, (Object)new Integer(i))));
        }
        root.add(node);
    }

    protected void addConsensusMatrix(DefaultMutableTreeNode root, Cluster result_cluster, GeneralInfo info, int factorIndex) {
        NodeList nodeList = result_cluster.getNodeList();
        root.add(new DefaultMutableTreeNode(new LeafInfo("Consensus Matrix with HCL ", this.createHCLViewer(nodeList.getNode(0), info, factorIndex))));
    }

    protected IViewer createHCLViewer(Node clusterNode, GeneralInfo info, int factorIndex) {
        HCLTreeData genes_result;
        HCLTreeData hCLTreeData = genes_result = info.hcl_genes ? this.getResult(clusterNode, 0) : null;
        HCLTreeData samples_result = info.hcl_samples ? this.getResult(clusterNode, info.hcl_genes ? 4 : 0) : null;
        return new NMFHCLViewer(this.connectivityMatrix[factorIndex], this.createDefaultFeatures(this.connectivityMatrix[factorIndex]), genes_result, samples_result, !this.doSamples);
    }

    protected int[] createDefaultFeatures(Experiment experiment) {
        int[] features = new int[experiment.getNumberOfGenes()];
        for (int i = 0; i < features.length; ++i) {
            features[i] = i;
        }
        return features;
    }

    protected HCLTreeData getResult(Node clusterNode, int pos) {
        HCLTreeData data = new HCLTreeData();
        NodeValueList valueList = clusterNode.getValues();
        data.child_1_array = (int[])valueList.getNodeValue((int)pos).value;
        data.child_2_array = (int[])valueList.getNodeValue((int)(pos + 1)).value;
        data.node_order = (int[])valueList.getNodeValue((int)(pos + 2)).value;
        data.height = (float[])valueList.getNodeValue((int)(pos + 3)).value;
        data.setFunction(12);
        return data;
    }

    protected void addClusterInfo(DefaultMutableTreeNode root, int factorIndex) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Cluster Information");
        node.add(new DefaultMutableTreeNode(new LeafInfo("Results (#,%)", (IViewer)new NMFInfoViewer(this.clusters[factorIndex], this.doSamples ? this.experiment.getNumberOfSamples() : this.experiment.getNumberOfGenes()))));
        root.add(node);
    }

    protected void addCentroidViews(DefaultMutableTreeNode root, int factorIndex) {
        DefaultMutableTreeNode centroidNode = new DefaultMutableTreeNode("Centroid Graphs");
        DefaultMutableTreeNode expressionNode = new DefaultMutableTreeNode("Expression Graphs");
        if (this.doSamples) {
            NMFExperimentCentroidViewer centroidViewer = new NMFExperimentCentroidViewer(this.experiment, this.clusters[factorIndex]);
            centroidViewer.setMeans(this.means[factorIndex].A);
            centroidViewer.setVariances(this.variances[factorIndex].A);
            for (int i = 0; i < this.clusters[factorIndex].length; ++i) {
                centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + (i + 1), (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 0))));
                expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + (i + 1), (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 1))));
            }
        } else {
            CentroidViewer centroidViewer = new CentroidViewer(this.experiment, this.clusters[factorIndex]);
            centroidViewer.setMeans(this.means[factorIndex].A);
            centroidViewer.setVariances(this.variances[factorIndex].A);
            for (int i = 0; i < this.clusters[factorIndex].length; ++i) {
                centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + (i + 1), (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 0))));
                expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + (i + 1), (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 1))));
            }
        }
        root.add(expressionNode);
    }

    protected void addGeneralInfo(DefaultMutableTreeNode root, GeneralInfo info) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("General Information");
        node.add(new DefaultMutableTreeNode("Cluster by " + (this.doSamples ? "Samples" : "Genes")));
        node.add(new DefaultMutableTreeNode(this.multiClusters ? "Rank range: " + String.valueOf(this.rvalue) + " - " + String.valueOf(this.maxrvalue) : "Rank value: " + String.valueOf(this.rvalue)));
        node.add(new DefaultMutableTreeNode("Number of runs: " + String.valueOf(this.numRuns)));
        node.add(new DefaultMutableTreeNode("Maximum iterations: " + String.valueOf(this.maxIters)));
        node.add(new DefaultMutableTreeNode(this.doMax ? "Performed maximum iterations" : "Cost convergence cutoff: " + this.cutoff + ", checked every " + this.checkFreq + " iterations"));
        node.add(new DefaultMutableTreeNode("Update rules and cost measurement: " + (this.divergence ? "Divergence" : "Euclidean distance")));
        node.add(new DefaultMutableTreeNode("Negative value removal: " + (this.adjustData ? (this.expScale ? "Exponentially scale" : "Subtract minimum") : "No adjustment")));
        node.add(new DefaultMutableTreeNode("Random seed: " + (this.randomSeed == -1L ? "None" : Long.valueOf(this.randomSeed))));
        node.add(new DefaultMutableTreeNode("Cluster storage: " + this.storeClusters));
        node.add(new DefaultMutableTreeNode("Time: " + String.valueOf((double)(info.time - 1L) / 1000.0) + " s"));
        root.add(node);
    }

    protected class GeneralInfo {
        public int clusters;
        public String correctionMethod;
        public float alpha;
        public long time;
        public String function;
        protected boolean hcl;
        protected boolean usePerms;
        protected int hcl_method;
        protected int numPerms;
        protected boolean hcl_genes;
        protected boolean hcl_samples = true;

        protected GeneralInfo() {
        }

        public String getMethodName() {
            return this.hcl ? HCLGUI.GeneralInfo.getMethodName(this.hcl_method) : "no linkage";
        }
    }

    protected class Listener
    extends DialogListener
    implements AlgorithmListener {
        protected Listener() {
        }

        public void valueChanged(AlgorithmEvent event) {
            switch (event.getId()) {
                case 1: {
                    NMFGUI.this.progressBar.setUnits(event.getIntValue());
                    NMFGUI.this.progressBar.setDescription(event.getDescription());
                    break;
                }
                case 2: {
                    NMFGUI.this.progressBar.setIndeterminate(false);
                    NMFGUI.this.progressBar.setIndeterminantString(event.getIntValue() + "%");
                    NMFGUI.this.progressBar.setValue(event.getIntValue());
                    NMFGUI.this.progressBar.setDescription(event.getDescription());
                    break;
                }
                case 3: {
                    break;
                }
                case 6: {
                    NMFGUI.this.progressBar.setIndeterminantString("Calculating...");
                    NMFGUI.this.progressBar.setDescription(event.getDescription());
                    NMFGUI.this.progressBar.setIndeterminate(true);
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("cancel-command")) {
                NMFGUI.this.algorithm.abort();
                NMFGUI.this.progressBar.dispose();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            NMFGUI.this.algorithm.abort();
            NMFGUI.this.progressBar.dispose();
        }
    }
}

