/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.nmf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.Expression;
import java.text.DecimalFormat;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;
import org.tigr.util.FloatMatrix;

public class NMFFactorViewer
extends ViewerAdapter {
    private JComponent header;
    private JTextArea content;
    private float[] cost;
    private boolean w;
    private JLabel headerLabel;
    private FloatMatrix[] T;
    private DecimalFormat format;

    public NMFFactorViewer(FloatMatrix[] T, float[] cost, boolean w) {
        this(T, w);
        this.cost = cost;
    }

    public NMFFactorViewer(FloatMatrix[] T, boolean w) {
        this.T = T;
        this.w = w;
        this.format = new DecimalFormat();
        this.format.setMaximumFractionDigits(5);
        this.format.setMinimumFractionDigits(5);
        this.format.setGroupingUsed(false);
        this.headerLabel = new JLabel("<html><body bgcolor='#FFFFFF'><font face='serif' size='5' color='#000080'><b>Factor</b></font></body></html>");
        this.header = this.createHeader(this.headerLabel);
        this.content = this.createContent();
        this.setMaxWidth(this.content, this.header);
    }

    @Override
    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{this.T, this.cost, new Boolean(this.w)});
    }

    @Override
    public void onSelected(IFramework framework) {
        Object userObject = framework.getUserObject();
        this.updateViewer((Integer)userObject);
    }

    @Override
    public JComponent getContentComponent() {
        return this.content;
    }

    @Override
    public JComponent getHeaderComponent() {
        return this.header;
    }

    private JComponent createHeader(JLabel label) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBackground(Color.white);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(10, 0, 10, 0);
        panel.add((Component)label, gbc);
        return panel;
    }

    private JTextArea createContent() {
        JTextArea area = new JTextArea(this.T[0].getRowDimension(), 20);
        area.setMargin(new Insets(0, 10, 0, 0));
        area.setEditable(false);
        return area;
    }

    private void updateViewer(int gen) {
        int i;
        int i2;
        int j;
        float total;
        float[] values;
        int k;
        this.headerLabel.setText("<html><body bgcolor='#FFFFFF'><font face='serif' size='5' color='#000080'><b>Factor for run " + String.valueOf(gen + 1) + "</b></font></body></html>");
        this.content.setText("");
        int rows = this.T[gen].getRowDimension();
        int cols = this.T[gen].getColumnDimension();
        int n = k = this.w ? cols : rows;
        if (this.cost[gen] >= 0.0f) {
            k += 2;
        }
        StringBuffer sb = new StringBuffer(rows * 10 + k);
        if (this.w) {
            values = new float[cols];
            total = 0.0f;
            for (j = 0; j < cols; ++j) {
                values[j] = 0.0f;
                for (i2 = 0; i2 < rows; ++i2) {
                    values[j] = values[j] + this.T[gen].get(i2, j);
                }
                total += values[j];
            }
            for (i = 0; i < values.length; ++i) {
                values[i] = values[i] / total * 100.0f;
                sb.append("Factor " + (i + 1) + " importance: " + this.format.format(values[i]) + "\n");
            }
        } else {
            values = new float[rows];
            total = 0.0f;
            for (j = 0; j < rows; ++j) {
                values[j] = 0.0f;
                for (i2 = 0; i2 < cols; ++i2) {
                    values[j] = values[j] + this.T[gen].get(j, i2);
                }
                total += values[j];
            }
            for (i = 0; i < values.length; ++i) {
                values[i] = values[i] / total * 100.0f;
                sb.append("Factor " + (i + 1) + " Importance: " + this.format.format(values[i]) + "\n");
            }
        }
        if (this.cost[gen] >= 0.0f) {
            sb.append("Cost: " + this.cost[gen] + "\n");
        }
        sb.append("\n");
        for (int i3 = 0; i3 < rows; ++i3) {
            for (j = 0; j < cols; ++j) {
                float value = this.T[gen].get(i3, j);
                if (Float.isNaN(value)) {
                    sb.append(String.valueOf(Float.NaN) + "\t");
                    continue;
                }
                sb.append(this.format.format(value) + "\t");
            }
            sb.append("\n");
        }
        this.content.setText(sb.toString());
        this.content.setCaretPosition(0);
    }

    private void setMaxWidth(JComponent content, JComponent header) {
        int c_width = content.getPreferredSize().width;
        int h_width = header.getPreferredSize().width;
        if (c_width > h_width) {
            header.setPreferredSize(new Dimension(c_width, header.getPreferredSize().height));
        } else {
            content.setPreferredSize(new Dimension(h_width, content.getPreferredSize().height));
        }
    }

    @Override
    public JComponent getRowHeaderComponent() {
        return null;
    }
}

