/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.nmf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class NMFDialog
extends AlgorithmDialog {
    private static final long serialVersionUID = 1L;
    private int result = 2;
    JTextField numRunsField;
    JTextField rankField;
    JTextField maxRankField;
    JTextField numItersField;
    JTextField randomSeedField;
    JTextField cutoffField;
    JTextField checkFreqField;
    JRadioButton divergenceButton1;
    JRadioButton clusterBySamples;
    JRadioButton expScale;
    JCheckBox clustercb;
    JCheckBox multiRanks;
    JCheckBox adjustCB;
    JCheckBox randomSeedCB;
    JCheckBox doMax;
    JLabel rankLabel;
    JLabel conCutoff;
    JLabel checkFreq;

    public NMFDialog(Frame frame) {
        super(frame, "NMF: Non-negative Matrix Factorization", true);
        this.setBounds(0, 0, 600, 200);
        this.setBackground(Color.white);
        this.setDefaultCloseOperation(2);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.insets = new Insets(3, 0, 3, 0);
        JPanel pane = new JPanel();
        pane.setBackground(Color.white);
        pane.setBorder(new EtchedBorder());
        pane.setLayout(gridbag);
        JPanel clusterTypePanel = new JPanel();
        clusterTypePanel.setBackground(Color.white);
        clusterTypePanel.setBorder(new TitledBorder(new EtchedBorder(), "Samples/genes selection", 0, 0, new Font("Dialog", 1, 12), Color.black));
        GridBagLayout grid = new GridBagLayout();
        this.clusterBySamples = new JRadioButton("Cluster Samples");
        this.clusterBySamples.setSelected(true);
        this.clusterBySamples.setBackground(Color.white);
        this.buildConstraints(constraints, 0, 0, 1, 1, 50, 100);
        grid.setConstraints(this.clusterBySamples, constraints);
        clusterTypePanel.add(this.clusterBySamples);
        JRadioButton clusterByGenes = new JRadioButton(" Cluster Genes");
        clusterByGenes.setBackground(Color.white);
        clusterByGenes.setSelected(false);
        this.buildConstraints(constraints, 0, 1, 1, 1, 50, 100);
        grid.setConstraints(clusterByGenes, constraints);
        clusterTypePanel.add(clusterByGenes);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.clusterBySamples);
        bg.add(clusterByGenes);
        this.buildConstraints(constraints, 0, 0, 1, 1, 0, 50);
        gridbag.setConstraints(clusterTypePanel, constraints);
        pane.add(clusterTypePanel);
        JPanel runParams = new JPanel();
        runParams.setBackground(Color.white);
        runParams.setBorder(new TitledBorder(new EtchedBorder(), "Run parameters", 0, 0, new Font("Dialog", 1, 12), Color.black));
        runParams.setLayout(grid);
        this.multiRanks = new JCheckBox("Run multiple ranks");
        this.multiRanks.setBackground(Color.white);
        this.multiRanks.setSelected(false);
        this.multiRanks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                NMFDialog.this.maxRankField.setEnabled(NMFDialog.this.multiRanks.isSelected());
                NMFDialog.this.rankLabel.setText(NMFDialog.this.multiRanks.isSelected() ? "Rank range :" : "Rank value :");
            }
        });
        this.buildConstraints(constraints, 0, 0, 1, 1, 50, 100);
        grid.setConstraints(this.multiRanks, constraints);
        runParams.add(this.multiRanks);
        JLabel numRunsLabel = new JLabel("Number of runs : ");
        this.buildConstraints(constraints, 0, 1, 1, 1, 50, 100);
        constraints.fill = 0;
        constraints.anchor = 13;
        grid.setConstraints(numRunsLabel, constraints);
        runParams.add(numRunsLabel);
        constraints.fill = 2;
        this.numRunsField = new JTextField("10", 7);
        this.buildConstraints(constraints, 1, 1, 1, 1, 50, 100);
        grid.setConstraints(this.numRunsField, constraints);
        runParams.add(this.numRunsField);
        this.rankLabel = new JLabel("Rank value : ");
        constraints.fill = 0;
        this.buildConstraints(constraints, 0, 2, 1, 1, 50, 100);
        grid.setConstraints(this.rankLabel, constraints);
        runParams.add(this.rankLabel);
        constraints.fill = 2;
        this.rankField = new JTextField("2", 7);
        this.buildConstraints(constraints, 1, 2, 1, 1, 50, 100);
        grid.setConstraints(this.rankField, constraints);
        runParams.add(this.rankField);
        JLabel maxRankLabel = new JLabel(" - ");
        maxRankLabel.setEnabled(false);
        this.buildConstraints(constraints, 2, 2, 1, 1, 50, 100);
        grid.setConstraints(maxRankLabel, constraints);
        runParams.add(maxRankLabel);
        this.maxRankField = new JTextField("4", 7);
        this.maxRankField.setEnabled(false);
        this.buildConstraints(constraints, 3, 2, 1, 1, 50, 100);
        grid.setConstraints(this.maxRankField, constraints);
        runParams.add(this.maxRankField);
        JLabel numItersLabel = new JLabel("Maximum iterations : ");
        constraints.fill = 0;
        this.buildConstraints(constraints, 0, 3, 1, 1, 50, 100);
        grid.setConstraints(numItersLabel, constraints);
        runParams.add(numItersLabel);
        constraints.fill = 2;
        this.numItersField = new JTextField("1000", 7);
        this.buildConstraints(constraints, 1, 3, 1, 1, 50, 100);
        grid.setConstraints(this.numItersField, constraints);
        runParams.add(this.numItersField);
        this.doMax = new JCheckBox("Always perform maximum iterations");
        this.doMax.setBackground(Color.white);
        this.doMax.setSelected(true);
        this.doMax.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                NMFDialog.this.conCutoff.setEnabled(!NMFDialog.this.doMax.isSelected());
                NMFDialog.this.cutoffField.setEnabled(!NMFDialog.this.doMax.isSelected());
                NMFDialog.this.checkFreq.setEnabled(!NMFDialog.this.doMax.isSelected());
                NMFDialog.this.checkFreqField.setEnabled(!NMFDialog.this.doMax.isSelected());
            }
        });
        constraints.fill = 0;
        constraints.anchor = 17;
        this.buildConstraints(constraints, 0, 4, 1, 1, 50, 100);
        grid.setConstraints(this.doMax, constraints);
        runParams.add(this.doMax);
        constraints.fill = 2;
        this.conCutoff = new JLabel("Cost convergence cutoff: ");
        this.conCutoff.setEnabled(false);
        constraints.anchor = 13;
        constraints.fill = 0;
        this.buildConstraints(constraints, 0, 5, 1, 1, 50, 100);
        grid.setConstraints(this.conCutoff, constraints);
        runParams.add(this.conCutoff);
        constraints.fill = 2;
        this.cutoffField = new JTextField("1.0", 7);
        this.cutoffField.setEnabled(false);
        this.buildConstraints(constraints, 1, 5, 1, 1, 50, 100);
        grid.setConstraints(this.cutoffField, constraints);
        runParams.add(this.cutoffField);
        this.checkFreq = new JLabel("Check Frequency: ");
        this.checkFreq.setEnabled(false);
        constraints.anchor = 13;
        constraints.fill = 0;
        this.buildConstraints(constraints, 0, 6, 1, 1, 50, 100);
        grid.setConstraints(this.checkFreq, constraints);
        runParams.add(this.checkFreq);
        constraints.fill = 2;
        this.checkFreqField = new JTextField("40", 7);
        this.checkFreqField.setEnabled(false);
        this.buildConstraints(constraints, 1, 6, 1, 1, 50, 100);
        grid.setConstraints(this.checkFreqField, constraints);
        runParams.add(this.checkFreqField);
        this.buildConstraints(constraints, 0, 2, 1, 1, 0, 50);
        gridbag.setConstraints(runParams, constraints);
        pane.add(runParams);
        JPanel divergencePanel = new JPanel();
        divergencePanel.setBackground(Color.white);
        divergencePanel.setBorder(new TitledBorder(new EtchedBorder(), "Update rules and cost measurement", 0, 0, new Font("Dialog", 1, 12), Color.black));
        JRadioButton divergenceButton2 = new JRadioButton(" Divergence");
        divergenceButton2.setBackground(Color.white);
        divergenceButton2.setSelected(true);
        this.buildConstraints(constraints, 0, 0, 1, 1, 50, 100);
        grid.setConstraints(divergenceButton2, constraints);
        divergencePanel.add(divergenceButton2);
        this.divergenceButton1 = new JRadioButton("Euclidean");
        this.divergenceButton1.setSelected(false);
        this.divergenceButton1.setBackground(Color.white);
        this.buildConstraints(constraints, 0, 1, 1, 1, 50, 100);
        grid.setConstraints(this.divergenceButton1, constraints);
        divergencePanel.add(this.divergenceButton1);
        ButtonGroup bg1 = new ButtonGroup();
        bg1.add(this.divergenceButton1);
        bg1.add(divergenceButton2);
        this.buildConstraints(constraints, 0, 4, 1, 1, 0, 50);
        gridbag.setConstraints(divergencePanel, constraints);
        pane.add(divergencePanel);
        JPanel normalizationPanel = new JPanel();
        normalizationPanel.setBackground(Color.white);
        normalizationPanel.setBorder(new TitledBorder(new EtchedBorder(), "Data matrix pre-processing", 0, 0, new Font("Dialog", 1, 12), Color.black));
        normalizationPanel.setLayout(grid);
        JLabel noNegs1 = new JLabel("The data matrix may not contain negative values.");
        JLabel noNegs2 = new JLabel("If negative values exist, select a way to adjust the data.");
        this.buildConstraints(constraints, 0, 0, 2, 1, 50, 100);
        grid.setConstraints(noNegs1, constraints);
        this.buildConstraints(constraints, 0, 1, 2, 1, 50, 100);
        grid.setConstraints(noNegs2, constraints);
        normalizationPanel.add(noNegs1);
        normalizationPanel.add(noNegs2);
        this.adjustCB = new JCheckBox("Always adjust data");
        this.adjustCB.setBackground(Color.white);
        this.adjustCB.setSelected(false);
        this.buildConstraints(constraints, 0, 2, 2, 1, 50, 100);
        grid.setConstraints(this.adjustCB, constraints);
        normalizationPanel.add(this.adjustCB);
        constraints.insets = new Insets(10, 0, 10, 0);
        JRadioButton subtractMin = new JRadioButton("Subtract minimum value");
        subtractMin.setBackground(Color.white);
        subtractMin.setSelected(true);
        this.buildConstraints(constraints, 0, 3, 1, 1, 50, 100);
        grid.setConstraints(subtractMin, constraints);
        normalizationPanel.add(subtractMin);
        this.expScale = new JRadioButton("Exponentially scale");
        this.expScale.setSelected(false);
        this.expScale.setBackground(Color.white);
        this.buildConstraints(constraints, 1, 3, 1, 1, 50, 100);
        grid.setConstraints(this.expScale, constraints);
        normalizationPanel.add(this.expScale);
        constraints.insets = new Insets(0, 0, 0, 0);
        ButtonGroup bg2 = new ButtonGroup();
        bg2.add(this.expScale);
        bg2.add(subtractMin);
        this.buildConstraints(constraints, 0, 5, 1, 1, 0, 50);
        gridbag.setConstraints(normalizationPanel, constraints);
        pane.add(normalizationPanel);
        JPanel randomSeedPanel = new JPanel();
        randomSeedPanel.setBackground(Color.white);
        randomSeedPanel.setBorder(new TitledBorder(new EtchedBorder(), "Random number generation", 0, 0, new Font("Dialog", 1, 12), Color.black));
        randomSeedPanel.setLayout(grid);
        this.randomSeedCB = new JCheckBox("Use random number generator seed:");
        this.randomSeedCB.setBackground(Color.white);
        this.randomSeedCB.setSelected(true);
        this.randomSeedCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                NMFDialog.this.randomSeedField.setEnabled(NMFDialog.this.randomSeedCB.isSelected());
            }
        });
        this.buildConstraints(constraints, 0, 0, 1, 1, 50, 100);
        grid.setConstraints(this.randomSeedCB, constraints);
        randomSeedPanel.add(this.randomSeedCB);
        this.randomSeedField = new JTextField("12345", 7);
        this.randomSeedField.setEnabled(true);
        this.buildConstraints(constraints, 1, 0, 1, 1, 50, 100);
        grid.setConstraints(this.randomSeedField, constraints);
        randomSeedPanel.add(this.randomSeedField);
        this.buildConstraints(constraints, 0, 6, 1, 1, 0, 50);
        gridbag.setConstraints(randomSeedPanel, constraints);
        pane.add(randomSeedPanel);
        JPanel clusterPanel = new JPanel();
        clusterPanel.setBackground(Color.white);
        clusterPanel.setBorder(new TitledBorder(new EtchedBorder(), "Clusters", 0, 0, new Font("Dialog", 1, 12), Color.black));
        clusterPanel.setLayout(grid);
        this.clustercb = new JCheckBox("Store results as clusters");
        this.clustercb.setBackground(Color.white);
        this.clustercb.setSelected(false);
        this.buildConstraints(constraints, 0, 0, 1, 1, 50, 100);
        grid.setConstraints(this.clustercb, constraints);
        clusterPanel.add(this.clustercb);
        this.buildConstraints(constraints, 0, 7, 1, 1, 50, 100);
        gridbag.setConstraints(clusterPanel, constraints);
        pane.add(clusterPanel);
        this.setActionListeners(new EventListener());
        this.addContent(pane);
        this.pack();
    }

    private void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.setVisible(true);
        return this.result;
    }

    public int getNumRuns() {
        return Integer.parseInt(this.numRunsField.getText());
    }

    public int getMaxIterations() {
        return Integer.parseInt(this.numItersField.getText());
    }

    public boolean getDivergence() {
        return !this.divergenceButton1.isSelected();
    }

    public boolean isStoreClusters() {
        return this.clustercb.isSelected();
    }

    public boolean isMultiRank() {
        return this.multiRanks.isSelected();
    }

    public long getRandomSeed() {
        if (this.randomSeedCB.isSelected()) {
            return Long.parseLong(this.randomSeedField.getText());
        }
        return -1L;
    }

    public int getRValue() {
        return Integer.parseInt(this.rankField.getText());
    }

    public int getMaxRValue() {
        return this.multiRanks.isSelected() ? Integer.parseInt(this.maxRankField.getText()) : this.getRValue();
    }

    public boolean isClusterSamples() {
        return this.clusterBySamples.isSelected();
    }

    public boolean isAdjustData() {
        return this.adjustCB.isSelected();
    }

    public boolean isExpScale() {
        return this.expScale.isSelected();
    }

    public boolean isDoMaxIters() {
        return this.doMax.isSelected();
    }

    public float getCutoff() {
        return Float.parseFloat(this.cutoffField.getText());
    }

    public int getCheckFreq() {
        return Integer.parseInt(this.checkFreqField.getText());
    }

    public static void main(String[] args) {
        NMFDialog dialog = new NMFDialog(new Frame());
        int result = dialog.showModal();
        System.out.println("result = " + result);
        System.exit(0);
    }

    protected class EventListener
    implements ActionListener,
    ItemListener {
        protected EventListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String command = event.getActionCommand();
            if (command.equals("ok-command")) {
                try {
                    int numRuns = NMFDialog.this.getNumRuns();
                    int maxR = NMFDialog.this.getMaxRValue();
                    int minR = NMFDialog.this.getRValue();
                    int iterations = NMFDialog.this.getMaxIterations();
                    if (numRuns <= 0) {
                        JOptionPane.showMessageDialog(null, "Invalid number of runs.", "Error", 0);
                        return;
                    }
                    if (maxR <= minR && NMFDialog.this.isMultiRank()) {
                        JOptionPane.showMessageDialog(null, "The maximum number of runs must be greater than the minimum number of runs, obviously.", "Error", 0);
                        return;
                    }
                    if (minR <= 1) {
                        JOptionPane.showMessageDialog(null, "The NMF rank must be at least 2.", "Error", 0);
                        return;
                    }
                    if (iterations <= 0) {
                        JOptionPane.showMessageDialog(null, "Invalid number of iterations.", "Error", 0);
                        return;
                    }
                    NMFDialog.this.result = 0;
                    NMFDialog.this.dispose();
                }
                catch (NumberFormatException nfe) {
                    JOptionPane.showMessageDialog(null, "Invalid input.\n\nPlease check your parameters and try again.", "Error", 0);
                    return;
                }
            } else if (command.equals("cancel-command")) {
                NMFDialog.this.result = 2;
                NMFDialog.this.dispose();
            } else if (!command.equals("reset-command") && command.equals("info-command")) {
                HelpWindow.launchBrowser(NMFDialog.this, "NMF Initialization Dialog");
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
        }
    }
}

