/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.minet;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.clusterUtil.Cluster;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterRepository;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterBrowser;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterSelector;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class MINETInitBox
extends AlgorithmDialog {
    private static final long serialVersionUID = 1L;
    public static final int JUST_ALPHA = 1;
    public static final int STD_BONFERRONI = 2;
    public static final int ADJ_BONFERRONI = 3;
    public static final int MAX_T = 4;
    public static final int FALSE_NUM = 5;
    public static final int FALSE_PROP = 6;
    public static final int ONE_CLASS = 7;
    public static final int TWO_CLASS = 8;
    public static final int PAIRED = 9;
    public static final int BUTTON_SELECTION = 10;
    public static final int CLUSTER_SELECTION = 11;
    boolean okPressed = false;
    boolean okReady = false;
    Vector<String> exptNames;
    MainPanel mPanel;
    PValuePanel pPanel;
    MethodsPanel methodsPanel;
    EstimatorPanel estimatorPanel;
    DiscretizationPanel discretizationPanel;
    ClusterRepository experimentClusterRepository;
    ClusterRepository geneClusterRepository;
    ClusterBrowser browser;

    public MINETInitBox(JFrame parentFrame, boolean modality, Vector<String> exptNames, ClusterRepository experimentClusterRepository, ClusterRepository geneClusterRepository) {
        super(parentFrame, "MINET Initialization", modality);
        this.exptNames = exptNames;
        this.experimentClusterRepository = experimentClusterRepository;
        this.geneClusterRepository = geneClusterRepository;
        this.setBounds(0, 0, 600, 700);
        this.setBackground(Color.white);
        this.setDefaultCloseOperation(2);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        JPanel pane = new JPanel();
        pane.setLayout(gridbag);
        this.okButton.setEnabled(true);
        this.mPanel = new MainPanel();
        JPanel paramsPane = new JPanel();
        this.methodsPanel = new MethodsPanel();
        paramsPane.add(this.methodsPanel);
        this.estimatorPanel = new EstimatorPanel();
        paramsPane.add(this.estimatorPanel);
        this.discretizationPanel = new DiscretizationPanel();
        paramsPane.add(this.discretizationPanel);
        JPanel popNClusterPanel = new JPanel(new GridBagLayout());
        popNClusterPanel.setBackground(Color.white);
        this.browser = new ClusterBrowser(this.geneClusterRepository);
        popNClusterPanel.add((Component)this.browser, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JTabbedPane consolidatedPane = new JTabbedPane();
        consolidatedPane.add("Cluster Selection", (Component)this.browser);
        consolidatedPane.add("Parameters", paramsPane);
        this.buildConstraints(constraints, 0, 1, 1, 1, 0, 20);
        gridbag.setConstraints(consolidatedPane, constraints);
        pane.add(consolidatedPane);
        this.buildConstraints(constraints, 0, 1, 1, 1, 0, 20);
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 80);
        gridbag.setConstraints(this.mPanel, constraints);
        pane.add(this.mPanel);
        this.addContent(pane);
        EventListener listener = new EventListener();
        this.setActionListeners(listener);
        this.addWindowListener(listener);
        if (geneClusterRepository == null || geneClusterRepository.isEmpty()) {
            Component comp = consolidatedPane.getComponentAt(0);
            JPanel panel = (JPanel)comp;
            panel.removeAll();
            panel.validate();
            panel.setOpaque(false);
            panel.add((Component)new JLabel("Empty Cluster Repository"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(15, 0, 10, 0), 0, 0));
            panel.add((Component)new JLabel("Please create a gene cluster and launch MINET again."), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 15, 0, new Insets(0, 0, 0, 0), 0, 0));
            consolidatedPane.setSelectedIndex(0);
            this.okButton.setEnabled(false);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        super.setVisible(visible);
        if (visible) {
            // empty if block
        }
    }

    void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public void enableOK() {
        this.okButton.setEnabled(true);
    }

    public int getSelectionDesign() {
        int design = -1;
        if (this.getTestDesign() == 7) {
            design = this.mPanel.oneClassmulg.getSelectedIndex() == 0 ? 10 : 11;
        }
        return 10;
    }

    public int getTestDesign() {
        int design = -1;
        design = 7;
        return design;
    }

    public int[] getOneClassAssignments() {
        int[] inGroupAssignments = new int[this.exptNames.size()];
        for (int i = 0; i < this.exptNames.size(); ++i) {
            inGroupAssignments[i] = this.mPanel.oneClassPanel.exptCheckBoxes[i].isSelected() ? 1 : 0;
        }
        return inGroupAssignments;
    }

    public int[] getClusterOneClassAssignments() {
        int j;
        int i;
        int[] groupAssignments = new int[this.exptNames.size()];
        ArrayList[] arraylistArray = new ArrayList[2];
        for (i = 0; i < 2; ++i) {
            j = i + 1;
            arraylistArray[i] = this.mPanel.oneClassClusterSelector.getGroupSamples("Samples " + j);
        }
        for (i = 0; i < this.exptNames.size(); ++i) {
            boolean doubleAssigned = false;
            groupAssignments[i] = 0;
            for (j = 0; j < 2; ++j) {
                if (!arraylistArray[j].contains(i)) continue;
                if (doubleAssigned) {
                    Object[] optionst = new Object[]{"OK"};
                    JOptionPane.showOptionDialog(null, "The clusters you have chosen have overlapping samples. \n Each group must contain unique samples.", "Multiple Ownership Error", 1, 3, null, optionst, optionst[0]);
                    return null;
                }
                groupAssignments[i] = j + 1;
                doubleAssigned = true;
            }
        }
        return groupAssignments;
    }

    public Cluster getSelectedCluster() {
        return this.browser.getSelectedCluster();
    }

    public boolean usePerms() {
        return true;
    }

    public int getNumPerms() {
        return Integer.parseInt(this.pPanel.timesField.getText());
    }

    public float getPValue() {
        return Float.parseFloat(this.pPanel.pValueInputField.getText());
    }

    public int getFalseNum() {
        return Integer.parseInt(this.pPanel.falseNumField.getText());
    }

    public double getFalseProp() {
        return Double.parseDouble(this.pPanel.falsePropField.getText());
    }

    public boolean validateFalseNum() {
        int a;
        try {
            String falseNum = this.pPanel.falseNumField.getText();
            a = Integer.parseInt(falseNum);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "False number must be an integer >= 0", "Input Error", 2);
            this.pPanel.falseNumField.requestFocus();
            this.pPanel.falseNumField.selectAll();
            return false;
        }
        if (a < 0) {
            JOptionPane.showMessageDialog(this, "False number must be an integer >= 0", "Input Error", 2);
            this.pPanel.falseNumField.requestFocus();
            this.pPanel.falseNumField.selectAll();
            return false;
        }
        return true;
    }

    public boolean validateFalseProp() {
        float a;
        try {
            String falseProp = this.pPanel.falsePropField.getText();
            a = Float.parseFloat(falseProp);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "False proportion must be between 0 and 1", "Input Error", 2);
            this.pPanel.falsePropField.requestFocus();
            this.pPanel.falsePropField.selectAll();
            return false;
        }
        if (a <= 0.0f || a > 1.0f) {
            JOptionPane.showMessageDialog(this, "False proportion must be between 0 and 1", "Input Error", 2);
            this.pPanel.falsePropField.requestFocus();
            this.pPanel.falsePropField.selectAll();
            return false;
        }
        return true;
    }

    public int getCorrectionMethod() {
        int method = 1;
        if (this.pPanel.falseNumButton.isSelected()) {
            method = 5;
        } else if (this.pPanel.falsePropButton.isSelected()) {
            method = 6;
        }
        return method;
    }

    public static void main(String[] args) {
        JFrame dummyFrame = new JFrame();
        Vector<String> dummyVect = new Vector<String>();
        for (int i = 0; i < 23; ++i) {
            dummyVect.add("Expt " + (i + 1));
        }
        dummyVect.add("Exptsdfsdfsgwegsgsgsd");
        MINETInitBox oBox = new MINETInitBox(dummyFrame, true, dummyVect, null, null);
        oBox.setVisible(true);
        System.out.println("end");
        System.exit(0);
    }

    public class EventListener
    extends WindowAdapter
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ae) {
            block13: {
                String command = ae.getActionCommand();
                if (command.equals("ok-command")) {
                    if (!MINETInitBox.this.okReady) {
                        return;
                    }
                    if (MINETInitBox.this.getSelectionDesign() == 11 && MINETInitBox.this.experimentClusterRepository.isEmpty()) {
                        JOptionPane.showMessageDialog(null, "Cluster Repository is Empty.", "Error", 2);
                        return;
                    }
                    try {
                        if (MINETInitBox.this.getTestDesign() == 7) {
                            int[] inGroupAssignments = MINETInitBox.this.getSelectionDesign() == 11 ? MINETInitBox.this.getClusterOneClassAssignments() : MINETInitBox.this.getOneClassAssignments();
                            int inNum = 0;
                            while (inGroupAssignments[inNum] != 1) {
                                if (++inNum != inGroupAssignments.length) continue;
                                JOptionPane.showMessageDialog(null, "No samples have been assigned to the analysis.", "Error!", 0);
                                MINETInitBox.this.okPressed = false;
                                return;
                            }
                            MINETInitBox.this.okPressed = true;
                            MINETInitBox.this.dispose();
                            break block13;
                        }
                        MINETInitBox.this.okPressed = true;
                        MINETInitBox.this.dispose();
                    }
                    catch (NumberFormatException nfe) {
                        JOptionPane.showMessageDialog(null, "Valid inputs: 0 < alpha < 1, and # of permutations (integer only) > 1", "Error!", 0);
                    }
                } else if (command.equals("reset-command")) {
                    MINETInitBox.this.mPanel.reset();
                    MINETInitBox.this.pPanel.reset();
                } else if (command.equals("cancel-command")) {
                    MINETInitBox.this.okPressed = false;
                    MINETInitBox.this.dispose();
                } else if (command.equals("info-command")) {
                    HelpWindow.launchBrowser(MINETInitBox.this, "MINET Initialization Dialog");
                }
            }
        }
    }

    class PValuePanel
    extends JPanel {
        JLabel numPermsLabel;
        JTextField timesField;
        JTextField pValueInputField;
        JTextField falseNumField;
        JTextField falsePropField;
        JRadioButton pValueButton;
        JRadioButton falseNumButton;
        JRadioButton falsePropButton;

        public PValuePanel() {
            this.setBorder(new TitledBorder(new EtchedBorder(), "P-value / false discovery parameters", 0, 0, new Font("Dialog", 1, 12), Color.black));
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.setBackground(Color.white);
            this.setLayout(gridbag);
            this.numPermsLabel = new JLabel("Enter number of permutations");
            MINETInitBox.this.buildConstraints(constraints, 0, 0, 1, 1, 33, 25);
            constraints.anchor = 13;
            gridbag.setConstraints(this.numPermsLabel, constraints);
            this.add(this.numPermsLabel);
            this.timesField = new JTextField("100", 7);
            this.timesField.setMinimumSize(new Dimension(50, 20));
            MINETInitBox.this.buildConstraints(constraints, 1, 0, 1, 1, 33, 25);
            constraints.anchor = 17;
            gridbag.setConstraints(this.timesField, constraints);
            this.add(this.timesField);
            JPanel pValSelectionPanel = new JPanel();
            pValSelectionPanel.setBackground(Color.white);
            pValSelectionPanel.setBorder(new TitledBorder(new EtchedBorder(1), "P-Value Cutoff ", 0, 0, new Font("Dialog", 1, 12), Color.black));
            GridBagLayout pValSelectionPanelgrid = new GridBagLayout();
            pValSelectionPanel.setLayout(pValSelectionPanelgrid);
            this.pValueButton = new JRadioButton("", true);
            this.pValueButton.setFocusPainted(false);
            this.pValueButton.setForeground(UIManager.getColor("Label.foreground"));
            this.pValueButton.setBackground(Color.white);
            pValSelectionPanel.add(this.pValueButton);
            JLabel pValueLabel = new JLabel("Enter alpha (critical p-value): ");
            MINETInitBox.this.buildConstraints(constraints, 1, 0, 1, 1, 33, 25);
            constraints.anchor = 17;
            pValSelectionPanelgrid.setConstraints(pValueLabel, constraints);
            pValSelectionPanel.add(pValueLabel);
            this.pValueInputField = new JTextField("0.01", 7);
            this.pValueInputField.setMinimumSize(new Dimension(50, 20));
            MINETInitBox.this.buildConstraints(constraints, 2, 0, 1, 1, 33, 0);
            constraints.anchor = 13;
            pValSelectionPanelgrid.setConstraints(this.pValueInputField, constraints);
            pValSelectionPanel.add(this.pValueInputField);
            MINETInitBox.this.buildConstraints(constraints, 0, 1, 2, 1, 33, 25);
            constraints.anchor = 13;
            constraints.fill = 2;
            gridbag.setConstraints(pValSelectionPanel, constraints);
            this.add(pValSelectionPanel);
            constraints.anchor = 10;
            this.falseNumButton = new JRadioButton("EITHER, The number of false significant genes should not exceed", false);
            this.falseNumButton.setFocusPainted(false);
            this.falseNumButton.setForeground(UIManager.getColor("Label.foreground"));
            this.falseNumButton.setBackground(Color.white);
            this.falsePropButton = new JRadioButton("OR, The proportion of false significant genes should not exceed", false);
            this.falsePropButton.setFocusPainted(false);
            this.falsePropButton.setForeground(UIManager.getColor("Label.foreground"));
            this.falsePropButton.setBackground(Color.white);
            this.falseNumField = new JTextField(10);
            this.falseNumField.setText("10");
            this.falseNumField.setMinimumSize(new Dimension(50, 20));
            this.falsePropField = new JTextField(10);
            this.falsePropField.setText("0.05");
            this.falsePropField.setMinimumSize(new Dimension(50, 20));
            ButtonGroup chooseCorrection = new ButtonGroup();
            chooseCorrection.add(this.falseNumButton);
            chooseCorrection.add(this.falsePropButton);
            chooseCorrection.add(this.pValueButton);
            JPanel FDMINETanel = new JPanel();
            FDMINETanel.setBackground(Color.white);
            FDMINETanel.setBorder(new TitledBorder(new EtchedBorder(1), "False discovery control ", 0, 0, new Font("Dialog", 1, 12), Color.black));
            GridBagLayout grid3 = new GridBagLayout();
            FDMINETanel.setLayout(grid3);
            JLabel FDRLabel = new JLabel("With confidence of [1 - alpha] : ");
            constraints.anchor = 17;
            MINETInitBox.this.buildConstraints(constraints, 0, 0, 2, 1, 100, 34);
            grid3.setConstraints(FDRLabel, constraints);
            FDMINETanel.add(FDRLabel);
            constraints.anchor = 10;
            MINETInitBox.this.buildConstraints(constraints, 0, 1, 1, 1, 50, 33);
            constraints.anchor = 13;
            grid3.setConstraints(this.falseNumButton, constraints);
            FDMINETanel.add(this.falseNumButton);
            MINETInitBox.this.buildConstraints(constraints, 1, 1, 1, 1, 50, 0);
            constraints.anchor = 17;
            grid3.setConstraints(this.falseNumField, constraints);
            FDMINETanel.add(this.falseNumField);
            MINETInitBox.this.buildConstraints(constraints, 0, 2, 1, 1, 50, 33);
            constraints.anchor = 13;
            grid3.setConstraints(this.falsePropButton, constraints);
            FDMINETanel.add(this.falsePropButton);
            MINETInitBox.this.buildConstraints(constraints, 1, 2, 1, 1, 50, 0);
            constraints.anchor = 17;
            grid3.setConstraints(this.falsePropField, constraints);
            FDMINETanel.add(this.falsePropField);
            constraints.anchor = 10;
            MINETInitBox.this.buildConstraints(constraints, 0, 3, 4, 1, 100, 50);
            gridbag.setConstraints(FDMINETanel, constraints);
            this.add(FDMINETanel);
        }

        protected void reset() {
            this.pValueInputField.setText("0.01");
        }
    }

    class DiscretizationPanel
    extends JPanel {
        JRadioButton none;
        JRadioButton equalfreq;
        JRadioButton equalwidth;
        JRadioButton globalequalwidth;

        public DiscretizationPanel() {
            this.setBorder(new TitledBorder(new EtchedBorder(), "Discretization Method", 0, 0, new Font("Dialog", 1, 12), Color.black));
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.setLayout(gridbag);
            this.none = new JRadioButton("none", false);
            this.equalfreq = new JRadioButton("Equal Frequency", false);
            this.equalwidth = new JRadioButton("Equal width", false);
            this.globalequalwidth = new JRadioButton("Global Equal Width", true);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.none);
            buttonGroup.add(this.equalfreq);
            buttonGroup.add(this.equalwidth);
            buttonGroup.add(this.globalequalwidth);
            this.equalwidth.setSelected(true);
            MINETInitBox.this.buildConstraints(constraints, 0, 0, 1, 1, 50, 50);
            constraints.anchor = 17;
            gridbag.setConstraints(this.equalfreq, constraints);
            this.add(this.none);
            MINETInitBox.this.buildConstraints(constraints, 1, 0, 1, 1, 50, 50);
            constraints.anchor = 17;
            gridbag.setConstraints(this.equalfreq, constraints);
            this.add(this.equalfreq);
            MINETInitBox.this.buildConstraints(constraints, 2, 0, 1, 1, 50, 50);
            constraints.anchor = 17;
            gridbag.setConstraints(this.equalwidth, constraints);
            this.add(this.equalwidth);
            MINETInitBox.this.buildConstraints(constraints, 3, 0, 1, 1, 50, 50);
            constraints.anchor = 17;
            gridbag.setConstraints(this.globalequalwidth, constraints);
            this.add(this.globalequalwidth);
        }

        public int getDiscretizationMethod() {
            if (this.equalfreq.isSelected()) {
                return 1;
            }
            if (this.equalwidth.isSelected()) {
                return 2;
            }
            if (this.globalequalwidth.isSelected()) {
                return 3;
            }
            return 0;
        }

        public String getDiscretizationMethodName() {
            if (this.equalfreq.isSelected()) {
                return "equalfreq";
            }
            if (this.none.isSelected()) {
                return "none";
            }
            if (this.equalwidth.isSelected()) {
                return "equalwidth";
            }
            if (this.globalequalwidth.isSelected()) {
                return "globalequalwidth";
            }
            return null;
        }
    }

    class EstimatorPanel
    extends JPanel {
        JRadioButton miEmpirical;
        JRadioButton miMm;
        JRadioButton miShrink;
        JRadioButton miSg;

        public EstimatorPanel() {
            this.setBorder(new TitledBorder(new EtchedBorder(), "Mutual information estimator", 0, 0, new Font("Dialog", 1, 12), Color.black));
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.setLayout(gridbag);
            this.miEmpirical = new JRadioButton("mi.empirical", false);
            this.miMm = new JRadioButton("mi.mm", false);
            this.miShrink = new JRadioButton("mi.shrink", true);
            this.miSg = new JRadioButton("mi.sg", true);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.miEmpirical);
            buttonGroup.add(this.miMm);
            buttonGroup.add(this.miShrink);
            buttonGroup.add(this.miSg);
            this.miShrink.setSelected(true);
            MINETInitBox.this.buildConstraints(constraints, 0, 0, 1, 1, 50, 50);
            constraints.anchor = 17;
            gridbag.setConstraints(this.miEmpirical, constraints);
            this.add(this.miEmpirical);
            MINETInitBox.this.buildConstraints(constraints, 1, 0, 1, 1, 50, 50);
            constraints.anchor = 17;
            gridbag.setConstraints(this.miMm, constraints);
            this.add(this.miMm);
            MINETInitBox.this.buildConstraints(constraints, 2, 0, 1, 1, 50, 50);
            constraints.anchor = 17;
            gridbag.setConstraints(this.miShrink, constraints);
            this.add(this.miShrink);
            MINETInitBox.this.buildConstraints(constraints, 3, 0, 1, 1, 50, 50);
            constraints.anchor = 17;
            gridbag.setConstraints(this.miSg, constraints);
            this.add(this.miSg);
        }

        public int getEstimator() {
            if (this.miEmpirical.isSelected()) {
                return 1;
            }
            if (this.miMm.isSelected()) {
                return 2;
            }
            if (this.miShrink.isSelected()) {
                return 3;
            }
            if (this.miSg.isSelected()) {
                return 4;
            }
            return 0;
        }

        public String getEstimatorName() {
            if (this.miEmpirical.isSelected()) {
                return this.miEmpirical.getText();
            }
            if (this.miMm.isSelected()) {
                return this.miMm.getText();
            }
            if (this.miShrink.isSelected()) {
                return this.miShrink.getText();
            }
            if (this.miSg.isSelected()) {
                return this.miSg.getText();
            }
            return null;
        }
    }

    class MethodsPanel
    extends JPanel {
        JRadioButton aracne;
        JRadioButton clr;
        JRadioButton mrnet;

        public MethodsPanel() {
            this.setBorder(new TitledBorder(new EtchedBorder(), "Inference algorithm", 0, 0, new Font("Dialog", 1, 12), Color.black));
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.setLayout(gridbag);
            this.aracne = new JRadioButton("aracne", false);
            this.clr = new JRadioButton("clr", false);
            this.mrnet = new JRadioButton("mrnet", true);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.aracne);
            buttonGroup.add(this.clr);
            buttonGroup.add(this.mrnet);
            this.aracne.setSelected(true);
            MINETInitBox.this.buildConstraints(constraints, 0, 0, 1, 1, 50, 50);
            constraints.anchor = 17;
            gridbag.setConstraints(this.aracne, constraints);
            this.add(this.aracne);
            MINETInitBox.this.buildConstraints(constraints, 1, 0, 1, 1, 50, 50);
            constraints.anchor = 17;
            gridbag.setConstraints(this.clr, constraints);
            this.add(this.clr);
            MINETInitBox.this.buildConstraints(constraints, 2, 0, 1, 1, 50, 50);
            constraints.anchor = 17;
            gridbag.setConstraints(this.mrnet, constraints);
            this.add(this.mrnet);
        }

        public int getMethod() {
            if (this.aracne.isSelected()) {
                return 1;
            }
            if (this.clr.isSelected()) {
                return 2;
            }
            if (this.mrnet.isSelected()) {
                return 3;
            }
            return 0;
        }

        public String getMethodName() {
            if (this.aracne.isSelected()) {
                return this.aracne.getText();
            }
            if (this.clr.isSelected()) {
                return this.clr.getText();
            }
            if (this.mrnet.isSelected()) {
                return this.mrnet.getText();
            }
            return null;
        }
    }

    class MainPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        GridBagConstraints constraints = new GridBagConstraints();
        GridBagLayout gridbag = new GridBagLayout();
        JPanel dummyPanel;
        ExperimentsPanel oneClassPanel;
        JTabbedPane oneClassmulg;
        ClusterSelector oneClassClusterSelector;
        float alpha;

        public MainPanel() {
            this.setBackground(Color.white);
            this.setLayout(this.gridbag);
            MINETInitBox.this.buildConstraints(this.constraints, 0, 0, 1, 1, 100, 10);
            this.constraints.fill = 1;
            MINETInitBox.this.okReady = true;
            try {
                this.oneClassPanel = new ExperimentsPanel(MINETInitBox.this.exptNames, 1);
                this.oneClassClusterSelector = new ClusterSelector(MINETInitBox.this.experimentClusterRepository, 1, "Samples");
                if (MINETInitBox.this.experimentClusterRepository != null) {
                    this.oneClassClusterSelector.setClusterType("Experiment");
                }
                JPanel oneClassClusterSelectorPanel = new JPanel();
                oneClassClusterSelectorPanel.setLayout(new GridBagLayout());
                GridBagConstraints c = new GridBagConstraints();
                c.fill = 1;
                c.weighty = 1.0;
                c.weightx = 1.0;
                c.gridx = 0;
                c.gridy = 1;
                c.gridwidth = 1;
                c.anchor = 20;
                oneClassClusterSelectorPanel.add((Component)this.oneClassClusterSelector, c);
                this.oneClassmulg = new JTabbedPane();
                this.oneClassmulg.add("Button Selection", this.oneClassPanel);
                this.oneClassmulg.add("Cluster Selection", oneClassClusterSelectorPanel);
                this.oneClassmulg.setSelectedIndex(1);
                if (MINETInitBox.this.experimentClusterRepository == null || MINETInitBox.this.experimentClusterRepository.isEmpty()) {
                    this.oneClassmulg.setSelectedIndex(0);
                }
                MINETInitBox.this.buildConstraints(this.constraints, 1, 0, 1, 3, 100, 100);
                this.constraints.fill = 1;
                this.gridbag.setConstraints(this.oneClassPanel, this.constraints);
                this.add(this.oneClassPanel);
                this.validate();
            }
            catch (NumberFormatException nfe) {
                JOptionPane.showMessageDialog(null, "Please enter a value greater than 0 and less than 1!", "Error", 0);
            }
        }

        protected void reset() {
            for (int i = 0; i < this.oneClassPanel.exptCheckBoxes.length; ++i) {
                this.oneClassPanel.exptCheckBoxes[i].setSelected(true);
            }
        }

        class ExperimentsPanel
        extends JPanel {
            int numPanels = 0;
            int numberGroups;
            JLabel[] expLabels;
            JCheckBox[] exptCheckBoxes;
            JRadioButton[][] rbArray;

            ExperimentsPanel(Vector<String> exptNames, int numGroups) {
                int i;
                int i2;
                this.setBorder(new TitledBorder(new EtchedBorder(), "Experiment Assignments", 0, 0, new Font("Dialog", 1, 12), Color.black));
                this.setBackground(Color.white);
                this.numberGroups = numGroups;
                ButtonGroup[] chooseGroup = new ButtonGroup[exptNames.size()];
                this.expLabels = new JLabel[exptNames.size()];
                this.exptCheckBoxes = new JCheckBox[exptNames.size()];
                this.rbArray = new JRadioButton[exptNames.size()][this.numberGroups + 1];
                this.numPanels = exptNames.size() / 512 + 1;
                GridBagLayout gridbag = new GridBagLayout();
                GridBagLayout gridbag2 = new GridBagLayout();
                GridBagConstraints constraints = new GridBagConstraints();
                this.setLayout(gridbag2);
                JPanel[] panels = new JPanel[this.numPanels];
                int currPanel = 0;
                for (i2 = 0; i2 < panels.length; ++i2) {
                    panels[i2] = new JPanel(gridbag);
                }
                for (i2 = 0; i2 < exptNames.size(); ++i2) {
                    String s1 = exptNames.get(i2);
                    this.expLabels[i2] = new JLabel(s1);
                    MINETInitBox.this.buildConstraints(constraints, 0, i2 % 512, 1, 1, 100, 100);
                    if (numGroups == 1) {
                        constraints.anchor = 17;
                        this.exptCheckBoxes[i2] = new JCheckBox("", true);
                        gridbag.setConstraints(this.exptCheckBoxes[i2], constraints);
                        panels[currPanel].add(this.exptCheckBoxes[i2]);
                        continue;
                    }
                    chooseGroup[i2] = new ButtonGroup();
                    for (int j = 0; j < this.numberGroups + 1; ++j) {
                        this.rbArray[i2][j] = new JRadioButton("Group " + (j + 1));
                        if (j == this.numberGroups) {
                            this.rbArray[i2][j] = new JRadioButton("Excluded");
                        }
                        chooseGroup[i2].add(this.rbArray[i2][j]);
                        MINETInitBox.this.buildConstraints(constraints, j, i2 % 512, 1, 1, 100, 100);
                        gridbag.setConstraints(this.rbArray[i2][j], constraints);
                        panels[currPanel].add(this.rbArray[i2][j]);
                    }
                    this.rbArray[i2][this.numberGroups].setSelected(true);
                }
                int maxLabelWidth = 0;
                for (int i3 = 0; i3 < this.expLabels.length; ++i3) {
                    if (!(this.expLabels[i3].getPreferredSize().getWidth() > (double)maxLabelWidth)) continue;
                    maxLabelWidth = (int)Math.ceil(this.expLabels[i3].getPreferredSize().getWidth());
                }
                JPanel bigPanel = new JPanel(new GridBagLayout());
                for (int i4 = 0; i4 < this.numPanels; ++i4) {
                    bigPanel.add((Component)panels[i4], new GridBagConstraints(0, i4, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                }
                JScrollPane scroll = new JScrollPane(bigPanel);
                scroll.setHorizontalScrollBarPolicy(32);
                scroll.setVerticalScrollBarPolicy(22);
                JPanel[] exptNameHeaderPanels = new JPanel[this.numPanels];
                GridBagLayout exptHeaderGridbag = new GridBagLayout();
                for (i = 0; i < exptNameHeaderPanels.length; ++i) {
                    exptNameHeaderPanels[i] = new JPanel();
                    exptNameHeaderPanels[i].setSize(50, panels[i].getPreferredSize().height);
                    exptNameHeaderPanels[i].setPreferredSize(new Dimension(maxLabelWidth + 10, panels[i].getPreferredSize().height));
                    exptNameHeaderPanels[i].setLayout(exptHeaderGridbag);
                }
                for (i = 0; i < this.expLabels.length; ++i) {
                    currPanel = i / 512;
                    MINETInitBox.this.buildConstraints(constraints, 0, i % 512, 1, 1, 100, 100);
                    constraints.fill = 1;
                    exptHeaderGridbag.setConstraints(this.expLabels[i], constraints);
                    exptNameHeaderPanels[currPanel].add(this.expLabels[i]);
                }
                JPanel headerPanel = new JPanel(new GridBagLayout());
                for (int i5 = 0; i5 < exptNameHeaderPanels.length; ++i5) {
                    headerPanel.add((Component)exptNameHeaderPanels[i5], new GridBagConstraints(0, i5, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                }
                scroll.setRowHeaderView(headerPanel);
                MINETInitBox.this.buildConstraints(constraints, 0, 0, 1, 1, 100, 90);
                constraints.fill = 1;
                gridbag2.setConstraints(scroll, constraints);
                this.add(scroll);
                JPanel panel2 = new JPanel();
                GridBagLayout gridbag3 = new GridBagLayout();
                panel2.setLayout(gridbag3);
                panel2.setBackground(Color.white);
                JButton saveButton = new JButton("  Save settings  ");
                saveButton.setFocusPainted(false);
                saveButton.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
                JButton loadButton = new JButton("  Load settings  ");
                loadButton.setFocusPainted(false);
                loadButton.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
                JButton resetButton = new JButton("  Reset  ");
                resetButton.setFocusPainted(false);
                resetButton.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
                resetButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        ExperimentsPanel.this.reset();
                    }
                });
                JFileChooser fc = new JFileChooser(TMEV.getDataPath());
                saveButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        if (ExperimentsPanel.this.numberGroups == 1) {
                            ExperimentsPanel.this.saveOneClassAssignments();
                        }
                    }
                });
                loadButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        if (ExperimentsPanel.this.numberGroups == 1) {
                            ExperimentsPanel.this.loadOneClassAssignments();
                        }
                    }
                });
                constraints.anchor = 10;
                constraints.fill = 0;
                constraints.insets = new Insets(5, 5, 5, 5);
                MINETInitBox.this.buildConstraints(constraints, 0, 0, 1, 1, 33, 100);
                gridbag3.setConstraints(saveButton, constraints);
                panel2.add(saveButton);
                MINETInitBox.this.buildConstraints(constraints, 1, 0, 1, 1, 33, 0);
                gridbag3.setConstraints(loadButton, constraints);
                panel2.add(loadButton);
                MINETInitBox.this.buildConstraints(constraints, 2, 0, 1, 1, 34, 0);
                gridbag3.setConstraints(resetButton, constraints);
                panel2.add(resetButton);
                constraints.insets = new Insets(0, 0, 0, 0);
                MINETInitBox.this.buildConstraints(constraints, 0, 2, 1, 1, 0, 5);
                constraints.anchor = 10;
                gridbag2.setConstraints(panel2, constraints);
                this.add(panel2);
            }

            protected void reset() {
                for (int i = 0; i < MainPanel.this.oneClassPanel.exptCheckBoxes.length; ++i) {
                    MainPanel.this.oneClassPanel.exptCheckBoxes[i].setSelected(true);
                }
            }

            private void saveOneClassAssignments() {
                JFileChooser fileChooser = new JFileChooser(TMEV.getDataPath());
                if (fileChooser.showSaveDialog(this) == 0) {
                    File file = fileChooser.getSelectedFile();
                    try {
                        PrintWriter pw = new PrintWriter(new FileWriter(file));
                        Date currDate = new Date(System.currentTimeMillis());
                        String dateString = currDate.toString();
                        String userName = System.getProperty("user.name");
                        pw.println("# Assignment File");
                        pw.println("# User: " + userName + " Save Date: " + dateString);
                        pw.println("#");
                        pw.print("Module:\t");
                        pw.println("MINET");
                        pw.print("Group 1 Label:\t");
                        pw.println("Include");
                        pw.println("#");
                        pw.println("Sample Index\tSample Name\tGroup Assignment");
                        for (int sample = 0; sample < MINETInitBox.this.exptNames.size(); ++sample) {
                            pw.print(String.valueOf(sample + 1) + "\t");
                            pw.print(MINETInitBox.this.exptNames.get(sample) + "\t");
                            if (this.exptCheckBoxes[sample].isSelected()) {
                                pw.println("Include");
                                continue;
                            }
                            pw.println("Exclude");
                        }
                        pw.flush();
                        pw.close();
                    }
                    catch (FileNotFoundException fnfe) {
                        fnfe.printStackTrace();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
            }

            private void loadOneClassAssignments() {
                JFileChooser fileChooser = new JFileChooser(TMEV.getDataPath());
                if (fileChooser.showOpenDialog(this) == 0) {
                    File file = fileChooser.getSelectedFile();
                    try {
                        String line;
                        BufferedReader br = new BufferedReader(new FileReader(file));
                        Vector<String> data = new Vector<String>();
                        while ((line = br.readLine()) != null) {
                            data.add(line.trim());
                        }
                        br.close();
                        Vector<String> groupNames = new Vector<String>();
                        Vector<Integer> sampleIndices = new Vector<Integer>();
                        Vector<String> sampleNames = new Vector<String>();
                        Vector<String> groupAssignments = new Vector<String>();
                        for (int row = 0; row < data.size(); ++row) {
                            line = (String)data.get(row);
                            if (line.startsWith("#") || line.startsWith("SampleIndex")) continue;
                            String[] lineArray = line.split("\t");
                            if (lineArray[0].startsWith("Module:")) {
                                if (lineArray[1].equals("MINET")) continue;
                                Object[] optionst = new Object[]{"Continue", "Cancel"};
                                if (JOptionPane.showOptionDialog(null, "The saved file was saved using a different module, " + lineArray[1] + ". \n Would you like MeV to try to load it anyway?", "File type warning", 1, 3, null, optionst, optionst[0]) == 0) continue;
                                return;
                            }
                            if (lineArray[0].startsWith("Group ") && lineArray[0].endsWith("Label:")) {
                                groupNames.add(lineArray[1]);
                                continue;
                            }
                            try {
                                Integer.parseInt(lineArray[0]);
                            }
                            catch (NumberFormatException nfe) {
                                continue;
                            }
                            sampleIndices.add(new Integer(lineArray[0]));
                            sampleNames.add(lineArray[1]);
                            groupAssignments.add(lineArray[2]);
                        }
                        if (MINETInitBox.this.exptNames.size() != sampleNames.size()) {
                            System.out.println(MINETInitBox.this.exptNames.size() + " s length " + sampleNames.size());
                            JOptionPane.showMessageDialog(this, "<html>Error -- number of samples designated in assignment file (" + String.valueOf(sampleNames.size()) + ")<br>" + "does not match the number of samples loaded in MeV (" + MINETInitBox.this.exptNames.size() + ").<br>" + "Assingments are not set.</html>", "File Compatibility Error", 0);
                            return;
                        }
                        Vector<String> currSampleVector = new Vector<String>();
                        for (int i = 0; i < MINETInitBox.this.exptNames.size(); ++i) {
                            currSampleVector.add(MINETInitBox.this.exptNames.get(i));
                        }
                        int fileSampleIndex = 0;
                        int groupIndex = 0;
                        for (int sample = 0; sample < MINETInitBox.this.exptNames.size(); ++sample) {
                            boolean doIndex = false;
                            for (int i = 0; i < MINETInitBox.this.exptNames.size(); ++i) {
                                if (i == sample || !MINETInitBox.this.exptNames.get(i).equals(MINETInitBox.this.exptNames.get(sample))) continue;
                                doIndex = true;
                            }
                            fileSampleIndex = sampleNames.indexOf(MINETInitBox.this.exptNames.get(sample));
                            if (fileSampleIndex == -1) {
                                doIndex = true;
                            }
                            if (doIndex) {
                                this.setOneClassStateBasedOnIndex(groupAssignments, groupNames);
                                break;
                            }
                            String groupName = (String)groupAssignments.get(fileSampleIndex);
                            groupIndex = groupNames.indexOf(groupName);
                            if (groupIndex == 0) {
                                this.exptCheckBoxes[sample].setSelected(true);
                                continue;
                            }
                            this.exptCheckBoxes[sample].setSelected(false);
                        }
                        this.repaint();
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(this, "<html>The file format cannot be read.</html>", "File Compatibility Error", 0);
                    }
                }
            }

            private void setOneClassStateBasedOnIndex(Vector<String> groupAssignments, Vector<String> groupNames) {
                Object[] optionst = new Object[]{"Continue", "Cancel"};
                if (JOptionPane.showOptionDialog(null, "The saved file was saved using a different sample annotation or has duplicate annotation. \n Would you like MeV to try to load it by index order?", "File type warning", 1, 3, null, optionst, optionst[0]) == 1) {
                    return;
                }
                for (int sample = 0; sample < MINETInitBox.this.exptNames.size(); ++sample) {
                    if (groupNames.indexOf(groupAssignments.get(sample)) == 0) {
                        this.exptCheckBoxes[sample].setSelected(true);
                        continue;
                    }
                    this.exptCheckBoxes[sample].setSelected(false);
                }
            }

            private void loadTwoClassAssignments() {
                JFileChooser fileChooser = new JFileChooser(TMEV.getDataPath());
                if (fileChooser.showOpenDialog(this) == 0) {
                    File file = fileChooser.getSelectedFile();
                    try {
                        String line;
                        BufferedReader br = new BufferedReader(new FileReader(file));
                        Vector<String> data = new Vector<String>();
                        while ((line = br.readLine()) != null) {
                            data.add(line.trim());
                        }
                        br.close();
                        Vector<String> groupNames = new Vector<String>();
                        Vector<Integer> sampleIndices = new Vector<Integer>();
                        Vector<String> sampleNames = new Vector<String>();
                        Vector<String> groupAssignments = new Vector<String>();
                        for (int row = 0; row < data.size(); ++row) {
                            line = (String)data.get(row);
                            if (line.startsWith("#") || line.startsWith("SampleIndex")) continue;
                            String[] lineArray = line.split("\t");
                            if (lineArray[0].startsWith("Module:")) {
                                if (lineArray[1].equals("MINET: Two-Class Unpaired")) continue;
                                Object[] optionst = new Object[]{"Continue", "Cancel"};
                                if (JOptionPane.showOptionDialog(null, "The saved file was saved using a different module, " + lineArray[1] + ". \n Would you like MeV to try to load it anyway?", "File type warning", 1, 3, null, optionst, optionst[0]) == 0) continue;
                                return;
                            }
                            if (lineArray[0].startsWith("Group ") && lineArray[0].endsWith("Label:")) {
                                groupNames.add(lineArray[1]);
                                continue;
                            }
                            try {
                                Integer.parseInt(lineArray[0]);
                            }
                            catch (NumberFormatException nfe) {
                                continue;
                            }
                            sampleIndices.add(new Integer(lineArray[0]));
                            sampleNames.add(lineArray[1]);
                            groupAssignments.add(lineArray[2]);
                        }
                        if (MINETInitBox.this.exptNames.size() != sampleNames.size()) {
                            System.out.println(MINETInitBox.this.exptNames.size() + "  " + sampleNames.size());
                            System.out.println(MINETInitBox.this.exptNames.size() + " s length " + sampleNames.size());
                            JOptionPane.showMessageDialog(this, "<html>Error -- number of samples designated in assignment file (" + String.valueOf(sampleNames.size()) + ")<br>" + "does not match the number of samples loaded in MeV (" + MINETInitBox.this.exptNames.size() + ").<br>" + "Assignments are not set.</html>", "File Compatibility Error", 0);
                            return;
                        }
                        int fileSampleIndex = 0;
                        int groupIndex = 0;
                        for (int sample = 0; sample < MINETInitBox.this.exptNames.size(); ++sample) {
                            boolean doIndex = false;
                            for (int i = 0; i < MINETInitBox.this.exptNames.size(); ++i) {
                                if (i == sample || !MINETInitBox.this.exptNames.get(i).equals(MINETInitBox.this.exptNames.get(sample))) continue;
                                doIndex = true;
                            }
                            fileSampleIndex = sampleNames.indexOf(MINETInitBox.this.exptNames.get(sample));
                            if (fileSampleIndex == -1) {
                                doIndex = true;
                            }
                            if (doIndex) {
                                this.setTwoClassStateBasedOnIndex(groupAssignments, groupNames);
                                break;
                            }
                            String groupName = (String)groupAssignments.get(fileSampleIndex);
                            groupIndex = groupNames.indexOf(groupName);
                            try {
                                if (groupIndex == 0) {
                                    this.rbArray[sample][0].setSelected(true);
                                }
                                if (groupIndex == 1) {
                                    this.rbArray[sample][1].setSelected(true);
                                }
                                if (groupIndex != 2 && groupIndex != -1) continue;
                                this.rbArray[sample][2].setSelected(true);
                                continue;
                            }
                            catch (Exception e) {
                                this.rbArray[sample][2].setSelected(true);
                            }
                        }
                        this.repaint();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(this, "<html>The file format cannot be read.</html>", "File Compatibility Error", 0);
                    }
                }
            }

            private void setTwoClassStateBasedOnIndex(Vector<String> groupAssignments, Vector<String> groupNames) {
                Object[] optionst = new Object[]{"Continue", "Cancel"};
                if (JOptionPane.showOptionDialog(null, "The saved file was saved using a different sample annotation or has duplicate annotation. \n Would you like MeV to try to load it by index order?", "File type warning", 1, 3, null, optionst, optionst[0]) == 1) {
                    return;
                }
                for (int sample = 0; sample < MINETInitBox.this.exptNames.size(); ++sample) {
                    try {
                        if (groupNames.indexOf(groupAssignments.get(sample)) == 0) {
                            this.rbArray[0][sample].setSelected(true);
                        }
                        if (groupNames.indexOf(groupAssignments.get(sample)) == 1) {
                            this.rbArray[1][sample].setSelected(true);
                        }
                        if (groupNames.indexOf(groupAssignments.get(sample)) != 2 && groupNames.indexOf(groupAssignments.get(sample)) != -1) continue;
                        this.rbArray[2][sample].setSelected(true);
                        continue;
                    }
                    catch (Exception e) {
                        this.rbArray[2][sample].setSelected(true);
                    }
                }
            }
        }
    }
}

