/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.minet;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.annotation.MevAnnotation;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.impl.bn.CytoscapeWebstart;
import org.tigr.microarray.mev.cluster.gui.impl.bn.NullArgumentException;
import org.tigr.microarray.mev.cluster.gui.impl.bn.XGMMLGenerator;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLGUI;
import org.tigr.microarray.mev.cluster.gui.impl.minet.MINETInitBox;
import org.tigr.microarray.mev.script.scriptGUI.IScriptGUI;
import org.tigr.util.FloatMatrix;

public class MINETGUI
implements IClusterGUI,
IScriptGUI {
    protected Algorithm algorithm;
    protected Progress progress;
    protected Experiment experiment;
    boolean debug = true;
    protected String methodName = null;
    protected String estimatorName = null;
    protected String discretizationName = null;
    protected int bins = 0;
    protected ArrayList<String> geneLabels;
    protected ArrayList<String> sampleLabels;
    Vector<String> exptNamesVector;
    protected int[] groupAssignments;
    protected IData data;
    protected int dataDesign;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework framework) throws AlgorithmException {
        int i;
        if (this.sysMsg("R 2.11.x", "MINET") != 0) {
            return null;
        }
        this.experiment = framework.getData().getExperiment();
        this.data = framework.getData();
        this.exptNamesVector = new Vector();
        int number_of_samples = this.experiment.getNumberOfSamples();
        int[] columnIndices = this.experiment.getColumnIndicesCopy();
        this.sampleLabels = new ArrayList();
        this.geneLabels = new ArrayList();
        for (i = 0; i < number_of_samples; ++i) {
            this.exptNamesVector.add(framework.getData().getFullSampleName(columnIndices[i]));
            this.sampleLabels.add(framework.getData().getFullSampleName(columnIndices[i]));
        }
        for (i = 0; i < this.experiment.getNumberOfGenes(); ++i) {
            this.geneLabels.add(String.valueOf(i));
        }
        MINETInitBox MINETDialog = new MINETInitBox((JFrame)framework.getFrame(), true, this.exptNamesVector, framework.getClusterRepository(1), framework.getClusterRepository(0));
        MINETDialog.setVisible(true);
        if (!MINETDialog.isOkPressed()) {
            return null;
        }
        this.methodName = MINETDialog.methodsPanel.getMethodName();
        this.estimatorName = MINETDialog.estimatorPanel.getEstimatorName();
        this.discretizationName = MINETDialog.discretizationPanel.getDiscretizationMethodName();
        this.dataDesign = MINETDialog.getTestDesign();
        if (MINETDialog.getTestDesign() == 7) {
            if (MINETDialog.getSelectionDesign() == 11) {
                this.groupAssignments = MINETDialog.getClusterOneClassAssignments();
            }
            if (MINETDialog.getSelectionDesign() == 10) {
                this.groupAssignments = MINETDialog.getOneClassAssignments();
            }
        }
        int samplesUsed = 0;
        for (int i2 = 0; i2 < this.groupAssignments.length; ++i2) {
            if (this.groupAssignments[i2] == 0) continue;
            ++samplesUsed;
        }
        int[] sampleIndices = new int[samplesUsed];
        int ii = 0;
        for (int i3 = 0; i3 < this.groupAssignments.length; ++i3) {
            if (this.groupAssignments[i3] != 1) continue;
            sampleIndices[ii++] = i3;
        }
        System.out.println(samplesUsed + " out of " + this.groupAssignments.length + " used.");
        if (!this.discretizationName.equals("none")) {
            this.bins = (int)Math.round(Math.sqrt(samplesUsed));
        }
        int[] geneIndices = MINETDialog.getSelectedCluster().getIndices();
        if (this.debug) {
            System.out.println("Selected gene indices from CLuster");
            for (int i4 = 0; i4 < geneIndices.length; ++i4) {
                System.out.println("Gene " + i4 + " in Cluster has data index of: " + geneIndices[i4]);
            }
        }
        FloatMatrix fm = new FloatMatrix(geneIndices.length, samplesUsed);
        for (int row = 0; row < geneIndices.length; ++row) {
            for (int col = 0; col < sampleIndices.length; ++col) {
                fm.set(row, col, this.experiment.get(geneIndices[row], sampleIndices[col]));
            }
        }
        Listener listener = new Listener();
        try {
            this.algorithm = framework.getAlgorithmFactory().getAlgorithm("MINET");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            this.progress = new Progress(framework.getFrame(), "Running Mutual Information network...", listener);
            this.progress.show();
            AlgorithmData data = new AlgorithmData();
            data.addMatrix("experiment", fm);
            data.addParam("dataDesign", String.valueOf(this.dataDesign));
            data.addIntArray("group_assignments", this.groupAssignments);
            data.addParam("methodName", this.methodName);
            data.addParam("estimatorName", this.estimatorName);
            data.addParam("discretizationName", this.discretizationName);
            data.addParam("bins", String.valueOf(this.bins));
            data.addParam("classes", String.valueOf(MINETDialog.getTestDesign()));
            data.addStringArray("geneLabels", this.geneLabels.toArray(new String[this.geneLabels.size()]));
            data.addStringArray("sampleLabels", this.sampleLabels.toArray(new String[this.sampleLabels.size()]));
            long start = System.currentTimeMillis();
            AlgorithmData result = this.algorithm.execute(data);
            long time = System.currentTimeMillis() - start;
            FloatMatrix netAdjMatrix = result.getMatrix("network");
            ArrayList<String> edgesList = this.getGeneEdges(netAdjMatrix, geneIndices);
            String netFileDir = System.getProperty("user.dir") + "/data/results";
            File file = new File(netFileDir);
            boolean exists = file.exists();
            if (!exists && !file.mkdir()) {
                throw new AlgorithmException("Result dir could not be created");
            }
            String netFileName = netFileDir + "/Minet_" + MINETGUI.getUniqueFileID() + ".xgmml";
            try {
                this.fromSimpleEdgeToXgmml(false, edgesList, netFileName);
            }
            catch (NullArgumentException e) {
                e.printStackTrace();
                throw new AlgorithmException((Exception)e);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new AlgorithmException((Exception)e);
            }
            Vector<String> files = new Vector<String>();
            files.add(netFileName);
            CytoscapeWebstart.onWebstartCytoscapeMINET(files);
            GeneralInfo info = new GeneralInfo();
            info.time = time;
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(info);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
        }
    }

    private ArrayList<String> getGeneEdges(FloatMatrix netAdjMatrix, int[] geneIndices) {
        int rows = netAdjMatrix.getRowDimension();
        int cols = netAdjMatrix.getColumnDimension();
        ArrayList<String> edges = new ArrayList<String>();
        for (int i = 0; i < rows; ++i) {
            for (int ii = i; ii < cols; ++ii) {
                if (!(netAdjMatrix.get(i, ii) > 0.0f)) continue;
                edges.add(geneIndices[i] + " pd " + geneIndices[ii]);
            }
        }
        return edges;
    }

    public AlgorithmData getScriptParameters(IFramework framework) {
        this.experiment = framework.getData().getExperiment();
        this.exptNamesVector = new Vector();
        int number_of_samples = this.experiment.getNumberOfSamples();
        for (int i = 0; i < number_of_samples; ++i) {
            this.exptNamesVector.add(framework.getData().getFullSampleName(this.experiment.getSampleIndex(i)));
        }
        MINETInitBox MINETDialog = new MINETInitBox((JFrame)framework.getFrame(), true, this.exptNamesVector, framework.getClusterRepository(1), framework.getClusterRepository(0));
        MINETDialog.setVisible(true);
        if (!MINETDialog.isOkPressed()) {
            return null;
        }
        if (MINETDialog.getTestDesign() == 7) {
            if (MINETDialog.getSelectionDesign() == 11) {
                this.groupAssignments = MINETDialog.getClusterOneClassAssignments();
            }
            if (MINETDialog.getSelectionDesign() == 10) {
                this.groupAssignments = MINETDialog.getOneClassAssignments();
            }
        }
        AlgorithmData data = new AlgorithmData();
        data.addParam("name", "MINET");
        data.addParam("alg-type", "data-visualization");
        data.addParam("output-class", "partition-output");
        String[] outputNodes = new String[]{"Significant Genes", "Non-significant Genes"};
        data.addStringArray("output-nodes", outputNodes);
        return data;
    }

    public void fromSimpleEdgeToXgmml(boolean edgeDir, ArrayList<String> inter, String fileName) throws NullArgumentException, IOException {
        String[] nodeids;
        int i;
        Hashtable<String, MevAnnotation> uniqueNodesWithId = new Hashtable<String, MevAnnotation>();
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
        String xgmmlContent = "";
        String label = fileName.substring(0, fileName.lastIndexOf("."));
        xgmmlContent = XGMMLGenerator.createHeader(label, "");
        out.write(xgmmlContent);
        xgmmlContent = "";
        for (i = 0; i < inter.size(); ++i) {
            nodeids = inter.get(i).split(" pd ");
            int labelFrom = Integer.parseInt(nodeids[0].trim());
            int labelTo = Integer.parseInt(nodeids[1].trim());
            if (!uniqueNodesWithId.containsKey(nodeids[0])) {
                MevAnnotation annoFrom = (MevAnnotation)this.data.getSlideDataElement(0, labelFrom).getElementAnnotation();
                uniqueNodesWithId.put(nodeids[0], annoFrom);
                xgmmlContent = XGMMLGenerator.createNode(annoFrom.getGeneSymbol(), nodeids[0], this.data, labelFrom);
                out.write(xgmmlContent);
            }
            if (uniqueNodesWithId.containsKey(nodeids[1])) continue;
            MevAnnotation annoTo = (MevAnnotation)this.data.getSlideDataElement(0, labelTo).getElementAnnotation();
            uniqueNodesWithId.put(nodeids[1], annoTo);
            xgmmlContent = XGMMLGenerator.createNode(annoTo.getGeneSymbol(), nodeids[1], this.data, labelTo);
            out.write(xgmmlContent);
        }
        for (i = 0; i < inter.size(); ++i) {
            nodeids = inter.get(i).split(" pd ");
            xgmmlContent = XGMMLGenerator.createEdge(edgeDir, ((MevAnnotation)uniqueNodesWithId.get(nodeids[0])).getGenBankAcc(), ((MevAnnotation)uniqueNodesWithId.get(nodeids[1])).getGenBankAcc(), nodeids[0], nodeids[1]);
            out.write(xgmmlContent);
        }
        xgmmlContent = XGMMLGenerator.getFooter();
        out.write(xgmmlContent);
        out.flush();
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode executeScript(IFramework framework, AlgorithmData algData, Experiment experiment) throws AlgorithmException {
        Listener listener = new Listener();
        this.experiment = experiment;
        this.data = framework.getData();
        this.groupAssignments = algData.getIntArray("condition_assignments");
        this.exptNamesVector = new Vector();
        int number_of_samples = experiment.getNumberOfSamples();
        for (int i = 0; i < number_of_samples; ++i) {
            this.exptNamesVector.add(this.data.getFullSampleName(i));
        }
        try {
            algData.addMatrix("experiment", experiment.getMatrix());
            this.algorithm = framework.getAlgorithmFactory().getAlgorithm("MINET");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            this.progress = new Progress(framework.getFrame(), "Running MINET Analysis...", listener);
            this.progress.show();
            long start = System.currentTimeMillis();
            AlgorithmData result = this.algorithm.execute(algData);
            long time = System.currentTimeMillis() - start;
            AlgorithmParameters params = algData.getParams();
            GeneralInfo info = new GeneralInfo();
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(info);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
        }
    }

    protected String getSigMethod(int sigMethod) {
        String methodName = "";
        if (sigMethod == 1) {
            methodName = "Just alpha (uncorrected)";
        } else if (sigMethod == 2) {
            methodName = "Standard Bonferroni correction";
        } else if (sigMethod == 3) {
            methodName = "Adjusted Bonferroni correction";
        } else if (sigMethod == 4) {
            methodName = "Westfall Young stepdown - MaxT";
        } else if (sigMethod == 5 || sigMethod == 6) {
            // empty if block
        }
        return methodName;
    }

    protected DefaultMutableTreeNode createResultTree(GeneralInfo info) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("MINET");
        this.addResultNodes(root, info);
        return root;
    }

    protected void addResultNodes(DefaultMutableTreeNode root, GeneralInfo info) {
        this.addGeneralInfo(root, info);
    }

    protected void addGeneralInfo(DefaultMutableTreeNode root, GeneralInfo info) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("General Information");
        node.add(this.getConditionAssignmentInfo());
        node.add(new DefaultMutableTreeNode("Inference Algorithm: " + this.methodName));
        node.add(new DefaultMutableTreeNode("Mutual Info Estimator: " + this.estimatorName));
        node.add(new DefaultMutableTreeNode("Discretization: " + this.discretizationName));
        if (!this.discretizationName.equals("none")) {
            node.add(new DefaultMutableTreeNode("Bins: " + this.bins));
        }
        node.add(new DefaultMutableTreeNode("Time: " + String.valueOf(info.time - 1L) + " ms"));
        root.add(node);
    }

    protected DefaultMutableTreeNode getConditionAssignmentInfo() {
        DefaultMutableTreeNode groupAssignmentInfo = new DefaultMutableTreeNode("Group assignments ");
        DefaultMutableTreeNode notInGroups = new DefaultMutableTreeNode("Samples Excluded");
        DefaultMutableTreeNode inGroup = new DefaultMutableTreeNode("Samples Included");
        groupAssignmentInfo.add(inGroup);
        for (int i = 0; i < this.groupAssignments.length; ++i) {
            int currentGroup = this.groupAssignments[i];
            if (currentGroup == 0) {
                notInGroups.add(new DefaultMutableTreeNode(this.exptNamesVector.get(i)));
                continue;
            }
            inGroup.add(new DefaultMutableTreeNode(this.exptNamesVector.get(i)));
        }
        if (notInGroups.getChildCount() > 0) {
            groupAssignmentInfo.add(notInGroups);
        }
        return groupAssignmentInfo;
    }

    private int sysMsg(String rVer, String module) {
        String os = System.getProperty("os.name");
        String arch = System.getProperty("os.arch");
        String ver = System.getProperty("os.version");
        String message = "System Config:\n";
        message = message + "OS: " + os + " | Architecture: " + arch + " | Version: " + ver + "\n";
        message = message + "Please note:\n";
        if (arch.toLowerCase().contains("64") && os.toLowerCase().contains("mac")) {
            message = message + "You need to have 32Bit JVM as default for " + module + "\n";
            message = message + "Please contact MeV Support if you need help.\n";
            message = message + "You also need to have" + rVer + " installed for " + module + "\n";
            message = message + "Cancel if either is not installed. Ok to continue.";
            return JOptionPane.showConfirmDialog(null, message, "R Engine Warning", 2, 2);
        }
        if (arch.toLowerCase().contains("64")) {
            message = message + "You need to have 32Bit JVM as default for " + module + "\n";
            message = message + "Please contact MeV Support if you need help.\n";
            message = message + "Cancel if 32 Bit JVM is not installed. Ok to continue.";
            return JOptionPane.showConfirmDialog(null, message, "R Engine Warning", 2, 2);
        }
        if (os.toLowerCase().contains("mac")) {
            message = message + "You need to have" + rVer + " installed for " + module + "\n";
            message = message + "Cancel if R is not installed. Ok to continue.";
            return JOptionPane.showConfirmDialog(null, message, "R Engine Warning", 2, 2);
        }
        return 0;
    }

    private static String getUniqueFileID() {
        Date now = new Date();
        String dateString = now.toString();
        SimpleDateFormat formatDt = new SimpleDateFormat("MMM_dd_yy_HHmmssSSS");
        dateString = formatDt.format(now);
        return dateString;
    }

    protected class GeneralInfo {
        public int clusters;
        public String correctionMethod;
        public float alpha;
        public long time;
        public String function;
        protected boolean hcl;
        protected boolean usePerms;
        protected int hcl_method;
        protected int numPerms;
        protected boolean hcl_genes;
        protected boolean hcl_samples;

        protected GeneralInfo() {
        }

        public String getMethodName() {
            return this.hcl ? HCLGUI.GeneralInfo.getMethodName(this.hcl_method) : "no linkage";
        }
    }

    protected class Listener
    extends DialogListener
    implements AlgorithmListener {
        protected Listener() {
        }

        public void valueChanged(AlgorithmEvent event) {
            switch (event.getId()) {
                case 1: {
                    MINETGUI.this.progress.setUnits(event.getIntValue());
                    MINETGUI.this.progress.setDescription(event.getDescription());
                    break;
                }
                case 2: {
                    MINETGUI.this.progress.setValue(event.getIntValue());
                    MINETGUI.this.progress.setDescription(event.getDescription());
                    break;
                }
                case 3: {
                    int value = event.getIntValue();
                    if (value != -1) break;
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("cancel-command")) {
                MINETGUI.this.algorithm.abort();
                MINETGUI.this.progress.dispose();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            MINETGUI.this.algorithm.abort();
            MINETGUI.this.progress.dispose();
        }
    }
}

