/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.lm;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.clusterUtil.Cluster;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterRepository;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterBrowser;
import org.tigr.microarray.mev.cluster.gui.impl.bn.BNConstants;
import org.tigr.microarray.mev.cluster.gui.impl.bn.BNDownloadManager;
import org.tigr.microarray.mev.cluster.gui.impl.bn.BNSupportDataFile;
import org.tigr.microarray.mev.cluster.gui.impl.bn.BNUpdateManager;
import org.tigr.microarray.mev.cluster.gui.impl.bn.Useful;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.microarray.mev.resources.IResourceManager;
import org.tigr.microarray.mev.resources.ISupportFileDefinition;
import org.tigr.microarray.mev.resources.ResourcererAnnotationFileDefinition;
import org.tigr.microarray.mev.resources.SupportFileAccessError;

public class LiteratureMiningDialog
extends AlgorithmDialog {
    private int result = 2;
    ConfigPanel configPanel;
    PriorSelectionPanel priorsPanel;
    DiscretizingPanel discPanel;
    ClassNumPanel classnumPanel;
    XmlBifPanel useGoPanel;
    RunBNPanel runBNPanel;
    PopSelectionPanel popPanel;
    BootStrapPanel bootStrapPanel;
    ClusterBrowser browser;
    EventListener listener;
    BNParameterPanel bnParamPanel;
    AlphaPanel statParamsPanel;
    JTabbedPane tabbedPane;
    Font font;
    Frame parent;
    IFramework framework;
    String kegg_sp = null;
    protected String arrayName;
    protected String speciesName;
    protected Hashtable<String, Vector<String>> speciestoarrays;
    protected IResourceManager resourceManager;
    protected boolean useLoadedAnnotationFile = false;
    File annotationFile;

    public LiteratureMiningDialog(IFramework frame, ClusterRepository repository, String[] annotationLabels, IResourceManager rm, String speciesName, String arrayName, Hashtable<String, Vector<String>> speciestoarrays) {
        super(frame.getFrame(), "LM: Literature Mining Analysis", true);
        this.parent = frame.getFrame();
        this.framework = frame;
        this.speciesName = speciesName;
        this.arrayName = arrayName;
        this.resourceManager = rm;
        this.speciestoarrays = speciestoarrays;
        this.font = new Font("Dialog", 1, 12);
        this.listener = new EventListener();
        this.addWindowListener(this.listener);
        this.tabbedPane = new JTabbedPane();
        this.configPanel = new ConfigPanel();
        JPanel popNClusterPanel = new JPanel(new GridBagLayout());
        popNClusterPanel.setBackground(Color.white);
        this.popPanel = new PopSelectionPanel();
        this.browser = new ClusterBrowser(repository);
        popNClusterPanel.add((Component)this.browser, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.tabbedPane.add("Population and Cluster Selection", popNClusterPanel);
        this.bnParamPanel = new BNParameterPanel(annotationLabels);
        JPanel parameters = new JPanel(new GridBagLayout());
        parameters.setBackground(Color.white);
        this.priorsPanel = new PriorSelectionPanel(repository != null && !repository.isEmpty());
        this.bootStrapPanel = new BootStrapPanel();
        this.discPanel = new DiscretizingPanel();
        this.classnumPanel = new ClassNumPanel();
        this.useGoPanel = new XmlBifPanel();
        parameters.add((Component)this.configPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        parameters.add((Component)this.priorsPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        parameters.add((Component)this.useGoPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        parameters.add((Component)this.tabbedPane, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addContent(parameters);
        this.setActionListeners(this.listener);
        if (repository == null || repository.isEmpty()) {
            Component comp = this.tabbedPane.getComponentAt(0);
            JPanel panel = (JPanel)comp;
            panel.removeAll();
            panel.validate();
            panel.setOpaque(false);
            panel.add((Component)new JLabel("Empty Cluster Repository"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(15, 0, 10, 0), 0, 0));
            panel.add((Component)new JLabel("Please create a gene cluster and launch LM again."), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.tabbedPane.setSelectedIndex(0);
            this.okButton.setEnabled(false);
        }
        this.setSize(600, 750);
    }

    public LiteratureMiningDialog(Frame parent, String[] annotationLabels) {
        super(parent, " LM: Literature Mining Analysis", true);
        this.parent = parent;
        this.font = new Font("Dialog", 1, 12);
        this.listener = new EventListener();
        this.addWindowListener(this.listener);
        this.tabbedPane = new JTabbedPane();
        this.configPanel = new ConfigPanel();
        JPanel popNClusterPanel = new JPanel(new GridBagLayout());
        popNClusterPanel.setBackground(Color.white);
        this.popPanel = new PopSelectionPanel();
        JPanel emptyClusterPanel = new JPanel(new GridBagLayout());
        String text = "<center><b>Note: When running LM in script mode the cluster<br>";
        text = text + "under analysis is determined by the preceding algorithm<br>";
        text = text + "that feeds source data into LM.</center>";
        JTextPane textArea = new JTextPane();
        textArea.setEditable(false);
        textArea.setBackground(Color.lightGray);
        textArea.setContentType("text/html");
        textArea.setText(text);
        emptyClusterPanel.add((Component)textArea, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        popNClusterPanel.add((Component)this.popPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        popNClusterPanel.add((Component)emptyClusterPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.tabbedPane.add("Population and Cluster Selection", popNClusterPanel);
        JPanel parameters = new JPanel(new GridBagLayout());
        parameters.setBackground(Color.white);
        this.priorsPanel = new PriorSelectionPanel(true);
        this.bootStrapPanel = new BootStrapPanel();
        this.discPanel = new DiscretizingPanel();
        this.classnumPanel = new ClassNumPanel();
        this.useGoPanel = new XmlBifPanel();
        parameters.add((Component)this.configPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        parameters.add((Component)this.priorsPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        parameters.add((Component)this.useGoPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        parameters.add((Component)this.tabbedPane, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addContent(parameters);
        this.setActionListeners(this.listener);
        this.setSize(600, 750);
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    private void resetControls() {
    }

    public boolean isClusterModeSelected() {
        return this.priorsPanel.litSourceCheckbox.isSelected();
    }

    public Cluster getSelectedCluster() {
        return this.browser.getSelectedCluster();
    }

    public boolean isPopFileModeSelected() {
        return this.popPanel.fileButton.isSelected();
    }

    public String getPopulationFileName() {
        return this.popPanel.getPopFile();
    }

    public String getConverterFileName() {
        return this.bnParamPanel.getConverterFileName();
    }

    public int getMinClusterSize() {
        String value = this.bnParamPanel.minClusterSizeField.getText();
        try {
            int size = Integer.parseInt(value);
            return size;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public String getBaseFileLocation() {
        return this.configPanel.getBaseFileLocation();
    }

    public int getNumberClass() {
        return this.classnumPanel.getNumClasses();
    }

    public int getNumberBin() {
        return this.discPanel.getNumLevels();
    }

    public boolean isLit() {
        return this.priorsPanel.litSourceCheckbox.isSelected();
    }

    public boolean isPPI() {
        return this.priorsPanel.ppiSourceCheckbox.isSelected();
    }

    public boolean isKEGG() {
        return this.priorsPanel.keggSourceCheckbox.isSelected();
    }

    public void setLit() {
        this.priorsPanel.litSourceCheckbox.setSelected(true);
    }

    public boolean isAll() {
        return this.isLit() && this.isPPI() && this.isKEGG();
    }

    public boolean isLitAndKegg() {
        return this.isLit() && this.isKEGG();
    }

    public boolean isPpiAndKegg() {
        return this.isKEGG() && this.isPPI() && !this.isLit();
    }

    public boolean isBoth() {
        return this.isLit() && this.isPPI();
    }

    public boolean isNone() {
        return !this.isLit() && !this.isPPI() && !this.isKEGG();
    }

    public boolean useGoTerm() {
        return this.useGoPanel.useGoButton.isSelected();
    }

    public String numParents() {
        return this.runBNPanel.numParents();
    }

    public boolean isClusterSource() {
        return this.popPanel.dataButton.isSelected();
    }

    public int getNumIterations() {
        return this.bootStrapPanel.getNumIterations();
    }

    public float getConfThreshold() {
        return this.bootStrapPanel.getConfThreshold();
    }

    public boolean isBootstrapping() {
        return this.bootStrapPanel.isBootstrapping();
    }

    public String getKeggSpecies() {
        return this.kegg_sp;
    }

    public String[] getAnnToGOFileList() {
        return this.bnParamPanel.getAnnToGOFileList();
    }

    public File getAnnotationFile() {
        return this.annotationFile;
    }

    public static void main(String[] args) {
        String[] labels = new String[]{"TC#", "GB#", "Role"};
        LiteratureMiningDialog eid = new LiteratureMiningDialog((Frame)new JFrame(), labels);
        eid.showModal();
    }

    private class EventListener
    extends DialogListener
    implements ItemListener {
        private EventListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("use-converter-command")) {
                if (LiteratureMiningDialog.this.bnParamPanel.useAnnBox.isSelected()) {
                    LiteratureMiningDialog.this.bnParamPanel.browserButton.setEnabled(true);
                    LiteratureMiningDialog.this.bnParamPanel.converterFileField.setEnabled(true);
                    LiteratureMiningDialog.this.bnParamPanel.converterFileField.setBackground(Color.white);
                    LiteratureMiningDialog.this.bnParamPanel.fileLabel.setEnabled(true);
                } else {
                    LiteratureMiningDialog.this.bnParamPanel.browserButton.setEnabled(false);
                    LiteratureMiningDialog.this.bnParamPanel.converterFileField.setEnabled(false);
                    LiteratureMiningDialog.this.bnParamPanel.converterFileField.setBackground(Color.lightGray);
                    LiteratureMiningDialog.this.bnParamPanel.fileLabel.setEnabled(false);
                }
            } else {
                if (command.equals("converter-file-browser-command")) {
                    File convertFile = new File(LiteratureMiningDialog.this.getBaseFileLocation() + "/Data/Convert");
                    JFileChooser chooser = new JFileChooser(convertFile);
                    chooser.setDialogTitle("Annotation Converter Selection");
                    chooser.setMultiSelectionEnabled(false);
                    if (chooser.showOpenDialog(LiteratureMiningDialog.this.parent) == 0) {
                        LiteratureMiningDialog.this.bnParamPanel.updateConverterFileField(chooser.getSelectedFile().getPath());
                    }
                    return;
                }
                if (command.equals("ann-file-browser-command")) {
                    File classFile = new File(LiteratureMiningDialog.this.getBaseFileLocation() + "/Data/Class/");
                    JFileChooser chooser = new JFileChooser(classFile);
                    chooser.setDialogTitle("Annotation --> GO Term, File(s) Selection");
                    chooser.setMultiSelectionEnabled(true);
                    if (chooser.showOpenDialog(LiteratureMiningDialog.this.parent) == 0) {
                        LiteratureMiningDialog.this.bnParamPanel.updateAnnFileList(chooser.getSelectedFiles());
                        LiteratureMiningDialog.this.bnParamPanel.removeButton.setEnabled(true);
                        LiteratureMiningDialog.this.okButton.setEnabled(true);
                    }
                } else if (command.equals("remove-ann-file-command")) {
                    LiteratureMiningDialog.this.bnParamPanel.removeSelectedFiles();
                } else if (command.equals("select-file-base-command")) {
                    LiteratureMiningDialog.this.configPanel.selectFileSystem();
                } else if (command.equals("update-files-command")) {
                    BNUpdateManager manager = new BNUpdateManager((JFrame)LiteratureMiningDialog.this.parent, LiteratureMiningDialog.this.configPanel.getBaseFileLocation());
                    manager.updateFiles();
                } else if (command.equals("ok-command")) {
                    String fileName;
                    System.out.println("LIT Mining Dlg. OK Cmd");
                    LiteratureMiningDialog.this.result = 0;
                    Hashtable<String, String> repInfo = BNDownloadManager.getRepositoryInfoCytoscape();
                    String codeBase = repInfo.get("cytoscape_webstart").trim();
                    String libDir = repInfo.get("cytoscape_lib_dir").trim();
                    String pluginsDir = repInfo.get("cytoscape_plugins_dir").trim();
                    if (codeBase == null || libDir == null) {
                        JOptionPane.showMessageDialog(new JFrame(), "Internet Connection error or Error reading properties file, will try with default values", "Cytoscape may not launch", 0);
                        return;
                    }
                    BNConstants.setCodeBaseLocation(codeBase);
                    BNConstants.setLibDirLocation(libDir);
                    BNConstants.setPluginsDirLocation(pluginsDir);
                    String fileBase = LiteratureMiningDialog.this.configPanel.getBaseFileLocation();
                    if (fileBase.contains(" ")) {
                        JOptionPane.showMessageDialog(LiteratureMiningDialog.this.parent, "Spaces are not allowed in Path. \n Selected a different location", "BN Initialization: Illegal Char in Path", 0);
                        LiteratureMiningDialog.this.configPanel.defaultFileBaseLocation.grabFocus();
                        LiteratureMiningDialog.this.configPanel.defaultFileBaseLocation.selectAll();
                        return;
                    }
                    if (LiteratureMiningDialog.this.isLit()) {
                        if (!new File(fileBase + BNConstants.SEP + "res.txt").exists()) {
                            JOptionPane.showMessageDialog(LiteratureMiningDialog.this.parent, "File: " + fileBase + BNConstants.SEP + "res.txt" + " is missing", "LM Initialization: Missing File", 2);
                            return;
                        }
                        if (!new File(fileBase + BNConstants.SEP + "affyID_accession.txt").exists()) {
                            JOptionPane.showMessageDialog(LiteratureMiningDialog.this.parent, "File: " + fileBase + BNConstants.SEP + "affyID_accession.txt" + " is missing", "LM Initialization: Missing File", 2);
                            return;
                        }
                        if (!new File(fileBase + BNConstants.SEP + "symArtsGeneDb.txt").exists()) {
                            JOptionPane.showMessageDialog(LiteratureMiningDialog.this.parent, "File: " + fileBase + BNConstants.SEP + "symArtsGeneDb.txt" + " is missing", "LM Initialization: Missing File", 2);
                            return;
                        }
                        if (!new File(fileBase + BNConstants.SEP + "symArtsPubmed.txt").exists()) {
                            JOptionPane.showMessageDialog(LiteratureMiningDialog.this.parent, "File: " + fileBase + BNConstants.SEP + "symArtsPubmed.txt" + " is missing", "LM Initialization: Missing File", 2);
                            return;
                        }
                    }
                    if (LiteratureMiningDialog.this.isPPI() && !new File(fileBase + BNConstants.SEP + "all_ppi.txt").exists()) {
                        JOptionPane.showMessageDialog(LiteratureMiningDialog.this.parent, "File: " + fileBase + BNConstants.SEP + "all_ppi.txt" + " is missing", "LM Initialization: Missing File", 2);
                        return;
                    }
                    if (LiteratureMiningDialog.this.isKEGG()) {
                        boolean success;
                        LiteratureMiningDialog.this.kegg_sp = null;
                        if (LiteratureMiningDialog.this.framework.getData().isAnnotationLoaded()) {
                            LiteratureMiningDialog.this.kegg_sp = LiteratureMiningDialog.this.framework.getData().getChipAnnotation().getSpeciesName().trim();
                        }
                        if (LiteratureMiningDialog.this.kegg_sp == null) {
                            LiteratureMiningDialog.this.kegg_sp = (String)JOptionPane.showInputDialog(null, "Select a Species", "Annotation Unknown", 2, null, BNConstants.KEGG_ORG, BNConstants.KEGG_ORG[0]);
                        } else if (!this.isKeggOrgSupported(LiteratureMiningDialog.this.kegg_sp) && JOptionPane.showConfirmDialog(new JFrame(), "Do you want to continue ? ", "Species " + LiteratureMiningDialog.this.kegg_sp + " not Supported for KEGG", 0) == 1) {
                            return;
                        }
                        if (LiteratureMiningDialog.this.kegg_sp.equalsIgnoreCase("Human")) {
                            LiteratureMiningDialog.this.kegg_sp = "hsa";
                        } else if (LiteratureMiningDialog.this.kegg_sp.equalsIgnoreCase("Mouse")) {
                            LiteratureMiningDialog.this.kegg_sp = "mmu";
                        } else if (LiteratureMiningDialog.this.kegg_sp.equalsIgnoreCase("Rat")) {
                            LiteratureMiningDialog.this.kegg_sp = "rno";
                        }
                        if (!new File(BNConstants.KEGG_FILE_BASE).exists() && !(success = new File(BNConstants.KEGG_FILE_BASE).mkdir())) {
                            JOptionPane.showMessageDialog(LiteratureMiningDialog.this.parent, "Failed to create directory", "Error", 0);
                            return;
                        }
                        String keggFileName = LiteratureMiningDialog.this.kegg_sp + "_kegg_edges.txt";
                        if (!new File(BNConstants.KEGG_FILE_BASE + BNConstants.SEP + keggFileName).exists()) {
                            JOptionPane.showMessageDialog(LiteratureMiningDialog.this.parent, "KEGG file is missing, will try to download", "LM Initialization: Missing File", 0);
                            BNDownloadManager dwnMgr = new BNDownloadManager((JFrame)LiteratureMiningDialog.this.parent, BNConstants.KEGG_FILE_BASE, "Trying to Download KEGG File", keggFileName, false);
                            if (!dwnMgr.updateFiles()) {
                                return;
                            }
                        }
                    }
                    if (LiteratureMiningDialog.this.isNone()) {
                        JOptionPane.showMessageDialog(LiteratureMiningDialog.this.parent, "Network Priors Source(s) not selected", "LM Initialization: Missing Selection", 2);
                        return;
                    }
                    if (LiteratureMiningDialog.this.useGoTerm() && !new File(fileBase + BNConstants.SEP + "gbGO.txt").exists()) {
                        JOptionPane.showMessageDialog(LiteratureMiningDialog.this.parent, "File: " + fileBase + BNConstants.SEP + "gbGO.txt" + " is missing", "LM Initialization: Missing File", 2);
                        return;
                    }
                    if (!new File(fileBase + BNConstants.SEP + "results").exists()) {
                        boolean success = new File(fileBase + BNConstants.SEP + "results").mkdir();
                        if (!success) {
                            JOptionPane.showMessageDialog(LiteratureMiningDialog.this.parent, "Dir: " + fileBase + BNConstants.SEP + "results" + " cannot be created", "LM Initialization: Dir create error", 2);
                            return;
                        }
                        System.out.println("Dir: " + fileBase + BNConstants.SEP + "results" + " created successfully !!");
                    }
                    if (!new File(fileBase + BNConstants.SEP + "tmp").exists()) {
                        boolean success = new File(fileBase + BNConstants.SEP + "tmp").mkdir();
                        if (!success) {
                            JOptionPane.showMessageDialog(LiteratureMiningDialog.this.parent, "Dir: " + fileBase + BNConstants.SEP + "tmp" + " cannot be created", "LM Initialization: Dir create error", 2);
                            return;
                        }
                        System.out.println("Dir: " + fileBase + BNConstants.SEP + "tmp" + " created successfully !!");
                    }
                    if (LiteratureMiningDialog.this.isClusterModeSelected() && LiteratureMiningDialog.this.popPanel.fileButton.isSelected() && ((fileName = LiteratureMiningDialog.this.popPanel.popField.getText()) == null || fileName.equals("") || fileName.equals(" "))) {
                        JOptionPane.showMessageDialog(LiteratureMiningDialog.this.parent, "You have selected to use a population file but have not entered a file name.  \nPlease enter a file or use the file browser to select a file.", "LM Initialization: Missing Parameter", 2);
                        LiteratureMiningDialog.this.tabbedPane.setSelectedIndex(0);
                        LiteratureMiningDialog.this.popPanel.popField.grabFocus();
                        LiteratureMiningDialog.this.popPanel.popField.selectAll();
                        LiteratureMiningDialog.this.popPanel.popField.setCaretPosition(0);
                        return;
                    }
                    if (LiteratureMiningDialog.this.bnParamPanel.useAnnBox.isSelected() && ((fileName = LiteratureMiningDialog.this.bnParamPanel.getConverterFileName()) == null || fileName.equals("") || fileName.equals(" "))) {
                        JOptionPane.showMessageDialog(LiteratureMiningDialog.this.parent, "You have selected to use an annotation conversion file but have not made a file selection.\nPlease enter a file name or browse to select a file.", "LM Initialization: Missing Parameter", 2);
                        LiteratureMiningDialog.this.tabbedPane.setSelectedIndex(1);
                        LiteratureMiningDialog.this.bnParamPanel.browserButton.grabFocus();
                        return;
                    }
                    BNConstants.setBaseFileLocation(fileBase);
                    TMEV.storeProperty((String)BNConstants.BN_LM_LOC_PROP, (String)fileBase);
                    LiteratureMiningDialog.this.dispose();
                } else if (command.equals("cancel-command")) {
                    LiteratureMiningDialog.this.result = 2;
                    LiteratureMiningDialog.this.dispose();
                } else {
                    if (command.equals("reset-command")) {
                        LiteratureMiningDialog.this.resetControls();
                        LiteratureMiningDialog.this.result = 2;
                        return;
                    }
                    if (command.equals("info-command")) {
                        HelpWindow.launchBrowser(LiteratureMiningDialog.this, "LM Initialization Dialog");
                    } else if (command.equals("organism-selected-command")) {
                        LiteratureMiningDialog.this.configPanel.selectSpecies();
                        LiteratureMiningDialog.this.configPanel.updateSelection();
                    } else if (command.equals("array-selected-command")) {
                        LiteratureMiningDialog.this.configPanel.updateSelection();
                    } else if (command.equals("download-support-file-command")) {
                        LiteratureMiningDialog.this.configPanel.onDownloadSupportFile();
                    }
                }
            }
        }

        private boolean isKeggOrgSupported(String sp) {
            for (int i = 0; i < BNConstants.KEGG_ORG.length; ++i) {
                if (!sp.equalsIgnoreCase(BNConstants.KEGG_ORG[i])) continue;
                return true;
            }
            return false;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            LiteratureMiningDialog.this.result = -1;
            LiteratureMiningDialog.this.dispose();
        }
    }

    private class ConfigPanel
    extends ParameterPanel {
        JTextField defaultFileBaseLocation;
        JComboBox organismListBox;
        JComboBox arrayListBox;
        JLabel chooseOrg;
        JLabel chooseArray;
        JLabel browseLabel;
        JLabel statusLabel;
        JButton getBNSupportFileButton;

        public ConfigPanel() {
            super("Location of Support File(s)");
            this.setLayout(new GridBagLayout());
            JButton cngFilesButton = new JButton("Change");
            cngFilesButton.setActionCommand("select-file-base-command");
            cngFilesButton.addActionListener(LiteratureMiningDialog.this.listener);
            cngFilesButton.setToolTipText("<html>Select the directory where LM  files reside.</html>");
            String _loc = TMEV.getSettingForOption((String)BNConstants.BN_LM_LOC_PROP);
            if (_loc == null || _loc.equals("")) {
                _loc = TMEV.getDataPath();
            }
            this.defaultFileBaseLocation = new JTextField(new File(_loc).getAbsolutePath());
            this.defaultFileBaseLocation.setEditable(true);
            this.getBNSupportFileButton = new JButton("Download");
            this.getBNSupportFileButton.setActionCommand("download-support-file-command");
            this.getBNSupportFileButton.addActionListener(LiteratureMiningDialog.this.listener);
            this.getBNSupportFileButton.setToolTipText("<html>Downloads BN support files<br>for a selected species and array type.</html>");
            this.chooseOrg = new JLabel("Organism");
            this.chooseArray = new JLabel("Array Platform");
            this.browseLabel = new JLabel("or Browse for another BN file(s) location:");
            this.statusLabel = new JLabel("Click to download");
            if (LiteratureMiningDialog.this.speciestoarrays == null || LiteratureMiningDialog.this.speciestoarrays.size() == 0) {
                this.organismListBox = new JComboBox();
                this.organismListBox.addItem("No organisms listed");
                this.organismListBox.setEnabled(false);
                this.arrayListBox = new JComboBox();
                this.arrayListBox.addItem("No species listed");
                this.arrayListBox.setEnabled(false);
            } else {
                this.organismListBox = new JComboBox<String>(new Vector<String>(LiteratureMiningDialog.this.speciestoarrays.keySet()));
                try {
                    this.organismListBox.setSelectedItem(LiteratureMiningDialog.this.speciesName);
                }
                catch (NullPointerException npe) {
                    JOptionPane.showMessageDialog(LiteratureMiningDialog.this.parent, "Organism information unavailable", "Aborting execution", 0);
                    return;
                }
                this.arrayListBox = new JComboBox<String>(LiteratureMiningDialog.this.speciestoarrays.get(this.organismListBox.getSelectedItem()));
                try {
                    this.arrayListBox.setSelectedItem(LiteratureMiningDialog.this.arrayName);
                }
                catch (NullPointerException npe) {
                    JOptionPane.showMessageDialog(LiteratureMiningDialog.this.parent, "Organism information unavailable", "Aborting execution", 0);
                    return;
                }
                this.arrayListBox.setEnabled(true);
            }
            this.arrayListBox.addActionListener(LiteratureMiningDialog.this.listener);
            this.arrayListBox.setActionCommand("array-selected-command");
            this.organismListBox.addActionListener(LiteratureMiningDialog.this.listener);
            this.organismListBox.setActionCommand("organism-selected-command");
            this.add((Component)this.chooseOrg, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 30, 0, 0), 0, 0));
            this.add((Component)this.chooseArray, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 30, 0, 0), 0, 0));
            this.add((Component)this.organismListBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 30, 0, 0), 0, 0));
            this.add((Component)this.arrayListBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 30, 0, 0), 0, 0));
            this.add((Component)this.statusLabel, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 25, 0, 20), 0, 0));
            this.add((Component)this.getBNSupportFileButton, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 25, 0, 20), 0, 0));
            this.add((Component)this.browseLabel, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 1, new Insets(10, 30, 0, 0), 0, 0));
            this.add((Component)this.defaultFileBaseLocation, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 17, 1, new Insets(10, 30, 5, 0), 0, 0));
            this.add((Component)cngFilesButton, new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 25, 5, 20), 0, 0));
            try {
                boolean b = LiteratureMiningDialog.this.resourceManager.fileIsInRepository((ISupportFileDefinition)new BNSupportDataFile(this.organismListBox.getSelectedItem().toString(), this.arrayListBox.getSelectedItem().toString()));
                if (b) {
                    this.getBNSupportFileButton.setText("Select This");
                } else {
                    this.getBNSupportFileButton.setText("Download");
                }
            }
            catch (NullPointerException npe) {
                this.getBNSupportFileButton.setText("Download");
            }
            this.updateSelection();
        }

        public void selectFileSystem() {
            String startDir = this.defaultFileBaseLocation.getText();
            File file = new File(startDir);
            if (!file.exists() && (file = TMEV.getFile((String)"data/bn")) == null) {
                file = new File(System.getProperty("user.dir"));
            }
            JFileChooser chooser = new JFileChooser(file);
            chooser.setFileSelectionMode(1);
            if (chooser.showOpenDialog(LiteratureMiningDialog.this) == 0) {
                String dir = chooser.getSelectedFile().getAbsolutePath().trim();
                if (dir.contains(" ")) {
                    JOptionPane.showMessageDialog(LiteratureMiningDialog.this.parent, "Spaces are not allowed in Path. \n Selected a different location", "LM Initialization: Illegal Char in Path", 0);
                    this.defaultFileBaseLocation.grabFocus();
                    this.defaultFileBaseLocation.selectAll();
                    return;
                }
                this.defaultFileBaseLocation.setText(chooser.getSelectedFile().getAbsolutePath());
                TMEV.storeProperty((String)BNConstants.BN_LM_LOC_PROP, (String)this.defaultFileBaseLocation.getText());
            }
        }

        public String getBaseFileLocation() {
            return this.defaultFileBaseLocation.getText();
        }

        public void selectSpecies() {
            this.arrayListBox.removeAllItems();
            Vector<String> arraysForThisSpecies = LiteratureMiningDialog.this.speciestoarrays.get(this.organismListBox.getSelectedItem());
            for (int i = 0; i < arraysForThisSpecies.size(); ++i) {
                this.arrayListBox.addItem(arraysForThisSpecies.elementAt(i));
            }
        }

        public void updateSelection() {
            if (this.arrayListBox.getSelectedItem() == null) {
                return;
            }
            String selectedOrganism = this.organismListBox.getSelectedItem().toString();
            String selectedArray = this.arrayListBox.getSelectedItem().toString();
            if (selectedOrganism != null && selectedArray != null) {
                if (LiteratureMiningDialog.this.resourceManager.fileIsInRepository((ISupportFileDefinition)new BNSupportDataFile(selectedOrganism, selectedArray))) {
                    this.statusLabel.setText("Click to Select");
                    this.getBNSupportFileButton.setText("Select");
                } else {
                    this.statusLabel.setText("Click to Download");
                    this.getBNSupportFileButton.setText("Download");
                }
                this.getBNSupportFileButton.setEnabled(true);
                try {
                    ResourcererAnnotationFileDefinition def = new ResourcererAnnotationFileDefinition(LiteratureMiningDialog.this.speciesName, LiteratureMiningDialog.this.arrayName);
                    LiteratureMiningDialog.this.annotationFile = LiteratureMiningDialog.this.resourceManager.getSupportFile((ISupportFileDefinition)def, false);
                }
                catch (SupportFileAccessError sfae) {
                    LiteratureMiningDialog.this.useLoadedAnnotationFile = false;
                }
            } else {
                this.getBNSupportFileButton.setEnabled(false);
            }
        }

        private void onDownloadSupportFile() {
            try {
                BNSupportDataFile bnSuppFile = new BNSupportDataFile(this.organismListBox.getSelectedItem().toString(), this.arrayListBox.getSelectedItem().toString());
                if (bnSuppFile == null) {
                    System.out.println("BNSuppFile obj is null");
                } else {
                    System.out.println("bnSuppFile.isSingleFile(): " + bnSuppFile.isSingleFile());
                    System.out.println("bnSuppFile.getUniqueName(): " + bnSuppFile.getUniqueName());
                    try {
                        System.out.println("bnSuppFile.getURL(): " + bnSuppFile.getURL().toString());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    System.out.println("bnSuppFile.isSingleFile(): " + bnSuppFile.isSingleFile());
                }
                File f = LiteratureMiningDialog.this.resourceManager.getSupportFile((ISupportFileDefinition)bnSuppFile, true);
                System.out.println("FTP & unzipping Complete: " + f.getAbsolutePath());
                String srcDirPath = f.getAbsolutePath() + BNConstants.SEP + bnSuppFile.getUniqueName();
                File srcDir = new File(srcDirPath);
                String dstDirPath = System.getProperty("user.dir") + BNConstants.SEP + "data" + BNConstants.SEP + "BN_files" + BNConstants.SEP + bnSuppFile.getUniqueName();
                File dstDir = new File(dstDirPath);
                try {
                    Useful.copyDirectory(srcDir, dstDir);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                this.defaultFileBaseLocation.setText(dstDir.getAbsolutePath());
                TMEV.storeProperty((String)BNConstants.BN_LM_LOC_PROP, (String)this.defaultFileBaseLocation.getText());
                this.getBNSupportFileButton.setText("Select This");
                this.statusLabel.setText("Selected");
                this.getBNSupportFileButton.setEnabled(false);
            }
            catch (SupportFileAccessError sfae) {
                this.statusLabel.setText("Failure");
                sfae.printStackTrace();
            }
            catch (NullPointerException npe) {
                this.statusLabel.setText("Failure");
                npe.printStackTrace();
                System.out.println("LMDialog.onDownloadSupportFile() - NullPointerException");
            }
        }
    }

    private class AlphaPanel
    extends JPanel {
        private JCheckBox fisherBox;
        private JCheckBox easeBox;
        private JCheckBox bonferroniBox;
        private JCheckBox sidakBox;
        private JCheckBox bonferroniStepBox;
        private JCheckBox permBox;
        private JTextField permField;
        private JLabel permLabel;
        private JCheckBox trimBox;
        private JCheckBox trimNBox;
        private JLabel trimNLabel;
        private JTextField trimNField;
        private JCheckBox trimPercentBox;
        private JLabel trimPercentLabel;
        private JTextField trimPercentField;

        public AlphaPanel() {
            super(new GridBagLayout());
            this.setBackground(Color.white);
            LiteratureMiningDialog.this.bootStrapPanel = new BootStrapPanel();
            JPanel statPanel = new JPanel(new GridBagLayout());
            statPanel.setBackground(Color.white);
            statPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Reported Statistic", 0, 0, LiteratureMiningDialog.this.font, Color.black));
            LiteratureMiningDialog.this.discPanel = new DiscretizingPanel();
            LiteratureMiningDialog.this.classnumPanel = new ClassNumPanel();
            this.add((Component)LiteratureMiningDialog.this.discPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)LiteratureMiningDialog.this.classnumPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        public boolean performPermutations() {
            return this.permBox.isSelected();
        }

        public void setEnablePermutations() {
            this.permLabel.setEnabled(this.permBox.isSelected());
            this.permField.setEnabled(this.permBox.isSelected());
        }

        public void validateTrimOptions() {
            if (this.trimBox.isSelected()) {
                this.trimNBox.setEnabled(true);
                this.trimPercentBox.setEnabled(true);
                this.trimNLabel.setEnabled(this.trimNBox.isSelected());
                this.trimNField.setEnabled(this.trimNBox.isSelected());
                this.trimPercentLabel.setEnabled(!this.trimNBox.isSelected());
                this.trimPercentField.setEnabled(!this.trimNBox.isSelected());
            } else {
                this.trimNBox.setEnabled(false);
                this.trimPercentBox.setEnabled(false);
                this.trimNLabel.setEnabled(false);
                this.trimNField.setEnabled(false);
                this.trimPercentLabel.setEnabled(false);
                this.trimPercentField.setEnabled(false);
            }
        }
    }

    private class BNParameterPanel
    extends JPanel {
        JTextField converterFileField;
        JList fileList;
        JButton browserButton;
        JTextField minClusterSizeField;
        JComboBox fieldNamesBox;
        JList annFileList;
        Vector annVector;
        JButton removeButton;
        JCheckBox useAnnBox;
        JLabel fileLabel;

        public BNParameterPanel(String[] fieldNames) {
            JPanel convPanel = new JPanel(new GridBagLayout());
            convPanel.setBackground(Color.white);
            convPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Annotation Conversion File", 0, 0, LiteratureMiningDialog.this.font, Color.black));
            this.useAnnBox = new JCheckBox("use annotation converter", false);
            this.useAnnBox.setActionCommand("use-converter-command");
            this.useAnnBox.addActionListener(LiteratureMiningDialog.this.listener);
            this.useAnnBox.setBackground(Color.white);
            this.useAnnBox.setFocusPainted(false);
            this.useAnnBox.setEnabled(false);
            this.converterFileField = new JTextField(30);
            this.converterFileField.setBorder(BorderFactory.createBevelBorder(1, Color.lightGray, Color.gray));
            this.converterFileField.setEnabled(false);
            this.converterFileField.setBackground(Color.lightGray);
            this.browserButton = new JButton("File Browser");
            this.browserButton.setActionCommand("converter-file-browser-command");
            this.browserButton.setFocusPainted(false);
            this.browserButton.setPreferredSize(new Dimension(150, 25));
            this.browserButton.setSize(150, 25);
            this.browserButton.addActionListener(LiteratureMiningDialog.this.listener);
            this.browserButton.setEnabled(false);
            JLabel converterNotAvailableLabel = new JLabel("Annotation conversion is not yet available");
            converterNotAvailableLabel.setForeground(Color.red);
            this.fileLabel = new JLabel("File :");
            this.fileLabel.setEnabled(false);
            convPanel.add((Component)converterNotAvailableLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 10, 5), 0, 0));
            convPanel.add((Component)this.useAnnBox, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 17, 1, new Insets(0, 15, 15, 0), 0, 0));
            convPanel.add((Component)this.fileLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 15, 15, 0), 0, 0));
            convPanel.add((Component)this.browserButton, new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 17, 3, new Insets(0, 15, 0, 0), 0, 0));
            convPanel.add((Component)this.converterFileField, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 15, 15, 0), 0, 0));
            JPanel annPanel = new JPanel(new GridBagLayout());
            annPanel.setBackground(Color.white);
            annPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Gene Annotation / Gene Ontology Linking Files", 0, 0, LiteratureMiningDialog.this.font, Color.black));
            JLabel filesLabel = new JLabel("Files: ");
            this.annVector = new Vector();
            this.annFileList = new JList(new DefaultListModel());
            this.annFileList.setCellRenderer(new ListRenderer());
            this.annFileList.setBorder(BorderFactory.createBevelBorder(1));
            JScrollPane annPane = new JScrollPane(this.annFileList);
            JButton annButton = new JButton("Add Files");
            annButton.setActionCommand("ann-file-browser-command");
            annButton.addActionListener(LiteratureMiningDialog.this.listener);
            annButton.setFocusPainted(false);
            annButton.setPreferredSize(new Dimension(150, 25));
            annButton.setSize(150, 25);
            this.removeButton = new JButton("Remove Selected");
            this.removeButton.setActionCommand("remove-ann-file-command");
            this.removeButton.addActionListener(LiteratureMiningDialog.this.listener);
            this.removeButton.setFocusPainted(false);
            this.removeButton.setPreferredSize(new Dimension(150, 25));
            this.removeButton.setSize(150, 25);
            this.removeButton.setEnabled(false);
            JPanel fillPanel = new JPanel();
            fillPanel.setBackground(Color.white);
            JLabel annPanelNotAvailable = new JLabel("GO Annotation Linking is not yet available.");
            annPanelNotAvailable.setForeground(Color.red);
            annButton.setEnabled(false);
            annPane.setEnabled(false);
            filesLabel.setForeground(Color.gray);
            annPanel.add((Component)annPanelNotAvailable, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            annPanel.add((Component)fillPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            annPanel.add((Component)annButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 10, 5), 0, 0));
            annPanel.add((Component)this.removeButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 3, new Insets(0, 5, 10, 0), 0, 0));
            annPanel.add((Component)filesLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
            annPanel.add((Component)annPane, new GridBagConstraints(1, 2, 2, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            File file = new File(LiteratureMiningDialog.this.getBaseFileLocation() + "/Data/Convert/");
            String tempPath = file.getPath();
            Vector<String> fileVector = new Vector<String>();
            this.fileList = new JList(fileVector);
            if (file.exists()) {
                String[] listFileNames = file.list();
                for (int i = 0; i < listFileNames.length; ++i) {
                    File tempFile = new File(tempPath + BNConstants.SEP + listFileNames[i]);
                    if (!tempFile.isFile()) continue;
                    fileVector.add(listFileNames[i]);
                }
                if (fileVector.size() > 0) {
                    this.converterFileField.setText(tempPath + BNConstants.SEP + (String)fileVector.elementAt(0));
                }
            }
            this.minClusterSizeField = new JTextField(5);
            this.minClusterSizeField.setText("5");
            JPanel contentPanel = new JPanel(new GridBagLayout());
            JPanel bnFilePanel = new JPanel(new GridBagLayout());
            this.setLayout(new GridBagLayout());
            this.add((Component)convPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)annPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        private void updateFileDirectoryField() {
            File file = new File((String)this.fileList.getSelectedValue());
            if (file == null) {
                return;
            }
            String tempPath = file.getParent();
            int fileIndex = this.fileList.getSelectedIndex();
            String fileName = (String)this.fileList.getModel().getElementAt(this.fileList.getSelectedIndex());
            this.converterFileField.setText(tempPath + BNConstants.SEP + fileName);
        }

        private void updateAnnFileList(File[] files) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (((DefaultListModel)this.annFileList.getModel()).contains(file)) continue;
                ((DefaultListModel)this.annFileList.getModel()).addElement(file);
            }
            this.annFileList.validate();
        }

        public String getConverterFileName() {
            if (this.useAnnBox.isSelected()) {
                return this.converterFileField.getText();
            }
            return null;
        }

        private void updateConverterFileField(String field) {
            this.converterFileField.setText(field);
        }

        public String[] getAnnToGOFileList() {
            String[] fileNames = new String[((DefaultListModel)this.annFileList.getModel()).size()];
            for (int i = 0; i < fileNames.length; ++i) {
                fileNames[i] = ((File)((DefaultListModel)this.annFileList.getModel()).elementAt(i)).getPath();
            }
            return fileNames;
        }

        public void removeSelectedFiles() {
            int[] indices = this.annFileList.getSelectedIndices();
            for (int i = 0; i < indices.length; ++i) {
                ((DefaultListModel)this.annFileList.getModel()).removeElementAt(indices[i]);
            }
            if (this.annFileList.getModel().getSize() < 1) {
                this.removeButton.setEnabled(false);
                LiteratureMiningDialog.this.okButton.setEnabled(false);
            }
            this.annFileList.validate();
        }

        private class ListRenderer
        extends DefaultListCellRenderer {
            private ListRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                File file = (File)value;
                this.setText(file.getName());
                return this;
            }
        }

        private class BNListListener
        implements ListSelectionListener {
            private BNListListener() {
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                BNParameterPanel.this.updateFileDirectoryField();
            }
        }
    }

    private class RunBNPanel
    extends JPanel {
        private JLabel numLabel;
        private JLabel slabel;
        private JLabel scorelabel;
        private JTextField nParents;

        public RunBNPanel() {
            super(new GridBagLayout());
            this.numLabel = new JLabel("Maximum Number of Parents:");
            this.slabel = new JLabel("Search algorithm: Hill Climbing");
            this.scorelabel = new JLabel("Scoring Scheme: BDeu");
            this.nParents = new JTextField("3");
            this.setLayout(new GridBagLayout());
            this.setBackground(Color.white);
            this.setBackground(Color.white);
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Running Bayesian Network Parameters ", 0, 0, LiteratureMiningDialog.this.font, Color.black));
            this.add((Component)this.slabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.scorelabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.numLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.nParents, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        public String numParents() {
            return this.nParents.getText();
        }
    }

    private class XmlBifPanel
    extends JPanel {
        private JRadioButton useGoButton;
        private JRadioButton useDFSButton;
        private ButtonGroup bGroup;

        public XmlBifPanel() {
            super(new GridBagLayout());
            this.setLayout(new GridBagLayout());
            this.setBackground(Color.white);
            this.useGoButton = new JRadioButton("Use GO Terms to direct edges");
            this.useGoButton.setHorizontalAlignment(0);
            this.useGoButton.setBackground(Color.white);
            this.useGoButton.setEnabled(false);
            this.useDFSButton = new JRadioButton("Use Depth-First Search to direct edges", true);
            this.useDFSButton.setHorizontalAlignment(0);
            this.useDFSButton.setBackground(Color.white);
            this.bGroup = new ButtonGroup();
            this.bGroup.add(this.useDFSButton);
            this.bGroup.add(this.useGoButton);
            this.setBackground(Color.white);
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "How to direct edges for graph", 0, 0, LiteratureMiningDialog.this.font, Color.black));
            this.add((Component)this.useDFSButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.useGoButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        public boolean useGoTerms() {
            return this.useGoButton.isEnabled();
        }
    }

    private class PopSelectionPanel
    extends ParameterPanel {
        JRadioButton fileButton;
        JRadioButton dataButton;
        JTextField popField;
        JButton browseButton;
        JLabel fileLabel;

        public PopSelectionPanel() {
            super("Population Selection");
            this.setLayout(new GridBagLayout());
            ButtonGroup bg = new ButtonGroup();
            this.fileButton = new JRadioButton("Population from File", true);
            this.fileButton.setBackground(Color.white);
            this.fileButton.setFocusPainted(false);
            bg.add(this.fileButton);
            this.fileButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    PopSelectionPanel.this.browseButton.setEnabled(PopSelectionPanel.this.fileButton.isSelected());
                    PopSelectionPanel.this.popField.setEnabled(PopSelectionPanel.this.fileButton.isSelected());
                    PopSelectionPanel.this.popField.setBackground(Color.white);
                    PopSelectionPanel.this.fileLabel.setEnabled(PopSelectionPanel.this.fileButton.isSelected());
                }
            });
            this.dataButton = new JRadioButton("Population from Current Viewer");
            this.dataButton.setBackground(Color.white);
            this.dataButton.setFocusPainted(false);
            bg.add(this.dataButton);
            this.dataButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    PopSelectionPanel.this.browseButton.setEnabled(PopSelectionPanel.this.fileButton.isSelected());
                    PopSelectionPanel.this.popField.setEnabled(PopSelectionPanel.this.fileButton.isSelected());
                    PopSelectionPanel.this.popField.setBackground(Color.lightGray);
                    PopSelectionPanel.this.fileLabel.setEnabled(PopSelectionPanel.this.fileButton.isSelected());
                }
            });
            this.browseButton = new JButton("File Browser");
            this.browseButton.setFocusPainted(false);
            this.browseButton.setPreferredSize(new Dimension(150, 25));
            this.browseButton.setSize(150, 25);
            this.browseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    JFileChooser chooser = new JFileChooser(TMEV.getFile((String)"Data/"));
                    chooser.setDialogTitle("Population File Selection");
                    chooser.setMultiSelectionEnabled(false);
                    if (chooser.showOpenDialog(LiteratureMiningDialog.this.parent) == 0) {
                        PopSelectionPanel.this.updatePopField(chooser.getSelectedFile().getPath());
                    }
                }
            });
            this.fileLabel = new JLabel("File: ");
            this.popField = new JTextField(25);
            JLabel filePopNotAvailable = new JLabel("Population selection from file is not yet available.");
            filePopNotAvailable.setForeground(Color.red);
            this.fileLabel.setForeground(Color.gray);
            this.popField.setEnabled(false);
            this.fileButton.setEnabled(false);
            this.browseButton.setEnabled(false);
            this.dataButton.setSelected(true);
            this.add((Component)filePopNotAvailable, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 1, new Insets(10, 30, 0, 0), 0, 0));
            this.add((Component)this.fileButton, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 17, 1, new Insets(10, 30, 0, 0), 0, 0));
            this.add((Component)this.fileLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 30, 0, 0), 0, 0));
            this.add((Component)this.popField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 10, 0, 0), 0, 0));
            this.add((Component)this.browseButton, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 25, 0, 20), 0, 0));
            this.add((Component)this.dataButton, new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 17, 1, new Insets(15, 30, 20, 0), 0, 0));
        }

        private void setEnableControls(boolean enable) {
            this.fileButton.setEnabled(enable);
            this.dataButton.setEnabled(enable);
            this.popField.setEnabled(enable);
            this.browseButton.setEnabled(enable);
            this.fileLabel.setEnabled(enable);
            this.setOpaque(enable);
            LiteratureMiningDialog.this.tabbedPane.setEnabledAt(0, enable);
        }

        private void updatePopField(String file) {
            this.popField.setText(file);
        }

        private String getPopFile() {
            return this.popField.getText();
        }
    }

    private class BootStrapPanel
    extends JPanel {
        private JTextField numIterationsField;
        private JLabel numIterationsLabel;
        private JTextField confThresholdField;
        private JLabel confThresholdLabel;
        private JCheckBox isBootstrappingCheckbox;
        private JLabel isBootStrappingLabel;
        private JLabel bootstrappingNotAvailable;

        public BootStrapPanel() {
            super(new GridBagLayout());
            this.setLayout(new GridBagLayout());
            this.setBackground(Color.white);
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Bootstrapping", 0, 0, LiteratureMiningDialog.this.font, Color.black));
            this.isBootstrappingCheckbox = new JCheckBox();
            this.isBootstrappingCheckbox.setSelected(false);
            this.isBootstrappingCheckbox.setEnabled(true);
            this.isBootstrappingCheckbox.setBackground(Color.white);
            this.isBootStrappingLabel = new JLabel(" Bootstrapping");
            this.isBootStrappingLabel.setBackground(Color.white);
            this.isBootstrappingCheckbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    LiteratureMiningDialog.this.bootStrapPanel.setEnableControls(BootStrapPanel.this.isBootstrappingCheckbox.isSelected());
                }
            });
            this.numIterationsField = new JTextField("100", 4);
            this.numIterationsField.setBackground(Color.white);
            this.numIterationsLabel = new JLabel(" Number of Iterations");
            this.numIterationsLabel.setBackground(Color.white);
            this.confThresholdField = new JTextField(".1", 2);
            this.confThresholdField.setBackground(Color.white);
            this.confThresholdLabel = new JLabel(" Confidence Threshold");
            this.confThresholdLabel.setBackground(Color.white);
            this.bootstrappingNotAvailable = new JLabel("Bootstrapping is not yet available");
            this.bootstrappingNotAvailable.setForeground(Color.red);
            this.isBootstrappingCheckbox.setEnabled(false);
            this.numIterationsField.setEnabled(false);
            this.confThresholdField.setEnabled(false);
            this.isBootStrappingLabel.setForeground(Color.gray);
            this.numIterationsLabel.setForeground(Color.gray);
            this.confThresholdLabel.setForeground(Color.gray);
            this.add((Component)this.bootstrappingNotAvailable, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 15, 0), 0, 0));
            this.add((Component)this.isBootstrappingCheckbox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 15, 0), 0, 0));
            this.add((Component)this.isBootStrappingLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 15, 0), 0, 0));
            this.add((Component)this.numIterationsField, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 15, 0), 0, 0));
            this.add((Component)this.numIterationsLabel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 15, 0), 0, 0));
            this.add((Component)this.confThresholdField, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 15, 0), 0, 0));
            this.add((Component)this.confThresholdLabel, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 15, 0), 0, 0));
        }

        public void setEnableControls(boolean enableControls) {
            this.numIterationsField.setEnabled(enableControls);
            this.confThresholdField.setEnabled(enableControls);
        }

        public int getNumIterations() {
            return new Integer(this.numIterationsField.getText());
        }

        public float getConfThreshold() {
            return new Float(this.confThresholdField.getText()).floatValue();
        }

        public boolean isBootstrapping() {
            return this.isBootstrappingCheckbox.isSelected();
        }
    }

    private class ClassNumPanel
    extends JPanel {
        private JTextField numClassesField;
        private JLabel numClassesLabel;

        public ClassNumPanel() {
            super(new GridBagLayout());
            this.setLayout(new GridBagLayout());
            this.setBackground(Color.white);
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Sample Classification", 0, 0, LiteratureMiningDialog.this.font, Color.black));
            this.numClassesField = new JTextField("2", 2);
            this.numClassesField.setBackground(Color.white);
            this.numClassesLabel = new JLabel(" Number of Sample Classes");
            this.numClassesLabel.setBackground(Color.white);
            this.numClassesField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    LiteratureMiningDialog.this.popPanel.setEnableControls(true);
                }
            });
            this.add((Component)this.numClassesLabel, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 15, 0), 0, 0));
            this.add((Component)this.numClassesField, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 15, 0), 0, 0));
        }

        public int getNumClasses() {
            return new Integer(this.numClassesField.getText());
        }
    }

    private class DiscretizingPanel
    extends JPanel {
        private JTextField numLevelsField;
        private JLabel numLevelsLabel;

        public DiscretizingPanel() {
            super(new GridBagLayout());
            this.setLayout(new GridBagLayout());
            this.setBackground(Color.white);
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Discretizing Expression Values", 0, 0, LiteratureMiningDialog.this.font, Color.black));
            this.numLevelsField = new JTextField("3", 1);
            this.numLevelsField.setBackground(Color.white);
            this.numLevelsLabel = new JLabel(" Number of Levels");
            this.numLevelsLabel.setBackground(Color.white);
            this.numLevelsField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    LiteratureMiningDialog.this.popPanel.setEnableControls(true);
                }
            });
            this.add((Component)this.numLevelsLabel, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 15, 0), 0, 0));
            this.add((Component)this.numLevelsField, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 15, 0), 0, 0));
        }

        public int getNumLevels() {
            return new Integer(this.numLevelsField.getText());
        }
    }

    private class PriorSelectionPanel
    extends JPanel {
        private JCheckBox litSourceCheckbox;
        private JCheckBox ppiSourceCheckbox;
        private JCheckBox keggSourceCheckbox;

        public PriorSelectionPanel(boolean haveClusters) {
            super(new GridBagLayout());
            this.setLayout(new GridBagLayout());
            this.setBackground(Color.white);
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Network Priors Sources", 0, 0, LiteratureMiningDialog.this.font, Color.black));
            this.litSourceCheckbox = new JCheckBox("Literature Mining", true);
            this.litSourceCheckbox.setFocusPainted(false);
            this.litSourceCheckbox.setBackground(Color.white);
            this.litSourceCheckbox.setHorizontalAlignment(0);
            this.litSourceCheckbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    LiteratureMiningDialog.this.popPanel.setEnableControls(true);
                }
            });
            this.ppiSourceCheckbox = new JCheckBox("Protein-Protein Interactions");
            this.ppiSourceCheckbox.setToolTipText("Uses protein-protein interaction data to create a seed network.");
            this.ppiSourceCheckbox.setFocusPainted(false);
            this.ppiSourceCheckbox.setBackground(Color.white);
            this.ppiSourceCheckbox.setHorizontalAlignment(0);
            this.ppiSourceCheckbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    LiteratureMiningDialog.this.popPanel.setEnableControls(false);
                }
            });
            this.keggSourceCheckbox = new JCheckBox("KEGG Interactions");
            this.keggSourceCheckbox.setToolTipText("Uses KEGG pathway interactions to create a seed network.");
            this.keggSourceCheckbox.setFocusPainted(false);
            this.keggSourceCheckbox.setBackground(Color.white);
            this.keggSourceCheckbox.setHorizontalAlignment(0);
            this.keggSourceCheckbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    LiteratureMiningDialog.this.popPanel.setEnableControls(true);
                }
            });
            this.ppiSourceCheckbox.setSelected(false);
            this.ppiSourceCheckbox.setEnabled(false);
            this.litSourceCheckbox.setEnabled(true);
            this.keggSourceCheckbox.setEnabled(true);
            this.add((Component)this.litSourceCheckbox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.keggSourceCheckbox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.ppiSourceCheckbox, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
    }
}

