/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.lm;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterRepository;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.impl.bn.BNConstants;
import org.tigr.microarray.mev.cluster.gui.impl.bn.BNSupportDataFile;
import org.tigr.microarray.mev.cluster.gui.impl.bn.CytoscapeWebstart;
import org.tigr.microarray.mev.cluster.gui.impl.bn.LMBNViewer;
import org.tigr.microarray.mev.cluster.gui.impl.bn.RunWekaProgressPanel;
import org.tigr.microarray.mev.cluster.gui.impl.bn.Useful;
import org.tigr.microarray.mev.cluster.gui.impl.bn.getInteractions.GetInteractionsModule;
import org.tigr.microarray.mev.cluster.gui.impl.bn.prepareXMLBif.PrepareXMLBifModule;
import org.tigr.microarray.mev.cluster.gui.impl.lm.LiteratureMiningDialog;
import org.tigr.microarray.mev.resources.PipelinedAnnotationsFileDefinition;
import org.tigr.microarray.mev.resources.SupportFileAccessError;

public class LMGUI
implements IClusterGUI {
    public static final int GENE_CLUSTER = 0;
    public static boolean done = false;
    public static boolean cancelRun = false;
    public static boolean prior = true;
    protected IFramework framework;
    IData data;
    RunWekaProgressPanel runProgressPanel;
    LMBNViewer fileViewer;
    Vector<String> networkFiles = new Vector();
    HashMap<String, String> probeIndexAssocHash = new HashMap();
    String species = null;
    String chip = null;
    BNSupportDataFile bnSuppFileHandle;

    public DefaultMutableTreeNode execute(IFramework frame) throws AlgorithmException {
        this.framework = frame;
        done = false;
        cancelRun = false;
        prior = true;
        this.data = this.framework.getData();
        Experiment exp = this.data.getExperiment();
        ClusterRepository repository = this.framework.getClusterRepository(0);
        String chipType = null;
        String species = null;
        Vector<BNSupportDataFile> defs = new Vector<BNSupportDataFile>();
        BNSupportDataFile bnSuppFileHandle = null;
        if (!this.framework.getData().isAnnotationLoaded()) {
            if (chipType == null || species == null) {
                JOptionPane.showMessageDialog(this.framework.getFrame(), "Organism and/or Array information unavailable", "Aborting execution...", 0);
                return null;
            }
            JOptionPane.showMessageDialog(this.framework.getFrame(), "Annotation unavailable", "Aborting execution...", 0);
            return null;
        }
        chipType = this.framework.getData().getChipAnnotation().getChipType();
        species = this.framework.getData().getChipAnnotation().getSpeciesName();
        bnSuppFileHandle = new BNSupportDataFile(species, chipType);
        defs.add(bnSuppFileHandle);
        Hashtable speciestoarrays = null;
        PipelinedAnnotationsFileDefinition aafd = new PipelinedAnnotationsFileDefinition();
        defs.add((BNSupportDataFile)aafd);
        try {
            Hashtable supportFiles = this.framework.getSupportFiles(defs, true);
            File speciesarraymapping = (File)supportFiles.get(aafd);
            try {
                speciestoarrays = aafd.parseAnnotationListFile(speciesarraymapping);
            }
            catch (IOException ioe) {
                speciestoarrays = null;
            }
        }
        catch (SupportFileAccessError sfae) {
            // empty catch block
        }
        final LiteratureMiningDialog dialog = new LiteratureMiningDialog(this.framework, repository, this.framework.getData().getFieldNames(), this.framework.getResourceManager(), species, chipType, speciestoarrays);
        if (dialog.showModal() != 0) {
            return null;
        }
        if (dialog.isNone()) {
            prior = false;
            done = true;
        }
        if (dialog.isNone()) {
            return null;
        }
        this.runProgressPanel = new RunWekaProgressPanel();
        this.runProgressPanel.setString("Learning Network Priors");
        this.runProgressPanel.setIndeterminate(true);
        this.runProgressPanel.setLocationRelativeTo(this.framework.getFrame());
        this.runProgressPanel.setVisible(true);
        String basePath = dialog.getBaseFileLocation() + BNConstants.SEP;
        try {
            this.probeIndexAssocHash = Useful.converter(dialog.getSelectedCluster(), this.framework, dialog.getBaseFileLocation());
            if (this.probeIndexAssocHash == null) {
                throw new Exception("Error in mapping Unique identifiers to Accession");
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.framework.getFrame(), e.getMessage(), "Error!", 0);
            done = false;
            this.runProgressPanel.dispose();
            return null;
        }
        String kegg_sp = dialog.getKeggSpecies();
        kegg_sp = kegg_sp != null ? kegg_sp.trim() : "na";
        Useful.buildPropertyFile(dialog.isLit(), dialog.isPPI(), dialog.isKEGG(), dialog.isBoth(), dialog.isLitAndKegg(), dialog.isPpiAndKegg(), dialog.isAll(), dialog.useGoTerm(), dialog.getBaseFileLocation(), kegg_sp, 0, 0);
        Thread thread1 = new Thread(new Runnable(){

            @Override
            public void run() {
                int status = -1;
                try {
                    status = LMGUI.this.literatureMining(dialog.isLit(), dialog.isPPI(), dialog.isKEGG(), dialog.isBoth(), dialog.isLitAndKegg(), dialog.isPpiAndKegg(), dialog.isAll(), dialog.getBaseFileLocation(), LMGUI.this.data);
                }
                catch (OutOfMemoryError ofm) {
                    LMGUI.this.runProgressPanel.dispose();
                    done = false;
                    System.out.println("Out of Memory. Aborting...");
                    JOptionPane.showMessageDialog(LMGUI.this.framework.getFrame(), ofm.getMessage() + "\n Out of Memory", "Error - Out of Memory. Aborting!", 0);
                    return;
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(LMGUI.this.framework.getFrame(), e.getMessage(), "Error!", 0);
                    e.printStackTrace();
                    done = false;
                    LMGUI.this.runProgressPanel.dispose();
                    return;
                }
                System.out.println("Interaction count: " + status);
                done = true;
                LMGUI.this.runProgressPanel.dispose();
            }
        });
        thread1.start();
        while (!done) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException x) {}
        }
        this.runProgressPanel.dispose();
        if (cancelRun) {
            return null;
        }
        done = false;
        GeneralInfo info = new GeneralInfo();
        if (dialog.isBoth()) {
            info.prior = "LM & PPI";
        } else if (dialog.isKEGG()) {
            info.prior = "KEGG";
        } else if (dialog.isAll()) {
            info.prior = "LM, PPI & KEGG";
        } else if (dialog.isLitAndKegg()) {
            info.prior = "LM & KEGG";
        } else if (dialog.isPpiAndKegg()) {
            info.prior = "PPI & KEGG";
        } else if (dialog.isPPI()) {
            info.prior = "PPI";
        } else if (dialog.isLit()) {
            info.prior = "Literature Mining";
        }
        if (dialog.useGoTerm()) {
            info.useGoTerms = "Use GO Terms";
        }
        info.numGene = dialog.getSelectedCluster().getIndices().length;
        String lmFile = basePath + "results" + BNConstants.SEP + System.getProperty("LM_ONLY");
        this.networkFiles.add(lmFile);
        CytoscapeWebstart.onWebstartCytoscapeBN(this.networkFiles);
        return this.createResultTree(exp, info);
    }

    private DefaultMutableTreeNode createResultTree(Experiment experiment, GeneralInfo info) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("LM");
        this.fileViewer = new LMBNViewer(this.networkFiles);
        root.add(new DefaultMutableTreeNode(new LeafInfo("Networks", (IViewer)this.fileViewer)));
        this.addGeneralInfo(root, info);
        return root;
    }

    private void addGeneralInfo(DefaultMutableTreeNode root, GeneralInfo info) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("General Information");
        node.add(new DefaultMutableTreeNode("Number of Genes: " + info.numGene));
        node.add(new DefaultMutableTreeNode("Prior: " + info.prior));
        root.add(node);
    }

    public int literatureMining(boolean lit, boolean ppi, boolean kegg, boolean LitPpi, boolean LitKegg, boolean KeggPpi, boolean LitPpiKegg, String path, IData data) {
        GetInteractionsModule getModule = new GetInteractionsModule(path, this.probeIndexAssocHash);
        if (lit) {
            return GetInteractionsModule.test(path + BNConstants.SEP + "tmp" + BNConstants.SEP + "getInterModLit.props", data);
        }
        if (ppi) {
            return GetInteractionsModule.test(path + BNConstants.SEP + "tmp" + BNConstants.SEP + "getInterModPPIDirectly.props", data);
        }
        if (LitPpi) {
            return GetInteractionsModule.test(path + BNConstants.SEP + "tmp" + BNConstants.SEP + "getInterModBoth.props", data);
        }
        if (kegg) {
            return GetInteractionsModule.test(path + BNConstants.SEP + "tmp" + BNConstants.SEP + "getInterModKegg.props", data);
        }
        if (LitKegg) {
            return GetInteractionsModule.test(path + BNConstants.SEP + "tmp" + BNConstants.SEP + "getInterModLitKegg.props", data);
        }
        if (KeggPpi) {
            return GetInteractionsModule.test(path + BNConstants.SEP + "tmp" + BNConstants.SEP + "getInterModPpiKegg.props", data);
        }
        if (LitPpiKegg) {
            return GetInteractionsModule.test(path + BNConstants.SEP + "tmp" + BNConstants.SEP + "getInterModLitPpiKegg.props", data);
        }
        return -1;
    }

    public void prepareXMLBifFile(String path) {
        PrepareXMLBifModule getModule = new PrepareXMLBifModule();
        PrepareXMLBifModule.test(path + BNConstants.SEP + "tmp" + BNConstants.SEP + "prepareXMLBifMod.props");
    }

    public void setLMBNViewer(LMBNViewer fileViewer) {
        this.fileViewer = fileViewer;
    }

    public LMBNViewer getLMBNViewerViewer() {
        return this.fileViewer;
    }

    public static class GeneralInfo {
        String prior = "No Priors";
        String useGoTerms = "Use modification of DFS";
        int numGene;
    }
}

