/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.limma;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterRepository;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterSelector;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class LIMMAInitBox
extends AlgorithmDialog {
    private static final long serialVersionUID = 1L;
    public static final int JUST_ALPHA = 1;
    public static final int STD_BONFERRONI = 2;
    public static final int ADJ_BONFERRONI = 3;
    public static final int MAX_T = 9;
    public static final int FALSE_NUM = 12;
    public static final int FALSE_PROP = 13;
    public static final int BUTTON_SELECTION = 14;
    public static final int CLUSTER_SELECTION = 15;
    boolean okPressed = false;
    boolean okReady = false;
    boolean step2 = false;
    Vector<String> exptNames;
    MultiClassPanel mPanel;
    JTabbedPane selectionPanel;
    HCLoptionPanel hclOpsPanel;
    ClusterRepository repository;
    JButton step2Button = new JButton("Continue...");

    public LIMMAInitBox(JFrame parentFrame, boolean modality, Vector<String> exptNames, ClusterRepository repository) {
        super(parentFrame, "LIMMA Initialization", modality);
        this.exptNames = exptNames;
        this.repository = repository;
        this.setBounds(0, 0, 1000, 850);
        this.setBackground(Color.white);
        this.setDefaultCloseOperation(2);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        JPanel pane = new JPanel();
        pane.setLayout(gridbag);
        this.okButton.setEnabled(false);
        this.mPanel = new MultiClassPanel();
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 80);
        gridbag.setConstraints(this.mPanel, constraints);
        pane.add(this.mPanel);
        this.addContent(pane);
        EventListener listener = new EventListener();
        this.setActionListeners(listener);
        this.addWindowListener(listener);
    }

    @Override
    public void setVisible(boolean visible) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        super.setVisible(visible);
        if (visible) {
            // empty if block
        }
    }

    private void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy, int anc) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
        gbc.anchor = anc;
    }

    private void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy, int anc, int fill) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
        gbc.anchor = anc;
        gbc.fill = fill;
    }

    private void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public void enableOK() {
        this.okButton.setEnabled(true);
    }

    public boolean drawTrees() {
        return this.hclOpsPanel.isHCLSelected();
    }

    public boolean drawSigTreesOnly() {
        return this.hclOpsPanel.drawSigTreesOnly();
    }

    private boolean isParamSufficient() {
        switch (this.getExperimentalDesign()) {
            case 1: {
                int inc = 0;
                int[] grpAssign = this.getGroupAssignments();
                for (int i = 0; i < grpAssign.length; ++i) {
                    if (grpAssign[i] != 1) continue;
                    ++inc;
                }
                if (inc < 2) {
                    JOptionPane.showMessageDialog(null, "Please select at least 2 samples.", "Error", 2);
                    return false;
                }
                return true;
            }
            case 2: {
                int[] inc = new int[2];
                int[] grpAssign = this.getGroupAssignments();
                for (int i = 0; i < grpAssign.length; ++i) {
                    if (grpAssign[i] == 0) continue;
                    int n = grpAssign[i] - 1;
                    inc[n] = inc[n] + 1;
                }
                if (inc[0] < 2 || inc[1] < 2) {
                    JOptionPane.showMessageDialog(null, "Please select at least 2 samples for each group.", "Error", 2);
                    return false;
                }
                return true;
            }
            case 3: {
                int i;
                int[] inc = new int[this.getNumGroups()];
                int[] grpAssign = this.getGroupAssignments();
                for (i = 0; i < grpAssign.length; ++i) {
                    if (grpAssign[i] == 0) continue;
                    int n = grpAssign[i] - 1;
                    inc[n] = inc[n] + 1;
                }
                for (i = 0; i < inc.length; ++i) {
                    if (inc[i] >= 2) continue;
                    JOptionPane.showMessageDialog(null, "Please select at least 2 samples for each group.", "Error", 2);
                    return false;
                }
                return true;
            }
            case 4: {
                int i;
                int[] inc = new int[this.getNumGroups()];
                int[] grpAssign = this.getGroupAssignments();
                for (i = 0; i < grpAssign.length; ++i) {
                    if (grpAssign[i] == 0) continue;
                    int n = grpAssign[i] - 1;
                    inc[n] = inc[n] + 1;
                }
                for (i = 0; i < inc.length; ++i) {
                    if (inc[i] >= 2) continue;
                    JOptionPane.showMessageDialog(null, "Please select at least 2 samples for each factor combination.\nSamples must be assigned to each possible combination of " + this.getFactorAName() + " vs. " + this.getFactorBName() + ".", "Error", 2);
                    return false;
                }
                return true;
            }
            case 5: {
                int i;
                int[] inc = new int[this.getNumGroups() * 2];
                int[] grpAssign = this.getGroupAssignments();
                for (i = 0; i < grpAssign.length; ++i) {
                    if (grpAssign[i] == 0) continue;
                    int n = grpAssign[i] - 1;
                    inc[n] = inc[n] + 1;
                }
                for (i = 0; i < inc.length; ++i) {
                    if (inc[i] >= 2) continue;
                    JOptionPane.showMessageDialog(null, "Please select at least 2 samples for each timepoint and condition combination.\nSamples must be assigned to each possible combination of timepoints and conditions.", "Error", 2);
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int[] getGroupAssignments() {
        if (this.getExperimentalDesign() < 4) {
            return this.getSimpleGroupAssignments();
        }
        if (this.getExperimentalDesign() == 4) {
            return this.getFactorGroupAssignments();
        }
        if (this.getExperimentalDesign() == 5) {
            return this.getTimeCourseGroupAssignments();
        }
        return null;
    }

    private int[] getClusterSelectorGroupAssignments() {
        int j;
        int i;
        int[] groupAssignments = new int[this.exptNames.size()];
        ArrayList[] arraylistArray = new ArrayList[this.mPanel.numGroups];
        for (i = 0; i < this.mPanel.numGroups; ++i) {
            j = i + 1;
            arraylistArray[i] = this.mPanel.groupsCS.getGroupSamples("Class " + j);
        }
        for (i = 0; i < this.exptNames.size(); ++i) {
            boolean doubleAssigned = false;
            groupAssignments[i] = 0;
            for (j = 0; j < this.mPanel.numGroups; ++j) {
                if (!arraylistArray[j].contains(i)) continue;
                if (doubleAssigned) {
                    Object[] optionst = new Object[]{"OK"};
                    JOptionPane.showOptionDialog(null, "The clusters you have chosen have overlapping samples. \n Each group must contain unique samples.", "Multiple Ownership Error", 1, 3, null, optionst, optionst[0]);
                    return null;
                }
                groupAssignments[i] = j + 1;
                doubleAssigned = true;
            }
        }
        return groupAssignments;
    }

    private int[] getSimpleGroupAssignments() {
        if (this.getSelectionDesign() == 15) {
            return this.getClusterSelectorGroupAssignments();
        }
        int[] groupAssignments = new int[this.exptNames.size()];
        block0: for (int i = 0; i < this.exptNames.size(); ++i) {
            if (this.mPanel.sampleSelectionPanel.notInTimeGroupRadioButtons[i].isSelected()) {
                groupAssignments[i] = 0;
                continue;
            }
            for (int j = 0; j < this.mPanel.sampleSelectionPanel.assignmentRBs.length; ++j) {
                if (!this.mPanel.sampleSelectionPanel.assignmentRBs[j][i].isSelected()) continue;
                groupAssignments[i] = j + 1;
                continue block0;
            }
        }
        return groupAssignments;
    }

    private int[] getTimeCourseGroupAssignments() {
        if (this.getSelectionDesign() == 15) {
            return this.getClusterSelectorTimeCourseAssignments();
        }
        int[] timeCourseGroupAssignments = new int[this.exptNames.size()];
        for (int i = 0; i < this.exptNames.size(); ++i) {
            int j;
            if (this.mPanel.ConditionESP.notInTimeGroupRadioButtons[i].isSelected() || this.mPanel.TimePointESP.notInTimeGroupRadioButtons[i].isSelected()) {
                timeCourseGroupAssignments[i] = 0;
                continue;
            }
            int a = 0;
            int b = 0;
            for (j = 0; j < this.mPanel.ConditionESP.assignmentRBs.length; ++j) {
                if (!this.mPanel.ConditionESP.assignmentRBs[j][i].isSelected()) continue;
                a = j;
                break;
            }
            for (j = 0; j < this.mPanel.TimePointESP.assignmentRBs.length; ++j) {
                if (!this.mPanel.TimePointESP.assignmentRBs[j][i].isSelected()) continue;
                b = j;
                break;
            }
            timeCourseGroupAssignments[i] = a * this.getNumGroups() + b + 1;
        }
        return timeCourseGroupAssignments;
    }

    private int[] getClusterSelectorTimeCourseAssignments() {
        boolean doubleAssigned;
        int j;
        int i;
        int[][] groupAssignments = new int[2][this.exptNames.size()];
        ArrayList[] arraylistArray = new ArrayList[this.mPanel.numGroups];
        for (i = 0; i < this.mPanel.numGroups; ++i) {
            j = i + 1;
            arraylistArray[i] = this.mPanel.timepointCS.getGroupSamples("Time-Point " + j);
        }
        for (i = 0; i < this.exptNames.size(); ++i) {
            doubleAssigned = false;
            groupAssignments[0][i] = 0;
            for (j = 0; j < this.mPanel.numGroups; ++j) {
                if (!arraylistArray[j].contains(i)) continue;
                if (doubleAssigned) {
                    Object[] optionst = new Object[]{"OK"};
                    JOptionPane.showOptionDialog(null, "The clusters you have chosen have overlapping samples. \n Each group must contain unique samples.", "Multiple Ownership Error", 1, 3, null, optionst, optionst[0]);
                    return null;
                }
                groupAssignments[0][i] = j + 1;
                doubleAssigned = true;
            }
        }
        arraylistArray = new ArrayList[2];
        for (i = 0; i < 2; ++i) {
            j = i + 1;
            arraylistArray[i] = this.mPanel.conditionCS.getGroupSamples("Condition " + j);
        }
        for (i = 0; i < this.exptNames.size(); ++i) {
            doubleAssigned = false;
            groupAssignments[1][i] = 0;
            for (j = 0; j < 2; ++j) {
                if (!arraylistArray[j].contains(i)) continue;
                if (doubleAssigned) {
                    Object[] optionst = new Object[]{"OK"};
                    JOptionPane.showOptionDialog(null, "The clusters you have chosen have overlapping samples. \n Each group must contain unique samples.", "Multiple Ownership Error", 1, 3, null, optionst, optionst[0]);
                    return null;
                }
                groupAssignments[1][i] = j + 1;
                doubleAssigned = true;
            }
        }
        int[] groupAssignments2 = new int[this.exptNames.size()];
        for (int i2 = 0; i2 < groupAssignments2.length; ++i2) {
            groupAssignments2[i2] = groupAssignments[0][i2] == 0 || groupAssignments[1][i2] == 0 ? 0 : (groupAssignments[1][i2] - 1) * this.mPanel.numGroups + (groupAssignments[0][i2] - 1) + 1;
        }
        return groupAssignments2;
    }

    private int[] getFactorGroupAssignments() {
        if (this.getSelectionDesign() == 15) {
            return this.getClusterSelectorFactorAssignments();
        }
        int[] factorGroupAssignments = new int[this.exptNames.size()];
        for (int i = 0; i < this.exptNames.size(); ++i) {
            int j;
            if (this.mPanel.FactorAESP.notInTimeGroupRadioButtons[i].isSelected() || this.mPanel.FactorBESP.notInTimeGroupRadioButtons[i].isSelected()) {
                factorGroupAssignments[i] = 0;
                continue;
            }
            int a = 0;
            int b = 0;
            for (j = 0; j < this.mPanel.FactorAESP.assignmentRBs.length; ++j) {
                if (!this.mPanel.FactorAESP.assignmentRBs[j][i].isSelected()) continue;
                a = j;
                break;
            }
            for (j = 0; j < this.mPanel.FactorBESP.assignmentRBs.length; ++j) {
                if (!this.mPanel.FactorBESP.assignmentRBs[j][i].isSelected()) continue;
                b = j;
                break;
            }
            factorGroupAssignments[i] = a * this.getNumFactorBGroups() + b + 1;
        }
        return factorGroupAssignments;
    }

    private int[] getClusterSelectorFactorAssignments() {
        boolean doubleAssigned;
        int j;
        int i;
        int[][] groupAssignments = new int[2][this.exptNames.size()];
        ArrayList[] arraylistArray = new ArrayList[this.getNumFactorBGroups()];
        for (i = 0; i < this.getNumFactorBGroups(); ++i) {
            j = i + 1;
            arraylistArray[i] = this.mPanel.factorACS.getGroupSamples("Level " + j);
        }
        for (i = 0; i < this.exptNames.size(); ++i) {
            doubleAssigned = false;
            groupAssignments[0][i] = 0;
            for (j = 0; j < this.getNumFactorBGroups(); ++j) {
                if (!arraylistArray[j].contains(i)) continue;
                if (doubleAssigned) {
                    Object[] optionst = new Object[]{"OK"};
                    JOptionPane.showOptionDialog(null, "The clusters you have chosen have overlapping samples. \n Each group must contain unique samples.", "Multiple Ownership Error", 1, 3, null, optionst, optionst[0]);
                    return null;
                }
                groupAssignments[0][i] = j + 1;
                doubleAssigned = true;
            }
        }
        arraylistArray = new ArrayList[2];
        for (i = 0; i < 2; ++i) {
            j = i + 1;
            arraylistArray[i] = this.mPanel.factorBCS.getGroupSamples("Level " + j);
        }
        for (i = 0; i < this.exptNames.size(); ++i) {
            doubleAssigned = false;
            groupAssignments[1][i] = 0;
            for (j = 0; j < 2; ++j) {
                if (!arraylistArray[j].contains(i)) continue;
                if (doubleAssigned) {
                    Object[] optionst = new Object[]{"OK"};
                    JOptionPane.showOptionDialog(null, "The clusters you have chosen have overlapping samples. \n Each group must contain unique samples.", "Multiple Ownership Error", 1, 3, null, optionst, optionst[0]);
                    return null;
                }
                groupAssignments[1][i] = j + 1;
                doubleAssigned = true;
            }
        }
        int[] groupAssignments2 = new int[this.exptNames.size()];
        for (int i2 = 0; i2 < groupAssignments2.length; ++i2) {
            groupAssignments2[i2] = groupAssignments[0][i2] == 0 || groupAssignments[1][i2] == 0 ? 0 : (groupAssignments[0][i2] - 1) * this.getNumFactorBGroups() + (groupAssignments[1][i2] - 1) + 1;
        }
        return groupAssignments2;
    }

    public int[][] getGroupMatrix() {
        int[] timeAssignments = this.getGroupAssignments();
        int[] numEachTime = new int[this.getNumGroups()];
        for (int i = 0; i < timeAssignments.length; ++i) {
            if (timeAssignments[i] == 0) continue;
            int n = timeAssignments[i] - 1;
            numEachTime[n] = numEachTime[n] + 1;
        }
        int[][] timeMatrix = new int[this.getNumGroups()][];
        for (int i = 0; i < this.getNumGroups(); ++i) {
            timeMatrix[i] = new int[numEachTime[i]];
        }
        int[] nextEntry = new int[this.getNumGroups()];
        for (int i = 0; i < timeAssignments.length; ++i) {
            if (timeAssignments[i] == 0) continue;
            timeMatrix[timeAssignments[i] - 1][nextEntry[timeAssignments[i] - 1]] = i;
            int n = timeAssignments[i] - 1;
            nextEntry[n] = nextEntry[n] + 1;
        }
        return timeMatrix;
    }

    public int getExperimentalDesign() {
        int design = -1;
        if (this.mPanel.ngPanel.oneClass.isSelected()) {
            design = 1;
        }
        if (this.mPanel.ngPanel.twoClass.isSelected()) {
            design = 2;
        }
        if (this.mPanel.ngPanel.multiClass.isSelected()) {
            design = 3;
        }
        if (this.mPanel.ngPanel.factorialDesign.isSelected()) {
            design = 4;
        }
        if (this.mPanel.ngPanel.timeCourse.isSelected()) {
            design = 5;
        }
        return design;
    }

    public int getSelectionDesign() {
        int design = -1;
        design = this.mPanel.tabbedmulg.getSelectedIndex() == 0 ? 14 : 15;
        return design;
    }

    public int getNumGroups() {
        if (this.getExperimentalDesign() == 4) {
            return this.getNumFactorAGroups() * this.getNumFactorBGroups();
        }
        return this.mPanel.numGroups;
    }

    public int getNumFactorAGroups() {
        return this.mPanel.factorAlevels;
    }

    public int getNumFactorBGroups() {
        return this.mPanel.factorBlevels;
    }

    public String getFactorAName() {
        return this.mPanel.factorAName;
    }

    public String getFactorBName() {
        return this.mPanel.factorBName;
    }

    public float getAlpha() {
        return Float.parseFloat(this.mPanel.ngPanel.alphaField.getText());
    }

    public static void main(String[] args) {
        JFrame dummyFrame = new JFrame();
        Vector<String> dummyVect = new Vector<String>();
        for (int i = 0; i < 24; ++i) {
            dummyVect.add("Expt " + i);
        }
        LIMMAInitBox oBox = new LIMMAInitBox(dummyFrame, true, dummyVect, null);
        oBox.setVisible(true);
        System.exit(0);
    }

    public class EventListener
    extends WindowAdapter
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ae) {
            String command = ae.getActionCommand();
            if (command.equals("ok-command")) {
                if (!LIMMAInitBox.this.okReady) {
                    return;
                }
                if (LIMMAInitBox.this.getSelectionDesign() == 15 && LIMMAInitBox.this.repository.isEmpty()) {
                    JOptionPane.showMessageDialog(null, "Cluster Repository is Empty.", "Error", 2);
                    return;
                }
                if (!LIMMAInitBox.this.isParamSufficient()) {
                    return;
                }
                LIMMAInitBox.this.okPressed = true;
                LIMMAInitBox.this.dispose();
            } else if (command.equals("reset-command")) {
                LIMMAInitBox.this.mPanel.reset();
            } else if (command.equals("cancel-command")) {
                LIMMAInitBox.this.okPressed = false;
                LIMMAInitBox.this.dispose();
            } else if (command.equals("info-command")) {
                HelpWindow.launchBrowser(LIMMAInitBox.this, "Linear Models for Microarray Data- Initialization Dialog");
            }
        }
    }

    public class RadioButtonListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ae) {
            if (LIMMAInitBox.this.getExperimentalDesign() == 3) {
                LIMMAInitBox.this.mPanel.ngPanel.numGroupsLabel.setText("Number of Groups: ");
                LIMMAInitBox.this.mPanel.ngPanel.numGroupsField.setVisible(true);
                LIMMAInitBox.this.mPanel.ngPanel.numGroupsLabel.setVisible(true);
                LIMMAInitBox.this.mPanel.ngPanel.factorPanel.setVisible(false);
            } else if (LIMMAInitBox.this.getExperimentalDesign() == 4) {
                LIMMAInitBox.this.mPanel.ngPanel.numGroupsField.setVisible(false);
                LIMMAInitBox.this.mPanel.ngPanel.numGroupsLabel.setVisible(false);
                LIMMAInitBox.this.mPanel.ngPanel.factorPanel.setVisible(true);
            } else if (LIMMAInitBox.this.getExperimentalDesign() == 5) {
                LIMMAInitBox.this.mPanel.ngPanel.numGroupsLabel.setText("Number of Timepoints: ");
                LIMMAInitBox.this.mPanel.ngPanel.numGroupsField.setVisible(true);
                LIMMAInitBox.this.mPanel.ngPanel.numGroupsLabel.setVisible(true);
                LIMMAInitBox.this.mPanel.ngPanel.factorPanel.setVisible(false);
            } else {
                LIMMAInitBox.this.mPanel.ngPanel.numGroupsField.setVisible(false);
                LIMMAInitBox.this.mPanel.ngPanel.numGroupsLabel.setVisible(false);
                LIMMAInitBox.this.mPanel.ngPanel.factorPanel.setVisible(false);
            }
        }
    }

    class MultiClassPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        DesignPanel ngPanel;
        GridBagConstraints constraints = new GridBagConstraints();
        GridBagLayout gridbag = new GridBagLayout();
        JPanel dummyPanel;
        ExperimentsSelectionPanel sampleSelectionPanel;
        ExperimentsSelectionPanel FactorAESP;
        ExperimentsSelectionPanel FactorBESP;
        ExperimentsSelectionPanel ConditionESP;
        ExperimentsSelectionPanel TimePointESP;
        JTabbedPane tabbedmulg;
        ClusterSelector groupsCS;
        ClusterSelector factorACS;
        ClusterSelector factorBCS;
        ClusterSelector conditionCS;
        ClusterSelector timepointCS;
        JLabel infoLabel;
        JLabel infoLabel2;
        int numGroups = -1;
        int factorAlevels = -1;
        int factorBlevels = -1;
        float alpha;
        String factorAName;
        String factorBName;

        public MultiClassPanel() {
            this.setBackground(Color.white);
            this.setLayout(this.gridbag);
            this.ngPanel = new DesignPanel();
            LIMMAInitBox.this.buildConstraints(this.constraints, 0, 0, 1, 1, 100, 10);
            this.constraints.fill = 1;
            this.gridbag.setConstraints(this.ngPanel, this.constraints);
            LIMMAInitBox.this.step2Button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (LIMMAInitBox.this.step2) {
                        MultiClassPanel.this.goBack();
                        return;
                    }
                    MultiClassPanel.this.initiatePanels();
                }
            });
            JPanel topPanel = new JPanel();
            topPanel.setBackground(Color.white);
            topPanel.setLayout(this.gridbag);
            LIMMAInitBox.this.buildConstraints(this.constraints, 0, 0, 1, 2, 75, 100);
            this.gridbag.setConstraints(this.ngPanel, this.constraints);
            topPanel.add(this.ngPanel);
            LIMMAInitBox.this.hclOpsPanel = new HCLoptionPanel();
            LIMMAInitBox.this.hclOpsPanel.setBorder(null);
            LIMMAInitBox.this.buildConstraints(this.constraints, 1, 0, 1, 1, 25, 100);
            this.gridbag.setConstraints(LIMMAInitBox.this.hclOpsPanel, this.constraints);
            topPanel.add(LIMMAInitBox.this.hclOpsPanel);
            LIMMAInitBox.this.buildConstraints(this.constraints, 1, 1, 1, 1, 0, 10);
            this.gridbag.setConstraints(LIMMAInitBox.this.step2Button, this.constraints);
            topPanel.add(LIMMAInitBox.this.step2Button);
            topPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "LIMMA Parameters", 0, 0, null, Color.black));
            LIMMAInitBox.this.buildConstraints(this.constraints, 0, 0, 1, 1, 100, 10);
            this.gridbag.setConstraints(topPanel, this.constraints);
            this.add(topPanel);
            this.infoLabel = new JLabel("Sample Group Assignment");
            this.infoLabel.setMaximumSize(new Dimension(50, 50));
            Font font = this.infoLabel.getFont();
            this.infoLabel.setFont(font.deriveFont(20.0f));
            LIMMAInitBox.this.buildConstraints(this.constraints, 0, 1, 1, 1, 0, 5, 10, 0);
            this.gridbag.setConstraints(this.infoLabel, this.constraints);
            this.add((Component)this.infoLabel, this.constraints);
            this.infoLabel2 = new JLabel("Please select the type of LIMMA analysis to be run, then click 'Continue'.");
            LIMMAInitBox.this.buildConstraints(this.constraints, 0, 2, 1, 1, 100, 5, 10);
            this.gridbag.setConstraints(this.infoLabel2, this.constraints);
            this.add((Component)this.infoLabel2, this.constraints);
            LIMMAInitBox.this.buildConstraints(this.constraints, 0, 3, 1, 1, 100, 90);
            this.dummyPanel = new JPanel();
            this.dummyPanel.setBackground(Color.white);
            this.gridbag.setConstraints(this.dummyPanel, this.constraints);
            this.add(this.dummyPanel);
        }

        private void goBack() {
            this.infoLabel.setVisible(true);
            this.infoLabel2.setVisible(true);
            this.ngPanel.numGroupsField.setEnabled(true);
            this.ngPanel.alphaField.setEnabled(true);
            this.ngPanel.oneClass.setEnabled(true);
            this.ngPanel.twoClass.setEnabled(true);
            this.ngPanel.multiClass.setEnabled(true);
            this.ngPanel.factorialDesign.setEnabled(true);
            this.ngPanel.timeCourse.setEnabled(true);
            this.ngPanel.factorALevel.setEnabled(true);
            this.ngPanel.factorBLevel.setEnabled(true);
            this.ngPanel.factorAName.setEnabled(true);
            this.ngPanel.factorBName.setEnabled(true);
            LIMMAInitBox.this.step2Button.setText("Continue...");
            LIMMAInitBox.this.step2 = false;
            this.tabbedmulg.setVisible(false);
            LIMMAInitBox.this.buildConstraints(this.constraints, 0, 1, 2, 1, 0, 90);
            this.constraints.fill = 1;
            LIMMAInitBox.this.buildConstraints(this.constraints, 0, 3, 1, 1, 100, 90);
            this.gridbag.setConstraints(this.dummyPanel, this.constraints);
            this.add(this.dummyPanel);
            LIMMAInitBox.this.step2Button.setSelected(false);
        }

        private void initiatePanels() {
            this.ngPanel.okPressed = true;
            LIMMAInitBox.this.okReady = true;
            try {
                this.alpha = Float.parseFloat(this.ngPanel.alphaField.getText());
                this.numGroups = 0;
                if (LIMMAInitBox.this.getExperimentalDesign() == 1) {
                    this.numGroups = 1;
                }
                if (LIMMAInitBox.this.getExperimentalDesign() == 2) {
                    this.numGroups = 2;
                }
                if (LIMMAInitBox.this.getExperimentalDesign() == 3) {
                    this.numGroups = Integer.parseInt(this.ngPanel.numGroupsField.getText());
                }
                if (LIMMAInitBox.this.getExperimentalDesign() == 4) {
                    this.factorAlevels = Integer.parseInt(this.ngPanel.factorALevel.getText());
                    this.factorBlevels = Integer.parseInt(this.ngPanel.factorBLevel.getText());
                    this.factorAName = this.ngPanel.factorAName.getText();
                    this.factorBName = this.ngPanel.factorBName.getText();
                }
                if (LIMMAInitBox.this.getExperimentalDesign() == 5) {
                    this.numGroups = Integer.parseInt(this.ngPanel.numGroupsField.getText());
                }
            }
            catch (NumberFormatException nfe) {
                JOptionPane.showMessageDialog(null, "Error reading parameter input.", "Error", 0);
                return;
            }
            if (this.alpha > 1.0f || this.alpha < 0.0f) {
                JOptionPane.showMessageDialog(null, "Please enter an alpha value between 0 and 1.", "Error", 0);
                return;
            }
            if (this.numGroups < 2 && LIMMAInitBox.this.getExperimentalDesign() != 4 && LIMMAInitBox.this.getExperimentalDesign() != 1) {
                JOptionPane.showMessageDialog(null, "The number of groups must be greater than 1.", "Error", 0);
                return;
            }
            if (LIMMAInitBox.this.getExperimentalDesign() == 4 && (this.factorAName.contains(" ") || this.factorBName.contains(" "))) {
                JOptionPane.showMessageDialog(null, "Factor names may not contain spaces.", "Error", 0);
                return;
            }
            if (LIMMAInitBox.this.getExperimentalDesign() == 4 && (this.factorAlevels < 2 || this.factorBlevels < 2)) {
                JOptionPane.showMessageDialog(null, "The number of groups in each factor must be greater than 1.", "Error", 0);
                return;
            }
            JPanel selectionPanel = new JPanel();
            GridBagLayout gbg = new GridBagLayout();
            selectionPanel.setLayout(gbg);
            GridBagConstraints cnstr = new GridBagConstraints();
            LIMMAInitBox.this.buildConstraints(cnstr, 0, 0, 1, 1, 1, 1);
            cnstr.fill = 1;
            JPanel clusterSelectorPanel = new JPanel();
            clusterSelectorPanel.setLayout(new GridBagLayout());
            JLabel clusterInstructions = new JLabel("Use the drop-down menus to assign clusters of samples to their corresponding groups.");
            GridBagConstraints c = new GridBagConstraints();
            c.gridwidth = 2;
            clusterSelectorPanel.add((Component)clusterInstructions, c);
            if (LIMMAInitBox.this.getExperimentalDesign() == 4) {
                this.FactorAESP = new ExperimentsSelectionPanel(LIMMAInitBox.this.exptNames, this.factorAlevels, this.ngPanel.getExperimentDesign(), this.factorAName, false);
                this.FactorBESP = new ExperimentsSelectionPanel(LIMMAInitBox.this.exptNames, this.factorBlevels, this.ngPanel.getExperimentDesign(), this.factorBName, false);
                selectionPanel.add((Component)this.FactorAESP, cnstr);
                cnstr.gridx = 1;
                selectionPanel.add((Component)this.FactorBESP, cnstr);
                ++cnstr.gridy;
                --cnstr.gridx;
                cnstr.gridwidth = 2;
                cnstr.weighty = 0.0;
                selectionPanel.add((Component)this.createSaveLoadPanel(), cnstr);
                this.factorACS = new ClusterSelector(LIMMAInitBox.this.repository, this.factorAlevels, "Level");
                this.factorBCS = new ClusterSelector(LIMMAInitBox.this.repository, this.factorBlevels, "Level");
                if (LIMMAInitBox.this.repository != null) {
                    this.factorACS.setClusterType(this.factorAName);
                    this.factorBCS.setClusterType(this.factorBName);
                }
                LIMMAInitBox.this.buildConstraints(c, 0, 1, 1, 1, 1, 1);
                c.fill = 1;
                clusterSelectorPanel.add((Component)this.factorACS, c);
                c.gridx = 1;
                clusterSelectorPanel.add((Component)this.factorBCS, c);
            } else if (LIMMAInitBox.this.getExperimentalDesign() == 5) {
                this.ConditionESP = new ExperimentsSelectionPanel(LIMMAInitBox.this.exptNames, 2, this.ngPanel.getExperimentDesign(), "Condition", false);
                this.TimePointESP = new ExperimentsSelectionPanel(LIMMAInitBox.this.exptNames, this.numGroups, this.ngPanel.getExperimentDesign(), "Time", false);
                selectionPanel.add((Component)this.ConditionESP, cnstr);
                cnstr.gridx = 1;
                selectionPanel.add((Component)this.TimePointESP, cnstr);
                ++cnstr.gridy;
                --cnstr.gridx;
                cnstr.gridwidth = 2;
                cnstr.weighty = 0.0;
                selectionPanel.add((Component)this.createSaveLoadPanel(), cnstr);
                this.conditionCS = new ClusterSelector(LIMMAInitBox.this.repository, 2, "Condition");
                this.timepointCS = new ClusterSelector(LIMMAInitBox.this.repository, this.numGroups, "Time-Point");
                if (LIMMAInitBox.this.repository != null) {
                    this.conditionCS.setClusterType("Condition");
                    this.timepointCS.setClusterType("Time-Point");
                }
                LIMMAInitBox.this.buildConstraints(c, 0, 1, 1, 1, 1, 1);
                c.fill = 1;
                clusterSelectorPanel.add((Component)this.conditionCS, c);
                c.gridx = 1;
                clusterSelectorPanel.add((Component)this.timepointCS, c);
            } else {
                this.sampleSelectionPanel = new ExperimentsSelectionPanel(LIMMAInitBox.this.exptNames, this.numGroups, this.ngPanel.getExperimentDesign(), "Group", true);
                selectionPanel.add((Component)this.sampleSelectionPanel, cnstr);
                ++cnstr.gridy;
                cnstr.weighty = 0.0;
                selectionPanel.add((Component)this.createSaveLoadPanel(), cnstr);
                if (LIMMAInitBox.this.getExperimentalDesign() == 5) {
                    this.groupsCS = new ClusterSelector(LIMMAInitBox.this.repository, this.numGroups, "Timepoint");
                    this.groupsCS.setClusterType("Timepoint");
                } else {
                    this.groupsCS = new ClusterSelector(LIMMAInitBox.this.repository, this.numGroups, "Class");
                    this.groupsCS.setClusterType("Class");
                }
                LIMMAInitBox.this.buildConstraints(c, 0, 1, 1, 1, 1, 1);
                c.fill = 1;
                c.gridx = 1;
                clusterSelectorPanel.add((Component)this.groupsCS, c);
            }
            this.remove(this.dummyPanel);
            this.tabbedmulg = new JTabbedPane();
            this.tabbedmulg.add("Button Selection", selectionPanel);
            this.tabbedmulg.add("Cluster Selection", clusterSelectorPanel);
            this.tabbedmulg.setSelectedIndex(1);
            if (LIMMAInitBox.this.repository == null || LIMMAInitBox.this.repository.isEmpty()) {
                this.tabbedmulg.setSelectedIndex(0);
            }
            LIMMAInitBox.this.buildConstraints(this.constraints, 0, 1, 2, 1, 0, 90);
            this.constraints.fill = 1;
            this.gridbag.setConstraints(this.tabbedmulg, this.constraints);
            this.add(this.tabbedmulg);
            this.validate();
            LIMMAInitBox.this.enableOK();
            this.ngPanel.numGroupsField.setEnabled(false);
            this.ngPanel.alphaField.setEnabled(false);
            this.ngPanel.oneClass.setEnabled(false);
            this.ngPanel.twoClass.setEnabled(false);
            this.ngPanel.multiClass.setEnabled(false);
            this.ngPanel.factorialDesign.setEnabled(false);
            this.ngPanel.timeCourse.setEnabled(false);
            this.ngPanel.factorALevel.setEnabled(false);
            this.ngPanel.factorBLevel.setEnabled(false);
            this.ngPanel.factorAName.setEnabled(false);
            this.ngPanel.factorBName.setEnabled(false);
            LIMMAInitBox.this.step2Button.setText("<<< Go Back");
            this.infoLabel.setVisible(false);
            this.infoLabel2.setVisible(false);
            LIMMAInitBox.this.step2 = true;
        }

        private void saveAssignments() {
            JFileChooser fileChooser = new JFileChooser(TMEV.getDataPath());
            if (fileChooser.showSaveDialog(this) == 0) {
                File file = fileChooser.getSelectedFile();
                try {
                    PrintWriter pw = new PrintWriter(new FileWriter(file));
                    Date currDate = new Date(System.currentTimeMillis());
                    String dateString = currDate.toString();
                    String userName = System.getProperty("user.name");
                    pw.println("# Assignment File");
                    pw.println("# User: " + userName + " Save Date: " + dateString);
                    pw.println("#");
                    pw.print("Module:\t");
                    pw.println("LIMMA");
                    pw.print("Design:\t");
                    pw.println(this.ngPanel.getExperimentDesign());
                    int groupMax = this.ngPanel.getExperimentDesign() != 4 ? this.numGroups : Math.max(this.factorAlevels, this.factorBlevels);
                    for (int i = 0; i < groupMax; ++i) {
                        pw.print("Group " + (i + 1) + " Label:\t");
                        pw.println("Group " + (i + 1));
                    }
                    pw.println("#");
                    pw.println("Sample Index\tSample Name\tGroup Assignment");
                    if (this.ngPanel.getExperimentDesign() < 4) {
                        int[] groupAssgn = LIMMAInitBox.this.getGroupAssignments();
                        for (int sample = 0; sample < LIMMAInitBox.this.exptNames.size(); ++sample) {
                            pw.print(String.valueOf(sample + 1) + "\t");
                            pw.print(LIMMAInitBox.this.exptNames.get(sample) + "\t");
                            if (groupAssgn[sample] != 0) {
                                pw.println("Group " + groupAssgn[sample]);
                                continue;
                            }
                            pw.println("Exclude");
                        }
                    } else {
                        for (int sample = 0; sample < LIMMAInitBox.this.exptNames.size(); ++sample) {
                            int j;
                            pw.print(String.valueOf(sample + 1) + "\t");
                            pw.print(LIMMAInitBox.this.exptNames.get(sample) + "\t");
                            int a = 0;
                            int b = 0;
                            if (this.ngPanel.getExperimentDesign() == 4) {
                                for (j = 0; j < LIMMAInitBox.this.mPanel.FactorAESP.assignmentRBs.length; ++j) {
                                    if (!LIMMAInitBox.this.mPanel.FactorAESP.assignmentRBs[j][sample].isSelected()) continue;
                                    a = j + 1;
                                    break;
                                }
                                for (j = 0; j < LIMMAInitBox.this.mPanel.FactorBESP.assignmentRBs.length; ++j) {
                                    if (!LIMMAInitBox.this.mPanel.FactorBESP.assignmentRBs[j][sample].isSelected()) continue;
                                    b = j + 1;
                                    break;
                                }
                            } else {
                                for (j = 0; j < LIMMAInitBox.this.mPanel.ConditionESP.assignmentRBs.length; ++j) {
                                    if (!LIMMAInitBox.this.mPanel.ConditionESP.assignmentRBs[j][sample].isSelected()) continue;
                                    b = j + 1;
                                    break;
                                }
                                for (j = 0; j < LIMMAInitBox.this.mPanel.TimePointESP.assignmentRBs.length; ++j) {
                                    if (!LIMMAInitBox.this.mPanel.TimePointESP.assignmentRBs[j][sample].isSelected()) continue;
                                    a = j + 1;
                                    break;
                                }
                            }
                            pw.println((a == 0 ? "Exclude" : "Group " + a) + "\t" + (b == 0 ? "Exclude" : "Group " + b));
                        }
                    }
                    pw.flush();
                    pw.close();
                }
                catch (FileNotFoundException fnfe) {
                    fnfe.printStackTrace();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }

        private void loadAssignments() {
            JFileChooser fileChooser = new JFileChooser("./data");
            if (fileChooser.showOpenDialog(this) == 0) {
                File file = fileChooser.getSelectedFile();
                try {
                    String line;
                    BufferedReader br = new BufferedReader(new FileReader(file));
                    Vector<String> data = new Vector<String>();
                    while ((line = br.readLine()) != null) {
                        data.add(line.trim());
                    }
                    br.close();
                    Vector<String> groupNames = new Vector<String>();
                    Vector<Integer> sampleIndices = new Vector<Integer>();
                    Vector<String> sampleNames = new Vector<String>();
                    Vector<String> groupAssignments = new Vector<String>();
                    Vector<String> group2Assignments = new Vector<String>();
                    int design = 0;
                    for (int row = 0; row < data.size(); ++row) {
                        line = (String)data.get(row);
                        if (line.startsWith("#") || line.startsWith("SampleIndex")) continue;
                        String[] lineArray = line.split("\t");
                        if (lineArray[0].startsWith("Module:")) {
                            if (lineArray[1].equals("LIMMA")) continue;
                            Object[] optionst = new Object[]{"Continue", "Cancel"};
                            if (JOptionPane.showOptionDialog(null, "The saved file was saved using a different module, " + lineArray[1] + ". \n Would you like MeV to try to load it anyway?", "File type warning", 1, 3, null, optionst, optionst[0]) == 0) continue;
                            return;
                        }
                        if (lineArray[0].startsWith("Group ") && lineArray[0].endsWith("Label:")) {
                            groupNames.add(lineArray[1]);
                            continue;
                        }
                        if (lineArray[0].startsWith("Design")) {
                            try {
                                design = Integer.parseInt(lineArray[1]);
                            }
                            catch (NumberFormatException nfe) {}
                            continue;
                        }
                        try {
                            Integer.parseInt(lineArray[0]);
                        }
                        catch (NumberFormatException nfe) {
                            continue;
                        }
                        sampleIndices.add(new Integer(lineArray[0]));
                        sampleNames.add(lineArray[1]);
                        groupAssignments.add(lineArray[2]);
                        if (design != 4 && design != 5) continue;
                        group2Assignments.add(lineArray[3]);
                    }
                    if (LIMMAInitBox.this.exptNames.size() != sampleNames.size()) {
                        System.out.println(LIMMAInitBox.this.exptNames.size() + "  " + sampleNames.size());
                        System.out.println(LIMMAInitBox.this.exptNames.size() + " s length " + sampleNames.size());
                        JOptionPane.showMessageDialog(this, "<html>Error -- number of samples designated in assignment file (" + String.valueOf(sampleNames.size()) + ")<br>" + "does not match the number of samples loaded in MeV (" + LIMMAInitBox.this.exptNames.size() + ").<br>" + "Assignments are not set.</html>", "File Compatibility Error", 0);
                        return;
                    }
                    Vector<String> currSampleVector = new Vector<String>();
                    for (int i = 0; i < LIMMAInitBox.this.exptNames.size(); ++i) {
                        currSampleVector.add(LIMMAInitBox.this.exptNames.get(i));
                    }
                    int fileSampleIndex = 0;
                    int groupIndex = 0;
                    int condIndex = 0;
                    for (int sample = 0; sample < LIMMAInitBox.this.exptNames.size(); ++sample) {
                        boolean doIndex = false;
                        for (int i = 0; i < LIMMAInitBox.this.exptNames.size(); ++i) {
                            if (i == sample || !LIMMAInitBox.this.exptNames.get(i).equals(LIMMAInitBox.this.exptNames.get(sample))) continue;
                            doIndex = true;
                        }
                        fileSampleIndex = sampleNames.indexOf(LIMMAInitBox.this.exptNames.get(sample));
                        if (fileSampleIndex == -1) {
                            doIndex = true;
                        }
                        if (doIndex) {
                            this.setStateBasedOnIndex(groupAssignments, groupNames, design, group2Assignments);
                            break;
                        }
                        String groupName = (String)groupAssignments.get(fileSampleIndex);
                        groupIndex = groupNames.indexOf(groupName);
                        if (design == 4 || design == 5) {
                            String condName = group2Assignments.get(fileSampleIndex);
                            condIndex = groupNames.indexOf(condName);
                        }
                        try {
                            if (LIMMAInitBox.this.getExperimentalDesign() == 4) {
                                LIMMAInitBox.this.mPanel.FactorBESP.assignmentRBs[condIndex][sample].setSelected(true);
                                LIMMAInitBox.this.mPanel.FactorAESP.assignmentRBs[groupIndex][sample].setSelected(true);
                                continue;
                            }
                            if (LIMMAInitBox.this.getExperimentalDesign() == 5) {
                                LIMMAInitBox.this.mPanel.ConditionESP.assignmentRBs[condIndex][sample].setSelected(true);
                                LIMMAInitBox.this.mPanel.TimePointESP.assignmentRBs[groupIndex][sample].setSelected(true);
                                continue;
                            }
                            LIMMAInitBox.this.mPanel.sampleSelectionPanel.assignmentRBs[groupIndex][sample].setSelected(true);
                            continue;
                        }
                        catch (Exception e) {
                            if (LIMMAInitBox.this.getExperimentalDesign() == 4) {
                                LIMMAInitBox.this.mPanel.FactorAESP.notInTimeGroupRadioButtons[sample].setSelected(true);
                                LIMMAInitBox.this.mPanel.FactorBESP.notInTimeGroupRadioButtons[sample].setSelected(true);
                                continue;
                            }
                            if (LIMMAInitBox.this.getExperimentalDesign() == 5) {
                                LIMMAInitBox.this.mPanel.TimePointESP.notInTimeGroupRadioButtons[sample].setSelected(true);
                                LIMMAInitBox.this.mPanel.ConditionESP.notInTimeGroupRadioButtons[sample].setSelected(true);
                                continue;
                            }
                            LIMMAInitBox.this.mPanel.sampleSelectionPanel.notInTimeGroupRadioButtons[sample].setSelected(true);
                        }
                    }
                    this.repaint();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(this, "<html>The file format cannot be read.</html>", "File Compatibility Error", 0);
                }
            }
        }

        private void setStateBasedOnIndex(Vector<String> groupAssignments, Vector<String> groupNames, int cond, Vector<String> condAssignments) {
            Object[] optionst = new Object[]{"Continue", "Cancel"};
            if (JOptionPane.showOptionDialog(null, "The saved file was saved using a different sample annotation or has duplicate annotation. \n Would you like MeV to try to load it by index order?", "File type warning", 1, 3, null, optionst, optionst[0]) == 1) {
                return;
            }
            int condIndex = 0;
            for (int sample = 0; sample < LIMMAInitBox.this.exptNames.size(); ++sample) {
                if (cond == 2) {
                    String condName = condAssignments.get(sample);
                    condIndex = groupNames.indexOf(condName);
                }
                try {
                    if (LIMMAInitBox.this.getExperimentalDesign() == 4) {
                        LIMMAInitBox.this.mPanel.FactorAESP.assignmentRBs[groupNames.indexOf(groupAssignments.get(sample))][sample].setSelected(true);
                        LIMMAInitBox.this.mPanel.FactorBESP.assignmentRBs[condIndex][sample].setSelected(true);
                        continue;
                    }
                    if (LIMMAInitBox.this.getExperimentalDesign() == 5) {
                        LIMMAInitBox.this.mPanel.TimePointESP.assignmentRBs[groupNames.indexOf(groupAssignments.get(sample))][sample].setSelected(true);
                        LIMMAInitBox.this.mPanel.ConditionESP.assignmentRBs[condIndex][sample].setSelected(true);
                        continue;
                    }
                    LIMMAInitBox.this.mPanel.sampleSelectionPanel.assignmentRBs[groupNames.indexOf(groupAssignments.get(sample))][sample].setSelected(true);
                    continue;
                }
                catch (Exception e) {
                    if (LIMMAInitBox.this.getExperimentalDesign() == 4) {
                        LIMMAInitBox.this.mPanel.FactorAESP.notInTimeGroupRadioButtons[sample].setSelected(true);
                        LIMMAInitBox.this.mPanel.FactorBESP.notInTimeGroupRadioButtons[sample].setSelected(true);
                        continue;
                    }
                    if (LIMMAInitBox.this.getExperimentalDesign() == 5) {
                        LIMMAInitBox.this.mPanel.TimePointESP.notInTimeGroupRadioButtons[sample].setSelected(true);
                        LIMMAInitBox.this.mPanel.ConditionESP.notInTimeGroupRadioButtons[sample].setSelected(true);
                        continue;
                    }
                    LIMMAInitBox.this.mPanel.sampleSelectionPanel.notInTimeGroupRadioButtons[sample].setSelected(true);
                }
            }
        }

        private JPanel createSaveLoadPanel() {
            JPanel panel2 = new JPanel();
            GridBagLayout gridbag3 = new GridBagLayout();
            panel2.setLayout(gridbag3);
            panel2.setBackground(Color.white);
            JButton saveButton = new JButton("  Save settings  ");
            saveButton.setFocusPainted(false);
            saveButton.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
            JButton loadButton = new JButton("  Load settings  ");
            loadButton.setFocusPainted(false);
            loadButton.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
            JButton resetButton = new JButton("  Reset  ");
            resetButton.setFocusPainted(false);
            resetButton.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
            final int finNum = LIMMAInitBox.this.exptNames.size();
            resetButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    for (int i = 0; i < finNum; ++i) {
                        if (LIMMAInitBox.this.getExperimentalDesign() == 4) {
                            LIMMAInitBox.this.mPanel.FactorAESP.notInTimeGroupRadioButtons[i].setSelected(true);
                            LIMMAInitBox.this.mPanel.FactorBESP.notInTimeGroupRadioButtons[i].setSelected(true);
                            continue;
                        }
                        if (LIMMAInitBox.this.getExperimentalDesign() == 5) {
                            LIMMAInitBox.this.mPanel.TimePointESP.notInTimeGroupRadioButtons[i].setSelected(true);
                            LIMMAInitBox.this.mPanel.ConditionESP.notInTimeGroupRadioButtons[i].setSelected(true);
                            continue;
                        }
                        LIMMAInitBox.this.mPanel.sampleSelectionPanel.notInTimeGroupRadioButtons[i].setSelected(true);
                    }
                }
            });
            JFileChooser fc = new JFileChooser();
            fc.setCurrentDirectory(new File("Data"));
            saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MultiClassPanel.this.saveAssignments();
                }
            });
            loadButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MultiClassPanel.this.loadAssignments();
                }
            });
            this.constraints.anchor = 10;
            this.constraints.fill = 0;
            this.constraints.insets = new Insets(5, 5, 5, 5);
            LIMMAInitBox.this.buildConstraints(this.constraints, 0, 0, 1, 1, 33, 100);
            gridbag3.setConstraints(saveButton, this.constraints);
            panel2.add(saveButton);
            LIMMAInitBox.this.buildConstraints(this.constraints, 1, 0, 1, 1, 33, 0);
            gridbag3.setConstraints(loadButton, this.constraints);
            panel2.add(loadButton);
            LIMMAInitBox.this.buildConstraints(this.constraints, 2, 0, 1, 1, 34, 0);
            gridbag3.setConstraints(resetButton, this.constraints);
            panel2.add(resetButton);
            this.constraints.insets = new Insets(0, 0, 0, 0);
            LIMMAInitBox.this.buildConstraints(this.constraints, 0, 2, 1, 1, 0, 5);
            this.constraints.anchor = 10;
            return panel2;
        }

        protected void reset() {
            if (this.ngPanel.okPressed) {
                this.sampleSelectionPanel.reset();
            }
        }

        class ExperimentsSelectionPanel
        extends JPanel {
            int design = 0;
            int numPanels = 0;
            JLabel[] expLabels;
            JRadioButton[][] assignmentRBs;
            JRadioButton[] notInTimeGroupRadioButtons;

            ExperimentsSelectionPanel(Vector<String> exptNames, int numGroups, int design, String title, boolean firstPanel) {
                int i;
                int i2;
                this.design = design;
                this.setBorder(new TitledBorder(new EtchedBorder(), title + " Assignments", 0, 0, new Font("Dialog", 1, 12), Color.black));
                this.setBackground(Color.white);
                this.expLabels = new JLabel[exptNames.size()];
                this.assignmentRBs = new JRadioButton[numGroups][exptNames.size()];
                this.numPanels = exptNames.size() / 512 + 1;
                this.notInTimeGroupRadioButtons = new JRadioButton[exptNames.size()];
                ButtonGroup[] chooseTime = new ButtonGroup[exptNames.size()];
                ButtonGroup[] chooseCondition = new ButtonGroup[exptNames.size()];
                GridBagLayout gridbag = new GridBagLayout();
                GridBagLayout gridbag2 = new GridBagLayout();
                GridBagConstraints constraints = new GridBagConstraints();
                this.setLayout(gridbag2);
                JPanel[] panels = new JPanel[this.numPanels];
                int currPanel = 0;
                for (i2 = 0; i2 < panels.length; ++i2) {
                    panels[i2] = new JPanel(gridbag);
                }
                for (i2 = 0; i2 < exptNames.size(); ++i2) {
                    int j;
                    String s1 = exptNames.get(i2);
                    this.expLabels[i2] = new JLabel(s1);
                    chooseTime[i2] = new ButtonGroup();
                    chooseCondition[i2] = new ButtonGroup();
                    if (design == 1) {
                        this.assignmentRBs[0][i2] = new JRadioButton("Include ", false);
                        chooseTime[i2].add(this.assignmentRBs[0][i2]);
                        this.assignmentRBs[0][i2].setSelected(true);
                    } else if (design == 5) {
                        for (j = 0; j < numGroups; ++j) {
                            this.assignmentRBs[j][i2] = new JRadioButton(title + " " + j + "     ", false);
                            chooseTime[i2].add(this.assignmentRBs[j][i2]);
                        }
                    } else {
                        for (j = 0; j < numGroups; ++j) {
                            this.assignmentRBs[j][i2] = new JRadioButton("Group " + (j + 1) + "     ", false);
                            chooseTime[i2].add(this.assignmentRBs[j][i2]);
                        }
                    }
                    currPanel = i2 / 512;
                    this.notInTimeGroupRadioButtons[i2] = new JRadioButton("Unassigned", true);
                    chooseTime[i2].add(this.notInTimeGroupRadioButtons[i2]);
                    int twoCondRoom = 0;
                    for (int j2 = 0; j2 < numGroups; ++j2) {
                        LIMMAInitBox.this.buildConstraints(constraints, j2 + twoCondRoom, i2 % 512, 1, 1, 100, 100);
                        gridbag.setConstraints(this.assignmentRBs[j2][i2], constraints);
                        panels[currPanel].add(this.assignmentRBs[j2][i2]);
                    }
                    LIMMAInitBox.this.buildConstraints(constraints, numGroups + 1 + twoCondRoom, i2 % 512, 1, 1, 100, 100);
                    gridbag.setConstraints(this.notInTimeGroupRadioButtons[i2], constraints);
                    panels[currPanel].add(this.notInTimeGroupRadioButtons[i2]);
                }
                int maxLabelWidth = 0;
                for (int i3 = 0; i3 < this.expLabels.length; ++i3) {
                    if (!(this.expLabels[i3].getPreferredSize().getWidth() > (double)maxLabelWidth)) continue;
                    maxLabelWidth = (int)Math.ceil(this.expLabels[i3].getPreferredSize().getWidth());
                }
                JPanel bigPanel = new JPanel(new GridBagLayout());
                for (int i4 = 0; i4 < this.numPanels; ++i4) {
                    bigPanel.add((Component)panels[i4], new GridBagConstraints(0, i4, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                }
                JScrollPane scroll = new JScrollPane(bigPanel);
                scroll.setHorizontalScrollBarPolicy(32);
                scroll.setVerticalScrollBarPolicy(22);
                JPanel[] exptNameHeaderPanels = new JPanel[this.numPanels];
                GridBagLayout exptHeaderGridbag = new GridBagLayout();
                for (i = 0; i < exptNameHeaderPanels.length; ++i) {
                    exptNameHeaderPanels[i] = new JPanel();
                    exptNameHeaderPanels[i].setSize(50, panels[i].getPreferredSize().height);
                    exptNameHeaderPanels[i].setPreferredSize(new Dimension(maxLabelWidth + 10, panels[i].getPreferredSize().height));
                    exptNameHeaderPanels[i].setLayout(exptHeaderGridbag);
                }
                for (i = 0; i < this.expLabels.length; ++i) {
                    currPanel = i / 512;
                    LIMMAInitBox.this.buildConstraints(constraints, 0, i % 512, 1, 1, 100, 100);
                    constraints.fill = 1;
                    exptHeaderGridbag.setConstraints(this.expLabels[i], constraints);
                    exptNameHeaderPanels[currPanel].add(this.expLabels[i]);
                }
                JPanel headerPanel = new JPanel(new GridBagLayout());
                for (int i5 = 0; i5 < exptNameHeaderPanels.length; ++i5) {
                    headerPanel.add((Component)exptNameHeaderPanels[i5], new GridBagConstraints(0, i5, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                }
                scroll.setRowHeaderView(headerPanel);
                LIMMAInitBox.this.buildConstraints(constraints, 0, 0, 1, 1, 100, 90, 10, 1);
                gridbag2.setConstraints(scroll, constraints);
                this.add(scroll);
            }

            protected void reset() {
                for (int i = 0; i < LIMMAInitBox.this.exptNames.size(); ++i) {
                    this.notInTimeGroupRadioButtons[i].setSelected(true);
                }
            }
        }

        class DesignPanel
        extends JPanel {
            JTextField factorAName;
            JTextField factorBName;
            JTextField factorALevel;
            JTextField factorBLevel;
            JTextField numGroupsField;
            JTextField alphaField;
            JLabel numGroupsLabel;
            JPanel factorPanel;
            boolean okPressed = false;
            JRadioButton oneClass;
            JRadioButton twoClass;
            JRadioButton multiClass;
            JRadioButton factorialDesign;
            JRadioButton timeCourse;

            public DesignPanel() {
                this.setBackground(Color.white);
                GridBagLayout gridbag = new GridBagLayout();
                GridBagConstraints constraints = new GridBagConstraints();
                this.setLayout(gridbag);
                this.setMinimumSize(new Dimension(300, 100));
                JLabel dataTypeLabel = new JLabel("Experimental Design:   ");
                LIMMAInitBox.this.buildConstraints(constraints, 0, 0, 1, 1, 30, 100, 13);
                gridbag.setConstraints(dataTypeLabel, constraints);
                this.add(dataTypeLabel);
                this.oneClass = new JRadioButton("One Class", true);
                this.twoClass = new JRadioButton("Two Class", false);
                this.multiClass = new JRadioButton("Multi-Class", false);
                this.factorialDesign = new JRadioButton("Two-Factor", false);
                this.timeCourse = new JRadioButton("Time Course", false);
                this.oneClass.setBackground(Color.white);
                this.oneClass.setBorder(null);
                this.twoClass.setBackground(Color.white);
                this.twoClass.setBorder(null);
                this.multiClass.setBackground(Color.white);
                this.multiClass.setBorder(null);
                this.factorialDesign.setBackground(Color.white);
                this.factorialDesign.setBorder(null);
                this.timeCourse.setBackground(Color.white);
                this.timeCourse.setBorder(null);
                ButtonGroup dataType = new ButtonGroup();
                dataType.add(this.oneClass);
                dataType.add(this.twoClass);
                dataType.add(this.multiClass);
                dataType.add(this.factorialDesign);
                dataType.add(this.timeCourse);
                this.oneClass.addActionListener(new RadioButtonListener());
                this.twoClass.addActionListener(new RadioButtonListener());
                this.multiClass.addActionListener(new RadioButtonListener());
                this.factorialDesign.addActionListener(new RadioButtonListener());
                this.timeCourse.addActionListener(new RadioButtonListener());
                LIMMAInitBox.this.buildConstraints(constraints, 1, 0, 1, 1, 30, 100);
                constraints.anchor = 17;
                gridbag.setConstraints(this.oneClass, constraints);
                this.add(this.oneClass);
                LIMMAInitBox.this.buildConstraints(constraints, 1, 1, 1, 1, 30, 100);
                constraints.anchor = 17;
                gridbag.setConstraints(this.twoClass, constraints);
                this.add(this.twoClass);
                LIMMAInitBox.this.buildConstraints(constraints, 1, 2, 1, 1, 30, 100);
                constraints.anchor = 17;
                gridbag.setConstraints(this.multiClass, constraints);
                this.add(this.multiClass);
                LIMMAInitBox.this.buildConstraints(constraints, 1, 3, 1, 1, 30, 100);
                constraints.anchor = 17;
                gridbag.setConstraints(this.factorialDesign, constraints);
                this.add(this.factorialDesign);
                LIMMAInitBox.this.buildConstraints(constraints, 1, 4, 1, 1, 30, 100);
                constraints.anchor = 17;
                gridbag.setConstraints(this.timeCourse, constraints);
                this.add(this.timeCourse);
                this.numGroupsLabel = new JLabel("Number of groups: ");
                this.numGroupsLabel.setVisible(false);
                LIMMAInitBox.this.buildConstraints(constraints, 0, 5, 1, 1, 30, 100);
                constraints.anchor = 13;
                gridbag.setConstraints(this.numGroupsLabel, constraints);
                this.add(this.numGroupsLabel);
                this.numGroupsField = new JTextField("4", 7);
                this.numGroupsField.setVisible(false);
                this.numGroupsField.setMinimumSize(new Dimension(50, 20));
                constraints.anchor = 17;
                LIMMAInitBox.this.buildConstraints(constraints, 1, 5, 1, 1, 30, 0);
                gridbag.setConstraints(this.numGroupsField, constraints);
                this.add(this.numGroupsField);
                this.factorPanel = new JPanel();
                this.factorPanel.setBackground(Color.white);
                GridBagLayout gridbag2 = new GridBagLayout();
                this.factorPanel.setLayout(gridbag2);
                JLabel factorALabel = new JLabel("Factor A Name: ");
                LIMMAInitBox.this.buildConstraints(constraints, 0, 0, 1, 1, 30, 0);
                gridbag2.setConstraints(factorALabel, constraints);
                this.factorPanel.add(factorALabel);
                JLabel factorBLabel = new JLabel("Factor B Name: ");
                LIMMAInitBox.this.buildConstraints(constraints, 0, 1, 1, 1, 30, 0);
                gridbag2.setConstraints(factorBLabel, constraints);
                this.factorPanel.add(factorBLabel);
                this.factorAName = new JTextField("FactorA", 7);
                this.factorAName.setMinimumSize(new Dimension(50, 20));
                LIMMAInitBox.this.buildConstraints(constraints, 1, 0, 1, 1, 30, 0);
                gridbag2.setConstraints(this.factorAName, constraints);
                this.factorPanel.add(this.factorAName);
                this.factorBName = new JTextField("FactorB", 7);
                this.factorBName.setMinimumSize(new Dimension(50, 20));
                LIMMAInitBox.this.buildConstraints(constraints, 1, 1, 1, 1, 30, 0);
                gridbag2.setConstraints(this.factorBName, constraints);
                this.factorPanel.add(this.factorBName);
                JLabel levelALabel = new JLabel("    Number of Levels: ");
                LIMMAInitBox.this.buildConstraints(constraints, 2, 0, 1, 1, 30, 0);
                gridbag2.setConstraints(levelALabel, constraints);
                this.factorPanel.add(levelALabel);
                JLabel levelBLabel = new JLabel("    Number of Levels: ");
                LIMMAInitBox.this.buildConstraints(constraints, 2, 1, 1, 1, 30, 0);
                gridbag2.setConstraints(levelBLabel, constraints);
                this.factorPanel.add(levelBLabel);
                this.factorALevel = new JTextField("2", 7);
                this.factorALevel.setMinimumSize(new Dimension(50, 20));
                LIMMAInitBox.this.buildConstraints(constraints, 3, 0, 1, 1, 30, 0);
                gridbag2.setConstraints(this.factorALevel, constraints);
                this.factorPanel.add(this.factorALevel);
                this.factorBLevel = new JTextField("2", 7);
                this.factorBLevel.setMinimumSize(new Dimension(50, 20));
                LIMMAInitBox.this.buildConstraints(constraints, 3, 1, 1, 1, 30, 0);
                gridbag2.setConstraints(this.factorBLevel, constraints);
                this.factorPanel.add(this.factorBLevel);
                LIMMAInitBox.this.buildConstraints(constraints, 0, 5, 2, 1, 30, 0, 10);
                constraints.ipady = 20;
                gridbag.setConstraints(this.factorPanel, constraints);
                this.factorPanel.setVisible(false);
                this.add(this.factorPanel);
                constraints.ipady = 0;
                JLabel alphaLabel = new JLabel("Significance Level: Alpha = ");
                LIMMAInitBox.this.buildConstraints(constraints, 0, 6, 1, 1, 30, 100);
                constraints.anchor = 13;
                gridbag.setConstraints(alphaLabel, constraints);
                this.add(alphaLabel);
                this.alphaField = new JTextField(".05", 7);
                this.alphaField.setMinimumSize(new Dimension(50, 20));
                constraints.anchor = 17;
                LIMMAInitBox.this.buildConstraints(constraints, 1, 6, 1, 1, 30, 0);
                gridbag.setConstraints(this.alphaField, constraints);
                this.add(this.alphaField);
            }

            public int getExperimentDesign() {
                if (this.oneClass.isSelected()) {
                    return 1;
                }
                if (this.twoClass.isSelected()) {
                    return 2;
                }
                if (this.multiClass.isSelected()) {
                    return 3;
                }
                if (this.factorialDesign.isSelected()) {
                    return 4;
                }
                if (this.timeCourse.isSelected()) {
                    return 5;
                }
                return 0;
            }

            @Override
            public void setVisible(boolean visible) {
                this.setLocation((MultiClassPanel.this.getWidth() - this.getSize().width) / 2, (MultiClassPanel.this.getHeight() - this.getSize().height) / 2);
                super.setVisible(visible);
                if (visible) {
                    // empty if block
                }
            }

            public boolean isOkPressed() {
                return this.okPressed;
            }
        }
    }

    class HCLoptionPanel
    extends JPanel {
        private JCheckBox hclCluster;
        private JRadioButton sigOnly;
        private JRadioButton allClusters;
        GridBagConstraints constraints = new GridBagConstraints();
        GridBagLayout gridbag = new GridBagLayout();

        public HCLoptionPanel() {
            this.setBackground(Color.white);
            Font font = new Font("Dialog", 1, 12);
            this.setLayout(this.gridbag);
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Hierarchical Clustering", 0, 0, font, Color.black));
            this.hclCluster = new JCheckBox("Construct Hierarchical Trees for :            ");
            this.hclCluster.setFocusPainted(false);
            this.hclCluster.setBackground(Color.white);
            this.hclCluster.setForeground(UIManager.getColor("Label.foreground"));
            this.sigOnly = new JRadioButton("Significant genes only", true);
            this.sigOnly.setBackground(Color.white);
            this.sigOnly.setForeground(UIManager.getColor("Label.foreground"));
            this.allClusters = new JRadioButton("All clusters", false);
            this.allClusters.setBackground(Color.white);
            this.allClusters.setForeground(UIManager.getColor("Label.foreground"));
            this.sigOnly.setEnabled(false);
            this.allClusters.setEnabled(false);
            ButtonGroup allOrSig = new ButtonGroup();
            allOrSig.add(this.sigOnly);
            allOrSig.add(this.allClusters);
            this.hclCluster.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 2) {
                        HCLoptionPanel.this.sigOnly.setEnabled(false);
                        HCLoptionPanel.this.allClusters.setEnabled(false);
                    } else {
                        HCLoptionPanel.this.sigOnly.setEnabled(true);
                        HCLoptionPanel.this.allClusters.setEnabled(true);
                    }
                }
            });
            LIMMAInitBox.this.buildConstraints(this.constraints, 0, 0, 1, 1, 25, 10, 17);
            this.gridbag.setConstraints(this.hclCluster, this.constraints);
            this.add(this.hclCluster);
            LIMMAInitBox.this.buildConstraints(this.constraints, 0, 1, 1, 1, 25, 10);
            this.gridbag.setConstraints(this.sigOnly, this.constraints);
            this.add(this.sigOnly);
            LIMMAInitBox.this.buildConstraints(this.constraints, 0, 2, 1, 1, 25, 10);
            this.gridbag.setConstraints(this.allClusters, this.constraints);
            this.add(this.allClusters);
            JPanel dummyPanel = new JPanel();
            LIMMAInitBox.this.buildConstraints(this.constraints, 0, 3, 1, 1, 25, 100);
            this.gridbag.setConstraints(dummyPanel, this.constraints);
            dummyPanel.setBackground(Color.white);
            this.add(dummyPanel);
        }

        public HCLoptionPanel(Color background) {
            this();
            this.setBackground(background);
        }

        public boolean isHCLSelected() {
            return this.hclCluster.isSelected();
        }

        public boolean drawSigTreesOnly() {
            return this.sigOnly.isSelected();
        }

        public void setHCLSelected(boolean value) {
            this.hclCluster.setSelected(value);
        }
    }
}

