/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.limma;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLGUI;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeData;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLViewer;
import org.tigr.microarray.mev.cluster.gui.impl.limma.LIMMACentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.limma.LIMMACentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.limma.LIMMAExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.limma.LIMMAInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.limma.LIMMAInitBox;
import org.tigr.microarray.mev.script.scriptGUI.IScriptGUI;
import org.tigr.util.FloatMatrix;

public class LIMMAGUI
implements IClusterGUI,
IScriptGUI {
    protected Algorithm algorithm;
    protected Progress progress;
    protected Experiment experiment;
    protected int[][] clusters;
    protected int[][] errorGenesArray = new int[1][];
    protected FloatMatrix means;
    protected FloatMatrix variances;
    protected int[][] sigGenesArrays;
    protected String[] auxTitles;
    protected Object[][] auxData;
    protected float[][] geneGroupMeans;
    protected float[][] geneGroupSDs;
    protected boolean drawSigTreesOnly;
    Vector<String> exptNamesVector;
    protected int[] groupAssignments;
    protected double falseProp;
    protected IData data;
    protected int numGroups;
    protected int dataDesign;
    protected int numFactorAGroups;
    protected int numFactorBGroups;
    protected float alpha;
    protected String factorAName;
    protected String factorBName;
    protected boolean errorGenes;
    protected boolean isHierarchicalTree;
    protected int iterations;
    protected ArrayList<String> geneLabels;
    protected ArrayList<String> sampleLabels;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework framework) throws AlgorithmException {
        IDistanceMenu menu;
        int function;
        int i;
        if (this.sysMsg() != 0) {
            return null;
        }
        this.experiment = framework.getData().getExperiment();
        this.data = framework.getData();
        this.exptNamesVector = new Vector();
        int number_of_samples = this.experiment.getNumberOfSamples();
        int[] columnIndices = this.experiment.getColumnIndicesCopy();
        this.sampleLabels = new ArrayList();
        this.geneLabels = new ArrayList();
        for (i = 0; i < number_of_samples; ++i) {
            this.exptNamesVector.add(framework.getData().getFullSampleName(columnIndices[i]));
            this.sampleLabels.add(framework.getData().getFullSampleName(columnIndices[i]));
        }
        for (i = 0; i < this.experiment.getNumberOfGenes(); ++i) {
            this.geneLabels.add(String.valueOf(i));
        }
        LIMMAInitBox LIMMADialog = new LIMMAInitBox((JFrame)framework.getFrame(), true, this.exptNamesVector, framework.getClusterRepository(1));
        LIMMADialog.setVisible(true);
        if (!LIMMADialog.isOkPressed()) {
            return null;
        }
        this.alpha = LIMMADialog.getAlpha();
        this.dataDesign = LIMMADialog.getExperimentalDesign();
        this.numGroups = LIMMADialog.getNumGroups();
        this.numFactorAGroups = LIMMADialog.getNumFactorAGroups();
        this.numFactorBGroups = LIMMADialog.getNumFactorBGroups();
        this.factorAName = LIMMADialog.getFactorAName();
        this.factorBName = LIMMADialog.getFactorBName();
        this.groupAssignments = LIMMADialog.getGroupAssignments();
        if (this.groupAssignments == null) {
            return null;
        }
        this.isHierarchicalTree = LIMMADialog.drawTrees();
        this.drawSigTreesOnly = true;
        if (this.isHierarchicalTree) {
            this.drawSigTreesOnly = LIMMADialog.drawSigTreesOnly();
        }
        if ((function = (menu = framework.getDistanceMenu()).getDistanceFunction()) == 0) {
            function = 1;
        }
        int hcl_method = 0;
        boolean hcl_samples = false;
        boolean hcl_genes = false;
        int hcl_function = 4;
        boolean hcl_absolute = false;
        boolean hcl_samples_ordered = false;
        boolean hcl_genes_ordered = false;
        if (this.isHierarchicalTree) {
            HCLInitDialog hcl_dialog = new HCLInitDialog(framework.getFrame(), menu.getFunctionName(function), menu.isAbsoluteDistance(), true);
            if (hcl_dialog.showModal() != 0) {
                return null;
            }
            hcl_method = hcl_dialog.getMethod();
            hcl_samples = hcl_dialog.isClusterExperiments();
            hcl_genes = hcl_dialog.isClusterGenes();
            hcl_function = hcl_dialog.getDistanceMetric();
            hcl_absolute = hcl_dialog.getAbsoluteSelection();
            hcl_genes_ordered = hcl_dialog.isGeneOrdering();
            hcl_samples_ordered = hcl_dialog.isSampleOrdering();
        }
        Listener listener = new Listener();
        try {
            int i2;
            this.algorithm = framework.getAlgorithmFactory().getAlgorithm("LIMMA");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            this.progress = new Progress(framework.getFrame(), "Running LIMMA Analysis", listener);
            this.progress.setIndeterminate(true);
            this.progress.setIndeterminantString("Finding Significant Genes");
            this.progress.show();
            AlgorithmData data = new AlgorithmData();
            data.addMatrix("experiment", this.experiment.getMatrix());
            data.addIntArray("group_assignments", this.groupAssignments);
            data.addParam("dataDesign", String.valueOf(this.dataDesign));
            data.addParam("numGroups", String.valueOf(this.numGroups));
            data.addParam("alpha", String.valueOf(this.alpha));
            data.addParam("numAGroups", String.valueOf(this.numFactorAGroups));
            data.addParam("numBGroups", String.valueOf(this.numFactorBGroups));
            data.addParam("nameA", String.valueOf(this.factorAName));
            data.addParam("nameB", String.valueOf(this.factorBName));
            if (this.dataDesign == 5) {
                data.addParam("numAGroups", String.valueOf(2));
                data.addParam("numBGroups", String.valueOf(this.numGroups));
                data.addParam("nameA", String.valueOf("Condition"));
                data.addParam("nameB", String.valueOf("Time"));
            }
            data.addStringArray("geneLabels", this.geneLabels.toArray(new String[this.geneLabels.size()]));
            data.addStringArray("sampleLabels", this.sampleLabels.toArray(new String[this.sampleLabels.size()]));
            if (this.isHierarchicalTree) {
                data.addParam("hierarchical-tree", String.valueOf(true));
                data.addParam("draw-sig-trees-only", String.valueOf(this.drawSigTreesOnly));
                data.addParam("method-linkage", String.valueOf(hcl_method));
                data.addParam("calculate-genes", String.valueOf(hcl_genes));
                data.addParam("calculate-experiments", String.valueOf(hcl_samples));
                data.addParam("hcl-distance-function", String.valueOf(hcl_function));
                data.addParam("hcl-distance-absolute", String.valueOf(hcl_absolute));
                data.addParam("hcl-genes-ordered", String.valueOf(hcl_genes_ordered));
                data.addParam("hcl-samples-ordered", String.valueOf(hcl_samples_ordered));
            }
            long start = System.currentTimeMillis();
            AlgorithmData result = this.algorithm.execute(data);
            long time = System.currentTimeMillis() - start;
            Cluster result_cluster = result.getCluster("cluster");
            this.means = result.getMatrix("clusters_means");
            this.variances = result.getMatrix("clusters_variances");
            this.clusters = result.getIntMatrix("sigGenesArrays");
            FloatMatrix geneGroupMeansMatrix = result.getMatrix("geneGroupMeansMatrix");
            FloatMatrix geneGroupSDsMatrix = result.getMatrix("geneGroupSDsMatrix");
            FloatMatrix pValues = result.getMatrix("pValues");
            FloatMatrix adjpValues = result.getMatrix("adjPValues");
            FloatMatrix lfc = result.getMatrix("lfc");
            FloatMatrix logOdds = result.getMatrix("logOdds");
            FloatMatrix tStat = result.getMatrix("tStat");
            FloatMatrix fValues = result.getMatrix("fValues");
            this.iterations = result.getParams().getInt("iterations");
            this.geneGroupMeans = new float[geneGroupMeansMatrix.getRowDimension()][geneGroupMeansMatrix.getColumnDimension()];
            this.geneGroupSDs = new float[geneGroupSDsMatrix.getRowDimension()][geneGroupSDsMatrix.getColumnDimension()];
            for (int i3 = 0; i3 < this.geneGroupMeans.length; ++i3) {
                for (int j = 0; j < this.geneGroupMeans[i3].length; ++j) {
                    this.geneGroupMeans[i3][j] = geneGroupMeansMatrix.A[i3][j];
                    this.geneGroupSDs[i3][j] = geneGroupSDsMatrix.A[i3][j];
                }
            }
            GeneralInfo info = new GeneralInfo();
            info.time = time;
            info.alpha = this.alpha;
            info.function = menu.getFunctionName(function);
            info.hcl = this.isHierarchicalTree;
            info.hcl_genes = hcl_genes;
            info.hcl_samples = hcl_samples;
            info.hcl_method = hcl_method;
            Vector<String> titlesVector = new Vector<String>();
            for (int i4 = 0; i4 < this.geneGroupMeans[0].length; ++i4) {
                titlesVector.add("Group " + (i4 + 1) + " mean");
                titlesVector.add("Group " + (i4 + 1) + " std.dev");
            }
            titlesVector.add("F-values");
            int x = 1;
            int y = 2;
            for (i2 = 0; i2 < this.getTotalInteractions(this.numGroups); ++i2) {
                titlesVector.add("significance-values, " + x + "vs." + y);
                titlesVector.add("adj-p-values, " + x + "vs." + y);
                titlesVector.add("log fold change, " + x + "vs." + y);
                titlesVector.add("t-statistic, " + x + "vs." + y);
                titlesVector.add("log-odds, " + x + "vs." + y);
                if (++y <= this.numGroups) continue;
                y = ++x + 1;
            }
            this.auxTitles = new String[titlesVector.size()];
            for (i2 = 0; i2 < this.auxTitles.length; ++i2) {
                this.auxTitles[i2] = (String)titlesVector.get(i2);
            }
            this.auxData = new Object[this.experiment.getNumberOfGenes()][this.auxTitles.length];
            for (i2 = 0; i2 < this.auxData.length; ++i2) {
                int j;
                int counter = 0;
                for (j = 0; j < this.geneGroupMeans[i2].length; ++j) {
                    this.auxData[i2][counter++] = new Float(this.geneGroupMeans[i2][j]);
                    this.auxData[i2][counter++] = new Float(this.geneGroupSDs[i2][j]);
                }
                this.auxData[i2][counter++] = Float.valueOf(fValues.get(i2, 0));
                for (j = 0; j < this.getTotalInteractions(this.numGroups); ++j) {
                    this.auxData[i2][counter++] = Float.valueOf(pValues.get(i2, j));
                    this.auxData[i2][counter++] = Float.valueOf(adjpValues.get(i2, j));
                    this.auxData[i2][counter++] = Float.valueOf(lfc.get(i2, j));
                    this.auxData[i2][counter++] = Float.valueOf(tStat.get(i2, j));
                    this.auxData[i2][counter++] = Float.valueOf(logOdds.get(i2, j));
                }
            }
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(result_cluster, info);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
        }
    }

    public AlgorithmData getScriptParameters(IFramework framework) {
        IDistanceMenu menu;
        int function;
        this.experiment = framework.getData().getExperiment();
        this.exptNamesVector = new Vector();
        int number_of_samples = this.experiment.getNumberOfSamples();
        for (int i = 0; i < number_of_samples; ++i) {
            this.exptNamesVector.add(framework.getData().getFullSampleName(this.experiment.getSampleIndex(i)));
        }
        LIMMAInitBox LIMMADialog = new LIMMAInitBox((JFrame)framework.getFrame(), true, this.exptNamesVector, framework.getClusterRepository(1));
        LIMMADialog.setVisible(true);
        if (!LIMMADialog.isOkPressed()) {
            return null;
        }
        this.dataDesign = LIMMADialog.getExperimentalDesign();
        this.numGroups = LIMMADialog.getNumGroups();
        this.groupAssignments = LIMMADialog.getGroupAssignments();
        if (this.groupAssignments == null) {
            return null;
        }
        boolean isHierarchicalTree = LIMMADialog.drawTrees();
        this.drawSigTreesOnly = true;
        if (isHierarchicalTree) {
            this.drawSigTreesOnly = LIMMADialog.drawSigTreesOnly();
        }
        if ((function = (menu = framework.getDistanceMenu()).getDistanceFunction()) == 0) {
            function = 4;
        }
        int hcl_method = 0;
        boolean hcl_samples = false;
        boolean hcl_genes = false;
        int hcl_function = 4;
        boolean hcl_absolute = false;
        if (isHierarchicalTree) {
            HCLInitDialog hcl_dialog = new HCLInitDialog(framework.getFrame(), menu.getFunctionName(function), menu.isAbsoluteDistance(), true);
            if (hcl_dialog.showModal() != 0) {
                return null;
            }
            hcl_method = hcl_dialog.getMethod();
            hcl_samples = hcl_dialog.isClusterExperiments();
            hcl_genes = hcl_dialog.isClusterGenes();
            hcl_function = hcl_dialog.getDistanceMetric();
            hcl_absolute = hcl_dialog.getAbsoluteSelection();
        }
        AlgorithmData data = new AlgorithmData();
        data.addParam("distance-factor", String.valueOf(1.0f));
        data.addParam("distance-absolute", String.valueOf(menu.isAbsoluteDistance()));
        data.addParam("distance-function", String.valueOf(function));
        data.addIntArray("group_assignments", this.groupAssignments);
        data.addParam("alpha-value", String.valueOf(LIMMADialog.mPanel.alpha));
        data.addParam("numGroups", String.valueOf(this.numGroups));
        if (isHierarchicalTree) {
            data.addParam("hierarchical-tree", String.valueOf(true));
            data.addParam("draw-sig-trees-only", String.valueOf(this.drawSigTreesOnly));
            data.addParam("method-linkage", String.valueOf(hcl_method));
            data.addParam("calculate-genes", String.valueOf(hcl_genes));
            data.addParam("calculate-experiments", String.valueOf(hcl_samples));
            data.addParam("hcl-distance-function", String.valueOf(hcl_function));
            data.addParam("hcl-distance-absolute", String.valueOf(hcl_absolute));
        }
        data.addParam("name", "LIMMA");
        data.addParam("alg-type", "cluster-genes");
        data.addParam("output-class", "partition-output");
        String[] outputNodes = new String[]{"Significant Genes", "Non-significant Genes"};
        data.addStringArray("output-nodes", outputNodes);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode executeScript(IFramework framework, AlgorithmData algData, Experiment experiment) throws AlgorithmException {
        Listener listener = new Listener();
        this.experiment = experiment;
        this.data = framework.getData();
        this.groupAssignments = algData.getIntArray("group_assignments");
        this.drawSigTreesOnly = algData.getParams().getBoolean("draw-sig-trees-only");
        this.exptNamesVector = new Vector();
        int number_of_samples = experiment.getNumberOfSamples();
        for (int i = 0; i < number_of_samples; ++i) {
            this.exptNamesVector.add(this.data.getFullSampleName(i));
        }
        try {
            int i;
            algData.addMatrix("experiment", experiment.getMatrix());
            this.algorithm = framework.getAlgorithmFactory().getAlgorithm("LIMMA");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            this.progress = new Progress(framework.getFrame(), "Running LIMMA Analysis", listener);
            this.progress.setIndeterminate(true);
            this.progress.setIndeterminantString("Finding Significant Genes");
            this.progress.show();
            long start = System.currentTimeMillis();
            AlgorithmData result = this.algorithm.execute(algData);
            long time = System.currentTimeMillis() - start;
            Cluster result_cluster = result.getCluster("cluster");
            NodeList nodeList = result_cluster.getNodeList();
            int k = 2;
            this.clusters = new int[k][];
            for (int i2 = 0; i2 < k; ++i2) {
                this.clusters[i2] = nodeList.getNode(i2).getFeaturesIndexes();
            }
            this.means = result.getMatrix("clusters_means");
            this.variances = result.getMatrix("clusters_variances");
            AlgorithmParameters params = algData.getParams();
            GeneralInfo info = new GeneralInfo();
            info.time = time;
            info.alpha = params.getFloat("alpha");
            this.numGroups = params.getInt("numGroups");
            info.usePerms = params.getBoolean("usePerms");
            info.numPerms = params.getInt("numPerms");
            info.function = framework.getDistanceMenu().getFunctionName(params.getInt("distance-function"));
            info.hcl = params.getBoolean("hierarchical-tree");
            info.hcl_genes = params.getBoolean("calculate-genes");
            info.hcl_samples = params.getBoolean("calculate-experiments");
            if (info.hcl) {
                info.hcl_method = params.getInt("method-linkage");
            }
            Vector<String> titlesVector = new Vector<String>();
            for (i = 0; i < this.geneGroupMeans[0].length; ++i) {
                titlesVector.add("Group" + (i + 1) + " mean");
                titlesVector.add("Group" + (i + 1) + " std.dev");
            }
            this.auxTitles = new String[titlesVector.size()];
            for (i = 0; i < this.auxTitles.length; ++i) {
                this.auxTitles[i] = (String)titlesVector.get(i);
            }
            this.auxData = new Object[experiment.getNumberOfGenes()][this.auxTitles.length];
            for (i = 0; i < this.auxData.length; ++i) {
                int counter = 0;
                for (int j = 0; j < this.geneGroupMeans[i].length; ++j) {
                    this.auxData[i][counter++] = new Float(this.geneGroupMeans[i][j]);
                    this.auxData[i][counter++] = new Float(this.geneGroupSDs[i][j]);
                }
            }
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(result_cluster, info);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
        }
    }

    private int getTotalInteractions(int groups) {
        if (this.dataDesign == 4 || this.dataDesign == 5) {
            return 3;
        }
        if (groups <= 1) {
            return 0;
        }
        return groups - 1 + this.getTotalInteractions(groups - 1);
    }

    public static void main(String[] args) {
    }

    protected String getNodeTitle(int ind, int x, int y) {
        if (this.dataDesign == 1) {
            if (ind == 0) {
                return "Significant Genes ";
            }
            return "Non-significant Genes ";
        }
        if (this.dataDesign == 3) {
            String str = "";
            str = ind % 2 == 0 ? "Significant Genes " : "Non-Significant Genes ";
            str = ind < this.getTotalInteractions(this.numGroups) * 2 ? str + x + " vs. " + y : str + "(All Groups)";
            return str;
        }
        if (this.dataDesign == 4) {
            int index = ind / 2;
            String str = "";
            String string = str = ind % 2 == 0 ? "Significant Genes " : "Non-Significant Genes ";
            if (index == 0) {
                str = str + this.factorAName + "1, " + this.factorBName + " 1 vs. 2";
            }
            if (index == 1) {
                str = str + this.factorAName + "2, " + this.factorBName + " 1 vs. 2";
            }
            if (index == 2) {
                str = str + "Difference";
            }
            return str;
        }
        if (this.dataDesign == 5) {
            String str = "";
            String string = str = ind % 2 == 0 ? "Significant Genes, " : "Non-Significant Genes, ";
            if (ind < (this.numGroups - 1) * 2) {
                str = str + "cond. = 1, ";
            } else if (ind < (this.numGroups - 1) * 4) {
                str = str + "cond. = 2, ";
            }
            if (ind < (this.numGroups - 1) * 4) {
                str = str + "t = " + (ind / 2 % (this.numGroups - 1) + 1);
            }
            if (ind == (this.numGroups - 1) * 4 || ind == (this.numGroups - 1) * 4 + 1) {
                str = str + "cond. = 1 (All) ";
            }
            if (ind == (this.numGroups - 1) * 4 + 2 || ind == (this.numGroups - 1) * 4 + 3) {
                str = str + "cond. = 2 (All) ";
            }
            if (ind == this.clusters.length - 2 || ind == this.clusters.length - 1) {
                str = str + "(All) ";
            }
            return str;
        }
        if (ind % 2 == 0) {
            return "Significant Genes " + x + " vs. " + y;
        }
        return "Non-significant Genes " + x + " vs. " + y;
    }

    protected DefaultMutableTreeNode createResultTree(Cluster result_cluster, GeneralInfo info) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("LIMMA");
        this.addResultNodes(root, result_cluster, info);
        return root;
    }

    protected void addResultNodes(DefaultMutableTreeNode root, Cluster result_cluster, GeneralInfo info) {
        this.addExpressionImages(root);
        this.addHierarchicalTrees(root, result_cluster, info);
        this.addTableViews(root);
        this.addClusterInfo(root);
        this.addGeneralInfo(root, info);
    }

    protected void addTableViews(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Table Views");
        ClusterTableViewer tabViewer = new ClusterTableViewer(this.experiment, this.clusters, this.data, this.auxTitles, this.auxData);
        int x = 1;
        int y = 2;
        for (int i = 0; i < this.clusters.length; ++i) {
            node.add(new DefaultMutableTreeNode(new LeafInfo(this.getNodeTitle(i, x, y), (IViewer)tabViewer, (Object)new Integer(i))));
            if (i % 2 == 1) {
                ++y;
            }
            if (y <= this.numGroups) continue;
            y = ++x + 1;
        }
        root.add(node);
    }

    protected void addExpressionImages(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Expression Images");
        LIMMAExperimentViewer expViewer = new LIMMAExperimentViewer(this.experiment, this.clusters, (float[][])null, (float[][])null, null, null, null, null, null, null, null);
        int x = 1;
        int y = 2;
        for (int i = 0; i < this.clusters.length; ++i) {
            node.add(new DefaultMutableTreeNode(new LeafInfo(this.getNodeTitle(i, x, y), (IViewer)expViewer, (Object)new Integer(i))));
            if (i % 2 == 1) {
                ++y;
            }
            if (y <= this.numGroups) continue;
            y = ++x + 1;
        }
        root.add(node);
    }

    protected void addHierarchicalTrees(DefaultMutableTreeNode root, Cluster result_cluster, GeneralInfo info) {
        if (!info.hcl) {
            return;
        }
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Hierarchical Trees");
        NodeList nodeList = result_cluster.getNodeList();
        if (!this.drawSigTreesOnly) {
            for (int i = 0; i < nodeList.getSize(); ++i) {
                if (i < nodeList.getSize() - 1) {
                    node.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes ", this.createHCLViewer(nodeList.getNode(i), info))));
                    continue;
                }
                if (i != nodeList.getSize() - 1) continue;
                node.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", this.createHCLViewer(nodeList.getNode(i), info))));
            }
        } else {
            node.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes ", this.createHCLViewer(nodeList.getNode(0), info))));
        }
        root.add(node);
    }

    protected IViewer createHCLViewer(Node clusterNode, GeneralInfo info) {
        HCLTreeData genes_result;
        HCLTreeData hCLTreeData = genes_result = info.hcl_genes ? this.getResult(clusterNode, 0) : null;
        HCLTreeData samples_result = info.hcl_samples ? this.getResult(clusterNode, info.hcl_genes ? 4 : 0) : null;
        return new HCLViewer(this.experiment, clusterNode.getFeaturesIndexes(), genes_result, samples_result);
    }

    protected HCLTreeData getResult(Node clusterNode, int pos) {
        HCLTreeData data = new HCLTreeData();
        NodeValueList valueList = clusterNode.getValues();
        data.child_1_array = (int[])valueList.getNodeValue((int)pos).value;
        data.child_2_array = (int[])valueList.getNodeValue((int)(pos + 1)).value;
        data.node_order = (int[])valueList.getNodeValue((int)(pos + 2)).value;
        data.height = (float[])valueList.getNodeValue((int)(pos + 3)).value;
        return data;
    }

    protected void addClusterInfo(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Cluster Information");
        node.add(new DefaultMutableTreeNode(new LeafInfo("Results (#,%)", (IViewer)new LIMMAInfoViewer(this.clusters, this.experiment.getNumberOfGenes(), this.dataDesign, this.numGroups))));
        root.add(node);
    }

    protected void addCentroidViews(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode centroidNode = new DefaultMutableTreeNode("Centroid Graphs");
        DefaultMutableTreeNode expressionNode = new DefaultMutableTreeNode("Expression Graphs");
        LIMMACentroidViewer centroidViewer = new LIMMACentroidViewer(this.experiment, this.clusters, null, null, null, null, null, null, null, null, null);
        centroidViewer.setMeans(this.means.A);
        centroidViewer.setVariances(this.variances.A);
        for (int i = 0; i < this.clusters.length; ++i) {
            if (i == 0) {
                centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes ", (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 0))));
                expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes ", (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 1))));
                continue;
            }
            if (i != 1) continue;
            centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 0))));
            expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 1))));
        }
        LIMMACentroidsViewer centroidsViewer = new LIMMACentroidsViewer(this.experiment, this.clusters, this.geneGroupMeans, this.geneGroupSDs, null, null, null, null, null, null, null);
        centroidsViewer.setMeans(this.means.A);
        centroidsViewer.setVariances(this.variances.A);
        centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("All Genes", (IViewer)centroidsViewer, (Object)new Integer(0))));
        expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("All Genes", (IViewer)centroidsViewer, (Object)new Integer(1))));
        root.add(centroidNode);
        root.add(expressionNode);
    }

    protected void addGeneralInfo(DefaultMutableTreeNode root, GeneralInfo info) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("General Information");
        if (this.dataDesign != 5) {
            node.add(this.getGroupAssignmentInfo());
        }
        if (this.isHierarchicalTree) {
            node.add(new DefaultMutableTreeNode("HCL: " + info.getMethodName()));
        }
        node.add(new DefaultMutableTreeNode("Time: " + String.valueOf(info.time - 1L) + " ms"));
        node.add(new DefaultMutableTreeNode(info.function));
        root.add(node);
    }

    protected DefaultMutableTreeNode getGroupAssignmentInfo() {
        int i;
        DefaultMutableTreeNode groupAssignmentInfo = new DefaultMutableTreeNode("Group assignments ");
        DefaultMutableTreeNode notInGroups = new DefaultMutableTreeNode("Not in groups");
        DefaultMutableTreeNode[] groups = new DefaultMutableTreeNode[this.numGroups];
        for (i = 0; i < this.numGroups; ++i) {
            groups[i] = new DefaultMutableTreeNode("Group " + (i + 1));
        }
        for (i = 0; i < this.groupAssignments.length; ++i) {
            int currentGroup = this.groupAssignments[i];
            if (currentGroup == 0) {
                notInGroups.add(new DefaultMutableTreeNode(this.exptNamesVector.get(i)));
                continue;
            }
            groups[currentGroup - 1].add(new DefaultMutableTreeNode(this.exptNamesVector.get(i)));
        }
        for (i = 0; i < groups.length; ++i) {
            groupAssignmentInfo.add(groups[i]);
        }
        if (notInGroups.getChildCount() > 0) {
            groupAssignmentInfo.add(notInGroups);
        }
        return groupAssignmentInfo;
    }

    private int sysMsg() {
        String os = System.getProperty("os.name");
        String arch = System.getProperty("os.arch");
        String ver = System.getProperty("os.version");
        String message = "System Config:\n";
        message = message + "OS: " + os + " | Architecture: " + arch + " | Version: " + ver + "\n";
        message = message + "Please note:\n";
        if (arch.toLowerCase().contains("64") && os.toLowerCase().contains("mac")) {
            message = message + "You need to have 32Bit JVM as default for LIMMA\n";
            message = message + "Please contact MeV Support if you need help.\n";
            message = message + "You also need to have R 2.11.x installed for LIMMA\n";
            message = message + "Cancel if either is not installed. Ok to continue.";
            return JOptionPane.showConfirmDialog(null, message, "R Engine Warning", 2, 2);
        }
        if (arch.toLowerCase().contains("64")) {
            message = message + "You need to have 32Bit JVM as default for LIMMA\n";
            message = message + "Please contact MeV Support if you need help.\n";
            message = message + "Cancel if 32 Bit JVM is not installed. Ok to continue.";
            return JOptionPane.showConfirmDialog(null, message, "R Engine Warning", 2, 2);
        }
        if (os.toLowerCase().contains("mac")) {
            message = message + "You need to have R 2.11.x installed for LIMMA\n";
            message = message + "Cancel if R is not installed. Ok to continue.";
            return JOptionPane.showConfirmDialog(null, message, "R Engine Warning", 2, 2);
        }
        return 0;
    }

    protected class GeneralInfo {
        public int clusters;
        public String correctionMethod;
        public float alpha;
        public long time;
        public String function;
        protected boolean hcl;
        protected boolean usePerms;
        protected int hcl_method;
        protected int numPerms;
        protected boolean hcl_genes;
        protected boolean hcl_samples;

        protected GeneralInfo() {
        }

        public String getMethodName() {
            return this.hcl ? HCLGUI.GeneralInfo.getMethodName(this.hcl_method) : "no linkage";
        }
    }

    protected class Listener
    extends DialogListener
    implements AlgorithmListener {
        protected Listener() {
        }

        public void valueChanged(AlgorithmEvent event) {
            switch (event.getId()) {
                case 1: {
                    LIMMAGUI.this.progress.setUnits(event.getIntValue());
                    LIMMAGUI.this.progress.setDescription(event.getDescription());
                    break;
                }
                case 2: {
                    LIMMAGUI.this.progress.setValue(event.getIntValue());
                    LIMMAGUI.this.progress.setDescription(event.getDescription());
                    break;
                }
                case 3: {
                    int value = event.getIntValue();
                    if (value != -1) break;
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("cancel-command")) {
                LIMMAGUI.this.algorithm.abort();
                LIMMAGUI.this.progress.dispose();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            LIMMAGUI.this.algorithm.abort();
            LIMMAGUI.this.progress.dispose();
        }
    }
}

